﻿/*
Copyright (c) 2003-2010, CKSource - Frederico Knabben. All rights reserved.
For licensing, see LICENSE.html or http://ckeditor.com/license
*/

CKEDITOR.editorConfig = function( config )
{
	// Define changes to default configuration here. For example:
	// config.language = 'fr';
	// config.uiColor = '#AADC6E';

    config.skin             = 'v2';

    config.width            = 600;
    config.height           = 300;
    config.resize_maxWidth  = 1200;
    config.resize_maxHeight = 600;
    config.resize_minWidth  = 200;
    config.resize_minHeight = 100;

    config.indentationChars = '  ';

    config.toolbar  =[
        ['Source','NewPage','Templates','Save','Preview','Print'],
        ['Cut','Copy','Paste','PasteText','PasteFromWord','SelectAll','RemoveFormat'],
        ['SpellChecker','Scayt'],
        ['Undo','Redo'],
        '/',
        ['Form','Checkbox','Radio','TextField','Textarea','Select','Button','ImageButton','HiddenField'],
        ['Link','Unlink','Anchor','Table','HorizontalRule','SpecialChar','PageBreak','Image','Flash','Smiley'],
        '/',
        ['Bold','Italic','Underline','Strike','TextColor','BGColor'],
        ['Subscript','Superscript','Blockquote','NumberedList','BulletedList','Outdent','Indent','JustifyLeft','JustifyCenter','JustifyRight','JustifyBlock'],
        ['Find','Replace'],
        '/',
        ['Styles','Format','Font','FontSize'],
        ['ShowBlocks','Maximize','About']];

    config.smiley_path = './images/icon_face/';
    config.smiley_images = [
        '01.gif', '02.gif', '03.gif', '04.gif', '05.gif',
        '06.gif', '07.gif', '08.gif', '09.gif', '10.gif',
        '11.gif', '12.gif', '13.gif', '14.gif', '15.gif',
        '16.gif', '17.gif', '18.gif', '19.gif', '20.gif'];
    config.smiley_descriptions = [
        '[:Smile:]', '[:Unhappy:]', '[:Laugh:]', '[:Attractive:]', '[:Shy:]',
        '[:Cry:]', '[:Angry:]', '[:Surprise:]', '[:Cool:]', '[:Sweat:]',
        '[:Panic:]', '[:Shutup:]', '[:Vomiting:]', '[:Sleep:]', '[:Good:]',
        '[:Bad:]', '[:Warning:]', '[:Question:]', '[:Flower:]', '[:Shit:]'];

    config.font_defaultLabel = 'Tahoma,Arial';
    config.font_names =
        'Arial; Arial Black; Arial Narrow; Book Antiqua; Century Gothic;' +
        'Comic Sans MS; Courier New; Franklin Gothic Medium; Garamond; Georgia;'+
        'Impact; Lucida Console; Lucida Sans Unicode; Microsoft Sans Serif; Palatino Linotype;'+
        'Tahoma; Times New Roman; Trebuchet MS; Verdana';
    config.font_style = {
        element   :'span',
        styles    :{'font-family':'#(family)'},
        overrides :[{ element:'font', attributes:{'face':null}}]};

    config.fontSize_defaultLabel = '12px';
    config.fontSize_sizes = '9px;10px;12px;14px;18px;24px;36px;';
    config.fontSize_style ={
        element   :'span',
        styles    :{'font-size':'#(size)'},
        overrides :[{ element:'font', attributes:{'size':null}}]};
};
