<?php
/*
+-----------------------------------------------------------------------------+
| $Id: bwcookie.class.php 2008-10-16 19:18:10Z Bleakwind $
| System Cookies
| Copyright (c) 2003-2010 Bleakwind (www.weaverdream.com)
| http://www.weaverdream.com/
| Release under the GNU Lesser General Public License Version 3 (LGPLv3):
|   http://www.gnu.org/licenses/lgpl.html
+-----------------------------------------------------------------------------+
// Initialize
$c = new bwcookie("weaverdream_sessid");
$c->set_cookie_params(0,null,null);
$c->set_session_name("weaverdream_sessid");
$c->set_check_cookie(array("wd_id","wd_unm","wd_pwd"), array("sess_id","sess_username","sess_password"));
$c->start();
// Check if login
if (!$c->iflogin()) {
    echo "no";
} else {
    echo "yes";
}
// Login
$c->set_lifetime('600');
$c->set_cookie(array(
    "wd_id"         => "1",
    "wd_unm"        => "username",
    "wd_pwd"        => "password",
));
$c->set_session(array(
    "sess_id"       => "1",
    "sess_username" => "username",
    "sess_password" => "password",
));
// Logout
$c->destroy();
// Debug
$c->debug();
*/

class bwcookie {

    // Cookie Setting
    var $cookie_lifetime    = 0;
    var $cookie_path        = null;
    var $cookie_domain      = null;

    var $session_name       = null;
    var $session_id         = null;

    var $alreadylogin       = false;
    var $cookie_key         = array();
    var $SESSION;

    function bwcookie(&$SESSION)
    {
        $this->SESSION = &$SESSION;
        $this->set_cookie_params();
        return;
    }

    function set_cookie_params($lifetime = null, $path = null, $domain = null)
    {
        if ( (preg_match("/^[0-9]{1,11}$/",$lifetime)) && ((int)$lifetime > 0) ) {
            $this->cookie_lifetime = (int)$lifetime;
        }

        if (!empty($path)) {
            $this->cookie_path = $path;
        } else {
            $this->cookie_path = substr($_SERVER['SCRIPT_NAME'], 0, strrpos($_SERVER['SCRIPT_NAME'], '/')+1);
        }

        if (!empty($domain)) {
            $this->cookie_domain = $domain;
        }

        session_set_cookie_params($this->cookie_lifetime, $this->cookie_path, $this->cookie_domain);

        return;
    }

    function set_session_name($name = null)
    {
        if (preg_match("/^[a-z0-9_]+$/i",$name) ) {
            $this->session_name = $name;
        }
        return $this->session_name;
    }

    function set_session_id($id = null)
    {
        if (preg_match("/^[a-z0-9_]+$/i",$id) ) {
            $this->session_id = $id;
        }
        return $this->session_id;
    }

    function set_check_cookie($cookie,$session)
    {
        $this->cookie_key = array();
        if (!is_array($cookie)) {
            if (!empty($cookie)) {
                $this->cookie_key['cookie'][]  = $cookie;
                $this->cookie_key['session'][] = $session;
            }
        } else {
            reset($cookie);reset($session);
            $count = count($cookie);
            for($i=0;$i<$count;$i++) {
                $this->cookie_key['cookie'][] = $cookie[$i];
                $this->cookie_key['session'][] = $session[$i];
            }
        }
        return;
    }

    function start()
    {
        ob_start();
        session_cache_limiter("private, must-revalidate");

        $this->SESSION->session_name($this->session_name);
        $this->SESSION->session_id($this->session_id, $this->cookie_lifetime, $this->cookie_path, $this->cookie_domain);
        $this->SESSION->session_start();

        if ($this->check_cookie() === true) {
            $this->alreadylogin = true;
        } else {
            $this->session_reset();
        }

        return;
    }

    function check_cookie()
    {
        $count = count($this->cookie_key['cookie']);
        if ($count > 0) {
            for($i=0; $i<$count ;$i++) {
                if ( empty($_COOKIE[$this->cookie_key['cookie'][$i]]) ||
                     ($_COOKIE[$this->cookie_key['cookie'][$i]] != sha1($this->SESSION->_[$this->cookie_key['session'][$i]])) ) {
                    return false;
                }
            }
        } else {
            return false;
        }

        return true;
    }

    function session_reset()
    {
        $count = count($this->cookie_key['cookie']);
        if ($count > 0) {
            for($i=0; $i<$count ;$i++) {
                setcookie($this->cookie_key['cookie'][$i], '', time() - 1, $this->cookie_path, $this->cookie_domain);
            }
        }

        $count = count($this->cookie_key['session']);
        if ($count > 0) {
            for($i=0; $i<$count ;$i++) {
               $this->SESSION->del($this->cookie_key['session'][$i]);
            }
        }

        return;
    }

    function set_lifetime($lifetime)
    {
        $this->cookie_lifetime = $lifetime;
        $this->set_cookie_params($this->cookie_lifetime);

        return;
    }

    function set_path($path)
    {
        $this->cookie_path = $path;
        $this->set_cookie_params($this->cookie_lifetime, $path);

        return;
    }

    function set_domain($domain)
    {
        $this->cookie_domain = $domain;
        $this->set_cookie_params($this->cookie_lifetime, $this->cookie_path, $this->cookie_domain);

        return;
    }

    function set_cookie($varname, $value = null)
    {
        setcookie($this->SESSION->session_name, $this->SESSION->session_id, time() + $this->cookie_lifetime, $this->cookie_path, $this->cookie_domain);
        if (!is_array($varname)) {
            if (!empty($varname)) {
                setcookie($varname, sha1($value), time() + $this->cookie_lifetime, $this->cookie_path, $this->cookie_domain);
            }
        } else {
            reset($varname);
            while(list($k, $v) = each($varname)) {
                if (!empty($k)) {
                    setcookie($k, sha1($v), time() + $this->cookie_lifetime, $this->cookie_path, $this->cookie_domain);
                }
            }
        }

        return;
    }

    function set_session($varname, $value = null)
    {
        $this->SESSION->set($this->SESSION->lifetime_name, $this->cookie_lifetime);
        if (!is_array($varname)) {
            if (!empty($varname)) {
                $this->SESSION->set($varname, $value);
            }
        } else {
            reset($varname);
            while(list($k, $v) = each($varname)) {
                if (!empty($k)) {
                    $this->SESSION->set($k, $v);
                }
            }
        }

        return;
    }

    function iflogin()
    {
        return $this->alreadylogin;
    }

    function destroy()
    {
        $this->session_reset();

        return;
    }

    function debug()
    {
        echo "<fieldset style='width:300;font-family:tahoma;font-size:11px;background-color:#F2F7FB;'><legend>Debug</legend>";

        echo "<br>session_name => ".$this->SESSION->session_name;
        echo "<br><br>".$this->SESSION->session_name." => ".$this->SESSION->session_id;

        echo "<pre style='font-family:tahoma;font-size: 11px;'>session_get_cookie_params => ";
        print_r(session_get_cookie_params());
        echo "</pre>";

        echo "<pre style='font-family:tahoma;font-size: 11px;'>\$_COOKIE => ";
        print_r($_COOKIE);
        echo "</pre>";

        echo "<pre style='font-family:tahoma;font-size: 11px;'>\$SESSION->_ => ";
        print_r($this->SESSION->_);
        echo "</pre>";

        echo "</fieldset>";
    }
}
?>