<?php
/*
+-----------------------------------------------------------------------------+
| $Id: bwpage.class.php 2009-06-02 19:18:45Z Bleakwind $
| Pagination
| Copyright (c) 2003-2010 Bleakwind (www.weaverdream.com)
| http://www.weaverdream.com/
| Release under the GNU Lesser General Public License Version 3 (LGPLv3):
|   http://www.gnu.org/licenses/lgpl.html
+-----------------------------------------------------------------------------+
*/

class bwpage {

    var $record_total       = 0;
    var $record_listnum     = 20;
    var $record_listfirst   = 0;
    var $record_listlast    = null;

    var $page_total         = 0;
    var $page_listnum       = 7;
    var $page_listfirst     = 1;
    var $page_listlast      = null;
    var $page_selectnum     = 100;
    var $page_selecfirst    = 1;
    var $page_seleclast     = null;

    var $page_current       = 1;
    var $url                = null;

    var $page_list          = null;
    var $page_select        = null;
    var $pagination         = array();

    //
    function bwpage()
    {
        $this->page_current = preg_match("/^[1-9][0-9]{0,10}$/",$_GET['pag']) ? (int)$_GET['pag'] : 1;
        $this->set_record_listnum("20");
        $this->set_page_listnum("7");
        $this->set_page_selectnum("100");
        return;
    }

    //
    function set_page_current($number)
    {
        $this->page_current = (int)$number;
        return;
    }

    //
    function set_record_listnum($number)
    {
        $this->record_listnum = (int)$number;
        return;
    }

    //
    function set_page_listnum($number)
    {
        $this->page_listnum = (int)$number;
        return;
    }

    //
    function set_page_selectnum($number)
    {
        $this->page_selectnum = (int)$number;
        return;
    }

    //
    function set_record($record_total)
    {
        $this->record_total     = preg_match("/^[1-9][0-9]{0,10}$/",$record_total) ? (int)$record_total : 1;
        return;
    }

    //
    function parse()
    {
        $this->record_listfirst = $this->record_listnum * ($this->page_current - 1);
        $this->record_listlast  = $this->record_listfirst+$this->record_listnum;
        $this->record_listlast  = ($this->record_listlast > $this->record_total) ? (int)$this->record_total : (int)$this->record_listlast;

        $this->page_total       = preg_match("/^[1-9][0-9]*$/", $this->record_listnum) ? ceil($this->record_total/$this->record_listnum) : "1";
        $this->page_listnum     = $this->page_listnum == 0 ? $this->page_total : $this->page_listnum;

        $this->page_listfirst   = $this->page_current - floor($this->page_listnum/2);
        $this->page_listfirst   = ($this->page_listfirst <= 0) ? 1 : (int)$this->page_listfirst;
        $this->page_listlast    = $this->page_listfirst + $this->page_listnum - 1;
        $this->page_listlast    = ($this->page_listlast > $this->page_total) ? (int)$this->page_total : (int)$this->page_listlast;

        $this->page_selectfirst = $this->page_current - floor($this->page_selectnum/2);
        $this->page_selectfirst = ($this->page_selectfirst <= 0) ? 1 : (int)$this->page_selectfirst;
        $this->page_selectlast  = $this->page_selectfirst + $this->page_selectnum - 1;
        $this->page_selectlast  = ($this->page_selectlast > $this->page_total) ? (int)$this->page_total : (int)$this->page_selectlast;
        return;
    }

    //
    function page($url)
    {
        global $LANGUAGE;
        $this->parse();
        $this->pagination = array();

        if ( $this->page_current > $this->page_total) {
            $back = $_SERVER['HTTP_REFERER'] ? $_SERVER['HTTP_REFERER'] : $url."pag=1";
            $this->pagination['error'] = "<script language='JavaScript'>alert('".$LANGUAGE['s']['_public']['lib_class_bwpage_class']['nopage']."');document.location.href='".$back."';</script>\n";
            $this->pagination['error'] .= $LANGUAGE['s']['_public']['lib_class_bwpage_class']['nopage']."<meta http-equiv='refresh' content='0;URL=".$back."'>\n";
        }

        $this->pagination['record_total']       = $this->record_total;
        $this->pagination['record_listnum']     = $this->record_listnum;
        $this->pagination['record_listfirst']   = $this->record_listfirst;

        $this->pagination['page_total']         = $this->page_total;

        $this->pagination['page_listnum']       = $this->page_listnum;
        $this->pagination['page_listfirst']     = $this->page_listfirst;
        $this->pagination['page_listlast']      = $this->page_listlast;

        $this->pagination['page_selectnum']     = $this->page_selectnum;
        $this->pagination['page_selectfirst']   = $this->page_selectfirst;
        $this->pagination['page_selectlast']    = $this->page_selectlast;

        $this->pagination['page_current']       = $this->page_current;
        $this->url                              = $url;
        $this->pagination['url']                = $this->url;

        // Page list
        if ($this->page_listfirst>1) {
            $this->pagination['page_listbegin']         = 1;
            $this->pagination['page_listbegin_more']    = $this->page_current-floor($this->page_listnum/2);
        }
        if ($this->page_selectfirst>1) {
            $this->pagination['page_selectbegin']       = 1;
            $this->pagination['page_selectbegin_more']  = $this->page_current-floor($this->page_selectnum/2);
        }
        if ($this->page_current>1) {
            $this->pagination['page_previous'] = $this->page_current-1;
        }
        for($i = $this->page_listfirst; $i <= $this->page_listlast; $i++) {
            if ($this->page_current == $i) {
                $this->pagination['page_list'][$i]['page']          = $i;
                $this->pagination['page_list'][$i]['if_current']    = "1";
            } else {
                $this->pagination['page_list'][$i]['page']          = $i;
                $this->pagination['page_list'][$i]['if_current']    = "0";
            }
        }
        // Page select
        for($i = $this->page_selectfirst; $i <= $this->page_selectlast; $i++) {
            if ($this->page_current == $i) {
                $this->pagination['page_select'][$i]['page']        = $i;
                $this->pagination['page_select'][$i]['if_current']  = "1";
            } else {
                $this->pagination['page_select'][$i]['page']        = $i;
                $this->pagination['page_select'][$i]['if_current']  = "0";
            }
        }
        //////
        if ($this->page_total>$this->page_current) {
            $this->pagination['page_next'] = $this->page_current+1;
        }
        if ($this->page_total>$this->page_selectlast) {
            $this->pagination['page_selectend']         = $this->page_total;
            $this->pagination['page_selectend_more']    = $this->page_current+floor($this->page_selectnum/2);
        }
        if ($this->page_total>$this->page_listlast) {
            $this->pagination['page_listend']           = $this->page_total;
            $this->pagination['page_listend_more']      =  $this->page_current+floor($this->page_listnum/2);
        }
        //////
        return $this->pagination;
    }

    // Debug of print var
    function fp($var,$type="")
    {
        $print = !empty($type) ? "var_dump" : "print_r";
        echo "<pre>";
        $print($var);
        echo "</pre>";
    }
}
?>