<?php
/*
+-----------------------------------------------------------------------------+
| $Id: bwruntime.class.php 2009-03-07 14:34:11Z Bleakwind $
| Get program runtime
| Copyright (c) 2003-2010 Bleakwind (www.weaverdream.com)
| http://www.weaverdream.com/
| Release under the GNU Lesser General Public License Version 3 (LGPLv3):
|   http://www.gnu.org/licenses/lgpl.html
+-----------------------------------------------------------------------------+
*/

class bwruntime
{
    var $timestart;
    var $digits;

    function bwruntime($digits = "")
    {
        $this->timestart    = explode (' ', microtime());
        $this->digits       = $digits;
    }

    function totaltime()
    {
        $timefinish         = explode (' ', microtime());
        if(!preg_match("/[0-9]+/", $this->digits)){
            $runtime_float  = $timefinish[0] - $this->timestart[0];
        }else{
            $runtime_float  = round(($timefinish[0] - $this->timestart[0]), $this->digits);
        }
        $runtime = ($timefinish[1] - $this->timestart[1]) + $runtime_float;
        return $runtime;
    }
}

/*
$bwruntime = new bwruntime();

$arr = array("total" => 123,
             "month" => 1234,
             "day"   => 12345,
             "hour"  => 123456,
       );

for($i=0;$i<1000000;$i++){
    reset($arr);
    while (list($key, $value) = each($arr)) {
       //echo "Key: $key; <br />Value: $value<br />\n";
    }
}

for($i=0;$i<1000000;$i++){
    foreach ($arr as $key => $value) {
       //echo "Key: $key; <br />Value: $value<br />\n";
    }
}

echo $bwruntime->totaltime();
*/
?>