<?php
/*
+-----------------------------------------------------------------------------+
| $Id: bwverify.class.php 2008-10-27 15:35:30Z Bleakwind $
| Upload file
| Copyright (c) 2003-2010 Bleakwind (www.weaverdream.com)
| http://www.weaverdream.com/
| Release under the GNU Lesser General Public License Version 3 (LGPLv3):
|   http://www.gnu.org/licenses/lgpl.html
+-----------------------------------------------------------------------------+
// Initialize
session_start();
$bwvc = new bwverify();
$bwvc->create_image();
$bwvc->transfer_code('verifycode');
$bwvc->output();
*/

class bwverify
{
    var $image;
    var $code;

    var $width;
    var $height;
    var $color;
    var $mixcolor;
    var $bgcolor;
    var $bordercolor;
    var $codelist;

    var $x;
    var $y;
    var $x_padding;
    var $y_padding;
    var $x_offset;
    var $y_offset;

    var $font_family;
    var $len;
    var $mix_amount;

    function bwverify()
    {
        $this->width        = 60;
        $this->height       = 18;
        $this->color        = "005295";
        $this->mixcolor     = "005295";
        $this->bgcolor      = "D3EDFC";
        $this->bordercolor  = "005295";
        $this->codelist    = array("3","4","6","7","8","9",
                                   "A", "B", "C", "D", "E", "F", "G", "H", "J", "K", "M", "N",
                                   "P", "R", "T", "U", "V", "W", "X", "Y");

        $this->x_padding    = 3;
        $this->y_padding    = 2;
        $this->x_offset     = 2;
        $this->y_offset     = 1;

        $this->font_family  = "4,5";
        $this->len          = 4;
        $this->mix_amount   = 60;
    }

    function create_image($default="")
    {
        $this->image = imagecreatetruecolor($this->width, $this->height) or die ("Cannot Initialize new GD image stream!");

        $color       = $this->color_hexdec($this->color);
        $mixcolor    = $this->color_hexdec($this->mixcolor);
        $bgcolor     = $this->color_hexdec($this->bgcolor);
        $bordercolor = $this->color_hexdec($this->bordercolor);

        $color       = imagecolorallocate($this->image, $color[0], $color[1], $color[2]);
        $mixcolor    = imagecolorallocate($this->image, $mixcolor[0], $mixcolor[1], $mixcolor[2]);
        $bgcolor     = imagecolorallocate($this->image, $bgcolor[0], $bgcolor[1], $bgcolor[2]);
        $bordercolor = imagecolorallocate($this->image, $bordercolor[0], $bordercolor[1], $bordercolor[2]);

        imagefill($this->image,$this->width-1,$this->height-1,$bgcolor);
        imagerectangle($this->image, 0, 0, $this->width-1,$this->height-1, $bordercolor);

        for($i = 0; $i < $this->mix_amount; $i++){
            imagesetpixel($this->image, mt_rand(1,$this->width-2), mt_rand(1,$this->height-2), $mixcolor);
        }

        $this->str_rand($this->len, $default);

        $per_long = floor(($this->width-($this->x_padding*2))/$this->len);

        if (!is_array($this->font_family)) {
            $font_family = explode(",", $this->font_family);
        }

        for($i=0;$i<$this->len;$i++) {
            $this->x = mt_rand($this->x_padding+($per_long*$i),$this->x_padding+$this->x_offset+($per_long*$i));
            $this->y = mt_rand($this->y_padding,$this->y_padding+$this->y_offset);
            imagestring($this->image, $font_family[array_rand($font_family,1)], $this->x, $this->y, $this->code{$i}, $color);
        }

        return $this->image;
    }

    function color_hexdec($color)
    {
        if(!preg_match("/^[a-z0-9]{6,6}$/i",$color)) {
            $color = "000000";
        }
        $color_array[0] = hexdec(substr($color,0,2));
        $color_array[1] = hexdec(substr($color,2,2));
        $color_array[2] = hexdec(substr($color,4,2));
        return $color_array;
    }

    function str_rand($len, $default="")
    {
        if (!empty($default)){
            $this->code = $default;
        } else {
            $key = array_rand($this->codelist,$len);
            for($i=0;$i<$len;$i++){
                $this->code .= $this->codelist[$key[$i]];
            }
        }
        return $this->code;
    }

    function transfer_code()
    {
        return $this->code;
    }

    function output()
    {
        header("content-type: image/png");
        header("Cache-control: private, no-cache, no-store, must-revalidate");
        imagepng($this->image);
        imagedestroy($this->image);
    }

}
?>