<?php
/*
+-----------------------------------------------------------------------------+
| $Id: function.smarty.php 2009-10-12 11:21:29Z Bleakwind $
| Global Smarty function
| Copyright (c) 2003-2010 Bleakwind (www.weaverdream.com)
| http://www.weaverdream.com/
| Release under the GNU Lesser General Public License Version 3 (LGPLv3):
|   http://www.gnu.org/licenses/lgpl.html
+-----------------------------------------------------------------------------+
*/

/*
 * Smarty plugin
 * -------------------------------------------------------------
 * File:     modifier.str_count.php
 * Type:     modifier
 * Name:     str_count
 * Purpose:  Count a string
 * -------------------------------------------------------------
 */
function smarty_modifier_str_count($string, $encoding = "UTF-8")
{
    return mb_strwidth($string, $encoding);
}
$t->register_modifier("str_count", "smarty_modifier_str_count");

/*
 * Smarty plugin
 * -------------------------------------------------------------
 * File:     modifier.str_cut.php
 * Type:     modifier
 * Name:     str_cut
 * Purpose:  Return a part of string
 * -------------------------------------------------------------
 */
function smarty_modifier_str_cut($string, $start, $width="", $trimmarker="", $encoding="UTF-8")
{
    $start = (int)$start;
    $width = (int)$width;
    if ($width > 0) {
        return mb_strimwidth($string, $start, $width, $trimmarker, $encoding);
    } else {
        return $string;
    }
}
$t->register_modifier("str_cut", "smarty_modifier_str_cut");

/*
 * Smarty plugin
 * -------------------------------------------------------------
 * File:     modifier.print_format.php
 * Type:     modifier
 * Name:     print_format
 * Purpose:  print_format
 * -------------------------------------------------------------
 */
function smarty_modifier_print_format($string, $var)
{
    $var_list = preg_split("/[\s,-]+/", $var);
    $_output = vsprintf($string, $var_list);
    return $_output;
}
$t->register_modifier("print_format", "smarty_modifier_print_format");

/*
 * Smarty plugin
 * -------------------------------------------------------------
 * File:     modifier.set_type.php
 * Type:     modifier
 * Name:     set_type
 * Purpose:  Set type to something
 * -------------------------------------------------------------
 */
function smarty_modifier_set_type($string, $type)
{
    settype($string, $type);
    return $string;
}
$t->register_modifier("set_type", "smarty_modifier_set_type");

/*
 * Smarty plugin
 * -------------------------------------------------------------
 * File:     modifier.handle_value.php
 * Type:     modifier
 * Name:     handle_value
 * Purpose:  handle_value
 * -------------------------------------------------------------
 */
function smarty_modifier_handle_value($string, $value)
{
    $string = explode("|", $string);
    if (is_array($string) && count($string)>0) {
        foreach($string as $v){
            $this_option = explode(":", $v);
            if ($this_option[0] == $value) {
                $this_value = $this_option;
                break;
            }
        }
    }
    return $this_value;
}
$t->register_modifier("handle_value", "smarty_modifier_handle_value");

/*
 * Smarty plugin
 * -------------------------------------------------------------
 * File:     modifier.strip_tags.php
 * Type:     modifier
 * Name:     strip_tags
 * Purpose:  Strip HTML and PHP tags from a string
 * -------------------------------------------------------------
 */
function smarty_modifier_strip_tags($string, $allow)
{
    if (!empty($allow)) {
        $string = strip_tags($string, $allow);
    } else {
        $string = strip_tags($string);
    }
    return $string;
}
$t->register_modifier("strip_tags", "smarty_modifier_strip_tags");

/*
 * Smarty plugin
 * -------------------------------------------------------------
 * File:     modifier.format_date.php
 * Type:     modifier
 * Name:     format_date
 * Purpose:  Strip HTML and PHP tags from a string
 * -------------------------------------------------------------
 */
function smarty_modifier_format_date($string, $format="%Y-%m-%d")
{
    if (!preg_match("/^[1-9][0-9]{0,10}$/",$string)){
        $return = "";
    } else {
        if (DIRECTORY_SEPARATOR == '\\') {
            $_win_from = array('%D',       '%h', '%n', '%r',          '%R',    '%t', '%T');
            $_win_to   = array('%m/%d/%y', '%b', "\n", '%I:%M:%S %p', '%H:%M', "\t", '%H:%M:%S');
            if (strpos($format, '%e') !== false) {
                $_win_from[] = '%e';
                $_win_to[]   = sprintf('%\' 2d', date('j', $string));
            }
            if (strpos($format, '%l') !== false) {
                $_win_from[] = '%l';
                $_win_to[]   = sprintf('%\' 2d', date('h', $string));
            }
            $format = str_replace($_win_from, $_win_to, $format);
        }
        $return = strftime($format, $string);
    }
    return $return;
}
$t->register_modifier("format_date", "smarty_modifier_format_date");

/*
 * Smarty plugin
 * -------------------------------------------------------------
 * File:     modifier.is_num.php
 * Type:     modifier
 * Name:     is_num
 * Purpose:  If in array
 * -------------------------------------------------------------
 */
function smarty_modifier_is_num($string, $long="10")
{
    $long = $long-1;
    if (preg_match("/^[1-9][0-9]{0,".$long."}$/", $string)) {
        return "1";
    } else {
        return "2";
    }
}
$t->register_modifier("is_num", "smarty_modifier_is_num");

/*
 * Smarty plugin
 * -------------------------------------------------------------
 * File:     modifier.in_array.php
 * Type:     modifier
 * Name:     in_array
 * Purpose:  If in array
 * -------------------------------------------------------------
 */
function smarty_modifier_in_array($str, $array)
{
    if (!is_array($array)) {
        $array = explode(",", $array);
    }
    if (is_array($array)) {
        return in_array($str, $array);
    } else {
        return false;
    }
}
$t->register_modifier("in_array", "smarty_modifier_in_array");

/*
 * Smarty plugin
 * -------------------------------------------------------------
 * File:     modifier.in_array_key.php
 * Type:     modifier
 * Name:     in_array_key
 * Purpose:  If in array
 * -------------------------------------------------------------
 */
function smarty_modifier_in_array_key($str, $array)
{
    if (!is_array($array)) {
        $array = explode(",", $array);
    }
    if (is_array($array)) {
        return array_key_exists($str, $array);
    } else {
        return false;
    }
}
$t->register_modifier("in_array_key", "smarty_modifier_in_array_key");

/*
 * Smarty plugin
 * -------------------------------------------------------------
 * File:     modifier.implode_str.php
 * Type:     modifier
 * Name:     implode_str
 * Purpose:  implode_str string
 * -------------------------------------------------------------
 */
function smarty_modifier_implode_str($str,$glue="")
{
    if (!empty($str)) {
        if (!is_array($str)) {
            $str = preg_split("/[\s,]+/", $str);
        }
        if (is_array($str) && count($str) > 0) {
            $str = implode($glue, $str);
        }
    }
    return $str;
}
$t->register_modifier("implode_str", "smarty_modifier_implode_str");

/*
 * Smarty plugin
 * -------------------------------------------------------------
 * File:     modifier.against_array.php
 * Type:     modifier
 * Name:     against_array
 * Purpose:  against_array string
 * -------------------------------------------------------------
 */
function smarty_modifier_against_array($array)
{
    if (is_array($array) && count($array) > 0) {
        krsort($array);
    }
    return $array;
}
$t->register_modifier("against_array", "smarty_modifier_against_array");

/*
 * Smarty plugin
 * -------------------------------------------------------------
 * File:     modifier.str_enbr.php
 * Type:     modifier
 * Name:     str_enbr
 * Purpose:  str_enbr string
 * -------------------------------------------------------------
 */
function smarty_modifier_str_enbr($str)
{
    $str = func::str_enbr($str);
    return $str;
}
$t->register_modifier("str_enbr", "smarty_modifier_str_enbr");

/*
 * Smarty plugin
 * -------------------------------------------------------------
 * File:     modifier.str_debr.php
 * Type:     modifier
 * Name:     str_debr
 * Purpose:  str_debr string
 * -------------------------------------------------------------
 */
function smarty_modifier_str_debr($str)
{
    $str = func::str_debr($str);
    return $str;
}
$t->register_modifier("str_debr", "smarty_modifier_str_debr");

/*
 * Smarty plugin
 * -------------------------------------------------------------
 * File:     modifier.str_stripbr.php
 * Type:     modifier
 * Name:     str_stripbr
 * Purpose:  str_stripbr string
 * -------------------------------------------------------------
 */
function smarty_modifier_str_stripbr($str)
{
    $str = func::str_stripbr($str);
    return $str;
}
$t->register_modifier("str_stripbr", "smarty_modifier_str_stripbr");

/*
 * Smarty plugin
 * -------------------------------------------------------------
 * File:     modifier.str_enspace.php
 * Type:     modifier
 * Name:     str_enspace
 * Purpose:  str_enspace string
 * -------------------------------------------------------------
 */
function smarty_modifier_str_enspace($str)
{
    $str = func::str_enspace($str);
    return $str;
}
$t->register_modifier("str_enspace", "smarty_modifier_str_enspace");

/*
 * Smarty plugin
 * -------------------------------------------------------------
 * File:     modifier.str_despace.php
 * Type:     modifier
 * Name:     str_despace
 * Purpose:  str_despace string
 * -------------------------------------------------------------
 */
function smarty_modifier_str_despace($str)
{
    $str = func::str_despace($str);
    return $str;
}
$t->register_modifier("str_despace", "smarty_modifier_str_despace");

/*
 * Smarty plugin
 * -------------------------------------------------------------
 * File:     modifier.str_stripspace.php
 * Type:     modifier
 * Name:     str_stripspace
 * Purpose:  str_stripspace string
 * -------------------------------------------------------------
 */
function smarty_modifier_str_stripspace($str)
{
    $str = func::str_stripspace($str);
    return $str;
}
$t->register_modifier("str_stripspace", "smarty_modifier_str_stripspace");

/*
 * Smarty plugin
 * -------------------------------------------------------------
 * File:     modifier.str_entag.php
 * Type:     modifier
 * Name:     str_entag
 * Purpose:  str_entag string
 * -------------------------------------------------------------
 */
function smarty_modifier_str_entag($str, $array="")
{
    $str = func::str_entag($str, $array);
    return $str;
}
$t->register_modifier("str_entag", "smarty_modifier_str_entag");

/*
 * Smarty plugin
 * -------------------------------------------------------------
 * File:     modifier.str_detag.php
 * Type:     modifier
 * Name:     str_detag
 * Purpose:  str_detag string
 * -------------------------------------------------------------
 */
function smarty_modifier_str_detag($str, $array="")
{
    $str = func::str_detag($str, $array);
    return $str;
}
$t->register_modifier("str_detag", "smarty_modifier_str_detag");

/*
 * Smarty plugin
 * -------------------------------------------------------------
 * File:     modifier.parse_bwbbcode.php
 * Type:     modifier
 * Name:     parse_bwbbcode
 * Purpose:  parse_bwbbcode string
 * -------------------------------------------------------------
 */
function smarty_modifier_parse_bwbbcode($str)
{
    global $bwbbcode;
    $str = $bwbbcode->parse_bwbbcode($str);
    return $str;
}
$t->register_modifier("parse_bwbbcode", "smarty_modifier_parse_bwbbcode");

/*
 * Smarty plugin
 * -------------------------------------------------------------
 * File:     function.indent_space.php
 * Type:     function
 * Name:     indent_space
 * Purpose:  indent_space
 * -------------------------------------------------------------
 */
function smarty_function_indent_space($params, &$smarty)
{
    $_output = '';

    foreach ($params as $_key => $_val) {
        switch ($_key) {
            case 'str':
                $str = (string)$_val;
                break;
            case 'limit':
                $limit = (int)$_val;
                break;
            default:
                $smarty->trigger_error("indent_space: unknown attribute '$_key'");
        }
    }
    $str = empty($str) ? "&nbsp;" : $str;
    return str_repeat($str, $limit);
}
$t->register_function("indent_space", "smarty_function_indent_space");

/*
 * Smarty plugin
 * -------------------------------------------------------------
 * File:     block.fill_space.php
 * Type:     block
 * Name:     fill_space
 * Purpose:  fill space
 * -------------------------------------------------------------
 */
function smarty_block_fill_space($params, $content, &$smarty)
{
    global $sys;
    $_output = '';

    foreach ($params as $_key => $_val) {
        switch ($_key) {
            case 'limit':
                $limit = (int)$_val;
                break;
            default:
                $smarty->trigger_error("fill_space: unknown attribute '$_key'");
        }
    }
    return str_repeat($content, $limit);
}
$t->register_block("fill_space", "smarty_block_fill_space");

/*
 * Smarty plugin
 * -------------------------------------------------------------
 * File:     modifier.is_file.php
 * Type:     modifier
 * Name:     is_file
 * Purpose:  is_file
 * -------------------------------------------------------------
 */
function smarty_modifier_is_file($dir, $filename)
{
    if (is_file($dir."/".$filename)) {
        return 1;
    } else {
        return 0;
    }
}
$t->register_modifier("is_file", "smarty_modifier_is_file");

/*
 * Smarty plugin
 * -------------------------------------------------------------
 * File:     modifier.is_dir.php
 * Type:     modifier
 * Name:     is_dir
 * Purpose:  is_dir
 * -------------------------------------------------------------
 */
function smarty_modifier_is_dir($dir)
{
    if (is_dir($dir)) {
        return 1;
    } else {
        return 0;
    }
}
$t->register_modifier("is_dir", "smarty_modifier_is_dir");

/*
 * Smarty plugin
 * -------------------------------------------------------------
 * File:     function.return_db_list.php
 * Type:     function
 * Name:     return_db_list
 * Purpose:  return_db_list
 * -------------------------------------------------------------
 */
function smarty_function_return_db_list($params, &$smarty)
{
    global $sys;
    $_output            = '';

    foreach ($params as $_key => $_val) {
        switch ($_key) {
            case 'item':
                $item = (string)$_val;
                break;
            case 'option':
                $option = $_val;
                break;
            default:
                $smarty->trigger_error("return_db_list: unknown attribute '$_key'");
        }
    }
    if (empty($item)) {
        $smarty->trigger_error("return_db_list: missing 'item' attribute");
    }
    $list = func::return_db_list($option);
    $smarty->assign($item, $list);
    return;
}
$t->register_function("return_db_list", "smarty_function_return_db_list");

/*
 * Smarty plugin
 * -------------------------------------------------------------
 * File:     function.run_function.php
 * Type:     function
 * Name:     run_function
 * Purpose:  run_function
 * -------------------------------------------------------------
 */
function smarty_function_run_function($params, &$smarty)
{
    $_output = '';

    foreach ($params as $_key => $_val) {
        switch ($_key) {
            case 'function':
                $function = (string)$_val;
                break;
            default:
                $smarty->trigger_error("run_function: unknown attribute '$_key'");
        }
    }

    $method = new func();
    if (method_exists($method, $function)) {
        $_output = func::$function();
    }
    return $_output;
}
$t->register_function("run_function", "smarty_function_run_function");

/*
 * Smarty plugin
 * -------------------------------------------------------------
 * File:     function.return_select.php
 * Type:     function
 * Name:     return_select
 * Purpose:  return_select
 * -------------------------------------------------------------
 */
function smarty_function_return_select($params, &$smarty)
{
    global $sys;
    $_output = '';

    foreach ($params as $_key => $_val) {
        switch ($_key) {
            case 'sort':
                $sort = (string)$_val;
                break;
            default:
                $smarty->trigger_error("return_select: unknown attribute '$_key'");
        }
    }
    if (empty($sort)) {
        $smarty->trigger_error("return_select: missing 'sort' attribute");
    }
    $smarty->assign($sys->return_select($sort));
    return;
}
$t->register_function("return_select", "smarty_function_return_select");

/*
 * Smarty plugin
 * -------------------------------------------------------------
 * File:     function.build_page.php
 * Type:     function
 * Name:     build_page
 * Purpose:  return content_list
 * -------------------------------------------------------------
 */
function smarty_function_build_page($params, &$smarty)
{
    global $sys, $bwpage;
    $_output            = '';
    $condition          = array();

    foreach ($params as $_key => $_val) {
        switch ($_key) {
            case 'item':
                $item = (string)$_val;
                break;
            case 'total':
                $total = (int)$_val;
                break;
            case 'listnum':
                $listnum = (int)$_val;
                break;
            case 'current':
                $current = (int)$_val;
                break;
            case 'url':
                $url = (string)$_val;
                break;
            default:
                $smarty->trigger_error("build_page: unknown attribute '$_key'");
        }
    }
    if (!preg_match("/^[a-z0-9_]+$/i", $item)) {
        $smarty->trigger_error("build_page: missing 'item' attribute");
    }

    $total      = preg_match("/^[1-9][0-9]{0,10}$/i", $total) ? $total : "1";
    $listnum    = preg_match("/^[1-9][0-9]{0,10}$/i", $listnum) ? $listnum : "1";
    $current    = preg_match("/^[1-9][0-9]{0,10}$/i", $current) ? $current : "1";

    $bwpage->set_record($total);
    $bwpage->set_record_listnum($listnum);
    $bwpage->set_page_current($current);
    $bwpage->page($url);
    $smarty->assign($item, $bwpage->pagination);

    return;
}
$t->register_function("build_page", "smarty_function_build_page");

/*
 * Smarty plugin
 * -------------------------------------------------------------
 * File:     function.build_image.php
 * Type:     function
 * Name:     build_image
 * Purpose:  build_image
 * -------------------------------------------------------------
 */
function smarty_function_build_image($params, &$smarty)
{
    global $sys, $SETTING;
    $_output = '';

    foreach ($params as $_key => $_val) {
        switch ($_key) {
            case 'item':
                $item = (string)$_val;
                break;
            case 'name':
                $name = (string)$_val;
                break;
            case 'sort':
                $sort = (string)$_val;
                break;
            case 'dir':
                $dir = (string)$_val;
                break;
            case 'image_dir':
                $image_dir = (string)$_val;
                break;
            case 'build_dir':
                $build_dir = (string)$_val;
                break;
            case 'filename':
                $filename = (string)$_val;
                break;
            case 'watermark':
                $watermark = (string)$_val;
                break;
            default:
                $smarty->trigger_error("build_image: unknown attribute '$_key'");
        }
    }
    if (empty($sort) ||
        empty($name) ||
        empty($image_dir) ||
        empty($build_dir)) {
        $build_image_this   = "images/nopicture.png";
    } else {
        $product_image      = $image_dir."/".$dir.$filename;
        if ( is_file($product_image) ) {
            $product_image_mktime   = filemtime($product_image);
            $build_image_this       = $build_dir."/".$dir.$name."_".$filename;
            $product_build_list     = func::db_select(DB_TABLE_PRODUCT_BUILD_CONFIG, "*", "sort='".$sort."' AND name='".$name."'", "", "rank");
            if (count($product_build_list) > 0) {
                foreach ($product_build_list as $product_build_record) {

                    $build_path         = $build_dir."/".$dir;
                    $build_image        = $build_dir."/".$dir.$product_build_record['name']."_".$filename;
                    $build_image_mktime = 0;
                    if (is_file($build_image)){ $build_image_mktime   = filemtime($build_image); }
                    if (!is_file($build_image)
                        || ($build_image_mktime < $product_image_mktime)
                        || ($build_image_mktime < $product_build_record['time']) ) {

                        if (!file_exists($build_path)) { func::make_dir($build_path); }

                        $image_filename     = $product_image;
                        $build_width        = $product_build_record['width'];
                        $build_height       = $product_build_record['height'];
                        $build_filename     = $build_image;
                        $cut_type_align     = $product_build_record['align'];
                        $cut_type_valign    = $product_build_record['valign'];

                        $build_percent = $build_width/$build_height;

                        list($image_width, $image_height, $image_type, $image_attr) = getimagesize($image_filename);
                        $image_percent = $image_width/$image_height;

                        $build_x = 0;
                        $build_y = 0;
                        if ($build_percent < $image_percent) {
                            $build_image_width  = $build_width;
                            $build_image_height = $build_width/$image_percent;
                            $build_x = 0;
                            if ($cut_type_valign == "top"){
                                $build_y = 0;
                            }elseif ($cut_type_valign == "bottom"){
                                $build_y = $build_height - $build_image_height;
                            }else{
                                $build_y = ($build_height - $build_image_height)/2;
                            }
                        } elseif ($build_percent > $image_percent) {
                            $build_image_width  = $build_height*$image_percent;
                            $build_image_height = $build_height;
                            if ($cut_type_valign == "left"){
                                $build_x = 0;
                            }elseif ($cut_type_valign == "right"){
                                $build_x = $build_width - $build_image_width;
                            }else{
                                $build_x = ($build_width - $build_image_width)/2;
                            }
                            $build_y = 0;
                        } else {
                            $build_image_width  = $build_width;
                            $build_image_height = $build_height;
                            $build_x = 0;
                            $build_y = 0;
                        }

                        $bwcurve = new bwcurve($build_width,$build_height);
                        $bwcurve->set_imagetype("gif");
                        $bwcurve->set_bgcolor("FFFFFF");
                        $bwcurve->set_copyimage($image_filename,$build_image_width,$build_x,$build_y);
                        if (!empty($watermark)) {
                            $watermark_image = $watermark;
                            list($watermark_image_width, $watermark_image_height, $watermark_image_type, $watermark_image_attr) = getimagesize($watermark_image);
                            $watermark_x = $build_width/3;
                            $watermark_y = $build_height/3*2;
                            $bwcurve->set_copyimage($watermark_image,$watermark_image_width,$watermark_x,$watermark_y);
                        }
                        $bwcurve->parse();
                        $bwcurve->output($build_filename);
                    }
                }
            }
        } else {
            $product_image          = "images/nopicture.png";
            $product_image_mktime   = filemtime($product_image);
            $build_path_this        = $build_dir;
            $build_image_this       = $build_dir."/".$name."_nopicture.gif";
            $build_image_this_mktime= 0;
            if (is_file($build_image_this)){ $build_image_this_mktime   = filemtime($build_image_this); }
            if (!is_file($build_image_this) || ($build_image_this_mktime < $product_image_mktime) ) {

                if (!file_exists($build_path_this)) { func::make_dir($build_path_this); }

                $image_filename     = $product_image;

                $product_build_list = func::db_select(DB_TABLE_PRODUCT_BUILD_CONFIG, "*", "sort='".$sort."' AND name='".$name."'", "", "rank");

                list($image_width, $image_height, $image_type, $image_attr) = getimagesize($image_filename);
                $image_percent = $image_width/$image_height;

                $build_width        = $product_build_list[0]['width']  != "" ? $product_build_list[0]['width']  : $image_width;
                $build_height       = $product_build_list[0]['height'] != "" ? $product_build_list[0]['height'] : $image_height;
                $build_filename     = $build_image_this;
                $cut_type_align     = $product_build_list[0]['align']  != "" ? $product_build_list[0]['align']  : "center";
                $cut_type_valign    = $product_build_list[0]['valign'] != "" ? $product_build_list[0]['valign'] : "middle";

                $build_percent = $build_width/$build_height;

                list($image_width, $image_height, $image_type, $image_attr) = getimagesize($image_filename);
                $image_percent = $image_width/$image_height;

                $build_x = 0;
                $build_y = 0;
                if ($build_percent < $image_percent) {
                    $build_image_width  = $build_width;
                    $build_image_height = $build_width/$image_percent;
                    $build_x = 0;
                    if ($cut_type_valign == "top"){
                        $build_y = 0;
                    }elseif ($cut_type_valign == "bottom"){
                        $build_y = $build_height - $build_image_height;
                    }else{
                        $build_y = ($build_height - $build_image_height)/2;
                    }
                } elseif ($build_percent > $image_percent) {
                    $build_image_width  = $build_height*$image_percent;
                    $build_image_height = $build_height;
                    if ($cut_type_valign == "left"){
                        $build_x = 0;
                    }elseif ($cut_type_valign == "right"){
                        $build_x = $build_width - $build_image_width;
                    }else{
                        $build_x = ($build_width - $build_image_width)/2;
                    }
                    $build_y = 0;
                } else {
                    $build_image_width  = $build_width;
                    $build_image_height = $build_height;
                    $build_x = 0;
                    $build_y = 0;
                }

                $bwcurve = new bwcurve($build_width,$build_height);
                $bwcurve->set_imagetype("gif");
                $bwcurve->set_bgcolor("FFFFFF");
                $bwcurve->set_copyimage($image_filename,$build_image_width,$build_x,$build_y);
                //$bwcurve->set_copyimage($watermark_source,$watermark_width,$watermark_x,$watermark_y);
                $bwcurve->parse();
                $bwcurve->output($build_filename);
            }
        }
    }
    if (!empty($item)) {
        $smarty->assign($item, $build_image_this);
        return;
    } else {
        return $build_image_this;
    }
}
$t->register_function("build_image", "smarty_function_build_image");

/*
 * Smarty plugin
 * -------------------------------------------------------------
 * File:     function.set_language.php
 * Type:     function
 * Name:     set_language
 * Purpose:  set_language
 * -------------------------------------------------------------
 */
function smarty_function_set_language($params, &$smarty)
{
    global $sys, $SESSION, $LANGLIST, $CONFIG, $CONFIGURE;
    $_output = '';

    foreach ($params as $_key => $_val) {
        switch ($_key) {
            case 'lang':
                $lang = (int)$_val;
                break;
            default:
                $smarty->trigger_error("set_language: unknown attribute '$_key'");
        }
    }
    if ( $lang == "0") {
        $smarty->trigger_error("set_language: missing 'vid' attribute");
    }

    // Language
    if ( !empty($lang) && ($lang != $CONFIG['language']) ){
        // Set the Language
        $CONFIG['language'] = $CONFIG['default_language'];
        if ( preg_match("/^[0-9]{1,11}$/i",$lang) && array_key_exists($lang,$LANGLIST) ) {
            $SESSION->set("language", $lang);
            $SESSION->_['language'] = $lang;
        }
        if ( preg_match("/^[0-9]{1,11}$/i",$SESSION->_['language'])
            && array_key_exists($SESSION->_['language'],$LANGLIST)
            && file_exists('language/'.$LANGLIST[$SESSION->_['language']]['dir'].'/source/_public.php') ) {
            $CONFIG['language'] = $SESSION->_['language'];
        }
        include_once './language/'.$LANGLIST[$CONFIG['language']]['dir'].'/source/_public.php';
        include_once './language/'.$LANGLIST[$CONFIG['language']]['dir'].'/template/_public.php';
        $current_lang_s = './language/'.$LANGLIST[$CONFIG['language']]['dir'].'/source/'.$sys->get['act'].'.php';
        $current_lang_t = './language/'.$LANGLIST[$CONFIG['language']]['dir'].'/template/'.$sys->get['act'].'.php';
        if ( file_exists($current_lang_s) ) { include_once $current_lang_s; }
        if ( file_exists($current_lang_t) ) { include_once $current_lang_t; }
        @header('Content-Type: text/html; charset='.$LANGUAGE['s']['_public']['global']['charset']);

    }
    return;
}
$t->register_function("set_language", "smarty_function_set_language");

/*
 * Smarty plugin
 * -------------------------------------------------------------
 * File:     modifier.fp.php
 * Type:     modifier
 * Name:     fp
 * Purpose:  format print string
 * -------------------------------------------------------------
 */
function smarty_modifier_fp($str)
{
    $_return = "<pre>".print_r($str, true)."</pre>";
    return $_return;
}
$t->register_modifier("fp", "smarty_modifier_fp");
?>