/*
+-----------------------------------------------------------------------------+
| $Id: jquery.bw.bbcode.js 2009-10-01 04:20:57Z Bleakwind $
| Build BBCode
| Copyright (c) 2003-2010 Bleakwind (www.weaverdream.com)
| http://www.weaverdream.com/
| Release under the GNU Lesser General Public License Version 3 (LGPLv3):
|   http://www.gnu.org/licenses/lgpl.html
+-----------------------------------------------------------------------------+
*/

(function($){
    $.fn.extend({
        bwbbcode:function(option){

            var font_default = ["Arial", "Arial Black", "Arial Narrow", "Book Antiqua", "Century Gothic",
                                "Comic Sans MS", "Courier New", "Franklin Gothic Medium", "Garamond", "Georgia",
                                "Impact", "Lucida Console", "Lucida Sans Unicode", "Microsoft Sans Serif", "Palatino Linotype",
                                "Tahoma", "Times New Roman", "Trebuchet MS", "Verdana"];
            var size_default = ["9", "10", "12", "14", "18", "24", "36"];
            var color_default = ["#002060", "#0070c0", "#c00000", "#00b050", "#8064a2", "#ff0000", "#ffc000",
                                 "#000000", "#0f243e", "#632423", "#4f6128", "#3f3151", "#a40035", "#974806",
                                 "#262626", "#17365d", "#953734", "#76923c", "#5f497a", "#ff0000", "#e36c09",
                                 "#595959", "#1f497d", "#c0504d", "#9bbb59", "#8064a2", "#fa4251", "#f79646",
                                 "#7f7f7f", "#548dd4", "#d99694", "#c3d69b", "#b2a2c7", "#ff909b", "#fac08f",
                                 "#bfbfbf", "#8db3e2", "#e5b9b7", "#d7e3bc", "#ccc1d9", "#ffbfc6", "#fbd5b5",
                                 "#ffffff", "#c6d9f0", "#f2dcdb", "#ebf1dd", "#e5e0ec", "#ffdee1", "#fdeada"];

            var bgcolor_default = ["#002060", "#0070c0", "#c00000", "#00b050", "#8064a2", "#ff0000", "#ffc000",
                                 "#000000", "#0f243e", "#632423", "#4f6128", "#3f3151", "#a40035", "#974806",
                                 "#262626", "#17365d", "#953734", "#76923c", "#5f497a", "#ff0000", "#e36c09",
                                 "#595959", "#1f497d", "#c0504d", "#9bbb59", "#8064a2", "#fa4251", "#f79646",
                                 "#7f7f7f", "#548dd4", "#d99694", "#c3d69b", "#b2a2c7", "#ff909b", "#fac08f",
                                 "#bfbfbf", "#8db3e2", "#e5b9b7", "#d7e3bc", "#ccc1d9", "#ffbfc6", "#fbd5b5",
                                 "#ffffff", "#c6d9f0", "#f2dcdb", "#ebf1dd", "#e5e0ec", "#ffdee1", "#fdeada"];

            var font_button;
            var font_selector_ifshow = false;

            var size_button;
            var size_selector_ifshow = false;

            var color_button;
            var color_selector_ifshow = false;

            var bgcolor_button;
            var bgcolor_selector_ifshow = false;

            $('#bwbbcode_bold').click(function()            { selectInsert('[b]', '[/b]'); });
            $('#bwbbcode_italic').click(function()          { selectInsert('[i]', '[/i]'); });
            $('#bwbbcode_underline').click(function()       { selectInsert('[u]', '[/u]'); });
            $('#bwbbcode_line-through').click(function()    { selectInsert('[s]', '[/s]'); });
            $('#bwbbcode_font').change(function()           { selectInsert('[font='+$(this).val()+']', '[/font]'); $(this).attr("value",''); });
            $('#bwbbcode_size').change(function()           { selectInsert('[size='+$(this).val()+']', '[/size]'); $(this).attr("value",''); });
            $('#bwbbcode_color').change(function()          { selectInsert('[color='+$(this).val()+']', '[/color]'); $(this).attr("value",''); });
            $('#bwbbcode_bgcolor').change(function()        { selectInsert('[bgcolor='+$(this).val()+']', '[/bgcolor]'); $(this).attr("value",''); });
            $('#bwbbcode_alignleft').click(function()       { selectInsert('[align=left]', '[/align]'); });
            $('#bwbbcode_aligncenter').click(function()     { selectInsert('[align=center]', '[/align]'); });
            $('#bwbbcode_alignright').click(function()      { selectInsert('[align=right]', '[/align]'); });
            $('#bwbbcode_quote').click(function()           { selectInsert('[quote]', '[/quote]'); });
            $('#bwbbcode_code').click(function()            { selectInsert('[code]', '[/code]'); });

            $('#bwbbcode_url').click(function() {
                //var p1 = prompt("显示链接的文本, 留空将显示链接地址...","");
                var p1 = prompt("显示链接的文本...","");
                if (p1 != null) {
                    var p2 = prompt("链接地址...","http://");
                    if (p2 != '' && p2 != 'http://') {
                        if (p1 != '') {
                            $('#content').insertIn('[url='+p2+']'+p1+'[/url]');
                        } else {
                            $('#content').insertIn('[url]'+p2+'[/url]');
                        }
                    }
                }
            });

            $('#bwbbcode_mail').click(function() {
                //var p1 = prompt("显示链接的文本, 留空将显示E-mail地址...","");
                var p1 = prompt("显示链接的文本...","");
                if (p1 != null) {
                    var p2 = prompt("E-mail地址...","xxx@xxx.com");
                    if (p2 != '') {
                        if (p1 != '') {
                            $('#content').insertIn('[email='+p2+']'+p1+'[/email]');
                        } else {
                            $('#content').insertIn('[email]'+p2+'[/email]');
                        }
                    }
                }
            });

            $('#bwbbcode_image').click(function() {
                var p = prompt('图片地址...', 'http://');
                if (p == null || $.trim(p) == '' || p.toLowerCase() == 'http://') {
                    return;
                }
                $('#content').insertIn('[img]' + p + '[/img]');
            });

            // font
            font_selector = $("<div id='bwbbcode_font_selector' unselectable='on'></div>");
            $.each(font_default, function(i){
                selector_content = $("<div class='bwbbcode_font_palette' unselectable='on'>"+this.toString()+"</div>")
                selector_content.css("font-family", this.toString());
                selector_content.bind("click", function(e){
                    selectInsert('[font='+font_default[i]+']', '[/font]');
                    font_selector_hide();
                });
                selector_content.bind("mouseover", function(e){
                    $(this).removeClass("bwbbcode_font_palette");
                    $(this).addClass("bwbbcode_font_palette_mouseover");
                });
                selector_content.bind("mouseout", function(e){
                    $(this).removeClass("bwbbcode_font_palette_mouseover");
                    $(this).addClass("bwbbcode_font_palette");
                });
                selector_content.appendTo(font_selector);
            });
            $("body").append(font_selector);
            font_selector.hide();
            $("#bwbbcode_font").bind("click", function(event){
                font_button = this;
                font_selector_ifshow ? font_selector_hide() : font_selector_show();
            });
            font_check_mouse = function(event){
                var font_selector_this = "div#bwbbcode_font_selector";
                var font_selector_parent = $(event.target).parents(font_selector_this).length;
                if(event.target == $(font_selector_this)[0] || event.target == font_button || font_selector_parent > 0) { return; }
                font_selector_hide();
            }
            font_selector_hide = function(){
                var font_selector_this = $("div#bwbbcode_font_selector");
                $(document).unbind("mousedown", font_check_mouse);
                font_selector_this.hide();
                font_selector_ifshow = false;
            }
            font_selector_show = function(){
                var font_selector_this = $("div#bwbbcode_font_selector");
                font_selector_this.css({
                    top: $(font_button).offset().top + ($(font_button).outerHeight()),
                    left: $(font_button).offset().left
                });
                font_selector_this.show();
                $(document).bind("mousedown", font_check_mouse);
                font_selector_ifshow = true;
            }
            //////

            // size
            size_selector = $("<div id='bwbbcode_size_selector' unselectable='on'></div>");
            $.each(size_default, function(i){
                selector_content = $("<div class='bwbbcode_size_palette' unselectable='on'>"+this.toString()+"</div>")
                selector_content.css("font-size", this.toString()+"px");
                selector_content.bind("click", function(e){
                    selectInsert('[size='+size_default[i]+']', '[/size]');
                    size_selector_hide();
                });
                selector_content.bind("mouseover", function(e){
                    $(this).removeClass("bwbbcode_size_palette");
                    $(this).addClass("bwbbcode_size_palette_mouseover");
                });
                selector_content.bind("mouseout", function(e){
                    $(this).removeClass("bwbbcode_size_palette_mouseover");
                    $(this).addClass("bwbbcode_size_palette");
                });
                selector_content.appendTo(size_selector);
            });
            $("body").append(size_selector);
            size_selector.hide();
            $("#bwbbcode_size").bind("click", function(event){
                size_button = this;
                size_selector_ifshow ? size_selector_hide() : size_selector_show();
            });
            size_check_mouse = function(event){
                var size_selector_this = "div#bwbbcode_size_selector";
                var size_selector_parent = $(event.target).parents(size_selector_this).length;
                if(event.target == $(size_selector_this)[0] || event.target == size_button || size_selector_parent > 0) { return; }
                size_selector_hide();
            }
            size_selector_hide = function(){
                var size_selector_this = $("div#bwbbcode_size_selector");
                $(document).unbind("mousedown", size_check_mouse);
                size_selector_this.hide();
                size_selector_ifshow = false;
            }
            size_selector_show = function(){
                var size_selector_this = $("div#bwbbcode_size_selector");
                size_selector_this.css({
                    top: $(size_button).offset().top + ($(size_button).outerHeight()),
                    left: $(size_button).offset().left
                });
                size_selector_this.show();
                $(document).bind("mousedown", size_check_mouse);
                size_selector_ifshow = true;
            }
            //////

            // color
            color_selector = $("<div id='bwbbcode_color_selector' unselectable='on'></div>");
            $.each(color_default, function(i){
                selector_content = $("<div class='bwbbcode_color_palette' unselectable='on'>&nbsp;</div>")
                selector_content.css("background-color", this.toString());
                selector_content.bind("click", function(e){
                    selectInsert('[color='+color_default[i]+']', '[/color]');
                    color_selector_hide();
                });
                selector_content.bind("mouseover", function(e){
                    $(this).removeClass("bwbbcode_color_palette");
                    $(this).addClass("bwbbcode_color_palette_mouseover");
                });
                selector_content.bind("mouseout", function(e){
                    $(this).removeClass("bwbbcode_color_palette_mouseover");
                    $(this).addClass("bwbbcode_color_palette");
                });
                selector_content.appendTo(color_selector);
            });
            $("body").append(color_selector);
            color_selector.hide();
            $("#bwbbcode_color").bind("click", function(event){
                color_button = this;
                color_selector_ifshow ? color_selector_hide() : color_selector_show();
            });
            color_check_mouse = function(event){
                var color_selector_this = "div#bwbbcode_color_selector";
                var color_selector_parent = $(event.target).parents(color_selector_this).length;
                if(event.target == $(color_selector_this)[0] || event.target == color_button || color_selector_parent > 0) { return; }
                color_selector_hide();
            }
            color_selector_hide = function(){
                var color_selector_this = $("div#bwbbcode_color_selector");
                $(document).unbind("mousedown", color_check_mouse);
                color_selector_this.hide();
                color_selector_ifshow = false;
            }
            color_selector_show = function(){
                var color_selector_this = $("div#bwbbcode_color_selector");
                color_selector_this.css({
                    top: $(color_button).offset().top + ($(color_button).outerHeight()),
                    left: $(color_button).offset().left
                });
                color_selector_this.show();
                $(document).bind("mousedown", color_check_mouse);
                color_selector_ifshow = true;
            }
            //////

            // bgcolor
            bgcolor_selector = $("<div id='bwbbcode_bgcolor_selector' unselectable='on'></div>");
            $.each(bgcolor_default, function(i){
                selector_content = $("<div class='bwbbcode_bgcolor_palette' unselectable='on'>&nbsp;</div>")
                selector_content.css("background-color", this.toString());
                selector_content.bind("click", function(e){
                    selectInsert('[bgcolor='+bgcolor_default[i]+']', '[/bgcolor]');
                    bgcolor_selector_hide();
                });
                selector_content.bind("mouseover", function(e){
                    $(this).removeClass("bwbbcode_bgcolor_palette");
                    $(this).addClass("bwbbcode_bgcolor_palette_mouseover");
                });
                selector_content.bind("mouseout", function(e){
                    $(this).removeClass("bwbbcode_bgcolor_palette_mouseover");
                    $(this).addClass("bwbbcode_bgcolor_palette");
                });
                selector_content.appendTo(bgcolor_selector);
            });
            $("body").append(bgcolor_selector);
            bgcolor_selector.hide();
            $("#bwbbcode_bgcolor").bind("click", function(event){
                bgcolor_button = this;
                bgcolor_selector_ifshow ? bgcolor_selector_hide() : bgcolor_selector_show();
            });
            bgcolor_check_mouse = function(event){
                var bgcolor_selector_this = "div#bwbbcode_bgcolor_selector";
                var bgcolor_selector_parent = $(event.target).parents(bgcolor_selector_this).length;
                if(event.target == $(bgcolor_selector_this)[0] || event.target == bgcolor_button || bgcolor_selector_parent > 0) { return; }
                bgcolor_selector_hide();
            }
            bgcolor_selector_hide = function(){
                var bgcolor_selector_this = $("div#bwbbcode_bgcolor_selector");
                $(document).unbind("mousedown", bgcolor_check_mouse);
                bgcolor_selector_this.hide();
                bgcolor_selector_ifshow = false;
            }
            bgcolor_selector_show = function(){
                var bgcolor_selector_this = $("div#bwbbcode_bgcolor_selector");
                bgcolor_selector_this.css({
                    top: $(bgcolor_button).offset().top + ($(bgcolor_button).outerHeight()),
                    left: $(bgcolor_button).offset().left
                });
                bgcolor_selector_this.show();
                $(document).bind("mousedown", bgcolor_check_mouse);
                bgcolor_selector_ifshow = true;
            }
            //////

            selectInsert = function (code_begin, code_end) {
                var val = $("#content").selected();
                //var mytest = val;
                //var s="";for(i in mytest){s+=i.toString()+"\n";}alert(mytest);alert(s);
                if (val == '') {
                    //alert('请选择文字后进行此操作...');
                    //return false;
                    $('#content').insertIn(code_begin + code_end);
                } else {
                    $('#content').insertIn(code_begin + val + code_end);
                }
            }

            $.fn.selected = function() {
                var txt = '';
                var doc = this.get(0).document;
                if (doc) {
                    var sel = doc.selection.createRange();
                    if (sel.text.length > 0) {
                        txt = sel.text;
                    }
                } else if (this.get(0).selectionStart || this.get(0).selectionStart == '0') {
                    var s = this.get(0).selectionStart;
                    var e = this.get(0).selectionEnd;
                    if (s != e) {
                        txt = this.get(0).value.substring(s, e);
                    }
                }
                return $.trim(txt);
            }

            $.fn.insertIn = function(t) {
                var doc = this.get(0).document;
                if (doc) {
                    var sel     = doc.selection.createRange();
                    this.get(0).focus();
                    sel.text    = t;
                } else if (this.get(0).selectionStart || this.get(0).selectionStart == '0') {
                    var s       = this.get(0).selectionStart;
                    var e       = this.get(0).selectionEnd;
                    var val     = this.get(0).value;
                    var start   = val.substring(0,s);
                    var end     = val.substring(e);
                    this.get(0).value = start + t + end;
                }
            }
        }
    });
})(jQuery);
