/*
+-----------------------------------------------------------------------------+
| $Id: jquery.bw.roll.js 2009-08-18 02:36:30Z Bleakwind $
| Roll up
| Copyright (c) 2003-2010 Bleakwind (www.weaverdream.com)
| http://www.weaverdream.com/
| Release under the GNU Lesser General Public License Version 3 (LGPLv3):
|   http://www.gnu.org/licenses/lgpl.html
+-----------------------------------------------------------------------------+
*/

(function($){
    $.fn.extend({
        bwroll:function(option){

            var mouse_event;
            var top         = this.eq(0).find("ul:first"),
                line_height = top.find("li:first").height(),
                line        = option.line  ?   parseInt(option.line,10)   : parseInt(this.height()/line_height,10),
                speed       = option.speed ?   parseInt(option.speed,10)  : 1000,
                space       = option.space ?   parseInt(option.space,10)  : 3000;

            if (line == 0) { line = 1; }

            bwrollUp = function(){
                top.animate({
                    marginTop:0 - line*line_height
                },speed,function(){
                    for(i = 1; i <= line; i++){
                        top.find("li:first").appendTo(top);
                    }
                    top.css({marginTop:0});
                });
            }

            top.hover(function(){
                clearInterval(mouse_event);
            },function(){
                mouse_event = setInterval("bwrollUp()",space);
            }).mouseout();

        }
    });
})(jQuery);
