<?php
/*
+-----------------------------------------------------------------------------+
| $Id: cp_password.php 2010-05-24 12:37:44Z Bleakwind $
| Manage password for Member
| Copyright (c) 2003-2010 Bleakwind (www.weaverdream.com)
| http://www.weaverdream.com/
| Release under the GNU Lesser General Public License Version 3 (LGPLv3):
|   http://www.gnu.org/licenses/lgpl.html
+-----------------------------------------------------------------------------+
*/

if (!defined( 'ENTRY_INDEX')){
    echo "<h1>Forbidden</h1><p>You don't have permission to access on this server.</p>";
    exit;
}

function cp_password($value)
{
    global $SETTING,$LANGUAGE,$CONFIG,$CONFIGURE,$SESSION,$PROMPT,$MEMBER,$db,$sys,$c;
    $ajax_response = new xajaxResponse();
    $error = false;
    //func::fp($value);

    if ( mb_strwidth($value['password'],"UTF-8") < 6 ||
        mb_strwidth($value['password'],"UTF-8") > 60 ||
        func::str_encrypt($value['password'],$CONFIGURE['sys']['encrypt_mix']) != $MEMBER['password'] ){
        $error = true;
        if(empty($anchor)) { $anchor = "password"; }
        $ajax_response->assign("password_return", "innerHTML", "<span class=\"prompt_failed\">".$LANGUAGE['s']['cp_password']['password_error']."</span>");
    } else {
        $ajax_response->assign("password_return", "innerHTML", "<span class=\"prompt_succeed\">".$LANGUAGE['s']['cp_password']['password_right']."</span>");
    }
    
    if ( mb_strwidth($value['password1'],"UTF-8") < 6 ||
        mb_strwidth($value['password1'],"UTF-8") > 60 ){
        $error = true;
        if(empty($anchor)) { $anchor = "password1"; }
        $ajax_response->assign("password1_return", "innerHTML", "<span class=\"prompt_failed\">".$LANGUAGE['s']['cp_password']['password1_error']."</span>");
    } else {
        $ajax_response->assign("password1_return", "innerHTML", "<span class=\"prompt_succeed\">".$LANGUAGE['s']['cp_password']['password1_right']."</span>");
    }
    if ( mb_strwidth($value['password2'],"UTF-8") < 6 ||
        mb_strwidth($value['password2'],"UTF-8") > 60 ||
        $value['password2'] != $value['password1']){
        $error = true;
        if(empty($anchor)) { $anchor = "password2"; }
        $ajax_response->assign("password2_return", "innerHTML", "<span class=\"prompt_failed\">".$LANGUAGE['s']['cp_password']['password2_error']."</span>");
    } else {
        $ajax_response->assign("password2_return", "innerHTML", "<span class=\"prompt_succeed\">".$LANGUAGE['s']['cp_password']['password2_right']."</span>");
    }

    if($error){
        $ajax_response->assign("cp_password_submit","value",$LANGUAGE['s']['cp_password']['submit_amend']);
        $ajax_response->assign("cp_password_submit","disabled",false);
        #$ajax_response->redirect("#".$anchor);
    }else{

        $where_password = "password ='".func::str_encrypt($value['password1'],$CONFIGURE['sys']['encrypt_mix'])."',";

        //////
        $sql = "UPDATE ".DB_TABLE_MEMBER." SET
                    ".$where_password."
                    ip_change       ='".func::return_ip()."',
                    time_change     =".$sys->nowtime."
                WHERE id='".$MEMBER['id']."'";
        $result = &$db->Execute($sql);
        if (!$result) {
            $ajax_response->alert($db->ErrorMsg());
        }else{
            $sys->set_prompt(array(
                "prompt_type"       => "'cp_prompt'",
                "prompt_if"         => "1",
                "prompt_message"    => "'".$LANGUAGE['s']['cp_password']['amend_succeed']."'",
                "prompt_returnurl"  => "'".$CONFIGURE['common']['control_index']."?act=cp'",
                "prompt_returntext" => "'".$LANGUAGE['s']['cp_password']['amend_return']."'",
                "prompt_image"      => "'succeed.gif'",
                "prompt_act"        => "'cp_prompt'",
            ));
            $c->destroy();
            $ajax_response->redirect($CONFIGURE['common']['control_index']."?act=cp_prompt");
        }
        //////
    }

    return $ajax_response;
}
$bwajax->register(XAJAX_FUNCTION, "cp_password");

$public_var['page_place'][] = $LANGUAGE['s']['cp_password']['page_place_upper'];
$public_var['page_place'][] = $LANGUAGE['s']['cp_password']['page_place'];
?>
