<?php
/*
+-----------------------------------------------------------------------------+
| $Id: cp_profile.php 2010-05-24 12:37:44Z Bleakwind $
| Manage profile for Member
| Copyright (c) 2003-2010 Bleakwind (www.weaverdream.com)
| http://www.weaverdream.com/
| Release under the GNU Lesser General Public License Version 3 (LGPLv3):
|   http://www.gnu.org/licenses/lgpl.html
+-----------------------------------------------------------------------------+
*/

if (!defined( 'ENTRY_INDEX')){
    echo "<h1>Forbidden</h1><p>You don't have permission to access on this server.</p>";
    exit;
}

function question_select($id, $select, $value)
{
    global $LANGUAGE,$LANGLIST,$SETTING,$sys, $member_info;
    $ajax_response = new xajaxResponse();
    if ( $value == "custom"){
        $ajax_response->assign($select, "style.width", '80px');
        $ajax_response->assign($id, "style.display", 'inline');
    } else {
        $ajax_response->assign($select, "style.width", '230px');
        $ajax_response->assign($id, "style.display", 'none');
    }
    return $ajax_response;
}
$bwajax->register(XAJAX_FUNCTION, "question_select");

function cp_profile($value)
{
    global $SETTING,$LANGUAGE,$CONFIG,$CONFIGURE,$SESSION,$PROMPT,$MEMBER,$db,$sys,$c;
    $ajax_response = new xajaxResponse();
    $error = false;
    //func::fp($value);

    $value['email'] = strtolower($value['email']);
    if ( !preg_match("/^[a-z0-9-_\.]+@([a-z0-9][a-z0-9-]*\.)+[a-z]{2,4}$/i",$value['email']) ) {
        $error = true;
        if(empty($anchor)) { $anchor = "email"; }
        $ajax_response->assign("email_return", "innerHTML", "<span class=\"prompt_failed\">".$LANGUAGE['s']['cp_profile']['email_error']."</span>");
    } else {
        $sql = "SELECT id FROM ".DB_TABLE_MEMBER." WHERE email='".$value['email']."' AND email!='".$MEMBER['email']."'";
        $result = &$db->Execute($sql);
        if ($result->RecordCount() > 0) {
            $error = true;
            if(empty($anchor)) { $anchor = "email"; }
            $ajax_response->assign("email_return", "innerHTML", "<span class=\"prompt_failed\">".$LANGUAGE['s']['cp_profile']['email_already_use']."</span>");
        } else {
            $ajax_response->assign("email_return", "innerHTML", "<span class=\"prompt_succeed\">".$LANGUAGE['s']['cp_profile']['email_right']."</span>");
        }
    }
    
    if ( mb_strwidth($value['password'],"UTF-8") < 6 ||
        mb_strwidth($value['password'],"UTF-8") > 60 ||
        func::str_encrypt($value['password'],$CONFIGURE['sys']['encrypt_mix']) != $MEMBER['password'] ){
        $error = true;
        if(empty($anchor)) { $anchor = "password"; }
        $ajax_response->assign("password_return", "innerHTML", "<span class=\"prompt_failed\">".$LANGUAGE['s']['cp_profile']['password_error']."</span>");
    } else {
        $ajax_response->assign("password_return", "innerHTML", "<span class=\"prompt_succeed\">".$LANGUAGE['s']['cp_profile']['password_right']."</span>");
    }
    
    $question_type = "1";
    if( !preg_match("/^[1-9][0-9]{0,10}$/",$value['question']) && $value['question'] != "custom" ){
        $error = true;
        if(empty($anchor)) { $anchor = "question"; }
        $ajax_response->assign("question_return", "innerHTML", "<span class=\"prompt_failed\">".$LANGUAGE['s']['cp_profile']['question_error']."<!-- question error --></span>");
    } elseif ($value['question'] == "custom") {
        if ( mb_strwidth($value['question_custom'],"UTF-8") < 6 ||
            mb_strwidth($value['question_custom'],"UTF-8") > 30 ) {
            $error = true;
            if(empty($anchor)) { $anchor = "question"; }
            $ajax_response->assign("question_return", "innerHTML", "<span class=\"prompt_failed\">".$LANGUAGE['s']['cp_profile']['question_custom_error']."<!-- question error --></span>");
        } else {
            $question_type = "2";
            $question = $value['question_custom'];
            $ajax_response->assign("question_return", "innerHTML", "<span class=\"prompt_succeed\">".$LANGUAGE['s']['cp_profile']['question_custom_right']."</span>");
        }
    } else {
        $question_type = "1";
        $question = $value['question'];
        $ajax_response->assign("question_return", "innerHTML", "<span class=\"prompt_succeed\">".$LANGUAGE['s']['cp_profile']['question_right']."</span>");
    }
    

    if ( mb_strwidth($value['answer'],"UTF-8") < 6 ||
        mb_strwidth($value['answer'],"UTF-8") > 30 ) {
        $error = true;
        if(empty($anchor)) { $anchor = "answer"; }
        $ajax_response->assign("answer_return", "innerHTML", "<span class=\"prompt_failed\">".$LANGUAGE['s']['cp_profile']['answer_error']."</span>");
    } else {
        $ajax_response->assign("answer_return", "innerHTML", "<span class=\"prompt_succeed\">".$LANGUAGE['s']['cp_profile']['answer_right']."</span>");
    }

    if($error){
        $ajax_response->assign("cp_profile_submit","value",$LANGUAGE['s']['cp_profile']['submit_amend']);
        $ajax_response->assign("cp_profile_submit","disabled",false);
        #$ajax_response->redirect("#".$anchor);
    }else{

        $history = array();
        $history['password'][] = array( $sys->nowtime => func::str_encrypt($value['password1'],$CONFIGURE['sys']['encrypt_mix']) );

        //////
        $sql = "UPDATE ".DB_TABLE_MEMBER." SET
                    email           ='".addslashes($value['email'])."',
                    question_type   ='".addslashes($question_type)."',
                    question        ='".addslashes($question)."',
                    answer          ='".addslashes($value['answer'])."',
                    ip_change       ='".func::return_ip()."',
                    time_change     =".$sys->nowtime."
                WHERE id='".$MEMBER['id']."'";
        $result = &$db->Execute($sql);
        if (!$result) {
            $ajax_response->alert($db->ErrorMsg());
        }else{
            $sys->set_prompt(array(
                "prompt_type"       => "'cp_prompt'",
                "prompt_if"         => "1",
                "prompt_message"    => "'".$LANGUAGE['s']['cp_profile']['amend_succeed']."'",
                "prompt_returnurl"  => "'".$CONFIGURE['common']['control_index']."?act=cp'",
                "prompt_returntext" => "'".$LANGUAGE['s']['cp_profile']['amend_return']."'",
                "prompt_image"      => "'succeed.gif'",
                "prompt_act"        => "'cp_prompt'",
            ));
            $ajax_response->redirect($CONFIGURE['common']['control_index']."?act=cp_prompt");
        }
        //////
    }

    return $ajax_response;
}
$bwajax->register(XAJAX_FUNCTION, "cp_profile");

$public_var['page_place'][] = $LANGUAGE['s']['cp_profile']['page_place_upper'];
$public_var['page_place'][] = $LANGUAGE['s']['cp_profile']['page_place'];
?>
