<?php
/*
+-----------------------------------------------------------------------------+
| $Id: curve.php 2010-05-24 12:37:44Z Bleakwind $
| Handle for Build picture
| Copyright (c) 2003-2010 Bleakwind (www.weaverdream.com)
| http://www.weaverdream.com/
| Release under the GNU Lesser General Public License Version 3 (LGPLv3):
|   http://www.gnu.org/licenses/lgpl.html
+-----------------------------------------------------------------------------+
*/

$space = 1;
$image_filename     = "01.jpg";

$build_width        = 50;
$build_height       = 150;
$build_filename     = "./cache/build.png";
$cut_type_align     = "center";
$cut_type_valign    = "middle";


$watermark_source   = "images/watermark_big.png";
$watermark_width    = 10;
$watermark_x        = 50;
$watermark_y        = 60;

$build = false;
if(file_exists($build_filename)){
    if(($sys->nowtime - filemtime($build_filename)) < $space){
        readfile($build_filename);
    }else{
        $build = true;
    }
}else{
    $build = true;
}

if($build === true) {

    $build_percent = $build_width/$build_height;

    list($image_width, $image_height, $image_type, $image_attr) = getimagesize($image_filename);
    $image_percent = $image_width/$image_height;

    $build_x = 0;
    $build_y = 0;
    if ($build_percent < $image_percent) {
        $build_image_width  = $build_width;
        $build_image_height = $build_width/$image_percent;
        $build_x = 0;
        if ($cut_type_valign == "top"){
            $build_y = 0;
        }elseif ($cut_type_valign == "bottom"){
            $build_y = $build_height - $build_image_height;
        }else{
            $build_y = ($build_height - $build_image_height)/2;
        }
    } elseif ($build_percent > $image_percent) {
        $build_image_width  = $build_height*$image_percent;
        $build_image_height = $build_height;
        if ($cut_type_valign == "left"){
            $build_x = 0;
        }elseif ($cut_type_valign == "right"){
            $build_x = $build_width - $build_image_width;
        }else{
            $build_x = ($build_width - $build_image_width)/2;
        }
        $build_y = 0;
    } else {
        $build_image_width  = $build_width;
        $build_image_height = $build_height;
        $build_x = 0;
        $build_y = 0;
    }

    $bwcurve = new bwcurve($build_width,$build_height);
    $bwcurve->set_imagetype("gif");
    $bwcurve->set_bgcolor("FFFFFF");
    $bwcurve->set_copyimage($image_filename,$build_image_width,$build_x,$build_y);
    //$bwcurve->set_copyimage($watermark_source,$watermark_width,$watermark_x,$watermark_y);
    $bwcurve->parse();
    header( "content-type: image/png");
    $bwcurve->output($build_filename);
    readfile($build_filename);
}
?>
