<?php
/*
+-----------------------------------------------------------------------------+
| $Id: forgetpass.php 2010-05-24 12:37:44Z Bleakwind $
| Get back Member password
| Copyright (c) 2003-2010 Bleakwind (www.weaverdream.com)
| http://www.weaverdream.com/
| Release under the GNU Lesser General Public License Version 3 (LGPLv3):
|   http://www.gnu.org/licenses/lgpl.html
+-----------------------------------------------------------------------------+
*/

if (!defined( 'ENTRY_INDEX')){
    echo "<h1>Forbidden</h1><p>You don't have permission to access on this server.</p>";
    exit;
}

function forgetpass_send($value)
{
    global $SETTING,$LANGUAGE,$CONFIG,$CONFIGURE,$SESSION,$PROMPT,$LANGLIST,$db,$sys,$c;
    $ajax_response = new xajaxResponse();
    //$ajax_response->alert(print_r($value, true)); $ajax_response->assign($submit,"disabled",false); return $ajax_response;
    //func::fp($value);

    $error  = false;
    $submit = "forgetpass_submit";

    if ( empty($value['verifycode']) || strtolower($value['verifycode']) != strtolower($SESSION->_['vc_forgetpass']) ) {
        if (!$error) {
            $error = true;
            $prompt_message = "<span class=\"prompt_failed\">".$LANGUAGE['s']['forgetpass']['verifycode_error']."</span>";
            $ajax_response->script("xajax_switch_verifycode('vc_forgetpass_show','".$CONFIGURE['common']['control_index']."','vc_forgetpass');");
        }
    }

    if ( !preg_match("/^[a-z0-9-_\.]+@([a-z0-9][a-z0-9-]*\.)+[a-z]{2,4}$/i",$value['email']) ) {
        if (!$error) {
            $error = true;
            $prompt_message = "<span class=\"prompt_failed\">".$LANGUAGE['s']['forgetpass']['email_error']."</span>";
        }
    }

    $value['username'] = strtolower(trim($value['username']));
    if ( empty($value['username']) ) {
        if (!$error) {
            $error = true;
            $prompt_message = "<span class=\"prompt_failed\">".$LANGUAGE['s']['forgetpass']['username_empty']."</span>";
        }
    } elseif ( mb_strwidth($value['username'],"UTF-8") < 4 ||
         mb_strwidth($value['username'],"UTF-8") > 60 ||
        preg_match("/[\x01-\x2E]|[\\x2F]|[\x3A-\x40]|[\x5B-\x5E]|[\x60]|[\x7B-\x7F]/",$value['username']) ) {
        if (!$error) {
            $error = true;
            $prompt_message = "<span class=\"prompt_failed\">".$LANGUAGE['s']['forgetpass']['username_error']."</span>";
        }
    }

    if($error){
        $ajax_response->assign("prompt_message","innerHTML",$prompt_message);
        $ajax_response->assign($submit,"value",$LANGUAGE['s']['forgetpass']['forgetpass_send_submit']);
        $ajax_response->assign($submit,"disabled",false);
    }else{

        $member_info  = func::db_select(DB_TABLE_MEMBER, "*", "username='".$value['username']."'");
        $member_info  = $member_info[0];
        if (empty($member_info)) {
            $ajax_response->assign("prompt_message", "innerHTML", "<span class=\"prompt_failed\">".$LANGUAGE['s']['forgetpass']['username_not_exist']."</span>");
            $ajax_response->assign($submit,"value",$LANGUAGE['s']['forgetpass']['forgetpass_send_submit']);
            $ajax_response->assign($submit,"disabled",false);
        } elseif ($member_info['email'] != $value['email']) {
            $ajax_response->assign("prompt_message", "innerHTML", "<span class=\"prompt_failed\">".$LANGUAGE['s']['forgetpass']['email_error']."</span>");
            $ajax_response->assign($submit,"value",$LANGUAGE['s']['forgetpass']['forgetpass_send_submit']);
            $ajax_response->assign($submit,"disabled",false);
        } else {

            $sn = sha1(microtime());
            $result_delete  = func::db_delete(DB_TABLE_MEMBER_RESET,  "mid=".$member_info['id']);

            $sql = "INSERT INTO ".DB_TABLE_MEMBER_RESET." SET
                        sn              ='".$sn."',
                        mid             ='".$member_info['id']."',
                        email           ='".$value['email']."',
                        time_created    ='".$sys->nowtime."'";

            if (!$db->Execute($sql)) {
                $ajax_response->assign("prompt_message", "innerHTML", "<span class=\"prompt_failed\">".$LANGUAGE['s']['forgetpass']['insert_error']."</span>");
                $ajax_response->assign($submit,"value",$LANGUAGE['s']['forgetpass']['forgetpass_send_submit']);
                $ajax_response->assign($submit,"disabled",false);
            }else{

                $mail               = new PHPMailer();
                $mail->SetLanguage("en");

                $mail->CharSet      = $LANGUAGE['s']['forgetpass']['mail_forgetpass_charset'];
                $mail->WordWrap     = 60;
                $mail->IsHTML(true);
                $mail->IsMail();

                $mail->From         = $CONFIG['email_from'];
                $mail->FromName     = iconv($LANGUAGE['s']['_public']['global']['charset'], $mail->CharSet, $LANGUAGE['s']['forgetpass']['mail_forgetpass_fromname']);
                $mail->Subject      = iconv($LANGUAGE['s']['_public']['global']['charset'], $mail->CharSet, $LANGUAGE['s']['forgetpass']['mail_forgetpass_subject']);

                $body               = $mail->getFile('language/'.$LANGLIST[$CONFIG['language']]['dir'].'/template/mail_forgetpass_html.php');
                //$body               = preg_replace("/\\\\/","",$body);
                $body               = str_replace("[MAIL_USERNAME]",$member_info['username'],$body);
                $body               = str_replace("[MAIL_PASSWORD]",$newpassword,$body);
                $body               = str_replace("[MAIL_FROMNAME]",$LANGUAGE['s']['forgetpass']['mail_fromname'],$body);
                $body               = str_replace("[MAIL_CONFIG_ROOTDIR]",CONFIG_ROOTDIR,$body);
                $body               = str_replace("[MAIL_CONTROL_INDEX]",$CONFIGURE['common']['control_index'],$body);
                $body               = str_replace("[MAIL_SYSNAME]",$SETTING['var_sysname'],$body);
                $body               = str_replace("[MAIL_SN]",$sn,$body);
                $body               = iconv($LANGUAGE['s']['_public']['global']['charset'], $mail->CharSet, $body);
                $mail->MsgHTML($body);

                $mail->AltBody      = $mail->getFile('language/'.$LANGLIST[$CONFIG['language']]['dir'].'/template/mail_forgetpass_text.php');
                $mail->AltBody      = preg_replace("/\\\\/","",$mail->AltBody);
                $mail->AltBody      = str_replace("[MAIL_USERNAME]",$member_info['username'],$mail->AltBody);
                $mail->AltBody      = str_replace("[MAIL_PASSWORD]",$newpassword,$mail->AltBody);
                $mail->AltBody      = str_replace("[MAIL_FROMNAME]",$LANGUAGE['s']['forgetpass']['mail_fromname'],$mail->AltBody);
                $mail->AltBody      = str_replace("[MAIL_CONFIG_ROOTDIR]",CONFIG_ROOTDIR,$mail->AltBody);
                $mail->AltBody      = str_replace("[MAIL_CONTROL_INDEX]",$CONFIGURE['common']['control_index'],$mail->AltBody);
                $mail->AltBody      = str_replace("[MAIL_SYSNAME]",$SETTING['var_sysname'],$mail->AltBody);
                $mail->AltBody      = str_replace("[MAIL_SN]",$sn,$mail->AltBody);
                $mail->AltBody      = iconv($LANGUAGE['s']['_public']['global']['charset'], $mail->CharSet, $mail->AltBody);

                $mail->AddAddress($value['email']);

                if(!$mail->Send()){
                    $sys->set_prompt(array(
                        "prompt_type"       => "'prompt'",
                        "prompt_if"         => "1",
                        "prompt_message"    => "'".$LANGUAGE['s']['forgetpass']['mail_forgetpass_sendfailed']."<!-- ".$mail->ErrorInfo." -->'",
                        "prompt_returnurl"  => "'".$CONFIGURE['common']['control_index']."'",
                        "prompt_returntext" => "'".$LANGUAGE['s']['forgetpass']['save_jump']."'",
                        "prompt_image"      => "'failed.gif'",
                        "prompt_act"        => "'prompt'",
                    ));
                    $ajax_response->redirect($CONFIGURE['common']['control_index']."?act=prompt");
                }else{
                    $sys->set_prompt(array(
                        "prompt_type"       => "'prompt'",
                        "prompt_if"         => "1",
                        "prompt_message"    => "'".$LANGUAGE['s']['forgetpass']['mail_forgetpass_sendsucceed']."'",
                        "prompt_returnurl"  => "'".$CONFIGURE['common']['control_index']."'",
                        "prompt_returntext" => "'".$LANGUAGE['s']['forgetpass']['save_jump']."'",
                        "prompt_image"      => "'succeed.gif'",
                        "prompt_act"        => "'prompt'",
                    ));
                    $ajax_response->redirect($CONFIGURE['common']['control_index']."?act=prompt");
                }
            }
        }
    }
    return $ajax_response;
}
$bwajax->register(XAJAX_FUNCTION, "forgetpass_send");

function forgetpass_reset($value)
{
    global $SETTING,$LANGUAGE,$CONFIG,$CONFIGURE,$SESSION,$PROMPT,$MEMBER,$db,$sys,$c;
    $ajax_response = new xajaxResponse();
    $error = false;
    //$ajax_response->alert("11111");
    //func::fp($value);

    $error  = false;
    $submit = "forgetpass_submit";

    if ( mb_strwidth($value['password1'],"UTF-8") < 6 ||
        mb_strwidth($value['password1'],"UTF-8") > 60 ){
        $error = true;
        if(empty($anchor)) { $anchor = "password1"; }
        $ajax_response->assign("password1_return", "innerHTML", "<span class=\"prompt_failed\">".$LANGUAGE['s']['forgetpass']['password1_error']."</span>");
    } else {
        $ajax_response->assign("password1_return", "innerHTML", "<span class=\"prompt_succeed\">".$LANGUAGE['s']['forgetpass']['password1_right']."</span>");
    }
    if ( mb_strwidth($value['password2'],"UTF-8") < 6 ||
        mb_strwidth($value['password2'],"UTF-8") > 60 ||
        $value['password2'] != $value['password1']){
        $error = true;
        if(empty($anchor)) { $anchor = "password2"; }
        $ajax_response->assign("password2_return", "innerHTML", "<span class=\"prompt_failed\">".$LANGUAGE['s']['forgetpass']['password2_error']."</span>");
    } else {
        $ajax_response->assign("password2_return", "innerHTML", "<span class=\"prompt_succeed\">".$LANGUAGE['s']['forgetpass']['password2_right']."</span>");
    }

    $value['username'] = strtolower(trim($value['username']));
    if ( empty($value['username']) ) {
        $error = true;
        if(empty($anchor)) { $anchor = "username"; }
        $ajax_response->assign("username_return", "innerHTML", "<span class=\"prompt_failed\">".$LANGUAGE['s']['forgetpass']['username_empty']."</span>");
    } elseif ( mb_strwidth($value['username'],"UTF-8") < 4 ||
         mb_strwidth($value['username'],"UTF-8") > 60 ||
        preg_match("/[\x01-\x2E]|[\\x2F]|[\x3A-\x40]|[\x5B-\x5E]|[\x60]|[\x7B-\x7F]/",$value['username']) ) {
        $error = true;
        if(empty($anchor)) { $anchor = "username"; }
        $ajax_response->assign("username_return", "innerHTML", "<span class=\"prompt_failed\">".$LANGUAGE['s']['forgetpass']['username_error']."</span>");
    }

    if($error){
        $ajax_response->assign($submit,"value",$LANGUAGE['s']['forgetpass']['forgetpass_reset_submit']);
        $ajax_response->assign($submit,"disabled",false);
        #$ajax_response->redirect("#".$anchor);
    }elseif(!preg_match("/^[a-z0-9]+$/i",$sys->get['sn'])){
        $ajax_response->alert($LANGUAGE['s']['forgetpass']['sn_error']);
        $ajax_response->assign($submit,"value",$LANGUAGE['s']['forgetpass']['forgetpass_reset_submit']);
        $ajax_response->assign($submit,"disabled",false);
    } else {
        $reset_info  = func::db_select(DB_TABLE_MEMBER_RESET, "*", "sn='".$sys->get['sn']."'");
        $reset_info  = $reset_info[0];
        if (empty($reset_info)) {
            $ajax_response->assign("prompt_message", "innerHTML", "<span class=\"prompt_failed\">".$LANGUAGE['s']['forgetpass']['sn_not_exist']."</span>");
            $ajax_response->assign($submit,"value",$LANGUAGE['s']['forgetpass']['forgetpass_reset_submit']);
            $ajax_response->assign($submit,"disabled",false);
        } elseif ( ($sys->notime - $reset_info['time_created']) > 86400 ) {
            $ajax_response->assign("prompt_message", "innerHTML", "<span class=\"prompt_failed\">".$LANGUAGE['s']['forgetpass']['sn_time_expire']."</span>");
            $ajax_response->assign($submit,"value",$LANGUAGE['s']['forgetpass']['forgetpass_reset_submit']);
            $ajax_response->assign($submit,"disabled",false);
        } else {

            $member_info  = func::db_select(DB_TABLE_MEMBER, "*", "id='".$reset_info['mid']."'");
            $member_info  = $member_info[0];
            if (empty($member_info)) {
                $ajax_response->assign("prompt_message", "innerHTML", "<span class=\"prompt_failed\">".$LANGUAGE['s']['forgetpass']['member_not_exist']."</span>");
                $ajax_response->assign($submit,"value",$LANGUAGE['s']['forgetpass']['forgetpass_reset_submit']);
                $ajax_response->assign($submit,"disabled",false);
            } elseif ($member_info['username'] != $value['username']) {
                $ajax_response->assign("prompt_message", "innerHTML", "<span class=\"prompt_failed\">".$LANGUAGE['s']['forgetpass']['username_error']."</span>");
                $ajax_response->assign($submit,"value",$LANGUAGE['s']['forgetpass']['forgetpass_reset_submit']);
                $ajax_response->assign($submit,"disabled",false);
            } else {

                $where_password = "password ='".func::str_encrypt($value['password1'],$CONFIGURE['sys']['encrypt_mix'])."',";

                //////
                $sql = "UPDATE ".DB_TABLE_MEMBER." SET
                            ".$where_password."
                            ip_change       ='".func::return_ip()."',
                            time_change     =".$sys->nowtime."
                        WHERE id='".$reset_info['mid']."'";
                $result = &$db->Execute($sql);
                if (!$result) {
                    $ajax_response->alert($db->ErrorMsg());
                }else{
                    $sys->set_prompt(array(
                        "prompt_type"       => "'cp_prompt'",
                        "prompt_if"         => "1",
                        "prompt_message"    => "'".$LANGUAGE['s']['forgetpass']['amend_succeed']."'",
                        "prompt_returnurl"  => "'".$CONFIGURE['common']['control_index']."?act=login'",
                        "prompt_returntext" => "'".$LANGUAGE['s']['forgetpass']['forgetpass_return']."'",
                        "prompt_image"      => "'succeed.gif'",
                        "prompt_act"        => "'cp_prompt'",
                    ));
                    $c->destroy();
                    $ajax_response->redirect($CONFIGURE['common']['control_index']."?act=cp_prompt");
                }
            }
        }
    }

    return $ajax_response;
}
$bwajax->register(XAJAX_FUNCTION, "forgetpass_reset");

if($sys->get['ope'] == "reset"){
    if(!preg_match("/^[a-z0-9]+$/i",$sys->get['sn'])){
        $sys->prompt("failed",$LANGUAGE['s']['forgetpass']['sn_error']."<!-- sn_error -->");
    }else{
        $sql = "SELECT * FROM ".DB_TABLE_MEMBER_RESET." WHERE sn='".$sys->get['sn']."'";
        $result = &$db->Execute($sql);
        if (!$result) {
            $ajax_response->alert($db->ErrorMsg());
        } else {
            if ($result->EOF) {
                $sys->prompt("failed",$LANGUAGE['s']['forgetpass']['sn_not_exist']."<!-- sn_not_exist -->");
            }else{
                if ( ($sys->notime - $result->fields['time_created']) > 86400 ) {
                    $sys->prompt("failed",$LANGUAGE['s']['forgetpass']['sn_time_expire']."<!-- sn_time_expire -->");
                } else {
                    $member_info = func::db_select(DB_TABLE_MEMBER, "id,username", "id=".$result->fields['mid']);
                    $member_info = $member_info[0];
                    $t->assign(array(
                        "forgetpass_sn" => $sys->get['forgetpass_sn'],
                        "member_info"      => $member_info,
                    ));
                }
            }
        }
    }

}
$public_var['page_place'][] = $LANGUAGE['s']['forgetpass']['page_place'];
?>