<?php
/*
+-----------------------------------------------------------------------------+
| $Id: function.ajax.php 2010-05-24 11:44:31Z Bleakwind $
| Private ajax function
| Copyright (c) 2003-2010 Bleakwind (www.weaverdream.com)
| http://www.weaverdream.com/
| Release under the GNU Lesser General Public License Version 3 (LGPLv3):
|   http://www.gnu.org/licenses/lgpl.html
+-----------------------------------------------------------------------------+
*/

// Quick Search
function quick_site_search($form, $action, $value, $submit)
{
    global $LANGUAGE;
    $ajax_response = new xajaxResponse();
    if (empty($value['search_keyword'])) {
        $ajax_response->alert($LANGUAGE['s']['_public']['search']['keyword_empty']);
    } elseif (mb_strwidth($value['search_keyword'],"UTF-8") > 30) {
        $ajax_response->alert($LANGUAGE['s']['_public']['search']['keyword_long']);
    } elseif (in_array($value['search_keyword'], $LANGUAGE['s']['_public']['search']['keyword_default'])){
        $ajax_response->alert($LANGUAGE['s']['_public']['search']['keyword_default_error']);
    } else {
        $ajax_response->assign($form,"action",$action);
        $ajax_response->assign($form,"target","_self");
        $ajax_response->script("$('#".$form."').submit();");
    }
    return $ajax_response;
}
$bwajax->register(XAJAX_FUNCTION, "quick_site_search");

// Quick login for member
function quick_member_login($value, $submit)
{
    global $SETTING,$LANGUAGE,$CONFIG,$CONFIGURE,$SESSION,$PROMPT,$db,$sys,$c,$ac;
    $ajax_response = new xajaxResponse();

    $error      = false;
    $mid        = "";
    $musername  = "";

    if ( empty($value['password']) ) {
        if (!$error) {
            $error = true;
            $prompt_message = $LANGUAGE['s']['_public']['login']['password_empty'];
        }
    } elseif ( mb_strwidth($value['password'],"UTF-8") < 4 ||
               mb_strwidth($value['password'],"UTF-8") > 60 ||
               preg_match("/[\x01-\x2E]|[\\x2F]|[\x3A-\x40]|[\x5B-\x5E]|[\x60]|[\x7B-\x7F]/",$value['password']) ) {
        if (!$error) {
            $error = true;
            $prompt_message = $LANGUAGE['s']['_public']['login']['password_error'];
        }
    }

    $value['username'] = strtolower(trim($value['username']));
    if ( empty($value['username']) ) {
        if (!$error) {
            $error = true;
            $prompt_message = $LANGUAGE['s']['_public']['login']['username_empty'];
        }
    } elseif ( (mb_strwidth($value['username'],"UTF-8") < 4 ||
                mb_strwidth($value['username'],"UTF-8") > 60 ||
                preg_match("/[\x01-\x2E]|[\\x2F]|[\x3A-\x40]|[\x5B-\x5E]|[\x60]|[\x7B-\x7F]/",$value['username']))
                && !preg_match("/^[a-z0-9-_\.]+@([a-z0-9][a-z0-9-]*\.)+[a-z]{2,4}$/i",$value['username']) ) {
        if (!$error) {
            $error = true;
            $prompt_message = $LANGUAGE['s']['_public']['login']['username_error'];
        }
    }else{
        // check the password
        if (preg_match("/^[a-z0-9-_\.]+@([a-z0-9][a-z0-9-]*\.)+[a-z]{2,4}$/i",$value['username'])){
            $sql = "SELECT id, username, password FROM ".DB_TABLE_MEMBER." WHERE email='".$value['username']."'";
        } else {
            $sql = "SELECT id, username, password FROM ".DB_TABLE_MEMBER." WHERE username='".$value['username']."'";
        }
        $result = &$db->Execute($sql);
        if (!$result) {
            $ajax_response->alert($db->ErrorMsg());
        } else {
            if ($result->EOF) {
                if (!$error) {
                    $error = true;
                    $prompt_message = $LANGUAGE['s']['_public']['login']['username_not_exist'];
                }
            } elseif ( $result->fields['password'] != func::str_encrypt($value['password'],$CONFIGURE['sys']['encrypt_mix']) ) {
                if (!$error) {
                    $error = true;
                    $prompt_message = $LANGUAGE['s']['_public']['login']['password_wrong'];
                }
            } else {
                $mid        = $result->fields['id'];
                $musername  = $result->fields['username'];
            }
        }
    }

    if($error){
        $ajax_response->alert($prompt_message);
        $ajax_response->assign($submit,"value",$LANGUAGE['s']['_public']['login']['login_submit']);
        $ajax_response->assign($submit,"disabled",false);
    }else{

        // Front session
        if($value['lifetime'] == "1"){
            $c->set_lifetime("31536000");
        }
        if ($value['lifetime'] == "3600" ||
            $value['lifetime'] == "86400" ||
            $value['lifetime'] == "604800" ||
            $value['lifetime'] == "2592000" ||
            $value['lifetime'] == "31536000" ) {
            $c->set_lifetime($value['lifetime']);
        }
        $c->set_cookie(array(
            $CONFIGURE['sys']['cookie_prefix']."mid"        => $mid,
            $CONFIGURE['sys']['cookie_prefix']."musername"  => $musername,
        ));
        $c->set_session(array(
            "mid"       => $mid,
            "musername" => $musername,
        ));

        if (!empty($PROMPT['prompt_returnurl'])){
            $returnurl_index = $PROMPT['prompt_returnurl'];
        } else {
            $returnurl_index = $CONFIGURE['common']['control_index'];
        }
        $ajax_response->redirect($returnurl_index);
    }
    return $ajax_response;
}
$bwajax->register(XAJAX_FUNCTION, "quick_member_login");

?>