<?php
/*
+-----------------------------------------------------------------------------+
| $Id: login.php 2010-05-24 12:37:44Z Bleakwind $
| Member Login
| Copyright (c) 2003-2010 Bleakwind (www.weaverdream.com)
| http://www.weaverdream.com/
| Release under the GNU Lesser General Public License Version 3 (LGPLv3):
|   http://www.gnu.org/licenses/lgpl.html
+-----------------------------------------------------------------------------+
*/

if (!defined( 'ENTRY_INDEX')){
    echo "<h1>Forbidden</h1><p>You don't have permission to access on this server.</p>";
    exit;
}

// Member login
function login_member($value, $submit)
{
    global $SETTING,$LANGUAGE,$CONFIG,$CONFIGURE,$SESSION,$PROMPT,$db,$sys,$c,$ac;
    $ajax_response = new xajaxResponse();
    //$ajax_response->alert(print_r($value, true)); $ajax_response->assign($submit,"disabled",false); return $ajax_response;

    $error  = false;
    $mid    = "";
    $musername    = "";

    if ( empty($value['verifycode']) || (strtolower($value['verifycode']) != strtolower($SESSION->_['vc_login'])) ) {
        if (!$error) {
            $error = true;
            $prompt_message = "<span class=\"prompt_failed\">".$LANGUAGE['s']['login']['verifycode_error']."</span>";
            $ajax_response->script("xajax_switch_verifycode('vc_login_show','".$CONFIGURE['common']['control_index']."','vc_login');");
        }
    }

    if ( empty($value['password']) ) {
        if (!$error) {
            $error = true;
            $prompt_message = "<span class=\"prompt_failed\">".$LANGUAGE['s']['login']['password_empty']."</span>";
        }
    } elseif ( mb_strwidth($value['password'],"UTF-8") < 4 ||
               mb_strwidth($value['password'],"UTF-8") > 60 ||
               preg_match("/[\x01-\x2E]|[\\x2F]|[\x3A-\x40]|[\x5B-\x5E]|[\x60]|[\x7B-\x7F]/",$value['password']) ) {
        if (!$error) {
            $error = true;
            $prompt_message = "<span class=\"prompt_failed\">".$LANGUAGE['s']['login']['password_error']."</span>";
        }
    }

    $value['username'] = strtolower(trim($value['username']));
    if ( empty($value['username']) ) {
        if (!$error) {
            $error = true;
            $prompt_message = "<span class=\"prompt_failed\">".$LANGUAGE['s']['login']['username_empty']."</span>";
        }
    } elseif ( (mb_strwidth($value['username'],"UTF-8") < 4 ||
                mb_strwidth($value['username'],"UTF-8") > 60 ||
                preg_match("/[\x01-\x2E]|[\\x2F]|[\x3A-\x40]|[\x5B-\x5E]|[\x60]|[\x7B-\x7F]/",$value['username']))
                && !preg_match("/^[a-z0-9-_\.]+@([a-z0-9][a-z0-9-]*\.)+[a-z]{2,4}$/i",$value['username']) ) {
        if (!$error) {
            $error = true;
            $prompt_message = "<span class=\"prompt_failed\">".$LANGUAGE['s']['login']['username_error']."</span>";
        }
    }else{
        // check the password
        if (preg_match("/^[a-z0-9-_\.]+@([a-z0-9][a-z0-9-]*\.)+[a-z]{2,4}$/i",$value['username'])){
            $sql = "SELECT id, username, password FROM ".DB_TABLE_MEMBER." WHERE email='".$value['username']."'";
        } else {
            $sql = "SELECT id, username, password FROM ".DB_TABLE_MEMBER." WHERE username='".$value['username']."'";
        }
        $result = &$db->Execute($sql);
        if (!$result) {
            $ajax_response->alert($db->ErrorMsg());
        } else {
            if ($result->EOF) {
                if (!$error) {
                    $error = true;
                    $prompt_message = "<span class=\"prompt_failed\">".$LANGUAGE['s']['login']['username_not_exist']."</span>";
                }
            } elseif ( $result->fields['password'] != func::str_encrypt($value['password'],$CONFIGURE['sys']['encrypt_mix']) ) {
                if (!$error) {
                    $error = true;
                    $prompt_message = "<span class=\"prompt_failed\">".$LANGUAGE['s']['login']['password_wrong']."</span>";
                }
            } else {
                $mid        = $result->fields['id'];
                $musername  = $result->fields['username'];
            }
        }
    }

    if($error){
        $ajax_response->assign("prompt_message","innerHTML",$prompt_message);
        $ajax_response->assign($submit,"value",$LANGUAGE['s']['login']['login_submit']);
        $ajax_response->assign($submit,"disabled",false);
    }else{

        $ajax_response->assign("prompt_message","innerHTML","");
        // Front session
        if($value['lifetime'] == "1"){
            $c->set_lifetime("31536000");
        }
        if ($value['lifetime'] == "3600" ||
            $value['lifetime'] == "86400" ||
            $value['lifetime'] == "604800" ||
            $value['lifetime'] == "2592000" ||
            $value['lifetime'] == "31536000" ) {
            $c->set_lifetime($value['lifetime']);
        }
        $c->set_cookie(array(
            $CONFIGURE['sys']['cookie_prefix']."mid"        => $mid,
            $CONFIGURE['sys']['cookie_prefix']."musername"  => $musername,
        ));
        $c->set_session(array(
            "mid"       => $mid,
            "musername" => $musername,
        ));

        if (!empty($PROMPT['prompt_returnurl'])){
            $returnurl_index = $PROMPT['prompt_returnurl'];
        } else {
            $returnurl_index = $CONFIGURE['common']['control_index'];
        }
        $ajax_response->redirect($returnurl_index);
    }
    return $ajax_response;
}
$bwajax->register(XAJAX_FUNCTION, "login_member");

if($sys->get['ope'] == "logout"){

    if (!$c->iflogin()){
        $sys->prompt("jump",$CONFIGURE['common']['control_index']."?act=login",$LANGUAGE['s']['login']['no_need_logout']);
    }
    $c->destroy();
    $ac->destroy();

    $sys->prompt("jump", $CONFIGURE['common']['control_index']."");

}else{

    // check login
    if( $MEMBER['iflogin'] == "1" ) {
        $sys->prompt("failed",sprintf($LANGUAGE['s']['login']['already_login'],$MEMBER['username']));
    }
    /////

    // outside prompt message
    if(!empty($sys->get['msg']) || !empty($sys->get['ret'])) {
        $sys->prompt("jump",$CONFIGURE['common']['control_index']."?act=login", $sys->get['msg'], $sys->get['ret']);
    }
    //////

}
$public_var['page_place'][] = $LANGUAGE['s']['login']['page_place'];
?>
