<?php
/*
+-----------------------------------------------------------------------------+
| $Id: search.php 2010-05-24 12:37:44Z Bleakwind $
| Site search
| Copyright (c) 2003-2010 Bleakwind (www.weaverdream.com)
| http://www.weaverdream.com/
| Release under the GNU Lesser General Public License Version 3 (LGPLv3):
|   http://www.gnu.org/licenses/lgpl.html
+-----------------------------------------------------------------------------+
*/

if (!defined( 'ENTRY_INDEX')){
    echo "<h1>Forbidden</h1><p>You don't have permission to access on this server.</p>";
    exit;
}

if ($sys->get['ope'] == "save"){

    $sys->post['search_type']       = strtolower(trim($sys->post['search_type']));
    $sys->get['search_type']        = strtolower(trim($sys->get['search_type']));
    $search_type                    = !empty($sys->post['search_type']) ? $sys->post['search_type'] : $sys->get['search_type'];
    if(!preg_match("/^content$/i", $search_type)){ $search_type = "content"; }
    $sys->post['search_model']      = strtolower(trim($sys->post['search_model']));
    $sys->get['search_model']       = strtolower(trim($sys->get['search_model']));
    $search_model                   = !empty($sys->post['search_model']) ? $sys->post['search_model'] : $sys->get['search_model'];
    if(!preg_match("/^[1-9][0-9]{0,10}$/i", $search_model)){ $search_model = "0"; }
    $sys->post['search_keyword']    = strtolower(trim($sys->post['search_keyword']));
    $sys->get['search_keyword']     = strtolower(trim($sys->get['search_keyword']));
    $search_keyword                 = !empty($sys->post['search_keyword']) ? $sys->post['search_keyword'] : $sys->get['search_keyword'];
    if(empty($search_keyword)){
        $sys->prompt("failed", $LANGUAGE['s']['search']['keyword_empty']);
    } elseif(mb_strwidth($search_keyword,"UTF-8") > 30){
        $sys->prompt("failed", $LANGUAGE['s']['search']['keyword_long']);
    } elseif(in_array($search_keyword, $LANGUAGE['s']['search']['keyword_default'])){
        $sys->prompt("failed", $$LANGUAGE['s']['search']['keyword_default_error']);
    } else {

        $keyword_array = preg_split("/[\s,]+/", $search_keyword);
        if (is_array($keyword_array) && count($keyword_array) > 0) {
            $where_keyword  = "";
            foreach ($keyword_array as $v) {
                $where_keyword .= " AND FIND_IN_SET('".addslashes($v)."', content.keyword) > 0";
            }
            $where_keyword  = substr(trim($where_keyword), 0, 3) == "AND" ? substr(trim($where_keyword), 3) : trim($where_keyword);
        }
        $where = " AND (".$where_keyword.")";

        if (preg_match("/^[1-9][0-9]{0,10}$/i", $search_model)) {
            $where .= " AND channel.setmodel_id=".$search_model."";
        }
        $where  .= " AND ((content.if_enable=1) || (content.if_enable=3 AND content.if_enable_begin<".time()." AND content.if_enable_begin>".time()."))";
        $where = substr(trim($where), 0, 3) == "AND" ? substr(trim($where), 3) : trim($where);
        $where = $where != "" ? "WHERE ".$where : "";
        //////

        $search_result['id_array']   = array();
        $sql = "SELECT scheduler.id as scheduler_id
                FROM ".DB_TABLE_SCHEDULER." scheduler
                    LEFT JOIN ".DB_TABLE_CONTENT." content ON content.content_id=scheduler.content_id
                    LEFT JOIN ".DB_TABLE_CONTENT_COVER." cover ON cover.content_id=scheduler.content_id
                    LEFT JOIN ".DB_TABLE_CHANNEL." channel ON channel.id=scheduler.channel_id
                ".$where."
                GROUP BY scheduler.id
                ORDER BY content.if_top DESC, content.post_time DESC";
        $result = &$db->Execute($sql);
        if (!$result) {
            echo $db->ErrorMsg();
        } else {
            while (!$result->EOF) {
                $search_result['id_array'][] = $result->fields['scheduler_id'];
                $result->MoveNext();
            }
        }

        if (!is_array($search_result['id_array']) || count($search_result['id_array'])<=0) {
            $sys->prompt("failed", $LANGUAGE['s']['search']['result_empty']);
        } else {

            $search_result['id_list'] = implode(",", $search_result['id_array']);
            
            $error = false;
            for($i=0;$i<3;$i++) {
                $search_id = sha1($MEMBER['id'].microtime());
                $total_record = func::db_count_record(DB_TABLE_SEARCH, "sid='".$search_id."'");
                if ($total_record <= 0) {
                    break;
                }else {
                    if ($i == "2") {
                        $error = true;
                        $sys->prompt("failed", $LANGUAGE['s']['search']['build_sid_error']);
                    }
                }
            }
            if (!$error) {
                $sql_data = array(
                    "sid"       => "'".$search_id."'",
                    "type"      => "'".$search_type."'",
                    "keyword"   => "'".$search_keyword."'",
                    "result"    => "'".$search_result['id_list']."'",
                    "mid"       => "'".(int)$MEMBER['id']."'",
                    "time"      => "'".time()."'",
                    "ip"        => "'".func::return_ip()."'",
                );
                $result = func::db_insert(DB_TABLE_SEARCH, $sql_data);
                if (!$result) {
                    $sys->prompt("failed", $LANGUAGE['s']['search']['insert_error']);
                } else {
                    $sys->prompt("jump",$CONFIGURE['common']['control_index']."?act=search&sid=".$search_id."&pag=".$sys->get['pag']);
                }
            }
        }
    }

} else {

    if(!preg_match("/^[a-z0-9_]{40}$/i", $sys->get['sid'])){
        $sys->prompt("failed", $LANGUAGE['s']['search']['sid_error']);
    } else {

        $sid            = $sys->get['sid'];
        $search_info    = func::db_select(DB_TABLE_SEARCH, "*", "sid='".$sid."'");
        $search_info    = $search_info[0];

        if(!preg_match("/^[a-z0-9_]{40}$/i", $search_info['sid'])){
            $sys->prompt("failed", $LANGUAGE['s']['search']['select_sid_error']);
        } else {

            $search_result  = $search_info['result'];
            $search_array   = explode(",", $search_result);
            $total_record   = count($search_array);
            $bwpage->set_record($total_record);
            $bwpage->set_record_listnum($CONFIG['page_record_content_search']);
            $bwpage->page($CONFIGURE['common']['control_index']."?act=search&sid=".$sid."&pag=%s");
            $sql = "SELECT scheduler.id as scheduler_id,
                        content.*,
                        cover.id as cover_id, cover.dir as cover_dir, cover.filename as cover_filename,
                        channel.id as channel_id, channel.name as channel_name
                    FROM ".DB_TABLE_SCHEDULER." scheduler
                        LEFT JOIN ".DB_TABLE_CONTENT." content ON content.content_id=scheduler.content_id
                        LEFT JOIN ".DB_TABLE_CONTENT_COVER." cover ON cover.content_id=scheduler.content_id
                        LEFT JOIN ".DB_TABLE_CHANNEL." channel ON channel.id=scheduler.channel_id
                    WHERE scheduler.id IN (".$search_result.")
                        AND ((content.if_enable=1) || (content.if_enable=3 AND content.if_enable_begin<".time()." AND content.if_enable_begin>".time()."))
                    GROUP BY scheduler.id
                    ORDER BY content.if_top DESC, content.post_time DESC
                    LIMIT ".$bwpage->record_listfirst.",".$bwpage->record_listnum;
            $result = &$db->Execute($sql);
            if (!$result) {
                echo $db->ErrorMsg();
            } else {
                while (!$result->EOF) {
                    $search_content_list[] = array(
                        'scheduler_id'              => $result->fields['scheduler_id'],

                        'content_id'                => $result->fields['content_id'],
                        'phrase'                    => $result->fields['phrase'],
                        'phrase_len'                => mb_strwidth($result->fields['phrase'],"UTF-8"),
                        'subject'                   => $result->fields['subject'],
                        'subject_len'               => mb_strwidth($result->fields['subject'],"UTF-8"),
                        'color'                     => $result->fields['color'],
                        'fontstyle'                 => $result->fields['fontstyle'],
                        'decoration'                => $result->fields['decoration'],
                        'prefix'                    => $result->fields['prefix'],
                        'author'                    => $result->fields['author'],
                        'excerpt'                   => $result->fields['excerpt'],
                        'template_content'          => $result->fields['template_content'],
                        'click'                     => $result->fields['click'],
                        'keyword'                   => $result->fields['keyword'],
                        'brief'                     => $result->fields['brief'],
                        'post_id'                   => $result->fields['post_id'],
                        'post_username'             => $result->fields['post_username'],
                        'post_ip'                   => $result->fields['post_ip'],
                        'post_time'                 => $result->fields['post_time'],
                        'verify_id'                 => $result->fields['verify_id'],
                        'verify_username'           => $result->fields['verify_username'],
                        'verify_ip'                 => $result->fields['verify_ip'],
                        'verify_time'               => $result->fields['verify_time'],
                        'if_enable'                 => $result->fields['if_enable'],
                        'if_enable_begin'           => $result->fields['if_enable_begin'],
                        'if_enable_end'             => $result->fields['if_enable_end'],
                        'if_top'                    => $result->fields['if_top'],
                        'if_top_begin'              => $result->fields['if_top_begin'],
                        'if_top_end'                => $result->fields['if_top_end'],
                        'if_view'                   => $result->fields['if_view'],
                        'if_view_privilege'         => $result->fields['if_view_privilege'],
                        'if_inerface'               => $result->fields['if_inerface'],
                        'if_inerface_privilege'     => $result->fields['if_inerface_privilege'],
                        'if_inerface_identity'      => $result->fields['if_inerface_identity'],
                        'if_inerface_check'         => $result->fields['if_inerface_check'],
                        'if_turn'                   => $result->fields['if_turn'],
                        'if_turn_type'              => $result->fields['if_turn_type'],
                        'if_turn_url'               => $result->fields['if_turn_url'],
                        'rank'                      => $result->fields['rank'],

                        'cover_id'                  => $result->fields['cover_id'],
                        'cover_dir'                 => $result->fields['cover_dir'],
                        'cover_filename'            => $result->fields['cover_filename'],

                        'channel_id'                => $result->fields['channel_id'],
                        'channel_name'              => $result->fields['channel_name'],
                        'channel_name_len'          => mb_strwidth($result->fields['channel_name'],"UTF-8"),
                    );
                    $result->MoveNext();
                }
            }
            if (!is_array($search_content_list) || count($search_content_list)<=0) {
                $sys->prompt("failed", $LANGUAGE['s']['search']['result_empty']);
            } else {
                $t->assign(array(
                    "search_info"           => $search_info,
                    "search_content_list"   => $search_content_list,
                    "pagination"            => $bwpage->pagination,
                ));
            }
        }
    }
}
$public_var['page_place'][] = $LANGUAGE['s']['search']['page_place'];
?>
