DROP TABLE IF EXISTS `pw_admin`;

CREATE TABLE `pw_admin` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `admin_user` varchar(50) NOT NULL,
  `admin_pwd` varchar(32) NOT NULL,
  `flag` smallint(2) DEFAULT '999',
  `pri_config` text,
  `last_login` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `last_login_ip` varchar(20) DEFAULT NULL,
  `add_user` varchar(50) DEFAULT NULL,
  `add_time` datetime DEFAULT NULL,
  `is_orgin` tinyint(5) DEFAULT '0',
  PRIMARY KEY (`id`)
)ENGINE=MyISAM;


DROP TABLE IF EXISTS `pw_ads`;

CREATE TABLE `pw_ads` (
  `ads_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `ads_name` varchar(50) NOT NULL,
  `ads_type` varchar(10) NOT NULL,
  `ads_pass` int(11) NOT NULL DEFAULT '0',
  `ads_begintime` int(11) NOT NULL,
  `ads_endtime` int(11) NOT NULL,
  `ads_place_id` int(11) NOT NULL,
  `ads_text` text NOT NULL,
  PRIMARY KEY (`ads_id`)
)ENGINE=MyISAM;

DROP TABLE IF EXISTS `pw_ads_place`;

CREATE TABLE `pw_ads_place` (
  `place_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `place_name` varchar(50) DEFAULT NULL,
  `place_desc` varchar(200) DEFAULT NULL,
  `place_width` int(11) DEFAULT NULL,
  `place_height` int(11) DEFAULT NULL,
  PRIMARY KEY (`place_id`)
)ENGINE=MyISAM;

DROP TABLE IF EXISTS `pw_category`;

CREATE TABLE `pw_category` (
  `category_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `category_name` varchar(200) NOT NULL DEFAULT '',
  `channel_id` varchar(50) NOT NULL DEFAULT '',
  `channel_model` tinyint(4) DEFAULT '1',
  `parent_id` int(11) unsigned NOT NULL DEFAULT '0',
  `category_desc` mediumtext,
  `post_num` int(11) unsigned DEFAULT '0',
  `index_img` varchar(255) DEFAULT NULL,
  `order_num` int(11) unsigned DEFAULT '0',
  `allow_html` tinyint(1) DEFAULT '0',
  `html_dir` varchar(255) DEFAULT NULL,
  `allow_post` tinyint(1) unsigned DEFAULT '0',
  `is_link` tinyint(1) DEFAULT '0',
  `link_url` varchar(255) DEFAULT NULL,
  `category_pass` varchar(50) DEFAULT NULL,
  `seo_info` text,
  `user_group` int(11) DEFAULT '1',
  `cfg` text,
  `total` int(11) DEFAULT '0',
  `cate_sign` varchar(50) DEFAULT NULL,
  `in_nav` int(11) DEFAULT '0',
   `tpl_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`category_id`),
  KEY `order_num` (`order_num`)
)ENGINE=MyISAM;

DROP TABLE IF EXISTS `pw_channel`;

CREATE TABLE `pw_channel` (
  `channel_id` int(4) unsigned NOT NULL AUTO_INCREMENT,
  `channel_name` varchar(200) DEFAULT NULL,
  `channel_model` tinyint(4) DEFAULT '1',
  `menu_show` smallint(2) DEFAULT '1',
  `channel_desc` text,
  `order_num` int(4) DEFAULT '0',
  `out_link` varchar(200) DEFAULT '0',
  `allow_html` tinyint(1) DEFAULT '0',
  `html_dir` varchar(255) DEFAULT NULL,
  `is_hidden` tinyint(1) DEFAULT '1',
  `opt_time` int(10) DEFAULT NULL,
  `user_group` int(11) DEFAULT NULL,
  `display_num` int(10) DEFAULT '10',
   `channel_tpl_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`channel_id`)
)ENGINE=MyISAM;

DROP TABLE IF EXISTS `pw_comment`;

CREATE TABLE `pw_comment` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `data_id` int(11) NOT NULL,
  `category_id` int(11) NOT NULL,
  `user_id` int(11) DEFAULT '0',
  `user_name` varchar(30) NOT NULL DEFAULT '',
  `user_mail` varchar(200) DEFAULT NULL,
  `content` text NOT NULL,
  `rank` tinyint(1) NOT NULL DEFAULT '0',
  `post_time` datetime DEFAULT NULL,
  `post_ip` varchar(15) DEFAULT NULL,
  `state` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `data_id` (`data_id`),
  KEY `cate_id` (`category_id`)
)ENGINE=MyISAM;

DROP TABLE IF EXISTS `pw_contents`;

CREATE TABLE `pw_contents` (
  `c_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `passwords` varchar(50) DEFAULT NULL,
  `short_title` varchar(150) DEFAULT NULL,
  `long_title` varchar(255) DEFAULT NULL,
  `short_content` text,
  `content` longtext,
  `is_hot` tinyint(4) DEFAULT '0',
  `thumb` varchar(255) DEFAULT NULL,
  `is_show` tinyint(4) DEFAULT '1',
  `is_pic` tinyint(4) DEFAULT '0',
  `is_new` tinyint(4) DEFAULT '0',
  `is_top` tinyint(4) DEFAULT '0',
  `is_recycle` tinyint(4) DEFAULT '0',
  `post_time` int(11) DEFAULT NULL,
  `edit_time` int(11) DEFAULT NULL,
  `hits` int(11) DEFAULT NULL,
  `down_times` int(11) DEFAULT NULL,
  `post_user` varchar(50) DEFAULT NULL,
  `out_link` varchar(255) DEFAULT NULL,
  `channel_model` tinyint(10) DEFAULT NULL,
  `channel_id` int(10) DEFAULT NULL,
  `category_id` int(11) DEFAULT NULL,
  `source` varchar(255) DEFAULT NULL,
  `ding_num` int(11) DEFAULT NULL,
  `cai_num` int(11) DEFAULT NULL,
  `ip` varchar(30) DEFAULT NULL,
  `type_id` int(10) unsigned DEFAULT NULL,
  `seo` text,
  `is_index_slide` tinyint(4) DEFAULT '0',
  `big_pic` varchar(255) DEFAULT NULL,
  `attach_size` varchar(50) DEFAULT NULL,
  `attach_link_1` varchar(255) DEFAULT NULL,
  `attach_link_2` varchar(255) DEFAULT NULL,
  `attach_link_3` varchar(255) DEFAULT NULL,
  `top_news` tinyint(4) DEFAULT '0',
  `product_price` float DEFAULT '0',
  PRIMARY KEY (`c_id`),
  KEY `t1` (`is_hot`,`is_show`,`is_pic`,`is_new`,`is_top`,`is_recycle`,`channel_id`,`category_id`,`type_id`),
  KEY `t2` (`c_id`,`is_hot`,`is_show`),
  KEY `t3` (`c_id`,`is_hot`,`is_top`),
  KEY `t4` (`c_id`,`is_recycle`),
  KEY `t5` (`c_id`,`channel_id`,`category_id`),
  KEY `t7` (`c_id`,`is_show`,`is_recycle`),
  KEY `type_id` (`type_id`),
  KEY `is_new` (`is_new`),
  KEY `is_top` (`is_top`),
  KEY `is_recycle` (`is_recycle`),
  KEY `category_id` (`category_id`),
  KEY `channel_id` (`channel_id`),
  KEY `channel_model` (`channel_model`),
  KEY `is_hot` (`is_hot`)
)ENGINE=MyISAM;

DROP TABLE IF EXISTS `pw_core_file`;

CREATE TABLE `pw_core_file` (
  `fid` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `source_file` varchar(255) DEFAULT NULL,
  `file_name` varchar(100) DEFAULT NULL,
  `type` varchar(15) DEFAULT 'default',
  `create_time` int(10) DEFAULT NULL,
  `file_size` varchar(20) DEFAULT NULL,
  `system` varchar(10) DEFAULT 'no',
  PRIMARY KEY (`fid`)
)ENGINE=MyISAM;

DROP TABLE IF EXISTS `pw_core_setting`;

CREATE TABLE `pw_core_setting` (
  `s_name` varchar(200) DEFAULT NULL,
  `s_data` text
)ENGINE=MyISAM;

DROP TABLE IF EXISTS `pw_error_log`;

CREATE TABLE `pw_error_log` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `info` varchar(255) NOT NULL,
  `file` varchar(100) NOT NULL,
  `time` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `time` (`time`)
)ENGINE=MyISAM;

DROP TABLE IF EXISTS `pw_extend_attr`;

CREATE TABLE `pw_extend_attr` (
  `attr_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `attr_name` varchar(50) DEFAULT NULL,
  `attr_value` text,
  `attr_type_id` int(10) DEFAULT NULL,
  `input_model` tinyint(4) DEFAULT '1',
  UNIQUE KEY `attr_id` (`attr_id`),
  KEY `attr_type_id` (`attr_type_id`)
)ENGINE=MyISAM;

DROP TABLE IF EXISTS `pw_extend_type`;

CREATE TABLE `pw_extend_type` (
  `type_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `type_name` varchar(200) DEFAULT NULL,
  `type_desc` text,
  PRIMARY KEY (`type_id`)
)ENGINE=MyISAM;

DROP TABLE IF EXISTS `pw_extend_type_attr_bind`;

CREATE TABLE `pw_extend_type_attr_bind` (
  `b_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `article_id` int(11) DEFAULT NULL,
  `value` text,
  `type_id` int(11) DEFAULT NULL,
  `attr_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`b_id`),
  KEY `type_id` (`type_id`),
  KEY `attr_id` (`attr_id`),
  KEY `article_id` (`article_id`)
)ENGINE=MyISAM;

DROP TABLE IF EXISTS `pw_link`;

CREATE TABLE `pw_link` (
  `id` smallint(6) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL DEFAULT '',
  `tid` smallint(5) unsigned NOT NULL DEFAULT '0',
  `type` varchar(4) NOT NULL DEFAULT 'text',
  `url` varchar(60) NOT NULL DEFAULT '',
  `intro` varchar(200) NOT NULL DEFAULT '',
  `email` varchar(50) NOT NULL DEFAULT '',
  `logo` char(200) NOT NULL DEFAULT '',
  `add_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `order_num` int(6) NOT NULL DEFAULT '0',
  `state` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `tid` (`tid`),
  KEY `state` (`state`),
  KEY `order_num` (`order_num`)
)ENGINE=MyISAM;

DROP TABLE IF EXISTS `pw_link_type`;

CREATE TABLE `pw_link_type` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
)ENGINE=MyISAM;

DROP TABLE IF EXISTS `pw_logs`;

CREATE TABLE `pw_logs` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(50) DEFAULT 'operation',
  `manager` varchar(50) DEFAULT NULL,
  `content` text,
  PRIMARY KEY (`id`)
)ENGINE=MyISAM;

DROP TABLE IF EXISTS `pw_mail_tpl`;

CREATE TABLE `pw_mail_tpl` (
  `tpl_id` tinyint(1) unsigned NOT NULL AUTO_INCREMENT,
  `tpl_name` varchar(30) NOT NULL,
  `is_html` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `tpl_subject` varchar(200) NOT NULL,
  `mail_tile` varchar(200) NOT NULL,
  `mail_content` text NOT NULL,
  `last_modify` datetime NOT NULL,
  `last_send` datetime NOT NULL,
  `tpl_desc` varchar(255) DEFAULT NULL,
  `tpl_open` tinyint(5) DEFAULT '0',
  PRIMARY KEY (`tpl_id`),
  UNIQUE KEY `template_code` (`tpl_name`)
)ENGINE=MyISAM;

DROP TABLE IF EXISTS `pw_model`;

CREATE TABLE `pw_model` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `cn_name` varchar(100) DEFAULT NULL,
  `en_name` varchar(30) DEFAULT NULL,
  `use_default` tinyint(2) NOT NULL DEFAULT '1',
  `is_sys` tinyint(2) NOT NULL DEFAULT '0',
  `state` tinyint(2) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
)ENGINE=MyISAM;

DROP TABLE IF EXISTS `pw_navigation`;

CREATE TABLE `pw_navigation` (
  `nav_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `nav_name` varchar(50) DEFAULT NULL,
  `nav_sort` int(11) DEFAULT NULL,
  `nav_link` varchar(255) DEFAULT NULL,
  `nav_blank` varchar(20) DEFAULT NULL,
  `nav_position` varchar(20) DEFAULT NULL,
  `nav_display` tinyint(4) DEFAULT NULL,
  PRIMARY KEY (`nav_id`)
)ENGINE=MyISAM;

DROP TABLE IF EXISTS `pw_notice`;

CREATE TABLE `pw_notice` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(255) DEFAULT NULL,
  `content` mediumtext,
  `hits` int(10) DEFAULT '0',
  `post_time` datetime DEFAULT NULL,
  `is_top` tinyint(1) DEFAULT '0',
  `url` varchar(50) DEFAULT NULL,
  `state` smallint(2) DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `n_id` (`id`),
  KEY `n_state` (`state`),
  KEY `post_time` (`post_time`)
)ENGINE=MyISAM;

DROP TABLE IF EXISTS `pw_poll_record`;

CREATE TABLE `pw_poll_record` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `poll_id` int(11) NOT NULL,
  `ip` varchar(15) NOT NULL,
  `time` int(11) NOT NULL,
  PRIMARY KEY (`id`)
)ENGINE=MyISAM;

DROP TABLE IF EXISTS `pw_single_page`;

CREATE TABLE `pw_single_page` (
  `id` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(60) NOT NULL DEFAULT '',
  `is_make` tinyint(6) NOT NULL DEFAULT '0',
  `keywords` varchar(30) NOT NULL DEFAULT '',
  `description` varchar(250) NOT NULL DEFAULT '',
  `template` varchar(30) NOT NULL DEFAULT '',
  `body` text,
  `url` varchar(60) NOT NULL DEFAULT '',
  `uptime` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `state` tinyint(1) DEFAULT '1',
  `file_name` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ismake` (`is_make`,`uptime`)
)ENGINE=MyISAM;

DROP TABLE IF EXISTS `pw_user_favor`;

CREATE TABLE `pw_user_favor` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `title` varchar(100) NOT NULL,
  `type` varchar(50) DEFAULT NULL,
  `content` varchar(120) NOT NULL,
  `isback` int(4) NOT NULL DEFAULT '0',
  `add_time` int(11) NOT NULL,
  `back_time` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`),
  KEY `level` (`isback`)
)ENGINE=MyISAM;

DROP TABLE IF EXISTS `pw_user_group`;

CREATE TABLE `pw_user_group` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `pri_config` text,
  `state` tinyint(2) NOT NULL DEFAULT '1',
  `is_system` tinyint(4) DEFAULT '0',
  PRIMARY KEY (`id`)
)ENGINE=MyISAM;

DROP TABLE IF EXISTS `pw_user_info`;

CREATE TABLE `pw_user_info` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `login_name` varchar(50) NOT NULL,
  `login_pwd` varchar(32) DEFAULT NULL,
  `pay_pwd` varchar(32) DEFAULT NULL,
  `email` varchar(100) DEFAULT NULL,
  `e_auth` tinyint(1) NOT NULL DEFAULT '0',
  `integral` int(10) NOT NULL DEFAULT '0',
  `money` decimal(10,2) NOT NULL DEFAULT '0.00',
  `v_money` int(10) DEFAULT '0',
  `nick_name` varchar(50) DEFAULT NULL,
  `true_name` varchar(50) DEFAULT NULL,
  `sex` varchar(10) NOT NULL DEFAULT '',
  `id_type` tinyint(1) NOT NULL DEFAULT '1',
  `id_card` varchar(20) DEFAULT NULL,
  `birthday` varchar(11) DEFAULT '0',
  `province` varchar(30) DEFAULT NULL,
  `city` varchar(30) DEFAULT NULL,
  `telephone` varchar(20) DEFAULT NULL,
  `mobile` varchar(20) DEFAULT NULL,
  `m_auth` tinyint(1) NOT NULL DEFAULT '0',
  `address` varchar(200) DEFAULT NULL,
  `zipcode` varchar(10) DEFAULT NULL,
  `work` varchar(50) DEFAULT NULL,
  `work_place` varchar(100) DEFAULT NULL,
  `education` varchar(20) DEFAULT NULL,
  `income` varchar(20) DEFAULT NULL,
  `level` int(3) DEFAULT '0',
  `qq` varchar(30) DEFAULT NULL,
  `msn` varchar(100) DEFAULT NULL,
  `homepage` varchar(200) DEFAULT NULL,
  `accountname` varchar(50) DEFAULT NULL,
  `bank` varchar(20) DEFAULT NULL,
  `bankname` varchar(20) DEFAULT NULL,
  `bankacc` varchar(200) DEFAULT NULL,
  `question` varchar(200) DEFAULT NULL,
  `answer` varchar(200) DEFAULT NULL,
  `bak_question` varchar(200) DEFAULT NULL,
  `bak_answer` varchar(200) DEFAULT NULL,
  `head_pic` varchar(200) DEFAULT '/files/common/image/no_head_pic.jpg',
  `user_sign` varchar(150) DEFAULT NULL,
  `user_interest` mediumtext,
  `reg_time` int(11) NOT NULL,
  `day_login` mediumint(4) NOT NULL DEFAULT '0',
  `total_login` int(11) NOT NULL DEFAULT '0',
  `login_ip` varchar(15) DEFAULT NULL,
  `login_time` int(11) NOT NULL DEFAULT '0',
  `group_id` tinyint(2) NOT NULL DEFAULT '1',
  `play_game` varchar(255) DEFAULT NULL,
  `agent_id` int(11) NOT NULL DEFAULT '0',
  `state` tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `state` (`state`),
  KEY `login_name` (`login_name`),
  KEY `group_id` (`group_id`),
  KEY `sex` (`sex`),
  KEY `level` (`level`),
  KEY `email` (`email`),
  KEY `money` (`money`),
  KEY `city` (`city`),
  KEY `province` (`province`),
  KEY `tg_id` (`agent_id`),
  KEY `accountname` (`accountname`)
)ENGINE=MyISAM;

DROP TABLE IF EXISTS `pw_user_option`;

CREATE TABLE `pw_user_option` (
  `option_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(50) DEFAULT NULL,
  `option_ticket` int(15) DEFAULT '0',
  `option_poll_id` int(11) NOT NULL,
  PRIMARY KEY (`option_id`)
)ENGINE=MyISAM;

DROP TABLE IF EXISTS `pw_user_poll`;

CREATE TABLE `pw_user_poll` (
  `poll_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `poll_title` varchar(100) NOT NULL,
  `poll_desc` varchar(200) DEFAULT NULL,
  `poll_type` varchar(10) NOT NULL DEFAULT 'radio',
  PRIMARY KEY (`poll_id`)
)ENGINE=MyISAM;

DROP TABLE IF EXISTS `pw_user_request`;

CREATE TABLE `pw_user_request` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `user_name` varchar(50) DEFAULT NULL,
  `title` varchar(100) DEFAULT NULL,
  `type` varchar(50) DEFAULT NULL,
  `content` text NOT NULL,
  `state` int(4) NOT NULL DEFAULT '0',
  `post_time` int(11) NOT NULL,
  `back_time` int(11) DEFAULT NULL,
  `admin_name` varchar(50) DEFAULT NULL,
  `admin_content` text,
  `request_type` varchar(10) NOT NULL DEFAULT 'request',
  `ip` varchar(15) DEFAULT NULL,
  `c_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`),
  KEY `level` (`state`)
)ENGINE=MyISAM;