function $(o){if(document.getElementById&&document.getElementById(o)){return document.getElementById(o);}else if(document.all&&document.all(o)){return document.all(o);}else if(document.layers&&document.layers[o]){return document.layers[o];}else{return false;}}
var isIE=!-[1,];

function addEventHandler(oTarget, sEventType, fnHandler) {
	if (oTarget.addEventListener) {
		oTarget.addEventListener(sEventType, fnHandler, false);
	} else if (oTarget.attachEvent) {
		oTarget.attachEvent("on" + sEventType, fnHandler);
	} else {
		oTarget["on" + sEventType] = fnHandler;
	}
};

function removeEventHandler(oTarget, sEventType, fnHandler) {
    if (oTarget.removeEventListener) {
        oTarget.removeEventListener(sEventType, fnHandler, false);
    } else if (oTarget.detachEvent) {
        oTarget.detachEvent("on" + sEventType, fnHandler);
    } else { 
        oTarget["on" + sEventType] = null;
    }
};

AvatarEditor = function(){
	this.editorDom = null; // ༭
	this.editPic = null; // ༭ͼƬ
	this.editorWidth = 560; // ༭ĬϿ
	this.editorHeight = 420; // ༭Ĭϸ߶
	this.scale = 1;
	this.offsetX = 0;
	this.offsetY = 0;
	this.previewer = null; //Ԥ
	this.masks = {}; //ֲ
	this.maskColor = '#000000'; //ɫ
	this.maskEl = '';
	this.opacity = 0.8; //͸
	this.drager = null; //϶
	this.dragerWidth = 120;//϶ĬϿ
	this.dragerHeight = 120;//϶ĬϿ
	this.minWidth = 120; //϶С
	this.minHeight = 120; //϶С߶
	this.useScale = true; //϶Ƿ񰴱
	this.previewerWidth = 120,
	this.previewerHeight = 120;
	this.picWidth = 0;
	this.zoombarButton = null;
	this.maxScale = 16;
	this.uploadButton = '';
	this.loading = null;
};
AvatarEditor.prototype = {
	init:function(){
		var e;
		e = $(this.editorDom);
		if(!e){
			alert('Ҳ༭' + this.editorDom);
			return ;
		}
		this.editorDom = e;
		
		e = $(this.previewer);
		if(!e){
			alert('ҲԤ' + this.previewer);
		}else{
			this.previewerCt = e;
			this.previewer = this.previewerCt.appendChild(document.createElement("img"));
			this.previewer.show = this.show;
			this.previewer.hide = this.hide;
			this.previewer.hide();
		}
		
		e = $(this.uploadButton);
		if(!e){
			alert('Ҳϴť' + this.uploadButton);
			return ;
		}
		this.uploadButton = e;
		this.initUploader();
		
		e = $(this.commitBtn);
		if(!e){
			//alert('Ҳͷť: ' + this.commitBtn);
		}
		this.commitBtn = e;
		//this.selectorInfo = $(this.selectorInfo);
		this.setEditorDom();
	},
	
	initUploader:function(){
		var _this = this;
		this.swfupload = new SWFUpload({
			// Backend Settings
			upload_url: window.location.href,
			use_query_string:true,
			// File Upload Settings
			post_params:{session_id : swfupload_session_id, action:'uploadavatar',ajax:1},
			file_post_name : 'AVATAR',
			file_size_limit : "3072",	// 3M
			file_types : "*.jpg;*.jpeg;*.png;*.gif;*.bmp",
			file_types_description : "All Files",
			file_upload_limit : 0,
			file_queue_limit : 0,
			// Event Handler Settings (all my handlers are in the Handler.js file)
			
			swfupload_preload_handler : function(){_this.mask('ڼϴ', 'ڼ swfupload ϴԺ...');_this.maskEl.button.hide()},
			swfupload_loaded_handler : function(){_this.unMask()},
			swfupload_load_failed_handler : function(m){alert(m);_this.unMask()},
			file_dialog_start_handler : function(){},
			file_queued_handler : function(f){
				_this.mask('ϴͼƬ','ϴͼƬ '+f.name+'Ժ...', true);
				_this.maskEl.button.value = 'ȡϴ';
				_this.maskEl.button.show();
				_this.maskEl.button.onclick = function(f){_this.swfupload.cancelUpload(f.id);_this.unMask();}
				_this.progressBar.show();
				_this.progressBar.setText('0%');
				_this.progressBar.setPercent(0);
				_this.swfupload.startUpload(f.id);
			},
			file_queue_error_handler : function(f,e,m){alert('ϴͼƬ̫ѡ(ܳ3M)')},
			file_dialog_complete_handler : function(ns,nq,t){},
			upload_start_handler : function(f){},
			upload_progress_handler : function(f,c,t){
				var p = ((c/t)*100).toFixed(2);
				_this.progressBar.setText(p+'%,'+SWFUpload.speed.formatBPS(f.currentSpeed));
				_this.progressBar.setPercent(p);
			},
			upload_error_handler : function(f,e,m){alert(m)},
			upload_success_handler : function(f,d,r){
				_this.progressBar.hide();
				_this.unMask();
				var v = ajax.jsondecode(d);
				aaaaaa = v;
				if(v.success == 1){
					_this.load(v.avatar);
				}else if(v.success == 0){
					alert(v.message)
				}else if(v.success == -1){
					alert('¼ʱµ¼');
				}else{
					alert('쳣µ¼');
				}
			},
			upload_complete_handler : function(f){},
			// Button Settings
			button_window_mode: SWFUpload.WINDOW_MODE.TRANSPARENT,
			button_placeholder_id : "account-avatar-swfupload-btn",
			button_width: 98,
			button_height: 22,
			// Flash Settings
			flash_url : flash_url,
			flash9_url : flash9_url,
			custom_settings:{},
			debug: false
		});
	},
	
	load:function(src){
		if(src.indexOf('http://') > 0) src = window.location.href.substr(0, window.location.href.lastIndexOf('/')+1) + src;
		if(!this.editPic){
			var _this = this;
			this.loading = this.createEl('div', null, 'i-e-loading');
			this.loading.innerHTML = 'ͼƬ...';
			this.editorDom.appendChild(this.loading);
			
			this.loading.show = this.show;
			this.loading.hide = this.hide;
			this.editPic = document.createElement('img');
			this.editPic.onload = function(){
				if(!_this.isloaded) _this.loaded();
			}
			this.editPic.show = this.show;
			this.editPic.hide = this.hide;
			this.editorDom.appendChild(this.editPic);
		}else{
			this.isEditing = true;
			this.editPic.show();
			this.previewer.show();
		}
		this.isloaded = false;
		if(this.selector) this.selector.hide();
		this.loading.show();
		this.editPic.avatar = src;
		src += '?' + new Date();
		this.editPic.src = src;
		if(document.readyState == 'complete' && !this.isloaded) this.loaded();
	},
	
	loaded:function(){
		this.isloaded = true;
		this.isEditing = true;
		this.unMask();
		this.loading.hide();
		if(this.isRender){
			if(!this.setEditPic()) return;
			this.selector.show();
		}else{
			this.isRender = true;
			this.initZoombar();
			this.createSelector();
			if(!this.setEditPic()) return;
		}
		this.setSelector(-1);
		this.setZoomScale();
		this.setZoomPosition();
	},
	
	setEditorDom:function(){
		this.editorDom.onselectstart = function(){return false;}
		this.editorDom.style.overflow = 'hidden';
		this.editorDom.style.width = this.editorWidth + 'px';
		this.editorDom.style.height = this.editorHeight + 'px';
		this.editorDom.style.position = 'relative';
		this.editorDom.style.cursor = 'default';
	},
	
	//ͼƬ
	setEditPic:function(){
		var img = new Image();
		img.src = this.editPic.src;
		this.previewer.src = this.editPic.src;
		this.setStyle(this.previewerCt.parentNode, {backgroundColor:'#FFFFFF'});
		this.previewer.show();
		var w,ew,h,eh;

		if(isIE){if(img.readyState=='complete'){w = ew = img.width;h = eh = img.height}}
		else(img.complete)
		{w = ew = img.width;h = eh = img.height;}
	
		if(!w){
			this.editPic.style.width = 'auto';
			if(!w) {
				var tthis=this;
				window.setTimeout(function(){
					tthis.loaded()
				},100);
				return false;
			}
		}
		this.picOw = w;
		this.picOh = h;
		if(w <= this.editorWidth && h <= this.editorHeight){
			this.scale = 1;
			this.offsetX = (this.editorWidth - w)/2;
			this.offsetY = (this.editorHeight - h)/2;
		}else{
			if((this.editorHeight / this.editorWidth) < (h / w)){
				eh = this.editorHeight;
				this.offsetY = 0;
				this.scale = eh / h;
				ew = this.scale * w;
				this.offsetX = (this.editorWidth - ew) / 2;
				
			}else{
				ew = this.editorWidth;
				this.offsetX = 0;
				this.scale = ew / w;
				eh = this.scale * h;
				this.offsetY = (this.editorHeight - eh) / 2;
			}
		}
		this.Oscale =  this.scale;
		if(w <= this.previewerWidth && h <= this.previewerHeight){
			this.minScale = 1;
			this.zoomPixWidth = [0, 278.6428675742993 / (this.zoombarWidth*2)];
		}else{
			if((this.previewerHeight / this.previewerWidth) < (h / w)){
				this.minScale = this.previewerWidth / w;
			}else{
				this.minScale = this.previewerHeight / h;
			}
			this.minScale = Math.max(this.minScale, 0.01);
			this.zoomPixWidth = [];
			this.zoomPixWidth[0] = (1 - this.minScale) / this.zoombarWidth;
			this.zoomPixWidth[1] = (Math.log(this.maxScale) / Math.log(1.01)) / this.zoombarWidth;
		}
		this.editPic.style.width = ew + 'px';
		//this.editPic.height = eh;
		this.dW = Math.min(ew, this.dragerWidth);
		this.dH = Math.min(eh, this.dragerHeight);
		
		this.editPic.style.marginTop = this.offsetY + 'px';
		this.editPic.style.marginLeft = this.offsetX + 'px';
		//this.editPic.style.position = 'absolute';
		//this.editPic.style.display = 'block';
		return true;
	},
	
	createSelector:function(){
		this.selector = this.createEl('DIV',{position:'absolute', left:0, top:0, width:'100%', height:'100%'});
		this.selector.show = this.show;
		this.selector.hide = this.hide;
		this.editorDom.appendChild(this.selector);
		this.masks.top = this.randarMask({});
		this.selector.appendChild(this.masks.top);
		this.masks.left = this.randarMask({cssFloat:'left', styleFloat:'left'});
		this.selector.appendChild(this.masks.left);
		this.selector.appendChild(this.createDrager());
		this.masks.right = this.randarMask({cssFloat:'right',styleFloat:'right'});
		this.selector.appendChild(this.masks.right);
		this.masks.bottom = this.randarMask({clear:'both'});
		this.selector.appendChild(this.masks.bottom);
	},
	
	setSelector:function(x,y,flag,sizeTip){
		var nW, nH;
		if(typeof x == 'undefined'){
			var f = true;
			if(this.masks.left.offsetWidth < this.editPic.offsetLeft){
				x = this.editPic.offsetLeft;
				f = false;
			}else if((this.masks.left.offsetWidth+this.drager.offsetWidth)>(this.editPic.offsetLeft+this.editPic.offsetWidth)){
				x = (this.editPic.offsetLeft+this.editPic.offsetWidth) - this.drager.offsetWidth;
				f = false;
			}
			if(this.masks.top.offsetHeight < this.editPic.offsetTop){
				y = this.editPic.offsetTop;
				f = false;
			}else if((this.masks.top.offsetHeight+this.drager.offsetHeight)>(this.editPic.offsetTop+this.editPic.offsetHeight)){
				y = (this.editPic.offsetTop+this.editPic.offsetHeight) - this.drager.offsetHeight;
				f = false;
			}
			
			if((this.drager.offsetWidth < this.previewerWidth || this.drager.offsetHeight < this.previewerHeight) && (this.editPic.offsetWidth > this.drager.offsetWidth || this.editPic.offsetHeight > this.drager.offsetHeight)){
				nW = this.previewerWidth;
				nH = this.previewerHeight;
				
				f = false;
			}
			if(f) return ;
			flag = true;
		}
		if(flag > 1){
			nW = x;
			nH = y;
			if(flag == 3){
				this.dW = x;
				this.dH = y;
			}
			x = this.dragerOffsetX;
			y = this.dragerOffsetY;
		}
		
		this.dW = this.dW ? this.dW : this.dragerWidth;
		this.dH = this.dH ? this.dH : this.dragerHeight;
		nW = nW ? nW : this.dW;
		nH = nH ? nH : this.dH;
		nW = Math.min(nW, this.editPic.offsetWidth);
		nH = Math.min(nH, this.editPic.offsetHeight);
		var offsetX = 0, offsetY = 0;
		if(x >= 0){
			offsetX = x;
		}else{
			offsetX = this.dragerOffsetX = (this.editorWidth - nW) / 2;
		}
		
		if(y >= 0){
			offsetY = y;
		}else{
			offsetY = this.dragerOffsetY = (this.editorHeight - nH) / 2;
		}
		
		if(flag && flag !=2){
			this.dragerOffsetX = offsetX;
			this.dragerOffsetY = offsetY;
		}
		this.setStyle(this.masks.top, {height:offsetY+'px'});
		this.setStyle(this.masks.bottom, {height:(this.editorHeight - offsetY - nH)+'px'});
		this.setStyle(this.masks.left, {width:offsetX+'px', height:nH+'px'});
		this.setStyle(this.masks.right, {width:(this.editorWidth - offsetX - nW)+'px', height:nH+'px'});
		this.setStyle(this.drager, {width:nW+'px', height:nH+'px'});
		this.setStyle(this.sizer, {marginTop: (nH - 12)+'px'});
		this.preview(offsetX, offsetY, nW, nH);
		
		if(sizeTip){
			if(!this.sizeTip){
				this.sizeTip = document.createElement('div');
				this.sizeTip.className = 'i-s-sizetip';
				this.editorDom.appendChild(this.sizeTip);
				this.sizeTip.show = this.show;
				this.sizeTip.hide = this.hide;
			}
			this.sizeTip.innerHTML = nW + ' x ' + nH;
			this.setStyle(this.sizeTip, {marginTop:offsetY + nH +'px', marginLeft:offsetX+nW+'px'});
			this.sizeTip.show();
		}
	},
	
	preview:function(){
		var scale = 1, dw = this.drager.offsetWidth, dh = this.drager.offsetHeight, pw = this.previewerWidth, ph = this.previewerHeight;
		if(dw > pw || dh > ph){
			if(dw == dh){
				scale = pw / dw;
				dw = pw;
				dh = ph;
			}else{
				if((dw / dh) > (pw / ph)){
					scale = pw / dw;
					dw = pw;
					dh = Math.floor(scale * dh)
				}else{
					scale = ph / dh;
					dh = ph;
					dw = Math.floor(scale * dw)
				}
			}
		}
		var ct, cl, t, l, w;
		ct = Math.floor((ph - dh) / 2);
		cl = Math.floor((pw - dw) / 2);
		this.setStyle(this.previewerCt,{width:dw+'px', height:dh+'px', marginTop:ct+'px', marginLeft:cl+'px'});
		w = Math.floor(this.editPic.offsetWidth * scale);
		this.setStyle(this.previewer, {width:w+'px'});
		t = Math.floor(this.editPic.offsetTop - this.masks.top.offsetHeight) * scale;
		l = Math.floor(this.editPic.offsetLeft - this.masks.left.offsetWidth) * scale;
		h = this.previewer.offsetHeight
		if(t < 0 && (t + h) < dh) t = dh - h;
		if(l < 0 && (l + w) < dw) l = dw - w;
		this.setStyle(this.previewer, {marginTop:t+'px', marginLeft:l+'px'});
		//this.setSelectorInfo(px,py,pw,ph);
	},
	
	randarMask:function(c){
		var m = this.createEl('DIV', {overflow:'hidden', backgroundColor:this.maskColor, opacity:this.opacity, filter:'alpha(opacity='+(this.opacity*100)+')'})
		this.setStyle(m, c);
		return m;
	},
	
	createDrager:function(){
		this.dragerCt = this.createEl('DIV');
		this.dragerCt.className = "i-drager-bd1";
		
		var b = this.createEl('DIV');
		this.dragerCt.appendChild(b);
		b.className = "i-drager-bd2";
		
		var l = this.createEl('DIV');
		b.appendChild(l);
		l.className = "i-drager-bd3";
		
		this.drager = this.createEl('DIV');
		l.appendChild(this.drager);
		this.drager.className = "i-drager-bd4";
		
		this.sizer = this.createEl('DIV');
		this.drager.appendChild(this.sizer);
		this.sizer.className = "i-drager-sizer";

		//¼(Ƴ¼)
		var _this = this;
		this._mM = function(e){_this.onMove(window.event || e);}
		this._mE = function(e){_this.endMove(window.event || e);}
		
		this._rR = function(e){_this.onResize(window.event || e);}
		this._rE = function(e){_this.endResize(window.event || e);}
		
		//궯
		addEventHandler(this.drager, "mousedown", function(e){_this.beforMove(window.event || e); });
		addEventHandler(this.sizer, "mousedown", function(e){_this.beforeResize(window.event || e); });
		
		return this.dragerCt;
	},
	
	beforMove:function(e){
		if(this.isResizing)return ;
		this.isMoving = true;
		
		this.moveEvtStart = [e.clientX, e.clientY];
		this.editPic.clientX = e.clientX;
		this.editPic.clientY = e.clientY;
		//this.moveDragerStart = this.getXY(this.drager);
		
		addEventHandler(document, "mousemove", this._mM);
		addEventHandler(document, "mouseup", this._mE);	
		
		//ʹƵҲͷ
		if(isIE){
			addEventHandler(this.drager, "losecapture", this._mE);
			this.drager.setCapture();
		}else{
			addEventHandler(window, "blur", this._mE);
		}
	},
	
	endMove:function(e){
		if(!this.isMoving)return ;
		this.isMoving = false;
		removeEventHandler(document, "mousemove", this._mM);
		removeEventHandler(document, "mouseup", this._mE);
		
		if(isIE){
			removeEventHandler(this.drager, "losecapture", this._mE);
			this.drager.releaseCapture();
		}else{
			removeEventHandler(window, "blur", this._mE);
		}

		this.onMove(e, true);
	},
	
	onMove:function(e, flag){
		//ѡ(ieòĬϴ)
		window.getSelection && window.getSelection().removeAllRanges();
		if(!this.isMoving && !flag)return ;
		var cx = e.clientX - this.moveEvtStart[0];
		var cy = e.clientY - this.moveEvtStart[1];
		if(this.editPic.offsetWidth > this.editorWidth){
			var _cx = e.clientX - this.editPic.clientX;
			if(this.masks.left.offsetWidth == 0){
				this.setStyle(this.editPic, {marginLeft:'0px'});
			}else if(this.masks.right.offsetWidth == 0){
				var x = this.editorWidth - this.editPic.offsetWidth;
				this.setStyle(this.editPic, {marginLeft:x+'px'});
			}else if(_cx < 0 && this.masks.left.offsetWidth > 0){
				var x = this.editPic.offsetLeft + Math.floor(this.editPic.offsetLeft * _cx / this.masks.left.offsetWidth);
				if(x < 0){
					this.editPic.clientX = e.clientX;
					this.setStyle(this.editPic, {marginLeft:x+'px'});
				}
			}else if(_cx > 0 && this.masks.right.offsetWidth > 0){
				var _x = this.editPic.offsetWidth - this.editorWidth;
				var x = this.editPic.offsetLeft - Math.floor((_x + this.editPic.offsetLeft) * _cx / this.masks.right.offsetWidth);
				if(x < _x && x > 0) x = _x;
				this.editPic.clientX = e.clientX;
				this.setStyle(this.editPic, {marginLeft:x+'px'});
			}
		}
		if(this.editPic.offsetHeight > this.editorHeight){
			var _cy = e.clientY - this.editPic.clientY;
			if(this.masks.top.offsetHeight == 0){
				this.setStyle(this.editPic, {marginTop:'0px'});
			}else if(this.masks.bottom.offsetHeight == 0){
				var y = this.editorHeight - this.editPic.offsetHeight;
				this.setStyle(this.editPic, {marginTop:y+'px'});
			}else if(_cy < 0  && this.masks.top.offsetHeight > 0){
				var y = this.editPic.offsetTop + Math.floor(this.editPic.offsetTop * _cy / this.masks.top.offsetHeight);
				if(y < 0){
					this.editPic.clientY = e.clientY;
					this.setStyle(this.editPic, {marginTop:y+'px'});
				}
			}else if(_cy > 0 && this.masks.bottom.offsetHeight > 0){
				var _y = this.editPic.offsetHeight - this.editorHeight;
				var y = this.editPic.offsetTop - Math.floor((_y + this.editPic.offsetTop) * _cy / this.masks.bottom.offsetHeight);
				if(x < _x && x > 0) x = _x;
				this.editPic.clientY = e.clientY;
				this.setStyle(this.editPic, {marginTop:y+'px'});
			}
		}
		this.dragerMoveTo(cx, cy, flag);
	},
	
	dragerMoveTo:function(x,y, flag){
		x = this.dragerOffsetX + x;
		y = this.dragerOffsetY + y;
		if(x < this.offsetX){
			x = this.offsetX;
		}else if((x + this.dW) > (this.editorWidth - (this.offsetX>0?this.offsetX:0))){
			x = this.editorWidth - (this.offsetX>0?this.offsetX:0) - this.dW;
		}else if(x < 0){
			x = 0;
		}
		if(y < this.offsetY){
			y = this.offsetY;
		}else if((y + this.dH) > (this.editorHeight-(this.offsetY>0?this.offsetY:0))){
			y = this.editorHeight - (this.offsetY>0?this.offsetY:0) - this.dH;
		}else if(y<0){
			y = 0;
		}
		this.setSelector(x, y, flag);
	},
	
	beforeResize:function(e){
		this.isResizing = true;
		
		this.moveEvtStart = [e.clientX, e.clientY];
		
		addEventHandler(document, "mousemove", this._rR);
		addEventHandler(document, "mouseup", this._rE);	
		
		//ʹƵҲͷ
		if(isIE){
			addEventHandler(this.sizer, "losecapture", this._rE);
			this.sizer.setCapture();
		}else{
			addEventHandler(window, "blur", this._rE);
		}
	},
	
	endResize:function(e){
		if(!this.isResizing)return ;
		this.onResize(e, 3);
		this.isResizing = false;
		
		removeEventHandler(document, "mousemove", this._rR);
		removeEventHandler(document, "mouseup", this._rE);
		
		if(isIE){
			removeEventHandler(this.sizer, "losecapture", this._rE);
			this.sizer.releaseCapture();
		}else{
			removeEventHandler(window, "blur", this._rE);
		}
		this.sizeTip.hide();
	},
	
	onResize:function(e,flag){
		if(!this.isResizing)return ;
		window.getSelection && window.getSelection().removeAllRanges();
		var x = this.dW + e.clientX - this.moveEvtStart[0];
		var y = this.dH + e.clientY - this.moveEvtStart[1];
		var s = x/y;
		var d = this.dragerWidth / this.dragerHeight;
		if(this.useScale){
			if(s > d){
				y = x * d;
			}else{
				x = y / d;
			}
		}
		
		if(x < this.minWidth){
			x = this.minWidth;
		}else if((x + this.dragerOffsetX) > (this.editorWidth - (this.offsetX>0?this.offsetX:0))){
			x = this.editorWidth - (this.offsetX>0?this.offsetX:0) - this.dragerOffsetX;
		}
		
		if(y < this.minHeight){
			y = this.minHeight;
		}else if((y + this.dragerOffsetY) > (this.editorHeight-(this.offsetY>0?this.offsetY:0))){
			y = this.editorHeight - (this.offsetY>0?this.offsetY:0) - this.dragerOffsetY;
		}
		s = x/y;
		if(s < d){
			y = x * d;
		}else{
			x = y / d;
		}
		this.setSelector(x, y, flag==3?3:2,true);
	},
	
	initZoombar:function(){ 
		this.zoombarButton = $(this.zoombarButton);
		this.zoombar = this.zoombarButton.parentNode;
		this.zoombarTxt = this.zoombar.parentNode.getElementsByTagName('span');
		
		var _this = this;
		this._zRmv = function(){_this.isZooming = false;}
		
		this.zoomIn = this.zoombarTxt[0];
		addEventHandler(this.zoomIn, "mousedown", function(){_this.isZooming = true;_this.zoom(1, true);});
		addEventHandler(this.zoomIn, "mouseup", this._zRmv);
		removeEventHandler(this.zoomIn, "mouseout", this._zRmv);
		
		this.zoomOut = this.zoombarTxt[2];
		addEventHandler(this.zoomOut, "mousedown", function(){_this.isZooming = true;_this.zoom(2, true);});
		addEventHandler(this.zoomOut, "mouseup", this._zRmv);
		removeEventHandler(this.zoomOut, "mouseout", function(){_this.isZooming = false;});
		
		this.zoomFix = this.zoombarTxt[3];
		addEventHandler(this.zoomFix, "click", function(){_this.isZooming = true;_this.zoom(3);});
		
		this.zoombarTxt = this.zoombarTxt[this.zoombarTxt.length - 1];
		this.zoombarMaxLeft = this.zoombar.offsetWidth - this.zoombarButton.offsetWidth - 4;
		this.zoombarWidth = this.zoombarMaxLeft/2;
		
		addEventHandler(this.zoombarButton, "mouseover", function(e){_this.zoombarButton.className = 'i-resizebtn i-resizebtnover';});
		addEventHandler(this.zoombarButton, "mouseout", function(e){_this.zoombarButton.className = 'i-resizebtn';});
		
		this._zZ = function(e){_this.onZoom(window.event || e);}
		this._zE = function(e){_this.endZoom(window.event || e);}
		
		//궯
		addEventHandler(this.zoombarButton, "mousedown", function(e){_this.beforeZoom(window.event || e); });
	},
	
	setZoomPosition:function(){
		var x;
		if(this.scale == this.minScale){
			x = 0;
		}else if(this.scale == this.maxScale){
			x = this.zoombarWidth * 2;
		}else if(this.scale == 1){
		 	x = this.zoombarWidth;
		}else if(this.scale > 1){
			x = Math.log(this.scale)/Math.log(1.01);
			x = x / this.zoomPixWidth[1];
			if(this.zoomPixWidth[0] > 0) x += this.zoombarWidth;
		}else{
			x = (this.scale - this.minScale) / this.zoomPixWidth[0];
		}
		this.setStyle(this.zoombarButton, {left:Math.floor(x)+'px'});
	},
	setZoomScale:function(){
		if(this.scale > this.maxScale){this.scale = this.maxScale;}
		else if(this.scale < this.minScale){this.scale = this.minScale}
		this.zoombarTxt.innerHTML = (this.scale * 100).toFixed(0) + '%';
	},
	
	beforeZoom:function(e){
		this.isZooming = true;
		this.moveEvtStart = [e.clientX, e.clientY];
		this.moveEvtStartWidth = this.editPic.offsetWidth;
		this.moveEvtStartLeft = this.zoombarButton.offsetLeft;
		this.zoomStartParam = {x:e.clientX, y:e.clientY, ow:this.editPic.offsetWidth, ol:this.zoombarButton.offsetLeft, scale:this.scale};
		
		addEventHandler(document, "mousemove", this._zZ);
		addEventHandler(document, "mouseup", this._zE);	
		
		//ʹƵҲͷ
		if(isIE){
			addEventHandler(this.zoombarButton, "losecapture", this._zE);
			this.zoombarButton.setCapture();
		}else{
			addEventHandler(window, "blur", this._zE);
		}
	},
	onZoom:function(e){
		if(!this.isZooming)return ;
		this.zoombarButton.className = 'i-resizebtn i-resizebtnover';
		window.getSelection && window.getSelection().removeAllRanges();	
		var x = e.clientX - this.zoomStartParam.x;
		if(x==0||(x<0&&this.zoomStartParam.ol==0)||(x>0&&this.zoomStartParam.ol==this.zoombarMaxLeft)) return ;
		x += this.zoomStartParam.ol;
		if(x < 0){
			x = 0;
		}else if(x > this.zoombarMaxLeft){
			x = this.zoombarMaxLeft;
		}
		if(x==this.zoombarButton.offsetLeft) return;	
		this.setStyle(this.zoombarButton, {left:x+'px'});
		if(this.zoomPixWidth[0] > 0){
			if(x < this.zoombarWidth){
				this.scale = this.minScale + x * this.zoomPixWidth[0];
			}else{
				x -= this.zoombarWidth;
				this.scale = Math.pow(1.01, x * this.zoomPixWidth[1]);
			}
		}else{
			this.scale = Math.pow(1.01, x * this.zoomPixWidth[1]);
		}
		this.setZoomScale();
		this.editPic.style.width = Math.round(this.picOw * this.scale) + 'px';
		this.offsetX = (this.editorWidth - this.editPic.offsetWidth) / 2;
		this.offsetY = (this.editorHeight - this.editPic.offsetHeight) / 2;
		this.editPic.style.marginTop = this.offsetY + 'px';
		this.editPic.style.marginLeft = this.offsetX + 'px';
		this.preview();
	},
	endZoom:function(e){
		if(!this.isZooming)return ;
		this.zoombarButton.className = 'i-resizebtn';
		this.isZooming = false;
		this.zoombarButton.className = 'i-resizebtn';
		this.setSelector();
		removeEventHandler(document, "mousemove", this._zZ);
		removeEventHandler(document, "mouseup", this._zE);		
		if(isIE){
			removeEventHandler(this.zoombarButton, "losecapture", this._zE);
			this.zoombarButton.releaseCapture();
		}else{
			removeEventHandler(window, "blur", this._zE);
		}
	},
	
	zoom:function(flag, first){
		if(!this.isZooming)return ;
		var scale = this.scale;
		var p = this.scale < 1 || (this.scale == 1 && flag == 1) ? 100 : 10;
		p = 1 / p;
		
		if(flag == 1){
			scale -= p;	
		}else if(flag ==2){
			scale += p;
		}else{
			scale = this.Oscale;
			this.isZooming = false;
		}
		
		if(scale < this.minScale){
			scale = this.minScale;
		}else if(scale > this.maxScale){
			scale = this.maxScale;
		}else if(this.picOw * scale < this.minWidth || this.picOh * scale < this.minHeight){
			//scale = this.minWidth / this.picOw;
		}
		
		if(scale == this.scale)return;
		this.scale = scale;
		this.setZoomScale();
		this.editPic.style.width = Math.round(this.picOw * this.scale) + 'px';
		this.offsetX = (this.editorWidth - this.editPic.offsetWidth) / 2;
		this.offsetY = (this.editorHeight - this.editPic.offsetHeight) / 2;
		
		this.editPic.style.marginTop = this.offsetY + 'px';
		this.editPic.style.marginLeft = this.offsetX + 'px';
		this.preview();
		
		this.setZoomPosition();
		this.setSelector();
		
		if(this.isZooming){
			var _this = this;
			setTimeout(function(){_this.zoom(flag);}, first ? 500 :80);
		}
	},
	
	setSelectorInfo:function(px,py,pw,ph){
		if(!this.selectorInfo)return;
		var c = '';
		c += '<span>&nbsp;&nbsp;&nbsp;X' + parseInt(px - (this.offsetX>0?this.offsetX:0))+'</span>';
		c += '<span>&nbsp;&nbsp;&nbsp;Y' + parseInt(py - (this.offsetY>0?this.offsetY:0))+'</span>';
		c += '<span>ȣ' + parseInt(pw)+"</span>";
		c += '<span>߶ȣ' + parseInt(ph)+"</span>";
		var s = Math.round(this.scale*100);
		c += '' + s + '%';
		this.selectorInfo.innerHTML = c;
	},
	
	initMask:function(){
		this.isInitMask = true;
		this.maskEl = document.createElement('div');
		this.maskEl.className = 'i-l-mask';
		this.maskEl.innerHTML = '<div class="i-p-titleinfo"><p style="font-weight:bold"></p><a href="javascript:void(0)" title="ر" class="i-p-close"></a></div><div class="i-l-bd"><div class="i-l-message"></div><div class="i-l-bar"><strong></strong><div><p></p></div></div><div class="i-ipt-up" onmouseover="this.className=\'i-ipt-up i-ipt-up-over\'" onmouseout="this.className=\'i-ipt-up\'" onmousedown="this.className=\'i-ipt-up i-ipt-up-click\'" onmouseup="this.className=\'i-ipt-up i-ipt-up-over\'"><div><input type="button" value="" /></div></div></div>';
		document.body.appendChild(this.maskEl);
		var o = this.maskEl.getElementsByTagName("div");
		this.maskEl.msg = o[2];
		this.maskEl.btnBar = o[4];
		this.maskEl.button = this.maskEl.getElementsByTagName("input")[0];
		this.maskEl.button.show = function(){this.parentNode.parentNode.style.display='block'}
		this.maskEl.button.hide = function(){this.parentNode.parentNode.style.display='none'}
		this.maskEl.shadow = document.createElement('div');
		this.maskEl.shadow.className = 'i-l-shadow';
		this.maskEl.setTitle = function(t){this.getElementsByTagName('p')[0].innerHTML=t}
		this.maskEl.setMessage = function(t){this.msg.innerHTML=t}
		document.body.appendChild(this.maskEl.shadow)
		this.maskEl.shadow.style.left = -(document.documentElement.scrollWidth - document.body.offsetWidth) / 2 + 'px';
		this.maskEl.shadow.style.width = document.documentElement.scrollWidth + 'px';
		this.maskEl.shadow.style.height = Math.max(document.body.scrollHeight,document.documentElement.scrollHeight) + 'px';
		
		this.progressBar = o[3];
		this.progressBar.text = this.progressBar.getElementsByTagName('strong')[0];
		this.progressBar.div = this.progressBar.getElementsByTagName('div')[0];
		this.progressBar.setText = function(t){this.text.innerHTML=t}
		this.progressBar.setPercent = function(p){this.div.style.display=p>0?'block':'none';this.div.style.width=Math.ceil(p*2.86)+'px'}
		
		this.maskEl.shadow.show = this.maskEl.btnBar.show = this.progressBar.show = this.show;
		this.maskEl.hide = this.maskEl.shadow.hide = this.maskEl.btnBar.hide = this.progressBar.hide = this.hide;
		
		
		this.maskEl.show = function(){
			this.style.display='block';
			var t = (document.documentElement.clientHeight - this.offsetHeight) / 2;
			this.style.top = t + document.documentElement.scrollTop + document.body.scrollTop - 20 + 'px';
			t = (document.body.offsetWidth - this.offsetWidth) / 2;
			this.style.left = t + 'px';
		}
	},
	mask:function(title,msg,flag){
		if(!this.isInitMask) this.initMask();
		this.maskEl.setTitle(title);
		this.maskEl.setMessage(msg);
		this.maskEl.show();
		this.maskEl.shadow.show();
		flag ? this.maskEl.btnBar.show() : this.maskEl.btnBar.hide();
	},
	unMask:function(){
		this.maskEl.hide();
		this.maskEl.shadow.hide();
	},
	
	getXY:function(e){
		var p = e;
		var x = 0, y = 0;
		while (p) {
			x += p.offsetLeft;
			y += p.offsetTop;
			p = p.offsetParent;
		}
		return [x,y];
	},
	
	createEl:function(tag,config,cls){
		tag = tag.toUpperCase();
		tag = document.createElement(tag);
		if(config) this.setStyle(tag, config);
		if(cls) tag.className = cls;
		return tag;
	},
	
	setStyle:function(o,config){
		for(key in config){
			o.style[key] = config[key];
		}
	},
	
	commit:function(){
		if(!this.isEditing){
			alert('ϴҪ༭ͷͼƬ');
			return ;
		}
		if(this.editPic){
			var param = {
				action : 'commit',
				avatar : this.editPic.avatar,
				scale : this.scale,
				x : this.masks.left.offsetWidth - this.editPic.offsetLeft,
				y : this.masks.top.offsetHeight - this.editPic.offsetTop,
				width : this.drager.offsetWidth,
				height : this.drager.offsetHeight,
				iwidth : this.picOw,
				iheight : this.picOh,
				owidth : this.previewerWidth,
				oheight : this.previewerHeight
			};
			
			this.mask('ͷ', 'ͷ񱣴УԺ');
			this.maskEl.button.hide();
			var _this = this;
			ajax.request('post', window.location.href,{
				success:function(r){
					var v = ajax.jsondecode(r.responseText);
					if(v.success == 1){
						_this.clear();
						Profile.setAvatar(v.avatar);
						Profile.avatar();
					}else if(v.success == -1){
						Account.login({callback:function(){_this.commit()}});
					}else{
						alert(v.message ? v.message : 'ʧܣԣ');
					}
					_this.unMask();
				}
			},param);
		}else{
			alert('ϴҪͷͼƬ');
		}
	},
	clear:function(){
		this.isEditing = false;
		this.editPic.hide();
		this.previewer.hide();
		this.selector.hide();
	},
	show:function(){this.style.display='block'},
	hide:function(){this.style.display='none'}
};