<?php
/**
 * Project:		EXCMS: the PHP content management system.
 * File:		favorite.php
 *
 * A product of PUTOYO Inc.
 * 
 * EXCMS is a ten million data-level,high speed,human-based content management system.
 *
 * EX is Excellence & Express & Exceed & Expert.
 * 
 * For questions, help, comments, discussion, please join the
 * EXCMS mailing list. Send a blank e-mail to
 * services@excms.cn
 * or join the EXCMS forum
 * www.excms.cn/forum
 * 
 * @link http://www.excms.cn/
 * @copyright Copyright (c) 2010 PUTOYO Inc.
 * @license http://www.excms.cn/licenses/LICENSE-1.0
 * @category EXCMS
 * @author hkz@excms.cn
 * @version $Rev:  $
 */
 
/* $Id: $ */ 
 
/**
* ҵʻϢ
*/

// load account common
require_once('common.inc.php');


$_PAGE['favorite']['page']['cateid'] = $_GET['cateid'];
$_PAGE['favorite']['page']['public'] = $_GET['public'];

// json array
$json = array('success' => 0);

switch ($action){
	// edit favorite
	case 'edit':
		if(!isset($_POST['public'])){
			$settings = $userObj->getFavoriteSettings(EXCMS_ACCOUNT_UID);
			$_POST['public'] = $settings['public'];
		}
		$data = array(
			'id'			=> (int)$_POST['id'],
			'contentid'		=> $EXCMS_CONFIG['code_contentid'] ? EXCMS::id_decode($_POST['contentid']) : $_POST['contentid'],
			'category'		=> $_POST['category'],
			'title'			=> $_POST['title'],
			'description'	=> $_POST['description'],
			'url'			=> $_POST['url'],
			'public'		=> $_POST['public'] > 0 ? 1 : 0
		);
		
		if($data['id'] > 0){
			$data['uid'] = EXCMS_ACCOUNT_UID;
			$rs = $userObj->editFavorite($data);
		}else{
			$rs = $userObj->addFavorite(EXCMS_ACCOUNT_UID, $data);
		}
		
		if($rs === false && $_POST['overlay'] != 1){
			$msg = $userObj->getMessage();
			$json['message'] = getLangByName($msg);
			if($msg == 'USER_FAVORITE_URL_EXIST' || $msg == 'USER_FAVORITE_EXIST'){
				$json['id'] = $userObj->getFavoriteid();
			}
			$json['success'] = 2;
		}else{
			$json['success'] = 1;
		}
		// response
		$json = EXCMS::jsonencode($json);
		if($crossDomainCallback){
			echo $crossDomainCallback . "({$json});";
		}else{
			echo $json;
		}
		exit;
		break;
	// rename favorite category
	case 'rename':
		if($userObj->editFavoriteCategory(EXCMS_ACCOUNT_UID, $_POST['categoryid'], $_POST['name'])){
			$json['success'] = 1;
		}else{
			$json['message'] = getLangByName($userObj->getMessage());
		}
		EXCMS::json_print($json);
		exit;
		break;
		
	// detele favorite
	case 'delete' : 
		$fids = $_POST['id'];
		if($userObj->deleteFavorite(EXCMS_ACCOUNT_UID, $fids)){ // success
			$json['success'] = 1;
		}else{ // faild
			$json['message'] = getLangByName($userObj->getMessage());
		}
		EXCMS::json_print($json);
		exit;
		break;
		
	// detele favorite category
	case 'deletecate' : 
		$categoryid = (int)$_POST['categoryid'];
		if($userObj->deleteFavoriteCategory(EXCMS_ACCOUNT_UID, $categoryid)){
			$json['success'] = 1;
		}else{
			// delete faild
			$json['message'] = getLangByName($userObj->getMessage());
		}
		EXCMS::json_print($json);
		exit;
		break;
		
	// get all categories
	case 'getCategory' :
		$json = array('success' => 1);
		$json['data'] = $userObj->getFavoriteCategory(EXCMS_ACCOUNT_UID);
		$json['settings'] = $userObj->getFavoriteSettings(EXCMS_ACCOUNT_UID);
		// response
		$json = EXCMS::jsonencode($json);
		if($crossDomainCallback){
			echo $crossDomainCallback . "({$json});";
		}else{
			echo $json;
		}
		exit;
		break;
		
	// get favorites by category id
	case 'getFavorite' :
		$page = array(
			'cateid'	=> $_GET['categoryid'],
			'public'	=> $_GET['public'],
			'pageon'	=> $_GET['pageon'],
			'pagesize'	=> $_GET['pagesize'],
			'total'		=> $_GET['total']
		);
		$json = $userObj->getFavoriteList(EXCMS_ACCOUNT_UID, $page);
		$json['success'] = 1;
		EXCMS::json_print($json);
		exit;
		break;
	case 'public' :
		$json['success'] = $userObj->setFavoritePublic($_POST['id'],$_POST['value']);
		if(!$json['success']){
			$json['message'] = $userObj->getMessage();
		}
		EXCMS::json_print($json);
		exit;
		break;
		
	case 'settings' : 
		$data = array(
			'uid'			=> EXCMS_ACCOUNT_UID,
			'categoryid' 	=> $_POST['categoryid'],
			'public' 		=> $_POST['public'],
			'pagesize' 		=> $_POST['pagesize'],
		);
		$json['success'] = $userObj->saveFavoriteSettings($data);
		if(!$json['success']){
			$json['message'] = getLangByName($userObj->getMessage());
		}
		EXCMS::json_print($json);
		exit;
		break;
		
	case 'deleteall': 
		$json['success'] = $userObj->delAllFavorite(EXCMS_ACCOUNT_UID);
		if(!$json['success']){
			$json['message'] = getLangByName($userObj->getMessage());
		}
		EXCMS::json_print($json);
		exit;
		break;
	
	case 'editor':
		if($crossDomainCallback){
			ob_start();
			EXCMS::display('account/addFavorite.html');
			$contents = ob_get_contents();
			ob_clean();
			echo $crossDomainCallback . "(\"" . addslashes(str_replace(array(chr(13), chr(10)), '', $contents)) . "\")";
		}else{
			EXCMS::display('account/addFavorite.html');
		}
		exit;
		break;
		
	// display favorite list
	default :
		$_PAGE['action'] = $action;
		EXCMS::display('account/favorite.html');
		break;
}

// excms file's end