<?php
/**
 * Project:		EXCMS: the PHP content management system.
 * File:		login.php
 *
 * A product of PUTOYO Inc.
 * 
 * EXCMS is a ten million data-level,high speed,human-based content management system.
 *
 * EX is Excellence & Express & Exceed & Expert.
 * 
 * For questions, help, comments, discussion, please join the
 * EXCMS mailing list. Send a blank e-mail to
 * services@excms.cn
 * or join the EXCMS forum
 * www.excms.cn/forum
 * 
 * @link http://www.excms.cn/
 * @copyright Copyright (c) 2010 PUTOYO Inc.
 * @license http://www.excms.cn/licenses/LICENSE-1.0
 * @category EXCMS
 * @author lynn@excms.cn
 * @version $Rev: 772 $
 */
 
/* $Id: login.php 772 2010-03-08 13:36:54Z hukuizhi $ */ 
 
/**
* ¼ҵʻ
*/
  
// ϵͳļ
require_once ('../configuration/inc/common.inc.php');
// load account config
loadModuleConfig('account',true);
// is enabled account
if(!$EXCMS_MODULE['account']['enabled']){
	EXCMS::page404('ϵͳδʻ');exit;
}

// define EXCMS Account Path
define('EXCMS_ACCOUNT', str_replace('\\', '/', dirname(__FILE__)) . '/');

// is ajax request
$ajax = $_POST['ajax'] || $_GET['ajax'];
// Get action
$action = $_POST['action'] ? $_POST['action'] : $_GET['action'];

// cross domain clallback
if(isset($_GET['crossDomainCallback']) && $_GET['crossDomainCallback'] != ''){
	$crossDomainCallback = trim($_GET['crossDomainCallback']);
}

// init user object
include_once LIB_MODULES_PATH . 'account/User.class.php';
$userObj = new User();

switch ($action){
	// check user is login
	case 'islogin' : 
		$json = array('success' => 0);
		if($userObj->isLogin()){
			$json['success'] = 1;
			$json['message'] = getLoginTypeMessage($_POST['logintype'] ? $_POST['logintype'] : $_GET['logintype']);
		}
		$json = EXCMS::jsonencode($json);
		if($crossDomainCallback){
      		echo $crossDomainCallback . "({$json})";
		}else{
			echo $json;
		}
		break;
	case 'checklogin' :
		$json = array('success' => 0);
		if($userObj->isLogin()){
			$json['success'] = 1;
			$json['message'] = getLoginTypeMessage('mytype');
		}
		EXCMS::json_print($json);
		break;
	// show verifycode image
	case 'verifycode':
		include_once LIB_PATH . 'util/CheckCode.class.php';
		$cc = new CheckCode();
		$cc->show();
		break;
	// ajax login
	case 'ajaxlogin' :
		$_PAGE['logintype'] = $_POST['logintype'] ? $_POST['logintype'] : $_GET['logintype'];
		ob_start();
		EXCMS::display('account/ajaxlogin.html');
		$contents = ob_get_contents();
		ob_clean();
		if($crossDomainCallback){
			echo $crossDomainCallback . "(\"" . addslashes(str_replace(array(chr(13), chr(10)), '', $contents)) . "\")";
		}else{
			echo $contents;
		}
		break;
	// login action
	case 'login':
		$_PAGE['login']['error'] = '';
		if(CHARSET != JSON_CHARSET && $ajax){
			$_POST['username'] = iconv('UTF-8','GBK',$_POST['username']);
		}
		$_PAGE['login']['username'] = $_POST['username'];
		if($crossDomainCallback){
			$username = $_GET['username'];
			$password = $_GET['password'];
			$verifycode = isset($_GET['verifycode']) ? trim($_GET['verifycode']) : false;
		}else{
			$_PAGE['login']['username'] = $username = $_POST['username'];
			$password = $_POST['password'];
			$verifycode = isset($_POST['verifycode']) ? trim($_POST['verifycode']) : false;
		}
		// Check verifycode
		if($verifycode !== false){
			if(empty($verifycode)){
				$_PAGE['login']['error'] = getLangByName('EMPTY_VERIFYCODE');
			}else{
				include_once LIB_PATH . 'util/CheckCode.class.php';
				$checkcode = new CheckCode();
				$checkcode->code_type = isset($_POST['verifycodetype']) ? trim($_POST['verifycodetype']) : trim($_GET['verifycodetype']);
				if(!$checkcode->check($verifycode,false)){
					$_PAGE['login']['error'] = getLangByName('VERIFYCODE_FAILED');
				}
			}
		}
		// login
		$success = false;
		if(empty($_PAGE['login']['error'])){
			$_PAGE['login_info'] = $userObj->login($username, $password);
			if($_PAGE['login_info']){
				$success = true;
				unset($_PAGE['login']);
				if(!$ajax) {
					$forward = $_GET['forward'] = empty($_GET['forward']) ? EXCMS::url(array('name' => 'account.home')) : $_GET['forward'];
					if($_PAGE['login_info'] === true){
						header('Location:' . $forward);
						exit();
					}else{// display login success page
						$user = $userObj->getSession();
						$_PAGE['forwordurl'] = $forward;
						$_PAGE['actiontitle'] = "¼ɹ";
						$_PAGE['actioncontent'] = "ӭ {$user['username']}";
						EXCMS::display('account/success.html');
						exit;
					}
				}
			}else{
				$error = $userObj->getMessage();
				$_PAGE['login']['error'] = ($error == 'USER_PASSWORD_ERROR' || $error == 'USERNAME_NOT_EXISTS') ? 'û' : getLangByName($error);
			}
		}
		// ajax response
		if($ajax){
			$json = array(
				'success' => $success ? 1 : 0,
				'message' => '',
			);
			if($success){
				$json['message'] = getLoginTypeMessage($_POST['logintype'] ? $_POST['logintype'] : $_GET['logintype']);
			}else{
				$json['message'] = $_PAGE['login']['error'];
			}
			$json['logininfo'] = $_PAGE['login_info'] === true ? "" : $_PAGE['login_info'];
			$json = EXCMS::jsonencode($json);
			if($crossDomainCallback){
				echo $crossDomainCallback . "({$json})";
			}elseif($ajax){
				echo $json;
			}
			exit;
		}
	// logout
	case 'logout' :
		$_PAGE['logoutinfo'] = $userObj->logout();
		if($crossDomainCallback){
      		echo $crossDomainCallback . '({success:1,logoutinfo:'.$_PAGE['logoutinfo'].'})';
			exit;
		}elseif($ajax){
			EXCMS::json_print(array('success' => 1,'logoutinfo'=>$_PAGE['logoutinfo']));
			exit;
		}
	// display login page
	default :
		// жûѵ¼תʻ
		if(!$ajax && $action != 'logout' && $userObj->isLogin()){
			header('Location:' . EXCMS::url(array('name' => 'account.home')));
			exit;
		}
		EXCMS::display('account/login.html');
		break;
}
/**
 * get login return message
 * 
 * @param string $type
 * @return string
 */
function getLoginTypeMessage($type){
	global $userObj;
	$u = $userObj->getSession();
	$url_home = EXCMS::url(array('name' => 'account.home'));
	$url_logout = EXCMS::url(array('name' => 'account.logout'));
	$msg = '';
	switch($type){
		case 'comment' :
			$msg = '<a href="' . $url_home . '" target="_blank">'. $u['nickname'].'</a>  | <a href="javascript:void(0)" onclick="Login.logout(this,\'' . $url_logout . '\')">˳</a>';
			break;
		case 'ask' :
			$url_myask = EXCMS::url(array('name' => 'ask.myask'));
			$url_profile = EXCMS::url(array('name' => 'account.profile'));
			$url_favorite = EXCMS::url(array('name' => 'account.favorite'));
			$msg =	'<a href="' . $url_myask . '" class="accountmenu" onmouseover="Account.showMenu(this,\'accountmenuul\')">' . $u['nickname'] . '</a><ul id="accountmenuul">' .
					'<li><a href="' . $url_home . '">ҵʻ</a></li>' .
					'<li><a href="' . $url_profile . '">ҵ</a></li>' .
					'<li><a href="' . $url_favorite . '">ҵղ</a></li>' .
					'</ul> | <a href="' . $url_myask . '">ҵʴ</a>' .		
					' | <a href="javascript:;" onclick="Account.logout()">˳</a>';
			break;
		case 'page' :
			$msg = 'ӭ, ' . $u['nickname'] . ', <a href="' . $url_home . '">ҵʻ</a> | <a href="javascript:void(0)" onclick="Login.logout(this,\'' . $url_logout . '\')">ע</a>';
			break;
		case 'mytype' :
			$msg =	'<div class="accountinfo"><h3 class="title"><span class="username">'.$u['nickname'] . '</span> ӭ' .  '</h3>'.
					'<img src="account/'.$u['avatar_small'].'" class="avatar" /><p class="info">'.
					'עʱ䣺' . date('Y-m-d H:i:s', $u['registeddate']).
					'<br />Σ' . $u['position'] . '('.$u['loginip'].')'.
					'<br />ϴΣ' . $u['lastposition'] . '('.$u['lastloginip'].')'.
					'<span class="links"><a href="account/profile.php?type=avatar">ͷ</a>'.
					'<a href="account/profile.php">ʻϢ</a>'.
					'<a href="account/profile.php?type=info"></a></span></p>';
			break;
	}
	return $msg;
}

// excms file's end