<?php
/**
 * Project:		EXCMS: the PHP content management system.
 * File:		recover.php
 *
 * A product of PUTOYO Inc.
 * 
 * EXCMS is a ten million data-level,high speed,human-based content management system.
 *
 * EX is Excellence & Express & Exceed & Expert.
 * 
 * For questions, help, comments, discussion, please join the
 * EXCMS mailing list. Send a blank e-mail to
 * join@excms.cn
 * or join the EXCMS forum
 * www.excms.cn/forum
 * 
 * @link http://www.excms.cn/
 * @copyright Copyright (c) 2010 PUTOYO Inc.
 * @license http://www.excms.cn/licenses/LICENSE-1.0
 * @category EXCMS
 * @author hkz@excms.cn
 * @version $Rev: 772 $
 */
 
/* $Id: recover.php 772 2010-03-08 13:36:54Z hukuizhi $ */ 
 
/**
* վûһ
*/
  
// ϵͳļ
require_once ('../configuration/inc/common.inc.php');
// load account config
loadModuleConfig('account',true);
// is enabled account
if(!$EXCMS_MODULE['account']['enabled']){
	EXCMS::page404('ϵͳδʻ');exit;
}

// is ajax request
$ajax = $_POST['ajax'] || $_GET['ajax'];

// ajax 봦
if($ajax && CHARSET != JSON_CHARSET){
	$_POST = EXCMS::iconv_all(JSON_CHARSET, CHARSET, $_POST);
}

// Get action
$action = $_POST['action'];

// return 
$json = array('success' => 0, 'message' => '');

// init User Object 
include_once LIB_MODULES_PATH . 'account/User.class.php';
$userObj = new User();

switch ($action){
	// check account username
	case 'account' :
		include_once LIB_PATH . 'util/CheckCode.class.php';
		$checkcode = new CheckCode();
		if($checkcode->check($_POST['verifycode'])){
			$userinfo = $userObj->getUserByName($_POST['username'],2);
			if($userinfo){
				$json['success'] = 1;
				$json['userinfo'] = array(
					'question'	=> $userinfo['question'],
					'uid'		=> $userinfo['uid'],
					'code'		=> $userObj->getUserVerifyCode($userinfo),
				);
			}else{
				$error = $userObj->getMessage();
				if($error == 'USERNAME_NOT_EXISTS'){
					$json['success'] = -1;
				}else{
					$json['message'] = getLangByName($error);
				}
			}
		}else{
			$json['success'] = -2;
		}
		EXCMS::json_print($json);
		exit;
		break;
	
	// anser the question or send password link to user's email
	case 'answer' :
		// Check verifycode
		if(isset($_POST['verifycode'])){
			include_once LIB_PATH . 'util/CheckCode.class.php';
			$checkcode = new CheckCode();
			if(!$checkcode->check($_POST['verifycode'])){
				$json['success'] = -2;
				EXCMS::json_print($json);
				exit;
			}
		}
		
		$data = array(
			'username' 		=> $_POST['username'],
			'type' 			=> $_POST['type'],
			'email' 		=> $_POST['email'],
			'answer' 		=> $_POST['answer'],
			'verifycode'	=> $_POST['code']
		);
		$json['email'] = $userObj->recoverStepTow($data);
		if($json['email']){
			$json['success'] = $_POST['type'] == 1 ? 2 : 1;
		}else{
			$error = $userObj->getMessage();
			if($error == 'USER_EMAIL_SEND_ERROR'){
				$json['success'] = -3;
				$json['message'] = 'send email failed';//getLangByName($error);
			}elseif($error == 'USER_ANSWER_ERROR'){
				$json['success'] = -1;
				$json['message'] = 'answer is not match';//getLangByName($error);
			}else{
				$json['message'] = getLangByName($error);
			}
		}
		EXCMS::json_print($json);
		exit;
		break;
	
	// reset user password
	case 'resetpassword':
		// Check verifycode
		if(isset($_POST['verifycode'])){
			include_once LIB_PATH . 'util/CheckCode.class.php';
			$checkcode = new CheckCode();
			if(!$checkcode->check($_POST['verifycode'])){
				$json['success'] = -2;
				EXCMS::json_print($json);
				exit;
			}
		}
		
		$newpwd = $_POST['newpwd'];
		$repwd = $_POST['repwd'];
		if($newpwd !== $repwd){
			$json['message'] = getLangByName('USER_PASSWORD_NOT_MATCH');
		}else{
			$data = array(
				'username' 		=> $_POST['username'],
				'newpwd' 		=> $newpwd,
				'repwd' 		=> $repwd,
				'verifycode'	=> $_POST['code']
			);
			if($userObj->resetpassword($data)){
				$json['success'] = 1;
			}else{
				$json['message'] = getLangByName($userObj->getMessage());
			}
		}
		EXCMS::json_print($json);
		exit;
		break;
		
	//show recover password
	default :
		$username = $_GET['username'];
		$code = $_GET['code'];
		if(!empty($username) && !empty($code)){ // Ϊʼһ뷽ʽ
			$_PAGE['recover']['user'] = $userObj->verifyUser($username,$code);
			if(is_array($_PAGE['recover']['user'])&&count($_PAGE['recover']['user'])){
				$_PAGE['recover']['user']['code'] = $code;
				$_PAGE['recover']['reset'] = 1;
			}else{ // 
				$_PAGE['actiontitle'] = "һ";
				$_PAGE['actioncontent'] =  getLangByName($userObj->getMessage()).".";
				$_PAGE['actionpage'] = "һҳ";
				$_PAGE['forwordurl'] = EXCMS::url(array('name'=>'account.recover'));
				EXCMS::display('account/success.html');
				exit;
			}
		}
		break;
}

// display page
EXCMS::display('account/recover.html');

// excms file's end