<?php
/**
 * Project:		EXCMS: the PHP content management system.
 * File:		register.php
 *
 * A product of PUTOYO Inc.
 * 
 * EXCMS is a ten million data-level,high speed,human-based content management system.
 *
 * EX is Excellence & Express & Exceed & Expert.
 * 
 * For questions, help, comments, discussion, please join the
 * EXCMS mailing list. Send a blank e-mail to
 * join@excms.cn
 * or join the EXCMS forum
 * www.excms.cn/forum
 * 
 * @link http://www.excms.cn/
 * @copyright Copyright (c) 2010 PUTOYO Inc.
 * @license http://www.excms.cn/licenses/LICENSE-1.0
 * @category EXCMS
 * @author hkz@excms.cn
 * @version $Rev: 772 $
 */
 
/* $Id: register.php 772 2010-03-08 13:36:54Z hukuizhi $ */ 
 
/**
* վûע
*/
  
// ϵͳļ
require_once ('../configuration/inc/common.inc.php');
// load account config
loadModuleConfig('account',true);
// is enabled account
if(!$EXCMS_MODULE['account']['enabled']){
	EXCMS::page404('ϵͳδʻ');exit;
}

// is enabled register
if(!$EXCMS_MODULE['account']['register']){
	EXCMS::page404('ϵͳδʻעṦ');exit;
}

// Get action
$action = $_POST['action'] ? $_POST['action'] : $_GET['action'];

switch ($action){
	// Check usename, email, verifycode
	case 'check' :
		if(CHARSET != JSON_CHARSET){
			$_GET = EXCMS::iconv_all(JSON_CHARSET, CHARSET, $_GET);
		}
		$type = trim($_GET['type']);
		$json = array('success' => 1, 'message' => '');
		switch($type){
			// check username
			case 'username' :
				include_once LIB_MODULES_PATH . 'account/User.class.php';
				$userObj = new User();
				if(!$userObj->checkUsername(trim($_GET['value']))){
					$json['success'] = 0;
					$json['message'] = getLangByName($userObj->getMessage());
				}
				break;
			
			// check email
			case 'email' :
				include_once LIB_MODULES_PATH . 'account/User.class.php';
				$userObj = new User();
				if(!$userObj->checkEmail(trim($_GET['value']))){
					$json['success'] = 0;
					$json['message'] = getLangByName($userObj->getMessage());
				}
				break;

			// check verifycode
			case 'verifycode' :
				$_GET['value'] = trim($_GET['value']);
				if($_GET['value'] == ''){
					$json['success'] = 0;
					$json['message'] = getLangByName('EMPTY_VERIFYCODE');
				}else{
					include_once LIB_PATH . 'util/CheckCode.class.php';
					$checkcode = new CheckCode();
					if($checkcode->check($_GET['value'], false) == false){
						$json['success'] = 0;
						$json['message'] = getLangByName('VERIFYCODE_FAILED');
					}
				}
				break;
			default : break;
		}
		EXCMS::json_print($json);
		exit;
		break;
	
	// submit user info
	case 'register':
		$_PAGE['user']['error'] = '';
		$_PAGE['user']['username'] = $_POST['username'];
		$_PAGE['user']['nickname'] = $_POST['nickname'];
		$_PAGE['user']['email'] = $_POST['email'];
		// Check verifycode
		if($EXCMS_MODULE['account']['register_verifycode']){ 
			$_POST['verifycode'] = trim($_POST['verifycode']);
			if($_POST['verifycode'] == ''){
				$_PAGE['user']['error'] = getLangByName('EMPTY_VERIFYCODE');
			}else{
				include_once LIB_PATH . 'util/CheckCode.class.php';
				$checkcode = new CheckCode();
				if(!$checkcode->check($_POST['verifycode'])){
					$_PAGE['user']['error'] = getLangByName('VERIFYCODE_FAILED');
				}
			}
		}
		// Register
		if(empty($_PAGE['user']['error'])){
			$data = array(
				'username' 		=> $_POST['username'],
				'password' 		=> $_POST['password'],
				'repassword' 	=> $_POST['repassword'],
				'nickname' 		=> $_POST['nickname'],
				'email' 		=> $_POST['email']
			);
			if($EXCMS_MODULE['account']['register_type'] != 1){
				$data['email'] = $_POST['username'];
			}
			include_once LIB_MODULES_PATH . 'account/User.class.php';
			$userObj = new User();
			if($userObj->register($data)){
				unset($_PAGE['user']);
				$_PAGE['user']['username'] = $_POST['username'];
				// show success message
				$_PAGE['success'] = 1;
				$_PAGE['forwordurl'] = EXCMS::url(array('name'=>'account.home'));
			}else{
				$_PAGE['user']['error'] = getLangByName($userObj->getMessage());
			}
			unset($userObj);
		}
		break;
		
	// show verifycode image
	case 'verifycode':
		include_once LIB_PATH . 'util/CheckCode.class.php';
		$cc = new CheckCode();
		$cc->show();
		exit;
		break;
}

// display registe page
EXCMS::display('account/register.html');

// excms file's end