EXCMS.Editor=function(config){
	Ext.apply(this,config);
	this.init();
};
EXCMS.ModelFields={};
EXCMS.Editor.prototype = {
	titleMaxLength:80,
	multiEdit:true,
	modelFields:{hidden:true},
	baseAction:'index.php?M=Content&A=Index',
	editorid:'',
	isRendered:false,
	systemField:{},
	init:function(){
		if(!this.multiEdit && this.container){
			this.editorid = 'editor-content-model-' + this.modelid;
			var fp = this.container.getComponent(this.editorid)
			if (fp) {
				this.container.activate(fp);
				this.setValue();
				return ;
			}
		}else if(this.contentid && this.container){
			this.editorid = 'editor-content-' + this.contentid;
			var fp = this.container.getComponent(this.editorid)
			if (fp) {
				this.container.activate(fp);
				return ;
			}
		}
		var title = '';
		if(this.contentid){
			title = this.title || '༭';
			this.loadData();
		}else{
			title = '½' + (this.modelname||'');
			this.contentid='';
		}
		this.setTitle(title);
		this.loadModel();
		return this;
	},
	loadModel:function(){
		if(!this.modelid && !this.model) return ;
		this.isLoadModel = true;
		if(EXCMS.ModelFields[this.modelid]){
			this.modelFields = EXCMS.ModelFields[this.modelid];
			this.initCompent();
			return ;
		}

		this.mask('ڼģ...');
		Ext.Ajax.request({
            url:'index.php?M=Model&A=Index&method=geteditor',method:'POST',params:{modelid:this.modelid,model:this.model},scope:this,
			failure:function(){this.unmask()},
            success:function(r,o){
				this.unmask()
				r = Ext.decode(r.responseText);
				if(r.success){
					if(r.data){
						for(var i=0;i<r.data.length;i++){
							eval("r.data["+i+"]="+r.data[i]+";");
						}
						EXCMS.ModelFields[this.modelid] = r.data;
						this.modelFields = r.data;
					}
					if(r.system){
						for (field in r.system){
							eval("this.systemField."+field+"="+r.system[field]+";");
						}
					}
					if(r.mirrorinfo){
						EXCMS.setMirrorInfo(r.mirrorinfo);
					}
					this.initCompent();
				}
            }                           
        });
	},
	initCompent:function(){
		var tthis = this;
		window.top.EXCMS.getChannelId = function(){return tthis.fields.channelid.getValue()}
		window.top.EXCMS.getContentId = function(){return tthis.contentid;}
		this.fields = {
			'title':new Ext.form.TextField({fieldLabel:'',anchor:'-244',xtype:'textfield',name:'title',cls:'editor-title',invalidClass:'editor-title-invalid',allowBlank:false,blankText:'ݱⲻΪ',maxLength:this.titleMaxLength,maxLengthText:'ȱС80ַ(40)Ƽ66ַ(33)',enableKeyEvents:true}),
			'color':new Ext.form.Hidden({name:'color',value:''}),
			'bold':new Ext.form.Hidden({name:'bold'}),
			'italic':new Ext.form.Hidden({name:'italic'}),
			'underline':new Ext.form.Hidden({name:'underline'}),
			'titlesetting':new Ext.form.Label({cls:'title_ico',html:'<a href="javascript:;" class="title_length"></a><a href="javascript:;" class="title_check" title="Ƿظ">ظ</a><a href="javascript:;" class="title_bold" title=""></a><a href="javascript:;" class="title_italic" title="б"></a><a href="javascript:;" class="title_underline" title="»"></a><a href="javascript:;" class="title_color" title="ɫ(Ĭ)"></a>',listeners:{'render':this.onRenderTitle,scope:this}}),
			
			'channelid':new Ext.form.Hidden({name:'channelid'}),
			'crossid':new Ext.form.Hidden({name:'crossid'}),
			'channel':new Ext.form.ComboBox({fieldLabel:'Ŀ',style:'font-family:""',store:new Ext.data.SimpleStore({fields:[],data:[[]]}),editable:false,mode:'local',triggerAction:'all',hiddenName:'channelname',tpl:'<tpl for="."><div style="height:220px"><div></div></div></tpl>',selectedClass:'',onSelect:Ext.emptyFn,allowBlank:false,blankText:'ĿΪ',emptyText:'ѡĿ'}),
			
			'author':new Ext.form.ComboBox({fieldLabel:'',maxHeight:220,name:'author',valueField:'author',displayField:'author',maxLength:60,maxLengthText:'ַȱС60',typeAhead:false,selectOnFocus:true,triggerAction:'all',emptyText:'ѡ',store:new Ext.data.Store({proxy:new Ext.data.HttpProxy({url:'index.php?M=Content&A=Author&method=getComboData'}),reader:new Ext.data.JsonReader({root:'Data',id:'id'},['author']),remoteSort:true})}),
			'source':new Ext.form.ComboBox({fieldLabel:'Դ',maxHeight:220,name:'source',valueField:'source',displayField:'source',maxLength:60, maxLengthText:'ԴַȱС60',waitMsgTarget:true,typeAhead:false,triggerAction:'all',emptyText:'ѡԴ',selectOnFocus:true,store:new Ext.data.Store({proxy:new Ext.data.HttpProxy({url:'index.php?M=Content&A=Source&method=getComboData'}),reader:new Ext.data.JsonReader({root:'Data',id:'id'},['id','source']),remoteSort:true})}),
			'forward':new Ext.form.TextField({hideLabel:true,xtype:'textfield',name:'forward',emptyText:'תӵַ(URL)',disabled:true, maxLength:100, maxLengthText:'ȱΪС100ַ'}),
			'comment':new Ext.form.Checkbox({hideLabel:true,boxLabel:'',name:'comment',checked:true,inputValue:1,listeners:{render:function(c){c.el.dom.parentNode.parentNode.parentNode.parentNode.style.cssText+=';float:left;margin:-25px 0 0 130px;'},scope:this}}),
			'templet':new Ext.form.ComboBox({fieldLabel:'ģ',maxHeight:220,name:'template',value:'',valueField:'id',displayField:'id',waitMsgTarget:true,typeAhead:true,triggerAction:'all',selectOnFocus:true,store:new Ext.data.Store({proxy:new Ext.data.HttpProxy({url:'index.php?M=Common&A=TemplatesList&cate=content'}),reader:new Ext.data.JsonReader({root:'Data',id:'id'},['id','name']),remoteSort:true}),forceSelection:true})
		};
		this.fields.title.on('keyup',function(t,e){this.ti[0].setValue()},this);
		this.fields.channel.tree = new Ext.tree.TreePanel({useArrows:true,cls:'channel-tree',bodyStyle:'padding:1px;',border:false,loader:new Ext.tree.TreeLoader({dataUrl:'index.php?M=Channel&A=Index&method=tree&treetype=crose',baseParams:{modelid:1}}),root:new Ext.tree.AsyncTreeNode({id:'0',text:'վĿ',cls:'channel-tree-root',expanded:true}),listeners:{'render':{fn:function(c){var t=c.el.dom.parentNode.parentNode.parentNode.parentNode;t.style.backgroundColor='#FFFFFF';new Ext.Resizable(t,{handles:'s',resizeChild:true})},scope:this}}});
		this.fields.channel.tree.contextmenu = new Ext.menu.Menu({items:[{text:'ˢĿ',icon:ico,iconCls:'btnico btn_fresh',handler:this.refreshTree,scope:this,mode:1}]}); 
		this.fields.channel.tree.on('contextmenu',function(n,e){
			this.selectedNode = n;this.channelrefresh = true;
	    	this.fields.channel.tree.contextmenu.showAt(e.getXY());
			this.fields.channel.tree.contextmenu.items.items[0].mode = n.id == '0';
		},this);
		this.fields.channel.on('collapse',function(c){if (this.channelrefresh) {this.channelrefresh = false;c.expand();}},this)
		this.fields.channel.tree.on('click',function(n){
			if(n.attributes['type']==0){
				if (n.attributes['modelid'] == this.modelid) {
					this.currentChannel = {channelid:n.attributes.id,text:n.attributes.text,modelid:n.attributes.modelid};
					if(n.attributes['cross'] == 1){
						var channelname = n.parentNode.text + '[' + n.text + ']';
						if(n.parentNode.parentNode && n.parentNode.parentNode.id != '0') channelname = n.parentNode.parentNode.text + ' > ' + channelname;
					}else{
						var channelname = n.text;
						if(n.parentNode && n.parentNode.id != '0') channelname = n.parentNode.text + ' > ' + channelname;
					}
					this.fields.channel.setValue(channelname.replace(/<[0-9a-zA-Z]{1,} .*<\/[0-9a-zA-Z]{1,}>/gm,""));
					this.fields.channelid.setValue(n.attributes['cross'] == 1 ? n.parentNode.id : n.id);
					if (n.attributes['cross'] == 1) {
						var cross = n.id.split('_');
						this.fields.crossid.setValue(cross[1]);
					}else {
						this.fields.crossid.setValue('');
					}
					this.fields.channel.collapse();
					this.fields.comment.setValue(n.attributes['Arccomment']);
				}
			}else n.expand();
		},this);
		this.fields.channel.on('expand',function(){this.fields.channel.tree.render(this.fields.channel.list.dom.getElementsByTagName('div')[2]);},this);
		
		var eastBdStyle = 'background:#f3f3f7;';
		var tabBodyStyle = 'padding:6px 2px 0 8px;background:#f3f3f7;';
		var labelStyle = 'display:block;padding-left:45px;padding-bottom:6px;color:#666;'
		
		// recommend panel
		/*
		this.recommendPanel = new Ext.Panel({height:220,autoScroll:true,html:'',tbar:[
		        '<b style="color:#15428B">ƼƬ</b>','->',
			    {text:'ѡ',handler:this.selectRmd,scope:this},
			    {text:'ɾ',handler:this.removeRmd,scope:this,type:'selected'},'-',
			    {xtype:'checkbox',inputValue:1,name:'updateblock',boxLabel:'Ƭ'}
		    ],listeners:{'render':{fn:function(p){
			this.rmdList = p.body;
			this.rmdList.dom.className += ' blocks-container';
				p.body.dom.onclick = function(e){
					e = window.event || e;
					e = e.target||e.srcElement;
					var tn = e.tagName.toLowerCase();
					if(tn == 'a'){
						setCls(e, 'current', e.selected);
						e.selected = !e.selected;
					}else if(tn == 'b') this.removeChild(e.parentNode);
				}
				p.body.dom.ondblclick = function(e){
					e = window.event || e;
					e = e.target||e.srcElement;
					var tn = e.tagName.toLowerCase();
					if(tn == 'a') this.removeChild(e);
				}
			},scope:this}}
		});*/
		if(this.modelid==1){
			 var systemItem = [this.systemField.body];
			 systemItem = systemItem.concat(this.modelFields);
			 modelConfig = {region:'center',autoScroll:true,layout:'form',border:false,bodyStyle:'padding:10px 12px',items:systemItem};
		}else if(this.modelid==2){
			var systemItem = [{xtype:'tabpanel',id:'tabpanel_content',style:'margin-bottom:10px',border:false,activeTab:1,autoHeight:true,cls:'excms-tabpanel excms-tabpanel-collapsible',collapsible:false,items:[
				{title:this.systemField.images.fieldLabel,autoWidth:true,autoHeight:true,items:this.systemField.images},
				{title:this.systemField.body.fieldLabel,autoWidth:true,autoHeight:true,items:this.systemField.body}
			]}];
			 systemItem = systemItem.concat(this.modelFields);
			 modelConfig = {region:'center',autoScroll:true,layout:'form',border:false,bodyStyle:'padding:10px 12px',items:systemItem};
		}else if(this.modelid==4){
			var systemItem = [{xtype:'tabpanel',id:'tabpanel_content',style:'margin-bottom:10px',border:false,activeTab:1,autoHeight:true,cls:'excms-tabpanel excms-tabpanel-collapsible',collapsible:true,items:[
				{title:this.systemField.videos.fieldLabel,autoWidth:true,autoHeight:true,items:this.systemField.videos},
				{title:this.systemField.body.fieldLabel,autoWidth:true,autoHeight:true,items:this.systemField.body}
			]}];
			 systemItem = systemItem.concat(this.modelFields);
			 modelConfig = {region:'center',autoScroll:true,layout:'form',border:false,bodyStyle:'padding:10px 12px',items:systemItem};
		}else if(this.modelid==3){
			this.systemField.images.title = this.systemField.images.fieldLabel;
			this.systemField.body.height = 200;
			this.systemField.body.disableOnResize = true;
			var systemItem= [{layout:'column',border:false,items:[
					{columnWidth:.5,layout:'form',defaults:{anchor:'-15'},border:false,items:[
						this.systemField.publishtype,
						this.systemField.downcategory,
						this.systemField.downtype,
						this.systemField.platform,
						this.systemField.publisher,
						this.systemField.publisherurl
					]},
					{columnWidth:.5,layout:'form',defaults:{anchor:'100%'},border:false,items:[
						this.systemField.version,
						this.systemField.copyright,
						this.systemField.language,
						this.systemField.level,
						this.systemField.email,
						this.systemField.demo
					]}
				]},
				{layout:'form',border:false,style:'margin-top:5px;border-top:1px dotted #99BBE8;padding-top:10px;',itemCls:'floatitem',collapsible:true,items:[
					this.systemField.downfilename,
					this.systemField.filesize,
					this.systemField.filetype
				]},
				this.systemField.urls,
				{xtype:'tabpanel',id:'tabpanel_content',style:'margin-top:10px;margin-bottom:10px',border:false,activeTab:1,autoHeight:true,cls:'excms-tabpanel excms-tabpanel-collapsible',collapsible:true,items:[
					{title:this.systemField.body.fieldLabel,autoHeight:true,items:this.systemField.body},
					{title:this.systemField.images.fieldLabel,autoHeight:true,items:this.systemField.images}
				]}
			];
			systemItem = systemItem.concat(this.modelFields);
			modelConfig = {region:'center',border:false,autoScroll:true,layout:'form',defaults:{anchor:'-24'},bodyStyle:'padding:10px 0 10px 10px;',labelWidth:60,items:systemItem};
		}else{
			var modelConfig = {region:'center',autoScroll:true,layout:'form',border:false,bodyStyle:'padding:10px 12px'};
			if(this.modelFields && typeof this.modelFields != 'string' && this.modelFields.length) modelConfig.items = this.modelFields;
			else modelConfig.html = '';
		}
		this.modelFieldsPanel = new Ext.Panel(modelConfig);
		this.thumbPanel = new Ext.Panel({layout:'form',border:false,html:'',listeners:{scope:this,'render':this.onRenderThumb}});
		this.recommend=new Ext.form.ComboMultiSelect({fieldLabel:'Ƽ',hiddenName:'recommend',anchor:'100%',multiSelect:true,valueField:'id',displayField:'name',triggerAction:'all',store:new Ext.data.Store({proxy:new Ext.data.HttpProxy({url:'index.php?M=Category&A=Index&method=getdata'}),fields:['id','name'],baseParams:{categoryid:1},reader:new Ext.data.JsonReader({root:'data'},['id','name'])})});
		this.relatedContent=new Ext.form.TextArea({fieldLabel:'',xtype:'textarea',vtype:'commanum',vtypeText:"ֻֻ߶','", name:'likecontentid',height:50,maxLength:100,emptyText:'IDá,',maxLengthText:'ȱС100ַ'});
		// form panel
		
		this.formPanel =  new Ext.FormPanel({id:this.editorid,layout:'border',title:this.title,border:false,closable:true,items:[
			{xtype:'hidden',name:'contentid'}, this.fields.channelid, this.fields.crossid, {xtype:'hidden',name:'lastchannelid'},
			this.fields.color, this.fields.bold, this.fields.italic, this.fields.underline,
			{xtype:'hidden',name:'thumb'}, {xtype:'hidden',name:'sort',value:'10'},
			{region:'center',layout:'border',border:false,items:[
				{region:'north',layout:'form',border:false,height:48,bodyStyle:'padding:12px 12px 0px;background:#FFF url(Themes/images/editor_top_bg.gif) repeat-x',labelWidth:60,items:[this.fields.title,this.fields.titlesetting]},
				this.modelFieldsPanel
			]},
			{region:'east',id:'formtabpanel',width:300,border:false,style:'border-left:1px solid #99BBE8',itemCls:'panel-body-transparent',xtype:'tabpanel',activeTab:1,items:[
				{title:'',autoScroll:true,layout:'form',bodyStyle:tabBodyStyle,labelWidth:44,defaults:{anchor:'-20'},items:[
					this.fields.channel,
					{fieldLabel:'ؼ',xtype:'textarea',name:'keywords',height:40,emptyText:'ؼá,Ÿ,Ƽ5(3),ܳ70ַ(35)', maxLength:70, maxLengthText:'ؼֳȱС70ַ(35)'},
					{xtype:'textfield',fieldLabel:'ǩ',name:'tags',emptyText:'ǩá,;ֿ',value:'',maxLength:70,maxLengthText:'ȱС70ַ(35)'},
					{fieldLabel:'ժҪ',xtype:'textarea',name:'description',height:80, maxLength:255,emptyText:'ժҪȱС250ַ(125)Ƽ150ַ(75)',maxLengthText:'ժҪȱС250ַ(125)'},
					this.thumbPanel,
					this.fields.source,
					this.fields.author,
					{fieldLabel:'༭',xtype:'textfield',name:'editor',emptyText:'α༭',maxLength:20},
					{layout:'form',border:false,bodyStyle:eastBdStyle,items:[
						{fieldLabel:'״̬',xtype:'radiogroup',width:150,items:[
							{boxLabel:'',name:'status',inputValue:1,checked:true},
							{boxLabel:'',name:'status',inputValue:0},
							{boxLabel:'ݸ',name:'status',inputValue:-1}
						]},
						{fieldLabel:'',xtype:'datetimefield',name:'publishdate',anchor:'100%'},
						this.recommend,
						{fieldLabel:'ѡ',xtype:'checkbox',boxLabel:'HTML',name:'ishtml',checked:true,inputValue:1},
						this.fields.comment,
						{fieldLabel:'',xtype:'checkbox',boxLabel:'ҳ桢бҳ',name:'updatepage',checked:false,inputValue:1}
					]}
				]},
				/*
				{title:'ؼƼ',layout:'form',labelWidth:66,defaults:{anchor:'-18'},bodyStyle:tabBodyStyle,autoScroll:true,items:[
                     {xtype:'trigger',fieldLabel:'عؼ',name:'likekeywords',triggerClass:'x-form-search-trigger',emptyText:'ؼá,;',value:'',maxLength:40,maxLengthText:'ȱС40ַ(20wh )'},
                     {xtype:'tabpanel',style:'margin-bottom:8px',height:220,activeTab:0,items:[
                          {title:'',html:'',tbar:[{text:'',handler:this.contentIdSelect,scope:this},{text:'ɾ'},'->',{xtype:'trigger',width:100,triggerClass:'x-form-search-trigger'}]},
                          {title:'ͼƬ',html:'',tbar:[{text:'',handler:this.contentIdSelect,scope:this},{text:'ɾ'},'->',{xtype:'trigger',width:100,triggerClass:'x-form-search-trigger'}]},
                          {title:'Ƶ',html:'',tbar:[{text:'',handler:this.contentIdSelect,scope:this},{text:'ɾ'},'->',{xtype:'trigger',width:100,triggerClass:'x-form-search-trigger'}]}
                     ]},
                     this.recommendPanel
				]},*/
				{title:'߼',bodyStyle:tabBodyStyle,layout:'form',autoScroll:true,labelWidth:58,defaults:{anchor:'-18'},items:[
					{fieldLabel:'ת',xtype:'checkbox',boxLabel:'ʹת',name:'isforward',inputValue:1,listeners:{check:function(c,n){this.setForward(n)},scope:this}},	
					this.fields.forward,
					{layout:'form',border:false,bodyStyle:eastBdStyle,labelAlign:'top',defaults:{anchor:'100%'},items:[
						{fieldLabel:'̱',xtype:'textfield',name:'shorttitle',cls:'editor-title',emptyText:'̱Ϊʱڱ',maxLength:40,maxLengthText:'ȱС40ַ(20)'},
						{fieldLabel:'Mate',xtype:'textfield',name:'metatitle',cls:'editor-title',emptyText:'MateΪʱڱ',maxLength:100,maxLengthText:'ȱС100ַ(50)'},
						{xtype:'textfield',fieldLabel:'عؼ',name:'likekeywords',emptyText:'ؼá,;',value:'',maxLength:40,maxLengthText:'ȱС40ַ(20wh )'},
						this.relatedContent,
						{xtype:'label',layout:'column',border:false,html:'',style:'padding-bottom:6px',listeners:{render: function(c){
							var b = document.createElement('input');
							b.type = 'button';
							b.value = 'ѡ';
							b.onclick = function(){
								this.contentIdSelect();
							}.createDelegate(this);
							c.el.dom.appendChild(b);
						},scope:this}}
					]},
					{xtype:'fieldset',title:'Զģ塢ļ',autoHeight:true,labelWidth:45,defaults:{anchor:'100%'},bodyStyle:eastBdStyle,items:[
						this.fields.templet,
						{fieldLabel:'ļ',xtype:'textfield',name:'filename',value:''},
						{xtype:'label',text:'磺myfilename.html',style:labelStyle}
					]}
				]}
			]}],
			tbar:[
				{text:'',iconCls:'btnico btn_save',handler:this.submit,scope:this},
				{text:'Ԥ',iconCls:'btnico btn_preview',handler:this.preview,scope:this},
				{text:'ˢ',iconCls:'btnico btn_fresh',handler:function(){this.reload()},hidden:true,scope:this},
				{text:'ȡ',iconCls:'btnico btn_cancel',handler:function(){this.cancel()},scope:this}
			],
			listeners:{
				scope:this,
				'actionfailed':function(f,a){this.unmask()},
				'actioncomplete':function(form,action){
					this.unmask();
					if(action.result.success){
						var contentid = action.result.contentid;
						this.updatepage(contentid);	
						var ok=''
						var values = this.formPanel.form.getValues();
							if(values.status == 1){
								ok = '';
							}else{
								ok='Ԥ';
						}
						Ext.MessageBox.show({
							title:'ݱɹ',
							width:360,
							msg: '༭༭ť<br>½½ťȡ<br>'+(action.result.message||'')+'<br>',
							buttons:{'yes':'½','no':'༭','cancel':'ȡ','ok':ok},
							fn: function(b){
								if(b == 'cancel'){
									this.cancel();
								}else if(b == 'no'){
								}else if(b == 'yes'){
									var channelid = this.fields.channelid.getValue();
									var channel = this.fields.channel.getValue();
									
									this.formPanel.form.reset();
									this.fields.channelid.setValue(channelid);
									this.fields.channel.setValue(channel);
									this.setThumb();
								}else if(b == 'ok'){
									if(Ext.Msg.buttonText.ok==''){
										if(this.contentid < contentid) this.contentid = contentid;
										this.browse(this);	
									}else{
										this.preview();
									}
									this.cancel();
								}
							},
							scope:this
						});

					}
				}
			}
		});
		this.formPanel.content = this;
		if(this.container){
			this.container.add(this.formPanel);
			this.container.activate(this.formPanel);
		}else{
			this.formPanel.region = 'center';
			new Ext.Viewport({layout:'border',items:this.formPanel});
		}
		this.ftp = this.formPanel.getComponent('formtabpanel');
		this.ftp.activate(0);
		if (this.channelid) {
			this.fields.channelid.setValue(this.channelid);
			this.fields.channel.setValue(this.channelname);
		}
		if(this.modelid==2 || this.modelid==3 || this.modelid==4){
			var p = this.formPanel.findById('tabpanel_content');
			p.activate(0);
			p.doLayout();
		}
		this.isRendered = true;
		if(this.contentid) {
			this.hideBtn(false);
			this.setValue();
		}
	},
	//ҳ桢бҳ
	updatepage:function(contentid){
		var values = this.formPanel.form.getValues();
		var contentid = values.contentid != '' ? values.contentid : contentid;
		if(values.updatepage == 1) var info = 1;
			if(values.updatepage || values.ishtml){
				Ext.Ajax.request({
				url:this.baseAction+'&method=updatepage',method:'POST',params:{contentid:contentid,channelid:values.channelid,ishtml:values.ishtml,status:values.status,info:info}, 
				failure:function(){},
				success:function(){
					 this.store.reload();
					 if(values.updatepage == 1) EXCMS.msg('ʾ','ҳ桢бҳɹ');  
				},
				scope:this
				});	
			}
	},
	// title setting initial
	onRenderTitle:function(c){
		var tthis=this;
		this.ti = c.el.dom.getElementsByTagName('a');
		this.ti[0].setValue=function(){
			var l = tthis.fields.title.getValue().byteLength();
			var color = l > tthis.titleMaxLength ? 'red' : 'green';
			this.innerHTML = '<font color="'+color+'">'+l+'</font>/<font color="red">'+tthis.titleMaxLength+'</font>';
		}
		this.ti[0].setValue();
		this.ti[1].onclick=function(){tthis.checkTitle()}
		this.ti[2].valueCls='title_bold_click';
		this.ti[2].field = this.fields.bold;
		this.fields.bold.viewEl = this.ti[2];
		this.ti[3].valueCls='title_italic_click';
		this.ti[3].field = this.fields.italic;
		this.fields.italic.viewEl = this.ti[3];
		this.ti[4].valueCls='title_underline_click';
		this.ti[4].field = this.fields.underline;
		this.fields.underline.viewEl = this.ti[4];
		this.ti[2].onclick=this.ti[3].onclick=this.ti[4].onclick=function(){var v=this.field.getValue()=='1'?'':1;this.field.setValue(v);this.setView(v)}
		this.ti[2].setView=this.ti[3].setView=this.ti[4].setView=function(v){setCls(this,this.valueCls,!v)}
		this.colorButton = this.ti[5];
		this.colorButton.onclick = function(){
			if(!tthis.colorMenu){
				tthis.colorMenu = new Ext.menu.ColorMenu();
				tthis.colorMenu.on('select',function(cm,color){tthis.setColorValue('#'+color)});
				tthis.colorMenu.on('show',function(){setCls(tthis.colorButton,'title_color_click')});
				tthis.colorMenu.on('hide',function(){setCls(tthis.colorButton,'title_color_click',1)});
			}
			tthis.colorMenu.show(tthis.colorButton);
		}
	},
	setTitle:function(T){document.title=T;this.title=T.ellipse(10);if(this.formPanel)this.formPanel.setTitle(this.title)},
	refreshTree:function(item){
		if(item.mode) {if(this.fields.channel.tree.root.loaded)this.fields.channel.tree.getLoader().load(this.fields.channel.tree.root);this.fields.channel.tree.root.expand();}
		else{if(this.selectedNode.loaded)this.fields.channel.tree.getLoader().load(this.selectedNode);this.selectedNode.expand();}
	},
	loadData:function(){
		if(this.isLoaded) return ;
		this.reload();
	},
	reload : function(){
		this.isLoaded = true;
		this.mask('ڼ, Ժ');
		Ext.Ajax.request({
            url:this.baseAction+'&method=getById',method:'POST',params:{contentid:this.contentid},scope:this,
            failure:function(r,p){this.unmask()},  
            success:function(r,o){
                this.unmask();
				r=jsonReturn(r);
				if(r.success) this.setValue(r.data);
            }
        });
	},
	setValue:function(values){
		if(!this.isRendered){
			if (values) {
				this.values = values;
				if (!this.isLoadModel) {
					this.modelid = this.values.modelid;
					this.loadModel();
					//this.onRender();
				}
			}
			return ;
		}else if(!this.values){
			if(values) this.values = values;
			else return ;
		}
		this.setTitle(this.values.title);
		this.fields.channel.disable();
		this.setForward(this.values.j>0);
		this.setColorValue(this.values.color||'');
		if(!this.values.bold) this.values.bold = '';
		this.ti[2].setView(this.values.bold);
		if(!this.values.italic) this.values.italic = '';
		this.ti[3].setView(this.values.italic);
		if(!this.values.underline) this.values.underline = '';
		this.ti[4].setView(this.values.underline);
		this.values.ispagination = 1;
		this.formPanel.form.setValues(this.values);
		if(this.values.thumb) this.setThumb(this.values.__thumb, true);
		this.ti[0].setValue();
	},
	setChannel:function(currentChannel){
		this.currentChannel = currentChannel;
		if(!currentChannel.channelid || currentChannel.channelid == '' || !currentChannel.text || currentChannel.text == ''){return ;}
		channelids = currentChannel.channelid.split('_');
		this.fields.channelid.setValue(channelids[0]);
		this.fields.channel.setValue(currentChannel.text.replace(/<[0-9a-zA-Z]{1,} .*<\/[0-9a-zA-Z]{1,}>/gm,""));
		this.fields.crossid.setValue(channelids[1]);
	},
	setForward:function(f){this.fields.forward.setDisabled(!f)},
	setColorValue:function(c){
		c = c ? c.trim() : '';
		this.fields.color.setValue(c == '#D6D6D6' || c == '' ? '' : c);
		this.colorButton.style.backgroundColor = c;
	},
	onRenderThumb:function(){
		this.thumbPanel.body.dom.innerHTML = '<div class="thumbselector"><em>ͼ</em><div class="thumbct"></div><div class="uploadtext"><a href="javascript:void(0);" class="thumb-res"  onmouseout="setCls(this,\'thumb-res-click\',1)" onmouseup="setCls(this,\'thumb-res-click\',1)" onmousedown="setCls(this,\'thumb-res-click\')" title="Դѡͼ"></a><a href="javascript:void(0);" class="thumb-up"  onmouseout="setCls(this,\'thumb-up-click\',1)" onmouseup="setCls(this,\'thumb-up-click\',1)" onmousedown="setCls(this,\'thumb-up-click\')" title="ϴͼ"></a><a href="javascript:void(0);" class="thumb-url" onmouseout="setCls(this,\'thumb-url-click\',1)" onmouseup="setCls(this,\'thumb-url-click\',1)" onmousedown="setCls(this,\'thumb-url-click\')" title="ָͼƬΪͼ"></a><a href="javascript:void(0);" class="thumb-del" onmouseout="setCls(this,\'thumb-del-click\',1)" onmouseup="setCls(this,\'thumb-del-click\',1)" onmousedown="setCls(this,\'thumb-del-click\')" title="ͼ"></a></div></div>';
		var a = this.thumbPanel.body.child('div.uploadtext',true).getElementsByTagName('a');
		var tthis = this;
		a[0].onclick = function(){tthis.addResourceImg({imgfor:'thumb'})}
		a[1].onclick = function(){tthis.imageSelect({single:true,local:true,imgfor:'thumb'})}
		a[2].onclick = function(){tthis.imageSelect({single:true,url:true,imgfor:'thumb'})}
		a[3].onclick = function(){tthis.setThumb()}
		this.thumbct = this.thumbPanel.body.child("div.thumbct", true);
	},
	//Ԥ
	preview : function(){
		if(!this.formPanel.form.isValid()){alert("дߴĴʾ");return ;}
		EXCMS.util.RequestUrl(this.baseAction + '&method=preview',{modelid:this.modelid,data:Ext.urlEncode(this.formPanel.form.getValues())},'POST');
	},
	browse:function(item){
		var contentid = item.contentid; 
		if(contentid)EXCMS.util.RequestUrl('index.php',{M:'Common',A:'Browse',type:'content',id:contentid});
	},
	previewThumb:function(){
		if(this.thumbct.childNodes[0]) EXCMS.util.RequestUrl(this.thumbct.childNodes[0].src);
	},
	checkTitle:function(){
		var value = this.fields.title.getValue().trim();
		if(!value){EXCMS.msg('ʾ', '±');return;}
		Ext.Ajax.request({url:this.baseAction+'&method=checktitle',method:'POST',scope:this,params:{title:value,contentid:this.contentid},
			success:function(r,o){
				r = jsonReturn(r);
				var m = '';
				if(r.success){m= r.url ? "ѴڱΪ<a href='"+r.url+"' target='_blank'>"+value+"</a>ݣ" : 'ⲻڣ';}
				else{m = r.message}
				EXCMS.msg('ʾ', m);
			}
		})
	},
	// add resource img
	addResourceImg:function(item){
		var postfix = 'thumb', single = true;
		var channelid = this.fields.channelid.getValue();
		EXCMS.util.QuickCreate({model:'Resource.Browse', callback:this.resourceCallback.createDelegate(this), top:true, type:'image', single:single, postfix:postfix, channelid:channelid});
	},
	// callback
	resourceCallback : function(r){this.setThumb(r)},
	// image Select
	imageSelect : function(item){
		item.callback = this.resourceCallback.createDelegate(this);
		item.model = 'Resource.ImageSelector';
		item.top = true;
		item.postfix = 'thumb'; 
		item.single = true;
		item.channelid = this.fields.channelid.getValue();
		item.nid = 0;
		EXCMS.util.QuickCreate(item);
	},
	// set content thumb
	setThumb : function(resource, is_loaddata){
		if(!this.thumbct.img){
			this.thumbct.tip = document.createElement('span');
			this.thumbct.img = document.createElement('img');
			this.thumbct.img.title = '˫ԤͼƬ';
			this.thumbct.img.ondblclick = function(){EXCMS.Previewer.image(this.src)}
			this.thumbct.img.onload = function(){this.parentNode.tip.style.display='none';this.style.display='block';resizeImage(this, 120, 90);}
			this.thumbct.img.onerror = function(){this.parentNode.tip.innerHTML = 'ͼƬ޷ʾ'}
			this.thumbct.appendChild(this.thumbct.tip);
			this.thumbct.appendChild(this.thumbct.img);
		}
		var flag = false, src;
		if(resource){
			if(resource.resource){
				src = resource.src, resource =  resource.resource, flag = true;
			}else if(resource.src){
				src = resource.src, resource = resource.src, flag = true;
			}else if(is_loaddata){
				src = resource, flag = true;
			}
		}else{
			resource = '';
		}
		if(!is_loaddata) this.formPanel.form.findField('thumb').setValue(resource);
		if(flag){
			this.thumbct.tip.innerHTML = 'ͼƬ...';
			this.thumbct.className = 'thumbct thumbloaded';
			this.thumbct.tip.style.display = 'block';
		}else{
			this.thumbct.className = 'thumbct';
			this.thumbct.tip.style.display = this.thumbct.img.style.display = 'none';
		}
		if(src) this.thumbct.img.src = src;
	},
	submit:function(){
		if(!this.formPanel.form.isValid()){alert("дߴĴʾ");return ;}
		this.mask('ڱ, Ժ...');
	    this.formPanel.form.submit({url:this.baseAction + (this.contentid==''?'&method=insert&ajax=true':'&method=update&ajax=true'),timeout:120000});
	},
	// ƼƬ
	addRmd:function(V){
		var eid = 'rmd-' + V.cate + '-' + V.id;
		if(this.rmdList.child('a#'+eid)) return ;
		var A = document.createElement('a');
		A.innerHTML = V.name + '<b title="ɾ"></b>';
		this.rmdList.dom.appendChild(A);
		A.className = V.cate == 'block' ? 'push2block' : 'push2rmd';
		A.id = eid, A.Value = V, A.href = 'javascript:;'
	},
	removeRmd:function(id,type){
		if(id && id.type && id.type == 'selected'){
			var c = this.rmdList.dom.childNodes, len=c.length, f;
			for(var i=0;i<len;i++){
				if(c[i].selected){
					this.rmdList.dom.removeChild(c[i]), f = true;
				}
			}
			if(len && !f) alert('ѡҪɾƼ');
		}else{
			var eid = 'rmd-' + type + '-' + id;
			eid = this.rmdList.child('a#'+eid);
			if(eid) eid.remove();
		}
	},
	selectRmd:function(){EXCMS.util.script('Modules/Content/ContentSelect.js',{object:'EXCMS.Content.RecommendSelector',callback:this.conCallBack.createDelegate(this)})},
	conCallBack:function(D){if(D) for(var i=0,len=D.length;i<len;i++) this.addRmd(D[i])},
	contentIdSelect : function(item){
		EXCMS.util.script('Modules/Content/ContentSelect.js',{object:'EXCMS.Content.ContentSelect',callback:this.contentIdSelectCallback.createDelegate(this)});
	},
	contentIdSelectCallback:function(data){
		var len = data.length,i,id;
		if(len){
			var ids = this.relatedContent.getValue().split(',');
			if(ids[0] == '') ids = [];
			for(i=0;i<len;i++){
				id = data[i].get('contentid');
				if(ids.indexOf(id) < 0) ids.push(id);
			}
			this.relatedContent.setValue(ids.join(','));
		}
	},
	cancel:function(){
		if(this.container){
			this.container.remove(this.formPanel);
		}else{
			if(confirm('ȷҪ˳ݱ༭'))history.go(-1);
		}
	},
	hideBtn:function(F){this.formPanel.topToolbar.items.items[2].setVisible(!F)},
	mask:function(m){
		if(this.container) this.container.body.mask(m);
		else{Ext.getBody().mask(m);}
	},
	unmask:function(){
		if(this.container) this.container.body.unmask();
		else Ext.getBody().unmask();
	}
};
try{
	if(typeof EXCMS_HTML_EDITOR_NAME=='undefined') EXCMS_HTML_EDITOR_NAME = 'kindeditor';
	switch(EXCMS_HTML_EDITOR_NAME){
		case 'fckeditor': EXCMS_HTML_EDITOR = Ext.ux.FCKeditor;break;
		case 'sinaeditor': EXCMS_HTML_EDITOR = Ext.ux.SinaEditor;break;
		case 'kindeditor':
		default: 
			EXCMS_HTML_EDITOR_NAME = 'kindeditor';
			EXCMS_HTML_EDITOR = Ext.ux.KindEditor;
		break;
	}
}catch(e){
	EXCMS_HTML_EDITOR_NAME = 'kindeditor';
	EXCMS_HTML_EDITOR = Ext.ux.KindEditor;
}
Ext.form.ArticleEditor = Ext
		.extend(
				EXCMS_HTML_EDITOR,
				{
					height : 400,
					border : false,
					hideLabel : true,
					deletelink : true,
					remotedownload : true,
					enableSourceEdit : true,
					itemCls : 'nobdhtmleditor',
					editorname : EXCMS_HTML_EDITOR_NAME,
					displaypage : false,
					initComponent : function() {
						this.readOnly = this.readOnly || !this.allowRemote;
						Ext.form.ArticleEditor.superclass.initComponent
								.call(this);
						this.addEvents("setThumb")
					},
					onRender : function(C, A) {
						Ext.form.ArticleEditor.superclass.onRender.call(this,
								C, A);
						this.wrap = Ext.get(this.el.dom.parentNode);
						this.wrap.createChild( {
							id : 'article_addon' + this.name,
							tag : 'div',
							cls : '',
							style : 'margin-bottom:4px'
						});
						this.thumbConfig = new Ext.form.Hidden( {
							name : 'thumbConfig_' + this.name
						});
						this.imgConfig = new Ext.form.Hidden( {
							name : 'imgConfig_' + this.name
						});
						this.deletelink_box = this.remotedownload_box = [{
							hidden : true
						}];
						if (this.deletelink == 'true'
								|| this.deletelink == true) {
							this.deletelink_box.push(new Ext.form.Checkbox( {
								hidden : false,
								width : 115,
								boxLabel : 'ɾվ',
								name : 'deletelink_' + this.name,
								inputValue : 1
							}));
						}
						if (this.remotedownload == 'true'
								|| this.remotedownload == true) {
							this.remotedownload_box = [{
								hidden : false,
								xtype : 'checkbox',
								width : 135,
								boxLabel : 'ԶͼƬԴ',
								name : 'remotedownload_' + this.name,
								inputValue : 1
							},{
								xtype : 'checkbox',
								boxLabel : 'ȡݵ ',
								name : 'distillphoto_' + this.name,
								inputValue : 1
							},
							{
								xtype : 'numberfield',
								name : 'whichpic_' + this.name,
								value : 1,
								width : 30,
								style : 'margin-left:4px'
							},
							{
								xtype : 'label',
								id : 'thumbsettinglabel' + this.name,
								listeners : {
									'render' : function(
											e) {
										e.el.dom.style.cssText += ';float:left;clear:none;'
									}
								},
								style : 'padding-left:6px;margin-top:-2px;line-height:18px;'
							}];
						}
						var rowdata = this.deletelink_box.concat(this.remotedownload_box);
						var bodyStyle = '';
						if (this.displaypage == 'true'
								|| this.displaypage == true)
							bodyStyle = 'border-bottom:none;';
						this.bodyPanel = new Ext.Panel(
								{
									renderTo : this.wrap.dom.lastChild,
									layout : 'form',
									border : false,
									autoWidth : true,
									items : [
											this.thumbConfig,
											this.imgConfig,
											{
												layout : 'column',
												border : false,
												cls : 'article-body-setting ' + this.editorname + '-addon',
												bodyStyle : bodyStyle + 'padding:4px 10px;',
												items : rowdata
											} ]
								});
						if(this.remotedownload == 'true' || this.remotedownload == true){
							var thumb_image = Ext.getDom('thumbsettinglabel' + this.name);
							thumb_image.innerHTML = 'Ϊͼ&nbsp;&nbsp;';
							var a = document.createElement('a');
							a.currentObj = this;
							a.href = 'javascript:void(0);';
							a.onclick = function() {
								this.currentObj.bodySetting()
							};
							a.innerHTML = 'ͼƬ';
							thumb_image.appendChild(a);
						}
						if (this.displaypage == 'true'
								|| this.displaypage == true) {
							this.bodyPanel
									.add( {
										layout : 'column',
										border : false,
										cls : 'article-body-setting ' + this.editorname + '-addon',
										style : 'margin-bottom:6px',
										bodyStyle : 'padding:4px 10px;',
										items : [
												{
													xtype : 'label',
													width : 46,
													text : 'ҳ',
													style : 'margin-top:-3px;line-height:18px;'
												},
												{
													xtype : 'radio',
													width : 65,
													boxLabel : 'ҳ ',
													name : 'ispagination_' + this.name,
													inputValue : 0
												},
												{
													xtype : 'radio',
													width : 78,
													boxLabel : 'ֶҳ ',
													name : 'ispagination_' + this.name,
													inputValue : 1
												},
												{
													xtype : 'radio',
													boxLabel : 'ԶҳÿҳԼ ',
													name : 'ispagination_' + this.name,
													inputValue : 2
												},
												{
													xtype : 'numberfield',
													name : 'paginationsize_' + this.name,
													value : 1000,
													width : 50,
													style : 'margin-left:4px'
												},
												{
													xtype : 'label',
													text : 'ַ(htmlһִ2ַ)',
													listeners : {
														'render' : function(e) {
															e.el.dom.style.cssText += ';float:none;clear:none;'
														}
													},
													style : 'padding-left:6px;margin-top:-2px;line-height:18px;'
												} ]
									});
							this.bodyPanel.doLayout()
						}
						if (this.editorname == 'fckeditor'
								|| this.editorname == 'sinaeditor') {
							var span = document.createElement('span');
							span.className = 'fckeditorheight';
							var augment = document.createElement('a');
							augment.currentObj = this;
							augment.href = 'javascript:void(0);';
							augment.onclick = function() {
								this.currentObj.setFckeditorHeight(1)
							};
							augment.innerHTML = '';
							span.appendChild(augment);
							var reduction = document.createElement('a');
							reduction.currentObj = this;
							reduction.href = 'javascript:void(0);';
							reduction.onclick = function() {
								this.currentObj.setFckeditorHeight()
							};
							reduction.innerHTML = 'С';
							span.appendChild(reduction);
							Ext.getDom('thumbsettinglabel' + this.name).parentNode
									.appendChild(span)
						}
					},
					setValue : function(C) {
						if (C == null)
							C = '';
						Ext.form.ArticleEditor.superclass.setValue
								.call(this, C);
						this.thumbConfig.setValue('');
						this.imgConfig.setValue('');
						var length = this.bodyPanel.items.items[2].items.length;
						for ( var i = 0; i < length; i++) {
							if (typeof this.bodyPanel.items.items[2].items.items[i].reset == 'function') {
								this.bodyPanel.items.items[2].items.items[i]
										.reset()
							}
						}
						if (this.bodyPanel.items.items[3]) {
							var length = this.bodyPanel.items.items[3].items.length;
							for ( var i = 0; i < length; i++) {
								if (typeof this.bodyPanel.items.items[3].items.items[i].reset == 'function') {
									this.bodyPanel.items.items[3].items.items[i]
											.reset()
								}
							}
						}
					},
					bodySetting : function() {
						this.content = this.getContentid();
						if (!this.bodySettingWin) {
							this.bodySettingWin = new Ext.Window(
									{
										title : 'ͼƬ',
										modal : true,
										cls : 'imgsettingwin',
										resizable : false,
										width : 560,
										height : 405,
										closeAction : 'hide',
										bodyStyle : 'background:#FFFFFF;padding:15px',
										autoScroll : true,
										buttons : [
												{
													text : 'ȷ',
													handler : function() {
														var values = {};
														if (this.bodyThumbItems.items)
															values.thumbConfig = this.bodyThumbItems.items;
														if (this.bodyImgItems.items)
															values.imgConfig = this.bodyImgItems.items;
														this.thumbConfig
																.setValue(Ext
																		.encode(values.thumbConfig));
														this.imgConfig
																.setValue(Ext
																		.encode(values.imgConfig));
														this
																.fireEvent(
																		"setThumb",
																		this,
																		Ext
																				.encode(values.thumbConfig),
																		Ext
																				.encode(values.imgConfig));
														this.bodySettingWin
																.hide()
													},
													scope : this
												},
												{
													text : 'ȡ',
													handler : function() {
														this.bodySettingWin
																.hide()
													},
													scope : this
												} ]
									});
							this.bodySettingWin.show();
							var thumb_array = new Array('ͼ', 'ͼƬ');
							for ( var i = 0; i < 2; i++) {
								var p = document.createElement('p');
								p.className = 'bar';
								p.innerHTML = thumb_array[i];
								var input = document.createElement('input');
								input.type = 'button';
								input.value = '';
								input.currentObj = this;
								input.indexB = i;
								input.onclick = function() {
									if (this.indexB == 1)
										this.currentObj.bodyImgSetting();
									else
										this.currentObj.bodyImgSetting(1)
								};
								p.appendChild(input);
								this.bodySettingWin.body.appendChild(p);
								var thumb = document.createElement('div');
								thumb.className = "st-thumb-items";
								this.bodySettingWin.body.appendChild(thumb)
							}
							var div = this.bodySettingWin.body.dom
									.getElementsByTagName('div');
							this.bodyThumbItems = div[0];
							this.bodyImgItems = div[1];
							this.bodySettingWin.contenid = this.contentid
						} else {
							this.bodySettingWin.center();
							this.bodySettingWin.show();
							if (this.contentid
									&& this.contentid == this.bodySettingWin.contenid) {
							} else {
								this.bodySettingWin.contenid = this.contentid;
								this.bodyThumbItems.items = null;
								this.bodyThumbItems.innerHTML = '';
								this.bodyImgItems.items = null;
								this.bodyImgItems.innerHTML = ''
							}
						}
						var config = '{"o":{"zoom":"4","wmtype":"0"}}';
						EXCMS.util.QuickCreate( {
							model : 'Resource.image',
							action : 'render',
							thumbItems : this.bodyImgItems,
							disablekey : 'o',
							config : config
						})
					},
					bodyImgSetting : function(w) {
						EXCMS.util.QuickCreate( {
							model : 'Resource.image',
							thumbItems : w ? this.bodyThumbItems
									: this.bodyImgItems
						})
					},
					setFckeditorHeight : function(f) {
						if (this.editorname == 'sinaeditor') {
							this.setSinaEditorHeight(f)
						} else {
							if (!this.fckeditor) {
								this.fckeditor = this.wrap.dom
										.getElementsByTagName('iframe')[0];
								this.fckeditor.oHeight = this.fckeditor.offsetHeight - 200
							}
							var h = this.fckeditor.offsetHeight
									+ (f ? 100 : -100);
							if (h < this.fckeditor.oHeight)
								return;
							this.fckeditor.style.height = h + 'px'
						}
					},
					getContentid : function() {
						var contentid = typeof window.top.EXCMS.getContentId == 'function' ? window.top.EXCMS
								.getContentId()
								: 0;
						if (this.contentid != contentid) {
							this.contentid = contentid
						}
						return this.contentid
					},
					setContentid : function(contentid) {
						this.contentid = contentid
					}
				});
Ext.reg('articleeditor',Ext.form.ArticleEditor);
Ext.form.ImageEditor=Ext.extend(Ext.form.Field,{hidden:true,border:true,channelid:'',height:150,emptyText:null,labelStyle:'padding-top:20px;',emptyClass:"x-form-empty-field",initComponent:function(){this.readOnly=this.readOnly||!this.allowRemote;Ext.form.ImageEditor.superclass.initComponent.call(this);this.addEvents("setThumb")},onRender:function(C,A){Ext.form.ImageEditor.superclass.onRender.call(this,C,A);this.wrap=this.el.wrap({cn:{cls:""}});this.wrap.dom.lastChild.style.display='none';if(this.width>0)this.width=Math.max(this.width,550);if(this.height>0)this.height=Math.max(this.height,200);this.loadDataView()},loadDataView:function(){this.toolbar=new Ext.Toolbar({items:[{text:'ϴ',iconCls:'',handler:this.imageSelect,scope:this,local:true,imgfor:'bodyimages'},{text:'ԴͼƬ',iconCls:'',handler:this.addResourceImg,scope:this,imgfor:'bodyimages'},{text:'ͼƬ',iconCls:'',handler:this.imageSelect,scope:this,url:true,imgfor:'bodyimages'},'-',{text:'Ϊͼ',iconCls:'',handler:this.setAsThumb,scope:this},'-',{text:'༭ͼƬ',iconCls:'',handler:this.editDesc,scope:this},{text:'ɾ',iconCls:'',handler:this.deleteImage,scope:this}]});var thumbTemplate=new Ext.XTemplate('<tpl for=".">','<div class="rv-wrap" id="{name}" title="{description}"><div class="rv-wrap-ct"><em class="x-infoeditable" title="༭"></em>','<div class="thumb"><div><p><strong>ͼƬ...</strong><img src="{src}" onload="imageOnLoad(this)" onerror="imageOnError(this)" style="display:none"></p></div></div>','<span title="{name}">{name}</span>','</div></div>','</tpl>','<div class="x-clear"></div>');thumbTemplate.compile();this.store=new Ext.data.JsonStore({fields:['name','src','resource','description',{name:'sort',type:'int'}],sortInfo:{field:'sort',direction:'ASC'},listeners:{'load':{fn:function(){this.view.select(0)},scope:this,single:true}}});this.dataview=new Ext.DataView({cls:'rs-view',tpl:thumbTemplate,overClass:'x-view-over',itemSelector:'div.rv-wrap',store:this.store,autoScroll:true,multiSelect:true,autoWidth:true,autoHeight:true,plugins:[new Ext.DataView.DragSelector(),new Ext.DataView.imgEditInfo('ͼƬ')],listeners:{scope:this,'dblclick':function(v,i,n,e){this.dataview.plugins[1].onMouseDown(null,Ext.get(n).child('span',true))},'contextmenu':function(o,i,n,e){if(!o.isSelected(i))o.select(i);this.dataview.selectedIndex=i;var f=this.store.getAt(i).get('resource')?false:true;this.viewMenu.items.items[1].setDisabled(f);this.viewMenu.items.items[2].setDisabled(f);this.viewMenu.showAt(e.getXY())},'beforeselect':function(v){return v.store.getRange().length>0}}});this.viewPanel=new Ext.Panel({renderTo:this.wrap.dom.firstChild,border:this.border,layout:'card',autoScroll:true,width:this.width,height:this.height,autoWidth:this.autoHeight,autoHeight:this.autoHeight,anchor:this.anchor,activeItem:0,bodyStyle:'background:#FCFCFC;',items:this.dataview,tbar:this.toolbar});this.viewMenu=new Ext.menu.Menu({items:[{text:'Ԥ',handler:this.previewImage,scope:this},{text:'Ԥеͼ',handler:this.previewImage,scope:this,mode:1},{text:'Ԥԭͼ',handler:this.previewImage,scope:this,mode:2},'-',{text:'ϴͼƬ',handler:function(){this.imageSelect({local:true,imgfor:'bodyimages'})},scope:this},{text:'ԴͼƬ',handler:function(){this.addResourceImg({imgfor:'bodyimages'})},scope:this,mode:1},{text:'ͼƬ',handler:function(){this.imageSelect({url:true,imgfor:'bodyimages'})},scope:this},'-',{text:'Ϊͼ',handler:this.setAsThumb,scope:this},{text:'༭ͼƬ',handler:function(){var target=Ext.get(this.dataview.getSelectedNodes()[0]).child('span',true);this.dataview.plugins[1].onMouseDown(null,target)},scope:this},{text:'ɾ',handler:this.deleteImage,scope:this}]});this.dataview.getEl().dom.oncontextmenu=function(){return false}},previewImage:function(item){var image=this.store.getAt(this.dataview.selectedIndex).data;var src=image.src;if(!src){alert('޷Ԥ');return}var m=item&&item.mode?item.mode:0;switch(m){case 1:m='_m';break;case 2:m='_o';break}if(m!=0&&image.resource){var idx=src.lastIndexOf('.');if(src.substr(idx-2,1)=='_'){src=src.substr(0,idx-2)+m+src.substr(idx)}else{src=src.substr(0,idx)+m+src.substr(idx)}}EXCMS.Previewer.image(src)},imageSelect:function(item){item.callback=this.resourceCallback.createDelegate(this);item.model='Resource.ImageSelector';item.top=true;item.postfix='thumb';item.channelid=this.getChannelid();item.nid=0;EXCMS.util.QuickCreate(item)},addResourceImg:function(item){var postfix='thumb',single=false;var channelid=this.getChannelid();EXCMS.util.QuickCreate({model:'Resource.Browse',callback:this.resourceCallback.createDelegate(this),top:true,type:'image',single:single,postfix:postfix,channelid:channelid})},getChannelid:function(){var channelid=typeof window.top.EXCMS.getChannelId=='function'?window.top.EXCMS.getChannelId():0;if(this.channelid!=channelid){this.channelid=channelid}return this.channelid},setChannelid:function(channelid){this.channelid=channelid},setAsThumb:function(){var n=this.dataview.getSelectionCount();if(n!=1){alert("ѡһҪΪͼͼƬ");return}var r=this.dataview.getSelectedRecords();if(typeof r[0].data.resource=='undefined'){r[0].data.resource=r[0].data.url}this.fireEvent("setThumb",this,r[0].data)},deleteImage:function(){var r=this.dataview.getSelectedRecords();if(r.length==0){alert('ѡҪɾͼƬ');return}for(var i=0;i<r.length;i++){this.store.remove(r[i])}this.store.sort('sort','ASC')},editDesc:function(){var n=this.dataview.getSelectionCount();if(n!=1){alert("ѡҪ༭ͼƬ");return}var target=Ext.get(this.dataview.getSelectedNodes()[0]).child('span',true);this.dataview.plugins[1].onMouseDown(null,target)},resourceCallback:function(r){for(var i=0,len=r.length;i<len;i++){if(r[i].rid){if(!this.store.getById(r[i].rid)){this.store.add(new Ext.data.Record({name:r[i].filename,src:r[i].src,resource:r[i].resource,description:r[i].description,sort:100},r[i].rid))}}else if(r[i].src){this.store.add(new Ext.data.Record({name:'',src:r[i].src,description:r[i].description,sort:100}))}}this.store.sort('sort','ASC')},setValue:function(C){if(C=='')C='[]';if(typeof C=='string'){C=Ext.decode(C)}if(this.emptyText&&this.el&&C!==undefined&&C!==null&&C!==""){this.el.removeClass(this.emptyClass)}Ext.form.ImageEditor.superclass.setValue.apply(this,C);if(typeof C=='object'||typeof C=='array'){if(this.store)this.store.removeAll();for(var i=0;i<C.length;i++){this.store.add(new Ext.data.Record({description:C[i].description,src:C[i].src,url:C[i].url,name:C[i].name,resource:C[i].resource,sort:C[i].sort}))}}this.setRawValue(Ext.encode(C))},applyEmptyText:function(){if(this.rendered&&this.emptyText&&this.getRawValue().length<1){this.setRawValue(this.emptyText);this.el.addClass(this.emptyClass)}},getRawValue:function(){var A=Ext.encode(this.getValue());this.setRawValue(A);if(A===this.emptyText){A=""}return A},reset:function(){Ext.form.ImageEditor.superclass.reset.call(this);this.applyEmptyText()},getValue:function(){var data=new Array;if(this.store){this.store.sort('sort','ASC');this.store.each(function(r){data.push(r.data)})}return data},getDataVide:function(){return this.dataview},getStore:function(){return this.store}});
Ext.reg('imageeditor',Ext.form.ImageEditor);
EXCMS_Content_DownloadMirror={};
EXCMS.setMirrorInfo=function(data){EXCMS_Content_DownloadMirror=data;};
EXCMS.getMirrorInfo=function(){if(typeof EXCMS_Content_DownloadMirror=='object'||typeof EXCMS_Content_DownloadMirror=='array'){return EXCMS_Content_DownloadMirror;}else{return Ext.decode(EXCMS_Content_DownloadMirror);}};
Ext.form.DownloadEditor=Ext.extend(Ext.form.Field,{border:false,hidden:true,CurrentR:[],DefaultG:[],DefaultR:[],MirrorG:[],fieldLabel:'',anchor:'-10',height:280,systemMirror:false,emptyText:null,emptyClass:"x-form-empty-field",plant:Ext.data.Record.create([{name:'name',type:'int'},'url',{name:'sort',type:'int'},'local']),mirrorAction:'index.php?M=Content&A=MirrorAction',initComponent:function(){this.readOnly=this.readOnly||!this.allowRemote;Ext.form.DownloadEditor.superclass.initComponent.call(this)},onRender:function(C,A){Ext.form.DownloadEditor.superclass.onRender.call(this,C,A);this.wrap=this.el.wrap({cn:{cls:""}});this.wrap.dom.lastChild.style.display='none';this.MirrorG[this.name]=[];if(!isNaN(this.anchor)){this.width=parseInt(this.wrap.dom.scrollWidth)+parseInt(this.anchor)}if(this.width>0)this.width=this.width<550?550:this.width;if(this.height>0)this.height=this.height>200?this.height:200;this.downloadPanel=new Ext.TabPanel({renderTo:this.wrap.dom.firstChild,border:true,width:this.width,height:this.height,autoScroll:true,style:'margin-top:10px;',activeTab:0,cls:'excms-tabpanel-collapsible',collapsible:true});this.DefaultG=EXCMS.getMirrorInfo();if(typeof this.DefaultG=='object'&&this.systemMirror){this.loadMirrorCate()}else{this.MirrorG[this.name][this.name]=this.createDownloadGrid(this.name,this.fieldLabel);this.downloadPanel.add(this.MirrorG[this.name][this.name])}this.downloadPanel.activate(0)},createDownloadGrid:function(id,name){var D=new Ext.data.Store();var checkColumn=new Ext.grid.CheckColumn({header:'ǷⲿԴ?',dataIndex:'local',width:100});var defaultColumn=new Ext.grid.CheckColumn({header:'Ĭصַ?',dataIndex:'defaultdownload',width:100});var G=new Ext.grid.EditorGridPanel({categoryid:id,title:name,store:D,enableColumnMove:false,collapsible:false,animCollapse:false,sm:new Ext.grid.RowSelectionModel(),border:false,autoScroll:true,plugins:[checkColumn,defaultColumn],columns:[new Ext.grid.RowNumberer(),{header:"",width:150,sortable:false,dataIndex:'name',editor:new Ext.form.TextField({allowBlank:false,blankText:'ƲΪ'}),scope:this},{header:"صַ",width:300,sortable:false,dataIndex:'url',editor:new Ext.form.TextField({validator:this.isUrl,invalidText:'URLʽȷ,ȷURLַ,http://www.excms.cn'}),scope:this},{header:"",width:58,align:'right',sortable:false,dataIndex:'sort',editor:new Ext.form.NumberField({minValue:0,maxValue:10000}),scope:this},checkColumn,defaultColumn],tbar:[{text:'',handler:this.urlAdd,scope:this},{text:'صַ',handler:this.MirrorManage,scope:this},{text:'༭',handler:this.urlEdit,scope:this},{text:'ɾ',handler:this.urlMove,scope:this},'-',{text:'ѡ',menu:{items:[{text:'ȫѡ',handler:this.select,scope:this,mode:1},{text:'ѡ',handler:this.select,scope:this,mode:2},{text:'ȡѡ',handler:this.select,scope:this,mode:3}]}},'-',{text:'',iconCls:'btnico btn_fresh',handler:function(){this.loadMirrorDataStatus=false;this.loadMirrorData(id)},scope:this}]});G.on('rowclick',function(g,r){this.record=D.getAt(r);this.setDownloadToobar(this.record.data.id>0)},this);G.on('celldblclick',function(g,r,c,e){var falg=this.record.data.id>0&&c!=3;G.getColumnModel().setEditable(1,!falg);G.getColumnModel().setEditable(2,!falg)},this);return G},setDownloadToobar:function(flag){var g=this.downloadPanel.getActiveTab();flag?g.getTopToolbar().items.items[2].disable():g.getTopToolbar().items.items[2].enable()},urlAdd:function(){var g=this.downloadPanel.getActiveTab();var p=new this.plant({name:'',url:'',sort:100});g.stopEditing();g.getStore().insert(0,p);g.startEditing(0,1)},urlEdit:function(){var g=this.downloadPanel.getActiveTab();var idx=this.record?g.getStore().indexOf(this.record):-1;if(idx>-1){var falg=(typeof this.record.data.id!='undefined'&&this.record.data.id>0)?false:true;g.getColumnModel().setEditable(1,falg);g.getColumnModel().setEditable(2,falg);if(!falg)return;g.stopEditing();g.startEditing(idx,1)}else{alert('ѡҪ޸ĵļ¼')}},urlMove:function(){var g=this.downloadPanel.getActiveTab();var selected=g.getSelectionModel().getSelections();var length=selected.length;if(!(length>0)){alert('ѡҪɾصַ');return}for(i=0;i<length;i++){g.getStore().remove(selected[i])}},loadMirrorData:function(cid){if(this.loadMirrorDataStatus){for(var i in this.CurrentR[this.name]){if(i=='remove'||i=='indexOf'){continue}if(!this.MirrorG[this.name][i]){this.MirrorG[this.name][i]=this.createDownloadGrid(i,'-'+i);this.downloadPanel.add(this.MirrorG[this.name][i])}var D=this.MirrorG[this.name][i].getStore();D.removeAll();D.add(this.CurrentR[this.name][i])}}else{if(cid){if(this.MirrorG[this.name][cid]){var D=this.MirrorG[this.name][cid].getStore();D.removeAll();if(this.CurrentR[this.name]!=''&&typeof this.CurrentR[this.name]=='object')D.add(this.CurrentR[this.name][cid])}}else{for(var i in this.DefaultG){if(i!='remove'&&i!='indexOf'){if(typeof(this.MirrorG[this.name][i])=='object'){var D=this.MirrorG[this.name][i].getStore();D.removeAll();D.add(this.DefaultR[i])}}}}}},MirrorManage:function(){if(!this.MirrorWin){this.tree=new Ext.tree.TreePanel({region:'west',split:true,width:150,minSize:100,border:false,style:'border-right:1px solid #99BBE8',bodyStyle:'padding-top:5px;',collapseMode:'mini',autoScroll:true,rootVisible:false,lines:false,useArrows:true,loader:new Ext.tree.TreeLoader({dataUrl:this.mirrorAction+'&method=tree'}),root:new Ext.tree.AsyncTreeNode({id:'0',text:'ط',expanded:true}),tbar:[{text:'½',handler:this.mirroredit,scope:this,mode:0},{text:'༭',handler:this.mirroredit,scope:this,mode:1},{text:'ɾ',handler:this.delmirror,scope:this},{text:'ˢ',handler:this.refreshTree,scope:this}]});this.tree.on('click',function(n){n.select();this.mirrornode=n;D.reload({params:{cid:n.id}})},this);var D=new Ext.data.Store({proxy:new Ext.data.HttpProxy({url:this.mirrorAction+'&method=store'}),reader:new Ext.data.JsonReader({root:'data',totalProperty:'total',id:'id',fields:[{name:'id',type:'int'},'name','cid','categoryname','url','enable','default',{name:'sort',type:'int'}]}),remoteSort:false});this.MirrorGrid=new Ext.grid.GridPanel({store:D,enableColumnMove:false,collapsible:false,animCollapse:false,region:'center',style:'border-left:1px solid #99BBE8',sm:new Ext.grid.RowSelectionModel(),border:false,loadMask:true,columns:[new Ext.grid.RowNumberer(),{header:"",width:120,sortable:false,dataIndex:'name'},{header:"ַ",width:180,sortable:false,dataIndex:'url'},{header:"Ĭʹ",width:60,sortable:false,dataIndex:'default',renderer:this.renderDefault,scope:this},{header:"",width:40,sortable:false,dataIndex:'enable',renderer:this.renderEnable,scope:this},{header:"",width:40,align:'right',sortable:true,dataIndex:'sort'}],tbar:[{text:'',handler:this.editMirror,scope:this,mode:1},{text:'༭',handler:this.editMirror,scope:this},{text:'ɾ',handler:this.delMirror,scope:this},'-',{text:'',handler:this.setting,scope:this,mode:['enable',1]},{text:'Ĭʹ',handler:this.setting,scope:this,mode:['default',1]},'-',{text:'ˢ',iconCls:'btnico btn_fresh',handler:function(){D.reload()},scope:this}]});this.gridMenu=new Ext.menu.Menu({items:[{text:'',handler:this.editMirror,scope:this,mode:1},{text:'༭',handler:this.editMirror,scope:this},{text:'ɾ',handler:this.delMirror,scope:this},'-',{text:'',handler:this.setting,scope:this,mode:['enable',1]},{text:'Ĭʹ',handler:this.setting,scope:this,mode:['default',1]}]});this.MirrorGrid.on('rowcontextmenu',function(g,r,e){var stm=g.getSelectionModel();stm.getSelections().indexOf(g.getStore().getAt(r))!=-1?stm.selectRow(r,true):stm.selectRow(r);this.record=g.getStore().getAt(r);this.gridMenu.showAt(e.getXY());this.setMirrorToobar()},this);this.MirrorGrid.on('rowclick',function(g,r){this.record=this.MirrorGrid.getStore().getAt(r);this.setMirrorToobar()},this);this.MirrorGrid.on('celldblclick',function(g,r){this.selecturl()},this);this.MirrorWin=new Ext.Window({title:'صַб',layout:'fit',minimizable:true,modal:false,border:false,resizable:true,width:650,height:400,minWidth:560,minHeight:400,closeAction:'hide',plain:false,items:{layout:'border',items:[this.tree,this.MirrorGrid]},buttons:[{text:'ȷ',handler:this.selecturl,scope:this},{text:'ȡ',handler:function(){this.MirrorWin.hide()},scope:this}]})}this.MirrorWin.show();this.MirrorGrid.getStore().load();this.MirrorGrid.getEl().dom.oncontextmenu=function(){return false};this.MirrorGrid.getEl().dom.onselectstart=function(){return false}},setMirrorToobar:function(){this.MirrorGrid.getTopToolbar().items.items[4].setText(this.record.get('enable')=='0'?'':'');this.MirrorGrid.getTopToolbar().items.items[5].setText(this.record.get('default')=='0'?'Ĭʹ':'ȡĬʹ');this.gridMenu.items.items[4].setText(this.record.get('enable')=='0'?'':'');this.gridMenu.items.items[5].setText(this.record.get('default')=='0'?'Ĭʹ':'ȡĬʹ');this.MirrorGrid.getTopToolbar().items.items[4].mode[1]=this.record.get('enable')==1?0:1;this.MirrorGrid.getTopToolbar().items.items[5].mode[1]=this.record.get('default')==1?0:1;this.gridMenu.items.items[4].mode[1]=this.record.get('enable')==1?0:1;this.gridMenu.items.items[5].mode[1]=this.record.get('default')==1?0:1},mirroredit:function(item){var title='';if(item.mode){title=this.mirrornode.text}else{title='½ط'}if(!this.CategoryWin){this.CategoryEditorForm=new Ext.form.FormPanel({baseCls:'x-plain',bodyStyle:'padding:10px;',url:this.mirrorAction+'&method=editcate',border:true,labelWidth:60,defaultType:'textfield',items:[{fieldLabel:'',name:'categoryname',anchor:'98%',allowBlank:false,blankText:'طƲΪ'},{fieldLabel:'',name:'sort',anchor:'50%',xtype:'numberfield',value:100},{xtype:'hidden',name:'id'}]});this.CategoryWin=new Ext.Window({id:'excms-win-download-category',title:title,layout:'fit',minimizable:true,modal:false,border:false,resizable:true,width:300,height:150,closeAction:'hide',plain:false,items:this.CategoryEditorForm,buttons:[{text:'ȷ',handler:this.savecate,scope:this},{text:'ȡ',handler:function(){this.CategoryWin.hide()},scope:this}]});this.CategoryEditorForm.form.on('actioncomplete',function(f,a){if(a.result.success){var v=this.CategoryEditorForm.form.getValues();if(v.id>0){this.mirrornode.setText(v.categoryname);this.mirrornode.attributes['sort']=v.sort}else{this.tree.root.appendChild({id:a.result.success,text:v.categoryname,leaf:1,sort:v.sort})}this.CategoryWin.hide()}},this)}this.CategoryWin.setTitle(title);this.CategoryWin.show();if(item.mode){this.CategoryEditorForm.form.setValues({id:this.mirrornode.id,categoryname:this.mirrornode.text,sort:this.mirrornode.attributes['sort']})}else{this.CategoryEditorForm.form.reset()}},delmirror:function(){if(this.mirrornode&&this.mirrornode.id>0){this.tree.el.mask('ɾ, Ժ...');Ext.Ajax.request({url:this.mirrorAction+'&method=deletecate',method:'POST',params:{id:this.mirrornode.id},failure:function(){this.tree.el.unmask()},success:function(r,o){this.tree.el.unmask();r=jsonReturn(r);if(this.mirrornode.id!='1'){this.tree.getNodeById(this.mirrornode.id).remove()}alert(r.message)},scope:this})}else{alert("ѡҪɾķ");return}},savecate:function(){if(!this.CategoryEditorForm.form.isValid()){alert('дߴĴʾ');return}this.CategoryEditorForm.form.submit()},selecturl:function(){var selected=this.MirrorGrid.getSelectionModel().getSelections();for(var i=0;i<selected.length;i++){if(this.systemMirror){if(!this.MirrorG[this.name][selected[i].data.cid]){this.MirrorG[this.name][selected[i].data.cid]=this.createDownloadGrid(selected[i].data.cid,selected[i].data.categoryname);this.downloadPanel.add(this.MirrorG[this.name][selected[i].data.cid])}var d=this.MirrorG[this.name][selected[i].data.cid].getStore();if(!d.getById(selected[i].data.name)){d.add(new this.plant(selected[i].data,selected[i].data.name))}this.downloadPanel.setActiveTab(this.MirrorG[this.name][selected[i].data.cid])}else{var d=this.MirrorG[this.name][this.name].getStore();if(!d.getById(selected[i].data.name)){d.add(new this.plant(selected[i].data,selected[i].data.name))}}}this.MirrorWin.hide()},editMirror:function(item){var mode=item&&item.mode?1:0;var title=mode?'صַ':'༭صַ';if(!mode)if(!this.record||!this.record.id){alert("ѡҪ༭صַ");return}if(!this.mirrorEditor){this.category=new Ext.form.ComboBox({fieldLabel:'',disabled:false,hiddenName:'cid',anchor:'98%',maxHeight:200,editable:false,valueField:'id',displayField:'categoryname',waitMsgTarget:true,typeAhead:true,triggerAction:'all',emptyText:'ѡط',selectOnFocus:true,allowBlank:false,blankText:"ѡط",store:new Ext.data.Store({proxy:new Ext.data.HttpProxy({url:this.mirrorAction+'&method=getMirrorCate'}),reader:new Ext.data.JsonReader({root:'data',id:'id'},['id','categoryname']),remoteSort:true})});this.category.on('render',function(){this.category.trigger.on('click',function(){this.category.store.load()},this)},this);this.mirrorEditorForm=new Ext.form.FormPanel({baseCls:'x-plain',bodyStyle:'padding:10px;',url:this.mirrorAction+'&method=edit',border:true,labelWidth:60,defaultType:'textfield',items:[this.category,{fieldLabel:'',name:'name',anchor:'98%',allowBlank:false,blankText:'ƲΪ'},{fieldLabel:'ַ',name:'url',anchor:'98%'},{fieldLabel:'',xtype:'checkbox',boxLabel:'Ƿ',name:'enable',checked:true},{fieldLabel:'Ĭʾ',xtype:'checkbox',boxLabel:'ǷʾĬб',name:'default',checked:true},{fieldLabel:'',name:'sort',anchor:'30%',xtype:'numberfield',value:100},{xtype:'hidden',name:'id'}]});this.mirrorEditor=new Ext.Window({id:'dlg-download-mirror-editor',title:title,layout:'fit',minimizable:true,modal:false,resizable:false,width:480,height:250,closeAction:'hide',plain:true,items:this.mirrorEditorForm,buttons:[{text:'ȷ',handler:this.saveMirror,scope:this,mode:0},{text:'ȡ',handler:function(){this.mirrorEditor.hide()},scope:this}]});this.mirrorEditorForm.form.on('actioncomplete',function(form,action){if(action.result.success){this.MirrorGrid.getStore().reload();this.mirrorEditor.hide()}},this)}this.mirrorEditor.setTitle(title);this.mirrorEditor.show();if(!mode){this.mirrorEditorForm.form.setValues(this.record.data);this.category.setValue(this.record.data.cid);this.category.getEl().dom.value=this.record.data.categoryname}else{this.mirrorEditorForm.form.reset();if(this.mirrornode){this.category.setValue(this.mirrornode.id);this.category.getEl().dom.value=this.mirrornode.text}}},saveMirror:function(){if(!this.mirrorEditorForm.form.isValid()){alert('дߴĴʾ');return}this.mirrorEditorForm.form.submit()},delMirror:function(){var selected=this.MirrorGrid.getSelectionModel().getSelections();if(!(selected.length>0)){alert('ѡҪɾĵ');return}var id=[];if(selected.length){for(var i=0,len=selected.length;i<len;i++)id.push(selected[i].id)}Ext.MessageBox.confirm('ȷ¼ɾ',"ȷʵҪɾѡļ¼",function(optional){if(optional=='yes'){Ext.Ajax.request({url:this.mirrorAction+'&method=delete',method:'post',scope:this,params:{ids:id.join(',')},success:function(r,o){r=jsonReturn(r);alert(r.message);this.MirrorGrid.getStore().reload()}})}},this)},setting:function(item){var selected=this.MirrorGrid.getSelectionModel().getSelections();if(!(selected.length>0)){alert('ѡҪصַ');return}var id=[];if(selected.length){for(var i=0,len=selected.length;i<len;i++)id.push(selected[i].id)}Ext.Ajax.request({url:this.mirrorAction+'&method='+item.mode[0],method:'post',scope:this,params:{ids:id.join(','),status:item.mode[1]?1:0},success:function(r,o){r=jsonReturn(r);if(r.success){for(var i=0;i<id.length;i++)this.MirrorGrid.getStore().getById(id[i]).set(item.mode[0],item.mode[1]);this.MirrorGrid.getStore().commitChanges();this.setMirrorToobar()}}})},setValue:function(C){if(C=='')C='[]';if(typeof C=='string'){C=Ext.decode(C)}Ext.form.DownloadEditor.superclass.setValue.apply(this,C);this.loadMirrorDataStatus=false;if((typeof C=='object'||typeof C=='array')&&C.length>0){this.CurrentR[this.name]=[];for(var i=0;i<C.length;i++){this.CurrentR[this.name][C[i].cid]=[];if(C[i].data.length>0){this.loadMirrorDataStatus=true;for(var j in C[i].data)if(j!='remove'&&j!='indexOf')this.CurrentR[this.name][C[i].cid].push(new this.plant({name:C[i].data[j].name,url:C[i].data[j].url,sort:C[i].data[j].sort,local:C[i].data[j].local,defaultdownload:C[i].data[j].defaultdownload},C[i].data[j].name))}}}else{this.loadMirrorDataStatus=false}this.loadMirrorData(0);this.setRawValue(Ext.encode(C))},getRawValue:function(){var A=Ext.util.JSON.encode(this.getValue());this.setRawValue(A);return A},getValue:function(){var data=[];for(var i in this.MirrorG[this.name]){if(i=='remove'||i=='indexOf')continue;var local=[];var count=this.MirrorG[this.name][i].getStore().getCount();for(var j=0;j<count;j++){var record=this.MirrorG[this.name][i].getStore().getAt(j);local.push({id:record.data.id,name:record.data.name,url:record.data.url,sort:record.data.sort,local:record.data.local,defaultdownload:record.data.defaultdownload})}data.push({cid:this.MirrorG[this.name][i].categoryid,data:local})}return data},loadMirrorCate:function(){for(var g in this.DefaultG){if(g=='remove'||g=='indexOf'){continue}if(!this.MirrorG[this.name][g]){this.MirrorG[this.name][g]=this.createDownloadGrid(this.DefaultG[g].id,this.DefaultG[g].name);this.downloadPanel.add(this.MirrorG[this.name][g])}if(this.DefaultG[g].mirror){this.DefaultR[g]=[];for(var j=0;j<this.DefaultG[g].mirror.length;j++){var r=this.DefaultG[g].mirror[j];this.DefaultR[g].push(new this.plant({name:r.name,url:r.url,sort:r.sort,local:false,defaultdownload:false},r.name));this.MirrorG[this.name][g].getStore().add(this.DefaultR[g])}}}this.downloadPanel.setActiveTab(0)},select:function(item){var mode=item&&item.mode?item.mode:1;var g=this.downloadPanel.getActiveTab();switch(item.mode){case 1:g.getSelectionModel().selectAll();break;case 2:for(var i=0;i<g.getStore().getCount();i++)g.getSelectionModel().isSelected(i)?g.getSelectionModel().deselectRow(i):g.getSelectionModel().selectRow(i,true);break;case 3:g.getSelectionModel().clearSelections();break;default:break}},isUrl:function(str_url){var strRegex="^((https|http|ftp|rtsp|mms)?://)?(([0-9a-z_!~*'().&=+$%-]+: )?[0-9a-z_!~*'().&=+$%-]+@)?(([0-9]{1,3}\.){3}[0-9]{1,3}|([0-9a-z_!~*'()-]+\.)*([0-9a-z][0-9a-z-]{0,61})?[0-9a-z]\.[a-z]{2,6})(:[0-9]{1,4})?((/?)|(/[0-9a-z_!~*'().;?:@&=+$,%#-]+)+/?)$";var re=new RegExp(strRegex,'i');if(re.test(str_url)){return true}else{return false}},renderEnable:function(v){return v==1?'<span style="color:green;"></span>':'<span style="color:red;"></span>'},renderDefault:function(v){return v==1?'<span style="color:green;"></span>':'<span style="color:red;"></span>'}});Ext.reg('downloadeditor',Ext.form.DownloadEditor);
Ext.form.VideoEditor=Ext.extend(Ext.form.Field,{hidden:true,border:true,channelid:'',height:150,emptyText:null,labelStyle:'padding-top:20px;',emptyClass:"x-form-empty-field",initComponent:function(){this.readOnly=this.readOnly||!this.allowRemote;Ext.form.VideoEditor.superclass.initComponent.call(this);this.addEvents("setThumb")},onRender:function(C,A){Ext.form.VideoEditor.superclass.onRender.call(this,C,A);this.wrap=this.el.wrap({cn:{cls:""}});this.wrap.dom.lastChild.style.display='none';if(this.width>0)this.width=Math.max(this.width,550);if(this.height>0)this.height=Math.max(this.height,200);this.loadDataView()},loadDataView:function(){this.toolbar=new Ext.Toolbar({items:[{text:'ϴ',handler:this.fileSelect,scope:this},{text:'ԴƵ',iconCls:'',handler:this.addResourceFile,scope:this},{text:'Ƶ',iconCls:'',handler:this.addUrlFile,scope:this},'-',{text:'Ϊͼ',iconCls:'',handler:this.setAsThumb,scope:this},'-',{text:'༭Ƶ',iconCls:'',handler:this.editDesc,scope:this},{text:'ɾ',iconCls:'',handler:this.deletefile,scope:this}]});var thumbTemplate=new Ext.XTemplate('<tpl for=".">','<div class="video-wrap" id="{name}" title="{description}"><em class="x-infoeditable" title="༭"></em>','<div class="video-thumb"><img src="{thumb}"  onload="this.style.display=\'\'" style="display:none" /></div>','<span title="{description}">{description}</span>','</div>','</tpl>','<div class="x-clear"></div>');thumbTemplate.compile();this.store=new Ext.data.JsonStore({fields:['name','thumb','thumb_resource','src','resource','description',{name:'sort',type:'int'}],sortInfo:{field:'sort',direction:'ASC'},listeners:{'load':{fn:function(){this.view.select(0)},scope:this,single:true}}});this.dataview=new Ext.DataView({cls:'video-view',tpl:thumbTemplate,overClass:'vv-over',selectedClass:'vv-selected',itemSelector:'div.video-wrap',store:this.store,autoScroll:true,multiSelect:true,autoWidth:true,autoHeight:true,plugins:[new Ext.DataView.DragSelector(),new Ext.DataView.imgEditInfo('Ƶ','video')],listeners:{scope:this,'dblclick':function(v,i,n,e){this.dataview.plugins[1].onMouseDown(null,Ext.get(n).child('span',true))},'contextmenu':function(o,i,n,e){if(!o.isSelected(i))o.select(i);this.dataview.selectedIndex=i;var f=this.store.getAt(i).get('resource')?false:true;this.viewMenu.items.items[1].setDisabled(f);this.viewMenu.items.items[2].setDisabled(f);this.viewMenu.showAt(e.getXY())},'beforeselect':function(v){return v.store.getRange().length>0}}});this.viewPanel=new Ext.Panel({renderTo:this.wrap.dom.firstChild,border:this.border,layout:'card',autoScroll:true,width:this.width,height:this.height,autoWidth:!this.width,autoHieght:!this.height,anchor:this.anchor,autoHeight:!this.height,activeItem:0,bodyStyle:'background:#FCFCFC;',items:this.dataview,tbar:this.toolbar});this.viewMenu=new Ext.menu.Menu({items:[{text:'ϴƵ',handler:this.fileSelect,scope:this},{text:'ԴƵ',handler:this.addResourceFile,scope:this},{text:'Ƶ',handler:this.addUrlFile,scope:this},'-',{text:'Ƶͼ',handler:this.addResourceImg,scope:this},{text:'ϴƵͼ',handler:this.imageSelect,scope:this},{text:'ԤƵͼ',handler:this.previewImage,scope:this},'-',{text:'Ϊͼ',iconCls:'',handler:this.setAsThumb,scope:this},'-',{text:'༭Ƶ',handler:function(){var target=Ext.get(this.dataview.getSelectedNodes()[0]).child('span',true);this.dataview.plugins[1].onMouseDown(null,target)},scope:this},{text:'ɾ',handler:this.deletefile,scope:this}]});this.dataview.getEl().dom.oncontextmenu=function(){return false}},imageSelect:function(item){EXCMS.util.QuickCreate({model:'Resource.ImageSelector',callback:this.setResourceImg.createDelegate(this),top:true,single:true,postfix:'thumb',channelid:this.getChannelid()})},addResourceImg:function(item){EXCMS.util.QuickCreate({model:'Resource.Browse',callback:this.setResourceImg.createDelegate(this),top:true,type:'image',single:true,postfix:'thumb',channelid:this.getChannelid()})},setResourceImg:function(r){var record=this.dataview.getSelectedRecords();record[0].set('thumb',r.src);record[0].set('thumb_resource',r.resource)},fileSelect:function(){var item={};item.callback=this.resourceCallback.createDelegate(this);item.model='Resource.Upload';item.top=true;item.channelid=this.getChannelid();item.tid=3;EXCMS.util.QuickCreate(item)},addResourceFile:function(){var channelid=this.getChannelid();EXCMS.util.QuickCreate({model:'Resource.Browse',callback:this.resourceCallback.createDelegate(this),top:true,type:'video',single:false,channelid:channelid})},previewImage:function(item){var image=this.store.getAt(this.dataview.selectedIndex).data;var src=image.thumb;if(!src){alert('޷Ԥ');return}EXCMS.Previewer.image(src)},previewVideo:function(){},setAsThumb:function(){var n=this.dataview.getSelectionCount();if(n!=1){alert("ѡһҪΪͼͼƬ");return}var r=this.dataview.getSelectedRecords();var data={resource:'',src:''};if(r[0].data.thumb_resource){data.resource=r[0].data.thumb_resource}else if(data.thumb){data.resource=r[0].data.thumb}else{alert("ǰƵͼ,ýͼ");return}data.src=r[0].data.thumb;this.fireEvent("setThumb",this,data)},addUrlFile:function(){if(!this.urlFileDialog){this.formPanel=new Ext.form.FormPanel({labelWidth:60,baseCls:'x-plain',bodyStyle:'padding:20px 12px',border:false,items:[{xtype:'textfield',fieldLabel:'',name:'name',anchor:'99%'},{xtype:'textfield',fieldLabel:'Ƶַ',name:'src',anchor:'99%',allowBlank:false,blankText:'ƵַΪ'},{xtype:'textarea',fieldLabel:'',name:'description',height:60,anchor:'99%'},{xtype:'numberfield',fieldLabel:'',value:50,name:'sort',anchor:'35%'}]});this.urlFileDialog=new Ext.Window({title:'ԶƵ',layout:'fit',modal:false,resizable:false,width:450,height:250,closeAction:'hide',plain:true,items:this.formPanel,buttons:[{text:'ȷ',handler:this.insert,scope:this},{text:'ȡ',handler:function(){this.urlFileDialog.hide()},scope:this}]})}this.urlFileDialog.show();this.formPanel.form.reset()},insert:function(){if(!this.formPanel.form.isValid()){alert('дߴĴʾ');return}var values=this.formPanel.form.getValues();this.store.add(new Ext.data.Record(values));this.urlFileDialog.hide();this.store.sort('sort','ASC')},resourceCallback:function(r){for(var i=0,len=r.length;i<len;i++){if(r[i].rid){if(!this.store.getById(r[i].rid)){this.store.add(new Ext.data.Record({name:r[i].filename,src:r[i].src,resource:r[i].resource,description:r[i].description,sort:100},r[i].rid))}}}this.store.sort('sort','ASC')},deletefile:function(){var r=this.dataview.getSelectedRecords();if(r.length==0){alert('ѡҪɾļ');return}for(var i=0;i<r.length;i++){this.store.remove(r[i])}this.store.sort('sort','ASC')},editDesc:function(){var n=this.dataview.getSelectionCount();if(n!=1){alert("ѡҪ༭ļ");return}var target=Ext.get(this.dataview.getSelectedNodes()[0]).child('span',true);this.dataview.plugins[1].onMouseDown(null,target)},getChannelid:function(){var channelid=typeof window.top.EXCMS.getChannelId=='function'?window.top.EXCMS.getChannelId():0;if(this.channelid!=channelid){this.channelid=channelid}return this.channelid},setChannelid:function(channelid){this.channelid=channelid},setValue:function(C){if(C=='')C='[]';if(typeof C=='string'){C=Ext.decode(C)}if(this.emptyText&&this.el&&C!==undefined&&C!==null&&C!==""){this.el.removeClass(this.emptyClass)}Ext.form.VideoEditor.superclass.setValue.apply(this,C);if(typeof C=='object'||typeof C=='array'){if(this.store)this.store.removeAll();for(var i=0;i<C.length;i++){this.store.add(new Ext.data.Record({description:C[i].description,thumb:C[i].thumb,thumb_resource:C[i].thumb_resource,src:C[i].src,name:C[i].name,resource:C[i].resource,sort:C[i].sort}))}}this.setRawValue(Ext.encode(C))},applyEmptyText:function(){if(this.rendered&&this.emptyText&&this.getRawValue().length<1){this.setRawValue(this.emptyText);this.el.addClass(this.emptyClass)}},getRawValue:function(){var A=Ext.encode(this.getValue());this.setRawValue(A);if(A===this.emptyText){A=""}return A},reset:function(){Ext.form.VideoEditor.superclass.reset.call(this);this.applyEmptyText()},getValue:function(){var data=new Array;if(this.store)this.store.sort('sort','ASC');this.store.each(function(r){data.push(r.data)});return data}});Ext.reg('videoeditor',Ext.form.VideoEditor);
EXCMS.HtmlEditorPage = function(config){Ext.MessageBox.prompt('ҳ','ҳ⣺',function(btn,txt){if(btn=='ok'){config.callback(txt.trim())}},this)}
function imageOnLoad(img){img.parentNode.getElementsByTagName('strong')[0].style.display='none';img.style.display='block';var imgSrc=img.src;var tempImg=new Image();tempImg.src=imgSrc;var scale=1.0;var width=0,height=0;var fitWidth=fitHeight=90;if(document.all){if(tempImg.readyState=='complete'){width=tempImg.width;height=tempImg.height;}}else{width=tempImg.width;height=tempImg.height;}scale=width/height;if(width>fitWidth){width=fitWidth;height=width/scale;if(height>fitHeight){height=fitHeight;width=height*scale;}}if(height>fitHeight){height=fitHeight;width=height*scale;}if(width==0||height==0){width=fitWidth;height=fitHeight;}img.style.width=width+'px';img.style.height=height+'px';var x=parseInt((90-width)/2);img.parentNode.parentNode.style.left=x+'px';};

