EXCMS.namespace('EXCMS.Account');
EXCMS.Account.config = {
	baseAction : 'index.php?M=Modules&EM=account&A=AccountConfig',
	init : function(){
	    Ext.QuickTips.init();
	    this.type ='keywords';
		this.view();
		btn = this.grid.topToolbar.items.items;
		for(var i=0;i<btn.length;i++){
			if(btn[i].acl && !excmsacl[btn[i].acl]){
				btn[i].hide();
			}
		}
		for(var i=0;i<this.gridMenu.items.items.length;i++){
			if(this.gridMenu.items.items[i].acl&&!excmsacl[this.gridMenu.items.items[i].acl]){
				this.gridMenu.items.items[i].hide();
			}
		}
	},
	
	//ʾ
	view : function(){		
		var actionPanel = new Ext.Panel({region:'west',split:true,collapsible:true,collapseMode:'mini',
				bodyStyle:'background:#DFE8F6;padding:3px 0 0 5px',width:200,minWidth:150,border:false,baseCls:'x-plain',
				items:{xtype:'panel',title:'û',contentEl:'search-action',collapsible:true,style:'margin-bottom:5px'}
			});
        this.D = new Ext.data.Store({
            proxy : new Ext.data.HttpProxy({url:this.baseAction + '&method=store'}),
            reader: new Ext.data.JsonReader({
                root: 'data',totalProperty: 'total',id: 'id',
                fields:["id","name","moduleid","_moduleid","value","group","description",{name:'type',type:'int'},"sort",{name:'issystem',type:'int'}]
            }),remoteSort:false
        });
		
		this.grid = new Ext.grid.EditorGridPanel({region:'center',title:'ûϢ',store:this.D,border:false,style:'border:1px solid #99BBE8;border-width:0px 0px 0px 1px',
			minColumnWidth:2,autoExpandColumn:3,border:false,sm:new Ext.grid.RowSelectionModel(),
            columns:[
				new Ext.grid.RowNumberer(),
				{header:"",width:150,sortable:true,dataIndex:'name'},
				{header:"ֵ",width:220,sortable:true,dataIndex:'value',renderer:this.renderValue,scope:this},
				{header:"",width:150,sortable:true,dataIndex:'description'},
				{header:"",width:80,sortable:true,dataIndex:'type',renderer:this.renderType,scope:this},
				{header:"ϵͳ?",width:70,align:'center',sortable:true,dataIndex:'issystem',renderer:this.renderIsSys,scope:this},
				{header:"",width:70,sortable:true,dataIndex:'sort',scope:this,editor: new Ext.form.NumberField({minValue:0,maxValue:10000})}
			],
			tbar:[
				{text:'½',iconCls:'btnico btn_add',handler:this.edit,scope:this,mode:0,acl:'add'},
				{text:'༭',iconCls:'btnico btn_edit',handler:this.edit,scope:this,mode:1,acl:'edit'},
				{text:'ɾ',iconCls:'btnico btn_del',handler:this.del,scope:this,acl:'delete'},'-',
				{text:'ˢ',iconCls:'btnico btn_fresh',handler:function(){this.D.reload()},scope:this}
			]
		});   
		this.gridMenu = new Ext.menu.Menu({items:[
            {text:'½',icon:ico,iconCls:'ico add',handler:this.edit,scope:this,mode:0,acl:'add'},
            {text:'༭',icon:ico,iconCls:'ico edit',handler:this.edit,scope:this,mode:1,acl:'edit'},
            {text:'ɾ',icon:ico,iconCls:'ico del',handler:this.del,scope:this,acl:'delete'}
        ]}); 
		
		this.grid.on('celldblclick',function(g,r,c,e){if(c!=6){this.record=this.D.getAt(r);this.edit({mode:1});}},this);
		this.grid.on('rowcontextmenu',function(g,r,e){var s=g.getSelectionModel();s.getSelections().indexOf(g.getStore().getAt(r))!= -1?s.selectRow(r,true):s.selectRow(r);this.record=this.D.getAt(r);this.gridMenu.showAt(e.getXY())},this);
		
	    new Ext.Viewport({layout:'border',items:[actionPanel,this.grid]});
        this.D.load();
		
		this.grid.getEl().dom.oncontextmenu = function(){return false;}
        this.grid.getEl().dom.onselectstart = function(){return false;}
	},
	edit:function(item){
		var title;
		if(item.mode==1){
			this.record = this.grid.getSelectionModel().getSelected();
			if(this.record){title ='޸ '+ this.record.get('name');}else{alert('ѡҪ༭ı');return ;}
		}else{title='½';}
		if(!this.editor){
			this.formPanel = new Ext.form.FormPanel({labelWidth:70,autoScroll:true,border:false,defaults:{anchor:'-20',xtype:'textfield'},layout:'form',bodyStyle:'padding:10px 0px 0px 10px;',items:[	
				{name:'id',xtype:'hidden'},{name:'issystem',xtype:'hidden'},
				{fieldLabel:'',name:'name',allowBlank:false,blankText:'Ϊ'},
				{fieldLabel:'',xtype:'radiogroup',items:[
					{boxLabel:'',name:'type',inputValue:1},
					{boxLabel:'',name:'type',inputValue:2},
					{boxLabel:'ı',name:'type',inputValue:3,checked:true},
					{boxLabel:'ı',name:'type',inputValue:4}
				]},
				{fieldLabel:'ֵ',xtype:'radiogroup',items:[
					{boxLabel:'',name:'value',inputValue:1,checked:true},
					{boxLabel:'',name:'value',inputValue:0}
				]},
				{fieldLabel:'ֵ',name:'value1',xtype:'numberfield'},
				{fieldLabel:'ֵ',name:'value2'},
				{fieldLabel:'ֵ',name:'value3',xtype:'textarea'},
				{xtype:'textarea',fieldLabel:'',name:'description',height:60},
				{xtype:'numberfield',fieldLabel:'',value:100,name:'sort',maxLength:6,anchor:'30%'}
			]});
			
            this.editor=new Ext.Window({layout:'fit',modal:false,resizable:false,width:520,height:330,closeAction:'hide',plain: true,
                items:this.formPanel,
                buttons:[{text:'ȷ',handler:this.save,scope:this},{text:'ȡ',handler:function(){this.editor.hide()},scope:this}]
            });
            this.formPanel.form.on('actioncomplete',function(form,action){
                if(action.result.success){this.editor.hide();this.D.reload();}
            }, this);
		}
		this.editor.setTitle(title);
		this.editor.show();
		this.formPanel.form.items.items[3].items.each(function(f){f.on('check',function(s,c){if(c){this.setVisible(s.inputValue)}},this);},this);

		if(item.mode==1){
			var data = this.record.data;
        	this.formPanel.form.setValues(data);
			this.setValue(data.type, data.value);
			this.setDisabled(data.issystem);
			this.setVisible(data.type);
		}else{
            this.formPanel.form.reset();
			this.setDisabled();
			this.setVisible(3);
		}
	},
	setDisabled : function(issystem){
		for(var i=1;i<4;i++){
			this.formPanel.form.items.items[i].setDisabled(issystem=='1'?true:false);
		}
	},
	//ʾ
	setVisible:function(type){
		type = type > 0 && type < 5 ? type : 3;
		for(var i=4;i<8;i++){
			this.formPanel.form.items.items[i].container.dom.parentNode.style.display = (type + 3) == i ? '' : 'none';
		}
	},
	
	setValue:function(type, value){
		for(var i=4;i<8;i++){
			this.formPanel.form.items.items[i].setValue((type + 3) == i ? value : '');
		}
	},
	//ϵͳ
	save:function(item){
		if(!this.formPanel.form.isValid()){alert('ߴĴʾ');return}
		var act = this.formPanel.form.items.items[0].getValue() == '' ? '&method=insert' : '&method=update';
		type = this.formPanel.form.items.items[3].getValue();
		name = this.formPanel.form.items.items[2].value;
		this.formPanel.form.submit({url:this.baseAction+act,params:{type:type,name:name}});
	},
	//ɾϵͳ
	del:function(){
        var records = this.grid.getSelectionModel().getSelections();
        var flag = false
        if(records.length > 0){
			var ids=[]
            for(var i=0,len=records.length;i<len; i++){
            	if(records[i].data.issystem) {flag = true;break;}
            	ids.push(records[i].id);
            }
        }else{
			alert('ѡҪɾı');
			return ;
		}
        if(flag){alert('ϵͳɾ');return;}
       if(confirm('ȷʵҪɾѡļ¼')){
			Ext.Ajax.request({
				url:this.baseAction + '&method=delete',method:'POST', params:{ids:ids.join(',')},scope:this,
				success:function(r,o){
					r=jsonReturn(r);
					if(r.success){this.D.reload();}
				}
			});
        }
	},
	//
	saveSettingSort : function(){
		var records = this.D.getModifiedRecords();
		var data=[];
		for(var i=0;i<records.length;i++){
			data.push({id:records[i].data.id,sort:records[i].data.sort});
		}
		if(data.length > 0){
			this.grid.getEl().mask('ݱ,Ժ');
			Ext.Ajax.request({url:this.baseAction+'&method=sort',method:'post',scope:this,
				params:{data:Ext.util.JSON.encode(data)},
				failure:function(){this.categoryGrid.getEl().unmask();},
				success:function(r,o){
					this.grid.getEl().unmask();
					r=jsonReturn(r);
					if (r.success) {
						this.D.commitChanges();
					}
				}
			});
		}
	},
	
	renderType:function(v){var d=['','','ı','ı'];return v>0&&v<5?d[v-1]:d[2]},
	renderIsSys:function(v){return v=='1'?'<font color=red></font>':'<font color=green></font>'},
	renderValue:function(v,m,r){return r.get('type')==1?(v==1?"<font color='green'></font>":"<font color='red'></font>"):v}
};
EXCMS.onReady(EXCMS.Account.config.init,EXCMS.Account.config);