Ext.namespace('Ext.ux');
Ext.ux.SinaEditor = Ext.extend(Ext.form.TextArea, {
	onRender : function(ct, position){
    	Ext.ux.SinaEditor.superclass.onRender.call(this, ct, position);
    	var width  =  this.width ? this.width+'px;' : this.anchor ? this.anchor : '100%';
    	this.el.dom.style.width= '100%';
    	this.el.dom.style.height = this.height;
		this.el.dom.style.display = 'none';
		var h = parseInt(this.height);
		if(!h) h = 200; 
		this.iframe = document.createElement('iframe');
		this.iframe.src = 'components/sinaeditor/editor.htm?ReadCookie=0&height='+h+'&id=' + this.id;
		this.iframe.frameborder = '0';
		this.iframe.scrolling = 'no';
		this.iframe.style.cssText += ';position:relative;border:none;height:'+h+'px;width:'+ width;
		this.el.dom.parentNode.appendChild(this.iframe);
	},
	onResize : function(D,B,A,C){
		Ext.ux.SinaEditor.superclass.onResize.call(this,D,B,A,C);
		var h = parseInt(this.el.dom.style.height);
	},
	setValue:function(v){
		Ext.ux.SinaEditor.superclass.setValue.call(this,v);
		if(this.iframe.contentWindow.isEditorRender){
			this.iframe.contentWindow.setHTML(v);
		}
	},
	setSinaEditorHeight:function(f){
		if(!this.iframe.oHeight) {
            this.iframe.oHeight = this.iframe.offsetHeight - 200;
        }
		var h = this.iframe.offsetHeight + (f ? 100 : -100);
        if (h < this.iframe.oHeight) return;
        this.iframe.style.height = h + 'px';
		this.iframe.contentWindow.setHeight(h);
	}
});
Ext.reg('sinaeditor', Ext.ux.SinaEditor);