<?php
/**
 * Project:		EXCMS: the PHP content management system.
 * File:		AdsPosition.class.php
 *
 * A product of PUTOYO Inc.
 * 
 * EXCMS is a ten million data-level,high speed,human-based content management system.
 *
 * EX is Excellence & Express & Exceed & Expert.
 * 
 * For questions, help, comments, discussion, please join the
 * EXCMS mailing list. Send a blank e-mail to
 * join@excms.cn
 * or join the EXCMS forum
 * www.excms.cn/forum
 * 
 * @link http://www.excms.cn/
 * @copyright Copyright (c) 2010 PUTOYO Inc.
 * @license http://www.excms.cn/licenses/LICENSE-1.0
 * @category EXCMS
 * @package content
 * @author $Author: zhanghaisong $
 * @version $Rev: 498 $
 */
/* $Id: AdsPosition.class.php 498 2010-01-12 12:38:30Z zhanghaisong $ */
/**
 * EXCMS λ
 * @category EXCMS
 * @package content
 * @author $Author: zhanghaisong $
 */
class AdsPosition
{
    /**
     * λݿ
     *
     * @access private
     * @var string
     */
    private $table = 'ads_position';
    /**
     * 캯
     *
     */
    function __construct ()
    {
        $this->table = TABLE_PREFIX . $this->table;
    }
    /**
     * PHP4캯
     *
     */
    function AdsPosition ()
    {
        $this->__construct();
    }
    /**
     * ȡָID
     *
     * @param integet $id λID
     * @return array λ
     */
    function getById ($id)
    {
        if (! ($id > 0)) {
            throw_exception('LACK_ADSPOSITION_ID');
        }
        $sql = "SELECT * FROM `{$this->table}` WHERE `id` = '{$id}' LIMIT 1";
                $GLOBALS['db']->query($sql);
        return $GLOBALS['db']->fetch();
    }
    /**
     * ӹλ
     *
     * @param array $data
     * @return integer λID
     */
    function insert ($data)
    {
        if (trim($data['name']) == '') {
            throw_exception('LACK_ADS_NAME');
        }
        $data = array(
        	'name' => $data['name'],
        	'description' => $data['description'],
        	'price'       => (int)$data['price'],
        	'template'  => $data['template'],
        	'width'       => (int)$data['width'],
        	'height'    => (int)$data['height'],
        	'expire'    => $data['expire'],
        	'enable'     => $data['enable'] ?  1 : 0
        );
        $sql = "INSERT INTO `{$this->table}` (`" . implode("`, `", array_keys($data)) . "`) VALUES('" . implode("', '", array_values($data)) . "')";
                $GLOBALS['db']->query($sql);
        return $GLOBALS['db']->insert_id();
    }
    /**
     * ¹λ
     *
     * @param integer $id
     * @param array $data
     * @return boolean
     */
    public function update($id,$data){
    	if (trim($data['name']) == '') {
            throw_exception('LACK_ADS_NAME');
        }
        $data = array(
        	'name' 			=> 	$data['name'],
        	'description' => $data['description'],
        	'price'       => (int)$data['price'],
        	'template'  => $data['template'],
        	'width'       => (int)$data['width'],
        	'height'    => (int)$data['height'],
        	'expire'    => $data['expire'],
        	'enable'     => $data['enable'] ?  1 : 0
        );
        $set = array();
		foreach($data as $k => $v){
			$set[] = "`{$k}` = '{$v}'";
		}
		$set = implode(", ", $set);
		$sql = "UPDATE `{$this->table}` SET {$set} WHERE `id` = '{$id}' LIMIT 1";
		return $GLOBALS['db']->query($sql);
    }
    /**
     * ɾָID
     *
     * @param string|integer|array $id ID
     * @return boolean
     */
    function delete ($id)
    {
        $id = EXCMS::convertToIntArray($id);
        if ($id === false) {
            throw_exception('LACK_ADSPOSITION_ID');
        }
        $num = count($id);
        $where = $num > 1 ? "`id` IN ('" . implode("', '", $id) . "') LIMIT {$num}" : "`id` = '" . $id[0] . "'";
        $sql = "DELETE FROM `{$this->table}` WHERE {$where}";
                return $GLOBALS['db']->query($sql);
    }
    /**
     * /ùλ
     *
     * @param integer $id
     * @param boolean $enable
     * @return boolean
     */
    public function enable($id,$enable=true){
    	$id = EXCMS::convertToIntArray($id);
        if ($id === false) {
            throw_exception('LACK_ADSPOSITION_ID');
        }
        $enable = $enable ? 1 : 0;
        $num = count($id);
        $where = $num > 1 ? "`id` IN ('" . implode("', '", $id) . "') LIMIT {$num}" : "`id` = '" . $id[0] . "'";
        $sql = "UPDATE `{$this->table}` SET `enable` = '{$enable}' WHERE {$where}";
                return $GLOBALS['db']->query($sql);
    }
    /**
     * ȡλб
     *
     * @param array $paging ҳ
     * <ul>
     * <li>integer $paging['limit'] ҳС default 0</li>
     * <li>integer $paging['start'] ҳʼС default 0</li>
     * <li>integer $paging['total']  default 0</li>
     * <li>integer $paging['sort'] ֶ</li>
     * <li>integer $paging['dir'] ʽ ASC or DESC, </li>
     * <li>integer $paging['keyword'] ؼ</li>
     * </ul>
     * @return array Paging 
     * <ul> 
     * <li> $array['total']  </li>
     * <li> $array['data'] ҳ </li>
     * </ul>
     */
    function getPaging ($paging = array())
    {
        $keyword = trim($paging['keywords']);
        if (!empty($keyword)) {
            $where = " AND (`name` like '%{$keyword}%' OR `description` like '%{$keyword}%') ";
        } 
             	$sql = "SELECT COUNT(*) as `total` FROM {$this->table} WHERE 1 {$where} ";
        $GLOBALS['db']->query($sql);
        $rs = $GLOBALS['db']->fetch();
        $total = $rs['total'];
        $rs = array();
        if($total > 0){
        	$orderby = "ORDER BY `id` DESC";
	        $start = (int) $paging['start'];
	        $limit = $paging['limit'] > 0 ? ($paging['limit'] > 100 ? 100 : $paging['limit']) : 25;
	        $limit = "LIMIT {$start}, {$limit}";
	        $sql = "SELECT * FROM {$this->table} WHERE 1 {$where} {$orderby} {$limit}";
	        	        $GLOBALS['db']->query($sql);
	        $rs = $GLOBALS['db']->fetchAll();
	        foreach ($rs as $key=>$value){
	        	$rs[$key]['phpurl'] = full_url(EXCMS::url(array('name'=>'ads.php','id'=>$value['id'])));
	        }
        }
        return array('total' => $total , 'data' => $rs);
    }
    /**
     * ȡλ
     *
     * @return array
     */
    public function getAdsPositionList(){
         	$sql = "SELECT id,name FROM {$this->table} WHERE `enable`='1' ";
        $GLOBALS['db']->query($sql);
        return  $GLOBALS['db']->fetchAll();
    }
}
?>