<?php
/**
 * Project:		EXCMS: the PHP content management system.
 * File:		content.php
 *
 * A product of PUTOYO Inc.
 * 
 * EXCMS is a ten million data-level,high speed,human-based content management system.
 *
 * EX is Excellence & Express & Exceed & Expert.
 * 
 * For questions, help, comments, discussion, please join the
 * EXCMS mailing list. Send a blank e-mail to
 * join@excms.cn
 * or join the EXCMS forum
 * www.excms.cn/forum
 * 
 * @link http:// www.excms.cn/
 * @copyright Copyright (c) 2010 PUTOYO Inc.
 * @license http:// www.excms.cn/licenses/LICENSE-1.0
 * @category EXCMS
 * @author hkz@putoyo.com
 * @version $Rev: 1526 $
 */
 
 /* $Id: content.php 1526 2010-05-25 15:00:28Z zhangxuelin $ */ 

// EXCMSļ
require_once('../configuration/inc/common.inc.php');

// ȡID
$contentid = trim($_GET['contentid']);

// IDʱ 
if($EXCMS_CONFIG['code_contentid']){
    $contentid = EXCMS::id_decode($contentid);
}
// IDǷ
if(!is_numeric($contentid) || !($contentid > 0)){
	exit();
}

// Ƿص
if(isset($_GET['crossDomainCallback']) && $_GET['crossDomainCallback'] != ''){
	$crossDomainCallback = trim($_GET['crossDomainCallback']);
}

// defined response array
$rs = array();

// switch action
switch(trim($_GET['act'])){
	// һ£Ҫװģ飩
	case 'digg' :
		// ģ
		loadModuleConfig('digg');
		// ض
		include_once LIB_MODULES_PATH . 'digg/Digg.class.php';
		Digg::create()->diggUp($contentid);
		$rs = Digg::create()->getByContentid($contentid);
		$rs = array(
			'digg' => (int)$rs['digg'],
			'trample' => (int)$rs['trample'],
		);
		$total = $rs['trample'] + $rs['digg'];
		// ٷֱ
		$rs['diggpercent'] = round($total > 0 ? $rs['digg'] / $total * 100 : 0, 1);
		// Ȱٷֱ
		$rs['tramplepercent'] = round($total > 0 ? $rs['trample'] / $total * 100 : 0, 1);
		break;
		
	// һţҪװģ飩
	case 'trample' :
		// ģ
		loadModuleConfig('digg');
		// ݵ
		include_once LIB_MODULES_PATH . 'digg/Digg.class.php'; 
		Digg::create()->trampleDown($contentid);
		$rs = Digg::create()->getByContentid($contentid);
		$rs = array(
			'digg' => (int)$rs['digg'],
			'trample' => (int)$rs['trample'],
		);
		$total = $rs['digg'] + $rs['trample'];
		// ٷֱ
		$rs['diggpercent'] = round($total > 0 ? $rs['digg'] / $total * 100 : 0, 1);
		// Ȱٷֱ
		$rs['tramplepercent'] = round($total > 0 ? $rs['trample'] / $total * 100 : 0, 1);
		break;

	default :
		// ȡҪװģ飩
		loadModuleConfig('click',true);
		// ݵ
		include_once LIB_MODULES_PATH . 'click/Click.class.php';
		$rs['click'] = Click::create()->clickUp($contentid);
		
		// ȡȴҪװģ飩
		// ض
		include_once LIB_MODULES_PATH . 'digg/Digg.class.php';
		$digg = Digg::create()->getByContentid($contentid);
		// 
		$rs['digg'] = (int)$digg['digg'];
		// ȴ
		$rs['trample'] = (int)$digg['trample'];
		$total = $rs['digg'] + $rs['trample'];
		// ٷֱ
		$rs['diggpercent'] = round($total > 0 ? $rs['digg'] / $total * 100 : 0, 1);	
		// Ȱٷֱ
		$rs['tramplepercent'] = round($total > 0 ? $rs['trample'] / $total * 100 : 0, 1);
		
		// ȡҪװģ飩
		// 
		include_once LIB_MODULES_PATH . 'comment/Comment.class.php';
		$comment = new Comment();
		$rs['comment'] = $comment->getCountByItemId($contentid);
		
		// get model
		if(isset($_GET['model']) && $_GET['model']){
			switch(strtolower($_GET['model'])){
				// 
				case 'download' :
					include_once LIB_MODULES_PATH . 'download/Downloads.class.php';
					$rs['download'] = Downloads::create()->getTotalByContentId($contentid);
					break;
			}
		}
		break;
}

// response
$json  = EXCMS::jsonencode($rs);
echo $crossDomainCallback ? $crossDomainCallback . "({$json})" : $json;

// excms file's end