<?php
/**
 * Project:		EXCMS: the PHP content management system.
 * File:		Action.php
 *
 * A product of PUTOYO Inc.
 * 
 * EXCMS is a ten million data-level,high speed,human-based content management system.
 *
 * EX is Excellence & Express & Exceed & Expert.
 * 
 * For questions, help, comments, discussion, please join the
 * EXCMS mailing list. Send a blank e-mail to
 * join@excms.cn
 * or join the EXCMS forum
 * www.excms.cn/forum
 * 
 * @link http://www.excms.cn/
 * @copyright Copyright (c) 2010 PUTOYO Inc.
 * @license http://www.excms.cn/licenses/LICENSE-1.0
 * @category EXCMS
 * @author zhangxuelin@excms.cn
 * @version $Rev: 2767 $
 */
/* $Id: Action.php 2767 2010-11-26 07:27:05Z luofen $ */
/**
 * EXCMS ֶ
 */
if(!defined('EXCMS') || !defined('EXCMS_ADMIN')){
	exit('Access Denied');
}
$IS_AJAX_REQUEST = true;
// load rating class, create object
include_once RATING_LIB_PATH . 'Rating.class.php';
$rating = new Rating();
$json = array('success' => 0);
switch($method){
	// ȡ
	case 'tree' :
		$rs = $rating->getAllGroup();
		$json = array();
		foreach($rs as $k => $v){
			$json[] = array('id' => &$rs[$k]['gid'], 'gid' => &$rs[$k]['gid'], 'text' => &$rs[$k]['name'], 'leaf' => true);
		}
		break;
	// ȡ
	case 'getGroupById' :
		$json['data'] = $rating->getGroupByGid($_POST['gid']);
		$json['success'] = 1;
		break;
	// ½༭
	case 'editGroup' :
		$gid = $_POST['gid'];
		if(!is_numeric($gid) || $gid < 1) $gid = 0;
		if($gid > 0){
			$json['success'] = $rating->updateGroup($gid, $_POST);
		}else{
			$json['gid'] = $rating->insertGroup($_POST);
			$json['success'] = 1;
		}
		break;
	case 'deleteGroup' :
		$gid = $_POST['gid'];
		if($gid > 1){
			$json['success'] = $rating->deleteGroup($gid);
		}
		break;
	// ȡ
	case 'store' :
		$p = array(
        	'gid'		=> $_POST['gid'],
			'limit'		=> $_POST['limit'],
        	'start'		=> $_POST['start'],
            'sort'		=> $_POST['sort'],
            'dir'		=> $_POST['dir'],
        	'keywords'	=> $_POST['key']
        );
        $json = $rating->getPaging($p);
		break;
	// ޸
	case 'modifyScore':
		$data = EXCMS::jsondecode($_POST['data']);
		if(is_array($data) && count($data)){
			foreach($data as $v) $rating->modifyScore($v['gid'], $v['contentid'], $v['score'], $v['sumscore'], $v['voters'], $v['uservoters']);
		}
		$json['success'] = 1;
		break;
	// ɾּ¼
	case 'delete' :
		$rating->deleteScore($_POST['gid'], $_POST['contentid']);
		$json['success'] = 1;
		break;
	// ־
	case 'logStore':
		$p = array(
        	'gid'		=> $_POST['gid'],
			'contentid'		=> $_POST['contentid'],
			'limit'		=> $_POST['limit'],
        	'start'		=> $_POST['start']
        );
		$json = $rating->getLogPaging($p);
		break;
}
EXCMS::json_print($json);

// excms file end