<?php
/**
 * Project:		EXCMS: the PHP content management system.
 * File:		Rating.class.php
 *
 * A product of PUTOYO Inc.
 * 
 * EXCMS is a ten million data-level,high speed,human-based content management system.
 *
 * EX is Excellence & Express & Exceed & Expert.
 * 
 * For questions, help, comments, discussion, please join the
 * EXCMS mailing list. Send a blank e-mail to
 * join@excms.cn
 * or join the EXCMS forum
 * www.excms.cn/forum
 * 
 * @link http://www.excms.cn/
 * @copyright Copyright (c) 2010 PUTOYO Inc.
 * @license http://www.excms.cn/licenses/LICENSE-1.0
 * @category EXCMS
 * @package Hit
 * @author zhangxuelin@excms.cn
 * @version $Rev: 2801 $
 */
/* $Id: Rating.class.php 2801 2010-11-30 01:05:26Z zhangxuelin $ */
/**
 * EXCMS 
 * @category EXCMS
 * @package Rating
 * @author zhangxuelin@excms.cn
 */
class Rating{
	/**
	 * ݱ
	 *
	 * @access private
	 * @var string
	 */
	private $table = 'rating';
	/**
	 * ݱ
	 *
	 * @access private
	 * @var string
	 */
	private $table_group = 'rating_group';
	/**
	 * ־¼ݱ
	 *
	 * @access private
	 * @var string
	 */
	private $table_log = 'rating_log';
	/**
	 * 캯
	 * 
	 */
	function __construct(){
		$this->table = TABLE_PREFIX . $this->table;
		$this->table_group = TABLE_PREFIX . $this->table_group;
		$this->table_log = TABLE_PREFIX . $this->table_log;
	}
	/**
	 * ͨID $gid ȡ
	 * 
	 * @param int $gid ID
	 * @return array
	 */
	public function getGroupByGid($gid){
		if(!is_numeric($gid) || $gid < 0){
			throw_exception('RATING_LACT_GID');
		}
		$GLOBALS['db']->query("SELECT * FROM `{$this->table_group}` WHERE `gid` = '{$gid}' LIMIT 1");
		return $GLOBALS['db']->fetch();
	}
	/**
	 * ȡ
	 * 
	 * @param boolean $setGisAsKey Ƿ gid Ϊ
	 * @return array
	 */
	public function getAllGroup($setGisAsKey = false){
		$GLOBALS['db']->query("SELECT * FROM `{$this->table_group}` ORDER BY `sort` ASC, `gid` ASC");
		$rs = $GLOBALS['db']->fetchAll();
		if($setGisAsKey){
			$rs_new = array();
			foreach($rs as $k => $v) $rs[$v['gid']] = &$rs[$k]; 
			return $rs_new;
		}
		return $rs;
	}
	/**
	 * Ƿ
	 * 
	 * @param string $name
	 * @param int $gid
	 * @return boolean
	 */
	public function checkGroupNameExist($name, $gid){
		$sql = "SELECT * FROM `{$this->table_group}` WHERE `name` = '{$name}'";
		if($gid > 0) $sql .= " AND `gid` <> '{$gid}'";
		$sql .= ' LIMIT 1';
		$GLOBALS['db']->query($sql);
		$rs = $GLOBALS['db']->fetch();
		return $rs['gid'] > 0;
	}
	/**
	 * ½飬 gid
	 * 
	 * @param array $data
	 * @return int $gid
	 */
	public function insertGroup($data){
		return $this->commitGroup($data);
	}
	/**
	 * 
	 * 
	 * @param int $gid
	 * @param array $data
	 * @return boolean
	 */
	public function updateGroup($gid, $data){
		if(!is_numeric($gid) || $gid < 0){
			throw_exception('RATING_LACT_GID');
		}
		return $this->commitGroup($data, 'update', $gid);
	}
	/**
	 * ɾ
	 *
	 * @param integer $gid
	 */
	public function deleteGroup($gid){
		if(!is_numeric($gid) || $gid < 0){
			throw_exception('RATING_LACT_GID');
		}
		$sql = "DELETE FROM `{$this->table_group}` WHERE `gid` = '{$gid}' ";
		$GLOBALS['db']->query($sql);
		return $this->deleteByGid($gid);
	}
	/**
	 * ύ
	 * 
	 * @param array $data
	 * @param string $method
	 * @param int $gid
	 */
	private function commitGroup(&$data, $method = 'insert', $gid = 0){
		$name = trim($data['name']);
		if(empty($name)){
			throw_exception('RATING_LACK_GROUP_NAME');
		}elseif($this->checkGroupNameExist($name, $gid)){
			throw_exception('RATING_GROUP_NAME_EXIST');
		}
		$data = array(
			'name' 			=> $name,
			'fullscore'		=> (int)$data['fullscore'],
			'minscore'		=> floatval($data['minscore']),
			'defaultvalue'	=> floatval($data['defaultvalue']),
			'stars'			=> (int)$data['stars'],
			'tips'			=> trim($data['tips']),
			'description'	=> trim($data['description']),
			'scoretext'		=> trim($data['scoretext']),
			'disabled'		=> (int)$data['disabled'] == 1 ? 1 : 0,
			'denyvote'		=> (int)$data['denyvote'] == 1 ? 1 : 0,
			'revote'		=> (int)$data['revote'] == 1 ? 1 : 0,
			'loginvote'		=> (int)$data['loginvote'] == 1 ? 1 : 0,
			'log'			=> (int)$data['log'] == 1 ? 1 : 0,
			'sort'			=> (int)$data['sort']
		);
		if($method == 'update'){
			$set = array();
			foreach($data as $k => $v) $set[] = "`{$k}` = '{$v}'";
			$set = implode(", ", $set);
			$GLOBALS['db']->query("UPDATE `{$this->table_group}` SET {$set} WHERE `gid` = '{$gid}' LIMIT 1");
			return true;
		}else{
			$GLOBALS['db']->query("INSERT INTO `{$this->table_group}` (`" . implode("`, `", array_keys($data)) . "`) VALUES('" . implode("', '", array_values($data)) . "')");
			return $GLOBALS['db']->insert_id();
		}
	}
	/**
	 * ȡָָID
	 * @param int $gid ID
	 * @param int $contentid ID
	 * @return array
	 */
	public function getScore($gid, $contentid){
		if(!is_numeric($gid) || $gid < 0){
			throw_exception('RATING_LACT_GID');
		}
		if(!is_numeric($contentid) || $contentid < 0){
			throw_exception('RATING_LACT_CONTENTID');
		}
		$GLOBALS['db']->query("SELECT * FROM `{$this->table}` WHERE `contentid` = '{$contentid}' AND `gid` = '{$gid}' LIMIT 1");
		$rs = $GLOBALS['db']->fetch();
		if($rs['contentid']){
			$rs['sumscore'] = floatval($rs['sumscore']);
			$rs['score'] = floatval($rs['score']);
			$rs['voters'] = intval($rs['voters']);
			$rs['uservoters'] = intval($rs['uservoters']);
			return $rs;
		}else{
			return null;
		}
	}
	/**
	 * ûǷѾֹ
	 * 
	 * @param int $uid
	 * @param int $gid
	 * @param int $contentid
	 * @return boolean
	 */
	public function isUserRated($uid, $gid, $contentid){
		$gid = (int)$gid;
		$contentid = (int)$contentid;
		$uid = (int)$uid;
		$GLOBALS['db']->query("SELECT 'uid' FROM `{$this->table_log}` WHERE `contentid` = '{$contentid}' AND `gid` = '{$gid}' AND `uid` = '{$uid}' LIMIT 1");
		$rs = $GLOBALS['db']->fetch();
		return $rs['uid'] > 0;
	}
	/**
	 * 
	 * @param int $gid ID
	 * @param int $contentid ID
	 * @param float $score 
	 * @return array
	 */
	public function rate($gid, $contentid, $score){
		if(!is_numeric($score) || $score < 0){
			throw_exception('RATING_LACT_SCORE');
		}
		include_once LIB_MODULES_PATH . 'account/User.class.php';
		$userObj = new User();
		$userinfo = $userObj->getSession();
		if($userinfo['uid']){
			$uid = $userinfo['uid'];
			if($this->isUserRated($uid, $gid, $contentid)){
				throw_exception('RATING_USER_IS_RATED');
			}
			$username = $userinfo['username'];
		}
		$group = $this->getGroupByGid($gid);
		$rs = array();
		if($group['gid'] > 0){
			if($group['disabled']){
				$rs['message'] = 'RATING_GROUP_DISABLED';
			}else{
				if($score > $group['fullscore']) $score = $group['fullscore'];
				$rs = $this->getScore($gid, $contentid);
				$data = array(
					'sumscore' => $score,
					'voters' => 1,
					'score' => $score,
					'lastrateddate' => time()
				);
				// û
				if($group['log'] && $uid) $data['uservoters'] = 1;
				if($rs['contentid']){
					$data['sumscore'] += $rs['sumscore'];
					$data['voters'] += $rs['voters'];
					if($data['uservoters']) $data['uservoters'] += $rs['uservoters'];
					$data['score'] = round($data['sumscore'] / $data['voters'], 1);
					foreach($data as $k => $v) $set[] = "`{$k}` = '{$v}'";
					$set = implode(", ", $set);
					$sql = "UPDATE `{$this->table}` SET {$set} WHERE `gid` = '{$gid}' AND `contentid` = '{$contentid}' LIMIT 1";
				}else{
					$data['contentid'] = $contentid;
					$data['gid'] = $gid;
					$sql = "INSERT INTO `{$this->table}` (`" . implode("`, `", array_keys($data)) . "`) VALUES('" . implode("', '", array_values($data)) . "')";
				}
				$GLOBALS['db']->query($sql);
				if($group['log']) $this->log($contentid, $gid, $score, $uid, $username);
				return $data;
			}
		}else{
			$rs['message'] = 'RATING_GROUP_NOT_EXIST';
		}
		return $rs;
	}
	/**
	 * ޸
	 * @param int $gid ID
	 * @param int $contentid ID
	 * @param float $score 
	 * @param float $sumscore ܷ
	 * @param int $voters 
	 * @param int $uservoters û
	 */
	public function modifyScore($gid, $contentid, $score = 0, $sumscore = 0, $voters = 0, $uservoters = 0){
		if(!is_numeric($gid) || $gid < 0){
			throw_exception('RATING_LACT_GID');
		}
		if(!is_numeric($contentid) || $contentid < 0){
			throw_exception('RATING_LACT_CONTENTID');
		}
		$score = floatval($score);
		$sumscore =  floatval($sumscore);
		$voters = (int)$voters;
		$uservoters = (int)$uservoters;
		$GLOBALS['db']->query("UPDATE `{$this->table}` SET `score` = '{$score}', `sumscore` = '{$sumscore}', `voters` = '{$voters}', `uservoters` = '{$uservoters}' WHERE `gid` = '{$gid}' AND `contentid` = '{$contentid}' LIMIT 1");
		return true;
	}
	/**
	 * ɾ
	 * @param int $gid
	 * @param int|string $contentid
	 */
	public function deleteScore($gid, $contentid){
		if(!is_numeric($gid) || $gid < 0){
			throw_exception('RATING_LACT_GID');
		}
		$ids = EXCMS::convertToIntArray($contentid);
		if($ids === false){
			throw_exception('RATING_LACT_CONTENTID');
		}
		$where = count($ids) > 1 ? "IN (" . implode(',', $ids) . ")" : "= {$ids[0]} LIMIT 1";
		$GLOBALS['db']->query("DELETE FROM `{$this->table}` WHERE `gid` = '{$gid}' AND `contentid` {$where}");
		return true;
	}
	/**
	 * IDɾ
	 *
	 * @param integer $gid
	 * @return boolean
	 */
	public function deleteByGid($gid){
		if(!is_numeric($gid) || $gid < 0){
			throw_exception('RATING_LACT_GID');
		}
		return $GLOBALS['db']->query("DELETE FROM `{$this->table}` WHERE `gid` = '{$gid}' ");
	}
	/**
	 * ȡַҳ
	 * @param array $params ҳ
	 * <ul>
	 * <li>int $params['gid'] ID</li>
	 * <li>int $params['total'] Ѿָtotalڲѯ</li>
	 * <li>string $params['start'] ʼ</li>
	 * <li>string $params['limit'] ҳС</li>
	 * </ul> 
	 * @return array
	 * <ul>
	 * <li>string $array['total'] </li>
	 * <li>string $array['data'] ҳ</li>
	 * </ul> 
	 */
	public function getPaging($params = array()){
		if(!is_numeric($params['gid']) || $params['gid'] < 0){
			throw_exception('RATING_LACT_GID');
		}
		// ָID
		$ids = EXCMS::convertToIntArray($params['contentids']);
		$where = "`gid` = '{$params['gid']}'";
		if($ids !== false) $where = " AND `contentid` IN (" . implode(',', $ids) . ")";
		if(empty($params['total']) || $params['total'] < 0){
			$sql = "SELECT COUNT(*) as `total` FROM `{$this->table}` WHERE {$where}";
			$GLOBALS['db']->query($sql);
			$rs = $GLOBALS['db']->fetch();
			$total = $rs['total'];
		}else{
			$total = (int)$params['total'];
		}
		$start = (int)$params['start'];
		$start = $start > 0 ? $start : 0;
		$limit = $params['limit'] > 0 ? ($params['limit'] > 100 ? 100 : $params['limit']) : 25;
		$limit = "LIMIT {$start}, {$limit}";
		$sql = "SELECT * FROM {$this->table} WHERE {$where} ORDER BY `lastrateddate` DESC {$limit}";
		$GLOBALS['db']->query($sql);
		$data = $GLOBALS['db']->fetchAll();
		// format
		if(is_array($data) && count($data) > 0) {
        	include_once LIB_PATH . 'content/Content.class.php';
			$content = new Content();
        	foreach($data as $k => $v){
        		$c = $content->getById($v['contentid'], false, 'title');
        		$data[$k]['title'] = $c['title'];
        		$data[$k]['lastrateddate'] = formatDate('Y-m-d H:i', $v['lastrateddate']);
        	}
        }
		return array('total' => $total, 'data' => $data);
	}
	/**
	 * ¼û־
	 * @param int $contentid
	 * @param int $gid
	 * @param int $uid
	 * @param float $store
	 */
	public function log($contentid, $gid, $score, $uid = 0, $username = ''){
		$dat = array(
			'contentid' => (int)$contentid,
			'gid' => (int)$gid,
			'uid' => (int)$uid,
			'username' => $username,
			'score' => floatval($score),
			'ip' => $_SERVER['REMOTE_ADDR'],
			'rateddate' => time()
		);
		$GLOBALS['db']->query("INSERT INTO `{$this->table_log}` (`" . implode("`, `", array_keys($dat)) . "`) VALUES('" . implode("', '", array_values($dat)) . "')");
	}
	/**
	 * ȡַҳ
	 * @param array $params ҳ
	 * <ul>
	 * <li>int $params['gid'] ID</li>
	 * <li>int $params['contentid'] ID</li>
	 * <li>int $params['total'] Ѿָtotalڲѯ</li>
	 * <li>string $params['start'] ʼ</li>
	 * <li>string $params['limit'] ҳС</li>
	 * </ul> 
	 * @return array
	 * <ul>
	 * <li>string $array['total'] </li>
	 * <li>string $array['data'] ҳ</li>
	 * </ul> 
	 */
	public function getLogPaging($params = array()){
		if(!is_numeric($params['gid']) || $params['gid'] < 0){
			throw_exception('RATING_LACT_GID');
		}
		if(!is_numeric($params['contentid']) || $params['contentid'] < 0){
			throw_exception('RATING_LACT_CONTENTID');
		}
		// ָID
		$ids = EXCMS::convertToIntArray($params['contentids']);
		$where = "`gid` = '{$params['gid']}' AND `contentid` = '{$params['contentid']}'";
		if(empty($params['total']) || $params['total'] < 0){
			$sql = "SELECT COUNT(*) as `total` FROM `{$this->table_log}` WHERE {$where}";
			$GLOBALS['db']->query($sql);
			$rs = $GLOBALS['db']->fetch();
			$total = $rs['total'];
		}else{
			$total = (int)$params['total'];
		}
		$start = (int)$params['start'];
		$start = $start > 0 ? $start : 0;
		$limit = $params['limit'] > 0 ? ($params['limit'] > 100 ? 100 : $params['limit']) : 25;
		$limit = "LIMIT {$start}, {$limit}";
		$sql = "SELECT * FROM {$this->table_log} WHERE {$where} ORDER BY `id` DESC {$limit} ";
		$GLOBALS['db']->query($sql);
		$data = $GLOBALS['db']->fetchAll();
		// format
		if(is_array($data) && count($data) > 0) {
		include_once LIB_PATH . 'plugins/ipquery/IpLocation.class.php';
			$ip = new IpLocation();
        	foreach($data as $k => $v){
        		$area = $ip->getlocation($v['ip']);
        		$data[$k]['area'] = $area['country'];
        		if($data[$k]['uid'] == 0) $data[$k]['uid'] = '';
        		if($data[$k]['username'] == '') $data[$k]['username'] = '';
        		$data[$k]['rateddate'] = formatDate('Y-m-d H:i', $v['rateddate']);
        	}
        }
		return array('total' => $total, 'data' => $data);
	}
}


// excms file end