/*
 * EXCMS Rating Component 1.0
 * Copyright(c) 2010, EXCMS.cn
 * services@excms.cn
 * 
 * http://www.excms.cn
 */

/**
 * @class Rating
 * ֣.<br><br>
 * ʾ:
<pre><code>
var rating = new Rating({stars:5, fullScore:10, minScore:0.5});
</code></pre>
 * @constructor
 * @param {Array} config (Optional) An object, the properties of which provide values for the new Rating's fields.
 */
function $(o){if(document.getElementById&&document.getElementById(o)){return document.getElementById(o)}else if(document.all&&document.all(o)){return document.all(o)}else if(document.layers&&document.layers[o]){return document.layers[o]}else{return false}}

Rating = function(config){
	this.config = config || {};
	this.gid = this.config.gid;
	this.contentid = this.config.contentid;
	this.url = this.config.url;
	this.url ? this.load() : this.initComponent();
};
Rating.prototype = {
	/**
	 * ʹõID
	 * ģֹ
	 * @property gid
	 * @type {Number}
	 */
	/**
	 * ID
	 * ģʹ $_PAGE_CONTENT.contentid, ģһʹ $cnt.contentid
	 * @property contentid
	 * @type {String}
	 */
	/**
	 * ֿؼUIò
	 * @property config
	 * @type {Object}
	 */	
	/**
	 * 
	 * @property renderTo
	 * @type {String/HTMLElement}
	 */
	renderTo : null,
	/**
	 *  HTMLElement 
	 * @property renderTo
	 * @type {String/HTMLElement}
	 */
	el : null,
	/**
	 *  HTMLElement ʽ
	 * @property cls
	 * @type {String}
	 */
	
	cls : '',
	/**
	 * ÷ıʾ HTMLElement 
	 * @property scoreTextEl
	 * @type {String/HTMLElement}
	 */
	scoreTextEl : null,
	/**
	 * 
	 * @property fullScore
	 * @type {Number}
	 */
	fullScore : 10,
	/**
	 * ֵֵСֵ
	 * @property minScore 0 ʱƽ
	 * @type {Number}
	 */
	minScore : 0,
	/**
	 * ǰ÷
	 * @property score
	 * @type {Number}
	 */
	score : 0,
	/**
	 * ܷ
	 * @property sumScore
	 * @type {Number}
	 */
	sumScore : 0,
	/**
	 * 
	 * @property voters
	 * @type {Number}
	 */
	voters : 0,
	/**
	 * û
	 * @property userVoters
	 * @type {Number}
	 */
	userVoters : 0,
	/**
	 * 
	 * @property stars
	 * @type {Number}
	 */
	stars : 5,
	/**
	 * ʾ
	 * ƶϵʾı
	 * @property tips
	 * @type {Array/String}
	 */
	tips : [],
	/**
	 * Ƿ
	 * @property hideStar
	 * @type {Boolean}
	 */
	hideStar : false,
	/**
	 * ÷ı
	 * ʾǰ÷ּݣ{voters}ȡ
	 * @property scoreText
	 * @type {String}
	 */
	scoreText : '({score})',
	/**
	 * Ƿص÷ı
	 * @property hideScoreText
	 * @type {Boolean}
	 */
	hideScoreText : false,
	/**
	 * ǷҪ¼
	 * @property loginVote
	 * @type {Boolean}
	 */
	loginVote : false,
	/**
	 * Ƿֹ
	 * @property denyVote
	 * @type {Boolean}
	 */
	denyVote : false,
	/**
	 * Ƿظ
	 * @property reVote
	 * @type {Boolean}
	 */
	reVote : false,
	
	/**
	 * 鼰
	 */ 
	load : function(){
		var tthis = this;
		ajax.request('post', this.url, {success:function(r){
			var v = ajax.jsondecode(r.responseText);
			if(v.success){
				var g;
				if(g = v.group){
					tthis.config.fullScore = g.fullscore || tthis.config.fullscore;
					tthis.config.score = g.defaultvalue || tthis.config.score;
					tthis.config.stars = g.stars || tthis.config.stars;
					tthis.config.tips = g.tips || tthis.config.tips;
					tthis.config.minScore = g.minscore || tthis.config.minScore;
					tthis.config.scoreText = tthis.config.scoreText || g.scoretext;
					tthis.config.denyVote = g.denyvote || tthis.config.denyVote;
					tthis.config.reVote = g.revote || tthis.config.reVote;
					tthis.config.loginVote = g.loginvote || tthis.config.loginVote;
				}
				if(g = v.content){
					tthis.config.score = g.score;
					tthis.config.sumScore = g.sumscore;
					tthis.config.voters = g.voters;
					tthis.config.userVoters = g.uservoters;
				}
				tthis.initComponent();
				if(typeof tthis.onload == 'function') tthis.onload(v);
			}else{
				alert(v.message ? v.message : 'ʧܣԣ');
			}
		}},{gid:this.gid, contentid:this.contentid, method:'getvalue'});
	},
	/**
	 * apply config
	 */
	apply : function (C, D, B) {
	    if (B) this.apply(C, B);
	    if (C && D && typeof D == 'object') {
	    	for (var A in D) C[A] = D[A];
	    }
	    return C;
	},
	/**
	 * ʼ
	 * @param {Object} config (Optional)
	 */ 
	initComponent : function(config){
		this.apply(this, this.config);
		if(this.tips && typeof this.tips == 'string'){
			this.tips = this.tips.split("\n");
		}
		if(this.el && typeof this.el == 'string'){
			this.el = $(this.el);
		}
		if(this.scoreTextEl && typeof this.scoreTextEl == 'string'){
			this.scoreTextEl = $(this.scoreTextEl);
		}
		if(!this.el && this.renderTo && typeof this.renderTo == 'string'){
			this.renderTo = $(this.renderTo);
		}
		if(!this.reVote && Cookies.processCookeiIds('rating', this.gid+'-'+this.contentid, 20, true)){
			this.denyVote = true;
		}
		this.render();
	},
	/**
	 * Ⱦ
	 */
	render : function(){
		if(!this.el){
			this.el = document.createElement('span');
			if(this.renderTo){
				this.isRender = true;
				this.renderTo.appendChild(this.el);
			}
		}else{
			this.isRender = true;
		}
		this.el.className += ' ratingbar ' + (this.cls || '');
		if(!this.hideStar){
			var a;
			this.el.stars = [];
			for(var i=0;i<this.stars;i++){
				a = document.createElement('a');
				a.className = 'rating-star';
				if(this.tips) a.title = this.tips[i] || '';
				this.el.appendChild(a);
				this.el.stars.push(a);
			}
			this.em = document.createElement('em');
			this.em.className = 'rating-em';
			this.el.appendChild(this.em);
			this.onrender();
		}
		this.renderEm();
	},
	onrender : function(){
		if(!this.el.parentNode) return ;
		this.denyVote ? this.disable() : this.renderEvent();
		this.starWidth = this.el.stars[0].offsetWidth;
		this.increWidth = this.minScore * this.stars * this.starWidth / this.fullScore;
		this.fullWidth = this.stars * this.starWidth;
		this.scorePerPix = this.fullScore / this.fullWidth;
		this.el.style.cssText = ';overflow:hidden;width:' + this.fullWidth + 'px';
		this.setWidth();
	},
	/**
	 * Ⱦ÷ı Element
	 */
	renderEm : function(){
		if(!this.hideScoreText && !this.scoreTextEl && this.el.parentNode && this.el.parentNode.tagName){
			this.scoreTextEl = document.createElement('span');
			this.scoreTextEl.className = 'rating-score';
			var p = this.el.parentNode;
			p.lastChild == this.el ? p.appendChild(this.scoreTextEl) : p.insertBefore(this.scoreTextEl, this.el.nextSibling);
			this.setScoreText();
		}
	},
	/**
	 * append el to element
	 */
	applyTo : function(el){
		if(this.isRender) return ;
		if(typeof el == 'string') el = $(el);
		if(el){
			if(this.el){
				el.appendChild(this.el);
				this.onrender();
				this.renderEm();
			}else{
				this.renderTo = el;
			}
		}
	},
	/**
	 * õ÷ı
	 */
	setScoreText : function(text, score){
		if(!this.hideScoreText && this.scoreTextEl){
			if(!text && this.scoreText){
				score = typeof score == 'undefined' ? this.score : score;
				text = this.scoreText.replace('{score}', score||0).replace('{sumscore}', this.sumScore||0).replace('{voters}', this.voters||0).replace('{uservoters}', this.userVoters||0);
			}
			this.scoreTextEl.innerHTML = text || '';
		}
	},
	/**
	 * Ⱦ¼
	 */
	renderEvent : function(){
		var tthis = this;
		this.el.onmousemove = function(e){
			e = window.event || e;
			var w = 0;
			if(this.getBoundingClientRect){
				w = this.getBoundingClientRect();
				w = e.clientX - w.left;
			}else{
				w = e.clientX - this.offsetLeft; 
				var p = this;
				while(p = p.offsetParent){
					w -= p.offsetLeft; 
				}
			}
			if(tthis.increWidth > 0){
				w = tthis.increWidth * Math.ceil(w / tthis.increWidth);
			}
			tthis.setWidth(w);
			tthis.currentScore = (w * tthis.scorePerPix).toFixed(1);
			tthis.setScoreText('', tthis.currentScore);
		}
		this.el.onmouseout = function(){
			tthis.setScoreText();
			tthis.setWidth();
		}
		this.el.onclick = function(){
			tthis.score = tthis.currentScore;
			tthis.setScoreText();
			tthis.commit();
		}
	},
	/**
	 * ø߶ֿ
	 */
	setWidth : function(width){
		if(this.hideStar) return ;
		width = typeof width == 'undefined' ? this.getWidth() : width;
		width = Math.round(width || 0);
		width = Math.max(0, Math.min(this.fullWidth, width));
		this.em.style.width = width + 'px';
	},
	/**
	 * ȼ
	 */
	getWidth : function(){
		return Math.round((this.score || 0) / this.scorePerPix);
	},
	/**
	 * 
	 */
	setScore : function(score){
		if(score > this.fullScore && score < 0){
			alert('ֵС0Ҳܴ'+this.fullScore+'');
			return ;
		}
		this.score = score;
		this.setWidth();
		this.setScoreText();
	},
	/**
	 * ȡǰ
	 */
	getScore : function(){
		return this.score;
	},
	/**
	 * ύ
	 */
	commit : function(){
		if(this.url){
			var tthis = this;
			if(this.loginVote && !Login.login){
				Account.login({callback:function(){tthis.commit()}});
				return ;
			}
			ajax.request('post', this.url, {success:function(r){
				var v = ajax.jsondecode(r.responseText);
				if(v.success == 1){
					tthis.sumScore = v.sumscore;
					tthis.voters = v.voters;
					tthis.userVoters = v.uservoters;
					tthis.setScore(v.score);
					if(!tthis.reVote) tthis.disable();
					Cookies.processCookeiIds('rating',tthis.gid+'-'+tthis.contentid,20);
				}else if(v.success == -1){
					Account.login({callback:function(){alert(1);tthis.commit()}});
				}else{
					alert(v.message ? v.message : 'ʧܣԣ');
				}
			}},{contentid:this.contentid, gid:this.gid, score:this.score, method:'commit'});
		}else if(!this.reVote){
			this.disable();
		}
	},
	/**
	 * ֹ
	 */
	disable : function(){
		if(this.el.disabled) return;
		this.el.disabled = true;
		this.el.onmousemove = this.el.onmouseout = this.el.onclick = function(){return false}
		for(var i=0,len=this.el.stars.length;i<len;i++)
			this.el.stars[i].style.cssText = ';cursor:default';
	}
};
