<?php
/**
 * Project:		EXCMS: the PHP content management system.
 * File:		video.php
 *
 * A product of PUTOYO Inc.
 * 
 * EXCMS is a ten million data-level,high speed,human-based content management system.
 *
 * EX is Excellence & Express & Exceed & Expert.
 * 
 * For questions, help, comments, discussion, please join the
 * EXCMS mailing list. Send a blank e-mail to
 * join@excms.cn
 * or join the EXCMS forum
 * www.excms.cn/forum
 * 
 * @link http://www.excms.cn/
 * @copyright Copyright (c) 2010 PUTOYO Inc.
 * @license http://www.excms.cn/licenses/LICENSE-1.0
 * @category EXCMS
 * @author lele
 * @version $Rev: 146 $
 */
/* $Id: index.php 146 2009-11-10 07:58:36Z zhangxuelin $ */

//ϵͳļ
require_once ('../configuration/inc/common.inc.php');

// ȡƵID
$contentid = $_GET['contentid'] ? $_GET['contentid'] : $_GET['id'];
$contentid = str_replace('.xml', '', $contentid);
$data = explode('|',$contentid);
$contentid = $data[0];
$field = $data[1] ? $data[1] : 'videos';
$page = $data[2] ? $data[2] : 1;


// IDʱ 
$EXCMS_CONFIG['code_contentid'] && $contentid = EXCMS::id_decode($contentid);

// ƵIDǷ
if(!is_numeric($contentid) || !($contentid > 0)) exit('ȱID');

// ƵಢȡƵ
include_once LIB_PATH . 'content/ContentAddon.class.php';
$addon = new ContentAddon();
$addon_array = $addon->getById($contentid);

// Ƶ
if(!isset($addon_array[$field])) exit('ȱƵ');
$videos_array = EXCMS::jsondecode($addon_array[$field]);

// include_once LIB_PATH . 'update/ContentFunction.class.php';

$items = '';
if(is_array($videos_array) && count($videos_array)){
	foreach($videos_array as $k => $v){
		$source = $v['resource'] && stripos($v['resource'], 'resource:') === 0;
		$thumb = $v['thumb_resource'] && stripos($v['thumb_resource'], 'resource:') === 0;
		if(($source || $thumb) && !isset($resource)){
			include_once LIB_PATH . 'resource/Resource.class.php';
			$resource = new Resource();
		}
		if($source){
			$rs = $resource->getResource($v['resource']);
			if($rs['src']){
				$videos_array[$k]['src'] = $rs['src'];
				$videos_array[$k]['_src_resource'] = $rs['_src_resource'];
			}else{
				$videos_array[$k]['src'] = $v['src'] ? $v['src'] : $v['resource'];
			}
		}
		if($thumb){
			$rs = $resource->getResource($v['thumb_resource']);
			if($rs['src']){
				$videos_array[$k]['thumb'] = $rs['src'];
				$videos_array[$k]['_thumb_resource'] = $rs['_src_resource'];
			}else{
				$videos_array[$k]['thumb'] = $v['thumb'] ? $v['thumb'] : $v['thumb_resource'];
			}
		}
		$items .= "\n\t\t<item>\r\n\t\t\t<title>{$videos_array[$k]['name']}</title>\r\n\t\t\t<img>{$videos_array[$k]['thumb']}</img>\r\n\t\t\t<url>{$videos_array[$k]['src']}</url>\r\n\t\t</item>";
	}
}
$total = count($videos_array);
$page = $page > $total ? $total : ($page < 1 ? 1 : $page);
// ȡƵ·
$path = EXCMS::url(array('name' => 'components'));

echo <<<EOF
<?xml version="1.0" encoding="utf-8" ?>
<config>
	<file>{$videos_array[$page-1]['src']}</file>
	<autostart>true</autostart>
	<volume>80</volume>
	<begin>{$videos_array[$page-1]['thumb']}</begin>
	<adtime>3</adtime>
	<bufferlength>5</bufferlength>
	<logo>{$path}/video/logo.png</logo>
	<logocolor>0xff9900</logocolor>
	<aboutlink>http://www.excms.cn</aboutlink>
	<abouttext>EXCMS</abouttext>
	<list>{$items}
	</list>
</config>
EOF;

//<advertisement>ƵͼƬURL</advertisement>

// excms file's end