<?php
/**
 * Project:		EXCMS: the PHP content management system.
 * File:		index.php
 *
 * A product of PUTOYO Inc.
 * 
 * EXCMS is a ten million data-level,high speed,human-based content management system.
 *
 * EX is Excellence & Express & Exceed & Expert.
 * 
 * For questions, help, comments, discussion, please join the
 * EXCMS mailing list. Send a blank e-mail to
 * join@excms.cn
 * or join the EXCMS forum
 * www.excms.cn/forum
 * 
 * @link http://www.excms.cn/
 * @copyright Copyright (c) 2010 PUTOYO Inc.
 * @license http://www.excms.cn/licenses/LICENSE-1.0
 * @category EXCMS
 * @package ask
 * @author $Author: zhanghaisong $
 * @version $Rev: 1896 $
 */
/* $Id: index.php 1896 2010-07-18 02:02:46Z zhanghaisong $ */
/**
 * ʴû
 * @category EXCMS
 * @package ask
 * @author $Author: zhanghaisong $
 */
//ASKϵͳļƶʱ޸ļ·
require_once ('configuration/inc/common.inc.php');
$_PAGE['action'] = $_POST['action'] ? $_POST['action'] : $_GET['action'];
$action_allow = array('addquestion', 'addquestionsuccess', 'addanswer', 'noanswer', 'hidden', 'unhide', 'abandon', 'setting', 'question_action', 'append', 'vote', 'addvote', 'adopt', 'noanswer');
if($_PAGE['action'] == '' || !in_array($_PAGE['action'], $action_allow)){
	Header("HTTP/1.1 403.1 Unkonw Action");
	exit;
}

// check user logined
if(!EXCMS_SESSION_UID){
	if($ajax){
		EXCMS::json_print(EXCMS::jsonencode(array('success' => -1, 'message' => 'Login time out')));
	}else{
		$forward = $_PAGE['action'] == 'logout' ? '' : urlencode('http://' . $_SERVER['SERVER_NAME'] . ($_SERVER['SERVER_PORT'] == 80 ? '' : (':' . $_SERVER['SERVER_PORT'])) . $_SERVER['REQUEST_URI']);
		Header('location:' . EXCMS::url(array('name' => 'account.login', 'forward' => $forward)));
	}
	exit;
}

$return = array('success' => false, 'message' => 'Ƿ', 'url' => $_SERVER['Referer']);

switch($_PAGE['action']){
	// ػش
	case 'hidden' :
		include_once ASK_LIB_PATH.'Answer.class.php';
		$answer = new Answer();
		$return['success'] = $answer->updateHidden($_POST['aid'], true);
		$return['message'] = $return['success'] ? 'سɹ' : 'ʧ';
		break;
	// ȡ
	case 'unhide' :
		include_once ASK_LIB_PATH.'Answer.class.php';
		$answer = new Answer();
		$return['success'] = $answer->updateHidden($_POST['aid'], false);
		$return['message'] = $return['success'] ? 'ȡسɹ' : 'ȡʧ';
		break;
	// ش
	case 'abandon' :
		include_once ASK_LIB_PATH . 'AskQuestion.class.php';
		$question = new AskQuestion();
		$return['success'] = $question->updateSolve(EXCMS_SESSION_UID, $_POST['qid'], false);
		$return['message'] = $return['success'] ? 'ѷش' : 'شʧ';
		break;
	// 
	case 'setting' :
		$data = array('uid' => EXCMS_SESSION_UID, 'question' => $_POST['question'], 'maxrecord' => $_POST['maxrecord'], 'cid' => $_POST['cid'], 'keywords' => $_POST['keywords']);
		include_once ASK_LIB_PATH.'AskSetting.class.php';
		$setting = new AskSetting();
		$return['success'] = $setting->commit($data);
		$return['message'] = $return['success'] ? 'óɹ' : Message::getMessage();
		break;
	// 
	case 'question_action' :
		include_once ASK_LIB_PATH . 'AskQuestion.class.php';
		$question = new AskQuestion();
		//
		if($_POST['append']){
			include_once ASK_LIB_PATH.'AskAppend.class.php'; //ⲹ,
			$aa = new AskAppend();
			$aa->insertSupplement(array('qid' => $_POST['qid'], 'content' => strip_tags($_POST['content'])));
			$return['success'] = $question->append($_POST['qid'], 1);
		}
		//
		if($_POST['raise_score']){
			include_once ASK_LIB_PATH.'AskScore.class.php';
			$score = new AskScore();
			$score_array = $score->getScoreByUid(EXCMS_SESSION_UID);
			if(count($score_array) > 0 && $_POST['score'] > $score_array['score']){
				$return['success'] = false;
				$return['message'] = "ǰĻΪ" . $score_array['score'] . ",ͻֲ,鿴λȡ";
			}else{
				$return['success'] = $question->updateCent($_POST['qid'], $_POST['score']); //ͷ
				$question->updateSolveddate($_POST['qid'], 3); //ϵͳԶӳЧ 3
				if($_POST['score'] > 20){
					$question->setting('createdate', $_POST['qid'], time());
				}
			}
		}
		//
		if($_POST['urgent']){
			$return['success'] = $questions->updateUrgent($_POST['qid'], $_POST['urgent']);
		}
		//
		if($_POST['anonymous']){
			$return['success'] = $question->updateAnonymous($_POST['qid'], $_POST['anonymous']);
		}
		$return['message'] = 'óɹ';
		break;
	// ׷ʻ򲹳ش
	case 'append' :
		$type = $_POST['type'] ? 1 : 0;
		include_once ASK_LIB_PATH.'AskAppend.class.php'; //ⲹ,
		$aa = new AskAppend();
		$aa->insertAppend(array('aid' => $_POST['aid'], 'type' => $type, 'content' => strip_tags($_POST['content'])));
		include_once ASK_LIB_PATH.'Answer.class.php';
		$answer = new Answer();
		$return['success'] = $answer->append($_POST['aid'], 1);
		if($_POST['anonymous'] > 0){
			$return['success'] = $answer->updateAnonymous($_POST['aid'], $_POST['anonymous']);
		}
		$return['message'] = '³ɹ';
		break;
	// תͶƱ
	case 'vote' :
		include_once ASK_LIB_PATH . 'AskQuestion.class.php'; //,AskQuestion
		$question = new AskQuestion();
		$question->updateStatus($_POST['qid'], 5); //תͶƱ
		$question->updateVoteDate($_POST['qid'], time()); //ͶƱʱ
		$question->updateVoteSolved($_POST['qid']); //½ʱ
		include_once ASK_LIB_PATH.'Answer.class.php';
		$answer = new Answer();
		$return['success'] = $answer->updateVote($_POST['aid'], true);
		$return['url'] = EXCMS::url(array('name' => 'ask.question', 'id' => $_POST['qid']));
		break;
	// ͶƱ
	case 'addvote' :
		include_once ASK_LIB_PATH.'Answer.class.php';
		$answer = new Answer();
		$answer->updateVotecount($_POST['aid']); //ͶƱ
		include_once ASK_LIB_PATH.'AskVote.class.php';
		$vote = new AskVote();
		if(!$vote->isVote(EXCMS_SESSION_UID, $_POST['qid'])){ //ǷѾͶƱ
			$data = array('qid' => (int)$_POST['qid'], 'aid' => (int)$_POST['aid'], 'uid' => (int)EXCMS_SESSION_UID);
			$vote->insert($data);
			$aidvote = $vote->groupStatVoteByQid($_POST['qid']); //شIDͳƷͳͶƱ
			$votetotal = 0;
			if(is_array($aidvote) && count($aidvote) > 0){
				foreach($aidvote as $value){
					$votetotal += $value['total'];
					if($value['total'] >= 3) $aid = $value['aid'];
				}
			}
			$votedate = $question_array['votedate']; //ͶƱʱ
			$day = (time() - $votedate) / 86400;
			if($votetotal >= 4 && $aid > 0 && $day >= 1){ //ͶƱƱƱߵĻشƱ 3 Ʊ,ͬʱͶƱڴﵽ1죨24СʱϵͳԶƱĻشѡΪȷ𰸡
				include_once ASK_LIB_PATH.'Answer.class.php';
				$answer = new Answer();
				$answer->updateIsbast($aid, true); //Ѵ
				unset($answer);
			}
			//ͶƱɹӻ
			include_once ASK_LIB_PATH.'AskScore.class.php';
			$score = new AskScore();
			$score->scoreVote(EXCMS_SESSION_UID);
			$return['success'] = true;
			$return['message'] = 'ͶƱɹлĲ';
		}else{
			$return['message'] = 'ѾЩͶƱظͶƱ';
		}
		$return['url'] = EXCMS::url(array('name' => 'ask.question', 'id' => $_POST['qid']));
		break;
	// ɴ
	case 'adopt' :
		if(!$_POST['qid'] > 0){
			EXCMS::showMessage('IDڻѱɾ');
		}
		if(!$_POST['aid'] > 0){
			EXCMS::showMessage('شIDڻشѱɾ');
		}
		//ػش
		include_once ASK_LIB_PATH.'Answer.class.php';
		//شAnswer
		$answer = new Answer();
		//´𰸱
		$return['success'] = $answer->updateIsbast($_POST['aid'], true);
		$return['message'] = 'ɴ𰸳ɹ';
		$return['url'] = EXCMS::url(array('name' => 'ask.question', 'id' => $_POST['qid']));
		break;
	// 
	case 'noanswer' :
		include_once ASK_LIB_PATH . 'AskQuestion.class.php'; //,AskQuestion
		$question = new AskQuestion();
		$question_array = $question->getById($_POST['qid']);
		
		if($question_array['uid'] > 0){
			include_once ASK_LIB_PATH.'AskScore.class.php';
			$score = new AskScore();
			if($question_array['status'] == 4){															//ɴ𰸻10ֻ
				$score->scoreExpiredDeal($question_array['uid']);
			}
			if($question_array['score'] > 0){
				$score->scoreCentQuestion($question_array['uid'], $question_array['score']); 			//𰸻
			}
		}
		
		$question->updateSolveddate($_POST['qid'], 0, time()); 				//¹رʱ
		$return['success'] = $question->updateStatus($_POST['qid'], 6);		//Ϊ
		$return['message'] = 'ر';
		//תǰҳ
		$return['url'] = EXCMS::url(array('name' => 'ask.question', 'id' => $_POST['qid']));
		break;
	// ӻش
	case 'addanswer' :
		// ֤
		if($EXCMS_MODULE['ask']['answer_verifycode'] && !EXCMS::verifycode_check($_POST['verifycode'])){
			$return['message'] = '֤벻ȷ';
			EXCMS::json_print($return);
			exit;
		}
		$data = array(
			'qid' => $_POST['qid'],
			'cid' => $_POST['cid'],
			'anonymous' => 0,
			'content' => trim(strip_tags($_POST['content'])),
			'uid' => EXCMS_SESSION_UID,
			'ip' => $_SERVER['REMOTE_ADDR']
		);
		if(strlen($data['content']) < 8){
			$return['message'] = 'ϸش';
			EXCMS::json_print($return);
			exit;
		}
		if($data['qid'] < 1){
			$return['message'] = 'ʲڻѱɾ';
			EXCMS::json_print($return);
			exit;
		}
		// , AskQuestion
		include_once ASK_LIB_PATH . 'AskQuestion.class.php'; 
		$question = new AskQuestion();
		$question_array = $question->getById($data['qid']);
		if($question_array['uid'] == EXCMS_SESSION_UID){
			$return['message'] = 'ܻشԼ';
			EXCMS::json_print($return);
			exit;
		}
		// ػش࣬شAnswer
		include_once ASK_LIB_PATH.'Answer.class.php';
		$answer = new Answer();
		if($answer->isAnswerByQid($data['qid'], EXCMS_SESSION_UID) > 0){
			$return['message'] = 'Ѿش,ظش';
			EXCMS::json_print($return);
			exit;
		}
		// ش
		if($EXCMS_MODULE['ask']['answer_anonymous_allow'] && $_POST['anonymous'] ==  1){
			$data['anonymous'] = 1;
		}
		$return['success'] = $answer->insert($data) ? 1 : 0;
		break;
		
	// 
	case 'addquestion' :
		// ֤
		if($EXCMS_MODULE['ask']['question_verifycode'] && !EXCMS::verifycode_check($_POST['verifycode'])){
			$return['message'] = '֤벻ȷ';
			EXCMS::json_print($return);
			exit;
		}
		$data = array(
			'title' => trim($_POST['title']),
			'content' => trim(strip_tags($_POST['content'])),
			'cid' => (int)$_POST['category'],
			'score' => (int)$_POST['score'],
			'urgent' => $_POST['urgent'],
			'uid' => EXCMS_SESSION_UID,
			// 'directto' => $_POST['directto'],
			'anonymous' => $_POST['anonymous'],
			'ip' => $_SERVER['REMOTE_ADDR']
		);
		if(strlen($data['title']) < 8){
			$return['message'] = '벹ʱ';
			EXCMS::json_print($return);
			exit;
		}
		if(!$data['cid'] > 0){
			$return['message'] = 'ѡ';
			EXCMS::json_print($return);
			exit;
		}
		if($data['score'] > 0 && $data['score'] > $_POST['totalscore']){
			// ࣬AskQuestion
			include_once ASK_LIB_PATH.'AskScore.class.php';
			$askScore = new AskScore();
			$user_score = $askScore->getScoreByUid(EXCMS_SESSION_UID);
			if($data['score'] > $user_score['score']){
				$return['message'] = 'ǰĻΪ' . $user_score['score'] . 'ͻ';
				EXCMS::json_print($return);
				exit;
			}
			unset($askScore, $user_score);
		}
		// 
		if($EXCMS_MODULE['ask']['question_anonymous_allow'] && $_POST['anonymous'] == 1){
			$data['anonymous'] = 1;
		}
		// ࣬AskQuestion
		include_once ASK_LIB_PATH . 'AskQuestion.class.php';
		$question = new AskQuestion();
		$id = $question->insert($data);
		$return['success'] = 1;
		$return['url'] = EXCMS::url(array('name' => 'ask.action', 'action' => 'addquestionsuccess'));
		$return['url'] .= strpos($return['url'], '?') === false ? '?' : '&';
		$return['url'] .= "qid={$id}&c=0";
		break;
	// ʾʳɹϢ
	case 'addquestionsuccess':
		$id = $_GET['qid'];
		if($id > 0){
			$_PAGE['question_check'] = $_GET['c'];
			$_PAGE['goto'] = $_PAGE['question_check'] == 1 ? EXCMS::url(array('name' => 'ask.myask')) : EXCMS::url(array('name' => 'ask.question', 'id' => $id));
			EXCMS::display('ask/message.html');
		}else{
			Header("HTTP/1.1 403.1 Unkonw Action");
		}
		exit;
		break;
}
EXCMS::json_print($return);

// excms file end