<?php
/**
 * Project:		EXCMS: the PHP content management system.
 * File:		AskAction.php
 *
 * A product of PUTOYO Inc.
 * 
 * EXCMS is a ten million data-level,high speed,human-based content management system.
 *
 * EX is Excellence & Express & Exceed & Expert.
 * 
 * For questions, help, comments, discussion, please join the
 * EXCMS mailing list. Send a blank e-mail to
 * join@excms.cn
 * or join the EXCMS forum
 * www.excms.cn/forum
 * 
 * @link http://www.excms.cn/
 * @copyright Copyright (c) 2010 PUTOYO Inc.
 * @license http://www.excms.cn/licenses/LICENSE-1.0
 * @category EXCMS
 * @package ask
 * @author $Author: zhanghaisong $
 * @version $Rev: 2252 $
 */
/* $Id: AskAction.php 2252 2010-08-17 10:11:48Z zhanghaisong $ */
/**
 * EXCMS ʶ
 */
if (!defined('EXCMS') || !defined('EXCMS_ADMIN') || !defined('ASK_PATH'))
{
    exit('Access Denied');
}
$IS_AJAX_REQUEST = true;

$message = array();
/**
 * ִ
 */
switch($method){
	/**
	 * 
	 */
	case 'tree' :
		include_once ASK_LIB_PATH . 'AskCategory.class.php';
		$askcate = new AskCategory();
		$message = $askcate->getAskCategoryTree($_POST['node']);
		break;
	case 'catestore' :
		$paging = array(
			'limit' => $_POST['limit'],
        	'start' => $_POST['start'],
            'sort' => $_POST['sort'],
            'dir' => $_POST['dir'],
            'total' => $_POST['TotalCount'],
            'pid' => (int)$_POST['pid'],
        	'keywords' => trim($_POST['key']),
        );
		include_once ASK_LIB_PATH . 'AskCategory.class.php';
		$askcate = new AskCategory();
		$message = $askcate->getPaging($paging);
		break;
	/**
	 * /޸
	 */
	case 'catecommit' :
		$data = array(
			'pid' =>$_POST['pid'],
			'name' =>$_POST['name'],
			'description' => $_POST['description'],
			'questioncheck' => $_POST['questioncheck'],	
			'answercheck' => $_POST['answercheck'],
			'sort' => $_POST['sort']
		);
		include_once ASK_LIB_PATH . 'AskCategory.class.php';
		$askcate = new AskCategory();
		$id = (int)$_POST['cid'];
		if($id>0){
			$askcate->update($id,$data);
		}else{
			$id = $askcate->insert($data);
		}
		$message['id']  = $id;
        $message['success'] = true;
        $message['message'] = "ɹ";
		break;
	/**
	 * ɾ
	 */
	case 'delcate' :
		include_once ASK_LIB_PATH . 'AskCategory.class.php';
		$askcate = new AskCategory();
		// ȡɾķid
		$ids = $askcate->getAskCategoryChilds($_POST['ids']);
		//ɾ
		include_once ASK_LIB_PATH . 'AskQuestion.class.php';
		$questions = new AskQuestion();
		$questions->deleteByCid($ids);
		//ɾϢ
		$message['success'] = $askcate->delete($ids);
		$message['message'] = "ɾɹ";
		unset($questions,$askcate);
		break;
	/**
     * ȡб
     */
	case 'store' :
		$paging = array(
			'limit' => $_POST['limit'],
        	'start' => $_POST['start'],
            'sort' => $_POST['sort'],
            'dir' => $_POST['dir'],
            'total' => $_POST['TotalCount'],
            'cid' => (int)$_POST['cid'],
            'checked' => $_POST['checked'],
            'status' => $_POST['status'],
            'urgent' => $_POST['urgent'],
            'elite' => $_POST['elite'],
        	'keywords' => trim($_POST['key']),
        );
    	include_once ASK_LIB_PATH . 'AskQuestion.class.php';
		$questions = new AskQuestion();
		$message = $questions->getPaging($paging);
		unset($questions,$paging);
        break;
   /**
    * /޸
    */
	case 'questionCommit' :
		//ȡ½ûID
		$session = EXCMS::getSession();
		 $data = array(
        	'cid' => $_POST['cid'],
        	'title' => trim($_POST['title']),
        	'score' => $_POST['score'],
            'content' => $_POST['content'],
            'urgent' => $_POST['urgent'],
            'anonymous' => $_POST['anonymous'],
            'uid' => $session['user']['uid'],
            'ip' => $_SERVER['REMOTE_ADDR']
        );
        include_once ASK_LIB_PATH . 'AskQuestion.class.php';
		$questions = new AskQuestion();
        $id = (int)$_POST['qid'];
        if($id>0){
			$questions->update($id,$data);
		}else{			
			$id = $questions->insert($data);
		}
		$message['message'] = "ɹ";
        $message['success'] = true;
		$message['id']  = $id;
		unset($questions,$data);
		break;
	/**
	 * ϸϢ
	 */
	case 'getById' :
		include_once ASK_LIB_PATH . 'AskQuestion.class.php';
		$questions = new AskQuestion();
		$message = $questions->getById($_POST['id']);
		include_once ASK_LIB_PATH . 'AskCategory.class.php';
		$askcate = new AskCategory();
		$cate_array =  $askcate->getById($message['cid']);
		$message['catename'] = $cate_array['name'];
		$message['createdate'] = formatDate("Y-m-d H:i:s",$message['createdate']);
    	$message['modifieddate'] = formatDate("Y-m-d H:i:s",$message['modifieddate']);
        unset($questions,$askcate,$cate_array);
		break;
	/**
	 * ɾ
	 */
	case 'delete' : 
		include_once ASK_LIB_PATH . 'AskQuestion.class.php';
		$questions = new AskQuestion();
		$message['success']  = $questions->delete($_POST['ids']);
        $message['message'] = "ɾɹ";
        unset($questions,$askcate);
		break;
	/**
	 * ״̬
	 */
	case 'checked' :
		include_once ASK_LIB_PATH . 'AskQuestion.class.php';
		$questions = new AskQuestion();
		$message['success'] = $questions->updateChecked($_POST['qids'],$_POST['value']);
		$message['message'] = $message['success'] ? 'óɹ' : 'ʧ';
		break;
	/**
	 * ʾ״̬
	 */
	case 'status' :
		include_once ASK_LIB_PATH . 'AskQuestion.class.php';
		$questions = new AskQuestion();
		$message['success'] = $questions->updateStatus($_POST['qids'],$_POST['value']);
		$message['message'] = $message['success'] ? 'óɹ' : 'ʧ';
		break;
	/**
	 * ̶
	 */
	case 'urgent' :
		include_once ASK_LIB_PATH . 'AskQuestion.class.php';
		$questions = new AskQuestion();
		$message['success'] = $questions->updateUrgent($_POST['qids'],$_POST['value']);
		$message['message'] = $message['success'] ? 'óɹ' : 'ʧ';
		break;
	/**
	 * þ
	 */
	case 'elite' :
		include_once ASK_LIB_PATH . 'AskQuestion.class.php';
		$questions = new AskQuestion();
		$message['success'] = $questions->updateElite($_POST['qids'],$_POST['value']);
		$message['message'] = $message['success'] ? 'óɹ' : 'ʧ';
		break;
		
	/**
	 * ɾ
	 */
	case 'deleteanswer' : 
		include_once ASK_LIB_PATH.'Answer.class.php';
		$answer = new Answer();
		$message['success']  = $answer->delete($_POST['aids']);
        $message['message'] = $message['success'] ? 'ɾ𰸳ɹ' : 'ɾʧ';
        unset($answer);
		break;
	/**
	 * ˴
	 */
	case 'answerchecked' :
		include_once ASK_LIB_PATH.'Answer.class.php';
		$answer = new Answer();
		$message['success'] = $answer->updateStatus($_POST['aids'],$_POST['value']);
		$message['message'] = $message['success'] ? '˳ɹ' : 'ʧ';	
		unset($answer);
		break;
	/**
	 * ش
	 */
	case 'ishidden' :
		include_once ASK_LIB_PATH.'Answer.class.php';
		$answer = new Answer();
		$message['success'] = $answer->updateHidden($_POST['aids'],$_POST['value']);
		$message['message'] = $message['success'] ? 'óɹ' : 'ʧ';	
		unset($answer);
		break;
	/**
	 * ɴ
	 */
	case 'isbest' :
		include_once ASK_LIB_PATH.'Answer.class.php';
		$answer = new Answer();
		$message['success'] = $answer -> updateIsbast($_POST['aid'],true);
		$message['message'] = $message['success'] ? 'ɴ𰸳ɹ' : 'ɴʧ';	
		unset($answer);
		break;
	/**
	 * ʾشб
	 */
	case 'answerstore' :
        $paging = array(
			'limit' => $_POST['limit'],
        	'start' => $_POST['start'],
            'sort' => $_POST['sort'],
            'dir' => $_POST['dir'],
            'total' => $_POST['TotalCount'],
            'qid' => (int)$_POST['qid'],
            'checked' => $_POST['checked'],
            'cid'	=> (int)$_POST['cid'],
        	'keywords' => trim($_POST['key']),
        );
    	include_once ASK_LIB_PATH.'Answer.class.php';
		$answer = new Answer();
		$message = $answer->getPaging($paging);
		if($paging['qid']>0){
			include_once ASK_LIB_PATH . 'AskQuestion.class.php';
			$questions = new AskQuestion();
			$questions->updateNewAnswer($paging['qid'],false);
		}
		break;
}
EXCMS::json_print($message);
?>