EXCMS.namespace('EXCMS.Ask');
EXCMS.Ask = {
	baseAction : 'index.php?M=Modules&EM=ask&A=AskAction',
	modulesAction : 'index.php?M=Modules&A=ModulesAction&moduleid=ask',
	checked: -1,
	urgent: -1,
	init:function(){
	    Ext.QuickTips.init();
	    this.ask_config = _EXCMS_ASK_CONFIG;
	    this.view();
	},
	view : function(){
        this.D = new Ext.data.Store({
            proxy : new Ext.data.HttpProxy({url:this.baseAction+'&method=store'}),
            reader: new Ext.data.JsonReader({root: 'data',totalProperty: 'total',id: 'qid',
                fields: [{name: 'qid', type: 'int'},
                    {name: 'catename', type: 'string'},{name: 'title', type: 'string'},{name: 'score', type: 'string'},{name: 'hot', type: 'string'},
                    {name: 'checked', type: 'int'},{name: 'elite', type:'int'},{name: 'status', type:'int'},{name: 'newanswer',type:'int'},
                    {name: 'answernumber',type:'int'},{name: 'createdate'}, {name: 'modifieddate'},{name: 'username', type: 'string'}
                ]
            }),
            remoteSort: true
        });
        this.soField = new Ext.form.TwinTriggerField({emptyText:',',width:240,trigger1Class:'x-form-clear-trigger',trigger2Class:'x-form-search-trigger',onTrigger1Click:this.soOnTrigger1Click.createDelegate(this),onTrigger2Click:this.soOnTrigger2Click.createDelegate(this)});
		this.soField.on('specialkey',function(f,e){if(e.getKey() == e.ENTER){this.soOnTrigger2Click();}},this);
		this.menu = [
		   {text:'',iconCls:'btnico btn_preview',handler:this.browse,scope:this,mode:0},
		   {text:'鿴ش',iconCls:'btnico btn_preview',handler:this.viewanswer,scope:this},
	       {text:'½',iconCls:'btnico btn_add',handler:this.QuestionEdit,scope:this,mode:0},
	       {text:'༭',iconCls:'btnico btn_edit',handler:this.QuestionEdit,scope:this,mode:1},
	       {text:'ɾ',iconCls:'btnico btn_del',handler:this.QuestionDel,scope:this},
	       {text:'',menu: {items:[
		       	{text:'',menu: {items:[
					{text:'ͨ',iconCls:'btnico btn_check',handler:this.setChecked,scope:this,mode:2},
					{text:'ͨ',handler:this.setChecked,scope:this,mode:1}
				]}},
				{text:'״̬',menu: {items:[
					{text:'',handler:this.setStatus,scope:this,mode:2},
					{text:'ѽ',handler:this.setStatus,scope:this,mode:3},
					{text:'ѹ',handler:this.setStatus,scope:this,mode:4},
					{text:'ͶƱ',handler:this.setStatus,scope:this,mode:5},
					{text:'ر',handler:this.setStatus,scope:this,mode:6}
				]}},
				{text:'̶',menu: {items:[
					{text:'',handler:this.setUrgent,scope:this,mode:1},
					{text:'ͨ',handler:this.setUrgent,scope:this,mode:0}
				]}},
				//{text:'Ƽ',handler:this.setElite,scope:this,mode:1},
				{text:'þ',menu: {items:[
					{text:'',handler:this.setElite,scope:this,mode:1},
					{text:'Ǿ',handler:this.setElite,scope:this,mode:0}
				]}}
				
	       ]}},
	       {text:'ʾ',menu: {items:[
		       {text:'״̬',menu: {items:[
		       		{text:'ȫ',group: 'checked',checked: true,handler:this.displayChecked,scope:this,mode:-1},
					{text:'δ',group: 'checked',checked: false,handler:this.displayChecked,scope:this,mode:0},
					{text:'δͨ',group: 'checked',checked: false,handler:this.displayChecked,scope:this,mode:1},
					{text:'ͨ',group: 'checked',checked: false,handler:this.displayChecked,scope:this,mode:2}
				]}},
				{text:'',menu: {items:[
					{text:'ȫ',group: 'status',checked: true,handler:this.displayStatus,scope:this,mode:0},
		       		{text:'',group: 'status',checked: false,handler:this.displayStatus,scope:this,mode:2},
					{text:'ѽ',group: 'status',checked: false,handler:this.displayStatus,scope:this,mode:3},
					{text:'ѹ',group: 'status',checked: false,handler:this.displayStatus,scope:this,mode:4},
					{text:'ͶƱ',group: 'status',checked: false,handler:this.displayStatus,scope:this,mode:5},
					{text:'ر',group: 'status',checked: false,handler:this.displayStatus,scope:this,mode:6}
				]}},
				{text:'̶',menu: {items:[
					{text:'ȫ',group: 'urgent',checked: true,handler:this.displayUrgent,scope:this,mode:-1},
					{text:'',group: 'urgent',checked: false,handler:this.displayUrgent,scope:this,mode:1},
					{text:'ͨ',group: 'urgent',checked: false,handler:this.displayUrgent,scope:this,mode:0}
				]}},
				{text:'',menu: {items:[
					{text:'ȫ',group: 'elite',checked: true,handler:this.displayElite,scope:this,mode:3},
					{text:'',group: 'elite',checked: false,handler:this.displayElite,scope:this,mode:1},
					{text:'Ǿ',group: 'elite',checked: false,handler:this.displayElite,scope:this,mode:0}
				]}}
	       ]}}
	    ];
        this.toolbar = new Ext.Toolbar({items:[
    		this.menu,'-',
            {text:'ˢ',iconCls:'btnico btn_fresh',handler:function(){this.D.reload();},scope:this},
            '->',' ',this.soField
        ]});
        
        this.grid = new Ext.grid.GridPanel({title:'б',store:this.D,
            columns:[
                {header:"ID",width:50,sortable:true,dataIndex:'qid'},
				{header:"",width:250,sortable:true,dataIndex:'title'},
				{header:"",width:100,sortable:true,dataIndex:'catename'},
				{header:"ͷ",width:50,sortable:true,dataIndex:'score'},
                {header:"",width:80,sortable:true,dataIndex:'username'},
                {header:"",width:36,sortable:true,dataIndex:'checked',renderer:this.renderChecked,scope:this},
				{header:"״̬",width:70,sortable:true,dataIndex:'status',renderer:this.renderStatus,scope:this},
                {header:"",width:46,sortable:true,dataIndex:'elite',renderer:this.formateScore,scope:this},
                {header:"",width:50,sortable:true,dataIndex:'answernumber'},
                {header:"",width:50,sortable:true,dataIndex:'hot'},
                {header:"ʱ",width:130,sortable:true,dataIndex:'createdate'}
            ],
			autoExpandColumn:1,autoExpandMin:250,autoExpandMax:400,
            enableColumnMove:false,collapsible:true,animCollapse:false,loadMask:{msg:'ݼ...'},border:false,
            tbar:this.toolbar,
            bbar: new Ext.PagingToolbar({pageSize: 25,store:this.D,displayInfo: true,displayMsg: 'ǰʾ{0} - {1} ܼ¼{2}',emptyMsg: "ʱû",beforePageText:"",afterPageText:"ҳ {0}ҳ"})
        });
        
        this.questionMenu = new Ext.menu.Menu({items: this.menu});
		this.grid.on('rowclick', function(g,r,e){
			this.currentQid = g.getStore().getAt(r).id;
		},this);
		this.grid.on('rowcontextmenu',function(g,r,e){
			this.record=this.D.getAt(r);
			this.currentQid = g.getStore().getAt(r).id;
			var stm = g.getSelectionModel();
			stm.getSelections().indexOf(g.getStore().getAt(r))!=-1?stm.selectRow(r,true):stm.selectRow(r);
			this.questionMenu.showAt(e.getXY());
		},this);
		this.grid.on('activate', function(g,r,e){this.tabPanel.activatePanl='question';},this);
		this.tabPanel = new Ext.TabPanel({region:'center',border:false,style:'border:1px solid #99BBE8;border-width:0px 0px 0px 1px',activeTab:0,enableTabScroll:true,autoDestroy:false,items:this.grid});
		this.tabPanel.on('beforeremove',function(t,c){t.activate(0);t.hideTabStripItem(c);return false;},this);
		this.tree = new Ext.tree.TreePanel({title:'',cls:'channel-tree ask-tree',bodyStyle:'padding:8px 1px;border-bottom:1px solid #99BBE8;',collapsible:false,
			rootVisible:true,lines:true,useArrows:true,border:false,autoScroll:true,
		    loader:new Ext.tree.TreeLoader({dataUrl:this.baseAction+'&method=tree'}),root:new Ext.tree.AsyncTreeNode({id:'0',text:'',cls:'category-tree-root',expanded:true}),
		    tbar: this.treemenu
		});
		this.treeMenu = [
			new Ext.menu.Menu({items: [
				{text:'',iconCls:'ico preview',handler:this.browse,scope:this,mode:1},'-',
				{text:'½',iconCls:'btnico btn_add',menu:new Ext.menu.Menu({items:[
					{text:'½',handler:this.categoryEdit,scope:this,mode:0},
			   	 	{text:'½¼',handler:this.categoryEdit,scope:this,mode:2},'-',
					{text:'½',icon:ico,iconCls:'ico add_article',handler:this.QuestionEdit,scope:this,mode:0}
			  	]}),scope:this},
				{text:'޸',iconCls:'ico edit',handler:this.categoryEdit,scope:this,mode:3},
				{text:'ɾ',iconCls:'ico del',handler:this.categoryDel,scope:this,mode:1},'-',
				{text:'ˢ·ڵ',iconCls:'btnico btn_fresh',handler:this.refreshTree,scope:this}
			]}),
			new Ext.menu.Menu({items: [
				{text:'',iconCls:'btnico btn_preview',handler:this.browse,scope:this,mode:1},
				{text:'½',iconCls:'ico add_article',handler:this.QuestionEdit,scope:this,mode:0},
				{text:'ˢ·ڵ',iconCls:'btnico btn_fresh',handler:this.refreshTree,scope:this}
			]}),
			new Ext.menu.Menu({items: [
				{text:'',iconCls:'btnico btn_preview',handler:this.browse,scope:this,mode:1},'-',
				{text:'ˢ·ڵ',iconCls:'btnico btn_fresh',handler:this.refreshTree,scope:this}
			]}),
			new Ext.menu.Menu({items: [
				{text:'ˢ·ڵ',iconCls:'btnico btn_fresh',handler:this.refreshTree,scope:this}
			]})
		];
		this.tree.on('contextmenu',function(n,e){
			n.select();
			this.categoryNode = n;
			if(n.id == 0){
				this.treeMenu[3].showAt(e.getXY());return;
			}
			if (this.tabPanel.activatePanl == 'category') {
				this.treeMenu[0].showAt(e.getXY());
			}else if(this.tabPanel.activatePanl == 'question'){
				this.treeMenu[1].showAt(e.getXY());
			}else{
				this.treeMenu[2].showAt(e.getXY());
			}
			this.catepath = n.getPath();
		},this);
		this.tree.on('click',function(n,e){
        	this.D.baseParams.cid = n.id;
        	this.categoryNode = n;
			if(this.tabPanel.activatePanl == 'category'){
				try{
					if(n.id&&EXCMS.Ask.Category.D.baseParams.pid!=n.id){
						EXCMS.Ask.Category.D.baseParams.pid=n.id;
						EXCMS.Ask.Category.D.reload();
					}
				}catch(e){}
			}else if(this.tabPanel.activatePanl == 'question'){
				this.D.reload();
			}else{
				this.container.activate(this.grid);
				this.D.reload();
			}
			this.catepath = n.getPath();
        },this);    
		this.main = new Ext.Viewport({layout:'border',items:[{region:'west',border:false,style:'border:1px solid #99BBE8;border-width:0px 1px 0px 0px',
					title:'',split:true,width:200,minSize:35,maxSize:400,layout:'accordion',layoutConfig:{animate:true},
                    items: [this.tree,{title:'ʴ',contentEl:'ask-action',border:false}]},this.tabPanel]});
		this.D.setDefaultSort('createdate', 'DESC');
		var request={start:0,limit:25};
        this.D.load({params:request});
		this.grid.getEl().dom.oncontextmenu = function(){return false}
		this.grid.getEl().dom.onselectstart=function(){return false}
		this.tree.getEl().dom.oncontextmenu = function(){return false}
		this.tree.getEl().dom.onselectstart=function(){return false}
	},
	soOnTrigger1Click:function(){
		this.soField.reset();
		this.D.baseParams.key = '';
		this.D.reload();
	},
	soOnTrigger2Click:function(){
	    var key = this.soField.getValue().trim();
	    if(key != ''){
	        this.D.baseParams.key = key;
	        this.D.reload();
	    }
	},
	refreshTree : function(item){
		if(this.categoryNode.id == 0) {if(this.tree.root.loaded)this.tree.getLoader().load(this.tree.root);this.tree.root.expand();}
		else {if(this.categoryNode.loaded)this.tree.getLoader().load(this.categoryNode);this.categoryNode.expand();}
	},
	//ˢ·
	renderNode : function(nodeId){
		var newParentNode = this.tree.getNodeById(nodeId);
		if(newParentNode){
			if(newParentNode.loaded){
				this.tree.getLoader().load(newParentNode);
			}
			newParentNode.expand();
		}else{
			this.tree.expandPath(this.catepath);
		}
    },
	reload:function(){
		
	},
	categoryEdit:function(item){
		if(item.mode==2){
			item.pid = this.categoryNode.id;
			item.pname = this.categoryNode.text;
		}else if(item.mode==3){
			item.category = this.categoryNode.attributes;
			item.category.pid = this.categoryNode.parentNode.id;
			item.category.pname = this.categoryNode.parentNode.text;
		}
		try{EXCMS.Ask.Category.categoryEdit(item);}catch(e){}
	},
	categoryDel:function(item){
		item.categoryid=this.categoryNode.id;
		try{EXCMS.Ask.Category.categoryDel(item);}catch(e){}
	},
	//༭
	QuestionEdit : function(item){
	    var title = '';
	    if(item.mode == 0){
	        title = "½";
	    }else if(item.mode == 1){
	    	var record = this.grid.getSelectionModel().getSelected();
            if(!record){alert('ѡһ⣡');return;}
            title = record.get("title")
            title = title.length > 10 ? title.substring(0,10)+"..." : title;            
        }
	    if(!this.QuestionForm){
	    	this.Ask_category=new Ext.form.ComboBox({fieldLabel:'',store:new Ext.data.SimpleStore({fields:[],data:[[]]}),editable:false,
				mode:'local',triggerAction:'all',maxHeight:200,hidename:'AskCategory',name:'catename',width:300,
				tpl: "<tpl for='.'><div style='height:200px'><div id='AskCategory'></div></div></tpl>",
				selectedClass:'',onSelect:Ext.emptyFn,allowBlank:false,blankText:"",emptyText:'ѡ'
			});
	        this.Ask_category.tree = new Ext.tree.TreePanel({
	             border:false,
	             loader:new Ext.tree.TreeLoader({dataUrl:this.baseAction+'&method=tree'}),
	             root:new Ext.tree.AsyncTreeNode({id:'0',text:'',expanded:true})
              });
			this.Ask_category.tree.on('click',function(node){
				if(node.id=='0'){ return ;} 
				this.Ask_category.setValue(node.text);  
				this.askcid.setValue(node.id);
				this.Ask_category.collapse();
			},this);
            this.Ask_category.on('expand',function(){this.Ask_category.tree.render('AskCategory');}.createDelegate(this));
          	this.askcid = new Ext.form.Hidden({name:'cid'});
          	this.QuestionForm = new Ext.FormPanel({region:'center',autoScroll:false,title:title,border:false,baseCls:'x-plain',url:this.baseAction+'&method=questionCommit',closable:true,
                items:[
                	{xtype:'hidden',name:'qid'},this.askcid,
					{layout:'form',anchor:'100%',height:140,bodyStyle:'background:#DFE8F6;padding:10px 0 0 10px;',labelWidth:60,border:false,items:[
						this.Ask_category,
	                    {layout:'column',border:false,anchor:'98%',height:26,bodyStyle:'background:#DFE8F6;',items:[
							{xtype:'label',text:':',width:65,cls:'x-form-item',style:'line-height:22px'},
							{xtype:'textfield',width:400,name:'title',allowBlank:false,blankText:"ⲻΪ"},
	                        {xtype:'label',text :'뽫׶',cls:'x-form-item',style:'padding-left:10px;line-height:20px'}
	           			]},
	           			{fieldLabel:'ͷ',hiddenName:'score',xtype:'combo',width:140,editable:false,mode:'local',
							triggerAction:'all',selectOnFocus:true,value:0,
							store: [[0,'0'],[5,'5'],[10,'10'],[15,'15'],[20,'20'],[30,'30'],[50,'50'],[80,'80'],[100,'100']]
						},
	           			{fieldLabel:'趨',xtype:'checkbox',anchor:'98%',boxLabel:'Զ趨ҪƸֵ10',name:'anonymous',inputValue:1},
                        {fieldLabel:'̶',xtype:'checkbox',anchor:'98%',boxLabel:'ܵǰǷ,ҪƸֵ20',name:'urgent',inputValue:1}
					]},
           			{xtype:'htmleditor',name:'content',hideLabel:true,enableAlignments:false,anchor:'100% -90'}
            	],
               tbar:[
                   {text:'',handler:this.QuestionSave,scope:this},
                   {text:'',handler:function(){this.QuestionForm.form.reset();},scope:this},
                   {text:'ȡ',handler:function(){this.tabPanel.activate(0);this.tabPanel.hideTabStripItem(this.QuestionForm);},scope:this}
		        ]
            });
          
            this.QuestionForm.form.on('actioncomplete',function(form,action){
            	if(action.result.success){
            		alert(action.result.message);
            		this.tabPanel.activate(0);
            		this.tabPanel.hideTabStripItem(this.QuestionForm);
            		this.D.reload();
            	}
            }, this);
	    	this.tabPanel.add(this.QuestionForm);
	        this.tabPanel.activate(this.QuestionForm);
	    }else{
	    	this.tabPanel.unhideTabStripItem(this.QuestionForm);
			this.tabPanel.activate(this.QuestionForm);
	    }
        this.QuestionForm.setTitle(title);
         if(item.mode == 1){
         	this.loadQuestionData();
        }else this.QuestionForm.form.reset();	
	},
	//
	loadQuestionData : function(){
		 this.QuestionForm.el.mask('ݼ...');
		 Ext.Ajax.request({
            url: this.baseAction+'&method=getById',
            method: 'POST', 
            params:{id:this.currentQid},
            failure:function(response,options){
            	this.QuestionForm.el.unmask();
                alert("ʧ");
            },  
            success:function(response,options){
                 var r=jsonReturn(response);
                 this.QuestionForm.el.unmask();
                 this.QuestionForm.form.setValues(r);
                 this.askcid.setValue(r.cid);
            },scope:this                                    
        });
	},
	//
	QuestionSave : function(){
		if(!this.QuestionForm.form.isValid()){Ext.MessageBox.show({title:'',msg:"ߴĴ",buttons:Ext.MessageBox.OK,icon:'ext-mb-error'});return ;}
	    this.QuestionForm.form.submit();
	},
	//ɾ
	QuestionDel : function(){
        var selected = this.grid.getSelectionModel().getSelections();
        if(selected.length > 0){
            var Data = [];
            for (var i = 0, len = selected.length; i < len; i++) {Data.push(selected[i].id);}
	   		Ext.MessageBox.confirm('ʾ','ȷʵҪɾѡļ¼', function(optional){
	               if(optional=='yes'){
	                   Ext.Ajax.request({
	                        url: this.baseAction+"&method=delete",
	                        method: 'POST', 
	                        params:{ids:Data.join(",")},
	                        failure:function(response,options){
	                            ReturnValue = Ext.MessageBox.alert("","쳣ϵԱ");
	                        },  
	                        success:function(response,options){
	                            var r=jsonReturn(response);
	                            if(r.success){
	                              	for(var i=0;i<Data.length;i++){
	                              		this.D.remove(this.D.getById(Data[i]));
	                              	}
	                              	this.D.commitChanges();
	                            }
	                        }.createDelegate(this)                                    
	                   });
	               }
	               else return
	           }.createDelegate(this));
         }else Ext.MessageBox.alert('ʾ','ѡһ¼');
	},
	//
	setChecked : function(item){
		this.setting('checked',item.mode);
	},
	//״̬
	setStatus : function(item){
		this.setting('status',item.mode);
	},
	//̶
	setUrgent : function(item){
		this.setting('urgent',item.mode);
	},
	//þ
	setElite : function(item){
		this.setting('elite',item.mode);
	},
	//״̬ʾ
	displayChecked : function(item){
		this.checked = item.mode;
		this.display();
	},
	//״̬ʾ
	displayStatus : function(item){
		this.status = item.mode;
		this.display();
	},
	//ʾ
	displayUrgent : function(item){
		this.urgent = item.mode
		this.display();
	},
	//ʾ
	displayElite  : function(item){
		this.elite = item.mode;
		this.display();
	},
	//ʾʽ
	display : function(){
		this.D.baseParams = {checked:this.checked,status:this.status,urgent:this.urgent,elite:this.elite};
		if(this.categoryNode){
			this.D.baseParams.cid = this.categoryNode.id;
		}
		this.D.reload();
	},
	//
	setting : function(action,value){
		var data = [];
		var selected = this.grid.getSelectionModel().getSelections();
		if(selected.length > 0){
	        for (var i = 0, len = selected.length; i < len; i++) {data.push(selected[i].id);}
		}else{
			alert("ѡһ¼");
			return false;
		}
		Ext.Ajax.request({
            url: this.baseAction+'&method=' + action,
            method: 'POST', 
            params:{qids:data.join(','),value:value},
            failure:function(response,options){
               	alert("","쳣ϵԱ");
            },  
            success:function(response,options){
                var r=jsonReturn(response);
                if(r.success){
           			alert(r.message);
					for(var i=0; i<data.length; i++){
						this.D.getById(data[i]).set(action,value);
					}
					this.D.commitChanges();
                }
            },scope:this         
        },this);
	},
	
	//
	browse : function(item){
		//
		if(item.mode==1){
			if(this.categoryNode){
				EXCMS.util.RequestUrl(this.ask_config.list,{cid:this.categoryNode.id});
			}else{
				alert("ѡ");
			}
		}else{	//
			if(this.currentQid){
				EXCMS.util.RequestUrl(this.ask_config.question,{id:this.currentQid});
			}else{
				alert("ѡһ¼");
			}
		}
	},
	//ʾشб
	viewanswer : function(){
		var title;
		if(this.grid.getSelectionModel().getSelected()){
			title = this.grid.getSelectionModel().getSelected().get("title");
			title = title.length > 10 ? title.substring(0,10)+"..." : title;
		}else{
			title ='ȫشб';
		}
		EXCMS.util.script('../ask/admin/Answer.js',{object:'EXCMS.Ask.Answer',container:this.tabPanel,qid:this.currentQid,title:title});
	},
	active : function(o){
		this.type = o;
		switch(o){
			//ʾб
			case 'category' :
				EXCMS.util.script('../ask/admin/Category.js',{object:'EXCMS.Ask.Category',container:this.tabPanel,'pid':this.categoryNode&&this.categoryNode.id?this.categoryNode.id:0});
				this.main.items.items[0].items.items[0].expand();
				break;
			//ʾб
			case 'question' :
				this.tabPanel.activate(this.grid);
				this.main.items.items[0].items.items[0].expand();
				break;
			//ʾشб
			case 'answer' :
				EXCMS.util.script('../ask/admin/Answer.js',{object:'EXCMS.Ask.Answer',container:this.tabPanel,title:'б'});
				break;
			//ʾͷ
			case 'actor' :
				EXCMS.util.script('../ask/admin/Actor.js',{object:'EXCMS.Ask.Actor',container:this.tabPanel});
				break;
			//ʾ
			case 'scorerank' :
				EXCMS.util.script('../ask/admin/ScoreRank.js',{object:'EXCMS.Ask.ScoreRank',container:this.tabPanel});
				break;
			//ʾûϸ
			case 'score' :
				EXCMS.util.script('../ask/admin/Score.js',{object:'EXCMS.Ask.Score',container:this.tabPanel});
				break;
			//ù
			case 'config' :
				EXCMS.util.script('../ask/admin/Config.js',{object:'EXCMS.Ask.Config',container:this.tabPanel});
				break;
		}
	},
	renderStatus : function(v){var r=['','','','ѽ','ѹ','ͶƱ','ر'];return r[v]},
	renderNewAnswer : function(v){return v ? "<span style='color:green;'></span>":''},
	formateScore : function(v){return v == 1 ? "<span style='color:green;'></span>" : ''},
	renderChecked:function(v){var r=['<span class="ccheck_u" title="δ"></span>','<span class="ccheck_n" title="δͨ"></span>','<span class="ccheck" title=""></span>'];return r[v>(r.length-1)?0:(v<0?0:v)]}

};
EXCMS.onReady(EXCMS.Ask.init,EXCMS.Ask);