<?php
/**
 * Project:		EXCMS: the PHP content management system.
 * File:		Actor.class.php
 *
 * A product of PUTOYO Inc.
 * 
 * EXCMS is a ten million data-level,high speed,human-based content management system.
 *
 * EX is Excellence & Express & Exceed & Expert.
 * 
 * For questions, help, comments, discussion, please join the
 * EXCMS mailing list. Send a blank e-mail to
 * join@excms.cn
 * or join the EXCMS forum
 * www.excms.cn/forum
 * 
 * @link http://www.excms.cn/
 * @copyright Copyright (c) 2010 PUTOYO Inc.
 * @license http://www.excms.cn/licenses/LICENSE-1.0
 * @category EXCMS
 * @package ask
 * @author $Author: zhangxuelin $
 * @version $Rev: 2201 $
 */
/* $Id: Actor.class.php 2201 2010-08-11 15:09:16Z zhangxuelin $ */
/**
 * EXCMS ʰͷ
 * @category EXCMS
 * @package ask
 * @author $Author: zhangxuelin $
 */
class Actor
{
	/**
     * ͷݿ
     *
     * @access private
     * @var string
     */
    private $table = 'ask_actor';
    /**
     * 캯
     *
     */
    function __construct ()
    {
        $this->table = TABLE_PREFIX . $this->table;
    }
    /**
     * PHP4캯
     *
     */
    function Actor ()
    {
        $this->__construct();
    }
    /**
	 * IDȡͷ
	 *
	 * @param integer $id	ͷID
	 * @return array	ͷϸϢ
	 */
	public function getById($id){
		 if (! ($id >= 0)) {
            throw_exception('ASK_ACTOR_LACK_ID');
        }
        $sql = "SELECT * FROM `{$this->table}` WHERE `id` = '{$id}' LIMIT 1";
                $GLOBALS['db']->query($sql);
        return $GLOBALS['db']->fetch();
	}
    /**
     * ½ͷ 
     *
     * @param array $data	ͷ
     * <ul>
     * <li>string $data['name'] ͷ </li>
     * <li>integer $data['catename']  </li>
     * <li>string $data['grade'] ȼ</li>
     * <li>integer $data['min'] С </li>
     * <li>integer $data['max'] </li>
     * </ul>
     * 
     * @return integer ͷ ID
     */
    function insert ($data)
    {
        if(trim($data['name'])==''){
        	throw_exception('ASK_ACTOR_LACK_NAME');
        }
        if($data['catename'] == ''){
        	throw_exception('ASK_ACTOR_LACK_CATENAME');
        }
       if(trim($data['grade'])==''){
        	throw_exception('ASK_ACTOR_LACK_GRADE');
        }
        $data = array(
        	'catename' => $data['catename'],
        	'grade' => $data['grade'],
        	'name' => $data['name'],
        	'min' => $data['min'],
        	'max' => $data['max']
        );
        $sql = "INSERT INTO `{$this->table}` (`" . implode("`, `", array_keys($data)) . "`) VALUES('" . implode("', '", array_values($data)) . "')";
                $GLOBALS['db']->query($sql);
        return $GLOBALS['db']->insert_id();
    }
    /**
     * ָIDͷ
     *
     * @param integer $id 	ͷID
     * @param array $data	ͷ
     * <ul>
     * <li>string $data['name'] ͷ </li>
     * <li>integer $data['catename']  </li>
     * <li>string $data['grade'] ȼ</li>
     * <li>integer $data['min'] С </li>
     * <li>integer $data['max'] </li>
     * </ul>
     * 
     * @return boolean
     */
    function update ($id, $data)
    {
        if (! ($id > 0)) {
            throw_exception('ASK_ACTOR_LACK_ID');
        }
        if(trim($data['name'])==''){
        	throw_exception('ASK_ACTOR_LACK_NAME');
        }
        if($data['catename']==''){
        	throw_exception('ASK_ACTOR_LACK_CATENAME');
        }
       if(trim($data['grade'])==''){
        	throw_exception('ASK_ACTOR_LACK_GRADE');
        }
        $data = array(
        	'name' => $data['name'],
        	'catename' => $data['catename'],
        	'grade' => $data['grade'],
        	'min' => $data['min'],
        	'max' => $data['max']
        );
        $set = array();
        foreach ($data as $k => $v) {
            $set[] = "`{$k}` = '{$v}'";
        }
        $set = implode(", ", $set);
                $sql = "UPDATE `{$this->table}` SET {$set} WHERE `id` = '{$id}' LIMIT 1";
        return $GLOBALS['db']->query($sql);
    }
	/**
     * ɾָIDͷ
     *
     * @param string|integer|array $id ͷID
     * 
     * @return boolean
     */
    public function delete ($id)
    {
        $id = EXCMS::convertToIntArray($id);
        if ($id === false) {
            throw_exception('ASK_ACTOR_LACK_ID');
        }
        $num = count($id);
        $where = $num > 1 ? "`id` IN ('" . implode("', '", $id) . "') LIMIT {$num}" : "`id` = '" . $id[0] . "'";
        $sql = "DELETE FROM `{$this->table}` WHERE {$where}";
                return $GLOBALS['db']->query($sql);
    }
    /**
     * ȡ
     *
     * @return array
     */
    public function  getCategory(){
    	$sql = "SELECT DISTINCT `catename` FROM `{$this->table}` ";
            $GLOBALS['db']->query($sql);
        return $GLOBALS['db']->fetchAll();
    }
    /**
     * ݻֻȡͷ
     *
     * @param integer $score	
     * @return array
     */
    public function getActorByScore($score){
    	$score = (int)$score;
        	$sql = "SELECT * FROM `{$this->table}` WHERE `min` <= '{$score}' AND (`max` >= '{$score}' OR `max` = 0) LIMIT 1";
    	$GLOBALS['db']->query($sql);
    	$actor_array = $GLOBALS['db']->fetch();
    	if(is_array($actor_array) && count($actor_array) > 0){
    		return $actor_array;
    	}
    	$sql = "SELECT * FROM `{$this->table}` ORDER BY min LIMIT 1";
    	$GLOBALS['db']->query($sql);
    	return $GLOBALS['db']->fetch();
    }
   /**
     * ȡͷηҳб
     *
     * @param array $paging ҳ
     * <ul>
     * <li>integer $paging['limit'] ҳС default 0</li>
     * <li>integer $paging['start'] ҳʼС default 0</li>
     * <li>integer $paging['total']  default 0</li>
     * <li>integer $paging['sort'] ֶ</li>
     * <li>integer $paging['dir'] ʽ ASC or DESC, </li>
     * <li>integer $paging['catename'] ɫID </li>
     * </ul>
     * @return array Paging 
     * <ul> 
     * <li> $array['total']  </li>
     * <li> $array['data'] ҳ </li>
     * </ul>
     */
  	public function getPaging ($paging = array())
	{
        if($paging['catename']!=''){
        	$where .= " and `catename`='{$paging['catename']}' ";
        }
                if (! isset($paging['total'])) {
            $sql = "SELECT COUNT(*) as `total` FROM `{$this->table}` WHERE 1 {$where}";
            $GLOBALS['db']->query($sql);
            $rs = $GLOBALS['db']->fetch();
            $total = $rs['total'];
        } else {
            $total = (int) $paging['total'];
        }
        if (empty($paging['sort'])) {
            $sort = "`id` ASC";
        } else {
            $dir = strtoupper($paging['dir']) == "DESC" ? "DESC" : "ASC";
            $sort = "`" . $paging['sort'] . "` {$dir}";
        }
        $orderby = "ORDER BY {$sort}";
        $start = (int) $paging['start'];
        $limit = $paging['limit'] > 0 ? ($paging['limit'] > 100 ? 100 : $paging['limit']) : 25;
        $limit = "LIMIT {$start}, {$limit}";
        $sql = "SELECT * FROM `{$this->table}` WHERE 1 {$where} {$orderby} {$limit}";
        $GLOBALS['db']->query($sql);
        $rs = $GLOBALS['db']->fetchAll();
        return array('total' => $total , 'data' => $rs);
    }
}

// excms file end