<?php
/**
 * Project:		EXCMS: the PHP content management system.
 * File:		Answer.class.php
 *
 * A product of PUTOYO Inc.
 *  
 * EXCMS is a tens of millions of data-level and human-base content management system.
 * 
 * For ANSWER, help, comments, discussion, etc., please join the
 * EXCMS mailing list. Send a blank e-mail to
 * join@excms.cn
 * 
 * @link http://www.excms.cn/
 * @copyright Copyright (c) 2010 PUTOYO Inc.
 * @license http://www.excms.cn/licenses/LICENSE-1.0
 * @category EXCMS
 * @package ask
 * @author $Author: zhangxuelin $
 * @version $Rev: 2154 $
 */
/* $Id: Answer.class.php 2154 2010-08-10 09:24:54Z zhangxuelin $ */
/**
 * EXCMS ش
 * @category EXCMS
 * @package ask
 * @author $Author: zhangxuelin $
 */
class Answer
{
	/**
     * شݱ
     *
     * @access private
     * @var string
     */
    private $table = 'ask_answers';
    /**
     * 캯
     *
     */
    function __construct ()
    {
        $this->table = TABLE_PREFIX . $this->table;
    }
    /**
     * PHP4캯
     *
     */
    function Answer ()
    {
        $this->__construct();
    }
    /**
	 * IDȡش
	 *
	 * @param integer $aid	شID
	 * @return array	شϸϢ
	 */
	public function getById($aid){
		if (! ($aid > 0)) {
            throw_exception('ASK_ANSWER_LACK_ID');
        }
        $sql = "SELECT * FROM `{$this->table}` WHERE `aid` = '{$aid}' LIMIT 1";
                $GLOBALS['db']->query($sql);
        return $GLOBALS['db']->fetch();
	}
    /**
     * ӻش 
     *
     * @param array $data ش
     * <ul>
     * <li>integer $data['qid'] شID</li>
     * <li>integer $data['cid'] ID</li>
     * <li>integer $data['ip'] IPַ</li>
     * <li>integer $data['anonymous'] ǷΪ(ĬΪ) </li>
     * <li>integer $data['content'] </li>
     * </ul>
     * 
     * @return integer ش aid
     */
    public function insert ($data)
    {
    	if((int)$data['qid']<1){
    		throw_exception('ASK_QUESTIONS_LACK_ID');
    	}
    	if((int)$data['cid']<1){
    		throw_exception('ASK_CATEGORY_LACK_ID');
    	}
        if(trim($data['content'])==''){
        	throw_exception('ASK_ANSWER_LACK_CONTENT');
        }
        global $EXCMS;
        $data = array(
        	'qid' => $data['qid'],
        	'cid' => $data['cid'],
        	'checked' => $EXCMS_MODULE['ask']['answer_check'] ==1 ? 0 : 2,
        	'ishidden' => 0,
        	'isbest' => 0,
        	'content' => trim($data['content']),
        	'anonymous' => $data['anonymous'] ? 1 : 0,
        	'vote' => 0,
        	'votecount' => 0,
        	'uid' => $data['uid'],
        	'ip' => $data['ip'],
            'createdate' => time(),
        	'modifieddate' => time()
        );
        $sql = "INSERT INTO `{$this->table}` (`" . implode("`, `", array_keys($data)) . "`) VALUES('" . implode("', '", array_values($data)) . "')";
                $GLOBALS['db']->query($sql);
       
        include_once ASK_LIB_PATH . 'AskQuestion.class.php';
        $question = new AskQuestion();
		$question->updateAnswerNumber($data['qid']);		 			//ش
		$question->updateSolve(EXCMS_SESSION_UID,$data['qid'],true);	//Ƿ
		
		include_once ASK_LIB_PATH.'AskAccount.class.php';
		$account = new AskAccount();
		$account->updateAnswer($data['uid']);			//ûش
		
		include_once ASK_LIB_PATH.'AskScore.class.php';
		$score = new AskScore();
		$score->scoreAnswer(EXCMS_SESSION_UID);			//ش÷
		
		unset($question,$account,$score,$data);
		return true;
    }
    /**
     * ָIDش
     *
     * @param integer $aid 	شID
     * @param array $data	ش
     * <ul>
     * <li>integer $data['ip'] IPַ</li>
     * <li>integer $data['content'] </li>
     * </ul>
     * 
     * @return boolean
     */
    function update ($aid, $data)
    {
        if (! ($aid > 0)) {
            throw_exception('ASK_ANSWER_LACK_ID');
        }
        if(trim($data['content'])==''){
        	throw_exception('ASK_ANSWER_LACK_CONTENT');
        }
        $data = array(
        	'ip'=> $data['ip'],
        	'modifieddate' => time(),
            'content' => trim($data['content'])
        );      
        $set = array();
        foreach ($data as $k => $v) {
            $set[] = "`{$k}` = '{$v}'";
        }
        $set = implode(", ", $set);
                $sql = "UPDATE `{$this->table}` SET {$set} WHERE `aid` = '{$aid}' LIMIT 1";
        return $GLOBALS['db']->query($sql);
    }
    /**
     * IDɾشб
     *
     * @param integer $qid	ID
     * @return boolean
     */
    public function deleteByQid($qid){
    	$qid = EXCMS::convertToIntArray($qid);
        if ($qid === false) {
            throw_exception('ASK_QUESTIONS_LACK_ID');
        }
                $num = count($qid);
        $where = $num > 1 ? "`qid` IN ('" . implode("', '", $qid) . "') LIMIT {$num}" : "`qid` = '" . $qid[0] . "'";
        $sql = "SELECT `uid` FROM {$this->table} WHERE {$where}";
        $GLOBALS['db']->query($sql);
        $answer_array = $GLOBALS['db']->fetchAll();
        $sql = "DELETE FROM {$this->table} WHERE {$where}";
        $success = $GLOBALS['db']->query($sql);
        if($success && count($answer_array) > 0){
        	include_once ASK_LIB_PATH.'AskAccount.class.php';
			$account = new AskAccount();
        	foreach ($answer_array as $value){
        		if($value['uid'] > 0)	$account->updateAnswer($value['uid'],-1);		//ٻش
        	}
	        unset($account,$answer_array);
        }
        return $success;
    }
	/**
     * ɾָIDش
     *
     * @param string|integer|array $aid شID
     * 
     * @return boolean
     */
    public function delete ($aid)
    {
        $aid = EXCMS::convertToIntArray($aid);
        if ($aid === false) {
            throw_exception('ASK_ANSWER_LACK_ID');
        }
                $num = count($aid);
        $where = $num > 1 ? "`aid` IN ('" . implode("', '", $aid) . "') LIMIT {$num}" : "`aid` = '" . $aid[0] . "'";
        $sql = "SELECT `qid`,`uid`,`isbest` FROM {$this->table} WHERE {$where}";
        $GLOBALS['db']->query($sql);
        $answer_array = $GLOBALS['db']->fetchAll();
        $sql = "DELETE FROM `{$this->table}` WHERE {$where}";
        $success = $GLOBALS['db']->query($sql);
        $success = true;
        if($success && is_array($answer_array) && count($answer_array) > 0){
        	include_once ASK_LIB_PATH . 'AskQuestion.class.php';
			$question = new AskQuestion();
			
			include_once ASK_LIB_PATH.'AskScore.class.php';
			$score = new AskScore();
			
			include_once ASK_LIB_PATH.'AskAccount.class.php';
			$account = new AskAccount();
	        foreach ($answer_array as $value){
				$question->updateAnswerNumber($value['qid'],false);						//ٻش
				$value['isbest'] = 1;
				//»
		        if($value['uid'] > 0){
		        	if($value['isbest']){												//Ѵ𰸱ɾ شߺ߿۷
		        		$question_array = $question->getById($value['qid']);	
		        		if($question_array['uid'] > 0)	$score->scoreDeleteBestAnswer($question_array['uid']);				
		        		$score->scoreDeleteBestAnswer($value['uid']);	
		        		$account->updateAnswerBest($value['uid'],-1);					
		        	}else{
		        		$score->scoreDeleteAnswer($value['uid']);							//شɾ  ش߼10
						$account->updateAnswer($value['uid'],-1);							//شһ
		        	}
				}
	        }
	        unset($question,$score,$account,$answer_array);
        }
        return $success;
    }
    /**
	 * ش
	 *
	 * @param integer $aid
	 * @param boolean $anonymous
	 * @return boolean
	 */
	public function updateAnonymous($aid,$anonymous=true){
		$answer_array = $this->getById($aid);
		$anonymous = $anonymous ? 1 : 0;
		$sql = "UPDATE `{$this->table}` SET `anonymous` = '{$anonymous}' WHERE `aid` = '{$aid}'";
		return $GLOBALS['db']->query($sql);
	}
    /**
     * ״̬
     *
     * @param integer $aid	شID
     * @param integer $checked	Ƿ0:δ 1:δͨ 2:ͨ
     * 
     * @return boolean
     */
    public function updateStatus($aid,$checked){
    	$aid = EXCMS::convertToIntArray($aid);
        if ($aid === false) {
            throw_exception('ASK_ANSWER_LACK_ID');
        }
        $num = count($aid);
        $where = $num > 1 ? "`aid` IN ('" . implode("', '", $aid) . "') LIMIT {$num}" : "`aid` = '" . $aid[0] . "'";
        $sql = "SELECT `uid`,`checked` FROM {$this->table} WHERE {$where}";
            	$GLOBALS['db']->query($sql);
    	$answer_array = $GLOBALS['db']->fetchAll();
    	if(is_array($answer_array) && count($answer_array) > 0){
    		include_once ASK_LIB_PATH.'AskScore.class.php';
			$score = new AskScore();
    		foreach ($answer_array as $value){
    			if($checked == $value['checked'] || $value['checked']==2) continue;
    			if($value['uid'] > 0){
    				if($value['checked']==0 && $checked == 1){											//δͨ
    					$score->scoreCheckAnswer($value['uid'],false);								
    				}else if($value['checked']==1 && $checked == 2){									//ͨ˷20
    					$score->scoreCheckAnswer($value['uid'],true);
    				}
				}
    		}
    	}
        $sql = "UPDATE `{$this->table}` SET `checked` = '{$checked}' WHERE {$where}";
        return $GLOBALS['db']->query($sql);
    }
    /**
     * 
     *
     * @param integer $aid	شID
     * @return boolean
     */
    public function updateEvaluated($aid){
    	if (! ($aid > 0)) {
            throw_exception('ASK_ANSWER_LACK_ID');
        }
    	$sql = "UPDATE `{$this->table}` SET `evaluated` = evaluated+1 WHERE `aid`='{$aid}'";
                return $GLOBALS['db']->query($sql);
    }
    /**
     * ׷Ϣ
     * @param int $aid
     * @param bool $append 
     * @return bool
     */
    public function append($aid,$append=true){
    	if (! ($aid > 0)) {
            throw_exception('ASK_ANSWER_LACK_ID');
        }
        $append = $append ? 1 : 0;
    	$sql = "UPDATE `{$this->table}` SET `append` = {$append} WHERE `aid`='{$aid}'";
                return $GLOBALS['db']->query($sql);
    }
    /**
     * ػش 01   
     *
     * @param integer $aid	شID
     * @param integer $status	״̬
     * 
     * @return boolean
     */
    public function updateHidden($aid,$ishidden){
    	$aid = EXCMS::convertToIntArray($aid);
        if ($aid === false) {
            throw_exception('ASK_ANSWER_LACK_ID');
        }
        $ishidden = $ishidden ? 1 : 0;
        $num = count($aid);
        $where = $num > 1 ? "`aid` IN ('" . implode("', '", $aid) . "') LIMIT {$num}" : "`aid` = '" . $aid[0] . "'";
        $sql = "UPDATE `{$this->table}` SET `ishidden` = '{$ishidden}' WHERE {$where}";
                return $GLOBALS['db']->query($sql);
    }
    /**
     * ²ɻش 01Ϊ
     *
     * @param integer $aid	شID
     * @param integer $isbast 01Ϊ
     * 
     * @return boolean
     */
    public function updateIsbast($aid,$isbast=true){
        $isbast = $isbast ? 1 : 0;
        $num = count($aid);
        $answer_array = $this->getById($aid);
        if($answer_array['isbest']) return true;
        $sql = "UPDATE `{$this->table}` SET `isbest` = '{$isbast}' WHERE `aid` = '{$aid}'";
                $success = $GLOBALS['db']->query($sql);
        if($success){
        	include_once ASK_LIB_PATH . 'AskQuestion.class.php';			//,AskQuestion
			$question = new AskQuestion();
			$question_array = $question -> getById($answer_array['qid']);
			
			include_once ASK_LIB_PATH.'AskScore.class.php';
			$score = new AskScore();
			if($question_array['uid'] > 0 && $question_array['status'] == 4){								//ɴ𰸻10ֻ
				$score->scoreExpiredDeal($question_array['uid']);
			}
			//ѽ
			$question->updateStatus($answer_array['qid'],3);
			
			$question->updateSolveddate($answer_array['qid'],0,time());	//½ʱ
			
			if($answer_array['uid'] > 0){
				$score->scoreAnswerAdopt($answer_array['uid'],$question_array['score']);					//ӻشߵ÷
				include_once ASK_LIB_PATH.'AskAccount.class.php';
				$account = new AskAccount();
				$account->updateAnswerBest($answer_array['uid']);											//»ش߻ش
			}
			if($question_array['uid'] > 0 && $question_array['score'] > 0){
				$score->scoreCentQuestion($question_array['uid'],$question_array['score']);					//͸
			}
			
			unset($question,$question_array,$score,$account);
        }
        return $success;
    }
    /**
     * »شǷתͶƱ
     *
     * @param integer $aid	شID
     * @param boolean $vote	ǷͶƱ
     * @return boolean
     */
    public function updateVote($aid,$vote = true){
    	$aid = EXCMS::convertToIntArray($aid);
        if ($aid === false) {
            throw_exception('ASK_ANSWER_LACK_ID');
        }
        $num = count($aid);
        $where = $num > 1 ? "`aid` IN ('" . implode("', '", $aid) . "') LIMIT {$num}" : "`aid` = '" . $aid[0] . "'";
        $vote = $vote ? 1 : 0;
        $sql = "UPDATE `{$this->table}` SET `vote` = '{$vote}' WHERE {$where}";
                return $GLOBALS['db']->query($sql);
    }
    /**
     * IDͶƱ
     *
     * @param integer $qid
     * @param boolean $vote
     * @return boolean
     */
    public function updateVoteByQid($qid,$vote = true){
        if (!($qid > 0)) {
            throw_exception('ASK_QUESTIONS_LACK_ID');
        }
        $vote = $vote ? 1 : 0;
        $sql = "UPDATE `{$this->table}` SET `vote` = '{$vote}' WHERE `qid` = '{$qid}' ";
                return $GLOBALS['db']->query($sql);
    }
    /**
     * ͶƱ
     *
     * @param integer $aid	شID
     * 
     * @return boolean
     */
    public function updateVotecount($aid){
    	$aid = EXCMS::convertToIntArray($aid);
        if ($aid === false) {
            throw_exception('ASK_ANSWER_LACK_ID');
        }
        $num = count($aid);
        $where = $num > 1 ? "`aid` IN ('" . implode("', '", $aid) . "') LIMIT {$num}" : "`aid` = '" . $aid[0] . "'";
        $sql = "UPDATE `{$this->table}` SET `votecount` = votecount+1 WHERE {$where}";
                return $GLOBALS['db']->query($sql);
    }
    /**
     * IDûIDȡشID
     *
     * @param integer $qid	ID
     * @param integer $uid	ûID
     * @return integer
     */
    public function isAnswerByQid($qid,$uid){
    	if (! ($qid > 0)) {
            throw_exception('ASK_QUESTIONS_LACK_ID');
        }
                $sql = "SELECT `aid` FROM `{$this->table}`   WHERE `qid` = '{$qid}' AND `uid`='{$uid}' LIMIT 1";
        $GLOBALS['db']->query($sql);
        $answer_array = $GLOBALS['db']->fetch();
        return $answer_array['aid'];
    }
    /**
     * IDȡһ
     *
     * @param integer $qid
     * @return array
     */
    public function getAnswerByQid($qid){
    	if (! ($qid > 0)) {
            throw_exception('ASK_QUESTIONS_LACK_ID');
        }
        $sql = "SELECT * FROM `{$this->table}`   WHERE `qid` = '{$qid}'  LIMIT 1";
                $GLOBALS['db']->query($sql);
        return $GLOBALS['db']->fetch();
    }
    /**
     * ȡѴб
     *
     * @param integer $qid	ID
     * 
     * @return array
     */
    public function getBestAnswer($qid){
		if (! ($qid > 0)) {
            throw_exception('ASK_QUESTIONS_LACK_ID');
        }
        $sql = "SELECT * FROM `{$this->table}`   WHERE `qid` = '{$qid}' AND `isbest` = 1";
                $GLOBALS['db']->query($sql);
        return $GLOBALS['db']->fetchAll();
    }
    /**
     * ͳƻش30Ļش
     *
     * @param integer $qid	ID
     * @param integer $number	ַ
     * @return boolean
     */
    public function statAnswerContentNumber($qid,$number=30){
    	if (! ($qid > 0)) {
            throw_exception('ASK_QUESTIONS_LACK_ID');
        }
        $sql = "SELECT COUNT(*) AS total FROM (SELECT LENGTH(`content`) AS number  FROM {$this->table} WHERE `qid`= '{$qid}') AS tmp WHERE number > '{$number}'";
                $GLOBALS['db']->query($sql);
        $answer_array = $GLOBALS['db']->fetch();
        return $answer_array['total'] > 0 ? true :false;
    }
   /**
     * ȡشбҳ
     *
     * @param array $paging ҳ
     * <ul>
     * <li>integer $paging['limit'] ҳС default 0</li>
     * <li>integer $paging['start'] ҳʼС default 0</li>
     * <li>integer $paging['total']  default 0</li>
     * <li>integer $paging['sort'] ֶ</li>
     * <li>integer $paging['dir'] ʽ ASC or DESC, </li>
     * <li>integer $paging['keywords'] ؼ</li>
     * <li>integer $paging['cid'] ID</li>
     * <li>integer $paging['qid'] ID</li>
     * <li>integer $paging['checked'] ״̬,0:δ 1:δͨ 2:ͨ</li>
     * </ul>
     * @return array Paging 
     * <ul> 
     * <li> $array['total']  </li>
     * <li> $array['data'] ҳ </li>
     * </ul>
     */
   function getPaging ($paging = array())
    {
        $keywords = trim($paging['keywords']);
        if (! empty($keywords)) {
            $where = " and `content` like '%{$keywords}%' ";
        }
        if($paging['cid']>0){
        	$where .= " and `cid`='{$paging['cid']}' ";
        }
        if($paging['qid']>0){
        	$where .=" and qid={$paging['qid']} ";
        }
        if($paging['checked']!=''){
        	$where .= " and `checked`='{$paging['checked']}' ";
        }
                if (! isset($paging['total'])) {
            $sql = "SELECT COUNT(*) as `total` FROM `{$this->table}` WHERE 1 {$where}";
            $GLOBALS['db']->query($sql);
            $rs = $GLOBALS['db']->fetch();
            $total = $rs['total'];
        } else {
            $total = (int) $paging['total'];
        }
        if($total <= 0){
        	return array('total' => $total , 'data' => array());
        }
        if(!in_array($paging['sort'],array('createdate','votecount','checked'))) $paging['sort'] = 'createdate';
       
        $dir = strtoupper($paging['dir']) == "DESC" ? "DESC" : "ASC";
        $sort = "`" . $paging['sort'] . "` {$dir}";
        
        $orderby = "ORDER BY {$sort}";
        $start = (int) $paging['start'];
        $limit = $paging['limit'] > 0 ? ($paging['limit'] > 100 ? 100 : $paging['limit']) : 25;
        $limit = "LIMIT {$start}, {$limit}";
        $sql = "SELECT * FROM `{$this->table}` WHERE 1 {$where} {$orderby} {$limit}";
        $GLOBALS['db']->query($sql);
        $rs = $GLOBALS['db']->fetchAll();
        if(is_array($rs) && count($rs)>0 ){
        	include_once ASK_LIB_PATH . 'AskCategory.class.php';
        	$cate = new AskCategory();
        	include_once ASK_LIB_PATH . 'AskQuestion.class.php';
        	$question = new AskQuestion();
        	include_once LIB_MODULES_PATH . 'account/Account.class.php';
        	$account = new Account();
        	foreach ($rs as $key=>$value){
        		$cate_array =  $cate->getById($value['cid']);
        		$rs[$key]['catename'] =$cate_array['name'];
        		$question_array = $question->getById($value['qid']);
        		$rs[$key]['title'] = $question_array['title'];
        		if($value['uid'] > 0){
        			$account_array = $account->getById($value['uid']);
        			$rs[$key]['username'] = $account_array['username'];
        		}
        		$rs[$key]['createdate'] = formatDate("Y-m-d H:i:s",$rs[$key]['createdate']);
        		$rs[$key]['modifieddate'] = formatDate("Y-m-d H:i:s",$rs[$key]['modifieddate']);
        	}
        	unset($cate,$user,$cate_array,$user_array,$question,$question_array);
        }
        return array('total' => $total , 'data' => $rs);
    }
}

?>
