<?php
/**
 * Project:		EXCMS: the PHP content management system.
 * File:		AskAccount.class.php
 *
 * A product of PUTOYO Inc.
 * 
 * EXCMS is a ten million data-level,high speed,human-based content management system.
 *
 * EX is Excellence & Express & Exceed & Expert.
 * 
 * For questions, help, comments, discussion, please join the
 * EXCMS mailing list. Send a blank e-mail to
 * join@excms.cn
 * or join the EXCMS forum
 * www.excms.cn/forum
 * 
 * @link http://www.excms.cn/
 * @copyright Copyright (c) 2010 PUTOYO Inc.
 * @license http://www.excms.cn/licenses/LICENSE-1.0
 * @category EXCMS
 * @package Hit
 * @author $Author: hukuizhi $
 * @version $Rev: 1700 $
 */
/* $Id: AskAccount.class.php 1700 2010-06-08 02:44:30Z hukuizhi $ */
/**
 * EXCMS ûʴͳ
 * @category EXCMS
 * @package AskAccount
 * @author $Author: hukuizhi $
 */
class AskAccount{
	/**
	 * ʴͳƱ
	 *
	 * @access private
	 * @var string
	 */
	private $table = "ask_account";
	/**
	 * 캯
	 * 
	 */
	function __construct(){
		$this->table = TABLE_PREFIX . $this->table;
	}
	/**
	 * PHP4캯
	 * 
	 */
	function AskAccount(){
		$this->__construct();
	}
	/**
     * ûIDȡûͳ
     *
     * @param integer $uid	ûID
     * @return array
     */
    public function getByUid($uid){
    	if((int)$uid < 1){
    		throw_exception('LACK_PARAM_UID');
    	}
		$GLOBALS['db']->query("SELECT * FROM `{$this->table}` WHERE `uid` = '{$uid}' LIMIT 1");
		return $GLOBALS['db']->fetch();
    }
	/**
	 * ͳ
	 *
	 * @param integer $uid
	 * @return integer
	 */
	public function insert($uid){
		if((int)$uid < 1){
    		throw_exception('LACK_PARAM_UID');
    	}
		$data = array(
			'uid' => $uid,
			'level' => 0,
			'question' => 0,
			'question_elite' => 0,
			'answer' => 0,
			'answer_best' => 0,
			'answer_elite' => 0,
			'adopt' => 0,
			'favorable' => 0
		);
        $sql = "INSERT INTO `{$this->table}` (`" . implode("`, `", array_keys($data)) . "`) VALUES('" . implode("', '", array_values($data)) . "')";
                $GLOBALS['db']->query($sql);
        return $uid;
	}
	/**
     * ֶָ
     *
     * @param integer $uid	ԱID
     * @param string $field	ֶ
	 * @param	integer  $value	ֵֶ
     * @param boolean $type	truefalse
     * @return boolean
     */
    public function update ($uid,$field,$value=1,$type=true)
    {
       if(in_array($field,array('question','question_elite','answer','answer_best','answer_elite','adopt','favorable'))){
	    	    	$account_array = $this->getByUid($uid);
	    	if(!is_array($account_array) || count($account_array) < 1 ){
				$this->insert($uid);
			}
	        $value = (int)$value;
	        $total = $type ? (int)$account_array[$field] + $value : (int)$account_array[$field] - $value; 
	        if($field == 'answer_best' && $account_array['answer'] > 0){
	        	$adopt = round($total/$account_array['answer'],2);
	        	$adopt = ",`adopt` = '{$adopt}' ";
	        }else if($field == 'answer' && $total > 0){
	        	$adopt = round($account_array['adopt']/$total,2);
	        	$adopt = ",`adopt` = '{$adopt}' ";
	        }
	        $set = " `{$field}` = '{$total}'".$adopt;
	        $sql = "UPDATE `{$this->table}` SET  {$set} WHERE `uid` = '{$uid}' LIMIT 1";
	        return $GLOBALS['db']->query($sql);
       }
       return true;
    }
    /**
     * µȼ
     *
     * @param integer $uid	ûID
     * @param integer $exp	ûֵ
     * @return boolean
     */
    public function updateLevel($uid,$exp){
    	$account_array = $this->getByUid($uid);
    	if(!is_array($account_array) || count($account_array) < 1 ){
			$this->insert($uid);
		}
		include_once ASK_LIB_PATH.'Actor.class.php';
		$actor = new Actor();
		$actor_array = $actor->getActorByScore($exp);
		$sql = "UPDATE `{$this->table}` SET `level` = '{$actor_array['grade']}'  WHERE `uid` = '{$uid}' LIMIT 1";
		unset($actor,$actor_array,$account_array);
		return $GLOBALS['db']->query($sql);
    }
    /**
     * 
     *
    * @param integer 	$uid	ûID
     * @param integer	$number	
     * @return boolean
     */
    public function updateQuestion($uid,$number=1){
    	return $this->update($uid,'question',$number);
    }
    /**
     * ¾
     *
     * @param integer 	$uid	ûID
     * @param integer	$number	
     * @return boolean
     */
    public function updateQuestionElite($uid,$number=1){
    	return $this->update($uid,'question_elite',$number);
    }
    /**
     * »ش
     *
     * @param integer 	$uid	ûID
     * @param integer	$number	
     * @return boolean
     */
    public function updateAnswer($uid,$number=1){
    	return $this->update($uid,'answer',$number);
    }
    /**
     * »ش
     *
     * @param integer 	$uid	ûID
     * @param integer	$number	
     * @return boolean
     */
    public function updateAnswerBest($uid,$number=1){
    	return $this->update($uid,'answer_best',$number);
    }
    /**
     * ¾ش
     *
     * @param integer 	$uid	ûID
     * @param integer	$number	
     * @return boolean
     */
    public function updateAnswerElite($uid,$number=1){
    	return $this->update($uid,'answer_elite',$number);
    }
    /**
     * º
     *
     * @param integer 	$uid	ûID
     * @param integer	$number	
     * @return boolean
     */
    public function updateFavorable($uid,$number=1){
    	return $this->update($uid,'favorable',$number);
    }
}
?>