<?php
/**
 * Project:		EXCMS: the PHP content management system.
 * File:		AskAppend.class.php
 *
 * A product of PUTOYO Inc.
 * 
 * EXCMS is a ten million data-level,high speed,human-based content management system.
 *
 * EX is Excellence & Express & Exceed & Expert.
 * 
 * For questions, help, comments, discussion, please join the
 * EXCMS mailing list. Send a blank e-mail to
 * join@excms.cn
 * or join the EXCMS forum
 * www.excms.cn/forum
 * 
 * @link http://www.excms.cn/
 * @copyright Copyright (c) 2010 PUTOYO Inc.
 * @license http://www.excms.cn/licenses/LICENSE-1.0
 * @category EXCMS
 * @package Hit
 * @author hukuizhi
 * @version $Rev: 1700 $
 */
/* $Id: AskSetting.class.php 1700 2010-06-08 02:44:30Z hukuizhi $ */
/**
 * EXCMS ask ⣬׷
 * @category EXCMS
 * @package Ask
 * @author $Author: hukuizhi $
 */
class AskAppend{
	/**
	 * ׷𰸱
	 * @access private
	 * @var string
	 */
	private $table = 'ask_answers_append';
	/**
	 * ⲹ
	 * @access private
	 * @var string
	 */
	private $table_supplement = 'ask_questions_append';
	/**
	 * 캯
	 */
	function __construct(){
		$this->table = TABLE_PREFIX . $this->table;
		$this->table_supplement = TABLE_PREFIX . $this->table_supplement;
	}
	/**
	 * PHP4캯
	 * 
	 */
	function AskAppend(){
		$this->__construct();
	}
	/**
	 * ⲹ
	 * @param array $data	
	 * @return bool
	 */
	public function insertSupplement($data){
		if(is_numeric($data['qid'])&&$data['qid']>0){
			$data = array(
				'qid' => $data['qid'],
				'content' => $data['content'],
				'date' => time()
			);
			$sql = "INSERT INTO `{$this->table_supplement}` (`" . implode("`, `", array_keys($data)) . "`) VALUES('" . implode("', '", array_values($data)) . "')";
	        	        return $GLOBALS['db']->query($sql);
		}else{
			throw_exception('ASK_QUESTIONS_LACK_ID');
		}
	}
	/**
	 * ɾⲹ
	 *
	 * @param integer|string|array $qid	 id
	 * @return boolean
	 */
	public function delSupplement($qid){
		$qid = EXCMS::convertToIntArray($qid);
		if($qid === false){
			throw_exception('ASK_QUESTIONS_LACK_ID');
		}
		$num = count($qid);
		$where = $num > 1 ? "`qid` IN ('" . implode("', '", $qid) . "') " : "`qid` = '" . $qid[0] . "'";
		$sql = "DELETE FROM `{$this->table_supplement}` WHERE {$where}";
		return $GLOBALS['db']->query($sql);
	}
	/**
	 * ׷׷Ӵ
	 * @param array $data	
	 * @return bool
	 */
	public function insertAppend($data){
		if(!is_numeric($data['aid']) || !($data['aid']>0)){
			throw_exception('ASK_QUESTIONS_LACK_ID');
		}
		if(!is_numeric($data['type'])){
			throw_exception('ASK_APPEND_LACK_TYPE');//ȱ׷
		}else{
			$data['type'] = $data['type'] ? 1 : 0;
		}
		$data = array(
			'aid' => $data['aid'],
			'type'=> $data['type'],
			'content' => $data['content'],
			'date' => time()
		);
		$sql = "INSERT INTO `{$this->table}` (`" . implode("`, `", array_keys($data)) . "`) VALUES('" . implode("', '", array_values($data)) . "')";
                return $GLOBALS['db']->query($sql);
	}
	/**
	 * ɾ׷׷Ӵ
	 *
	 * @param integer|string|array $aid	 id
	 * @return boolean
	 */
	public function delAppend($aid){
		$aid = EXCMS::convertToIntArray($aid);
		if($aid === false){
			throw_exception('ASK_ANSWER_LACK_ID');
		}
		$num = count($aid);
		$where = $num > 1 ? "`aid` IN ('" . implode("', '", $qid) . "') " : "`aid` = '" . $qid[0] . "'";
		$sql = "DELETE FROM `{$this->table}` WHERE {$where}";
		return $GLOBALS['db']->query($sql);
	}
}

// excms file's end