 <?php
	/**
	 * Project:		EXCMS: the PHP content management system.
	 * File:		AskCateList.class.php
	 *
	 * A product of PUTOYO Inc.
	 * 
	 * EXCMS is a ten million data-level,high speed,human-based content management system.
	 *
	 * EX is Excellence & Express & Exceed & Expert.
	 * 
	 * For questions, help, comments, discussion, please join the
	 * EXCMS mailing list. Send a blank e-mail to
	 * join@excms.cn
	 * or join the EXCMS forum
	 * www.excms.cn/forum
	 * 
	 * @link http://www.excms.cn/
	 * @copyright Copyright (c) 2010 PUTOYO Inc.
	 * @license http://www.excms.cn/licenses/LICENSE-1.0
	 * @category EXCMS
	 * @package ask
	 * @author $Author: zhanghaisong $
	 * @version $Rev: 2220 $
	 */
	/* $Id: AskCateList.class.php 2220 2010-08-13 08:22:17Z zhanghaisong $ */
	/**
	 * EXCMS ǩ
	 * @category EXCMS
	 * @package ask
	 * @author $Author: zhanghaisong $
	 */
	include_once ASK_LIB_PATH . 'AskCategory.class.php';
	
	class AskCateList{
		/**
		 * 
		 *
		 * @var integer
		 */
		private $cid;
		/**
		 * top Ŀ,selfͬĿ,sonĿ, Ĭself
		 *
		 * @var boolean
		 */
		private $type;
		/**
		 * ʾĿ
		 *
		 * @var integer
		 */
		private $levels;
		/**
		 * ໺
		 *
		 * @var array
		 */
		private $category_cache;
		/**
		 * Ƿʾ
		 *
		 * @var boolean
		 */
		private $answer = false;
		/**
		 * ȡ
		 *
		 * @return object
		 */
		public function __construct(){
			if(!is_array($this->category_cache)){
				$category = new AskCategory();
				$this->category_cache = $category->getCateCache();
				unset($category);
			}
		}
		public function AskCateList(){
			$this->__construct();
		}
		/**
		 * ÷ID
		 *
		 * @param integer $cid
		 */
		public function setCid($cid){
			$this->cid = $cid;
		}
		public function setType($type){
			$this->type = $type;
		}
		public function setLevels($levels){
			$this->levels = $levels;
		}
		public function setAnswer($answer){
			$this->answer = $answer;
		}
		/**
		 * ȡID
		 *
		 * @return integer
		 */
		public function getCid(){
			return empty($this->cid) ? 0 : $this->cid;
		}
		/**
		 * top ,selfͬ,sonӷ Ĭself
		 *
		 * @return boolean
		 */
		public function getType(){
			switch($this->type){
				case 'top' :
					$typeid = 0;
					break;
				case 'son' :
					$typeid = $this->getCid();
					if(!is_array($this->category_cache[$typeid]['childids']) || count($this->category_cache[$typeid]['childids']) < 1){
						$typeid = $this->category_cache[$this->getCid()]['pid'];
					}
					break;
				case 'self' :
				default :
					$typeid = $this->category_cache[$this->getCid()]['pid'];
					break;
			}
			return $typeid;
		}
		/**
		 * ȡ༶
		 *
		 * @return integer
		 */
		public function getLevels(){
			return $this->levels <= 0 ? 0 : $this->levels;
		}
		/**
		 * ȡʾ
		 *
		 * @return boolean
		 */
		public function getAnswer(){
			return $this->answer;
		}
		/**
		 * ȡб
		 *
		 * @return array
		 * <ul>
		 * <li>$array['cid'] ID</li>
		 * <li>$array['type'] top Ŀ,selfͬĿ,sonĿ,crossĿ Ĭself</li>
		 * <li>$array['levels'] ʾĿ </li>
		 * </ul>
		 */
		public function getAskCateList($array){
			global $_CATEGORY;
			$array['cid'] = $array['cid'] > 0 ? $array['cid'] : $_CATEGORY['cid'];
			$this->setCid($array['cid']);
			$this->setType($array['type']);
			$this->setLevels($array['levels']);
			$askcate_array = $this->category_cache[$this->getType()]['childids'];
			$result = null;
			if(is_array($askcate_array) && count($askcate_array) > 0){
				$category_array = array();
				foreach($askcate_array as $key => $value){
					$category_array[$key] = $this->category_cache[$value];
					$category_array[$key]['url'] = EXCMS::url(array('name' => 'ask.list', 'cid' => $value, 'type' => '', 'word' => ''));
				}
				$result = array('from' => &$category_array);
				unset($ask_cate);
			}
			return $result;
		}
		/**
		 * ȡб
		 * 
		 * @param array $array 
		 * <ul>
		 * <li>$array['cid'] ID</li>
		 * <li>$array['type'] top Ŀ,selfͬĿ,sonĿ,crossĿ Ĭself</li>
		 * <li>$array['levels'] ʾĿ,ĬΪĿ</li>
		 * <li>$array['answer'] Ƿʾ </li>
		 * <li>$array['levels1'] һʾ </li>
		 * <li>$array['levels2'] öʾ </li>
		 * </ul>
		 * 
		 * @return array
		 */
		public function getAskCate($array){
			global $_PAGE;
			$array["cid"] = $array['cid'] > 0 ? $array["cid"] : $_PAGE['ASK_CATEGORY']['cid'];
			$this->setCid($array['cid']);
			$this->setType($array['type']);
			$this->setLevels($array['levels']);
			$this->setAnswer($array['answer']);
			foreach($array as $key => $value){
				$pos = strpos($key, 'level');
				if($pos !== false){
					$level = trim(substr($key, $pos + 5));
					$levelNum[$level] = $value;
				}
			}
			return $this->getAskCateTree($this->getType(), $this->getLevels(), $levelNum);
		}
		/**
		 * ȡ
		 *
		 * @param integer $cid	ID
		 * @param integer $levels	༶
		 * @param integer $levelNum	
		 * @param integer $curLevel	ǰ༶
		 * 
		 * @return string 
		 */
		public function getAskCateTree($cid, $levels, $levelNum, $curLevel = 1){
			$askcate_array = $this->category_cache[$cid]['childids'];
			if(is_array($askcate_array) && count($askcate_array) > 0){
				$count = 0;
				$str = "<ul class=\"level{$curLevel}-ul clearfix channelid{$cid}\">\n";
				foreach($askcate_array as $value){
					$category_array = $this->category_cache[$value];
					//(Ϊ  ǰСü)  (Ϊ  СڵǰĿ)
					if(($levels == 0 || $levels >= $curLevel) && (empty($levelNum[$curLevel]) || $count < $levelNum[$curLevel])){
						$str .= "<li class=\"level{$curLevel}-li\">";
						$url = EXCMS::url(array('name' => 'ask.list', 'cid' => $category_array['cid'], 'type' => '', 'word' => ''));
						if($this->getAnswer()){
							$answernum = " (" . $category_array['asknumber'] . ")";
						}
						$childs =  is_array($this->category_cache[$category_array['cid']]['childids']) && count($this->category_cache[$category_array['cid']]['childids']) > 0;
						if(!($levels == $curLevel) && $childs){
							$str .= "\n<h3 class=\"level{$curLevel}-h3\"><a href=\"{$url}\">" . $category_array['name'] . "</a>{$answernum}</h3>\n";
							$str .= $this->getAskCateTree($category_array['cid'], $levels, $levelNum, $curLevel + 1);
						}else{
							if($curLevel == 1){
								$str .= "\n<h3 class=\"level{$curLevel}-h3\"><a href=\"{$url}\">" . $category_array['name'] . "</a>{$answernum}</h3>\n";
							}else{
								$str .= "<a href=\"{$url}\">" . $category_array['name'] . "</a>{$answernum}";
							}
						}
						$str .= "</li>\n";
						$count++;
					}
				}
				$str .= "</ul>\n";
			}
			return $str;
		}
	}

 // excms file end