<?php
/**
 * Project:		EXCMS: the PHP content management system.
 * File:		AskQuestion.class.php
 *
 * A product of PUTOYO Inc.
 * 
 * EXCMS is a ten million data-level,high speed,human-based content management system.
 *
 * EX is Excellence & Express & Exceed & Expert.
 * 
 * For questions, help, comments, discussion, please join the
 * EXCMS mailing list. Send a blank e-mail to
 * join@excms.cn
 * or join the EXCMS forum
 * www.excms.cn/forum
 * 
 * @link http://www.excms.cn/
 * @copyright Copyright (c) 2010 PUTOYO Inc.
 * @license http://www.excms.cn/licenses/LICENSE-1.0
 * @category EXCMS
 * @package ask
 * @author $Author: zhanghaisong $
 * @version $Rev: 2252 $
 */
/* $Id: AskQuestion.class.php 2252 2010-08-17 10:11:48Z zhanghaisong $ */
/**
 * EXCMS 
 * @category EXCMS
 * @package ask
 * @author $Author: zhanghaisong $
 */
class AskQuestion{
	/**
	 * ݱ
	 *
	 * @access private
	 * @var string
	 */
	private $table = 'ask_questions';
	/**
	 * Դʱ
	 *
	 * @var string
	 */
	private $fromuid_table = 'ask_from_uid';
	/**
	 * 캯
	 *
	 */
	function __construct(){
		$this->table = TABLE_PREFIX . $this->table;
		$this->fromuid_table = TABLE_PREFIX . $this->fromuid_table;
	}
	/**
	 * PHP4캯
	 *
	 */
	function AskQuestion(){
		$this->__construct();
	}
	/**
	 * IDȡ
	 *
	 * @param integer $qid	ID
	 * @return array	ϸϢ
	 */
	public function getById($qid){
		if(!($qid > 0)){
			throw_exception('ASK_QUESTIONS_LACK_ID');
		}
		$sql = "SELECT * FROM `{$this->table}` WHERE `qid` = '{$qid}' LIMIT 1";
		$GLOBALS['db']->query($sql);
		return $GLOBALS['db']->fetch();
	}
	/**
	 * IDȡϢ
	 *
	 * @param integer $qid	ID
	 * 
	 * @return array	ϸϢ
	 */
	public function getByQid($qid){
		$rs = $this->getById($qid);
		include_once ASK_LIB_PATH . 'AskCategory.class.php';
		$askcate = new AskCategory();
		$rs['category'] = $askcate->getCateCache($rs['cid']);
		$rs['url'] = EXCMS::url(array('name' => 'ask.question', 'id' => $qid));
		global $_QUESTION_STATUS_TEXT;
		$rs['status_text'] = $_QUESTION_STATUS_TEXT[$rs['status']];
		$rs['asktime'] = timeformat($rs['createdate'], 'nj H:i');
		unset($askcate, $ask_array);
		return $rs;
	}
	/**
	 * ½ 
	 *
	 * @param array $data	
	 * <ul>
	 * <li>string $data['cid']  </li>
	 * <li>integer $data['title']  </li>
	 * <li>string $data['score'] ͷ</li>
	 * <li>string $data['ip'] IP</li>
	 * <li>integer $data['anonymous'] ǷΪ(ĬΪ) </li>
	 * <li>string $data['urgent'] ǷΪ(ĬΪ)</li>
	 * <li>integer $data['content'] Լⲹ˵ </li>
	 * </ul>
	 * 
	 * @return integer  ID
	 */
	function insert($data){
		if((int)$data['cid'] < 1){
			throw_exception('ASK_CATEGORY_LACK_ID');
		}
		if(trim($data['title']) == ''){
			throw_exception('ASK_QUESTIONS_TITLE');
		}
		global $EXCMS_MODULE;
		$expired_time = (int)$EXCMS_MODULE['ask']['question_expired_time'] > 0 ? (int)$EXCMS_MODULE['ask']['question_expired_time'] : 15;
		$time = time();
		$data = array(
			'cid' => $data['cid'],
			'title' => trim($data['title']),
			'content' => trim($data['content']),
			'score' => (int)$data['score'],
			'hot' => 0,
			'checked' => $EXCMS_MODULE['ask']['question_check'] == 1 ? 0 : 2,
			'status' => 2,
			'urgent' => $data['urgent'] ? 1 : 0,
			'anonymous' => $data['anonymous'] ? 1 : 0,
			'answernumber' => 0,
			'newanswer' => 0,
			'uid' => $data['uid'],
			'ip' => $data['ip'],
			'createdate' => $time,
			'modifieddate' => $time,
			'solveddate' => $time + ($expired_time * 24 * 60 * 60),
			'votedate' => ''
		);
		$sql = "INSERT INTO `{$this->table}` (`" . implode("`, `", array_keys($data)) . "`) VALUES('" . implode("', '", array_values($data)) . "')";
		$GLOBALS['db']->query($sql);
		$id = $GLOBALS['db']->insert_id();
		// 
		include_once ASK_LIB_PATH . 'AskCategory.class.php';
		$askcate = new AskCategory();
		$askcate->updateQuestionNumber($data['cid']);
		/*
		 * ִ
		 */
		if($data['uid'] > 0){
			include_once ASK_LIB_PATH.'AskScore.class.php';
			$score = new AskScore();
			// ʿۻ
			if($data['anonymous']) $score->scoreAnonymousQuestion($data['uid']);
			// ʿۻ
			if($data['urgent']) $score->scoreQuestoinUgrent($data['uid']);
			// ֱĳʰ˴οۻ
			if($data['directto']){
				$directto = EXCMS::convertToIntArray($data['directto']);
				if($directto !== false){
					$directto_num = count($directto);
					$this->insertFromUid($data['uid'], $directto, $id);
					$score->scoreQuestionDirect($data['uid'], $directto_num);
				}
			}
			$score->scoreQuestoin($data['uid']); // ӻ
			
			// ͳƱ
			include_once ASK_LIB_PATH.'AskAccount.class.php';
			$account = new AskAccount();
			$account->updateQuestion($data['uid']); // 
		}
		/*
		// ִ
		include_once LIB_MODULES_PATH . 'search/SearchSplitWord.class.php';
		$class_splitword = new SearchSplitWord();
		$class_splitword->saveSplit($data['title'] . $data['content'], '', $data['cid'], $id, 3, $data['checked']);
		unset($class_splitword);
		*/
		return $id;
	}
	/**
	 * 
	 *
	 * @param integer $qid
	 * @param boolean $anonymous
	 * @return boolean
	 */
	public function updateAnonymous($qid,$anonymous=true){
		$question_array = $this->getById($qid);
		$anonymous = $anonymous ? 1 : 0;
		if($question_array['anonymous'] == 0 && $anonymous == 1){
			include_once ASK_LIB_PATH.'AskScore.class.php';
			$score = new AskScore();
			$score->scoreAnonymousQuestion(EXCMS_SESSION_UID); 	
		}
		if($question_array['anonymous'] != $anonymous){
			return $this->setting('anonymous',$qid,$anonymous);
		}
		return true;
	}
	/**
	 * ָID
	 *
	 * @param integer $qid ID
	 * @param array $data	
	 * <ul>
	 * <li>string $data['cid']  </li>
	 * <li>integer $data['title']  </li>
	 * <li>string $data['score'] ͷ</li>
	 * <li>string $data['ip'] IP</li>
	 * <li>integer $data['anonymous'] ǷΪ(ĬΪ) </li>
	 * <li>string $data['urgent'] ǷΪ(ĬΪ)</li>
	 * <li>integer $data['content'] Լⲹ˵ </li>
	 * </ul>
	 * 
	 * @return boolean
	 */
	public function update($qid, $data){
		if(!($qid > 0)){
			throw_exception('ASK_QUESTIONS_LACK_ID');
		}
		if((int)$data['cid'] < 1){
			throw_exception('ASK_CATEGORY_LACK_ID');
		}
		if(trim($data['title']) == ''){
			throw_exception('ASK_QUESTIONS_TITLE');
		}
		$data = array(
			'cid' => $data['cid'],
			'title' => trim($data['title']),
			'score' => $data['score'],
			'modifieddate' => time(),
			'content' => trim($data['content']),
			'ip' => $data['ip'],
			'anonymous' => $data['anonymous'] ? 1 : 0,
			'urgent' => $data['urgent'] ? 1 : 0
		);
		/*
		// ִ
		include_once LIB_MODULES_PATH . 'search/SearchSplitWord.class.php';
		$class_splitword = new SearchSplitWord();
		$class_splitword->saveSplit($data['title'] . $data['content'], '', $data['cid'], $qid, 3, 1);
		unset($class_splitword);
		*/
		$set = array();
		foreach($data as $k => $v){
			$set[] = "`{$k}` = '{$v}'";
		}
		$set = implode(", ", $set);
		$sql = "UPDATE `{$this->table}` SET {$set} WHERE `qid` = '{$qid}' LIMIT 1";
		return $GLOBALS['db']->query($sql);
	}
	/**
	 * ݷIDɾб
	 *
	 * @param integer $cid	ID
	 * @return boolean
	 */
	public function deleteByCid($cid){
		$cid = EXCMS::convertToIntArray($cid);
		if($cid === false){
			throw_exception('ASK_CATEGORY_LACK_ID');
		}
		$num = count($cid);
		$where = $num > 1 ? "`cid` IN ('" . implode("', '", $cid) . "')" : "`cid` = '" . $cid[0] . "'";
		$sql = "DELETE FROM `{$this->table}` WHERE {$where}";
		return $GLOBALS['db']->query($sql);
		//·
	//»
	}
	/**
	 * ɾָID
	 *
	 * @param string|integer|array $qid ID
	 * @return boolean
	 */
	public function delete($qid){
		$qid = EXCMS::convertToIntArray($qid);
		if($qid === false){
			throw_exception('ASK_QUESTIONS_LACK_ID');
		}
		$num = count($qid);
		$where = $num > 1 ? "`qid` IN ('" . implode("', '", $qid) . "') LIMIT {$num}" : "`qid` = '" . $qid[0] . "'";
		$sql = "SELECT `cid`,`qid`,`uid`,`score` FROM {$this->table} WHERE {$where}";
		$GLOBALS['db']->query($sql);
		$question_array = $GLOBALS['db']->fetchAll();
		$sql = "DELETE FROM `{$this->table}` WHERE {$where}";
		$success = $GLOBALS['db']->query($sql);
		if($success){
			//·
			include_once ASK_LIB_PATH . 'AskCategory.class.php';
			$askcate = new AskCategory();
			
			include_once ASK_LIB_PATH.'AskScore.class.php';
			$score = new AskScore();
		
			include_once ASK_LIB_PATH.'AskAccount.class.php';
			$account = new AskAccount();
			foreach($question_array as $value){
				$askcate->updateQuestionNumber($value['cid'], false); 					//µ
				//»
				if($value['uid'] > 0){
					$score->scoreDeleteQuestion($value['uid']);						 	//ʱɾ  ߼20
					$account->updateQuestion($value['uid'], -1); 						//
				}
			}
			
			include_once ASK_LIB_PATH.'Answer.class.php';								//ɾشб
			$answer = new Answer();
			$answer->deleteByQid($qid);
			
			include_once LIB_MODULES_PATH . 'search/SearchSplitWord.class.php';					//ɾִ
			$class_splitword = new SearchSplitWord();
			$class_splitword->deleteByContentId($qid, 'ask');
			
			unset($askcate,$score,$account,$answer,$class_splitword);
		}
		return $success;
	}
	/**
	 * ͶƱرʱ
	 *
	 * @param integer $qid
	 * 
	 * @return boolean
	 */
	public function updateVoteSolved($qid){
		global $EXCMS_MODULE;
		return $this->updateSolveddate($qid,(int)$EXCMS_MODULE['ask']['vote_time']);
	}
	/**
	 * ½ʱ
	 *
	 * @param integer $qid	ID
	 * @param integer $day	
	 * @return boolean
	 */
	public function updateSolveddate($qid, $day = 0, $time = 0){
		if($day > 0){
			$question_array = $this->getById($qid);
			$question_array['solveddate'] = $question_array['solveddate'] + ((int)$day * 24 * 60 * 60);
		}
		if($time > 0){
			$question_array['solveddate'] = $time;
		}
		return $this->setting('solveddate', $qid, $question_array['solveddate']);
	}
	/**
	 * ⲹ˵
	 *
	 * @param integer $qid	ID
	 * @param bool $append	Ƿⲹ
	 * @return boolean
	 */
	public function append($qid, $append=1){
		return $this->setting('append', $qid, $append);
	}
	/**
	 * ״̬
	 *
	 * @param integer $qid	ID
	 * @param integer $checked	Ƿ0:δ 1:δͨ 2:ͨ
	 * 
	 * @return boolean
	 */
	public function updateChecked($qid, $checked){
		if($checked < 0 || $checked > 2) $checked = 0;
		$qid = EXCMS::convertToIntArray($qid);
		$num = count($qid);
		$where = $num > 1 ? "`qid` IN ('" . implode("', '", $qid) . "') LIMIT {$num}" : "`qid` = '" . $qid[0] . "'";
		$sql = "SELECT `uid`,`checked` FROM {$this->table} WHERE {$where}";
		$GLOBALS['db']->query($sql);
		$question_array = $GLOBALS['db']->fetchAll();
		if(is_array($question_array) && count($question_array) > 0){

			include_once ASK_LIB_PATH.'AskScore.class.php';
			$score = new AskScore();
			
			foreach($question_array as $value){
				if($checked == $value['checked'] || $value['checked'] == 2) continue;
				
				if($value['uid'] > 0){
					if($value['checked'] == 0 && $checked == 1){ 						//δͨ˿20
						$score->scoreCheckQuestion($value['uid'], false); 
					}else if($value['checked'] == 1 && $checked == 2){					 //ͨ˷20
						$score->scoreCheckQuestion($value['uid'], true); 
					}
				}
			}
		}
		unset($question_array,$score);
		return $this->setting('checked', $qid, $checked);
	}
	/**
	 * ¾
	 *
	 * @param integer $qid	ID
	 * @param integer $elite	 1Ǿ2:ͨĬΪͨ
	 * @return boolean
	 */
	public function updateElite($qid, $elite){
		$elite = $elite == 1 ? 1 : 0;
		$qid = EXCMS::convertToIntArray($qid);
		$num = count($qid);
		$where = $num > 1 ? "`qid` IN ('" . implode("', '", $qid) . "') LIMIT {$num}" : "`qid` = '" . $qid[0] . "'";
		$sql = "SELECT `qid`,`uid`,`elite` FROM {$this->table} WHERE {$where} AND `status`= '3' ";
		$GLOBALS['db']->query($sql);
		$question_array = $GLOBALS['db']->fetchAll();
		if($elite == 1 && is_array($question_array) && count($question_array) > 0){
			
			include_once ASK_LIB_PATH.'AskScore.class.php';
			$score = new AskScore();
			
			include_once ASK_LIB_PATH.'AskAccount.class.php';
			$account = new AskAccount();
			
			include_once ASK_LIB_PATH.'Answer.class.php';
			$answer = new Answer();
			foreach($question_array as $value){
				if($value['uid'] > 0 && $value['elite'] == 2){
					$score->scoreQuestionElite($value['uid']); 											//ʼӷ
					$answer_array = $answer->getBestAnswer($value['qid']);
					foreach ($answer_array as $v){
						if($v['uid'] > 0){
							$score->scoreAnswerElite($v['uid']);										//ʻشӷ
							$account->updateAnswerElite($v['uid']);										//ش
						}
					}
					$account->updateQuestionElite($value['uid']);										//
				}
			}
		}
		unset($question_array,$score,$account);
		return $this->setting('elite', $qid, $elite);
	}
	/**
	 * ǰ
	 *
	 * @param mixed $question	ID
	 */
	public function dealQuestion($qid){
		if(is_array($qid)){
			$question_array = $qid;
			$qid = $question_array['qid'];
		}else{
			$question_array = $this->getById($qid);
		}
		$time = time();
		if($question_array['status'] == 5 && $time >= $question_array['solveddate']){ // ͶƱҵǰʱڽʱ
			include_once ASK_LIB_PATH.'AskVote.class.php';
			$vote = new AskVote();
			$aidvote = $vote->groupStatVoteByQid($qid); //شIDͳƷͳͶƱ
			$votetotal = 0;
			if(is_array($aidvote) && count($aidvote) > 0){
				foreach($aidvote as $value){
					$votetotal += $value['total'];
					if($value['total'] >= 3) $aid = $value['aid'];
				}
			}
			$votedate = $question_array['votedate']; //ͶƱʱ
			$day = (time() - $votedate) / 86400;
			if($votetotal >= 4 && $aid > 0 && $day >= 1){ //ͶƱƱƱߵĻشƱ 3 Ʊ,ͬʱͶƱڴﵽ1죨24СʱϵͳԶƱĻشѡΪȷ𰸡
				include_once ASK_LIB_PATH.'Answer.class.php';
				$answer = new Answer();
				$answer->updateIsbast($aid, true); //Ѵ
				unset($answer);
			}else if($votetotal < 4){ // ͶƱ 4 Ʊ⽫Զرա
				$this->closeQuestion($qid, $question_array['uid'], $question_array['score']);
			}else{ // ת
				$this->expiredDeal($qid, $question_array['uid']);
			}
			unset($vote, $aidvote);
		}else if($question_array['status'] == 2 && $time >= $question_array['solveddate']){ // ѹ
			include_once ASK_LIB_PATH.'Answer.class.php';
			$answer = new Answer();
			if($question_array['answernumber'] <= 3 && !$answer->statAnswerContentNumber($qid)){ // ڲϵͳԶرա
				$this->closeQuestion($qid, $question_array['uid'], $question_array['score']); // Ϊ
			}else if($question_array['answernumber'] >= 2){ //תͶƱ
				// תͶƱ״̬
				$this->updateStatus($qid, 5);
				// ͶƱʱ
				$this->updateVoteDate($qid, time());
				// ½ʱ
				$this->updateVoteSolved($qid);
				// ͶƱش
				$answer->updateVoteByQid($qid, true);
				if($question_array['uid'] > 0){
					include_once ASK_LIB_PATH.'AskScore.class.php';
					$score = new AskScore();
					$score->expExpiredToVote($question_array['uid']);
					unset($score);
				}
			}else if($question_array['answernumber'] == 1){ // ѽ	
				$answer_array = $answer->getAnswerByQid($qid);
				$answer->updateIsbast($answer_array['aid'], true);
			}else{ // 
				$this->expiredDeal($qid, $question_array['uid']);
			}
			unset($answer, $answer_array);
		}
	}
	/**
	 * ر
	 *
	 * @param integer $qid	ID
	 * @return boolean
	 */
	public function closeQuestion($qid,$uid,$score){
		$this->updateStatus($qid, 6);		//ر
		$this->updateVoteSolved($qid);		//¹رʱ
		if($uid > 0 && $score > 0){
			include_once ASK_LIB_PATH.'AskScore.class.php';
			$score = new AskScore();
			$score->scoreCentQuestion($uid,$score);
			unset($score);
		}
		return true;
	}
	/**
	 * 
	 *
	 * @param integer $qid
	 * @param integer $uid
	 * 
	 * @return boolean
	 */
	public function expiredDeal($qid,$uid=0){
		$this->updateStatus($id, 4);				//
		if( !($uid > 0)){
			$question_array = $this->getById($qid);
			$uid  = $question_array['uid'];
		}
		if($uid > 0)	{
			include_once ASK_LIB_PATH.'AskScore.class.php';
			$score = new AskScore();
			$score->scoreExpiredQuestion($uid);			//
			unset($score);
		}
		return true;
	}
	/**
	 * ״̬
	 *
	 * @param integer $qid	ID
	 * @param integer $status	1:⡢2:⡢3:ѽ4:5ͶƱ6ر
	 * @return boolean
	 */
	public function updateStatus($qid, $status){
		if($status < 1 || $status > 6) $status = 2;
		return $this->setting('status', $qid, $status);
	}
	/**
	 * ½
	 *
	 * @param integer $qid	ID
	 * @param integer $urgent	ǷΪ(0ͨ1)
	 * @return boolean
	 */
	public function updateUrgent($qid, $urgent){
		$urgent = $urgent > 0 ? 1 : 0;
		$qid = EXCMS::convertToIntArray($qid);
		$num = count($qid);
		$where = $num > 1 ? "`qid` IN ('" . implode("', '", $qid) . "') LIMIT {$num}" : "`qid` = '" . $qid[0] . "'";
		$sql = "SELECT `uid`,`urgent` FROM {$this->table} WHERE {$where}";
		$GLOBALS['db']->query($sql);
		$question_array = $GLOBALS['db']->fetchAll();
		if($urgent && count($question_array) > 0){
			include_once ASK_LIB_PATH.'AskScore.class.php';
			$score = new AskScore();
			foreach ($question_array as $value){
				if($value['uid'] > 0 && $value['urgent']== 0){
					$score->scoreQuestoinUgrent($value['uid']); 
				}
			}
		}
		return $this->setting('urgent', $qid, $urgent);
	}
	/**
	 * Ƿ»ش
	 *
	 * @param integer $qid	ID
	 * @param boolean $status	Ƿ»ش,ĬΪtrue
	 * @return boolean
	 */
	public function updateNewAnswer($qid, $status = true){
		$status = $status ? 1 : 0;
		return $this->setting('newanswer', $qid, $status);
	}
	/**
	 * 
	 *
	 * @param string $action	
	 * @param integer $qid	ID
	 * @param integer $value	ֵ
	 * @return boolean
	 */
	public function setting($action, $qid, $value){
		if(!in_array($action, array('checked', 'elite', 'status', 'urgent', 'newanswer', 'append', 'solveddate', 'createdate','anonymous'))) throw_exception('ASK_QUESTIONS_NOT_SETTING');
		$qid = EXCMS::convertToIntArray($qid);
		if($qid === false){
			throw_exception('ASK_QUESTIONS_LACK_ID');
		}
		$num = count($qid);
		$where = $num > 1 ? "`qid` IN ('" . implode("', '", $qid) . "') LIMIT {$num}" : "`qid` = '" . $qid[0] . "'";
		$sql = "UPDATE `{$this->table}` SET `{$action}` = '{$value}' WHERE {$where}";
		return $GLOBALS['db']->query($sql);
	}
	/**
	 * ´
	 *
	 * @param integer $qid	ID
	 * @param boolean $status ٴ,ĬΪӴ
	 * 
	 * @return boolean
	 */
	public function updateAnswerNumber($qid, $status = true){
		$qid = EXCMS::convertToIntArray($qid);
		if($qid === false){
			throw_exception('ASK_QUESTIONS_LACK_ID');
		}
		$num = count($qid);
		$where = $num > 1 ? "`qid` IN ('" . implode("', '", $qid) . "') LIMIT {$num}" : "`qid` = '" . $qid[0] . "'";
		if($status){
			$status = " answernumber+1 ";
		}else{
			$status = " answernumber-1 ";
		}
		$sql = "UPDATE `{$this->table}` SET `answernumber` = {$status} WHERE {$where}";
		return $GLOBALS['db']->query($sql);
	}
	/**
	 * ͷ
	 *
	 * @param integer $qid	ID
	 * @param integer $value	ͷ
	 * @param boolean $status ͷ,ĬΪͷ
	 * 
	 * @return boolean
	 */
	public function updateCent($qid, $value, $status = true){
		$qid = EXCMS::convertToIntArray($qid);
		if($qid === false){
			throw_exception('ASK_QUESTIONS_LACK_ID');
		}
		$num = count($qid);
		$where = $num > 1 ? "`qid` IN ('" . implode("', '", $qid) . "') LIMIT {$num}" : "`qid` = '" . $qid[0] . "'";
		$status = $status ? " score+ " : " score- ";
		$status = $status . (int)$value;
		$sql = "UPDATE `{$this->table}` SET `score` = {$status} WHERE {$where}";
		return $GLOBALS['db']->query($sql);
	}
	/**
	 * µ
	 *
	 * @param integer $qid	ID
	 * 
	 * @return boolean	
	 */
	public function updateHot($qid){
		$qid = EXCMS::convertToIntArray($qid);
		if($qid === false){
			throw_exception('ASK_QUESTIONS_LACK_ID');
		}
		$num = count($qid);
		$where = $num > 1 ? "`qid` IN ('" . implode("', '", $qid) . "') LIMIT {$num}" : "`qid` = '" . $qid[0] . "'";
		$sql = "UPDATE `{$this->table}` SET `hot` = hot+1 WHERE {$where}";
		return $GLOBALS['db']->query($sql);
	}
	/**
	 * ͶƱʱ
	 *
	 * @param integer $qid	ID
	 * @param integer $time	ͶƱʱ
	 * @return boolean
	 */
	public function updateVoteDate($qid, $time){
		$qid = EXCMS::convertToIntArray($qid);
		if($qid === false){
			throw_exception('ASK_QUESTIONS_LACK_ID');
		}
		$num = count($qid);
		$where = $num > 1 ? "`qid` IN ('" . implode("', '", $qid) . "') LIMIT {$num}" : "`qid` = '" . $qid[0] . "'";
		$sql = "UPDATE `{$this->table}` SET `votedate` = '{$time}' WHERE {$where}";
		return $GLOBALS['db']->query($sql);
	}
	/**
	 * ͳ˹
	 *
	 * @return integer	
	 */
	public function countQuestionNumber(){
		$sql = "SELECT count(*) AS number FROM `{$this->table}` WHERE `checked` = 2 ";
		$GLOBALS['db']->query($sql);
		$question_array = $GLOBALS['db']->fetch();
		return $question_array['number'];
	}
	/**
	 * ͳƴ
	 *
	 * @return integer	
	 */
	public function countPendingNumbere($uid=0){
		if($uid > 0){
			$uid = (int)$uid;
			$where = " `uid` = '{$uid}' AND ";
		}
		$sql = "SELECT count(*) AS number FROM `{$this->table}` WHERE {$where} `checked` = 2 AND `status` = '2'";
		$GLOBALS['db']->query($sql);
		$question_array = $GLOBALS['db']->fetch();
		return $question_array['number'];
	}
	/**
	 * ͳѽ
	 *
	 * @return integer	
	 */
	public function countSolution($uid=0){
		if($uid > 0){
			$uid = (int)$uid;
			$where = " `uid` = '{$uid}' AND ";
		}
		$sql = "SELECT count(*) AS number FROM `{$this->table}` WHERE {$where} `checked` = 2 AND `status` = 3 ";
		$GLOBALS['db']->query($sql);
		$question_array = $GLOBALS['db']->fetch();
		return $question_array['number'];
	}
	/**
	 * ͳѹرյ
	 * 
	 * @param $uid
	 *
	 * @return integer	
	 */
	public function countClose($uid=0){
		if($uid > 0){
			$uid = (int)$uid;
			$where = " `uid` = '{$uid}' AND ";
		}
		$sql = "SELECT count(*) AS number FROM `{$this->table}` WHERE {$where} `checked` = 2 AND `status` = 6 ";
		$GLOBALS['db']->query($sql);
		$question_array = $GLOBALS['db']->fetch();
		return $question_array['number'];
	}
	/**
	 * ȡҳб
	 *
	 * @param array $paging ҳ
	 * <ul>
	 * <li>integer $paging['limit'] ҳС default 0</li>
	 * <li>integer $paging['start'] ҳʼС default 0</li>
	 * <li>integer $paging['total']  default 0</li>
	 * <li>integer $paging['sort'] ֶ</li>
	 * <li>integer $paging['dir'] ʽ ASC or DESC, </li>
	 * <li>integer $paging['keywords'] ؼ</li>
	 * <li>integer $paging['cid'] </li>
	 * <li>integer $paging['checked'] ״̬,0:δ 1:δͨ 2:ͨ</li>
	 * </ul>
	 * @return array Paging 
	 * <ul> 
	 * <li> $array['total']  </li>
	 * <li> $array['data'] ҳ </li>
	 * </ul>
	 */
	function getPaging($paging = array()){
		$keywords = trim($paging['keywords']);
		if(!empty($keywords)){
			$where = " and (`title` like '%{$keywords}%' or `content` like '%{$keywords}%')";
		}
		if($paging['cid'] > 0){
			$where .= " and `cid`='{$paging['cid']}' ";
		}
		if(isset($paging['checked']) && $paging['checked'] >= 0){
			$paging['checked'] = (int)$paging['checked'];
			$where .= " and `checked`='{$paging['checked']}' ";
		}
		$paging['status'] = (int)$paging['status'];
		if($paging['status'] > 0){
			$where .= " and `status`= '{$paging['status']}'";
		}
		if(isset($paging['urgent']) && $paging['urgent'] >= 0){
			$paging['urgent'] = (int)$paging['urgent'];
			$where .= " and `urgent`= '{$paging['urgent']}'";
		}
		if($paging['elite'] == '1' || $paging['elite'] == '0'){
			$where .= " and `elite`= '{$paging['elite']}'";
		}
		if(!isset($paging['total'])){
			$sql = "SELECT COUNT(*) as `total` FROM `{$this->table}` WHERE 1 {$where}";
			$GLOBALS['db']->query($sql);
			$rs = $GLOBALS['db']->fetch();
			$total = $rs['total'];
		}else{
			$total = (int)$paging['total'];
		}
		if($total <= 0){
			return array('total' => $total, 'data' => array());
		}
		if(!in_array($paging['sort'], array('createdate', 'hot', 'answernumber', 'score', 'checked'))) $paging['sort'] = 'createdate';
		$dir = strtoupper($paging['dir']) == "DESC" ? "DESC" : "ASC";
		$sort = "`" . $paging['sort'] . "` {$dir}";
		$orderby = "ORDER BY {$sort}";
		$start = (int)$paging['start'];
		$limit = $paging['limit'] > 0 ? ($paging['limit'] > 100 ? 100 : $paging['limit']) : 25;
		$limit = "LIMIT {$start}, {$limit}";
		$sql = "SELECT * FROM `{$this->table}` WHERE 1 {$where} {$orderby} {$limit}";
		$GLOBALS['db']->query($sql);
		$rs = $GLOBALS['db']->fetchAll();
		if(count($rs) > 0){
			include_once ASK_LIB_PATH . 'AskCategory.class.php';
			$cate = new AskCategory();
			$cate_cache = $cate->getCateCache();
			include_once LIB_MODULES_PATH . 'account/Account.class.php';
			$account = new Account();
			$account_cache = array();
			foreach($rs as $key => $value){
				// ȡ
				$rs[$key]['catename'] = '';
				if($value['cid'] > 0){
					$rs[$key]['catename'] = $cate_cache[$value['cid']]['name'];
				}
				// ȡû
				if($value['uid'] > 0){
					if(!$account_cache[$value['uid']]){
						$account_cache[$value['uid']] = $account->getById($value['uid']);
					}
					$rs[$key]['username'] = $account_cache[$value['uid']]['username'];
				}
				$rs[$key]['createdate'] = formatDate('Y-m-d H:i:s', $rs[$key]['createdate']);
				$rs[$key]['modifieddate'] = formatDate('Y-m-d H:i:s', $rs[$key]['modifieddate']);
			}
			unset($cate, $cate_cache, $account, $account_cache);
		}
		return array('total' => $total, 'data' => $rs);
	}
	/**
	 * ʽ
	 *
	 * @param array $question	
	 * @return array
	 */
	public function format(&$question){
		if($question['cid'] > 0){
			include_once ASK_LIB_PATH . 'AskCategory.class.php';
			$cate = new AskCategory();
			$question['category'] = $cate->getCateCache($question['cid']);
		}
		if($question['uid'] > 0 && !$question['anonymous']){
			include_once LIB_MODULES_PATH . 'account/Account.class.php';
			$account = new Account();
			$question['user'] = $account->getById($question['uid']);
			include_once ASK_LIB_PATH.'AskScore.class.php';
			$score = new AskScore();
			$question['user']['score'] = $score->getScoreByUid($question['uid']);
			$question['user']['exp'] = $score->getExpByUid($question['uid']);
			include_once ASK_LIB_PATH.'Actor.class.php';
			$actor = new Actor();
			$question['user']['actor'] = $actor->getActorByScore($question['user']['exp']['exp']);
			include_once ASK_LIB_PATH.'AskAccount.class.php';
			$account = new AskAccount();
			$question['user']['account'] = $account->getByUid($question['uid']);
			unset($account,$score,$actor);
		}else{
			$question['user'] = array('username' => '');
		}
		global $_QUESTION_STATUS_TEXT;
		$question['status_text'] = $_QUESTION_STATUS_TEXT[$question['status']];
		$vote = $_GET['vote'];
		if($question['answernumber'] > 0 && EXCMS_SESSION_UID > 0){
			include_once ASK_LIB_PATH.'Answer.class.php';
			$answer = new Answer();
			$question['myanswer'] = $answer->isAnswerByQid($question['qid'], EXCMS_SESSION_UID);
		}
		// ظ״̬Ϊδ
		$flag = $question['status'] == 1 || $question['status'] == 2;
		// ǰûǷ
		$question['is_author'] = $is_question_author = $question['uid'] == EXCMS_SESSION_UID;
		$question['displayanswer'] = $flag && !$is_question_author && !$question['myanswer'];
		$question['adopt'] = $flag && !$vote && $is_question_author;
		$question['displayvote'] = $flag && $vote && $is_question_author;
		$question['solved'] = $question['status'] == 3;
		$question['vote'] = $question['status'] == 5;
		$question['finishtime'] = get_formatted_timediff($question['solveddate']);
	}
	/**
	 * ûԴ
	 *
	 * @param integer $uid
	 * @param integer $fromuid
	 * @param integer $qid
	 */
	public function insertFromUid($uid,$fromuid,$qid){
		if(!($uid > 0)){
			throw_exception('LACK_PARAM_UID');
		}
		if(!($qid > 0)){
			throw_exception('ASK_QUESTIONS_LACK_ID');
		}
		$fromuid = implode(',', $fromuid);
		$sql = "INSERT INTO `{$this->fromuid_table}` (`uid`,`fromuid`,`qid`) VALUES('{$uid}','{$fromuid}','{$qid}')";
		return $GLOBALS['db']->query($sql);
	}
	/**
	 * ûIDɾӦϵ
	 *
	 * @param integer $uid
	 * @return boolean
	 */
	public function deleteByUid($uid){
		$uid = EXCMS::convertToIntArray($uid);
		if($uid === false){
			throw_exception('LACK_PARAM_UID');
		}
		$sql = "DELETE FROM {$this->fromuid_table} WHERE `uid` ='{$uid}' ";
		return $GLOBALS['db']->query($sql);
	}
	/**
	 * ûIDɾӦϵ
	 *
	 * @param integer $fromuid
	 * @return boolean
	 */
	public function deleteByFromUid($fromuid){
		$fromuid = EXCMS::convertToIntArray($fromuid);
		if($fromuid === false){
			throw_exception('LACK_PARAM_UID');
		}
		$sql = "DELETE FROM {$this->fromuid_table} WHERE `fromuid` ='{$fromuid}' ";
		return $GLOBALS['db']->query($sql);
	}
	/**
	 * IDɾӦϵ
	 *
	 * @param integer $qid
	 * @return boolean
	 */
	public function deleteByQid($qid){
		$qid = EXCMS::convertToIntArray($qid);
		if($qid === false){
			throw_exception('ASK_QUESTIONS_LACK_ID');
		}
		$sql = "DELETE FROM {$this->fromuid_table} WHERE `qid` ='{$qid}' ";
		return $GLOBALS['db']->query($sql);
	}
	/**
	 * ǰ
	 *
	 * @param integer $fromuid	ûID
	 * @param integer $qid	ID
	 * @param boolean $status	״̬
	 * 
	 * @return boolean
	 */
	public function updateSolve($fromuid,$qid,$status=true){
		$qid = EXCMS::convertToIntArray($qid);
		if($qid === false){
			throw_exception('ASK_QUESTIONS_LACK_ID');
		}
		$qid = implode("','",$qid);
		$status = $status ? 1 : 2;
		$sql = "UPDATE `{$this->fromuid_table}` SET `status`='{$status}' WHERE `qid` IN('{$qid}') AND `fromuid` = '{$fromuid}'";
		return $GLOBALS['db']->query($sql);
	}
}

// excms file end