 <?php
	/**
	 * Project:		EXCMS: the PHP content management system.
	 * File:		AskQuestionList.class.php
	 *
	 * A product of PUTOYO Inc.
	 * 
	 * EXCMS is a ten million data-level,high speed,human-based content management system.
	 *
	 * EX is Excellence & Express & Exceed & Expert.
	 * 
	 * For questions, help, comments, discussion, please join the
	 * EXCMS mailing list. Send a blank e-mail to
	 * join@excms.cn
	 * or join the EXCMS forum
	 * www.excms.cn/forum
	 * 
	 * @link http://www.excms.cn/
	 * @copyright Copyright (c) 2010 PUTOYO Inc.
	 * @license http://www.excms.cn/licenses/LICENSE-1.0
	 * @category EXCMS
	 * @package ask
	 * @author $Author: zhanghaisong $
	 * @version $Rev: 2220 $
	 */
	/* $Id: AskQuestionList.class.php 2220 2010-08-13 08:22:17Z zhanghaisong $ */
	/**
	 * EXCMS бǩ
	 * @category EXCMS
	 * @package ask
	 * @author $Author: zhanghaisong $
	 */
	class AskQuestionList{
		/**
		 * 
		 *
		 * @var integer
		 */
		private $cid;
		/**
		 * 
		 *
		 * @var string
		 */
		private $type;
		/**
		 * ǷǾ
		 *
		 * @var boolean
		 */
		private $elite;
		/**
		 * pending:⡢solved:ѽexpired:voteͶƱcloseرofferurgent:hotelitemyhelpҵzeroش
		 *
		 * @var integer
		 */
		private $status = array('pending', 'solved', 'offer', 'urgent', 'hot', 'elite', 'expired', 'vote', 'close', 'myhelp', 'zero');
		/**
		 * ؼ ؼ","
		 *
		 * @var string
		 */
		private $keyword;
		/**
		 * ǷΪ
		 *
		 * @var boolean
		 */
		private $anonymous;
		/**
		 * ǷΪ
		 *
		 * @var boolean
		 */
		private $urgent;
		/**
		 * ֶ
		 *
		 * @var string
		 */
		private $orderby;
		/**
		 * ʽ
		 *
		 * @var string
		 */
		private $orderway;
		/**
		 * ʾ
		 *
		 * @var integer
		 */
		private $row;
		/**
		 * ҳ
		 * 
		 * @var string
		 */
		private $limit;
		/**
		 * ҳС
		 *
		 * @var integer
		 */
		private $pagesize;
		/**
		 * ǰҳ
		 *
		 * @var integer
		 */
		private $pageon = 1;
		/**
		 * ûID
		 *
		 * @var integer
		 */
		private $uid;
		/**
		 * ûID
		 *
		 * @var integer
		 */
		private $quid;
		/**
		 * 
		 *
		 * @var boolean
		 */
		private $qstatus;
		/**
		 * ״̬
		 *
		 * @var 
		 */
		private $checked;
		/**
		 * 
		 *
		 * @var array
		 */
		private $where = array();
		public function setCid($cid){
			$this->cid = $cid;
		}
		public function setElite($elite){
			$this->elite = $elite ? true : false;
		}
		public function setKeyword($keyword){
			$this->keyword = $keyword;
		}
		public function setAnonymous($anonymous){
			$this->anonymous = $anonymous;
		}
		public function setUrgent($urgent){
			$this->urgent = $urgent;
		}
		public function setOrderby($orderby){
			$this->orderby = $orderby;
		}
		public function setOrderway($orderway){
			$this->orderway = $orderway;
		}
		public function setLimit($limit){
			$this->limit = $limit;
		}
		public function setRow($row){
			$this->row = $row;
		}
		public function setPagesize($pagesize){
			$this->pagesize = $pagesize;
		}
		public function setUid($uid){
			$this->uid = (int)$uid;
		}
		public function setType($type){
			$this->type = $type;
		}
		public function setChecked($checked){
			$this->checked = $checked;
		}
		public function setQuid($quid){
			$this->quid = $quid;
		}
		public function setQstatus($qstatus){
			$this->qstatus = $qstatus;
		}
		public function setWord($word = ''){
			$word = trim($word);
			$this->word = $word ? $word : false;
		}
		/**
		 * ȡID
		 *
		 * @return integer
		 */
		public function getCid(){
			$cid = EXCMS::convertToIntArray($this->cid);
			if(is_array($cid)){
				$count = count($cid);
				if($count > 1){
					$cidstr = implode("','", $cid);
					$this->where['cid'] = "AND `cid` IN('{$cidstr}')";
				}elseif($count == 1){
					$this->where['cid'] = "AND `cid` = '{$cid[0]}'";
				}
			}
			return $this->cid;
		}
		/**
		 * ǷǾ
		 *
		 * @return boolean
		 */
		public function getElite(){
			if($this->elite){
				$this->where['elite'] = "AND `elite` = '1' ";
			}
			return $this->elite;
		}
		/**
		 * ȡǷΪ
		 *
		 * @return boolean
		 */
		public function getAnonymous(){
			if(isset($this->anonymous) && $this->anonymous !== ''){
				if(empty($this->anonymous)){
					$this->where['anonymous'] = "AND `anonymous` = '0' ";
				}else{
					$this->where['anonymous'] = "AND `anonymous` = '1' ";
				}
			}
			return $this->anonymous;
		}
		/**
		 * ȡǷΪ
		 *
		 * @return boolean
		 */
		public function getUrgent(){
			if(isset($this->urgent) && $this->urgent !== ''){
				if(empty($this->urgent)){
					$this->where['urgent'] = "AND `urgent` = '0' ";
				}else{
					$this->where['urgent'] = "AND `urgent` = '1' ";
				}
			}
			return $this->urgent;
		}
		/**
		 * ȡؼ
		 *
		 * @return string
		 */
		public function getKeyword(){
			if($this->keyword){
				$this->where['keyword'] = " AND title like '%{$this->keyword}%' ";
			}
			return $this->keyword;
		}
		/**
		 * ȡҳ
		 *
		 */
		public function getLimit(){
			if(isset($this->limit) && !empty($this->limit)){
				$this->limit = explode(',', trim($this->limit));
				$this->limit[0] = (int)$this->limit[0];
				$this->limit[1] = isset($this->limit[1]) && (int)$this->limit[1] ? (int)$this->limit[1] : $this->row;
				$this->limit = "limit " . $this->limit[0] . "," . $this->limit[1];
			}else if(isset($this->row) && !empty($this->row)){
				$this->limit = "limit " . $this->row;
			}else{
				$this->limit = "limit " . $this->getPagesize() * ($this->pageon - 1) . "," . $this->getPagesize();
			}
			return $this->limit;
		}
		/**
		 * ȡݷҳС ĬΪ10
		 *
		 * @return integer
		 */
		public function getPagesize(){
			if($this->pagesize == "" || $this->pagesize <= 0 || $this->pagesize == null) return 10;
			return $this->pagesize;
		}
		public function getUid(){
			if($this->uid > 0){
				$this->where['uid'] = " AND `uid` = '{$this->uid}' ";
			}
			return $this->uid;
		}
		/**
		 * ȡ
		 *
		 * @return string
		 */
		public function getType(){
			$types = explode(',', $this->type);
			foreach($types as $value){
				if(in_array($value, $this->status)){
					switch($value){
						//ѽ
						case 'solved' :
							$this->where['status'] = "AND `status` =  '3' ";
							break;
						//
						case 'offer' :
							$this->where['score'] = "AND `score` > '0' ";
							$this->setOrderby('score');
							$this->setOrderway('desc');
							break;
						//
						case 'urgent' :
							$this->setUrgent(true);
							break;
						//
						case 'hot' :
							$this->setOrderby('hot');
							$this->setOrderway('desc');
							break;
						//
						case 'elite' :
							$this->setElite(true);
							break;
						//ѹ
						case 'expired' :
							$this->where['status'] = "AND `status` =  '4' ";
							break;
						//ͶƱ
						case 'vote' :
							$this->where['status'] = "AND `status` =  '5' ";
							break;
						//ش
						case 'zero' :
							$this->where['zero'] = " AND `answernumber` = '0' ";
							break;
						//ر
						case 'close' :
							$this->where['status'] = "AND `status` =  '6' ";
							break;
						case 'myhelp' :
							$this->where['myhelp'] = $this->getMyHelp($this->getUid());
							break;
						//
						case 'pending' :
						default :
							$this->where['status'] = "AND `status` =  '2' ";
							break;
					}
				}
			}
		}
		/**
		 * ȡҵ
		 *
		 * @param integer $uid	ûID
		 * @return string
		 */
		private function getMyHelp($uid){
			$sql = "SELECT `qid` FROM `" . TABLE_PREFIX . "ask_from_uid` WHERE `uid` = '{$uid}' ";
			$GLOBALS['db']->query($sql);
			$quid_array = $GLOBALS['db']->fetchAll();
			if(is_array($quid_array) && count($quid_array) > 0){
				foreach($quid_array as $value){
					$qids .= $value['qid'] . ',';
				}
				return " AND `qid` IN('" . substr($qids, 0, strlen($qids) - 1) . "')";
			}else
				return " AND `qid` = '' ";
		}
		/**
		 * ȡյش״̬
		 *
		 * @return string
		 */
		public function getQstatus(){
			$quid = $this->getQuid();
			if($quid > 0){
				$sql = "SELECT `qid` FROM `" . TABLE_PREFIX . "ask_from_uid` WHERE `fromuid` = '{$quid}' ";
			}
			if(in_array($this->qstatus, array('pending', 'solved', 'noanswer'))){
				switch($this->qstatus){
					case 'pending' :
						$status = 0;
						break;
					case 'solved' :
						$status = 1;
						break;
					case 'noanswer' :
						$status = 2;
						break;
				}
				$sql = "SELECT `qid` FROM `" . TABLE_PREFIX . "ask_from_uid` WHERE `fromuid` = '{$quid}' AND `status` = '{$status}' ";
			}
			if($sql != ''){
				$GLOBALS['db']->query($sql);
				$quid_array = $GLOBALS['db']->fetchAll();
				if(is_array($quid_array) && count($quid_array) > 0){
					foreach($quid_array as $value){
						$qids .= $value['qid'] . "','";
					}
					$this->where['qstatus'] = " AND `qid` IN('" . substr($qids, 0, strlen($qids) - 3) . "')";
				}else
					$this->where['qstatus'] = " AND `qid` = '' ";
			}
			return $this->qstatus;
		}
		/**
		 * ȡ
		 *
		 * @return string
		 */
		public function getOrderBy(){
			$orderbyArr = explode(',', trim($this->orderby));
			$orderwayArr = explode(',', trim($this->orderway));
			$order = ' order by ';
			$seprator = ' ';
			foreach($orderbyArr as $k => $v){
				switch($v){
					//ͷ 
					case 'score' :
						$order .= $seprator . ((isset($orderwayArr[$k]) && $orderwayArr[$k] == "asc") ? "score asc" : "score desc");
						break;
					//
					case 'hot' :
						$order .= $seprator . ((isset($orderwayArr[$k]) && $orderwayArr[$k] == "asc") ? "hot asc" : "hot desc");
						break;
					//ʱ
					case 'createdate' :
						$order .= $seprator . ((isset($orderwayArr[$k]) && $orderwayArr[$k] == "asc") ? "createdate asc" : "createdate desc");
						break;
					//ش
					case 'answernumber' :
						$order .= $seprator . ((isset($orderwayArr[$k]) && $orderwayArr[$k] == "asc") ? "answernumber asc" : "answernumber desc");
						break;
					default :
						$order .= " createdate desc";
				}
				$seprator = ",";
			}
			return $order;
		}
		/**
		 * ȡ״̬
		 *
		 * @return string
		 */
		public function getChecked(){
			if(isset($this->checked) && $this->checked !== ''){
				if(empty($this->checked)){
					$this->where['checked'] = " AND `checked` = '0'";
				}else{
					$this->where['checked'] = " AND `checked` = '1'";
				}
			}else{
				$this->where['checked'] = " AND `checked` = '2'";
			}
			return $this->checked;
		}
		/**
		 * ȡID
		 *
		 * @return integer
		 */
		public function getQuid(){
			return (int)$this->quid;
		}
		public function getWord(){
			if($this->word !== false) $this->where['word'] = " AND `title` LIKE '%" . $this->word . "%'";
		}
		/**
		 * ȡѯ
		 *
		 * @return string
		 */
		private function getWhere(){
			$this->getQstatus();
			$this->getCid();
			$this->getKeyword();
			$this->getAnonymous();
			$this->getUid();
			$this->getType();
			$this->getUrgent();
			$this->getElite();
			$this->getChecked();
			$this->getWord();
			return join(' ', $this->where);
		}
		/**
		 * ȡб
		 *
		 * @param array $array	ֶ
		 * <ul>
		 * <li>$array['cid'] </li>
		 * <li>$array['keyword'] ؼ ؼ","</li>
		 * <li>$array['anonymous'] ǷΪ</li>
		 * <li>$array['urgent'] ǷΪ</li>
		 * <li>$array['elite'] ǷǾ </li>
		 * <li>$array['orderby'] ֶ</li>
		 * <li>$array['orderway'] ʽ</li>
		 * <li>$array['row'] ʾ </li>
		 * <li>$array['limit'] ȡΧڵļ¼ </li>
		 * <li>$array['pagesize'] ҳС </li>
		 * </ul> 
		 * @return array	б
		 * <ul> 
		 * <li> $array['from'] б </li>
		 * <li> $array['item']  </li>
		 * <li> $array['pager'] ҳ </li>
		 */
		public function getAskQuestionList($array){
			global $_PAGE, $_QUESTION_STATUS_TEXT;
			//ò
			$this->setCid($array['cid']);
			$this->setKeyword($array['keyword']);
			$this->setAnonymous($array['anonymous']);
			$this->setUrgent($array['urgent']);
			$this->setElite($array['elite']);
			$this->setUid($array['uid']);
			$this->setQuid($array['quid']);
			$this->setQstatus($array['qstatus']);
			$this->setType($array['type']);
			$this->setOrderby($array['orderby']);
			$this->setOrderway($array['orderway']);
			$this->setRow($array['row']);
			$this->setChecked($array['checked']);
			$this->setLimit($array['limit']);
			$this->setPagesize($array['pagesize']);
			$this->setWord($array['word']);
			$fields = explode(',', $array['fields']);
			$stat = empty($array['limit']) && empty($array['row']);
			unset($array);
			//ʼ
			$this->pageon = max($_PAGE['page'], 1);
			//ͳ
			$wherestr = $this->getWhere();
			if($stat){
				$sql = "SELECT COUNT(*) as total FROM " . TABLE_PREFIX . "ask_questions WHERE 1 {$wherestr} ";
				$GLOBALS['db']->query($sql);
				$total = $GLOBALS['db']->fetch();
				$total = $total['total'];
			}
			//ѯ
			if($total > 0 || !$stat){
				$table = TABLE_PREFIX . 'ask_questions';
				$sql = "SELECT * FROM `{$table}` WHERE 1 {$wherestr} {$this->getOrderBy()} {$this->getLimit()}";
				$GLOBALS['db']->query($sql);
				$ask_array = $GLOBALS['db']->fetchAll();
			}else{
				return null;
			}
			if(is_array($ask_array) && count($ask_array) > 0){
				include_once LIB_PATH . 'update/ContentFunction.class.php';
				if(in_array('category', $fields)){
					include_once ASK_LIB_PATH . 'AskCategory.class.php';
					$ask_cate = new AskCategory();
					$category_array = $ask_cate->getCateCache();
					unset($ask_cate);
				}
				if(in_array('user', $fields)){
					include_once LIB_MODULES_PATH . 'account/Account.class.php';
					$account = new Account();
				}
				if(in_array('useraccount', $fields)){
					include_once ASK_LIB_PATH.'AskAccount.class.php';
					$askaccount = new AskAccount();
				}
				if(in_array('useractor', $fields) || in_array('userscore', $fields) || in_array('userexp', $fields)){
					include_once ASK_LIB_PATH.'AskScore.class.php';
					$score = new AskScore();
					if(in_array('useractor', $fields)){
						include_once ASK_LIB_PATH.'Actor.class.php';
						$actor = new Actor();
					}
				}
				foreach($ask_array as $key => $value){
					$ask_array[$key]['url'] = EXCMS::url(array('name' => 'ask.question', 'id' => $value['qid']));
					if(in_array('category', $fields) && $value['cid'] > 0){
						$ask_array[$key]['category'] = $category_array[$value['cid']];
					}
					$ask_array[$key]['statusname'] = $_QUESTION_STATUS_TEXT[$value['status']];
					$ask_array[$key]['asktime'] = timeformat($value['createdate'], 'nj H:i');
					if($value['uid'] > 0){
						if(in_array('useractor', $fields) || in_array('userexp', $fields)){
							$ask_array[$key]['userexp'] = $score->getExpByUid($value['uid']);
							if(in_array('useractor', $fields)){
								$ask_array[$key]['useractor'] = $actor->getActorByScore($ask_array[$key]['userexp']['exp']);
							}
						}
						if(in_array('userscore', $fields)){
							$ask_array[$key]['userscore'] = $score->getScoreByUid($value['uid']);
						}
						if(in_array('useraccount', $fields)){
							$ask_array[$key]['useraccount'] = $askaccount->getByUid($value['uid']);
						}
					}
					if(in_array('user', $fields) && $value['uid'] > 0 && !$value['anonymous']){
						$ask_array[$key]['user'] = $account->getById($value['uid']);
					}else{
						$ask_array[$key]['user'] = array('username' => '');
					}
				}
				$result = array('from' => &$ask_array, 'item' => array('total' => $total), 'pager' => array('total' => $total, 'pagesize' => $this->getPagesize(), 'dynamic' => true, 'pageon' => $_PAGE['page'], 'encodepage' => 'nocode'));
			}else{
				$result = null;
			}
			return $result;
		}
	}

// excms file end