 <?php
	/**
	 * Project:		EXCMS: the PHP content management system.
	 * File:		AskScoreList.class.php
	 *
	 * A product of PUTOYO Inc.
	 * 
	 * EXCMS is a ten million data-level,high speed,human-based content management system.
	 *
	 * EX is Excellence & Express & Exceed & Expert.
	 * 
	 * For questions, help, comments, discussion, please join the
	 * EXCMS mailing list. Send a blank e-mail to
	 * join@excms.cn
	 * or join the EXCMS forum
	 * www.excms.cn/forum
	 * 
	 * @link http://www.excms.cn/
	 * @copyright Copyright (c) 2010 PUTOYO Inc.
	 * @license http://www.excms.cn/licenses/LICENSE-1.0
	 * @category EXCMS
	 * @package ask
	 * @author $Author: zhanghaisong $
	 * @version $Rev: 1847 $
	 */
	/* $Id: AskScoreList.class.php 1847 2010-07-01 03:20:24Z zhanghaisong $ */
	/**
	 * EXCMS ûб
	 * @category EXCMS
	 * @package ask
	 * @author $Author: zhanghaisong $
	 */
	class AskScoreList{
		/**
		 * û
		 *
		 * @var string
		 */
		private $username;
		/**
		 * зʽ
		 *
		 * @var string
		 */
		private $type;
		/**
		 * ʾ
		 *
		 * @var integer
		 */
		private $row;
		/**
		 * 
		 *
		 * @var array
		 */
		private $sort_type = array('exp', 'exp_week', 'exp_month', 'exp_year');
		public function __construct(){}
		public function setUsername($username){
			$this->username = $username;
		}
		public function getUsername(){
			return $this->username;
		}
		public function setType($type){
			$this->type = $type;
		}
		public function getType(){
			if(!in_array($type, $this->sort_type)){
				$this->type = 'exp';
			}
			return $this->type;
		}
		public function setRow($row){
			$this->row = (int)$row;
		}
		public function getRow(){
			return $this->row > 0 && $this->row < 1000 ? $this->row : 10;
		}
		/**
		 * ȡASKб
		 *
		 * @return array
		 */
		public function getAskScoreList($array){
			$this->setUsername($array['username']);
			$this->setType($array['type']);
			$username = $this->getUsername();
			$type = $this->getType();
			$fields = explode(',', $array['fields']);
			if($username){
				include_once LIB_MODULES_PATH . 'account/Account.class.php';
				$account = new Account();
				$user_array = $account->getByName($username);
				unset($user_array['password']);
				if(is_array($user_array) && count($user_array) > 0 && $user_array['checked'] && $user_array['enabled']){
					include_once ASK_LIB_PATH.'AskScore.class.php';
					$score = new AskScore();
					$rs = $score->getExpByUid($user_array['uid']);
					$rs['url'] = EXCMS::url(array('name' => 'ask.myquestion', 'uid' => $user_array['uid']));
					if(count($rs) > 0){
						include_once ASK_LIB_PATH.'Actor.class.php';
						$actor = new Actor();
						$rs['user'] = &$user_array;
						$rs['actor'] = $actor->getActorByScore($rs['exp']);
						return array('from' => $rs);
					}
					return array($user_array);
				}
				return array();
			}
			$sql = "SELECT * FROM " . TABLE_PREFIX . "ask_exp ORDER BY `" . $type . "` DESC LIMIT " . $this->getRow();
			$GLOBALS['db']->query($sql);
			$rs = $GLOBALS['db']->fetchAll();
			if(count($rs) > 0){
				if(in_array('user', $fields)){
					include_once LIB_MODULES_PATH . 'account/Account.class.php';
					$account = new Account();
				}
				if(in_array('actor', $fields)){
					include_once ASK_LIB_PATH.'Actor.class.php';
					$actor = new Actor();
				}
				foreach($rs as $key => $value){
					if($value['uid'] > 0){
						$value['url'] = EXCMS::url(array('name' => 'ask.myquestion', 'uid' => $value['uid']));
						if(in_array('user', $fields)) $rs[$key]['user'] = $account->getById($value['uid']);
						unset($rs[$key]['user']['password']);
						if(in_array('actor', $fields)) $rs[$key]['actor'] = $actor->getActorByScore($value['total']);
					}
				}
			}
			return array('from' => &$rs);
		}
	}

// excms file end