DROP TABLE IF EXISTS `excms_ask_account`;
CREATE TABLE `excms_ask_account` (
  `uid` INT(11) UNSIGNED NOT NULL,
  `level` CHAR(20) DEFAULT NULL,
  `question` INT(11) DEFAULT NULL,
  `question_elite` INT(11) DEFAULT NULL,
  `answer` INT(11) DEFAULT NULL,
  `answer_best` INT(11) DEFAULT NULL,
  `answer_elite` INT(11) DEFAULT NULL,
  `adopt` FLOAT DEFAULT NULL,
  `favorable` INT(11) DEFAULT NULL
) ENGINE=MYISAM DEFAULT CHARSET=gbk;

DROP TABLE IF EXISTS `excms_ask_actor`;
CREATE TABLE `excms_ask_actor` (
  `id` SMALLINT(4) UNSIGNED NOT NULL AUTO_INCREMENT,
  `catename` CHAR(50) DEFAULT NULL,
  `grade` CHAR(20) DEFAULT NULL,
  `name` CHAR(40) DEFAULT NULL,
  `min` INT(11) DEFAULT '0',
  `max` INT(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MYISAM AUTO_INCREMENT=21 DEFAULT CHARSET=gbk;

INSERT INTO `excms_ask_actor` VALUES ('1','ƾϵ','1','ͯ','0','80');
INSERT INTO `excms_ask_actor` VALUES ('2','ϵ','2','','81','400');
INSERT INTO `excms_ask_actor` VALUES ('3','ƾϵ','3','','401','800');
INSERT INTO `excms_ask_actor` VALUES ('4','ƾϵ','4','','801','2000');
INSERT INTO `excms_ask_actor` VALUES ('5','ƾϵ','5','Ԫ','2001','4000');
INSERT INTO `excms_ask_actor` VALUES ('6','ƾϵ','6','ʿ','4001','7000');
INSERT INTO `excms_ask_actor` VALUES ('7','ƾϵ','7','Ԫ','7001','10000');
INSERT INTO `excms_ask_actor` VALUES ('8','ƾϵ','8','ͬʿ','10001','14000');
INSERT INTO `excms_ask_actor` VALUES ('9','ƾϵ','9','ʿ','14001','18000');
INSERT INTO `excms_ask_actor` VALUES ('10','ƾϵ','10','̽','18001','22000');
INSERT INTO `excms_ask_actor` VALUES ('11','ƾϵ','11','','22001','32000');
INSERT INTO `excms_ask_actor` VALUES ('12','ƾϵ','12','״Ԫ','32001','45000');
INSERT INTO `excms_ask_actor` VALUES ('13','ƾϵ','13','','45001','60000');
INSERT INTO `excms_ask_actor` VALUES ('14','ƾϵ','14','ة','60001','100000');
INSERT INTO `excms_ask_actor` VALUES ('15','ƾϵ','15','ѧʿ','100001','150000');
INSERT INTO `excms_ask_actor` VALUES ('16','ƾϵ','16','ʷة','150001','250000');
INSERT INTO `excms_ask_actor` VALUES ('17','ƾϵ','17','ղʿ','250001','400000');
INSERT INTO `excms_ask_actor` VALUES ('18','ƾϵ','18','','400001','700000');
INSERT INTO `excms_ask_actor` VALUES ('19','ƾϵ','19','ѧʿ','700001','1000000');
INSERT INTO `excms_ask_actor` VALUES ('20','ƾϵ','20','','1000001','0');

DROP TABLE IF EXISTS `excms_ask_answers`;
CREATE TABLE `excms_ask_answers` (
  `aid` INT(11) UNSIGNED NOT NULL AUTO_INCREMENT,
  `qid` INT(11) NOT NULL,
  `cid` MEDIUMINT(5) NOT NULL,
  `checked` TINYINT(1) NOT NULL DEFAULT '0',
  `ishidden` TINYINT(1) NOT NULL DEFAULT '0',
  `isbest` TINYINT(1) NOT NULL DEFAULT '0',
  `content` TEXT,
  `anonymous` TINYINT(1) NOT NULL DEFAULT '0',
  `vote` TINYINT(1) DEFAULT '0',
  `votecount` INT(11) NOT NULL DEFAULT '0',
  `uid` INT(11) DEFAULT NULL,
  `append` TINYINT(1) UNSIGNED DEFAULT '0',
  `ip` CHAR(15) DEFAULT NULL,
  `createdate` INT(11) DEFAULT NULL,
  `modifieddate` INT(11) DEFAULT NULL,
  PRIMARY KEY (`aid`)
) ENGINE=MYISAM DEFAULT CHARSET=gbk;
DROP TABLE IF EXISTS `excms_ask_answers_append`;
CREATE TABLE `excms_ask_answers_append` (
  `id` INT(11) NOT NULL AUTO_INCREMENT,
  `aid` INT(11) DEFAULT NULL,
  `type` TINYINT(1) DEFAULT '0',
  `content` TEXT,
  `date` INT(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MYISAM DEFAULT CHARSET=gbk;
DROP TABLE IF EXISTS `excms_ask_answers_comment`;
CREATE TABLE `excms_ask_answers_comment` (
  `qid` INT(11) DEFAULT NULL,
  `aid` INT(11) DEFAULT NULL,
  `solveoption` TINYINT(1) DEFAULT NULL,
  `yuanchuang` TINYINT(1) DEFAULT NULL,
  `sudu` TINYINT(1) DEFAULT NULL,
  `taidu` TINYINT(1) DEFAULT NULL,
  `comment` VARCHAR(100) DEFAULT NULL
) ENGINE=MYISAM DEFAULT CHARSET=gbk;
DROP TABLE IF EXISTS `excms_ask_category`;
CREATE TABLE `excms_ask_category` (
  `cid` MEDIUMINT(5) UNSIGNED NOT NULL AUTO_INCREMENT,
  `pid` MEDIUMINT(5) UNSIGNED NOT NULL DEFAULT '0',
  `name` CHAR(40) NOT NULL,
  `type` TINYINT(1) UNSIGNED DEFAULT '0',
  `childnum` SMALLINT(2) DEFAULT '0',
  `wordgroupnum` TINYINT(1) DEFAULT '0',
  `description` VARCHAR(250) DEFAULT NULL,
  `asknumber` INT(11) UNSIGNED NOT NULL DEFAULT '0',
  `questioncheck` TINYINT(1) UNSIGNED NOT NULL DEFAULT '2',
  `answercheck` TINYINT(1) DEFAULT '0',
  `sort` INT(11) DEFAULT '50',
  PRIMARY KEY (`cid`)
) ENGINE=MYISAM DEFAULT CHARSET=gbk;
DROP TABLE IF EXISTS `excms_ask_exp`;
CREATE TABLE `excms_ask_exp` (
  `uid` INT(11) UNSIGNED NOT NULL,
  `exp` INT(11) DEFAULT '0',
  `exp_operate` INT(11) DEFAULT '0',
  `exp_question` INT(11) DEFAULT '0',
  `exp_answer` INT(11) DEFAULT '0',
  `exp_punish` INT(11) DEFAULT '0',
  `exp_other` INT(11) DEFAULT '0',
  `exp_week` INT(11) DEFAULT '0',
  `exp_month` INT(11) DEFAULT '0',
  `exp_year` INT(11) DEFAULT '0',
  `exp_updatetime` INT(11) DEFAULT NULL,
  `exp_question_day` INT(11) DEFAULT '0',
  `exp_answer_day` INT(11) DEFAULT '0',
  `exp_vote_day` INT(11) DEFAULT '0'
) ENGINE=MYISAM DEFAULT CHARSET=gbk;
DROP TABLE IF EXISTS `excms_ask_from_uid`;
CREATE TABLE `excms_ask_from_uid` (
  `uid` INT(11) DEFAULT NULL,
  `fromuid` INT(11) DEFAULT NULL,
  `qid` INT(11) DEFAULT NULL,
  `status` TINYINT(1) DEFAULT '0'
) ENGINE=MYISAM DEFAULT CHARSET=gbk;
DROP TABLE IF EXISTS `excms_ask_questions`;
CREATE TABLE `excms_ask_questions` (
  `qid` INT(11) UNSIGNED NOT NULL AUTO_INCREMENT,
  `cid` MEDIUMINT(5) UNSIGNED DEFAULT NULL,
  `title` CHAR(100) NOT NULL,
  `content` TEXT,
  `score` TINYINT(2) UNSIGNED DEFAULT '0',
  `hot` INT(11) UNSIGNED DEFAULT '0',
  `checked` TINYINT(1) UNSIGNED DEFAULT '0',
  `elite` TINYINT(1) UNSIGNED DEFAULT '0',
  `status` TINYINT(1) UNSIGNED DEFAULT '2',
  `urgent` TINYINT(1) UNSIGNED DEFAULT '0',
  `anonymous` TINYINT(1) UNSIGNED DEFAULT '0',
  `answernumber` INT(11) UNSIGNED DEFAULT '0',
  `newanswer` TINYINT(1) UNSIGNED DEFAULT '0',
  `uid` INT(11) DEFAULT NULL,
  `ip` CHAR(15) DEFAULT NULL,
  `createdate` INT(11) UNSIGNED DEFAULT NULL,
  `modifieddate` INT(11) UNSIGNED DEFAULT NULL,
  `solveddate` INT(11) UNSIGNED DEFAULT NULL,
  `append` TINYINT(1) UNSIGNED DEFAULT '0',
  `votedate` INT(11) DEFAULT NULL,
  PRIMARY KEY (`qid`)
) ENGINE=MYISAM DEFAULT CHARSET=gbk;
DROP TABLE IF EXISTS `excms_ask_questions_append`;
CREATE TABLE `excms_ask_questions_append` (
  `id` INT(11) NOT NULL AUTO_INCREMENT,
  `qid` INT(11) DEFAULT NULL,
  `content` TEXT,
  `date` INT(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MYISAM DEFAULT CHARSET=gbk;
DROP TABLE IF EXISTS `excms_ask_score`;
CREATE TABLE `excms_ask_score` (
  `uid` INT(11) UNSIGNED NOT NULL AUTO_INCREMENT,
  `score` INT(11) DEFAULT '20',
  `score_operate` INT(11) DEFAULT '0',
  `score_answer` INT(11) DEFAULT '0',
  `score_question` INT(11) DEFAULT '0',
  `score_punish` INT(11) DEFAULT '0',
  `score_other` INT(11) DEFAULT '0',
  `score_question_day` INT(5) DEFAULT '0',
  `score_answer_day` INT(5) DEFAULT '0',
  `score_updatetime` INT(11) DEFAULT NULL,
  `score_vote_day` INT(11) DEFAULT '0',
  PRIMARY KEY (`uid`)
) ENGINE=MYISAM DEFAULT CHARSET=gbk;
DROP TABLE IF EXISTS `excms_ask_score_log`;
CREATE TABLE `excms_ask_score_log` (
  `lid` INT(11) UNSIGNED NOT NULL AUTO_INCREMENT,
  `uid` INT(11) DEFAULT NULL,
  `type` TINYINT(1) DEFAULT NULL,
  `score` INT(5) DEFAULT NULL,
  `log` VARCHAR(100) DEFAULT NULL,
  `createdate` INT(11) DEFAULT NULL,
  PRIMARY KEY (`lid`)
) ENGINE=MYISAM DEFAULT CHARSET=gbk;
DROP TABLE IF EXISTS `excms_ask_setting`;
CREATE TABLE `excms_ask_setting` (
  `uid` INT(11) NOT NULL,
  `question` TINYINT(1) DEFAULT NULL,
  `maxrecord` INT(5) DEFAULT NULL,
  `cid` CHAR(100) DEFAULT NULL,
  `keywords` VARCHAR(500) DEFAULT NULL,
  PRIMARY KEY (`uid`)
) ENGINE=MYISAM DEFAULT CHARSET=gbk;
DROP TABLE IF EXISTS `excms_ask_vote`;
CREATE TABLE `excms_ask_vote` (
  `vid` INT(11) NOT NULL AUTO_INCREMENT,
  `qid` INT(11) DEFAULT NULL,
  `aid` INT(11) DEFAULT NULL,
  `uid` INT(11) DEFAULT NULL,
  `votetime` INT(11) DEFAULT NULL,
  PRIMARY KEY (`vid`)
) ENGINE=MYISAM DEFAULT CHARSET=gbk;

DELETE FROM `excms_url` WHERE `moduleid` = 'ask';
INSERT INTO `excms_url` (`moduleid`,`name`,`url`,`enablerewrite`,`rewrite`,`description`,`issystem`,`sort`) VALUES ('ask','index','/ask/index.php','0','/ask/index.html','ʰҳд','1','50'),('ask','list','ask/list.php?cid={cid}&type={type}&word={word}&page={page}','0','/ask-list-{cid}-{type}-{word}-{page}.html','б(,,ѽ,,ȵ,)','1','50'),('ask','question','/ask/question.php?id={id}','0','/ask/question-{id}.html','ϸϢ','1','50'),('ask','myask','/ask/myask.php?action={action}&status={status}','0','/ask/myask/{action}/{status}','ҵʰ','1','50'),('ask','wen','/ask/wen.php?action={action}','0','/ask/wen-action.html','ҳ','1','50'),('ask','action','/ask/action.php?action={action}','0','/ask/action-{action}.html','ASKûĶ','1','50'),('ask','search','/ask/search.php?word={word}&type={type}&cid={cid}&date={date}&special={special}','0','','','1','50'),('ask','user','/ask/user.php?unumber={unumber}&action={action}&status={status}','0','/ask/user-{unumber}-{action}-{status}.html','ûʴϢ','1','50');
DELETE FROM `excms_system_config` WHERE `moduleid` = 'ask';
INSERT INTO `excms_system_config` (`moduleid`,`name`,`value`,`description`,`group`,`type`,`issystem`,`sort`) VALUES ('ask','name','ʴ','ʴ','ģ','3','1','100'),('ask','question_check','0','ǷҪ','ģ','1','1','100'),('ask','answer_check','0','شǷҪ','ģ','1','1','100'),('ask','search_son','1','Ƿӷ','ģ','1','1','100'),('ask','question_expired_time','15','ʱ,λ:','ģ','2','1','100'),('ask','vote_time','5','ͶƱʱ','ģ','2','1','100'),('ask','question_verifycode','1','ǷҪ֤','ģ','1','1','100'),('ask','answer_verifycode','1','ش֤','ģ','1','1','100'),('ask','question_anonymous_allow','1','Ƿ','ģ','1','1','100'),('ask','answer_anonymous_allow','0','Ƿش','ģ','1','1','100'),('ask','answer_best_allow','2','Ŀ','ģ','2','1','100'),('ask','score_question_anonymous','10','ʿۻ','ģ','2','1','100'),('ask','score_answer_adopt','20','𰸱ɼӻּӦͷ','ģ','2','1','100'),('ask','score_question_expired','20','ʹڿۻ','ģ','2','1','100'),('ask','score_answer_delete','10','شɾش߼10','ģ','2','1','100'),('ask','score_answer_uncheck','10','شδͨ˿۷֣޸ͨ˺󽫷','ģ','2','1','100'),('ask','score_question_delete','20','ʱɾۻ','ģ','2','1','100'),('ask','score_question_uncheck','20','δͨۻּӦͷ (޸ͨ˺󽫷)','ģ','2','1','100'),('ask','score_answer_best_delete','20','𰸱ɾߺṩ߿ۻ','ģ','2','1','100'),('ask','score_question_expired_deal','0','ӻ','ģ','2','1','100'),('ask','score_first_login','20','û״ε½ӻ','ģ','2','1','100'),('ask','score_answer','0','شӻ','ģ','2','1','100'),('ask','score_day_login','0','ÿյһε½ӻ','ģ','2','1','100'),('ask','score_question','2','ʻȡ','ģ','2','1','100'),('ask','score_answer_elite','10','شѡΪʴ𰸼ӻ','ģ','2','1','100'),('ask','score_answer_recommend','10','شѡΪƼ𰸼ӻ','ģ','2','1','100'),('ask','score_vote','0','ͶƱӻ','ģ','2','1','100'),('ask','score_question_day_max','20','ÿɻ','ģ','2','1','100'),('ask','score_answer_day_max','20','شÿɻû','ģ','2','1','100'),('ask','score_question_elite','0','ʱѡ񾫲ʼӻ','ģ','2','1','100'),('ask','score_expired_to_vote','20','תͶƱۻ','ģ','2','1','100'),('ask','score_questoin_ugrent','20','ۻ','ģ','2','1','100'),('ask','score_question_direct','2','ֱĳʰ˴οۻ','ģ','2','1','100'),('ask','score_vote_day_max','0','ÿͶƱɻ','ģ','2','1','100'),('ask','exp_day_login','2','ÿյһε½Ӿֵ','ģ','2','1','100'),('ask','exp_first_login','20','û״ε½Ӿֵ','ģ','2','1','100'),('ask','exp_question','0','ʻþֵ','ģ','2','1','100'),('ask','exp_answer','2','ش⽱ֵ','ģ','2','1','100'),('ask','exp_answer_day_max','10','شÿɻֵ','ģ','2','1','100'),('ask','exp_question_anonymous','0','ʿ۾ֵ','ģ','2','1','100'),('ask','exp_question_delete','10','ʱɾ۾ֵ','ģ','2','1','100'),('ask','exp_question_expired','0','ʹڿ۾','ģ','2','1','100'),('ask','exp_question_uncheck','20','δ˿۾ֵ','ģ','2','1','100'),('ask','exp_question_day_max','20','ÿɻֵ','ģ','2','1','100'),('ask','exp_answer_delete','20','شɾ۾ֵ','ģ','2','1','100'),('ask','exp_answer_uncheck','20','شδͨ˿۾ֵ','ģ','2','1','100'),('ask','exp_answer_adopt','20','ش𱻲ɼӾֵ','ģ','2','1','100'),('ask','exp_answer_best_delete','20','𰸱ɾߺṩ߿۾ֵ','ģ','2','1','100'),('ask','exp_answer_elite','10','شѡΪʴ𰸼Ӿֵ','ģ','2','1','100'),('ask','exp_answer_recommend','10','شƼشӾֵ','ģ','2','1','100'),('ask','exp_question_expired_deal','10','ʼӾֵ','ģ','2','1','100'),('ask','exp_expired_to_vote','0','תͶƱ۾ֵ','ģ','2','1','100'),('ask','exp_questoin_ugrent','0','۾ֵ','ģ','2','1','100'),('ask','exp_question_direct','0','ֱĳʰ˴ο۾ֵ','ģ','2','1','100'),('ask','exp_vote','2','ͶƱӾֵ','ģ','2','1','100'),('ask','exp_question_elite','10','ʼӾֵ','ģ','2','1','100'),('ask','exp_vote_day_max','20','ÿͶƱɻ','ģ','2','1','100');
DELETE FROM `excms_modules_action` WHERE `module` = 'ask';
INSERT INTO `excms_modules_action` (`actionname`,`module`,`class`,`action`,`params`) VALUES ('ask.questionlist','ask','AskQuestionList','getAskQuestionList','tagparam'),('ask.answerlist','ask','AskAnswerList','getAskAnswerList','tagparam'),('ask.catelist','ask','AskCateList','getAskCateList','tagparam'),('ask.cate','ask','AskCateList','getAskCate','tagparam'),('ask.searchpagelist','ask','AskSearch','getAskSearch','tagparam'),('ask.search','ask','AskQuestion','getByQid','qid'),('ask.askscorelist','ask','AskScoreList','getAskScoreList','tagparam'),('ask.appendlist','ask','AskAppendList','getAskAppendList','tagparam');