<?php
/**
 * Project:		EXCMS: the PHP content management system.
 * File:		myask.php
 *
 * A product of PUTOYO Inc.
 * 
 * EXCMS is a ten million data-level,high speed,human-based content management system.
 *
 * EX is Excellence & Express & Exceed & Expert.
 * 
 * For questions, help, comments, discussion, please join the
 * EXCMS mailing list. Send a blank e-mail to
 * join@excms.cn
 * or join the EXCMS forum
 * www.excms.cn/forum
 * 
 * @link http://www.excms.cn/
 * @copyright Copyright (c) 2010 PUTOYO Inc.
 * @license http://www.excms.cn/licenses/LICENSE-1.0
 * @category EXCMS
 * @package ask
 * @author $Author: zhanghaisong $
 * @version $Rev: 1896 $
 */
 
 /* $Id: index.php 1896 2010-07-18 02:02:46Z zhanghaisong $ */ 
 
 /**
 * ҵʴ
 * @category EXCMS
 * @package ask
 * @author $Author: zhanghaisong $
 */ 
 
//ASKϵͳļƶʱ޸ļ·
require_once ('configuration/inc/common.inc.php');

// check user logined
if(!EXCMS_SESSION_UID){
	$forward = urlencode("http://".$_SERVER['SERVER_NAME'].($_SERVER['SERVER_PORT'] ==  80 ? '' : (':'.$_SERVER['SERVER_PORT'])).$_SERVER['REQUEST_URI']);
	header('location:' . EXCMS::url(array('name' => 'account.login', 'forward'=>$forward)));	
	exit;
}

// set page name
$_PAGE['name'] = 'myask';


$_PAGE['action'] = $_GET['action'];

include_once ASK_LIB_PATH.'AskScore.class.php';
$score = new AskScore();
$score_array['score']  = $score->getScoreByUid(EXCMS_SESSION_UID);
if(!is_array($score_array['score']) || count($score_array['score']) < 1){
	$score_array['score'] = array('score'=>0,'score_operate'=>0,'score_answer'=>0,'score_question'=>0,'score_punish'=>0,'score_other'=>0,'score_question_day'=>0,'score_answer_day'=>0,'score_vote_day'=>0);
}
include_once ASK_LIB_PATH.'Actor.class.php';
$actor = new Actor();
$_PAGE_USER['actor'] = $actor->getActorByScore($score_array['score'] ['score']);

include_once ASK_LIB_PATH.'AskAccount.class.php';
$account = new AskAccount();
$account_array['account'] = $account->getByUid(EXCMS_SESSION_UID);
if(!is_array($account_array['account']) || count($account_array['account']) < 1){
	$account_array['account'] = array('question'=>0,'question_elite'=>0,'answer'=>0,'answer_best'=>0,'answer_elite'=>0,'adopt'=>0,'favorable'=>0);
}
$_PAGE_USER = array_merge($account_array,$_PAGE_USER,$score_array);

$_PAGE['status'] = $_GET['status'];	//״̬
switch ($_PAGE['action']){
	// ҵ
	case 'question' :
		$_PAGE['title'] = 'ҵ';
		$tpl = 'my_question.html';
		if($_PAGE['status']=='failed')	$_PAGE['checked'] = true;
		break;
	
	// ҵĻش
	case 'answer' :
		$_PAGE['title'] = 'ҵĻش';
		$tpl = 'my_answer.html';
		switch ($_PAGE['status']){
			case 'best' :$_PAGE['listtype'] = 'best';
				break;
			case 'hidden' :$_PAGE['hidden'] = true;
				break;
			case 'anonymous' :$_PAGE['anonymous'] = true;
				break;
			case 'failed' :	$_PAGE['checked'] = true;
				break;
			default:$_PAGE['hidden'] = false;
				break;
		}
		break;
		
	// յ
	case 'directask' :
		$_PAGE['title'] = 'յ';
		$tpl = 'my_directask.html';
		break;
	
	// ҵϢ
	case 'message' :
		$_PAGE['title'] = 'ҵϢ';
		$tpl = 'my_message.html';
		break;
	// ϸ
	case 'score' :
		$_PAGE['title'] = 'ϸ';
		$tpl = 'my_score.html';
		$_PAGE_USER['exp'] = $score->getExpByUid(EXCMS_SESSION_UID);
		if(!is_array($_PAGE_USER['exp']) || count($_PAGE_USER['exp']) < 1){
			$_PAGE_USER['exp'] = array('exp'=>0,'exp_operate'=>0,'exp_question'=>0,'exp_answer'=>0,'exp_punish'=>0,'exp_other'=>0,'exp_week'=>0,'exp_month'=>0,'exp_year'=>0,'exp_question_day'=>0,'exp_answer_day'=>0,'exp_vote_day'=>0);
		}
		include_once ASK_LIB_PATH . 'AskQuestion.class.php';
		$question = new AskQuestion();
		$_PAGE_USER['account']['questions_solved'] = $question->countSolution(EXCMS_SESSION_UID);
		$_PAGE_USER['account']['questions_pending'] = $question->countPendingNumbere(EXCMS_SESSION_UID);
		$_PAGE_USER['account']['questions_close'] = $question->countClose(EXCMS_SESSION_UID);
		break;
		
	// ҵ
	case 'setting' :
		$_PAGE['title'] = 'ҵ';
		$tpl = 'my_setting.html';
		include_once ASK_LIB_PATH.'AskSetting.class.php';
		$setting = new AskSetting();
		$_PAGE['setting'] = $setting->getByUid(EXCMS_SESSION_UID);
		$cids = explode(',',$_PAGE['setting']['cid']);
		if($_PAGE['setting']['cid']!='' && is_array($cids) && count($cids) > 0){
			include_once ASK_LIB_PATH . 'AskCategory.class.php';
			$cate = new AskCategory();
			foreach ($cids as $value){
				if($value > 0){
					$category_array = $cate->getCateCache($value);
					$_PAGE['setting']['category'] .= '  <a href="'.$cate_array['url'].'">'.$category_array['name'].'</a>';
				}
			}
		}else{
			$_PAGE['setting']['category'] = 'ûùעķ';
		}
		$keywords = explode(',',$_PAGE['setting']['keywords']);
		if($_PAGE['setting']['keywords']!='' && is_array($keywords) && count($keywords) > 0){
			foreach ($keywords as $value){
				$_PAGE['setting']['keywords'] .= " <a href='".EXCMS::url(array('name'=>'ask.search','word'=>$value))."'>".$value."</a>";
			}
		}else{
			$_PAGE['setting']['keywords'] = 'ûùעĹؼ';
		}
		$_PAGE['setting']['maxrecord'] = (int)$_PAGE['setting']['maxrecord'] ? $_PAGE['setting']['maxrecord'] : 5;
		break;
		
	// ҵʴĬҳ
	case 'myask' :
	default:
		$_PAGE['title'] = 'ҵʴ';
		$tpl = 'my_ask.html';
		$_PAGE['action'] = '';
		$_PAGE_USER['exp'] = $score->getExpByUid(EXCMS_SESSION_UID);
		if(!is_array($_PAGE_USER['exp']) || count($_PAGE_USER['exp']) < 1){
			$_PAGE_USER['exp'] = array('exp'=>0,'exp_operate'=>0,'exp_question'=>0,'exp_answer'=>0,'exp_punish'=>0,'exp_other'=>0,'exp_week'=>0,'exp_month'=>0,'exp_year'=>0,'exp_question_day'=>0,'exp_answer_day'=>0,'exp_vote_day'=>0);
		}
		include_once ASK_LIB_PATH.'AskSetting.class.php';
		$setting = new AskSetting();
		$setting_array =  $setting->getByUid(EXCMS_SESSION_UID);
		$_PAGE['cid'] = $setting_array['cid'];
		break;
}
$_PAGE['page'] = $_GET['page'];

// ģ
EXCMS::display("ask/{$tpl}");

// excms file end