<?php
/**
 * Project:		EXCMS: the PHP content management system.
 * File:		comment.php
 *
 * A product of PUTOYO Inc.
 * 
 * EXCMS is a ten million data-level,high speed,human-based content management system.
 *
 * EX is Excellence & Express & Exceed & Expert.
 * 
 * For questions, help, comments, discussion, please join the
 * EXCMS mailing list. Send a blank e-mail to
 * join@excms.cn
 * or join the EXCMS forum
 * www.excms.cn/forum
 * 
 * @link http://www.excms.cn/
 * @copyright Copyright (c) 2010 PUTOYO Inc.
 * @license http://www.excms.cn/licenses/LICENSE-1.0
 * @category EXCMS
 * @author blaster@putoyo.com
 * @version $Rev: 146 $
 */
 
 /* $Id: comment.php 146 2009-11-10 07:58:36Z zhangxuelin $ */ 
 
 /**
  * EXCMS۳
  */

// ϵͳļ
include_once ('configuration/inc/common.inc.php');
//ģ
loadModuleConfig('comment',true);
// ģǷ
if($EXCMS_MODULE['comment'] === false){
	EXCMS::showMessage('ģѽ');
}
$params = array_merge($_GET, $_POST);

//࣬
include_once LIB_MODULES_PATH . 'comment/Comment.class.php';
include_once LIB_MODULES_PATH . 'comment/CommentStat.class.php';
$commentstat = new CommentStat();
$comment = new Comment();

/**
 * ȡҳ
 */
 
// ȡҳ
$action = $params['act'];

// ȡID
$contentid = $params['contentid'] ? $params['contentid'] : $params['id'];

// IDʱ 
$_contentid = $EXCMS_CONFIG['code_contentid'] ? EXCMS::id_decode($contentid) : $contentid;

//ȡID
$commentid = $params['commentid'];

// ȡ۷ҳ

if(isset($_GET['page'])){
	$_PAGE['pageon'] = $_GET['page'];
}

// Ƿص
if(isset($_GET['crossDomainCallback']) && $_GET['crossDomainCallback'] != ''){
	$crossDomainCallback = trim($_GET['crossDomainCallback']);
}
switch($action){
	/**
	 * 
	 */
	case 'getquote' :
		//IDѯϸϢ
		$rs = $comment->getById($params['id']);
		$rs['createddate'] = formatDate('Y-m-d H:i:s',$rs['createddate']);
		echo "[quote]ԭEXCMS{$rs['area']}[{$rs['username']}]{$rs['createddate']}".chr(13)."{$rs['content']}[/quote]";
		break;
	
	/**
	 * ֧
	 */
	case 'support' :
		$_PAGE["comment"] = $comment->getDetailById($params['id']);
		$support = $commentstat->support($_PAGE["comment"]['itemid'],'content');
		$support = $comment->support($params['id']);
		if($crossDomainCallback){
		  echo $crossDomainCallback . "(\"{$support}\")";
		}else{
		  echo $support;
		}
		break;
	
	/**
	 * 
	 */
	case 'against' :
		$_PAGE["comment"] = $comment->getDetailById($params['id']);
		$against = $commentstat->against($_PAGE["comment"]['itemid'],'content');
		$against = $comment->against($params['id']);
		if($crossDomainCallback){
		  echo $crossDomainCallback . "(\"{$against}\")";
		}else{
		  echo $against;
		}
		break;
	
	/**
	 * б
	 */
	case 'commentlist' :
		$_PAGE_CONTENT['_contentid'] = $_contentid;
		$_PAGE_CONTENT['contentid'] = $contentid;
		if($_contentid>0){
			if($crossDomainCallback){
				ob_start();
				EXCMS::display('comment/comment_list.html');
				$comment_list = ob_get_contents();
				ob_clean();
				echo $crossDomainCallback . "(\"" . addslashes(str_replace(array(chr(13), chr(10)), '', $comment_list)) . "\")";
			}else{
				EXCMS::display('comment/comment_list.html');
			}
			
		}
		break;
	// 
	case 'contentcomment' :
		$_PAGE_CONTENT['contentid'] = $contentid;
		$_PAGE_CONTENT['_contentid'] = $_contentid;
		if($_contentid > 0){
			if($crossDomainCallback){
				ob_start();
				EXCMS::display('comment/comment_block.html');
				$comment_list = ob_get_contents();
				ob_clean();
				echo $crossDomainCallback . "(\"" . addslashes(str_replace(array(chr(13), chr(10)), '', $comment_list)) . "\")";
			}else{
				EXCMS::display('comment/comment_block.html');
			}
		}
		break;
	
	/**
	 * Ϣ
	 */
	case 'loadcommentconfig' :
		EXCMS::json_print($EXCMS_MODULE['comment']);
		break;
	/**
	 * 
	 */
	case 'submit' :
		session_start();
		//֤
		if ($EXCMS_MODULE['comment']['verifycode'] && !EXCMS::verifycode_check($params['verifycode'])) {
			EXCMS::showMessage('֤벻ȷ');
		}
		// ID
		checkContentComment($_contentid);
		
		if(trim($params['commenttext']) == ''){
			EXCMS::showMessage('ݲΪ');
		}
		// ȡ
		$data = array();
		
		// ¼,ֹο
		if (!$EXCMS_MODULE['comment'] ['allow_guest']) {
			// load User class and creat user object
			include_once LIB_MODULES_PATH . 'account/User.class.php';
			$userObj = new User();
			// check user logined
			if(!$userObj->isLogin()){
				EXCMS::showMessage('¼');
				$forward = $action == 'logout' ? '' : urlencode("http://".$_SERVER['SERVER_NAME'].($_SERVER['SERVER_PORT']==80 ? '' : (':'.$_SERVER['SERVER_PORT'])).$_SERVER['REQUEST_URI']);
				header('location:' . EXCMS::url(array('name' => 'account.login','forward'=>$forward)));	
				exit;
			}else{
				$userinfo = $userObj->getSession();
				$data['uid'] = $userinfo['uid'];
				$data['username'] = $userinfo['nickname'];
			}
		}
		$data['itemid'] = $_contentid;
		$data['content'] = htmlspecialchars($params['commenttext']);
		$data['ip'] = $_SERVER['REMOTE_ADDR'];
		$data['createddate'] = time();
		// 
		if ($EXCMS_MODULE['comment']['anonymous'] && $params['anonymous']) {
			$data['anonymous'] = 1;
		}
		
		// IP
		if($EXCMS_MODULE['comment']['allow_hide_ip'] && $params['hideip'] == 1){
			$data['hideip'] = 1;
		}
		
		include_once LIB_PATH . 'plugins/ipquery/IpLocation.class.php';
		//ڵ
		$area = new IpLocation();
		$area = $area->getlocation($data['ip']);
		if($area['country']){
			$data['area'] = str_replace(array('ʡ','',''), '', $area['country']);
			if(stripos($data['area'], '') === 0 || stripos($data['area'], '') === 0) unset($data['area']);
		}
		//λ
		if($EXCMS_MODULE['comment']['allow_hide_position'] && $params['hideposition'] == 1){
			$data['hideposition'] = 1;
		}
		//жϻظǷ
		$replyid = (int)$params['reply'];
		if($replyid > 0){
			$replyInfo = $comment->getById($replyid);
			if(!$replyInfo){
				$replyid = 0;
			}
		}
		
		// ڻظ
		if($replyid > 0){
			$data['replyid'] = $replyid;
			$data['floor'] = $replyInfo['floor'] + 1;
			$lastFloor = $replyInfo['floor'] > 1 ? $replyInfo['lastfloor'] : '';
			// ǷIP
			$replyInfo['ip'] = $replyInfo['hideip'] ? '' : "(" . ipformat($replyInfo['ip']) . ")";
			// Ƿ
			if($replyInfo['anonymous']){
				$replyInfo['username'] = '';
			}elseif($replyInfo['uid'] > 0 || $replyInfo['username']){
				$replyInfo['username'] = ' [' . $replyInfo['username'] . '] ';
				unset($replyInfo['ip']);
			}else{
				$replyInfo['username'] = '';
			}
			// Ƿλ
			if($replyInfo['hideposition']){
				$replyInfo['area'] = '';
			}
			//ɻظ
			$data['lastfloor'] = "<div class=\"cmt_old\">" . $lastFloor . 
				"<dl class=\"cmt_old_head\">" . 
				"<dt>%%EXCMS_SITENAME%%" . $replyInfo['area'] . $replyInfo['username'] . $replyInfo['ip'] . "ԭ</dd>" . 
				"<dd>" . $replyInfo['floor'] . "</dd></dl>" . 
				"<div class=\"cmt_old_message\">" . $replyInfo['content'] . "</div></div>";
		}
		$comment->insert($data, 'content');
		checkContentComment($_contentid);
		$data['modelid'] = $_PAGE_CONTENT['modelid'];
		$data['channelid'] = $_PAGE_CONTENT['channelid'];
		$commentstat->insert($data, 'content');
		header("Location:" . EXCMS::url(array('name' => 'comment.content', 'contentid' => $contentid)), true);
		exit;
	/**
	 * ۷桢СۡƼۡ
	 */
	default :
		// 
		if((is_numeric($_contentid) && $_contentid > 0) || (is_numeric($commentid) && $commentid > 0)){
			
			// ȫ
			if($commentid){
				$_PAGE['comment'] = $comment->getDetailById($commentid);
				$_contentid = $_PAGE['comment']['itemid'];
			}
			// 
			checkContentComment($_contentid);
				// ȡ۷
			$_PAGE['type'] = $params['type'];
			if(in_array($_PAGE['type'], array('hot', 'support', 'against'))){
				$_PAGE['urlrule'] = array('name' => "comment.content_{$_PAGE['type']}");
			}else{
				$_PAGE['type'] = 'all';
				$_PAGE['urlrule'] = array('name' => 'comment.content');
			}
			
			// ݷ
			include_once LIB_PATH . 'update/ContentFunction.class.php';
			$_PAGE_CONTENT['url'] = ContentFunction::getContentUrl($_PAGE_CONTENT);
			$_PAGE_CONTENT['href'] = &$_PAGE_CONTENT['url'];
			$_PAGE['comment']['total'] = $comment->getCountByItemId($_contentid);;
			$_PAGE['comment']['shownum'] = $_PAGE['comment']['total'];
			EXCMS::display($commentid ? 'comment/comment_single.html' : 'comment/comment_content.html');
		}else{ // ۷桢СۡƼ
			$type = $_GET['type'];
			$tpl = 'comment.html';
			if($type == 'rank'){ // 
				$_PAGE['title'] = 'а';
				$tpl = 'comment_rank.html';
				$_PAGE['rank'] = isset($_GET['rank']) && in_array($_GET['rank'], array('day', 'week', 'month', 'year', 'all')) ? $_GET['rank'] : 'week';
			}elseif($type == 'wonderful'){ // ͷ
				$_PAGE['title'] = 'ͷ';
				$_PAGE['recommend'] = 1;
				$tpl = 'comment_recommend.html';
				$_PAGE['urlrule'] = array('name' => 'comment.wonderful');
			}elseif($type == 'recommend'){ // Ƽ
				$_PAGE['title'] = 'Ƽ';
				$_PAGE['recommend'] = 2;
				$tpl = 'comment_recommend.html';
				$_PAGE['urlrule'] = array('name' => 'comment.recommend');
			}else{ // ҳ
				$_PAGE['title'] = '';
			}
			EXCMS::display("comment/{$tpl}");
		}
		break;
}

//Ƿ
function checkContentComment($_contentid){
	global $_PAGE_CONTENT, $_PAGE_CHANNEL, $EXCMS_CONFIG; 
	//ȡϢ
	include_once LIB_PATH . 'content/Content.class.php';
	$content = new Content();
	$_PAGE_CONTENT = $content->getById($_contentid);
	$_PAGE_CONTENT['_contentid'] = $_contentid;
	if($EXCMS_CONFIG['code_contentid']){
		$_PAGE_CONTENT['contentid'] = EXCMS::id_encode($_PAGE_CONTENT['contentid']);
	}
	unset($content);
	
	if(!$_PAGE_CONTENT){
		EXCMS::page404('ݲ');
	}elseif (!$_PAGE_CONTENT['comment']) {
		EXCMS::page404('ݲ');
	}
	
	//ȡĿϢ
	//include_once LIB_PATH . 'channel/Channel.class.php';
	//$_PAGE_CHANNEL = new Channel();
	//$_PAGE_CHANNEL = $_PAGE_CHANNEL->getById($_PAGE_CONTENT['channelid']);

	if (!($_PAGE_CHANNEL['comment'] > 0)){
		//exit('Ŀ');
	}
	
	/*
	//ǷҪ¼
	if (! ($EXCMS_MODULE['comment']['allow_guest'] > 0) && ! ($_SESSION['uid'] > 0)) {
		EXCMS::showMessage('¼');
	}
	*/
}

// excms file's end