<?php
/**
 * Project:		EXCMS: the PHP content management system.
 * File:		global.inc.php
 *
 * A product of PUTOYO Inc.
 * 
 * EXCMS is a ten million data-level,high speed,human-based content management system.
 *
 * EX is Excellence & Express & Exceed & Expert.
 * 
 * For questions, help, comments, discussion, please join the
 * EXCMS mailing list. Send a blank e-mail to
 * join@excms.cn
 * or join the EXCMS forum
 * www.excms.cn/forum
 * 
 * @link http://www.excms.cn/
 * @copyright Copyright (c) 2010 PUTOYO Inc.
 * @license http://www.excms.cn/licenses/LICENSE-1.0
 * @category EXCMS
 * @author $Author: zhanghaisong $
 * @version $Rev: 3557 $
 */
/* $Id: global.func.php 3557 2011-01-11 03:12:55Z zhanghaisong $ */
/**
 * EXCMS ͨú
 */
/**
 * EXCMS debug࣬¼ʱsqlѯ
 * @author hukuizhi
 *
 */
class Debug{
	static $debug_time = 0;
	static $debug_memory = 0;
	static $debug_queries = 0;
	static $debug_query_time = 0;
	static $time = 0;
	static $debug_fetch_time = 0;
}
/**
 * Է¼ʱsqlѯ
 * @return true
 */
function debug(){
	Debug::$debug_time = processedIn();
	Debug::$debug_memory = processedMemory();
	Debug::$debug_queries = $GLOBALS['db']->querynum;
	Debug::$debug_query_time = number_format($GLOBALS['db']->querytime, 8);
	Debug::$debug_fetch_time = number_format($GLOBALS['db']->fetchtime, 8);
	return true;
}
/**
 * ȡ()ʱ
 * @return float
 */
function processedIn(){
	$startTime = explode(' ', EXCMS_TIME_START);
	$endTime = explode(' ', microtime());
	return number_format(($endTime[1] + $endTime[0] - $startTime[1] - $startTime[0]), 6);
}
/**
 * ȡ()ʱ
 * @return float
 */
function processedMemory(){
	return round((memory_get_peak_usage() - EXCMS_MEMORY_START) / 1024, 1);
}
/**
 * ʾϢ(ִʱsqlִʱ)
 * @param bool $return trueֱfalseصϢַ(default) 
 * @return string
 */
function displayDebugInfo($return = false){
	global $EXCMS_CONFIG;
	if(!$EXCMS_CONFIG['debug_mode']) return;
	debug();
	//	$re = "Processed in ".Debug::$debug_time." second(s), ".Debug::$debug_queries." queries takes ".Debug::$debug_query_time." second(s).";//.Debug::$debug_fetch_time;
	
	$re = "<font style=\"font-size:11px\">Processed in " . round(Debug::$debug_time, 6) . " second(s), " . Debug::$debug_queries . " queries takes " . round(Debug::$debug_query_time, 6) . " second(s), memory:" . Debug::$debug_memory . 'KB.</font>'; //.Debug::$debug_fetch_time;
	if($return){
		return $re;
	}
	echo "<div style=\"text-align:center;color:#999;font-size:11px;font-family:Arial;\">{$re}</div><pre>";
}
/**
 * ȡȷʱ
 * @return string
 */
function microtime_float(){
	list($u, $s) = explode(" ", microtime());
	return ((float)$u + (float)$s);
}
/**
 * ʹ÷бַ
 * @param array | string $v
 * @return array | string
 */
function addslashes_deep($v){
	return is_array($v) ? array_map('addslashes_deep', $v) : addslashes($v);
}
/**
 * תΪλ
 *
 * @param string $str 
 * @return string
 */
function convertToAscii($str){
	$s = trim($str);
	if($str != ''){
		$leng = strlen($s);
		$str = "";
		$reg = "/^[" . chr(0xa1) . "-" . chr(0xff) . "]+$/";
		if(CHARSET == JSON_CHARSET){
			$s = EXCMS::iconv_all('UTF-8', 'GBK', $s);
		}
		for($i = 0; $i < $leng; $i++){
			if(preg_match($reg, $s[$i])){
				$str .= sprintf("%02d%02d", ord($s[$i]) - 160, ord($s[++$i]) - 160);
			}else{
				$str .= $s[$i];
			}
		}
		if(CHARSET == JSON_CHARSET){
			$s = EXCMS::iconv_all('GBK', 'UTF-8', $str);
		}
	}
	return $str;
}
/**
 * תӷ
 * @param string $url
 */
function goUrl($url){
	echo "<script language=javascript>location.href=\"" . $url . "\"</script>";
}
/**
 * file_put_contents
 */
if(!function_exists('file_put_contents')){
	define('FILE_APPEND', 8);
	/**
	 * дļ
	 *
	 * @param string $file дļ
	 * @param string $data д
	 * @param string $append д뷽ʽ Ĭwbab
	 * @return int ļС
	 */
	function file_put_contents($file, $data, $append = ''){
		$mode = $append == '' ? 'wb' : 'ab';
		$fp = @fopen($file, 'wb') or exit("ܴļ $file !");
		flock($fp, LOCK_EX);
		$len = @fwrite($fp, $data);
		flock($fp, LOCK_UN);
		@fclose($fp);
		return $len;
	}
}
if(!function_exists('mb_strpos')){
	function mb_strpos($str, $needle, $offset = 0, $charset = ''){
		$arr = preg_split("/$needle/", $str);
		if(1 == sizeof($arr)) $pos = false;
		else{
			if(0 == $offset) $pos = mb_strlen($arr[0]);
			elseif($offset >= mb_strlen($str)) $pos = false;
			else{
				$sstr = mb_substr($str, $offset);
				if(mb_strpos($sstr, $needle) === false) $pos = false;
				else $pos = $offset + mb_strpos($sstr, $needle);
			}
		}
		return $pos;
	}
	function mb_strlen($str){
		preg_match_all("/[\\x80-\\xff]?./", $str, $arr);
		return sizeof($arr[0]);
	}
	function mb_substr($str, $start, $len = -1){
		preg_match_all("/[\\x80-\\xff]?./", $str, $arr);
		$len == -1 && $len = sizeof($arr[0]) - $start;
		return @implode(array_slice($arr[0], $start, $len), '');
	}
}
/**
 * ض
 *
 * @param string $url ضURL
 * @param int $time ͣʱ
 * @param null|string $msg ʾϢ
 */
function redirect($url, $time = 0, $msg = ''){
	//URLַ֧
	$url = str_replace(array("\n", "\r"), '', $url);
	if(empty($msg)){
		$msg = "ϵͳ{$time}֮Զת{$url}";
	}
	if(!headers_sent()){
		// redirect
		if(0 === $time){
			header("Location: " . $url);
		}else{
			header("refresh:{$time};url={$url}");
			EXCMS::showMessage($msg);
		}
		exit();
	}else{
		$str = "<meta http-equiv='Refresh' content='{$time};URL={$url}'>";
		if($time != 0){
			$str .= $msg;
		}
		exit($str);
	}
}
/**
 * ʽıݣ滻ոͻ
 *
 * @param string $string
 * @return string
 */
function format_textarea($string){
	return nl2br(str_replace(' ', '&nbsp;', htmlspecialchars($string)));
}
/**
 * תɴ洢СBytes,KB,MB,GB
 *
 * @param int $filesize ļС
 * @return string
 */
function sizecount($filesize, $type = ''){
	if($type == 'MB'){
		$filesize = $filesize * 1048576;
	}else if($type == 'KB'){
		$filesize = $filesize * 1024;
	}
	if($filesize > 0){
		if($filesize >= 1073741824){
			$filesize = round($filesize / 1073741824 * 100) / 100 . 'GB';
		}elseif($filesize >= 1048576){
			$filesize = round($filesize / 1048576 * 100) / 100 . 'MB';
		}elseif($filesize >= 1024){
			$filesize = round($filesize / 1024 * 100) / 100 . 'KB';
		}else{
			$filesize = $filesize . 'B';
		}
	}else
		$filesize = 'δ֪';
	return $filesize;
}
/**
 * ¼ʽ'ǰ''Сʱǰ''ǰ''ǰ'ָʽʱ
 *
 * @param int $time ʱ䣬
 * @param string $dateformat='Y-m-d H:i:s'
 * @return string
 */
function timeformat($time, $dateformat = 'Y-m-d H:i:s'){
	$now = time();
	$t = $now - $time;
	$t = $t == 0 ? 1 : $t;
	if(formatDate('Y', $now) != formatDate('Y', $time)){
		$time = formatDate('Ymd', $time);
	}elseif($t >= 60 * 60 * 24 * 3){
		$time = formatDate($dateformat, $time);
	}elseif($t >= 60 * 60 * 24){
		$time = floor($t / (60 * 60 * 24)) . 'ǰ';
	}elseif($t >= 60 * 60){
		$time = floor($t / (60 * 60)) . 'Сʱǰ';
	}elseif($t >= 60){
		$time = round($t / 60) . 'ǰ';
	}else{
		$time = $t . 'ǰ';
	}
	return $time;
}
/**
 * ʱתڸʽ
 *
 * @param int $mktime ʱ
 * @return string 
 */
function GetDateMk($mktime){
	global $EXCMS_CONFIG;
	$cli_time = $EXCMS_CONFIG["cli_time"];
	if($mktime == "" || ereg("[^0-9]", $mktime)) return "";
	return gmdate("Y-m-d", $mktime + 3600 * (int)$cli_time);
}
/**
 * ȡַƴ
 *
 * @param string $str ַ
 * @param int $type 0ȫƴ1ƴ2ȫƴƴ 3ȡƴĸ
 * 
 * @return string
 */
function pinyin($str, $type = 0){
	include_once LIB_PATH . 'util/Pinyin.class.php';
	$pinyin = new Pinyin();
	return $pinyin->getPinyin($str, $type);
}
/**
 * ʽʱ
 *
 * @param string $format ʱʽ
 * @param int $timest ʱ
 * @return string
 */
function formatDate($format = 'Y-m-d H:i:s', $timest = 0){
	global $EXCMS_CONFIG;
	$cli_time = $EXCMS_CONFIG['cli_time'];
	$addtime = $cli_time * 3600;
	if(empty($format)) $format = 'Y-m-d H:i:s';
	$timest = $timest > 0 ? $timest : time();
	return gmdate($format, $timest + $addtime);
}
function get_formatted_timediff($then, $now = false){
	define('INT_SECOND',	1);
	define('INT_MINUTE',	60);
	define('INT_HOUR',		3600);
	define('INT_DAY',		86400);
	define('INT_WEEK',		604800);
	!$now && $now = time();
	$timediff = ($then - $now);
	$days = intval($timediff / INT_DAY);
	$timediff = intval($timediff - (INT_DAY * $days));
	$hours = intval($timediff / INT_HOUR);
	$timediff = intval($timediff - (INT_HOUR * $hours));
	$mins = intval($timediff / INT_MINUTE);
	$timediff = intval($timediff - (INT_MINUTE * $mins));
	$sec = intval($timediff / INT_SECOND);
	$timediff = intval($timediff - ($sec * INT_SECOND));
	$str = '';
	$days > 0 && $str .= intval($days) . '';
	$hours > 0 && $str .= intval($hours) . 'Сʱ';
	$mins > 0 && $str .= intval($mins) . '';
	$sec > 0 && $str .= intval($sec) . '';
	/*if ( !$weeks && !$days && !$hours && !$mins && !$sec )
    {
        $str .= 'ѵʱ';
    }
    else
    {
        $str .= 'ǰ';
    }*/
	return $str;
}
/**
 * ַȡ֧ GBK, GB2312, UTF8
 * һĺִ2ַ
 * @param string $str Դַ
 * @param int $length ȡ
 * @param int $start ʵλ
 * @return string
 */
function csubstr($str, $length, $start = 0, $suffix = true){
	if($length < 1) return '';
	if($start < 0) $start = 0;
	$str_len = strlen($str);
	if($str_len <= $start) return '';
	$slice = '';
	if($str_len < $start + $length || $length == 0) $length = $str_len - $start;
	$i = $k = 0;
	$add = CHARSET == JSON_CHARSET ? 2 : 1;
	while($length > 0 && $i <= $str_len){
		if(ord($str[$i]) > 127){
			if($k >= $start){
				if($str_len > $i + $add && $length > $add){
					$slice .= $add > 1 ? $str[$i] . $str[$i + 1] . $str[$i + 2] : $str[$i] . $str[$i + 1];
					$length -= 2;
				}else{
					break;
				}
			}
			$k += 2;
			$i += $add + 1;
		}else{
			if($k >= $start){
				$slice .= $str[$i];
				$length--;
			}
			$i++;
			$k++;
		}
	}
	$suffix_str = '<font style="font-family:Tahoma"></font>';
	if($suffix === false || $suffix == 'false' || $suffix == '' || $suffix == 0){
		$suffix = false;
	}elseif($suffix === true || $suffix == 'true' || $suffix == 1){
		$suffix = true;
	}else{
		$suffix_str = $suffix;
	}
	return $suffix && $i < ($str_len - 1) ? $slice . $suffix_str : $slice;
}
/**
 * high light words
 * @param string $str ַ
 * @param string $word ؼ
 * @param int $length ǷҪȡ
 * @return string
 */
function highLightWords($str, $word, $length = 0){
	if($length > 0) $str = csubstr($str, $length);
	if(!$word) return $str;
	$words = explode(' ', trim($word));
	$i = 0;
	foreach($words as $k => $v){
		if($word == '') unset($words[$k]);
		$i++;
	}
	if($i == 0) return $str;
	$pattern = "/(" . implode('|', $words) . ")/i";
	return preg_replace($pattern, "<font color=\"red\">\\1</font>", $str);
}
/**
 * URLʽ׼
 * @param $url
 * @return string
 */
function urlFormat($url){
	$url = preg_replace("/(\\/+\\.\\/+)|(\\/+)|(\\\\+)/", "/", $url);
	return str_replace('http:/', 'http://', $url);
}
/**
 * ıתHTML
 * @param string $txt
 * @return string
 */
function text2Html($txt){
	$txt = str_replace("  ", "", $txt);
	$txt = str_replace("<", "&lt;", $txt);
	$txt = str_replace(">", "&gt;", $txt);
	$txt = preg_replace("/[\r\n]{1,}/isU", "<br/>\r\n", $txt);
	return $txt;
}
/**
 * HTMLı
 * @param string $str
 * @return string
 */
function html2Text($str){
	$str = preg_replace("/<sty(.*)\\/style>|<scr(.*)\\/script>|<!--(.*)-->/isU", '', $str);
	$str = str_replace(array('<br />', '<br>', '<br/>'), "\n", $str);
	$str = strip_tags($str);
	return $str;
}
/**
 * HTML
 * @param string $str
 * @return string
 */
function clearHtml($str){
	$str = html2Text($str);
	$str = str_replace('<', '&lt;', $str);
	$str = str_replace('>', '&gt;', $str);
	return $str;
}
/**
 * ֶݲΪ
 *
 *@param string $start ǰ׺
 *@param string $field ֵֶ
 *@param string $end ׺
 *@return string
 */
function notEmptyJoin($start = '', $field = '', $end = ''){
	if(empty($field)) return '';
	return $start . $field . $end;
}
/**
 * ʽַ
 *
 * @param string $str
 * @param bool $space Ƿ񽫿ոתɶ
 * @return string
 */
function formatCommaStr($str, $space = true){
	if($space){
		$str = str_replace(array('', ''), ',', trim($str));
		$str = preg_replace("/[, \040]{1,}/", ',', $str);
	}else{
		$str = str_replace('', ',', trim($str));
		$str = preg_replace("/[,]{1,}/", ',', $str);
	}
	substr($str, 0, 1) == ',' && $str = substr($str, 1);
	substr($str, -1, 1) == ',' && $str = substr($str, 0, -1);
	return trim($str);
}
function mysql_filter_string($str){
	return mysql_escape_string($str);
}
/**
 * ʽոַ
 *
 * @param string $str
 * @return string
 */
function formatSpaceSplitStr($str){
	return trim(preg_replace("/[\040]{2,}/", " ", str_replace(array(',', '', ''), ' ', trim($str))));
}
/**
 * Ÿַת飬ȥظ
 *
 * @param string $str
 * @param boolean $unique Ƿȥظֵ
 * @return array
 */
function convertCommaStrToArray($str, $unique = false){
	$str = formatCommaStr($str);
	if(empty($str)) return array();
	$str = explode(',', $str);
	return $unique ? array_unique($str) : $str;
}
/**
 * лȡı
 *
 * @param string $str 
 * @return array
 */
function clearLink($str){
	preg_match_all('/<a\s*[^>]*href=["|\']?([^>"\' ]+)["|\']?\s*[^>]*>([^>]+)<\/a>/i', $str, $v);
	return $v[2][0];
}
/**
 * htmlıȡзǿ(urlıΪ)url
 *
 * @param string $html htmlı
 * @return array
 */
function getAllLinks($html){
	preg_match_all("'<\s*a\s.*?href\s*=\s*([\"\'])?(?(1)(.*?)\\1|([^\s\>]+))[^>]*>?(.*?)</a>'isx", stripslashes($html), $match);
	$links = array();
	while(list($k, $v) = each($match[4])){
		$v = trim($v);
		if(!empty($v)){
			$url = trim($match[2][$k]);
			empty($url) && $url = trim($match[3][$k]);
			!empty($url) && $links[] = array('txt' => $v, 'url' => $url);
		}
	}
	return $links;
}
/**
 * ʽipַ
 * @param string $ip
 * @return string
 */
function ipformat($ip){
	return preg_replace("/\d+\.\d+$/i", '*.*', $ip);
}
/**
 * Եַȫַ)
 * @param $url
 */
function full_url($url){
	strpos($url, "http://") === false && $url = urlFormat($GLOBALS['EXCMS_CONFIG']['domain'] . $url);
	return $url;
}
/**
 * ·
 */
function getRelativePath($path, $basedir = SITE_PATH){
	$p = urlFormat($path);
	$d = urlFormat($basedir);
	return stripos($p, $d) === 0 ? substr($p, strlen($d)) : (stripos($d, $p) === 0 ? '' : $p);
}
/**
 * Ŀ¼Ƿд
 *
 * @param string $file ļ
 * @param string $postfix ׺
 * @return string
 */
function writeable($d){
	$w = 0;
	!is_dir($d) && mkdir($d, 0777);
	if(is_dir($d)){
		$f = "{$d}/excms.txt";
		if($fp = fopen($f, 'w')){
			fclose($fp);
			unlink($f);
			$w = 1;
		}
	}
	return $w;
}
/**
 * Ӻ׺
 *
 * @param string $file ļ
 * @param string $postfix ׺
 * @return string
 */
function addFilePostfix($file, $postfix, $con = '_'){
	if(empty($postfix)) return $file;
	$pos = strrpos($file, '.');
	$postfix = $con . $postfix;
	if($pos){
		$file = substr($file, 0, $pos) . $postfix . substr($file, $pos);
	}else{
		$file .= $postfix;
	}
	return $file;
}
/**
 * ǰ׺
 *
 * @param string $file ļ
 * @param string $prefix ǰ׺
 * @return string
 */
function addFilePrefix($file, $prefix){
	if($prefix == '') return $file;
	$file = str_replace('\\', '/', $file);
	$pos = strrpos($file, '/');
	if($pos !== false){
		$file = substr($file, 0, $pos + 1) . $prefix . '_' . substr($file, $pos + 1);
	}else{
		$file = $prefix . '_' . $file;
	}
	return $file;
}
if(file_exists(INC_PATH . 'debug.func.php')){
	include_once INC_PATH . 'debug.func.php';
}

// excms file's end