<?php
/**
 * Project:		EXCMS: the PHP content management system.
 * File:		Contentid.class.php
 *
 * A product of PUTOYO Inc.
 * 
 * EXCMS is a ten million data-level,high speed,human-based content management system.
 *
 * EX is Excellence & Express & Exceed & Expert.
 * 
 * For questions, help, comments, discussion, please join the
 * EXCMS mailing list. Send a blank e-mail to
 * join@excms.cn
 * or join the EXCMS forum
 * www.excms.cn/forum
 * 
 * @link http://www.excms.cn/
 * @copyright Copyright (c) 2010 PUTOYO Inc.
 * @license http://www.excms.cn/licenses/LICENSE-1.0
 * @category EXCMS
 * @package update
 * @author $Author: zhanghaisong $
 * @version $Rev: 404 $
 */
/* $Id: ListBase.class.php 404 2009-12-22 10:12:08Z zhanghaisong $ */
/**
 * EXCMS ID
 * 
 * @category EXCMS
 * @package template
 * @author $Author: zhanghaisong $
 */
class Contentid{
	/**
	 * 
	 *
	 * @access private
	 * @var string
	 */
	protected $table = 'contents';
	/**
	 * ȡضĵбĵID
	 *
	 * @var string
	 */
	var $id;
	/**
	 * ǰֶ
	 *
	 * @var string
	 */
	var $item;
	var $type;
	/**
	 * ҪʽֶΣݱֶκͷݱֶ
	 * @var array
	 */
	var $toFormate = array('channel', 'href', 'url', 'arctitle', 'thumb');
	/**
	 * ǰContentid
	 *
	 * @var ContentList
	 */
	private static $instance;
	/**
	 * 캯
	 *
	 */
	public function __construct(){
		$this->table = TABLE_PREFIX . $this->table;
	}
	/**
	 * PHP4캯
	 *
	 */
	public function Contentid(){
		$this->__construct();
	}
	/**
	 * Contentid
	 *
	 * @return Contentid
	 */
	public static function create(){
		if(self::$instance == null){
			self::$instance = new Contentid();
		}
		return self::$instance;
	}
	/**
	 * IDȡ
	 *
	 * @param $contentid ID
	 * @param $channelid ĿID
	 * @param $model ģID
	 * @param $type   
	 * @return array
	 */
	public function getContent($contentid, $type = null, $channelid = null, $model = null, $image = null){
		if($type == 'pre' || $type == 'prev' || $type == 'next'){
			$where = '';
			$contentid = (int)$contentid;
			$contentid < 1 && throw_exception('LACK_CONTENT_ID');
			$channelid = (int)$channelid;
			$channelid > 0 && $where = "`channelid` = '{$channelid}' AND ";
			if($model){
				switch($model){
					case 'article' :
						$model = 1;
						break;
					case 'image' :
						$model = 2;
						break;
					case 'download' :
						$model = 3;
						break;
					case 'video' :
						$model = 4;
						break;
					default :
						$model = (int)$model;
						break;
				}
				$model > 0 && $where .= "`modelid` = '{$model}' AND ";
			}
			$image && $where .= "`isthumb` = '1' AND ";
			$type = $type == 'next' ? "> '{$contentid}'" : "< '{$contentid}' ORDER BY `contentid` DESC";
			$sql = "SELECT * FROM `{$this->table}` WHERE {$where}`checked` = '1' AND `contentid` {$type} LIMIT 1";
		}else{
			$ids = EXCMS::array_trim_rmnull_unique(explode(',', $contentid));
			$t = count($ids);
			if($t){
				$ids = $t > 1 ? "IN ('" . implode("','", $ids) . "')" : "= '{$ids[0]}'";
			}else{
				if($GLOBALS['_PAGE_CONTENT']['_contentid']){
					$t = 1;
					$ids = "= '{$GLOBALS['_PAGE_CONTENT']['_contentid']}'";
				}else
					return null;
			}
			$sql = "SELECT * FROM `{$this->table}` WHERE `contentid` {$ids} LIMIT {$t}";
		}
		$GLOBALS['db']->query($sql);
		$data = $GLOBALS['db']->fetchAll();
		if(is_array($data) && count($data)){
			// ʽ
			$data = ContentFunction::formate($data, $this->toFormate);
			return array('from' => $data);
		}else
			return null;
	}
}