SET NAMES 'gbk';

DROP TABLE IF EXISTS `excms_account_fields`;
CREATE TABLE `excms_account_fields` (
  `uid` int(11) NOT NULL,
  `realname` char(20) DEFAULT NULL,
  `gender` tinyint(1) DEFAULT NULL,
  `birthday` char(10) DEFAULT NULL,
  `phone` char(12) DEFAULT NULL,
  `mobile` char(12) DEFAULT NULL,
  `area` char(20) DEFAULT NULL,
  `job` varchar(50) DEFAULT NULL,
  `msn` char(30) DEFAULT NULL,
  `qq` char(15) DEFAULT NULL,
  `address` varchar(100) DEFAULT NULL,
  `zipcode` char(10) DEFAULT NULL,
  `question` varchar(50) DEFAULT NULL,
  `answer` varchar(50) DEFAULT NULL,
  `backupemail` char(20) DEFAULT NULL,
  PRIMARY KEY (`uid`)
) ENGINE=MyISAM DEFAULT CHARSET=gbk;


DROP TABLE IF EXISTS `excms_account_group`;
CREATE TABLE `excms_account_group` (
  `groupid` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `name` char(20) NOT NULL DEFAULT '',
  `type` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `allowadmin` tinyint(1) DEFAULT '0',
  `description` varchar(200) NOT NULL,
  `explimit` int(11) DEFAULT '0',
  `credit` int(11) DEFAULT NULL,
  `enabled` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `issystem` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `sort` tinyint(3) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`groupid`)
) ENGINE=MyISAM AUTO_INCREMENT=1001 DEFAULT CHARSET=gbk;

INSERT INTO `excms_account_group` VALUES ('1','עԱ','0','0','עԱ','0','0','1','0','50');
INSERT INTO `excms_account_group` VALUES ('2','߼Ա','0','0','߼Ա','500','500','1','0','50');
INSERT INTO `excms_account_group` VALUES ('3','VIPԱ','0','0','VIPԱ','2000','2000','1','0','50');
INSERT INTO `excms_account_group` VALUES ('4','û','1','1','û','10000','10000','1','0','50');

DROP TABLE IF EXISTS `excms_account_models`;
CREATE TABLE `excms_account_models` (
  `modelid` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(20) DEFAULT NULL,
  `ename` varchar(20) NOT NULL,
  `addontable` varchar(20) DEFAULT NULL,
  `issystem` tinyint(2) unsigned DEFAULT '0',
  `status` tinyint(2) unsigned DEFAULT '0',
  `sort` tinyint(2) DEFAULT NULL,
  PRIMARY KEY (`modelid`)
) ENGINE=MyISAM AUTO_INCREMENT=1001 DEFAULT CHARSET=gbk;


DROP TABLE IF EXISTS `excms_account_models_fields`;
CREATE TABLE `excms_account_models_fields` (
  `fieldid` int(11) NOT NULL AUTO_INCREMENT,
  `modelid` int(11) DEFAULT NULL,
  `formname` varchar(50) DEFAULT NULL,
  `fieldname` varchar(50) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `datatype` int(2) DEFAULT NULL,
  `datalength` int(11) DEFAULT NULL,
  `allownull` tinyint(1) DEFAULT NULL,
  `default` text,
  `allowshow` tinyint(1) DEFAULT '1',
  `allowlist` tinyint(1) DEFAULT '0',
  `allowsearch` tinyint(1) DEFAULT '0',
  `addonAtributes` text,
  `issystem` tinyint(1) DEFAULT '0',
  `sort` int(11) DEFAULT '50',
  PRIMARY KEY (`fieldid`)
) ENGINE=MyISAM AUTO_INCREMENT=1001 CHARSET=gbk;


DROP TABLE IF EXISTS `excms_account_score`;
CREATE TABLE `excms_account_score` (
  `uid` int(11) DEFAULT NULL,
  `total` int(11) DEFAULT NULL,
  `ask` int(11) DEFAULT NULL,
  `punish` int(11) DEFAULT NULL,
  `expend` int(11) DEFAULT NULL
) ENGINE=MyISAM DEFAULT CHARSET=gbk;


DROP TABLE IF EXISTS `excms_accounts`;
CREATE TABLE `excms_accounts` (
  `uid` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `username` char(20) NOT NULL,
  `password` char(32) NOT NULL,
  `nickname` char(20) DEFAULT NULL,
  `domain` varchar(24) DEFAULT NULL,
  `unumber` int(11) DEFAULT '0',
  `modelid` int(11) unsigned DEFAULT '1',
  `groupid` int(11) unsigned DEFAULT NULL,
  `email` varchar(50) DEFAULT NULL,
  `checked` tinyint(1) unsigned DEFAULT '0',
  `enabled` tinyint(1) unsigned DEFAULT '1',
  `experience` int(11) unsigned DEFAULT '0',
  `credit` int(11) unsigned DEFAULT '0',
  `avatar` varchar(30) DEFAULT NULL,
  `remarks` varchar(200) DEFAULT '',
  `registeddate` int(11) unsigned DEFAULT NULL,
  `registedip` char(15) DEFAULT NULL,
  `lastloginip` char(15) DEFAULT NULL,
  `lastlogindate` int(11) unsigned DEFAULT NULL,
  PRIMARY KEY (`uid`),
  KEY `username` (`username`)
) ENGINE=MyISAM DEFAULT CHARSET=gbk;


DROP TABLE IF EXISTS `excms_acl`;
CREATE TABLE `excms_acl` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `menuid` int(11) DEFAULT NULL,
  `name` varchar(20) DEFAULT NULL,
  `identify` varchar(20) DEFAULT NULL,
  `description` varchar(100) DEFAULT NULL,
  `action` varchar(100) DEFAULT NULL,
  `sort` int(3) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=1001 DEFAULT CHARSET=gbk;

INSERT INTO `excms_acl` VALUES ('1','26','½','add','½ģ','insert','50');
INSERT INTO `excms_acl` VALUES ('2','26','༭','edit,rewrite','༭()ģ','update,status','50');
INSERT INTO `excms_acl` VALUES ('3','26','ɾ','delete','ɾģ','del','50');
INSERT INTO `excms_acl` VALUES ('5','27','½','add','½','insert','50');
INSERT INTO `excms_acl` VALUES ('6','27','༭','edit,rewrite','༭()','update,status','50');
INSERT INTO `excms_acl` VALUES ('7','27','ɾ','delete','ɾ','delete','50');
INSERT INTO `excms_acl` VALUES ('9','29','½','add','½,ͼƬ,,Ƶ','insert','50');
INSERT INTO `excms_acl` VALUES ('10','29','༭','edit,move','ݱ༭,ƶ','update,move','50');
INSERT INTO `excms_acl` VALUES ('11','29','ɾ','delete','ɾ','delete','50');
INSERT INTO `excms_acl` VALUES ('13','24','½','add,copy,paste','½ƣճ','insert,copy,paste','50');
INSERT INTO `excms_acl` VALUES ('14','24','༭','edit,move','༭ƶ','update,move','50');
INSERT INTO `excms_acl` VALUES ('15','24','ɾ','delete','ɾ','delete','50');
INSERT INTO `excms_acl` VALUES ('16','24','','setting','Ŀ','setting','50');
INSERT INTO `excms_acl` VALUES ('17','24','Դ','Binding','Դ','loadBindResource','50');
INSERT INTO `excms_acl` VALUES ('18','26','Դ','bind','Դ','bind','50');
INSERT INTO `excms_acl` VALUES ('19','26','ֶι','manageFields','ֶι','manageFields','50');
INSERT INTO `excms_acl` VALUES ('20','27','ֶι','managefields','ֶι','fieldstore','50');
INSERT INTO `excms_acl` VALUES ('21','27','ݹ','managedata','ݹ','datastore','50');
INSERT INTO `excms_acl` VALUES ('23','33','½ͱ༭','add,edit','Tag½ͱ༭','commit','50');
INSERT INTO `excms_acl` VALUES ('25','33','ɾ','delete','ɾ','delete','50');
INSERT INTO `excms_acl` VALUES ('26','34','½ͱ༭','add,edit','عؼֵ½ͱ༭','commit','50');
INSERT INTO `excms_acl` VALUES ('28','34','ɾ','delete','ɾ','delete','50');
INSERT INTO `excms_acl` VALUES ('29','35','½ͱ༭','add,edit','½,༭','commit','50');
INSERT INTO `excms_acl` VALUES ('31','35','ɾ','delete','ɾ','delete','50');
INSERT INTO `excms_acl` VALUES ('32','36','½ͱ༭','add,edit','½,༭','commit','50');
INSERT INTO `excms_acl` VALUES ('34','36','ɾ','delete','ɾ','delete','50');
INSERT INTO `excms_acl` VALUES ('35','59','װ','install','װ','install','50');
INSERT INTO `excms_acl` VALUES ('36','59','ж','uninstall','ж','uninstall','50');
INSERT INTO `excms_acl` VALUES ('37','59','','setting','','setting','50');
INSERT INTO `excms_acl` VALUES ('38','56','½','add','½ģ','insert','50');
INSERT INTO `excms_acl` VALUES ('39','56','༭','edit','༭ģ','update','50');
INSERT INTO `excms_acl` VALUES ('40','56','ɾ','delete','ɾģ','delete','50');
INSERT INTO `excms_acl` VALUES ('41','58','װ','installModule','װ','installModule','50');
INSERT INTO `excms_acl` VALUES ('42','58','ж','uninstall','ж','uninstall','50');
INSERT INTO `excms_acl` VALUES ('43','58','','setting','','setting','50');
INSERT INTO `excms_acl` VALUES ('44','30','½','add','½Զҳ','insert','50');
INSERT INTO `excms_acl` VALUES ('45','30','༭','edit','༭Զҳ','update','50');
INSERT INTO `excms_acl` VALUES ('46','30','ɾ','delete','ɾԶҳ','delete','50');
INSERT INTO `excms_acl` VALUES ('47','32','½ͱ༭','add,edit','½ͱ༭ؼ','commit','50');
INSERT INTO `excms_acl` VALUES ('49','32','ɾ','delete','ɾ','delete','50');
INSERT INTO `excms_acl` VALUES ('50','62','½','add','½','insert','50');
INSERT INTO `excms_acl` VALUES ('51','62','༭','edit','༭','update','50');
INSERT INTO `excms_acl` VALUES ('52','62','ɾ','delete','ɾ','delete','50');
INSERT INTO `excms_acl` VALUES ('53','63','½','add','½','insert','50');
INSERT INTO `excms_acl` VALUES ('54','63','༭','edit,rewrite','༭/д','update,enablerewrite','50');
INSERT INTO `excms_acl` VALUES ('55','63','ɾ','delete','ɾ','delete','50');
INSERT INTO `excms_acl` VALUES ('56','64','½','add','½','insert','50');
INSERT INTO `excms_acl` VALUES ('57','64','༭','edit,status','༭','update','50');
INSERT INTO `excms_acl` VALUES ('58','64','ɾ','delete','ɾ','delete','50');
INSERT INTO `excms_acl` VALUES ('59','66','½(༭)','add,edit','½','insert,update','50');
INSERT INTO `excms_acl` VALUES ('60','66','༭','edit','༭','update','50');
INSERT INTO `excms_acl` VALUES ('61','66','ɾ','delete','ɾ','delete','50');
INSERT INTO `excms_acl` VALUES ('62','67','½','add','½','edit','50');
INSERT INTO `excms_acl` VALUES ('63','67','༭','edit,setting','༭/ã','edit,setting','50');
INSERT INTO `excms_acl` VALUES ('64','67','ɾ','delete','ɾ','del','50');
INSERT INTO `excms_acl` VALUES ('70','6','½','add','½Դͣ½Դ','insert','50');
INSERT INTO `excms_acl` VALUES ('71','6','༭','edit','༭ԴͣԴ','update','50');
INSERT INTO `excms_acl` VALUES ('72','6','ɾ','delete','ɾ','delete','50');
INSERT INTO `excms_acl` VALUES ('73','77','½(ҳ)','add','½(ҳ)','commitcategory','50');
INSERT INTO `excms_acl` VALUES ('74','77','޸ķ(ҳ)','edit','޸ķ(ҳ)','commitcategory','50');
INSERT INTO `excms_acl` VALUES ('75','77','ɾ(ҳ)','delete','ɾ(ҳ)','deletecategory','50');
INSERT INTO `excms_acl` VALUES ('76','77','ɷ(ҳ)','publishcategory','ɷ(ҳ)Ƭ','publishcategory','50');
INSERT INTO `excms_acl` VALUES ('77','77','½Ƭ','blockadd','½Ƭ','commitblock','50');
INSERT INTO `excms_acl` VALUES ('78','64','½','addgroup','½','insertgroup','50');
INSERT INTO `excms_acl` VALUES ('79','64','༭','editgroup','༭','updategroup','50');
INSERT INTO `excms_acl` VALUES ('80','64','ɾ','deletegroup','ɾ','deletegroup','50');
INSERT INTO `excms_acl` VALUES ('81','64','Ȩ','groupacl','Ȩ','saveACL,channeltree,blocktree,getACL','50');
INSERT INTO `excms_acl` VALUES ('82','150','½','add','½','insert','50');
INSERT INTO `excms_acl` VALUES ('83','150','༭','edit','༭','update','50');
INSERT INTO `excms_acl` VALUES ('84','150','ɾ','delete','ɾ','delete','50');
INSERT INTO `excms_acl` VALUES ('85','75','½','add','½','insert','50');
INSERT INTO `excms_acl` VALUES ('86','75','༭','edit','༭','update','50');
INSERT INTO `excms_acl` VALUES ('87','75','ɾ','delete','ɾ','delete','50');
INSERT INTO `excms_acl` VALUES ('89','65','','backup','','backup','50');
INSERT INTO `excms_acl` VALUES ('90','65','Ż','optimize','Ż','optimize','50');
INSERT INTO `excms_acl` VALUES ('91','65','޸','repair','޸','repair','50');
INSERT INTO `excms_acl` VALUES ('92','65','','import','','import','50');
INSERT INTO `excms_acl` VALUES ('93','65','ѹ','unzip','ѹ','unzip','50');
INSERT INTO `excms_acl` VALUES ('94','65','ɾ','delbackup','ɾ','delbackup','50');
INSERT INTO `excms_acl` VALUES ('95','74','½','add','½','insert','50');
INSERT INTO `excms_acl` VALUES ('96','74','༭','edit,status','༭','update,status','50');
INSERT INTO `excms_acl` VALUES ('97','74','ɾ','delete','ɾ','delete','50');
INSERT INTO `excms_acl` VALUES ('98','66','','setting','','setting','50');
INSERT INTO `excms_acl` VALUES ('99','66','½','treeadd','½','treeinsert','50');
INSERT INTO `excms_acl` VALUES ('100','66','༭','treeedit','༭','treeupdate','50');
INSERT INTO `excms_acl` VALUES ('101','66','ɾ','treedelete','ɾ','treedelete','50');
INSERT INTO `excms_acl` VALUES ('102','60','½','treeadd','½','groupinsert','50');
INSERT INTO `excms_acl` VALUES ('103','60','༭','treeedit','༭','groupupdate','50');
INSERT INTO `excms_acl` VALUES ('104','60','ɾ','treedelete','ɾ','groupdelete','50');
INSERT INTO `excms_acl` VALUES ('105','60','½','add','½','insert','50');
INSERT INTO `excms_acl` VALUES ('106','60','༭','edit,status','༭','update,status','50');
INSERT INTO `excms_acl` VALUES ('107','60','ɾ','delete','ɾ','delete','50');
INSERT INTO `excms_acl` VALUES ('108','60','״̬','status','״̬','status','50');
INSERT INTO `excms_acl` VALUES ('109','60','ʾ','display','ʾ','display','50');
INSERT INTO `excms_acl` VALUES ('110','60','','settings','','settings','50');
INSERT INTO `excms_acl` VALUES ('111','61','½','add','½','insert','50');
INSERT INTO `excms_acl` VALUES ('112','61','༭','edit','༭','update','50');
INSERT INTO `excms_acl` VALUES ('113','61','ɾ','delete','ɾ','delete','50');
INSERT INTO `excms_acl` VALUES ('114','31','༭','edit','༭','store','50');
INSERT INTO `excms_acl` VALUES ('115','31','ɾ','delete','ɾ','delete','50');
INSERT INTO `excms_acl` VALUES ('116','64','','resetpwd','','setpassword','50');
INSERT INTO `excms_acl` VALUES ('117','167','½','add','½','insert','50');
INSERT INTO `excms_acl` VALUES ('118','167','༭','edit','༭','update','50');
INSERT INTO `excms_acl` VALUES ('119','167','ɾ','delete','ɾ','delete','50');
INSERT INTO `excms_acl` VALUES ('120','56','','download','ģ','down','50');
INSERT INTO `excms_acl` VALUES ('121','6','½Դ','typeadd','½Դ','typeedit','50');
INSERT INTO `excms_acl` VALUES ('122','6','½Դ','nodeadd','½Դ','nodeedit','50');
INSERT INTO `excms_acl` VALUES ('123','6','༭','typeedit','༭','nodeedit','50');
INSERT INTO `excms_acl` VALUES ('124','6','ɾ','typedelete','ɾ','typedelete','50');
INSERT INTO `excms_acl` VALUES ('125','6','','config','','commitNodeConfig','50');
INSERT INTO `excms_acl` VALUES ('126','67','','treeadd','','treeinsert','50');
INSERT INTO `excms_acl` VALUES ('127','67','༭','treeedit','༭','treeupdate','50');
INSERT INTO `excms_acl` VALUES ('128','67','ɾ','treedelete','ɾ','treedelete','50');
INSERT INTO `excms_acl` VALUES ('130','67','','updatesort','','updatesort','50');
INSERT INTO `excms_acl` VALUES ('133','29','','setting',',˺Ƽ','setting','50');
INSERT INTO `excms_acl` VALUES ('134','29','','update','ʾ,(,ҳ,Ŀ)','update','50');
INSERT INTO `excms_acl` VALUES ('135','29','۵','comment,click',',ݵ','comment,getHits','50');
INSERT INTO `excms_acl` VALUES ('136','30','','update','Զҳ','update','50');
INSERT INTO `excms_acl` VALUES ('137','56','ģĿ¼','enable','ģĿ¼','templateupdate','50');
INSERT INTO `excms_acl` VALUES ('138','77','ȫ','categorystore','ȫ','categorystore','50');
INSERT INTO `excms_acl` VALUES ('139','77','ȫƬ','blockpaging','ȫƬ','blockpaging','50');
INSERT INTO `excms_acl` VALUES ('140','27','½','addcategory','½','savegroup','50');
INSERT INTO `excms_acl` VALUES ('141','27','༭','editcategory','༭','savegroup','50');
INSERT INTO `excms_acl` VALUES ('142','27','ɾ','delcategory','ɾ','deletegroup','50');
INSERT INTO `excms_acl` VALUES ('143','56','ɾģĿ¼','del','ɾģĿ¼','templatedelete','50');

DROP TABLE IF EXISTS `excms_admin`;
CREATE TABLE `excms_admin` (
  `adminid` int(11) NOT NULL AUTO_INCREMENT,
  `adminname` char(20) DEFAULT NULL,
  `password` char(32) DEFAULT NULL,
  `fullname` varchar(40) DEFAULT NULL,
  `status` int(1) unsigned NOT NULL DEFAULT '0',
  `createddate` int(11) unsigned DEFAULT NULL,
  `logintimes` int(11) unsigned NOT NULL DEFAULT '0',
  `lastlogindate` int(11) unsigned DEFAULT NULL,
  `lastloginip` char(15) DEFAULT NULL,
  `description` varchar(250) DEFAULT NULL,
  `ssid`  char(32) DEFAULT NULL,
  PRIMARY KEY (`adminid`)
) ENGINE=MyISAM AUTO_INCREMENT=1001 DEFAULT CHARSET=gbk;

DROP TABLE IF EXISTS `excms_admin_group`;
CREATE TABLE `excms_admin_group` (
  `groupid` smallint(2) unsigned NOT NULL AUTO_INCREMENT,
  `name` char(20) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `system` tinyint(1) unsigned DEFAULT '0',
  `sort` tinyint(2) unsigned DEFAULT NULL,
  PRIMARY KEY (`groupid`)
) ENGINE=MyISAM AUTO_INCREMENT=1001 DEFAULT CHARSET=gbk;

INSERT INTO `excms_admin_group` VALUES ('1','Ա','Ա','1','1');
INSERT INTO `excms_admin_group` VALUES ('2','ϵͳԱ','ϵͳԱ','1','2');

DROP TABLE IF EXISTS `excms_admin_group_acl`;
CREATE TABLE `excms_admin_group_acl` (
  `groupid` int(11) DEFAULT NULL,
  `aclid` int(11) DEFAULT NULL,
  `menuid` int(11) DEFAULT NULL
) ENGINE=MyISAM AUTO_INCREMENT=1001 DEFAULT CHARSET=gbk;

INSERT INTO `excms_admin_group_acl` VALUES ('1','0','71');
INSERT INTO `excms_admin_group_acl` VALUES ('1','0','68');
INSERT INTO `excms_admin_group_acl` VALUES ('1','63','67');
INSERT INTO `excms_admin_group_acl` VALUES ('1','62','67');
INSERT INTO `excms_admin_group_acl` VALUES ('1','64','67');
INSERT INTO `excms_admin_group_acl` VALUES ('1','130','67');
INSERT INTO `excms_admin_group_acl` VALUES ('1','0','67');
INSERT INTO `excms_admin_group_acl` VALUES ('1','99','66');
INSERT INTO `excms_admin_group_acl` VALUES ('1','98','66');
INSERT INTO `excms_admin_group_acl` VALUES ('1','101','66');
INSERT INTO `excms_admin_group_acl` VALUES ('1','60','66');
INSERT INTO `excms_admin_group_acl` VALUES ('1','61','66');
INSERT INTO `excms_admin_group_acl` VALUES ('1','59','66');
INSERT INTO `excms_admin_group_acl` VALUES ('1','100','66');
INSERT INTO `excms_admin_group_acl` VALUES ('1','0','66');
INSERT INTO `excms_admin_group_acl` VALUES ('1','96','74');
INSERT INTO `excms_admin_group_acl` VALUES ('1','97','74');
INSERT INTO `excms_admin_group_acl` VALUES ('1','95','74');
INSERT INTO `excms_admin_group_acl` VALUES ('1','0','74');
INSERT INTO `excms_admin_group_acl` VALUES ('1','94','65');
INSERT INTO `excms_admin_group_acl` VALUES ('1','93','65');
INSERT INTO `excms_admin_group_acl` VALUES ('1','91','65');
INSERT INTO `excms_admin_group_acl` VALUES ('1','90','65');
INSERT INTO `excms_admin_group_acl` VALUES ('1','89','65');
INSERT INTO `excms_admin_group_acl` VALUES ('1','92','65');
INSERT INTO `excms_admin_group_acl` VALUES ('1','0','65');
INSERT INTO `excms_admin_group_acl` VALUES ('1','87','75');
INSERT INTO `excms_admin_group_acl` VALUES ('1','85','75');
INSERT INTO `excms_admin_group_acl` VALUES ('1','86','75');
INSERT INTO `excms_admin_group_acl` VALUES ('1','0','75');
INSERT INTO `excms_admin_group_acl` VALUES ('1','79','64');
INSERT INTO `excms_admin_group_acl` VALUES ('1','58','64');
INSERT INTO `excms_admin_group_acl` VALUES ('1','57','64');
INSERT INTO `excms_admin_group_acl` VALUES ('1','56','64');
INSERT INTO `excms_admin_group_acl` VALUES ('1','116','64');
INSERT INTO `excms_admin_group_acl` VALUES ('1','78','64');
INSERT INTO `excms_admin_group_acl` VALUES ('1','81','64');
INSERT INTO `excms_admin_group_acl` VALUES ('1','80','64');
INSERT INTO `excms_admin_group_acl` VALUES ('1','0','64');
INSERT INTO `excms_admin_group_acl` VALUES ('1','82','150');
INSERT INTO `excms_admin_group_acl` VALUES ('1','83','150');
INSERT INTO `excms_admin_group_acl` VALUES ('1','84','150');
INSERT INTO `excms_admin_group_acl` VALUES ('1','0','150');
INSERT INTO `excms_admin_group_acl` VALUES ('1','0','73');
INSERT INTO `excms_admin_group_acl` VALUES ('1','54','63');
INSERT INTO `excms_admin_group_acl` VALUES ('1','53','63');
INSERT INTO `excms_admin_group_acl` VALUES ('1','55','63');
INSERT INTO `excms_admin_group_acl` VALUES ('1','0','63');
INSERT INTO `excms_admin_group_acl` VALUES ('1','50','62');
INSERT INTO `excms_admin_group_acl` VALUES ('1','52','62');
INSERT INTO `excms_admin_group_acl` VALUES ('1','51','62');
INSERT INTO `excms_admin_group_acl` VALUES ('1','0','62');
INSERT INTO `excms_admin_group_acl` VALUES ('1','0','10');
INSERT INTO `excms_admin_group_acl` VALUES ('1','112','61');
INSERT INTO `excms_admin_group_acl` VALUES ('1','113','61');
INSERT INTO `excms_admin_group_acl` VALUES ('1','111','61');
INSERT INTO `excms_admin_group_acl` VALUES ('1','0','61');
INSERT INTO `excms_admin_group_acl` VALUES ('1','110','60');
INSERT INTO `excms_admin_group_acl` VALUES ('1','104','60');
INSERT INTO `excms_admin_group_acl` VALUES ('1','109','60');
INSERT INTO `excms_admin_group_acl` VALUES ('1','108','60');
INSERT INTO `excms_admin_group_acl` VALUES ('1','107','60');
INSERT INTO `excms_admin_group_acl` VALUES ('1','106','60');
INSERT INTO `excms_admin_group_acl` VALUES ('1','105','60');
INSERT INTO `excms_admin_group_acl` VALUES ('1','103','60');
INSERT INTO `excms_admin_group_acl` VALUES ('1','102','60');
INSERT INTO `excms_admin_group_acl` VALUES ('1','0','60');
INSERT INTO `excms_admin_group_acl` VALUES ('1','0','9');
INSERT INTO `excms_admin_group_acl` VALUES ('1','36','59');
INSERT INTO `excms_admin_group_acl` VALUES ('1','37','59');
INSERT INTO `excms_admin_group_acl` VALUES ('1','35','59');
INSERT INTO `excms_admin_group_acl` VALUES ('1','0','59');
INSERT INTO `excms_admin_group_acl` VALUES ('1','0','8');
INSERT INTO `excms_admin_group_acl` VALUES ('1','42','58');
INSERT INTO `excms_admin_group_acl` VALUES ('1','41','58');
INSERT INTO `excms_admin_group_acl` VALUES ('1','43','58');
INSERT INTO `excms_admin_group_acl` VALUES ('1','0','58');
INSERT INTO `excms_admin_group_acl` VALUES ('1','0','7');
INSERT INTO `excms_admin_group_acl` VALUES ('1','125','6');
INSERT INTO `excms_admin_group_acl` VALUES ('1','71','6');
INSERT INTO `excms_admin_group_acl` VALUES ('1','123','6');
INSERT INTO `excms_admin_group_acl` VALUES ('1','122','6');
INSERT INTO `excms_admin_group_acl` VALUES ('1','121','6');
INSERT INTO `excms_admin_group_acl` VALUES ('1','124','6');
INSERT INTO `excms_admin_group_acl` VALUES ('1','70','6');
INSERT INTO `excms_admin_group_acl` VALUES ('1','72','6');
INSERT INTO `excms_admin_group_acl` VALUES ('1','0','6');
INSERT INTO `excms_admin_group_acl` VALUES ('1','40','56');
INSERT INTO `excms_admin_group_acl` VALUES ('1','39','56');
INSERT INTO `excms_admin_group_acl` VALUES ('1','38','56');
INSERT INTO `excms_admin_group_acl` VALUES ('1','137','56');
INSERT INTO `excms_admin_group_acl` VALUES ('1','120','56');
INSERT INTO `excms_admin_group_acl` VALUES ('1','143','56');
INSERT INTO `excms_admin_group_acl` VALUES ('1','0','56');
INSERT INTO `excms_admin_group_acl` VALUES ('1','0','5');
INSERT INTO `excms_admin_group_acl` VALUES ('1','76','77');
INSERT INTO `excms_admin_group_acl` VALUES ('1','74','77');
INSERT INTO `excms_admin_group_acl` VALUES ('1','73','77');
INSERT INTO `excms_admin_group_acl` VALUES ('1','75','77');
INSERT INTO `excms_admin_group_acl` VALUES ('1','138','77');
INSERT INTO `excms_admin_group_acl` VALUES ('1','139','77');
INSERT INTO `excms_admin_group_acl` VALUES ('1','77','77');
INSERT INTO `excms_admin_group_acl` VALUES ('1','0','77');
INSERT INTO `excms_admin_group_acl` VALUES ('1','0','4');
INSERT INTO `excms_admin_group_acl` VALUES ('1','32','36');
INSERT INTO `excms_admin_group_acl` VALUES ('1','34','36');
INSERT INTO `excms_admin_group_acl` VALUES ('1','0','36');
INSERT INTO `excms_admin_group_acl` VALUES ('1','29','35');
INSERT INTO `excms_admin_group_acl` VALUES ('1','31','35');
INSERT INTO `excms_admin_group_acl` VALUES ('1','0','35');
INSERT INTO `excms_admin_group_acl` VALUES ('1','28','34');
INSERT INTO `excms_admin_group_acl` VALUES ('1','26','34');
INSERT INTO `excms_admin_group_acl` VALUES ('1','0','34');
INSERT INTO `excms_admin_group_acl` VALUES ('1','49','32');
INSERT INTO `excms_admin_group_acl` VALUES ('1','47','32');
INSERT INTO `excms_admin_group_acl` VALUES ('1','0','32');
INSERT INTO `excms_admin_group_acl` VALUES ('1','25','33');
INSERT INTO `excms_admin_group_acl` VALUES ('1','23','33');
INSERT INTO `excms_admin_group_acl` VALUES ('1','0','33');
INSERT INTO `excms_admin_group_acl` VALUES ('1','115','31');
INSERT INTO `excms_admin_group_acl` VALUES ('1','114','31');
INSERT INTO `excms_admin_group_acl` VALUES ('1','0','31');
INSERT INTO `excms_admin_group_acl` VALUES ('1','45','30');
INSERT INTO `excms_admin_group_acl` VALUES ('1','44','30');
INSERT INTO `excms_admin_group_acl` VALUES ('1','46','30');
INSERT INTO `excms_admin_group_acl` VALUES ('1','136','30');
INSERT INTO `excms_admin_group_acl` VALUES ('1','0','30');
INSERT INTO `excms_admin_group_acl` VALUES ('1','9','29');
INSERT INTO `excms_admin_group_acl` VALUES ('1','10','29');
INSERT INTO `excms_admin_group_acl` VALUES ('1','135','29');
INSERT INTO `excms_admin_group_acl` VALUES ('1','133','29');
INSERT INTO `excms_admin_group_acl` VALUES ('1','134','29');
INSERT INTO `excms_admin_group_acl` VALUES ('1','11','29');
INSERT INTO `excms_admin_group_acl` VALUES ('1','0','29');
INSERT INTO `excms_admin_group_acl` VALUES ('1','0','3');
INSERT INTO `excms_admin_group_acl` VALUES ('1','21','27');
INSERT INTO `excms_admin_group_acl` VALUES ('1','7','27');
INSERT INTO `excms_admin_group_acl` VALUES ('1','6','27');
INSERT INTO `excms_admin_group_acl` VALUES ('1','5','27');
INSERT INTO `excms_admin_group_acl` VALUES ('1','140','27');
INSERT INTO `excms_admin_group_acl` VALUES ('1','141','27');
INSERT INTO `excms_admin_group_acl` VALUES ('1','142','27');
INSERT INTO `excms_admin_group_acl` VALUES ('1','20','27');
INSERT INTO `excms_admin_group_acl` VALUES ('1','0','27');
INSERT INTO `excms_admin_group_acl` VALUES ('1','117','167');
INSERT INTO `excms_admin_group_acl` VALUES ('1','118','167');
INSERT INTO `excms_admin_group_acl` VALUES ('1','119','167');
INSERT INTO `excms_admin_group_acl` VALUES ('1','0','167');
INSERT INTO `excms_admin_group_acl` VALUES ('1','18','26');
INSERT INTO `excms_admin_group_acl` VALUES ('1','19','26');
INSERT INTO `excms_admin_group_acl` VALUES ('1','1','26');
INSERT INTO `excms_admin_group_acl` VALUES ('1','3','26');
INSERT INTO `excms_admin_group_acl` VALUES ('1','2','26');
INSERT INTO `excms_admin_group_acl` VALUES ('1','0','26');
INSERT INTO `excms_admin_group_acl` VALUES ('1','0','25');
INSERT INTO `excms_admin_group_acl` VALUES ('1','0','76');
INSERT INTO `excms_admin_group_acl` VALUES ('1','14','24');
INSERT INTO `excms_admin_group_acl` VALUES ('1','13','24');
INSERT INTO `excms_admin_group_acl` VALUES ('1','15','24');
INSERT INTO `excms_admin_group_acl` VALUES ('1','16','24');
INSERT INTO `excms_admin_group_acl` VALUES ('1','17','24');
INSERT INTO `excms_admin_group_acl` VALUES ('1','0','24');
INSERT INTO `excms_admin_group_acl` VALUES ('1','0','23');
INSERT INTO `excms_admin_group_acl` VALUES ('1','0','2');

DROP TABLE IF EXISTS `excms_admin_group_block_acl`;
CREATE TABLE `excms_admin_group_block_acl` (
  `groupid` int(11) DEFAULT NULL,
  `blockid` int(11) DEFAULT NULL,
  `acl` char(7) DEFAULT NULL
) ENGINE=MyISAM DEFAULT CHARSET=gbk;


DROP TABLE IF EXISTS `excms_admin_group_channel_acl`;
CREATE TABLE `excms_admin_group_channel_acl` (
  `groupid` int(11) DEFAULT NULL,
  `channelid` int(11) DEFAULT NULL,
  `acl` char(7) DEFAULT NULL
) ENGINE=MyISAM DEFAULT CHARSET=gbk;


DROP TABLE IF EXISTS `excms_admin_relate`;
CREATE TABLE `excms_admin_relate` (
  `adminid` int(11) NOT NULL,
  `groupid` int(11) NOT NULL
) ENGINE=MyISAM AUTO_INCREMENT=1001 DEFAULT CHARSET=gbk;

INSERT INTO `excms_admin_relate` VALUES ('1','1');

DROP TABLE IF EXISTS `excms_block`;
CREATE TABLE `excms_block` (
  `blockid` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `categoryid` smallint(5) unsigned DEFAULT NULL,
  `name` varchar(40) DEFAULT NULL,
  `type` enum('html','auto','manu','rss','json','rpc') NOT NULL,
  `code` text,
  `compiledcode` text,
  `data` longtext,
  `html` longtext,
  `url` varchar(255) DEFAULT NULL,
  `method` varchar(50) DEFAULT NULL,
  `args` varchar(255) DEFAULT NULL,
  `rows` tinyint(2) unsigned DEFAULT '0',
  `frequency` smallint(5) unsigned DEFAULT NULL,
  `width` smallint(5) unsigned DEFAULT '0',
  `publisheddate` int(10) unsigned DEFAULT NULL,
  `nextdate` int(10) unsigned DEFAULT NULL,
  `updateddate` int(10) unsigned DEFAULT NULL,
  `updatedby` mediumint(8) unsigned DEFAULT NULL,
  `lockeddate` int(10) unsigned DEFAULT NULL,
  `lockedby` mediumint(8) unsigned DEFAULT NULL,
  `createddate` int(10) unsigned DEFAULT NULL,
  `createdby` mediumint(8) unsigned DEFAULT NULL,
  `comment` varchar(100) DEFAULT NULL,
  `sort` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`blockid`)
) ENGINE=MyISAM AUTO_INCREMENT=1001 DEFAULT CHARSET=gbk;

INSERT INTO `excms_block` VALUES (1,1,'ͷ','auto','{list listtype=recommend type=head row=4}\n{loop item=cnt}\n<div class=\"content-head\">\n<h2><a href=\"{$cnt.url}\" target=\"_blank\">{$cnt.title}</a></h2>\n<p>\n{list listtype=related id=$cnt._contentid}\n{loop item=rtitle}<a href=\"{$rtitle.url}\" target=\"_blank\">{$rtitle.title}</a>{if !$rtitle._loop_last} | {/if}{/loop}\n{listelse}{$cnt.description length=150}<a href=\"{$cnt.url}\" class=\"cred\" target=\"_blank\">[Ķȫ]</a>{/list}\n</p>\n</div>\n{/loop}\n{/list}','<?php /* EXCMS template, created on 2010-12-28 16:29:43 compiled from  */\nfunction excms_block_func_1(){\n\n?>\n<?php \n$_list_from_array = EXCMSTPL::_list(array(\'listtype\' => \'recommend\',\'type\' => \'head\',\'row\' => \'4\',\'fields\' => \'url,title,description\',\'channelid\' => $_PAGE_CHANNEL[\'_channelid\'],));\nif(is_array($_list_from_array[\'from\']) && count($_list_from_array[\'from\'])):\n$_list_from = &$_list_from_array[\'from\'];\n$_list_total = &$_list_from_array[\'total\'];\n?>\n<?php\nif(is_array($_list_from) && count($_list_from)):\n$cnt_loop_total = count($_list_from);\n$cnt_loop_rownum = 0;\nforeach($_list_from as $key => $cnt):\n$cnt[\'_loop_key\'] = $key;\n$cnt[\'_loop_rownum\'] = ++$cnt_loop_rownum;\n$cnt[\'_loop_total\'] = $cnt_loop_total;\n$cnt[\'_loop_first\'] = ($cnt[\'_loop_rownum\'] == 1);\n$cnt[\'_loop_last\'] = ($cnt[\'_loop_rownum\'] == $cnt[\'_loop_total\']);\n?>\n<div class=\"content-head\">\n<h2><a href=\"<?php echo $cnt[\'url\']; ?>\" target=\"_blank\"><?php echo $cnt[\'title\']; ?></a></h2>\n<p>\n<?php \n$_list_from_array = EXCMSTPL::_list(array(\'listtype\' => \'related\',\'id\' => $cnt[\'_contentid\'],\'from\' => &$cnt,\'fields\' => \'url,title\',\'channelid\' => &$cnt[\'_channelid\'],));\nif(is_array($_list_from_array[\'from\']) && count($_list_from_array[\'from\'])):\n$_list_from = &$_list_from_array[\'from\'];\n$_list_total = &$_list_from_array[\'total\'];\n?>\n<?php\nif(is_array($_list_from) && count($_list_from)):\n$rtitle_loop_total = count($_list_from);\n$rtitle_loop_rownum = 0;\nforeach($_list_from as $key => $rtitle):\n$rtitle[\'_loop_key\'] = $key;\n$rtitle[\'_loop_rownum\'] = ++$rtitle_loop_rownum;\n$rtitle[\'_loop_total\'] = $rtitle_loop_total;\n$rtitle[\'_loop_first\'] = ($rtitle[\'_loop_rownum\'] == 1);\n$rtitle[\'_loop_last\'] = ($rtitle[\'_loop_rownum\'] == $rtitle[\'_loop_total\']);\n?><a href=\"<?php echo $rtitle[\'url\']; ?>\" target=\"_blank\"><?php echo $rtitle[\'title\']; ?></a><?php if (! $rtitle[\'_loop_last\']): ?> | <?php endif; ?><?php endforeach; endif; ?>\n<?php else: ?><?php echo csubstr($cnt[\'description\'],150,0,true); ?><a href=\"<?php echo $cnt[\'url\']; ?>\" class=\"cred\" target=\"_blank\">[Ķȫ]</a><?php endif; unset($_list_from_array); ?>\n</p>\n</div>\n<?php endforeach; endif; ?>\n<?php endif; unset($_list_from_array); ?>\n<?php }','','','','','',0,3600,0,0,1293528584,1293524984,1,0,0,1290838715,1,'',100),(2,1,'½','auto','{list listtype=recommend type=focus row=10}\n<ul class=\"list\">\n{loop item=cnt}\n<li><a href=\"{$cnt.url}\">{$cnt.title}</a></li>\n{if $cnt._loop_rownum==5}\n</ul>\n<span class=\"dotline\"></span>\n<ul class=\"list\">\n{/if}\n{/loop}\n</ul>\n{/list}','<?php /* EXCMS template, created on 2010-12-28 16:29:52 compiled from  */\nfunction excms_block_func_2(){\n\n?>\n<?php \n$_list_from_array = EXCMSTPL::_list(array(\'listtype\' => \'recommend\',\'type\' => \'focus\',\'row\' => \'10\',\'fields\' => \'url,title\',\'channelid\' => $_PAGE_CHANNEL[\'_channelid\'],));\nif(is_array($_list_from_array[\'from\']) && count($_list_from_array[\'from\'])):\n$_list_from = &$_list_from_array[\'from\'];\n$_list_total = &$_list_from_array[\'total\'];\n?>\n<ul class=\"list\">\n<?php\nif(is_array($_list_from) && count($_list_from)):\n$cnt_loop_total = count($_list_from);\n$cnt_loop_rownum = 0;\nforeach($_list_from as $key => $cnt):\n$cnt[\'_loop_key\'] = $key;\n$cnt[\'_loop_rownum\'] = ++$cnt_loop_rownum;\n$cnt[\'_loop_total\'] = $cnt_loop_total;\n$cnt[\'_loop_first\'] = ($cnt[\'_loop_rownum\'] == 1);\n$cnt[\'_loop_last\'] = ($cnt[\'_loop_rownum\'] == $cnt[\'_loop_total\']);\n?>\n<li><a href=\"<?php echo $cnt[\'url\']; ?>\"><?php echo $cnt[\'title\']; ?></a></li>\n<?php if ($cnt[\'_loop_rownum\'] == 5): ?>\n</ul>\n<span class=\"dotline\"></span>\n<ul class=\"list\">\n<?php endif; ?>\n<?php endforeach; endif; ?>\n</ul>\n<?php endif; unset($_list_from_array); ?>\n<?php }','','','','','',0,3600,0,0,1293528592,1293524992,1,0,0,1290838891,1,'',100),(3,1,'Ƽ','auto','{list listtype=recommend type=recommend row=10}\n<ul class=\"list\">\n{loop item=cnt}\n<li><a href=\"{$cnt.url}\">{$cnt.title}</a></li>\n{/loop}\n</ul>\n{/list}','<?php /* EXCMS template, created on 2010-12-28 16:29:55 compiled from  */\nfunction excms_block_func_3(){\n\n?>\n<?php \n$_list_from_array = EXCMSTPL::_list(array(\'listtype\' => \'recommend\',\'type\' => \'recommend\',\'row\' => \'10\',\'fields\' => \'url,title\',\'channelid\' => $_PAGE_CHANNEL[\'_channelid\'],));\nif(is_array($_list_from_array[\'from\']) && count($_list_from_array[\'from\'])):\n$_list_from = &$_list_from_array[\'from\'];\n$_list_total = &$_list_from_array[\'total\'];\n?>\n<ul class=\"list\">\n<?php\nif(is_array($_list_from) && count($_list_from)):\n$cnt_loop_total = count($_list_from);\n$cnt_loop_rownum = 0;\nforeach($_list_from as $key => $cnt):\n$cnt[\'_loop_key\'] = $key;\n$cnt[\'_loop_rownum\'] = ++$cnt_loop_rownum;\n$cnt[\'_loop_total\'] = $cnt_loop_total;\n$cnt[\'_loop_first\'] = ($cnt[\'_loop_rownum\'] == 1);\n$cnt[\'_loop_last\'] = ($cnt[\'_loop_rownum\'] == $cnt[\'_loop_total\']);\n?>\n<li><a href=\"<?php echo $cnt[\'url\']; ?>\"><?php echo $cnt[\'title\']; ?></a></li>\n<?php endforeach; endif; ?>\n</ul>\n<?php endif; unset($_list_from_array); ?>\n<?php }','','','','','',0,3600,0,0,1293528595,1293524995,1,0,0,1290838937,1,'',100),(4,1,'»õ','auto','{list listtype=flash image=true row=5}\n<li><a href=\"{$cnt.url}\" class=\"img\"><strong class=\"txt\">{$cnt.title}</strong><img src=\"{$cnt.thumb postfix=ss}\" alt=\"{$cnt.title}\"></a></li>\n{/list}','<?php /* EXCMS template, created on 2010-12-28 16:34:03 compiled from  */\nfunction excms_block_func_4(){\n\n?>\n<?php \n$_list_from_array = EXCMSTPL::_list(array(\'listtype\' => \'flash\',\'image\' => \'true\',\'row\' => \'5\',\'channelid\' => $_PAGE_CHANNEL[\'_channelid\'],));\nif(is_array($_list_from_array[\'from\']) && count($_list_from_array[\'from\'])):\n$_list_from = &$_list_from_array[\'from\'];\n$_list_total = &$_list_from_array[\'total\'];\n?>\n<li><a href=\"<?php echo $cnt[\'url\']; ?>\" class=\"img\"><strong class=\"txt\"><?php echo $cnt[\'title\']; ?></strong><img src=\"<?php echo EXCMS::imagePostfix($cnt[\'thumb\'],\'ss\',$cnt[\'_thumb_resource\']) ; ?>\" alt=\"<?php echo $cnt[\'title\']; ?>\"></a></li>\n<?php endif; unset($_list_from_array); ?>\n<?php }','','','','','',0,3600,0,0,1293528843,1293525243,1,0,0,1290839528,1,'',100),(5,1,'','auto','{list channelid=0 row=10}\n<ul class=\"list\">\n{loop item=cnt}\n<li><a href=\"{$cnt.url}\">{$cnt.title}</a></li>\n{/loop}\n</ul>\n{/list}','<?php /* EXCMS template, created on 2010-12-28 16:29:58 compiled from  */\nfunction excms_block_func_5(){\n\n?>\n<?php \n$_list_from_array = EXCMSTPL::_list(array(\'channelid\' => \'0\',\'row\' => \'10\',\'fields\' => \'url,title\',));\nif(is_array($_list_from_array[\'from\']) && count($_list_from_array[\'from\'])):\n$_list_from = &$_list_from_array[\'from\'];\n$_list_total = &$_list_from_array[\'total\'];\n?>\n<ul class=\"list\">\n<?php\nif(is_array($_list_from) && count($_list_from)):\n$cnt_loop_total = count($_list_from);\n$cnt_loop_rownum = 0;\nforeach($_list_from as $key => $cnt):\n$cnt[\'_loop_key\'] = $key;\n$cnt[\'_loop_rownum\'] = ++$cnt_loop_rownum;\n$cnt[\'_loop_total\'] = $cnt_loop_total;\n$cnt[\'_loop_first\'] = ($cnt[\'_loop_rownum\'] == 1);\n$cnt[\'_loop_last\'] = ($cnt[\'_loop_rownum\'] == $cnt[\'_loop_total\']);\n?>\n<li><a href=\"<?php echo $cnt[\'url\']; ?>\"><?php echo $cnt[\'title\']; ?></a></li>\n<?php endforeach; endif; ?>\n</ul>\n<?php endif; unset($_list_from_array); ?>\n<?php }','','','','','',0,3600,0,0,1293528599,1293524999,1,0,0,1290836516,1,'',100),(6,1,'ͼ','auto','{list channelid=0 row=6 image=true}\n<ul class=\"img-list\">\n{loop item=cnt}\n<li>\n<a href=\"{$cnt.url}\" class=\"img\"><img src=\"{$cnt.thumb}\" alt=\"{$cnt.title}\"></a>\n<span class=\"txt\"><a href=\"{$cnt.url}\">{$cnt.title}</a></span>\n</li>\n{/loop}\n</ul>\n{/list}','<?php /* EXCMS template, created on 2010-12-28 16:30:01 compiled from  */\nfunction excms_block_func_6(){\n\n?>\n<?php \n$_list_from_array = EXCMSTPL::_list(array(\'channelid\' => \'0\',\'row\' => \'6\',\'image\' => \'true\',\'fields\' => \'url,thumb,title\',));\nif(is_array($_list_from_array[\'from\']) && count($_list_from_array[\'from\'])):\n$_list_from = &$_list_from_array[\'from\'];\n$_list_total = &$_list_from_array[\'total\'];\n?>\n<ul class=\"img-list\">\n<?php\nif(is_array($_list_from) && count($_list_from)):\n$cnt_loop_total = count($_list_from);\n$cnt_loop_rownum = 0;\nforeach($_list_from as $key => $cnt):\n$cnt[\'_loop_key\'] = $key;\n$cnt[\'_loop_rownum\'] = ++$cnt_loop_rownum;\n$cnt[\'_loop_total\'] = $cnt_loop_total;\n$cnt[\'_loop_first\'] = ($cnt[\'_loop_rownum\'] == 1);\n$cnt[\'_loop_last\'] = ($cnt[\'_loop_rownum\'] == $cnt[\'_loop_total\']);\n?>\n<li>\n<a href=\"<?php echo $cnt[\'url\']; ?>\" class=\"img\"><img src=\"<?php echo $cnt[\'thumb\']; ?>\" alt=\"<?php echo $cnt[\'title\']; ?>\"></a>\n<span class=\"txt\"><a href=\"<?php echo $cnt[\'url\']; ?>\"><?php echo $cnt[\'title\']; ?></a></span>\n</li>\n<?php endforeach; endif; ?>\n</ul>\n<?php endif; unset($_list_from_array); ?>\n<?php }','','','','','',0,3600,0,0,1293528601,1293525001,1,0,0,1290836799,1,'',100),(7,1,'ͼƬ','auto','{list row=6 model=image image=true}\n<ul class=\"img-list\">\n{loop item=cnt}\n<li>\n<a href=\"{$cnt.url}\" class=\"img\"><img src=\"{$cnt.thumb}\" alt=\"{$cnt.title}\"></a>\n<span class=\"txt\"><a href=\"{$cnt.url}\">{$cnt.title}</a></span>\n</li>\n{/loop}\n</ul>\n{/list}','<?php /* EXCMS template, created on 2010-12-28 16:30:03 compiled from  */\nfunction excms_block_func_7(){\n\n?>\n<?php \n$_list_from_array = EXCMSTPL::_list(array(\'row\' => \'6\',\'model\' => \'image\',\'image\' => \'true\',\'fields\' => \'url,thumb,title\',\'channelid\' => $_PAGE_CHANNEL[\'_channelid\'],));\nif(is_array($_list_from_array[\'from\']) && count($_list_from_array[\'from\'])):\n$_list_from = &$_list_from_array[\'from\'];\n$_list_total = &$_list_from_array[\'total\'];\n?>\n<ul class=\"img-list\">\n<?php\nif(is_array($_list_from) && count($_list_from)):\n$cnt_loop_total = count($_list_from);\n$cnt_loop_rownum = 0;\nforeach($_list_from as $key => $cnt):\n$cnt[\'_loop_key\'] = $key;\n$cnt[\'_loop_rownum\'] = ++$cnt_loop_rownum;\n$cnt[\'_loop_total\'] = $cnt_loop_total;\n$cnt[\'_loop_first\'] = ($cnt[\'_loop_rownum\'] == 1);\n$cnt[\'_loop_last\'] = ($cnt[\'_loop_rownum\'] == $cnt[\'_loop_total\']);\n?>\n<li>\n<a href=\"<?php echo $cnt[\'url\']; ?>\" class=\"img\"><img src=\"<?php echo $cnt[\'thumb\']; ?>\" alt=\"<?php echo $cnt[\'title\']; ?>\"></a>\n<span class=\"txt\"><a href=\"<?php echo $cnt[\'url\']; ?>\"><?php echo $cnt[\'title\']; ?></a></span>\n</li>\n<?php endforeach; endif; ?>\n</ul>\n<?php endif; unset($_list_from_array); ?>\n<?php }','','','','','',0,3600,0,0,1293528603,1293525003,1,0,0,1290839086,1,'',100),(8,1,'','auto','<div class=\"area\">\n<div class=\"hd\">\n<h2><a class=\"cred\" href=\"{url name=top}\" target=\"_blank\"></a></h2>\n<div class=\"tabs tab3 r-tabs\" id=\"tab-switch-rank\">\n<span class=\"tab-item current\"><a href=\"{url name=top}\" target=\"_blank\"></a></span>\n<span class=\"tab-item\"><a href=\"{url name=comment}\" target=\"_blank\"></a></span>\n<span class=\"tab-item\"><a href=\"{url name=digg}\" target=\"_blank\">ע</a></span>\n</div>\n</div>\n<div class=\"bd\" id=\"tab-switch-rank-body\">\n<ul class=\"list rank-list\">\n{list listtype=click row=10 order=week}\n{loop item=cnt}\n<li><em class=\"ranknum {if $cnt._loop_rownum lt 4}rankred{/if}\">{$cnt._loop_rownum}</em><a href=\"{$cnt.url}\" target=\"_blank\">{$cnt.title}</a></li>\n{/loop}\n{/list}\n</ul>\n\n<ul class=\"list commentlist\" style=\"display:none\">\n{list listtype=comment row=10 rank=week allowpage=0}\n{loop item=cnt}\n<li><a href=\"{$cnt.item.url}\" target=\"_blank\" class=\"fl\">{$cnt.item.title}</a><a href=\"{$cnt.url}\" class=\"fr cred linum\" target=\"_blank\">{$cnt.commentnum}</a></li>\n{/loop}\n{/list}\n</ul>\n\n<ul class=\"list digglist\" style=\"display:none\">\n{list listtype=digg row=10}\n{loop item=cnt}\n<li><a href=\"{$cnt.url}\" target=\"_blank\" class=\"fl\">{$cnt.title}</a><span class=\"linum\">{$cnt.digg}</span></li>\n{/loop}\n{/list}\n</ul>\n</div>\n<script language=\"javascript\">inittab(\'tab-switch-rank\',\'span\')</script>\n</div>','','','<div class=\"area\">\n<div class=\"hd\">\n<h2><a class=\"cred\" href=\"/top.php\" target=\"_blank\"></a></h2>\n<div class=\"tabs tab3 righttabs\" id=\"tab-switch-rank\">\n<span class=\"tab-item current\"><a href=\"/top.php\" target=\"_blank\"></a></span>\n<span class=\"tab-item\"><a href=\"\" target=\"_blank\"></a></span>\n<span class=\"tab-item\"><a href=\"\" target=\"_blank\">ע</a></span>\n</div>\n</div>\n<div class=\"bd\" id=\"tab-switch-rank-body\">\n<ul class=\"list rank-list\">\n</ul>\n\n<ul class=\"list commentlist\" style=\"display:none\">\n</ul>\n\n<ul class=\"list digglist\" style=\"display:none\">\n</ul>\n</div>\n<script language=\"javascript\">inittab(\'tab-switch-rank\',\'span\')</script>\n</div>\n','','','',0,3600,0,0,1293528610,1293525010,1,0,0,1290834141,1,'',100),(9,1,'','auto','<ul class=\"list rank-list\">\n{list listtype=click row=10 order=week}\n{loop item=cnt}\n<li><em class=\"ranknum {if $cnt._loop_rownum lt 4}rankred{/if}\">{$cnt._loop_rownum}</em><a href=\"{$cnt.url}\" target=\"_blank\">{$cnt.title}</a></li>\n{/loop}\n{/list}\n</ul>','','','<ul class=\"list rank-list\">\n</ul>\n','','','',0,3600,0,0,1293528614,1293525014,1,0,0,1290836963,1,'',100),(10,1,'','auto','<ul class=\"list commentlist\">\n{list listtype=comment row=10 rank=week allowpage=0}\n{loop item=cnt}\n<li><a href=\"{$cnt.item.url}\" target=\"_blank\" class=\"fl\">{$cnt.item.title length=28}</a><a href=\"{$cnt.url}\" class=\"fr cred\" target=\"_blank\">{$cnt.commentnum}</a></li>\n{/loop}\n{/list}\n</ul>','<?php /* EXCMS template, created on 2010-12-28 16:30:16 compiled from  */\nfunction excms_block_func_10(){\n\n?>\n<ul class=\"list commentlist\">\n<?php \n$_list_from_array = EXCMSTPL::_list(array(\'listtype\' => \'comment\',\'row\' => \'10\',\'rank\' => \'week\',\'allowpage\' => \'0\',\'fields\' => \'item.url,item.title,url,commentnum\',\'channelid\' => $_PAGE_CHANNEL[\'_channelid\'],));\nif(is_array($_list_from_array[\'from\']) && count($_list_from_array[\'from\'])):\n$_list_from = &$_list_from_array[\'from\'];\n$_list_total = &$_list_from_array[\'total\'];\n?>\n<?php\nif(is_array($_list_from) && count($_list_from)):\n$cnt_loop_total = count($_list_from);\n$cnt_loop_rownum = 0;\nforeach($_list_from as $key => $cnt):\n$cnt[\'_loop_key\'] = $key;\n$cnt[\'_loop_rownum\'] = ++$cnt_loop_rownum;\n$cnt[\'_loop_total\'] = $cnt_loop_total;\n$cnt[\'_loop_first\'] = ($cnt[\'_loop_rownum\'] == 1);\n$cnt[\'_loop_last\'] = ($cnt[\'_loop_rownum\'] == $cnt[\'_loop_total\']);\n?>\n<li><a href=\"<?php echo $cnt[\'item\'][\'url\']; ?>\" target=\"_blank\" class=\"fl\"><?php echo csubstr($cnt[\'item\'][\'title\'],28,0,true); ?></a><a href=\"<?php echo $cnt[\'url\']; ?>\" class=\"fr cred\" target=\"_blank\"><?php echo $cnt[\'commentnum\']; ?></a></li>\n<?php endforeach; endif; ?>\n<?php endif; unset($_list_from_array); ?>\n</ul>\n<?php }','','<ul class=\"list commentlist\">\n</ul>\n','','','',0,3600,0,0,1293528616,1293525016,1,0,0,1290836997,1,'',100),(11,1,'ע','auto','<ul class=\"list digglist\">\n{list listtype=digg row=10}\n{loop item=cnt}\n<li><a href=\"{$cnt.url}\" target=\"_blank\" class=\"fl\">{$cnt.title}</a><span class=\"linum\">{$cnt.digg}</span></li>\n{/loop}\n{/list}\n</ul>','<?php /* EXCMS template, created on 2010-12-28 16:30:18 compiled from  */\nfunction excms_block_func_11(){\n\n?>\n<ul class=\"list digglist\">\n<?php \n$_list_from_array = EXCMSTPL::_list(array(\'listtype\' => \'digg\',\'row\' => \'10\',\'fields\' => \'url,title,digg\',\'channelid\' => $_PAGE_CHANNEL[\'_channelid\'],));\nif(is_array($_list_from_array[\'from\']) && count($_list_from_array[\'from\'])):\n$_list_from = &$_list_from_array[\'from\'];\n$_list_total = &$_list_from_array[\'total\'];\n?>\n<?php\nif(is_array($_list_from) && count($_list_from)):\n$cnt_loop_total = count($_list_from);\n$cnt_loop_rownum = 0;\nforeach($_list_from as $key => $cnt):\n$cnt[\'_loop_key\'] = $key;\n$cnt[\'_loop_rownum\'] = ++$cnt_loop_rownum;\n$cnt[\'_loop_total\'] = $cnt_loop_total;\n$cnt[\'_loop_first\'] = ($cnt[\'_loop_rownum\'] == 1);\n$cnt[\'_loop_last\'] = ($cnt[\'_loop_rownum\'] == $cnt[\'_loop_total\']);\n?>\n<li><a href=\"<?php echo $cnt[\'url\']; ?>\" target=\"_blank\" class=\"fl\"><?php echo $cnt[\'title\']; ?></a><span class=\"linum\"><?php echo $cnt[\'digg\']; ?></span></li>\n<?php endforeach; endif; ?>\n<?php endif; unset($_list_from_array); ?>\n</ul>\n<?php }','','<ul class=\"list digglist\">\n</ul>\n','','','',0,3600,0,0,1293528618,1293525018,1,0,0,1290837024,1,'',100),(12,1,'±ǩ','auto','{list listtype=tag row=40 sort=new}\r\n<div class=\"tag-cloud\">\r\n{loop item=tag}{$tag.fulllink}{/loop}\r\n</div>\r\n{/list}','<?php /* EXCMS template, created on 2010-12-28 16:30:22 compiled from  */\nfunction excms_block_func_12(){\n\n?>\n<?php \n$_list_from_array = EXCMSTPL::_list(array(\'listtype\' => \'tag\',\'row\' => \'40\',\'sort\' => \'new\',\'fields\' => \'fulllink\',\'channelid\' => $_PAGE_CHANNEL[\'_channelid\'],));\nif(is_array($_list_from_array[\'from\']) && count($_list_from_array[\'from\'])):\n$_list_from = &$_list_from_array[\'from\'];\n$_list_total = &$_list_from_array[\'total\'];\n?>\r\n<div class=\"tag-cloud\">\r\n<?php\nif(is_array($_list_from) && count($_list_from)):\n$tag_loop_total = count($_list_from);\n$tag_loop_rownum = 0;\nforeach($_list_from as $key => $tag):\n$tag[\'_loop_key\'] = $key;\n$tag[\'_loop_rownum\'] = ++$tag_loop_rownum;\n$tag[\'_loop_total\'] = $tag_loop_total;\n$tag[\'_loop_first\'] = ($tag[\'_loop_rownum\'] == 1);\n$tag[\'_loop_last\'] = ($tag[\'_loop_rownum\'] == $tag[\'_loop_total\']);\n?><?php echo $tag[\'fulllink\']; ?><?php endforeach; endif; ?>\r\n</div>\r\n<?php endif; unset($_list_from_array); ?>\n<?php }','','','','','',0,3600,0,0,1293528622,1293525022,1,0,0,1290837454,1,'',100),(13,1,'һ','auto','<ul class=\"list rank-list\">\n{list listtype=comment row=5 rank=week allowpage=0}\n{loop item=cnt}\n<li><em class=\"ranknum{if $cnt._loop_rownum}<4} rankred{/if}\">{$cnt._loop_rownum}</em><a href=\"{$cnt.item.url}\" target=\"_blank\">{$cnt.item.title}</a> <span class=\"date\"><font class=\"cred\">{$cnt.commentnum}</font></span></li>\n{/loop}\n{/list}\n</ul>','','','<ul class=\"list rank-list\">\n</ul>\n','','','',0,3600,0,0,1293352959,1293349359,1,0,0,1290995323,1,'',100),(50,1,'ÿƼ','manu','{list listtype=block}\n<ul class=\"list\">\n{loop item=array fromname=loop}\n<li>\n{loop item=cnt from=$loop}\n<a href=\"{$cnt.url}\" target=\"_blank\" style=\"color:{$cnt.color};{if $cnt.bold}font-weight:bold;{/if}\">{$cnt.title}</a>\n{/loop}\n</li>\n{/loop}\n</ul>\n{/list}','','','','','','',0,3600,0,0,0,1293525085,1,0,0,1290845338,1,'',100),(51,1,'ȵͼƬ','manu','{list listtype=block}\n<ul class=\"img-list\">\n{loop item=array fromname=loop}\n<li>\n{loop item=cnt from=$loop}\n<a href=\"{$cnt.url}\" target=\"_blank\" class=\"img\"><img src=\"{$cnt.thumb}\" alt=\"{$cnt.title}\"></a>\n<span class=\"txt\"><a href=\"{$cnt.url}\" target=\"_blank\" style=\"color:{$cnt.color};{if $cnt.bold}font-weight:bold;{/if}\">{$cnt.title}</a></span>\n{/loop}\n</li>\n{/loop}\n</ul>\n{/list}','<?php /* EXCMS template, created on 2010-12-28 16:31:36 compiled from  */\nfunction excms_block_func_51(){\n\n?>\n<?php \n$_list_from_array = EXCMSTPL::_list(array(\'listtype\' => \'block\',\'channelid\' => $_PAGE_CHANNEL[\'_channelid\'],));\nif(is_array($_list_from_array[\'from\']) && count($_list_from_array[\'from\'])):\n$_list_from = &$_list_from_array[\'from\'];\n$_list_total = &$_list_from_array[\'total\'];\n?>\n<ul class=\"img-list\">\n<?php\nif(is_array($_list_from) && count($_list_from)):\n$array_loop_total = count($_list_from);\n$array_loop_rownum = 0;\nforeach($_list_from as $key => $array):\n$loop = $array;\n$array[\'_loop_key\'] = $key;\n$array[\'_loop_rownum\'] = ++$array_loop_rownum;\n$array[\'_loop_total\'] = $array_loop_total;\n$array[\'_loop_first\'] = ($array[\'_loop_rownum\'] == 1);\n$array[\'_loop_last\'] = ($array[\'_loop_rownum\'] == $array[\'_loop_total\']);\n?>\n<li>\n<?php\nif(is_array($loop) && count($loop)):\n$cnt_loop_total = count($loop);\n$cnt_loop_rownum = 0;\nforeach($loop as $key => $cnt):\n$cnt[\'_loop_key\'] = $key;\n$cnt[\'_loop_rownum\'] = ++$cnt_loop_rownum;\n$cnt[\'_loop_total\'] = $cnt_loop_total;\n$cnt[\'_loop_first\'] = ($cnt[\'_loop_rownum\'] == 1);\n$cnt[\'_loop_last\'] = ($cnt[\'_loop_rownum\'] == $cnt[\'_loop_total\']);\n?>\n<a href=\"<?php echo $cnt[\'url\']; ?>\" target=\"_blank\" class=\"img\"><img src=\"<?php echo $cnt[\'thumb\']; ?>\" alt=\"<?php echo $cnt[\'title\']; ?>\"></a>\n<span class=\"txt\"><a href=\"<?php echo $cnt[\'url\']; ?>\" target=\"_blank\" style=\"color:<?php echo $cnt[\'color\']; ?>;<?php if ($cnt[\'bold\']): ?>font-weight:bold;<?php endif; ?>\"><?php echo $cnt[\'title\']; ?></a></span>\n<?php endforeach; endif; ?>\n</li>\n<?php endforeach; endif; ?>\n</ul>\n<?php endif; unset($_list_from_array); ?>\n<?php }','','','','','',0,3600,0,0,0,1293525096,1,0,0,1290149637,1,'',100),(52,1,'ҳƼͼƬ','manu','{list listtype=block}\n<ul class=\"img-list\">\n{loop item=array fromname=loop}\n<li>\n{loop item=cnt from=$loop}\n<a href=\"{$cnt.url}\" target=\"_blank\" class=\"img\"><img src=\"{$cnt.thumb}\" alt=\"{$cnt.title}\"></a>\n<span class=\"txt2row\"><a href=\"{$cnt.url}\" target=\"_blank\" style=\"color:{$cnt.color};{if $cnt.bold}font-weight:bold;{/if}\">{$cnt.title}</a></span>\n{/loop}\n</li>\n{/loop}\n</ul>\n{/list}','<?php /* EXCMS template, created on 2010-12-28 16:31:53 compiled from  */\nfunction excms_block_func_52(){\n\n?>\n<?php \n$_list_from_array = EXCMSTPL::_list(array(\'listtype\' => \'block\',\'channelid\' => $_PAGE_CHANNEL[\'_channelid\'],));\nif(is_array($_list_from_array[\'from\']) && count($_list_from_array[\'from\'])):\n$_list_from = &$_list_from_array[\'from\'];\n$_list_total = &$_list_from_array[\'total\'];\n?>\n<ul class=\"img-list\">\n<?php\nif(is_array($_list_from) && count($_list_from)):\n$array_loop_total = count($_list_from);\n$array_loop_rownum = 0;\nforeach($_list_from as $key => $array):\n$loop = $array;\n$array[\'_loop_key\'] = $key;\n$array[\'_loop_rownum\'] = ++$array_loop_rownum;\n$array[\'_loop_total\'] = $array_loop_total;\n$array[\'_loop_first\'] = ($array[\'_loop_rownum\'] == 1);\n$array[\'_loop_last\'] = ($array[\'_loop_rownum\'] == $array[\'_loop_total\']);\n?>\n<li>\n<?php\nif(is_array($loop) && count($loop)):\n$cnt_loop_total = count($loop);\n$cnt_loop_rownum = 0;\nforeach($loop as $key => $cnt):\n$cnt[\'_loop_key\'] = $key;\n$cnt[\'_loop_rownum\'] = ++$cnt_loop_rownum;\n$cnt[\'_loop_total\'] = $cnt_loop_total;\n$cnt[\'_loop_first\'] = ($cnt[\'_loop_rownum\'] == 1);\n$cnt[\'_loop_last\'] = ($cnt[\'_loop_rownum\'] == $cnt[\'_loop_total\']);\n?>\n<a href=\"<?php echo $cnt[\'url\']; ?>\" target=\"_blank\" class=\"img\"><img src=\"<?php echo $cnt[\'thumb\']; ?>\" alt=\"<?php echo $cnt[\'title\']; ?>\"></a>\n<span class=\"txt2row\"><a href=\"<?php echo $cnt[\'url\']; ?>\" target=\"_blank\" style=\"color:<?php echo $cnt[\'color\']; ?>;<?php if ($cnt[\'bold\']): ?>font-weight:bold;<?php endif; ?>\"><?php echo $cnt[\'title\']; ?></a></span>\n<?php endforeach; endif; ?>\n</li>\n<?php endforeach; endif; ?>\n</ul>\n<?php endif; unset($_list_from_array); ?>\n<?php }','','','','','',0,3600,0,0,0,1293525113,1,0,0,1290995497,1,'',100),(100,2,'ҳͷ','auto','{list listtype=recommend type=indexhead row=4}\n{loop item=cnt}\n<div class=\"content-head\">\n<h2><a href=\"{$cnt.url}\" target=\"_blank\">{$cnt.title}</a></h2>\n<p>\n{list listtype=related id=$cnt._contentid}\n{loop item=rtitle}<a href=\"{$rtitle.url}\" target=\"_blank\">{$rtitle.title}</a>{if !$rtitle._loop_last} | {/if}{/loop}\n{listelse}{$cnt.description length=150}<a href=\"{$cnt.url}\" class=\"cred\" target=\"_blank\">[Ķȫ]</a>{/list}\n</p>\n</div>\n{/loop}\n{/list}','','','','','','',0,3600,0,0,1293528753,1293525153,1,0,0,1290839611,1,'',100),(101,2,'ҳ','auto','{list listtype=recommend type=indexfocus row=10}\n<ul class=\"list\">\n{loop item=cnt}\n<li><a href=\"{$cnt.url}\">{$cnt.title}</a></li>\n{if $cnt._loop_rownum==5}\n</ul>\n<span class=\"dotline\"></span>\n<ul class=\"list\">\n{/if}\n{/loop}\n</ul>\n{/list}','<?php /* EXCMS template, created on 2010-12-28 16:32:35 compiled from  */\nfunction excms_block_func_101(){\n\n?>\n<?php \n$_list_from_array = EXCMSTPL::_list(array(\'listtype\' => \'recommend\',\'type\' => \'indexfocus\',\'row\' => \'10\',\'fields\' => \'url,title\',\'channelid\' => $_PAGE_CHANNEL[\'_channelid\'],));\nif(is_array($_list_from_array[\'from\']) && count($_list_from_array[\'from\'])):\n$_list_from = &$_list_from_array[\'from\'];\n$_list_total = &$_list_from_array[\'total\'];\n?>\n<ul class=\"list\">\n<?php\nif(is_array($_list_from) && count($_list_from)):\n$cnt_loop_total = count($_list_from);\n$cnt_loop_rownum = 0;\nforeach($_list_from as $key => $cnt):\n$cnt[\'_loop_key\'] = $key;\n$cnt[\'_loop_rownum\'] = ++$cnt_loop_rownum;\n$cnt[\'_loop_total\'] = $cnt_loop_total;\n$cnt[\'_loop_first\'] = ($cnt[\'_loop_rownum\'] == 1);\n$cnt[\'_loop_last\'] = ($cnt[\'_loop_rownum\'] == $cnt[\'_loop_total\']);\n?>\n<li><a href=\"<?php echo $cnt[\'url\']; ?>\"><?php echo $cnt[\'title\']; ?></a></li>\n<?php if ($cnt[\'_loop_rownum\'] == 5): ?>\n</ul>\n<span class=\"dotline\"></span>\n<ul class=\"list\">\n<?php endif; ?>\n<?php endforeach; endif; ?>\n</ul>\n<?php endif; unset($_list_from_array); ?>\n<?php }','','','','','',0,3600,0,0,1293528755,1293525155,1,0,0,1290839659,1,'',100),(102,2,'ҳƼ','auto','{list listtype=recommend type=indexrmd row=10}\n<ul class=\"list\">\n{loop item=cnt}\n<li><a href=\"{$cnt.url}\">{$cnt.title}</a></li>\n{/loop}\n</ul>\n{/list}','','','','','','',0,3600,0,0,1293528757,1293525157,1,0,0,1290839687,1,'',100),(103,2,'ҳõ','auto','{list listtype=indexflash image=true row=5}\n<li><a href=\"{$cnt.url}\" class=\"img\"><strong class=\"txt\">{$cnt.title}</strong><img src=\"{$cnt.thumb postfix=ss}\" alt=\"{$cnt.title}\"></a></li>\n{/list}','<?php /* EXCMS template, created on 2010-12-28 16:32:40 compiled from  */\nfunction excms_block_func_103(){\n\n?>\n<?php \n$_list_from_array = EXCMSTPL::_list(array(\'listtype\' => \'indexflash\',\'image\' => \'true\',\'row\' => \'5\',\'channelid\' => $_PAGE_CHANNEL[\'_channelid\'],));\nif(is_array($_list_from_array[\'from\']) && count($_list_from_array[\'from\'])):\n$_list_from = &$_list_from_array[\'from\'];\n$_list_total = &$_list_from_array[\'total\'];\n?>\n<li><a href=\"<?php echo $cnt[\'url\']; ?>\" class=\"img\"><strong class=\"txt\"><?php echo $cnt[\'title\']; ?></strong><img src=\"<?php echo EXCMS::imagePostfix($cnt[\'thumb\'],\'ss\',$cnt[\'_thumb_resource\']) ; ?>\" alt=\"<?php echo $cnt[\'title\']; ?>\"></a></li>\n<?php endif; unset($_list_from_array); ?>\n<?php }','','','','','',0,3600,0,0,1293528760,1293525160,1,0,0,1290839709,1,'',100),(110,2,'ҳͷ','manu','{list listtype=block}\n{loop item=array fromname=loop}\n{loop item=cnt from=$loop}\n<div class=\"content-head\">\n<h2><a href=\"{$cnt.url}\" target=\"_blank\" style=\"color:{$cnt.color};{if $cnt.bold}font-weight:bold;{/if}\">{$cnt.title}</a></h2>\n{if $cnt.rtitles}\n<p class=\"rtitle\">\n{loop from=$cnt.rtitles item=rtitle}<a href=\"{$rtitle.url}\" target=\"_blank\" style=\"color:{$rtitle.color};{if $rtitle.bold}font-weight:bold;{/if}\">{$rtitle.title}</a> {if !$rtitle._loop_last} | {/if}{/loop}\n</p>\n{elseif $cnt.description}\n<p class=\"desc\">{$cnt.description}<a href=\"{$cnt.url}\" class=\"cred\" target=\"_blank\">[ϸ]</a></p>\n{/if}\n</div>\n{/loop}\n{/loop}\n{/list}','','','','','','',0,3600,0,0,0,1293525175,1,0,0,1290149637,1,'',100),(111,2,'ҳ','manu','{list listtype=block}\n<ul class=\"list\">\n{loop item=array fromname=loop}\n<li>\n{loop item=cnt from=$loop}\n<a href=\"{$cnt.url}\" target=\"_blank\" style=\"color:{$cnt.color};{if $cnt.bold}font-weight:bold;{/if}\">{$cnt.title}</a>\n{if $cnt.tailtitle}<span class=\"tail\">{if $cnt.tailurl}<a href=\"{$cnt.tailurl}\" target=\"_blank\" style=\"color:{$cnt.tailcolor};{if $cnt.tailbold}font-weight:bold;{/if}\">{$cnt.tailtitle}</a>{else}{$cnt.tailtitle}{/if}</span>{/if}\n{/loop}\n</li>\n{if !$array._loop_last and $array._loop_rownum%5==0}</ul><span class=\"dotline\"></span><ul class=\"list\">{/if}\n{/loop}\n</ul>\n{/list}','<?php /* EXCMS template, created on 2010-12-28 16:33:10 compiled from  */\nfunction excms_block_func_111(){\n\n?>\n<?php \n$_list_from_array = EXCMSTPL::_list(array(\'listtype\' => \'block\',\'channelid\' => $_PAGE_CHANNEL[\'_channelid\'],));\nif(is_array($_list_from_array[\'from\']) && count($_list_from_array[\'from\'])):\n$_list_from = &$_list_from_array[\'from\'];\n$_list_total = &$_list_from_array[\'total\'];\n?>\n<ul class=\"list\">\n<?php\nif(is_array($_list_from) && count($_list_from)):\n$array_loop_total = count($_list_from);\n$array_loop_rownum = 0;\nforeach($_list_from as $key => $array):\n$loop = $array;\n$array[\'_loop_key\'] = $key;\n$array[\'_loop_rownum\'] = ++$array_loop_rownum;\n$array[\'_loop_total\'] = $array_loop_total;\n$array[\'_loop_first\'] = ($array[\'_loop_rownum\'] == 1);\n$array[\'_loop_last\'] = ($array[\'_loop_rownum\'] == $array[\'_loop_total\']);\n?>\n<li>\n<?php\nif(is_array($loop) && count($loop)):\n$cnt_loop_total = count($loop);\n$cnt_loop_rownum = 0;\nforeach($loop as $key => $cnt):\n$cnt[\'_loop_key\'] = $key;\n$cnt[\'_loop_rownum\'] = ++$cnt_loop_rownum;\n$cnt[\'_loop_total\'] = $cnt_loop_total;\n$cnt[\'_loop_first\'] = ($cnt[\'_loop_rownum\'] == 1);\n$cnt[\'_loop_last\'] = ($cnt[\'_loop_rownum\'] == $cnt[\'_loop_total\']);\n?>\n<a href=\"<?php echo $cnt[\'url\']; ?>\" target=\"_blank\" style=\"color:<?php echo $cnt[\'color\']; ?>;<?php if ($cnt[\'bold\']): ?>font-weight:bold;<?php endif; ?>\"><?php echo $cnt[\'title\']; ?></a>\n<?php if ($cnt[\'tailtitle\']): ?><span class=\"tail\"><?php if ($cnt[\'tailurl\']): ?><a href=\"<?php echo $cnt[\'tailurl\']; ?>\" target=\"_blank\" style=\"color:<?php echo $cnt[\'tailcolor\']; ?>;<?php if ($cnt[\'tailbold\']): ?>font-weight:bold;<?php endif; ?>\"><?php echo $cnt[\'tailtitle\']; ?></a><?php else: ?><?php echo $cnt[\'tailtitle\']; ?><?php endif; ?></span><?php endif; ?>\n<?php endforeach; endif; ?>\n</li>\n<?php if (! $array[\'_loop_last\'] && $array[\'_loop_rownum\']%5 == 0): ?></ul><span class=\"dotline\"></span><ul class=\"list\"><?php endif; ?>\n<?php endforeach; endif; ?>\n</ul>\n<?php endif; unset($_list_from_array); ?>\n<?php }','','','','','',0,3600,0,0,0,1293525190,1,0,0,1290419492,1,'',100),(112,2,'ҳƼ','manu','{list listtype=block}\r\n{loop item=array fromname=loop}\r\n{if $array._loop_first}\r\n{loop item=cnt from=$loop}\r\n<div class=\"txpic clearfix\">\r\n<a class=\"img\" href=\"{$cnt.url}\" target=\"_blank\"><img src=\"{$cnt.thumb}\" alt=\"{$cnt.title}\"></a>\r\n<h3><a href=\"{$cnt.url}\" style=\"color:{$cnt.color};{if $cnt.bold}font-weight:bold;{/if}\">{$cnt.title}</a></h3>\r\n<p>{$cnt.description length=52 suffix=1}<a href=\"{$cnt.url}\" target=\"_blank\" class=\"cred\">[ϸ]</a></p>\r\n</div>\r\n{/loop}\r\n{else}\r\n{if $array._loop_rownum==2}<ul class=\"list list-f12\">{/if}\r\n<li>{loop item=cnt from=$loop}<a href=\"{$cnt.url}\" target=\"_blank\" style=\"color:{$cnt.color};{if $cnt.bold}font-weight:bold;{/if}\">{$cnt.title}</a> {/loop}</li>\r\n{if $array._loop_last}</ul>{/if}\r\n{/if}\r\n{/loop}\r\n{/list}','<?php /* EXCMS template, created on 2010-12-28 16:33:24 compiled from  */\nfunction excms_block_func_112(){\n\n?>\n<?php \n$_list_from_array = EXCMSTPL::_list(array(\'listtype\' => \'block\',\'channelid\' => $_PAGE_CHANNEL[\'_channelid\'],));\nif(is_array($_list_from_array[\'from\']) && count($_list_from_array[\'from\'])):\n$_list_from = &$_list_from_array[\'from\'];\n$_list_total = &$_list_from_array[\'total\'];\n?>\r\n<?php\nif(is_array($_list_from) && count($_list_from)):\n$array_loop_total = count($_list_from);\n$array_loop_rownum = 0;\nforeach($_list_from as $key => $array):\n$loop = $array;\n$array[\'_loop_key\'] = $key;\n$array[\'_loop_rownum\'] = ++$array_loop_rownum;\n$array[\'_loop_total\'] = $array_loop_total;\n$array[\'_loop_first\'] = ($array[\'_loop_rownum\'] == 1);\n$array[\'_loop_last\'] = ($array[\'_loop_rownum\'] == $array[\'_loop_total\']);\n?>\r\n<?php if ($array[\'_loop_first\']): ?>\r\n<?php\nif(is_array($loop) && count($loop)):\n$cnt_loop_total = count($loop);\n$cnt_loop_rownum = 0;\nforeach($loop as $key => $cnt):\n$cnt[\'_loop_key\'] = $key;\n$cnt[\'_loop_rownum\'] = ++$cnt_loop_rownum;\n$cnt[\'_loop_total\'] = $cnt_loop_total;\n$cnt[\'_loop_first\'] = ($cnt[\'_loop_rownum\'] == 1);\n$cnt[\'_loop_last\'] = ($cnt[\'_loop_rownum\'] == $cnt[\'_loop_total\']);\n?>\r\n<div class=\"txpic clearfix\">\r\n<a class=\"img\" href=\"<?php echo $cnt[\'url\']; ?>\" target=\"_blank\"><img src=\"<?php echo $cnt[\'thumb\']; ?>\" alt=\"<?php echo $cnt[\'title\']; ?>\"></a>\r\n<h3><a href=\"<?php echo $cnt[\'url\']; ?>\" style=\"color:<?php echo $cnt[\'color\']; ?>;<?php if ($cnt[\'bold\']): ?>font-weight:bold;<?php endif; ?>\"><?php echo $cnt[\'title\']; ?></a></h3>\r\n<p><?php echo csubstr($cnt[\'description\'],52,0,1); ?><a href=\"<?php echo $cnt[\'url\']; ?>\" target=\"_blank\" class=\"cred\">[ϸ]</a></p>\r\n</div>\r\n<?php endforeach; endif; ?>\r\n<?php else: ?>\r\n<?php if ($array[\'_loop_rownum\'] == 2): ?><ul class=\"list list-f12\"><?php endif; ?>\r\n<li><?php\nif(is_array($loop) && count($loop)):\n$cnt_loop_total = count($loop);\n$cnt_loop_rownum = 0;\nforeach($loop as $key => $cnt):\n$cnt[\'_loop_key\'] = $key;\n$cnt[\'_loop_rownum\'] = ++$cnt_loop_rownum;\n$cnt[\'_loop_total\'] = $cnt_loop_total;\n$cnt[\'_loop_first\'] = ($cnt[\'_loop_rownum\'] == 1);\n$cnt[\'_loop_last\'] = ($cnt[\'_loop_rownum\'] == $cnt[\'_loop_total\']);\n?><a href=\"<?php echo $cnt[\'url\']; ?>\" target=\"_blank\" style=\"color:<?php echo $cnt[\'color\']; ?>;<?php if ($cnt[\'bold\']): ?>font-weight:bold;<?php endif; ?>\"><?php echo $cnt[\'title\']; ?></a> <?php endforeach; endif; ?></li>\r\n<?php if ($array[\'_loop_last\']): ?></ul><?php endif; ?>\r\n<?php endif; ?>\r\n<?php endforeach; endif; ?>\r\n<?php endif; unset($_list_from_array); ?>\n<?php }','','','','','',0,3600,0,0,0,1293525204,1,0,0,1290846782,1,'',100),(113,2,'ҳõ','manu','{list listtype=block}\r\n<div class=\"slider-pic\">\r\n{loop item=array fromname=loop}\r\n{loop item=cnt from=$loop}\r\n<li><a href=\"{$cnt.url}\" class=\"img\"><strong class=\"txt\">{$cnt.title}</strong><img src=\"{$cnt.thumb postfix=ss}\" alt=\"{$cnt.title}\"></a></li>\r\n{/loop}\r\n{/loop}\r\n</div>\r\n{/list}','<?php /* EXCMS template, created on 2010-12-28 16:33:32 compiled from  */\nfunction excms_block_func_113(){\n\n?>\n<?php \n$_list_from_array = EXCMSTPL::_list(array(\'listtype\' => \'block\',\'channelid\' => $_PAGE_CHANNEL[\'_channelid\'],));\nif(is_array($_list_from_array[\'from\']) && count($_list_from_array[\'from\'])):\n$_list_from = &$_list_from_array[\'from\'];\n$_list_total = &$_list_from_array[\'total\'];\n?>\r\n<div class=\"slider-pic\">\r\n<?php\nif(is_array($_list_from) && count($_list_from)):\n$array_loop_total = count($_list_from);\n$array_loop_rownum = 0;\nforeach($_list_from as $key => $array):\n$loop = $array;\n$array[\'_loop_key\'] = $key;\n$array[\'_loop_rownum\'] = ++$array_loop_rownum;\n$array[\'_loop_total\'] = $array_loop_total;\n$array[\'_loop_first\'] = ($array[\'_loop_rownum\'] == 1);\n$array[\'_loop_last\'] = ($array[\'_loop_rownum\'] == $array[\'_loop_total\']);\n?>\r\n<?php\nif(is_array($loop) && count($loop)):\n$cnt_loop_total = count($loop);\n$cnt_loop_rownum = 0;\nforeach($loop as $key => $cnt):\n$cnt[\'_loop_key\'] = $key;\n$cnt[\'_loop_rownum\'] = ++$cnt_loop_rownum;\n$cnt[\'_loop_total\'] = $cnt_loop_total;\n$cnt[\'_loop_first\'] = ($cnt[\'_loop_rownum\'] == 1);\n$cnt[\'_loop_last\'] = ($cnt[\'_loop_rownum\'] == $cnt[\'_loop_total\']);\n?>\r\n<li><a href=\"<?php echo $cnt[\'url\']; ?>\" class=\"img\"><strong class=\"txt\"><?php echo $cnt[\'title\']; ?></strong><img src=\"<?php echo EXCMS::imagePostfix($cnt[\'thumb\'],\'ss\',$cnt[\'_thumb_resource\']) ; ?>\" alt=\"<?php echo $cnt[\'title\']; ?>\"></a></li>\r\n<?php endforeach; endif; ?>\r\n<?php endforeach; endif; ?>\r\n</div>\r\n<?php endif; unset($_list_from_array); ?>\n<?php }','','','','','',0,3600,0,0,0,1293525212,1,0,0,1290845738,1,'',100),(114,2,'ҳȵͼƬ','manu','{list listtype=block}\n<ul class=\"img-list\">\n{loop item=array fromname=loop}\n{loop item=cnt from=$loop}\n<li>\n<a href=\"{$cnt.url}\" target=\"_blank\" class=\"img\"><img src=\"{$cnt.thumb postfix=ss}\" alt=\"{$cnt.title}\"></a>\n<span class=\"txt2row\"><a href=\"{$cnt.url}\" target=\"_blank\" style=\"color:{$cnt.color};{if $cnt.bold}font-weight:bold;{/if}\">{$cnt.title}</a></span>\n</li>\n{/loop}\n{/loop}\n</ul>\n{/list}','<?php /* EXCMS template, created on 2010-12-28 16:33:44 compiled from  */\nfunction excms_block_func_114(){\n\n?>\n<?php \n$_list_from_array = EXCMSTPL::_list(array(\'listtype\' => \'block\',\'channelid\' => $_PAGE_CHANNEL[\'_channelid\'],));\nif(is_array($_list_from_array[\'from\']) && count($_list_from_array[\'from\'])):\n$_list_from = &$_list_from_array[\'from\'];\n$_list_total = &$_list_from_array[\'total\'];\n?>\n<ul class=\"img-list\">\n<?php\nif(is_array($_list_from) && count($_list_from)):\n$array_loop_total = count($_list_from);\n$array_loop_rownum = 0;\nforeach($_list_from as $key => $array):\n$loop = $array;\n$array[\'_loop_key\'] = $key;\n$array[\'_loop_rownum\'] = ++$array_loop_rownum;\n$array[\'_loop_total\'] = $array_loop_total;\n$array[\'_loop_first\'] = ($array[\'_loop_rownum\'] == 1);\n$array[\'_loop_last\'] = ($array[\'_loop_rownum\'] == $array[\'_loop_total\']);\n?>\n<?php\nif(is_array($loop) && count($loop)):\n$cnt_loop_total = count($loop);\n$cnt_loop_rownum = 0;\nforeach($loop as $key => $cnt):\n$cnt[\'_loop_key\'] = $key;\n$cnt[\'_loop_rownum\'] = ++$cnt_loop_rownum;\n$cnt[\'_loop_total\'] = $cnt_loop_total;\n$cnt[\'_loop_first\'] = ($cnt[\'_loop_rownum\'] == 1);\n$cnt[\'_loop_last\'] = ($cnt[\'_loop_rownum\'] == $cnt[\'_loop_total\']);\n?>\n<li>\n<a href=\"<?php echo $cnt[\'url\']; ?>\" target=\"_blank\" class=\"img\"><img src=\"<?php echo EXCMS::imagePostfix($cnt[\'thumb\'],\'ss\',$cnt[\'_thumb_resource\']) ; ?>\" alt=\"<?php echo $cnt[\'title\']; ?>\"></a>\n<span class=\"txt2row\"><a href=\"<?php echo $cnt[\'url\']; ?>\" target=\"_blank\" style=\"color:<?php echo $cnt[\'color\']; ?>;<?php if ($cnt[\'bold\']): ?>font-weight:bold;<?php endif; ?>\"><?php echo $cnt[\'title\']; ?></a></span>\n</li>\n<?php endforeach; endif; ?>\n<?php endforeach; endif; ?>\n</ul>\n<?php endif; unset($_list_from_array); ?>\n<?php }','','','','','',0,3600,0,0,0,1293525224,1,0,0,1290845977,1,'',100),(115,1,'ȵƼ','manu','{list listtype=block}\n{loop item=array fromname=loop}\n{if $array._loop_first}\n{loop item=cnt from=$loop}\n<div class=\"txpic clearfix\">\n<a class=\"img\" href=\"{$cnt.url}\" target==\"_blank\"><img src=\"{$cnt.thumb}\" alt=\"{$cnt.title}\" /></a>\n<h3><a href=\"{$cnt.url}\" target==\"_blank\">{$cnt.title}</a></h3>\n<p>{$cnt.description length=40 suffix=1}<a href=\"{$cnt.url}\" class=\"cred\" target==\"_blank\">[ϸ]</a></p>\n</div>\n{/loop}\n<ul class=\"list\">\n{else}\n<li>\n{loop item=cnt from=$loop}\n<a href=\"{$cnt.url}\" target=\"_blank\" style=\"color:{$cnt.color};{if $cnt.bold}font-weight:bold;{/if}\">{$cnt.title}</a>{if $cnt.tailtitle}\n<span class=\"tail\">{if $cnt.tailurl}<a href=\"{$cnt.tailurl}\" target=\"_blank\" style=\"color:{$cnt.tailcolor};{if $cnt.tailbold}font-weight:bold;{/if}\">{$cnt.tailtitle}</a>{else}{$cnt.tailtitle}{/if}</span>{/if}\n{/loop}\n{/if}\n</li>\n{/loop}\n</ul>\n{/list}','<?php /* EXCMS template, created on 2010-12-28 16:32:27 compiled from  */\nfunction excms_block_func_115(){\n\n?>\n<?php \n$_list_from_array = EXCMSTPL::_list(array(\'listtype\' => \'block\',\'channelid\' => $_PAGE_CHANNEL[\'_channelid\'],));\nif(is_array($_list_from_array[\'from\']) && count($_list_from_array[\'from\'])):\n$_list_from = &$_list_from_array[\'from\'];\n$_list_total = &$_list_from_array[\'total\'];\n?>\n<?php\nif(is_array($_list_from) && count($_list_from)):\n$array_loop_total = count($_list_from);\n$array_loop_rownum = 0;\nforeach($_list_from as $key => $array):\n$loop = $array;\n$array[\'_loop_key\'] = $key;\n$array[\'_loop_rownum\'] = ++$array_loop_rownum;\n$array[\'_loop_total\'] = $array_loop_total;\n$array[\'_loop_first\'] = ($array[\'_loop_rownum\'] == 1);\n$array[\'_loop_last\'] = ($array[\'_loop_rownum\'] == $array[\'_loop_total\']);\n?>\n<?php if ($array[\'_loop_first\']): ?>\n<?php\nif(is_array($loop) && count($loop)):\n$cnt_loop_total = count($loop);\n$cnt_loop_rownum = 0;\nforeach($loop as $key => $cnt):\n$cnt[\'_loop_key\'] = $key;\n$cnt[\'_loop_rownum\'] = ++$cnt_loop_rownum;\n$cnt[\'_loop_total\'] = $cnt_loop_total;\n$cnt[\'_loop_first\'] = ($cnt[\'_loop_rownum\'] == 1);\n$cnt[\'_loop_last\'] = ($cnt[\'_loop_rownum\'] == $cnt[\'_loop_total\']);\n?>\n<div class=\"txpic clearfix\">\n<a class=\"img\" href=\"<?php echo $cnt[\'url\']; ?>\" target==\"_blank\"><img src=\"<?php echo $cnt[\'thumb\']; ?>\" alt=\"<?php echo $cnt[\'title\']; ?>\" /></a>\n<h3><a href=\"<?php echo $cnt[\'url\']; ?>\" target==\"_blank\"><?php echo $cnt[\'title\']; ?></a></h3>\n<p><?php echo csubstr($cnt[\'description\'],40,0,1); ?><a href=\"<?php echo $cnt[\'url\']; ?>\" class=\"cred\" target==\"_blank\">[ϸ]</a></p>\n</div>\n<?php endforeach; endif; ?>\n<ul class=\"list\">\n<?php else: ?>\n<li>\n<?php\nif(is_array($loop) && count($loop)):\n$cnt_loop_total = count($loop);\n$cnt_loop_rownum = 0;\nforeach($loop as $key => $cnt):\n$cnt[\'_loop_key\'] = $key;\n$cnt[\'_loop_rownum\'] = ++$cnt_loop_rownum;\n$cnt[\'_loop_total\'] = $cnt_loop_total;\n$cnt[\'_loop_first\'] = ($cnt[\'_loop_rownum\'] == 1);\n$cnt[\'_loop_last\'] = ($cnt[\'_loop_rownum\'] == $cnt[\'_loop_total\']);\n?>\n<a href=\"<?php echo $cnt[\'url\']; ?>\" target=\"_blank\" style=\"color:<?php echo $cnt[\'color\']; ?>;<?php if ($cnt[\'bold\']): ?>font-weight:bold;<?php endif; ?>\"><?php echo $cnt[\'title\']; ?></a><?php if ($cnt[\'tailtitle\']): ?>\n<span class=\"tail\"><?php if ($cnt[\'tailurl\']): ?><a href=\"<?php echo $cnt[\'tailurl\']; ?>\" target=\"_blank\" style=\"color:<?php echo $cnt[\'tailcolor\']; ?>;<?php if ($cnt[\'tailbold\']): ?>font-weight:bold;<?php endif; ?>\"><?php echo $cnt[\'tailtitle\']; ?></a><?php else: ?><?php echo $cnt[\'tailtitle\']; ?><?php endif; ?></span><?php endif; ?>\n<?php endforeach; endif; ?>\n<?php endif; ?>\n</li>\n<?php endforeach; endif; ?>\n</ul>\n<?php endif; unset($_list_from_array); ?>\n<?php }','','','','','',0,3600,0,0,0,1293525147,1,0,0,1293076746,1,'',100);

DROP TABLE IF EXISTS `excms_block_category`;
CREATE TABLE `excms_block_category` (
  `categoryid` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `pid` smallint(5) unsigned DEFAULT '0',
  `name` varchar(50) DEFAULT NULL,
  `type` enum('cate','page') NOT NULL DEFAULT 'cate',
  `blocks` smallint(5) unsigned DEFAULT '0',
  `template` varchar(100) DEFAULT NULL,
  `url` varchar(100) DEFAULT NULL,
  `frequency` smallint(5) unsigned DEFAULT NULL,
  `publisheddate` int(10) unsigned DEFAULT NULL,
  `updateddate` int(10) unsigned DEFAULT NULL,
  `nextdate` int(10) unsigned DEFAULT NULL,
  `createddate` int(10) unsigned DEFAULT NULL,
  `createdby` mediumint(8) unsigned DEFAULT NULL,
  `comment` varchar(100) DEFAULT NULL,
  `sort` tinyint(1) unsigned DEFAULT NULL,
  PRIMARY KEY (`categoryid`)
) ENGINE=MyISAM AUTO_INCREMENT=1001 DEFAULT CHARSET=gbk;

INSERT INTO `excms_block_category` VALUES (1,0,'ͨƬ','cate',0,'','',0,0,0,0,1290149048,1,'',100),(2,0,'ҳ','page',0,'themes/excellence/index.html','{PPT:Ŀ¼}/index.html',3600,0,0,1290152456,1290149123,1,'',100);

DROP TABLE IF EXISTS `excms_block_history`;
CREATE TABLE `excms_block_history` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `blockid` smallint(5) unsigned NOT NULL,
  `data` mediumtext,
  `type` tinyint(1) unsigned NOT NULL,
  `revertto` int(11) unsigned DEFAULT NULL,
  `createdby` mediumint(8) unsigned DEFAULT NULL,
  `ip` varchar(15) DEFAULT NULL,
  `createddate` int(11) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=gbk;


DROP TABLE IF EXISTS `excms_category`;
CREATE TABLE `excms_category` (
  `categoryid` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `group` int(11) unsigned DEFAULT NULL,
  `name` varchar(20) DEFAULT NULL,
  `identify` varchar(20) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `table` varchar(40) DEFAULT NULL,
  `ismultilevel` tinyint(1) unsigned DEFAULT NULL,
  `issystem` tinyint(1) unsigned DEFAULT NULL,
  `status` tinyint(1) unsigned DEFAULT NULL,
  `sort` int(11) DEFAULT NULL,
  PRIMARY KEY (`categoryid`)
) ENGINE=MyISAM AUTO_INCREMENT=2001 DEFAULT CHARSET=gbk;

INSERT INTO `excms_category` VALUES ('1','1','Ƽ','recommend','Ƽ,ͷ,...','category_recommend','0','1','1','92');
INSERT INTO `excms_category` VALUES ('2','1','ݾ','distillate','ݾ','category_distillate','0','1','1','50');
INSERT INTO `excms_category` VALUES ('8','3','','softtype','','category_softtype','0','0','1','16');
INSERT INTO `excms_category` VALUES ('9','3','','language','','category_language','0','0','1','46');
INSERT INTO `excms_category` VALUES ('10','3','','copyright','','category_copyright','0','0','1','58');
INSERT INTO `excms_category` VALUES ('11','3','ȼ','softlevel','','category_level','0','0','1','48');
INSERT INTO `excms_category` VALUES ('12','3','','downtype','','category_downtype','0','0','1','3');
INSERT INTO `excms_category` VALUES ('13','4','ļ','filetype','','category_filetype','0','0','1','23');
INSERT INTO `excms_category` VALUES ('14','3','Ӧƽ̨','platform','Ӧƽ̨','category_platform','0','0','1','29');
INSERT INTO `excms_category` VALUES ('1000','1000','Tag','tagcategory','','category_tagcategory','0','1','1','50');
INSERT INTO `excms_category` VALUES ('1001','1000','TagƼ','tagrecommend','','category_tagrecommend','0','1','1','50');

DROP TABLE IF EXISTS `excms_category_copyright`;
CREATE TABLE `excms_category_copyright` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(50) DEFAULT NULL,
  `sort` int(11) DEFAULT '5',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=1001 DEFAULT CHARSET=gbk;

INSERT INTO `excms_category_copyright` VALUES ('1','ҵ','50');
INSERT INTO `excms_category_copyright` VALUES ('2','','50');
INSERT INTO `excms_category_copyright` VALUES ('3','','50');
INSERT INTO `excms_category_copyright` VALUES ('4','','50');

DROP TABLE IF EXISTS `excms_category_distillate`;
CREATE TABLE `excms_category_distillate` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(50) DEFAULT NULL,
  `sort` int(11) DEFAULT '5',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=1001 DEFAULT CHARSET=gbk;

INSERT INTO `excms_category_distillate` VALUES ('1','Ǿ','50');
INSERT INTO `excms_category_distillate` VALUES ('2','I','50');
INSERT INTO `excms_category_distillate` VALUES ('3','II','50');
INSERT INTO `excms_category_distillate` VALUES ('4','III','50');

DROP TABLE IF EXISTS `excms_category_downtype`;
CREATE TABLE `excms_category_downtype` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(50) DEFAULT NULL,
  `sort` int(11) DEFAULT '5',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=1001 DEFAULT CHARSET=gbk;

INSERT INTO `excms_category_downtype` VALUES ('1','','50');
INSERT INTO `excms_category_downtype` VALUES ('2','ĵ','50');
INSERT INTO `excms_category_downtype` VALUES ('3','','50');

DROP TABLE IF EXISTS `excms_category_fields`;
CREATE TABLE `excms_category_fields` (
  `fieldid` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `categoryid` int(11) unsigned DEFAULT NULL,
  `fieldname` varchar(20) DEFAULT NULL,
  `formname` varchar(50) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `valuetype` tinyint(1) DEFAULT NULL,
  `valuefrom` int(11) DEFAULT NULL,
  `issystem` tinyint(1) DEFAULT NULL,
  `sort` int(11) DEFAULT NULL,
  PRIMARY KEY (`fieldid`)
) ENGINE=MyISAM AUTO_INCREMENT=1001 DEFAULT CHARSET=gbk;

INSERT INTO `excms_category_fields` VALUES ('1','1','id','id','ƼID','1','0','1','0');
INSERT INTO `excms_category_fields` VALUES ('2','1','name','','Ƽ','0','0','1','1');
INSERT INTO `excms_category_fields` VALUES ('3','1','sort','','','1','0','1','50');
INSERT INTO `excms_category_fields` VALUES ('4','2','id','id','ݱֶ','1','0','1','0');
INSERT INTO `excms_category_fields` VALUES ('5','2','name','','','0','0','1','2');
INSERT INTO `excms_category_fields` VALUES ('6','2','sort','','','1','0','1','50');
INSERT INTO `excms_category_fields` VALUES ('7','8','id','id','ݱֶ','1','0','1','0');
INSERT INTO `excms_category_fields` VALUES ('8','8','name','','','0','0','1','2');
INSERT INTO `excms_category_fields` VALUES ('9','8','sort','','','1','0','1','50');
INSERT INTO `excms_category_fields` VALUES ('10','9','id','id','ݱֶ','1','0','1','0');
INSERT INTO `excms_category_fields` VALUES ('11','9','name','','','0','0','1','2');
INSERT INTO `excms_category_fields` VALUES ('12','9','sort','','','1','0','1','50');
INSERT INTO `excms_category_fields` VALUES ('13','10','id','id','ݱֶ','1','0','1','0');
INSERT INTO `excms_category_fields` VALUES ('14','10','name','','','0','0','1','2');
INSERT INTO `excms_category_fields` VALUES ('15','10','sort','','','1','0','1','50');
INSERT INTO `excms_category_fields` VALUES ('16','11','id','id','ݱֶ','1','0','1','0');
INSERT INTO `excms_category_fields` VALUES ('17','11','name','','','0','0','1','2');
INSERT INTO `excms_category_fields` VALUES ('18','11','sort','','','1','0','1','50');
INSERT INTO `excms_category_fields` VALUES ('19','12','id','id','ݱֶ','1','0','1','0');
INSERT INTO `excms_category_fields` VALUES ('20','12','name','','','0','0','1','2');
INSERT INTO `excms_category_fields` VALUES ('21','12','sort','','','1','0','1','50');
INSERT INTO `excms_category_fields` VALUES ('22','13','id','id','ݱֶ','1','0','1','0');
INSERT INTO `excms_category_fields` VALUES ('23','13','name','','','0','0','1','2');
INSERT INTO `excms_category_fields` VALUES ('24','13','sort','','','1','0','1','50');
INSERT INTO `excms_category_fields` VALUES ('25','14','id','id','ݱֶ','1','0','1','0');
INSERT INTO `excms_category_fields` VALUES ('26','14','name','','','0','0','1','2');
INSERT INTO `excms_category_fields` VALUES ('27','14','sort','','','1','0','1','50');
INSERT INTO `excms_category_fields` VALUES ('37','1000','id','id','ݱֶ','1','0','1','0');
INSERT INTO `excms_category_fields` VALUES ('38','1000','name','','','0','0','1','2');
INSERT INTO `excms_category_fields` VALUES ('39','1000','sort','','','1','0','1','50');
INSERT INTO `excms_category_fields` VALUES ('40','1001','id','id','ݱֶ','1','0','1','0');
INSERT INTO `excms_category_fields` VALUES ('41','1001','name','','','0','0','1','2');
INSERT INTO `excms_category_fields` VALUES ('42','1001','sort','','','1','0','1','50');
INSERT INTO `excms_category_fields` VALUES ('43','1000','alias','','ݱ','0','0','0','50');
INSERT INTO `excms_category_fields` VALUES ('44','1001','alias','','ݱ','0','0','0','50');
INSERT INTO `excms_category_fields` VALUES ('53','1','alias','ʶ','Ƽʶ','0','0','0','2');

DROP TABLE IF EXISTS `excms_category_filetype`;
CREATE TABLE `excms_category_filetype` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(50) DEFAULT NULL,
  `sort` int(11) DEFAULT '5',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=1001 DEFAULT CHARSET=gbk;

INSERT INTO `excms_category_filetype` VALUES ('1','RAR','50');
INSERT INTO `excms_category_filetype` VALUES ('2','ZIP','50');
INSERT INTO `excms_category_filetype` VALUES ('3','EXE','50');
INSERT INTO `excms_category_filetype` VALUES ('4','DOC','50');

DROP TABLE IF EXISTS `excms_category_group`;
CREATE TABLE `excms_category_group` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(20) DEFAULT NULL,
  `description` varchar(200) DEFAULT NULL,
  `sort` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2001 DEFAULT CHARSET=gbk;

INSERT INTO `excms_category_group` VALUES ('1','','','10');
INSERT INTO `excms_category_group` VALUES ('3','','','100');
INSERT INTO `excms_category_group` VALUES ('4','ͨ÷','ͨ÷','100');
INSERT INTO `excms_category_group` VALUES ('1000','Tagǩ','','100');

DROP TABLE IF EXISTS `excms_category_language`;
CREATE TABLE `excms_category_language` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(50) DEFAULT NULL,
  `sort` int(11) DEFAULT '5',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=1001 DEFAULT CHARSET=gbk;

INSERT INTO `excms_category_language` VALUES ('1','','50');
INSERT INTO `excms_category_language` VALUES ('2','','50');
INSERT INTO `excms_category_language` VALUES ('3','Ӣ','50');

DROP TABLE IF EXISTS `excms_category_level`;
CREATE TABLE `excms_category_level` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(50) DEFAULT NULL,
  `sort` int(11) DEFAULT '5',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=1001 DEFAULT CHARSET=gbk;

INSERT INTO `excms_category_level` VALUES ('1','һ','50');
INSERT INTO `excms_category_level` VALUES ('2','','50');
INSERT INTO `excms_category_level` VALUES ('3','','50');
INSERT INTO `excms_category_level` VALUES ('4','','50');
INSERT INTO `excms_category_level` VALUES ('5','','50');

DROP TABLE IF EXISTS `excms_category_platform`;
CREATE TABLE `excms_category_platform` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(50) DEFAULT NULL,
  `sort` int(11) DEFAULT '5',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=1001 DEFAULT CHARSET=gbk;

INSERT INTO `excms_category_platform` VALUES ('1','DOS','50');
INSERT INTO `excms_category_platform` VALUES ('2','Win9X','50');
INSERT INTO `excms_category_platform` VALUES ('3','WinNT','50');
INSERT INTO `excms_category_platform` VALUES ('4','WinXP','50');
INSERT INTO `excms_category_platform` VALUES ('5','Win2000','50');
INSERT INTO `excms_category_platform` VALUES ('6','Win2003','50');
INSERT INTO `excms_category_platform` VALUES ('7','Vista','50');
INSERT INTO `excms_category_platform` VALUES ('8','Win2008','50');
INSERT INTO `excms_category_platform` VALUES ('9','Win7','50');
INSERT INTO `excms_category_platform` VALUES ('10','Unix','50');
INSERT INTO `excms_category_platform` VALUES ('11','Linux','50');
INSERT INTO `excms_category_platform` VALUES ('12','FreeBSD','50');
INSERT INTO `excms_category_platform` VALUES ('13','Mac','50');

DROP TABLE IF EXISTS `excms_category_recommend`;
CREATE TABLE `excms_category_recommend` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(50) DEFAULT NULL,
  `sort` int(11) DEFAULT '5',
  `alias` varchar(200) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=1001 DEFAULT CHARSET=gbk;

INSERT INTO `excms_category_recommend` VALUES ('1','ͷ','50','head');
INSERT INTO `excms_category_recommend` VALUES ('2','','50','focus');
INSERT INTO `excms_category_recommend` VALUES ('3','Ƽ','50','recommend');
INSERT INTO `excms_category_recommend` VALUES ('4','õ','50','flash');
INSERT INTO `excms_category_recommend` VALUES ('5','','50','roll');
INSERT INTO `excms_category_recommend` VALUES ('6','ҳͷ','50','indexhead');
INSERT INTO `excms_category_recommend` VALUES ('7','ҳ','50','indexfocus');
INSERT INTO `excms_category_recommend` VALUES ('8','ҳƼ','50','indexrmd');
INSERT INTO `excms_category_recommend` VALUES ('9','ҳõ','50','indexflash');

DROP TABLE IF EXISTS `excms_category_softtype`;
CREATE TABLE `excms_category_softtype` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(50) DEFAULT NULL,
  `sort` int(11) DEFAULT '5',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=1001 DEFAULT CHARSET=gbk;

INSERT INTO `excms_category_softtype` VALUES ('1','','50');
INSERT INTO `excms_category_softtype` VALUES ('2','','50');
INSERT INTO `excms_category_softtype` VALUES ('3','','50');

DROP TABLE IF EXISTS `excms_category_tagcategory`;
CREATE TABLE `excms_category_tagcategory` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(50) DEFAULT NULL,
  `sort` int(11) DEFAULT '5',
  `alias` varchar(200) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=1001 DEFAULT CHARSET=gbk;

INSERT INTO `excms_category_tagcategory` VALUES ('1','ȵ','50','hot');
INSERT INTO `excms_category_tagcategory` VALUES ('2','','50','pop');
INSERT INTO `excms_category_tagcategory` VALUES ('3','','50','geili');
INSERT INTO `excms_category_tagcategory` VALUES ('4','Ѷ','50','info');
INSERT INTO `excms_category_tagcategory` VALUES ('5','ͼƬ','50','pic');
INSERT INTO `excms_category_tagcategory` VALUES ('6','Ƶ','50','video');

DROP TABLE IF EXISTS `excms_category_tagrecommend`;
CREATE TABLE `excms_category_tagrecommend` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(50) DEFAULT NULL,
  `sort` int(11) DEFAULT '5',
  `alias` varchar(200) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=1001 DEFAULT CHARSET=gbk;

INSERT INTO `excms_category_tagrecommend` VALUES ('1','ҳƼ','50','indexrmd');
INSERT INTO `excms_category_tagrecommend` VALUES ('2','ȵƼ','50','hot');

DROP TABLE IF EXISTS `excms_channels`;
CREATE TABLE `excms_channels` (
  `channelid` mediumint(5) unsigned NOT NULL AUTO_INCREMENT,
  `pid` mediumint(5) unsigned NOT NULL DEFAULT '0',
  `name` char(20) NOT NULL,
  `channelalias` char(20) DEFAULT NULL,
  `total` int(11) unsigned DEFAULT '0',
  `modelid` smallint(2) unsigned DEFAULT NULL,
  `path` varchar(100) DEFAULT NULL,
  `type` tinyint(1) unsigned DEFAULT '0',
  `forward` varchar(100) DEFAULT NULL,
  `redirectto` tinyint(2) unsigned DEFAULT '0',
  `defaultpage` varchar(50) DEFAULT NULL,
  `title` varchar(80) DEFAULT NULL,
  `keywords` varchar(80) DEFAULT NULL,
  `description` varchar(250) DEFAULT NULL,
  `picture` varchar(100) DEFAULT NULL,
  `checked` tinyint(1) unsigned DEFAULT '1',
  `navigation` tinyint(1) unsigned DEFAULT '0',
  `visible` tinyint(1) unsigned DEFAULT '1',
  `auth` tinyint(1) unsigned DEFAULT '0',
  `comment` tinyint(1) unsigned DEFAULT '0',
  `contribute` tinyint(1) unsigned DEFAULT '1',
  `templateindex` varchar(100) DEFAULT NULL,
  `templatelist` varchar(100) DEFAULT NULL,
  `listurlrule` varchar(100) DEFAULT NULL,
  `crosslisturlrule` varchar(100) DEFAULT NULL,
  `templatedetail` varchar(100) DEFAULT NULL,
  `detailurlrule` varchar(100) DEFAULT NULL,
  `templatesingle` varchar(100) DEFAULT NULL,
  `body` text,
  `sort` smallint(2) unsigned DEFAULT '50',
  PRIMARY KEY (`channelid`),
  KEY `pid` (`pid`,`sort`,`channelid`)
) ENGINE=MyISAM AUTO_INCREMENT=1001 DEFAULT CHARSET=gbk;

INSERT INTO `excms_channels` VALUES ('1','0','վ','announce','0','1','{PPT:1}/announce','0','','0','','','','վ¹Ϣ','','1','0','1','0','1','0','channel.html','list.html','{channeldir}/{page}.html','{channeldir}/{crossid}/{page}.html','content.html','{channeldir}/{Y}{M}/{contentid}.html','single.html','','50');
INSERT INTO `excms_channels` VALUES ('2','0','','about','0','0','{PPT:1}/about','3','','2','','','','','','1','0','1','0','1','0','channel.html','list.html','{channeldir}/{page}.html','{channeldir}/{crossid}/{page}.html','content.html','{channeldir}/{Y}{M}/{contentid}.html','single.html','','50');
INSERT INTO `excms_channels` VALUES ('3','2','','aboutindex','0','0','{PPT:1}/about','2','','0','index.html','','','','','1','2','0','0','1','0','channel.html','list.html','{channeldir}/{page}.html','{channeldir}/{crossid}/{page}.html','content.html','{channeldir}/{Y}{M}/{contentid}.html','single.html','','50');
INSERT INTO `excms_channels` VALUES ('4','2','ϵ','contactus','0','0','{PPT:1}/about','2','','0','contactus.html','','','','','1','2','0','0','1','0','channel.html','list.html','{channeldir}/{page}.html','{channeldir}/{crossid}/{page}.html','content.html','{channeldir}/{Y}{M}/{contentid}.html','single.html','','50');

DROP TABLE IF EXISTS `excms_channels_cross`;
CREATE TABLE `excms_channels_cross` (
  `channelid` mediumint(4) unsigned NOT NULL,
  `crossid` mediumint(5) unsigned NOT NULL,
  `eachother` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `sort` tinyint(2) unsigned NOT NULL DEFAULT '50',
  PRIMARY KEY (`channelid`,`crossid`)
) ENGINE=MyISAM DEFAULT CHARSET=gbk;


DROP TABLE IF EXISTS `excms_comments`;
CREATE TABLE `excms_comments` (
  `commentid` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `type` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `itemid` int(11) unsigned NOT NULL,
  `checked` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `support` int(11) unsigned NOT NULL DEFAULT '0',
  `against` int(11) unsigned NOT NULL DEFAULT '0',
  `floor` int(11) unsigned NOT NULL DEFAULT '1',
  `content` text,
  `lastfloor` text,
  `replyid` int(11) unsigned NOT NULL DEFAULT '0',
  `uid` int(11) unsigned NOT NULL DEFAULT '0',
  `username` char(20) DEFAULT NULL,
  `ip` char(15) DEFAULT NULL,
  `area` varchar(100) DEFAULT NULL,
  `anonymous` tinyint(1) unsigned DEFAULT '0',
  `hideip` tinyint(1) DEFAULT '0',
  `hideposition` tinyint(1) DEFAULT '0',
  `createddate` int(11) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`commentid`),
  KEY `contentid` (`type`,`itemid`)
) ENGINE=MyISAM DEFAULT CHARSET=gbk;


DROP TABLE IF EXISTS `excms_comments_recommend`;
CREATE TABLE `excms_comments_recommend` (
  `commentid` int(11) NOT NULL,
  `recommendid` int(11) DEFAULT NULL,
  `itemid` int(11) DEFAULT NULL,
  `rmdtitle` char(20) DEFAULT NULL,
  `rmddescription` varchar(200) DEFAULT NULL,
  `rmddate` int(11) DEFAULT NULL,
  PRIMARY KEY (`commentid`)
) ENGINE=MyISAM DEFAULT CHARSET=gbk;


DROP TABLE IF EXISTS `excms_comments_stat`;
CREATE TABLE `excms_comments_stat` (
  `itemid` int(11) unsigned NOT NULL,
  `type` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `channelid` int(11) unsigned DEFAULT NULL,
  `topid` int(11) unsigned DEFAULT NULL,
  `modelid` int(11) unsigned DEFAULT NULL,
  `total` int(11) unsigned DEFAULT NULL,
  `actor` int(11) unsigned DEFAULT NULL,
  `checked` int(11) unsigned DEFAULT '1',
  `lastdate` int(11) unsigned DEFAULT NULL,
  PRIMARY KEY (`itemid`,`type`),
  KEY `topid_checked` (`topid`,`checked`,`lastdate`,`total`)
) ENGINE=MyISAM DEFAULT CHARSET=gbk;


DROP TABLE IF EXISTS `excms_contents`;
CREATE TABLE `excms_contents` (
  `contentid` int(8) unsigned NOT NULL AUTO_INCREMENT,
  `modelid` smallint(2) unsigned NOT NULL DEFAULT '1',
  `channelid` mediumint(4) unsigned NOT NULL DEFAULT '0',
  `crossid` mediumint(5) unsigned DEFAULT NULL,
  `title` char(80) NOT NULL DEFAULT '',
  `shorttitle` char(40) DEFAULT NULL,
  `metatitle` char(100) DEFAULT NULL,
  `keywords` char(70) DEFAULT NULL,
  `tags` char(70) DEFAULT NULL,
  `description` char(250) DEFAULT NULL,
  `source` char(60) DEFAULT NULL,
  `author` char(60) DEFAULT NULL,
  `editor` varchar(20) DEFAULT NULL,
  `isthumb` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `thumb` char(100) DEFAULT NULL,
  `titleatt` char(50) DEFAULT NULL,
  `likekeywords` char(40) DEFAULT NULL,
  `likecontentid` char(200) DEFAULT NULL,
  `forward` char(100) DEFAULT NULL,
  `template` char(100) DEFAULT NULL,
  `filename` char(50) DEFAULT NULL,
  `ishtml` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `path` varchar(200) DEFAULT NULL,
  `checked` tinyint(1) NOT NULL DEFAULT '0',
  `publishdate` int(11) unsigned NOT NULL DEFAULT '0',
  `modifieddate` int(11) unsigned NOT NULL DEFAULT '0',
  `modifiedby` mediumint(5) unsigned NOT NULL,
  `modifiedbyadmin` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `createddate` int(11) unsigned NOT NULL DEFAULT '0',
  `createdby` mediumint(5) unsigned NOT NULL,
  `createdbyadmin` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `distillate` tinyint(1) unsigned DEFAULT NULL,
  `recommend` varchar(15) DEFAULT '',
  `credits` int(11) NOT NULL DEFAULT '0',
  `comment` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `sort` tinyint(2) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`contentid`),
  KEY `channel` (`channelid`,`contentid`),
  KEY `thumb` (`isthumb`,`checked`,`contentid`),
  KEY `sort` (`channelid`,`checked`,`sort`),
  KEY `createddate` (`createddate`),
  KEY `user` (`channelid`,`createdby`,`createdbyadmin`)
) ENGINE=MyISAM DEFAULT CHARSET=gbk;


DROP TABLE IF EXISTS `excms_contents_articles`;
CREATE TABLE `excms_contents_articles` (
  `contentid` int(11) NOT NULL,
  `body` mediumtext,
  PRIMARY KEY (`contentid`)
) ENGINE=MyISAM DEFAULT CHARSET=gbk;


DROP TABLE IF EXISTS `excms_contents_authors`;
CREATE TABLE `excms_contents_authors` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `author` varchar(32) DEFAULT NULL,
  `link` varchar(128) DEFAULT NULL,
  `sort` int(11) DEFAULT '100',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=gbk;


DROP TABLE IF EXISTS `excms_contents_click`;
CREATE TABLE `excms_contents_click` (
  `contentid` int(9) unsigned NOT NULL,
  `modelid` smallint(2) unsigned NOT NULL DEFAULT '1',
  `topid` mediumint(5) unsigned NOT NULL,
  `channelid` mediumint(5) unsigned NOT NULL,
  `crossid` mediumint(5) unsigned DEFAULT NULL,
  `checked` tinyint(1) unsigned DEFAULT '1',
  `init` mediumint(2) unsigned DEFAULT '0',
  `total` int(11) unsigned NOT NULL DEFAULT '0',
  `day` int(11) unsigned NOT NULL DEFAULT '0',
  `yesterday` int(11) unsigned NOT NULL DEFAULT '0',
  `week` int(11) unsigned NOT NULL DEFAULT '0',
  `month` int(11) unsigned NOT NULL DEFAULT '0',
  `year` int(11) unsigned NOT NULL DEFAULT '0',
  `updatetime` int(11) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`contentid`),
  KEY `checked_day` (`checked`,`day`),
  KEY `checked_month` (`checked`,`month`),
  KEY `checked_total` (`checked`,`total`),
  KEY `checked_week` (`checked`,`week`),
  KEY `topid_checked_day` (`topid`,`checked`,`day`),
  KEY `topid_checked_week` (`topid`,`checked`,`week`),
  KEY `topid_checked_month` (`topid`,`checked`,`month`),
  KEY `topid_checked_total` (`topid`,`checked`,`total`),
  KEY `model_check_total` (`modelid`,`checked`,`total`)
) ENGINE=MyISAM DEFAULT CHARSET=gbk;


DROP TABLE IF EXISTS `excms_contents_download`;
CREATE TABLE `excms_contents_download` (
  `contentid` int(11) unsigned NOT NULL,
  `publishtype` enum('1','2') DEFAULT NULL,
  `downcategory` int(11) NOT NULL DEFAULT '0',
  `version` varchar(250) NOT NULL DEFAULT '',
  `filesize` varchar(250) NOT NULL DEFAULT '',
  `copyright` int(11) NOT NULL DEFAULT '0',
  `downtype` int(11) NOT NULL DEFAULT '0',
  `filetype` int(11) NOT NULL DEFAULT '0',
  `publisher` varchar(250) NOT NULL DEFAULT '',
  `publisherurl` varchar(250) NOT NULL DEFAULT '',
  `demo` varchar(250) NOT NULL DEFAULT '',
  `email` varchar(250) NOT NULL DEFAULT '',
  `platform` varchar(200) NOT NULL DEFAULT '0',
  `language` int(11) NOT NULL DEFAULT '0',
  `body` mediumtext,
  `level` enum('1','2','3','4','5') DEFAULT NULL,
  `urls` text NOT NULL,
  `downfilename` varchar(200) NOT NULL DEFAULT '',
  `images` text NOT NULL,
  PRIMARY KEY (`contentid`)
) ENGINE=MyISAM DEFAULT CHARSET=gbk;


DROP TABLE IF EXISTS `excms_contents_images`;
CREATE TABLE `excms_contents_images` (
  `contentid` int(11) NOT NULL DEFAULT '0',
  `images` text NOT NULL,
  `body` mediumtext,
  PRIMARY KEY (`contentid`)
) ENGINE=MyISAM DEFAULT CHARSET=gbk;


DROP TABLE IF EXISTS `excms_contents_keywords`;
CREATE TABLE `excms_contents_keywords` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `keywords` varchar(64) DEFAULT NULL,
  `link` varchar(128) DEFAULT NULL,
  `frequency` int(11) DEFAULT NULL,
  `status` tinyint(1) DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=gbk;


DROP TABLE IF EXISTS `excms_contents_modify`;
CREATE TABLE `excms_contents_modify` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `contentid` int(11) NOT NULL,
  `userid` int(11) NOT NULL,
  `username` varchar(20) DEFAULT NULL,
  `modifieddate` int(11) DEFAULT NULL,
  `ip` varchar(20) DEFAULT NULL,
  `description` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=gbk;


DROP TABLE IF EXISTS `excms_contents_recommend`;
CREATE TABLE `excms_contents_recommend` (
  `contentid` int(9) unsigned NOT NULL,
  `recommendid` tinyint(2) unsigned NOT NULL,
  `modelid` mediumint(2) unsigned DEFAULT NULL,
  `topid` mediumint(2) unsigned NOT NULL,
  `channelid` mediumint(5) unsigned NOT NULL,
  `crossid` mediumint(5) unsigned DEFAULT NULL,
  `thumb` tinyint(2) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`contentid`,`recommendid`),
  KEY `channel_rmd_thumb` (`channelid`,`recommendid`,`thumb`,`contentid`),
  KEY `model_rmd_thumb` (`modelid`,`recommendid`,`thumb`,`contentid`),
  KEY `model_rmd` (`modelid`,`recommendid`,`contentid`),
  KEY `thumb` (`thumb`,`contentid`),
  KEY `thumb_rmd` (`recommendid`,`thumb`,`contentid`),
  KEY `channel` (`channelid`,`recommendid`,`contentid`),
  KEY `topid_rmd` (`topid`,`recommendid`,`contentid`),
  KEY `topid_rmd_thumb` (`topid`,`recommendid`,`thumb`,`contentid`)
) ENGINE=MyISAM DEFAULT CHARSET=gbk;


DROP TABLE IF EXISTS `excms_contents_related_title`;
CREATE TABLE `excms_contents_related_title` (
  `id` int(10) unsigned NOT NULL,
  `type` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `data` text,
  `createdby` mediumint(5) DEFAULT NULL,
  `modifiedby` mediumint(5) DEFAULT NULL,
  `createddate` int(10) unsigned DEFAULT NULL,
  `modifieddate` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`,`type`)
) ENGINE=MyISAM DEFAULT CHARSET=gbk;


DROP TABLE IF EXISTS `excms_contents_resource`;
CREATE TABLE `excms_contents_resource` (
  `contentid` int(11) NOT NULL,
  `rid` int(11) NOT NULL,
  PRIMARY KEY (`contentid`,`rid`)
) ENGINE=MyISAM DEFAULT CHARSET=gbk;


DROP TABLE IF EXISTS `excms_contents_sources`;
CREATE TABLE `excms_contents_sources` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `source` varchar(64) DEFAULT NULL,
  `link` varchar(128) DEFAULT NULL,
  `sort` int(11) DEFAULT '100',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=gbk;


DROP TABLE IF EXISTS `excms_contents_videos`;
CREATE TABLE `excms_contents_videos` (
  `contentid` int(11) NOT NULL DEFAULT '0',
  `videos` text NOT NULL,
  `body` mediumtext,
  PRIMARY KEY (`contentid`)
) ENGINE=MyISAM DEFAULT CHARSET=gbk;


DROP TABLE IF EXISTS `excms_cron`;
CREATE TABLE `excms_cron` (
  `cronid` smallint(5) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) DEFAULT NULL,
  `module` varchar(50) DEFAULT NULL,
  `script` varchar(50) DEFAULT NULL,
  `action` varchar(50) DEFAULT NULL,
  `params` varchar(100) DEFAULT NULL,
  `type` tinyint(1) DEFAULT '0',
  `status` tinyint(1) DEFAULT '1',
  `mode` tinyint(1) DEFAULT '1',
  `date` int(11) DEFAULT NULL,
  `interval` smallint(5) DEFAULT NULL,
  `times` smallint(5) DEFAULT '0',
  `minute` varchar(100) DEFAULT NULL,
  `hour` varchar(62) DEFAULT NULL,
  `day` varchar(52) DEFAULT NULL,
  `weekday` varchar(13) DEFAULT NULL,
  `startdate` int(11) DEFAULT NULL,
  `enddate` int(11) DEFAULT NULL,
  `lastrundate` int(11) DEFAULT NULL,
  `runtimes` mediumint(11) DEFAULT '0',
  PRIMARY KEY (`cronid`)
) ENGINE=MyISAM AUTO_INCREMENT=1001 DEFAULT CHARSET=gbk;

INSERT INTO `excms_cron` VALUES ('1','','','','','','0','1','1','','','0','','','','','','','','0');
INSERT INTO `excms_cron` VALUES ('2','','','','','','0','1','1','','','0','','','','','','','','0');
INSERT INTO `excms_cron` VALUES ('3','','','','','','0','1','1','','','0','','','','','','','','0');
INSERT INTO `excms_cron` VALUES ('4','','','','','','0','1','1','','','0','','','','','','','','0');
INSERT INTO `excms_cron` VALUES ('5','','','','','','0','1','1','','','0','','','','','','','','0');

DROP TABLE IF EXISTS `excms_cron_log`;
CREATE TABLE `excms_cron_log` (
  `id` mediumint(9) NOT NULL AUTO_INCREMENT,
  `cronid` smallint(5) DEFAULT NULL,
  `flag` tinyint(1) DEFAULT NULL,
  `message` varchar(255) DEFAULT NULL,
  `rundate` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=1001 DEFAULT CHARSET=gbk;

INSERT INTO `excms_cron_log` VALUES ('1','','','','');
INSERT INTO `excms_cron_log` VALUES ('2','','','','');
INSERT INTO `excms_cron_log` VALUES ('3','','','','');
INSERT INTO `excms_cron_log` VALUES ('4','','','','');
INSERT INTO `excms_cron_log` VALUES ('5','','','','');
INSERT INTO `excms_cron_log` VALUES ('6','','','','');

DROP TABLE IF EXISTS `excms_custompages`;
CREATE TABLE `excms_custompages` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(100) DEFAULT NULL,
  `filename` varchar(100) DEFAULT NULL,
  `keywords` varchar(100) DEFAULT NULL,
  `description` varchar(250) DEFAULT NULL,
  `body` text,
  `compile` tinyint(1) unsigned DEFAULT '0',
  `templet` varchar(100) DEFAULT NULL,
  `modifieddate` int(11) unsigned DEFAULT NULL,
  `createddate` int(11) unsigned DEFAULT NULL,
  `updateddate` int(11) unsigned DEFAULT NULL,
  `adminid` int(11) unsigned DEFAULT NULL,
  `adminname` char(20) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=gbk;


DROP TABLE IF EXISTS `excms_desktop_info`;
CREATE TABLE `excms_desktop_info` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(200) DEFAULT NULL,
  `style` varchar(100) DEFAULT NULL,
  `url` varchar(200) DEFAULT NULL,
  `status` tinyint(1) DEFAULT NULL,
  `sort` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=1001 DEFAULT CHARSET=gbk;

INSERT INTO `excms_desktop_info` VALUES ('1','ӭ','welcome','index.php?M=Desktop&A=Index&method=admininfo','1','1');
INSERT INTO `excms_desktop_info` VALUES ('2','EXCMSٷϢ','official','index.php?M=Desktop&A=Index&method=official','1','2');
INSERT INTO `excms_desktop_info` VALUES ('3','ݿ汾','version','index.php?M=Desktop&A=Index&method=database','1','3');
INSERT INTO `excms_desktop_info` VALUES ('5','վͳ','stat','index.php?M=Desktop&A=Index&method=datatotal','1','5');

DROP TABLE IF EXISTS `excms_desktop_setting`;
CREATE TABLE `excms_desktop_setting` (
  `adminid` int(11) unsigned NOT NULL,
  `data` text,
  `resourceconfig` text,
  PRIMARY KEY (`adminid`)
) ENGINE=MyISAM DEFAULT CHARSET=gbk;


DROP TABLE IF EXISTS `excms_desktop_tree`;
CREATE TABLE `excms_desktop_tree` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `pid` int(11) DEFAULT NULL,
  `title` varchar(50) DEFAULT NULL,
  `icon` varchar(50) DEFAULT NULL,
  `url` varchar(200) DEFAULT NULL,
  `handler` varchar(200) DEFAULT NULL,
  `sort` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=1001 DEFAULT CHARSET=gbk;

INSERT INTO `excms_desktop_tree` VALUES ('1','0','ٴ','ico add','','','0');
INSERT INTO `excms_desktop_tree` VALUES ('2','1','Ŀ','ico add_channel','','parent.EXCMS.util.QuickCreate({model:\'Channel.Editor\'})','1');
INSERT INTO `excms_desktop_tree` VALUES ('3','1','','ico add_article','index.php?M=Content&A=AddContent','','2');
INSERT INTO `excms_desktop_tree` VALUES ('4','1','ͼƬ','ico add_image','index.php?M=Content&A=AddContent&modelname=image','','3');
INSERT INTO `excms_desktop_tree` VALUES ('6','0','湤','ico desktop_tools','','','2');
INSERT INTO `excms_desktop_tree` VALUES ('7','6','ʱ','ico time','','EXCMS.util.QuickDialog({model:\'Time\'})','6');
INSERT INTO `excms_desktop_tree` VALUES ('8','6','ѧ','ico calc','','EXCMS.util.QuickDialog({model:\'Calc\'})','8');
INSERT INTO `excms_desktop_tree` VALUES ('9','6','','ico cale','','EXCMS.util.QuickDialog({model:\'Calr\'})','9');
INSERT INTO `excms_desktop_tree` VALUES ('10','0','Ŀ','ico channels','index.php?M=Channel','','1');
INSERT INTO `excms_desktop_tree` VALUES ('11','0','ݹ','ico contents','index.php?M=Content','','1');
INSERT INTO `excms_desktop_tree` VALUES ('12','0','ҷ','ico my_contents','index.php?M=Content&type=mine','','1');
INSERT INTO `excms_desktop_tree` VALUES ('13','0','۹','ico comments','index.php?M=Modules&EM=Comment','','1');
INSERT INTO `excms_desktop_tree` VALUES ('14','0','','ico update','index.php?M=Update','','1');
INSERT INTO `excms_desktop_tree` VALUES ('15','1','','ico add_download','index.php?M=Content&A=AddContent&modelname=download','','4');
INSERT INTO `excms_desktop_tree` VALUES ('16','1','Զҳ','ico add_custompage','index.php?M=Content&A=CustomPage&act=new','','5');

DROP TABLE IF EXISTS `excms_digg`;
CREATE TABLE `excms_digg` (
  `contentid` int(8) unsigned NOT NULL,
  `topid` mediumint(5) unsigned NOT NULL,
  `channelid` mediumint(4) unsigned NOT NULL,
  `crossid` mediumint(4) unsigned NOT NULL DEFAULT '0',
  `modelid` smallint(2) unsigned NOT NULL DEFAULT '0',
  `checked` tinyint(1) DEFAULT NULL,
  `digg` int(11) unsigned NOT NULL DEFAULT '0',
  `trample` int(11) unsigned NOT NULL DEFAULT '0',
  `daydigg` int(11) unsigned NOT NULL DEFAULT '0',
  `daytrample` int(11) unsigned NOT NULL DEFAULT '0',
  `yesterdaydigg` int(11) unsigned NOT NULL DEFAULT '0',
  `yesterdaytrample` int(11) unsigned NOT NULL DEFAULT '0',
  `weekdigg` int(11) unsigned NOT NULL DEFAULT '0',
  `weektrample` int(11) unsigned NOT NULL DEFAULT '0',
  `monthdigg` int(11) unsigned NOT NULL DEFAULT '0',
  `monthtrample` int(11) unsigned NOT NULL DEFAULT '0',
  `updatetimedigg` int(11) unsigned NOT NULL DEFAULT '0',
  `updatetimetrample` int(11) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`contentid`),
  KEY `topid_checked` (`topid`,`checked`),
  KEY `model_checked` (`modelid`,`checked`),
  KEY `checked_day` (`checked`,`daydigg`),
  KEY `checked_week` (`checked`,`weekdigg`),
  KEY `checked_month` (`checked`,`monthdigg`),
  KEY `checked_digg` (`checked`,`digg`)
) ENGINE=MyISAM DEFAULT CHARSET=gbk;


DROP TABLE IF EXISTS `excms_digg_log`;
CREATE TABLE `excms_digg_log` (
  `contentid` int(11) unsigned DEFAULT NULL,
  `uid` int(11) unsigned DEFAULT NULL,
  `username` char(20) DEFAULT NULL,
  `type` tinyint(1) DEFAULT NULL,
  `ip` char(15) DEFAULT NULL,
  `date` int(11) unsigned DEFAULT NULL,
  KEY `contentid` (`contentid`,`type`,`date`),
  KEY `uid` (`uid`,`contentid`),
  KEY `ip` (`ip`,`contentid`)
) ENGINE=MyISAM DEFAULT CHARSET=gbk;


DROP TABLE IF EXISTS `excms_download_category`;
CREATE TABLE `excms_download_category` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `categoryname` char(50) NOT NULL,
  `sort` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=1001 DEFAULT CHARSET=gbk;

INSERT INTO `excms_download_category` VALUES ('1','Ĭ','1');

DROP TABLE IF EXISTS `excms_download_count`;
CREATE TABLE `excms_download_count` (
  `contentid` int(11) unsigned NOT NULL,
  `channelid` int(11) NOT NULL,
  `crossid` mediumint(5) unsigned DEFAULT NULL,
  `total` int(11) DEFAULT '0',
  `day` int(11) DEFAULT '0',
  `week` int(11) DEFAULT '0',
  `month` int(11) DEFAULT '0',
  `year` int(11) DEFAULT '0',
  `createtime` int(11) DEFAULT NULL,
  PRIMARY KEY (`contentid`)
) ENGINE=MyISAM DEFAULT CHARSET=gbk;


DROP TABLE IF EXISTS `excms_download_mirror`;
CREATE TABLE `excms_download_mirror` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `cid` int(11) NOT NULL,
  `name` char(50) NOT NULL,
  `url` char(100) DEFAULT NULL,
  `default` tinyint(1) DEFAULT '1',
  `enable` tinyint(1) DEFAULT '0',
  `count` int(11) DEFAULT '0',
  `sort` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=gbk;


DROP TABLE IF EXISTS `excms_favorite`;
CREATE TABLE `excms_favorite` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `uid` int(11) unsigned DEFAULT NULL,
  `contentid` int(11) unsigned DEFAULT NULL,
  `category` varchar(50) DEFAULT NULL,
  `title` varchar(80) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `url` varchar(255) DEFAULT NULL,
  `public` tinyint(1) unsigned DEFAULT NULL,
  `addtime` int(11) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=gbk;


DROP TABLE IF EXISTS `excms_favorite_category`;
CREATE TABLE `excms_favorite_category` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `uid` int(11) unsigned DEFAULT NULL,
  `name` varchar(200) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=gbk;


DROP TABLE IF EXISTS `excms_favorite_mapped`;
CREATE TABLE `excms_favorite_mapped` (
  `cateid` int(11) NOT NULL,
  `favoriteid` int(11) unsigned NOT NULL,
  `uid` int(11) unsigned DEFAULT NULL,
  PRIMARY KEY (`cateid`,`favoriteid`),
  KEY `cateid` (`cateid`),
  KEY `uid` (`uid`)
) ENGINE=MyISAM DEFAULT CHARSET=gbk;


DROP TABLE IF EXISTS `excms_favorite_settings`;
CREATE TABLE `excms_favorite_settings` (
  `uid` int(11) NOT NULL,
  `categoryid` int(11) DEFAULT NULL,
  `public` tinyint(1) DEFAULT NULL,
  `pagesize` tinyint(2) DEFAULT NULL,
  PRIMARY KEY (`uid`)
) ENGINE=MyISAM DEFAULT CHARSET=gbk;


DROP TABLE IF EXISTS `excms_folder`;
CREATE TABLE `excms_folder` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `pid` int(11) DEFAULT NULL,
  `tid` smallint(2) DEFAULT NULL,
  `nid` smallint(2) DEFAULT NULL,
  `name` varchar(40) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=gbk;


DROP TABLE IF EXISTS `excms_friend_settings`;
CREATE TABLE `excms_friend_settings` (
  `uid` int(11) NOT NULL,
  `checktype` tinyint(1) DEFAULT NULL,
  `question` varchar(50) DEFAULT NULL,
  `answer` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`uid`)
) ENGINE=MyISAM DEFAULT CHARSET=gbk;


DROP TABLE IF EXISTS `excms_friends`;
CREATE TABLE `excms_friends` (
  `friendid` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `uid` int(11) unsigned DEFAULT NULL,
  `fuid` int(11) unsigned DEFAULT NULL,
  `groups` varchar(100) NOT NULL,
  `type` tinyint(1) unsigned DEFAULT '0',
  `addtime` int(11) unsigned DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`friendid`)
) ENGINE=MyISAM DEFAULT CHARSET=gbk;


DROP TABLE IF EXISTS `excms_friends_group`;
CREATE TABLE `excms_friends_group` (
  `groupid` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `uid` int(11) unsigned DEFAULT NULL,
  `name` char(20) DEFAULT NULL,
  `sort` int(5) unsigned DEFAULT NULL,
  PRIMARY KEY (`groupid`)
) ENGINE=MyISAM DEFAULT CHARSET=gbk;


DROP TABLE IF EXISTS `excms_iplocation`;
CREATE TABLE `excms_iplocation` (
  `ip` varchar(20) NOT NULL DEFAULT '',
  `beginip` varchar(20) DEFAULT NULL,
  `endip` varchar(20) DEFAULT NULL,
  `domain` varchar(50) DEFAULT NULL,
  `country` varchar(50) DEFAULT NULL,
  `area` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`ip`)
) ENGINE=MyISAM DEFAULT CHARSET=gbk;


DROP TABLE IF EXISTS `excms_likekeyword_index`;
CREATE TABLE `excms_likekeyword_index` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `name` char(80) DEFAULT NULL,
  `contentscount` int(11) unsigned DEFAULT '0',
  `createddate` int(11) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=gbk;


DROP TABLE IF EXISTS `excms_likekeyword_list`;
CREATE TABLE `excms_likekeyword_list` (
  `id` int(8) NOT NULL,
  `contentid` int(8) NOT NULL,
  `channelid` mediumint(5) DEFAULT NULL,
  `sort` int(6) DEFAULT '10',
  PRIMARY KEY (`id`,`contentid`),
  KEY `contentid` (`contentid`),
  KEY `contentid_id` (`contentid`,`id`),
  KEY `channelid_contentid_id` (`channelid`,`contentid`,`id`)
) ENGINE=MyISAM DEFAULT CHARSET=gbk;


DROP TABLE IF EXISTS `excms_links`;
CREATE TABLE `excms_links` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `cid` int(11) NOT NULL,
  `name` char(100) DEFAULT NULL,
  `url` char(200) DEFAULT NULL,
  `haslogo` tinyint(1) DEFAULT NULL,
  `logo` char(200) DEFAULT NULL,
  `checked` tinyint(1) DEFAULT '0',
  `email` char(50) DEFAULT NULL,
  `sitename` char(50) DEFAULT NULL,
  `info` text,
  `index` tinyint(1) DEFAULT '0',
  `sort` int(11) DEFAULT NULL,
  `createddate` int(11) DEFAULT NULL,
  `click` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=1001 DEFAULT CHARSET=gbk;

INSERT INTO `excms_links` VALUES ('1','1','','http://www.excms.cn','2','http://www.excms.cn/logo.gif','1','','EXCMS׿Խݹϵͳ','','1','100','1264642843','15');
INSERT INTO `excms_links` VALUES ('2','1','','http://www.excms.cn','1','','1','','EXCMS','','1','100','1264642969','2');
INSERT INTO `excms_links` VALUES ('3','1','','http://www.excms.cn','1','','1','','׿Խݹϵͳ','','0','100','1264643076','4');

DROP TABLE IF EXISTS `excms_links_category`;
CREATE TABLE `excms_links_category` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `name` char(50) NOT NULL DEFAULT '',
  `sort` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=1001 DEFAULT CHARSET=gbk;

INSERT INTO `excms_links_category` VALUES ('1','','1');

DROP TABLE IF EXISTS `excms_menu`;
CREATE TABLE `excms_menu` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `pid` int(11) unsigned DEFAULT NULL,
  `name` varchar(50) DEFAULT NULL,
  `identity` varchar(50) DEFAULT NULL,
  `url` varchar(200) DEFAULT NULL,
  `target` tinyint(1) unsigned DEFAULT NULL,
  `modules` varchar(20) DEFAULT NULL,
  `extendmodules` varchar(20) DEFAULT NULL,
  `action` varchar(20) DEFAULT NULL,
  `icon` varchar(50) DEFAULT NULL,
  `handler` varchar(4000) DEFAULT NULL,
  `activeclass` varchar(50) DEFAULT NULL,
  `param` varchar(4000) DEFAULT NULL,
  `ismain` tinyint(1) DEFAULT NULL,
  `display` tinyint(1) unsigned DEFAULT NULL,
  `issystem` tinyint(1) unsigned DEFAULT '0',
  `isacl` tinyint(1) unsigned DEFAULT '0',
  `sort` int(11) unsigned DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=1001 DEFAULT CHARSET=gbk;

INSERT INTO `excms_menu` VALUES ('1','0','','Desktop','','0','','','','','','','','0','1','1','0','1');
INSERT INTO `excms_menu` VALUES ('2','0','Ŀ','Channel','','0','','','','','','','','0','1','1','1','2');
INSERT INTO `excms_menu` VALUES ('3','0','','Content','','0','','','','','','','','0','1','1','1','3');
INSERT INTO `excms_menu` VALUES ('4','0','','Update','','0','','','','','','','','0','1','1','1','4');
INSERT INTO `excms_menu` VALUES ('5','0','ģ','Template','','0','','','','','','','','0','1','1','1','5');
INSERT INTO `excms_menu` VALUES ('6','0','Դ','Resource','index.php?M=Resource','0','Resource','','','','','','','1','1','1','1','6');
INSERT INTO `excms_menu` VALUES ('7','0','ģ','Module','','0','','','','','','','','0','1','1','1','7');
INSERT INTO `excms_menu` VALUES ('8','0','','Plugin','','0','','','','','','','','0','1','1','1','8');
INSERT INTO `excms_menu` VALUES ('9','0','û','Account','','0','','','','','','','','0','1','1','1','9');
INSERT INTO `excms_menu` VALUES ('10','0','ϵͳ','System','','0','','','','','','','','0','1','1','1','10');
INSERT INTO `excms_menu` VALUES ('11','1','ҵ','desktop','index.php?M=Desktop','1','Desktop','','','ico desktop','this.g','','','1','1','1','0','50');
INSERT INTO `excms_menu` VALUES ('12','1','վҳ','homepage','/','0','','','','ico homepage','','','hrefTarget: \'_blank\'','0','1','1','0','50');
INSERT INTO `excms_menu` VALUES ('13','1','湤','desktop_tools','','0','','','','ico desktop_tools','','','','0','1','1','0','50');
INSERT INTO `excms_menu` VALUES ('14','13','ʱ','time','','0','','','','ico time','EXCMS.util.QuickDialog','','model: \'Time\'','0','1','1','0','50');
INSERT INTO `excms_menu` VALUES ('15','13','','cale','','0','','','','ico cale','EXCMS.util.QuickDialog','','model: \'Calr\'','0','1','1','0','50');
INSERT INTO `excms_menu` VALUES ('16','13','','calc','','0','','','','ico calc','EXCMS.util.QuickDialog','','model: \'Calc\'','0','1','1','0','50');
INSERT INTO `excms_menu` VALUES ('17','1','','profile','index.php?M=System&A=AdminProfile','0','System','','AdminProfile','ico profile','this.g','','','1','1','1','0','52');
INSERT INTO `excms_menu` VALUES ('18','17','Ϣ','profile','index.php?M=System&A=AdminProfile','0','System','','AdminProfile','','this.g','','','1','1','1','0','50');
INSERT INTO `excms_menu` VALUES ('19','17','޸','logout','','0','','','','ico password','EXCMS.util.QuickCreate','','model: \'Admin.SetPassword\'','0','1','1','0','50');
INSERT INTO `excms_menu` VALUES ('20','1','','DesktopSetting','','0','','','','','EXCMS.util.QuickCreate','','model: \'DesktopSetting.Editor\'','0','1','1','0','52');
INSERT INTO `excms_menu` VALUES ('21','1','ע','logout','','0','Auth','','Logout','ico logout','','','href: \'index.php?M=Auth&A=Logout\'','0','1','1','0','54');
INSERT INTO `excms_menu` VALUES ('22','1','˳','exit','','0','Auth','','Logout','ico exit','','','href: \'index.php?M=Auth&A=Logout&act=exit\'','0','1','1','0','54');
INSERT INTO `excms_menu` VALUES ('23','2','½Ŀ','add_channel','','0','','','','ico add_channel','EXCMS.util.QuickCreate','','model: \'Channel.Editor\'','0','1','1','1','1');
INSERT INTO `excms_menu` VALUES ('24','2','Ŀ','channels','index.php?M=Channel','0','Channel','','','ico channels','this.g','','','1','1','1','1','2');
INSERT INTO `excms_menu` VALUES ('25','2','½ģ','add_models','','0','','','','ico models','EXCMS.util.QuickCreate','','model: \'Model.Editor\'','0','1','1','1','5');
INSERT INTO `excms_menu` VALUES ('26','2','ģ','models','index.php?M=Model','0','Model','','','ico models','this.g','','','1','1','1','1','6');
INSERT INTO `excms_menu` VALUES ('27','2','','category','index.php?M=Category','0','Category','','','ico category','this.g','','','1','1','1','1','9');
INSERT INTO `excms_menu` VALUES ('28','3','½','add_article','','0','','','','ico add_article','','','','0','1','1','0','50');
INSERT INTO `excms_menu` VALUES ('29','3','ݹ','contents','index.php?M=Content','0','Content','','','ico contents','this.g','','','1','1','1','1','52');
INSERT INTO `excms_menu` VALUES ('30','3','Զҳ','custompages','index.php?M=Content&A=CustomPage','0','Content','','CustomPage','ico custompages','this.g','','','1','1','1','1','52');
INSERT INTO `excms_menu` VALUES ('31','3','','RelatedTitle','index.php?M=Content&A=RelatedTitle','0','Content','','RelatedTitle','','this.g','','','1','1','1','1','54');
INSERT INTO `excms_menu` VALUES ('32','3','ؼ','keywordslink','index.php?M=Content&A=Keywords','0','Content','','Keywords','ico keywordslink','this.g','','','1','1','1','1','55');
INSERT INTO `excms_menu` VALUES ('33','3','Tag ǩ','tags','index.php?M=Content&A=Tag','0','Content','','Tag','ico tags','this.g','','','1','1','1','1','54');
INSERT INTO `excms_menu` VALUES ('34','3','عؼ','Likekeyword','index.php?M=Content&A=Likekeyword','0','Content','','Likekeyword','','this.g','','','1','1','1','1','55');
INSERT INTO `excms_menu` VALUES ('35','3','','authors','index.php?M=Content&A=Author','0','Content','','Author','ico authors','this.g','','','1','1','1','1','55');
INSERT INTO `excms_menu` VALUES ('36','3','Դ','sources','index.php?M=Content&A=Source','0','Content','','Source','ico sources','this.g','','','1','1','1','1','55');
INSERT INTO `excms_menu` VALUES ('37','3','ݹ','contenttools','','0','','','','ico desktop_tools','','','','0','1','1','0','56');
INSERT INTO `excms_menu` VALUES ('38','3','ͳ','chart','index.php?M=Content&A=Stat','0','Content','','Stat','ico chart','this.g','','','1','0','1','0','56');
INSERT INTO `excms_menu` VALUES ('39','37','ά','ContentBatch','index.php?M=Content&A=ContentBatch','0','Content','','ContentBatch','','this.g','','','1','1','1','0','50');
INSERT INTO `excms_menu` VALUES ('40','37','ҳ','AutoAbstract','index.php?M=Content&A=AutoAbstract','0','Content','','AutoAbstract','','this.g','','','1','1','1','0','50');
INSERT INTO `excms_menu` VALUES ('41','4','ҳ','update_home','index.php?M=Update&method=index','0','Update','','','ico update_home','this.g','','','0','1','1','0','50');
INSERT INTO `excms_menu` VALUES ('42','4','Ŀ','update_channel','index.php?M=Update&method=channel','0','Update','','','ico update_channel','this.g','','','0','1','1','0','50');
INSERT INTO `excms_menu` VALUES ('43','4','','update_archive','index.php?M=Update&method=content','0','Update','','','ico update_archive','this.g','','','0','1','1','0','50');
INSERT INTO `excms_menu` VALUES ('44','4','Զҳ','update_custompage','index.php?M=Update&method=custompage','0','Update','','','ico update_custompage','this.g','','','0','1','1','0','50');
INSERT INTO `excms_menu` VALUES ('45','4','վͼ','update_map','index.php?M=Update&method=map','0','Update','','','ico update_map','this.g','','','0','1','1','0','52');
INSERT INTO `excms_menu` VALUES ('46','4','RSSļ','update_rss','index.php?M=Update&method=rss','0','Update','','','ico update_rss','this.g','','','0','1','1','0','52');
INSERT INTO `excms_menu` VALUES ('47','4','Sitemap','update_sitemap','index.php?M=Update&method=sitemap','0','Update','','','ico update_sitemap','this.g','','','0','1','1','0','52');
INSERT INTO `excms_menu` VALUES ('48','4','','update_link','index.php?M=Update&method=link','0','Update','','','ico update_link','this.g','','','0','1','1','0','52');
INSERT INTO `excms_menu` VALUES ('49','4','»','cache','index.php?M=System&A=Index&method=allcache','0','System','','Index','ico cache','this.updateCache','','','0','1','1','0','54');
INSERT INTO `excms_menu` VALUES ('50','49','ϵͳ','systemcache','index.php?M=System&A=Index&method=cache','0','System','','Index','','this.updateCache','','','0','1','1','0','50');
INSERT INTO `excms_menu` VALUES ('51','49','URL','urlcache','index.php?M=System&A=Url&method=cache','0','System','','url','','this.updateCache','','','0','1','1','0','50');
INSERT INTO `excms_menu` VALUES ('52','49','Ŀ','channelcache','index.php?M=Channel&A=Index&method=cache','0','Channel','','Index','','this.updateCache','','','0','1','1','0','50');
INSERT INTO `excms_menu` VALUES ('53','49','ģͻ','modelcache','index.php?M=Model&A=Index&method=cachemodel','0','Model','','Index','','this.updateCache','','','0','1','1','0','50');
INSERT INTO `excms_menu` VALUES ('54','49','ֶλ','mainfieldcache','index.php?M=Model&A=Index&method=cachemainfield','0','Model','','Index','','this.updateCache','','','0','1','1','0','50');
INSERT INTO `excms_menu` VALUES ('55','49','ȫ','allcache','index.php?M=System&A=Index&method=allcache','0','System','','Index','','this.updateCache','','','0','1','1','0','50');
INSERT INTO `excms_menu` VALUES ('56','5','ģ','template','index.php?M=Template','0','Template','','','ico template','this.g','','','1','1','1','1','50');
INSERT INTO `excms_menu` VALUES ('57','5','ģ建','cleartplcache','index.php?M=Template&A=Index&method=clearcache','0','Template','','Index','ico cleartplcache','this.updateCache','','','0','1','1','0','52');
INSERT INTO `excms_menu` VALUES ('58','7','ģ','module','index.php?M=Modules','0','Modules','','','ico module','this.g','','','1','1','1','1','50');
INSERT INTO `excms_menu` VALUES ('59','8','','plugin','index.php?M=Plugins','0','Plugins','','','ico plugin','this.g','','','1','1','1','1','50');
INSERT INTO `excms_menu` VALUES ('60','9','û','account','index.php?M=Modules&EM=account','0','Modules','account','','ico user','this.g','','','1','1','1','1','50');
INSERT INTO `excms_menu` VALUES ('61','9','ʻ','accountconfig','index.php?M=Modules&EM=account&A=AccountConfig&type=config','0','Modules','account','AccountConfig','','this.g','','','1','1','1','1','52');
INSERT INTO `excms_menu` VALUES ('62','10','ϵͳ','system','index.php?M=System','0','System','','','ico system','this.g','','','1','1','1','1','1');
INSERT INTO `excms_menu` VALUES ('63','10','URLд','url','index.php?M=System&A=Url','0','System','','Url','ico url','this.g','','','1','1','1','1','1');
INSERT INTO `excms_menu` VALUES ('64','10','Ա','admin','index.php?M=System&A=Admin','0','System','','Admin','ico admin','this.g','','','1','1','1','1','3');
INSERT INTO `excms_menu` VALUES ('65','10','ݿ','database','index.php?M=System&A=Database','0','System','','Database','ico database','this.g','','','1','1','1','1','5');
INSERT INTO `excms_menu` VALUES ('66','10','','desktopmanage','index.php?M=System&A=DesktopManage','0','System','','DesktopManage','','this.g','','','1','1','1','1','40');
INSERT INTO `excms_menu` VALUES ('68','0','','Help','','0','','','','','this.g','','','0','1','1','1','11');
INSERT INTO `excms_menu` VALUES ('69','68','','help','','0','','','','ico help','function(){EXCMS.util.RequestUrl(\'http://www.excms.cn/help\')}','','','0','1','1','0','50');
INSERT INTO `excms_menu` VALUES ('70','68','֧','support','','0','','','','ico support','function(){EXCMS.util.RequestUrl(\'http://www.excms.cn/support\')}','','','0','1','1','0','50');
INSERT INTO `excms_menu` VALUES ('71','68','','updatecms','','0','','','','ico updatecms','this.checkupdate','','','0','1','1','1','52');
INSERT INTO `excms_menu` VALUES ('72','68','EXCMS ׿Խݹϵͳ','aboutEXCMS','','0','','','','ico aboutEXCMS','this.about','','','0','1','1','0','54');
INSERT INTO `excms_menu` VALUES ('74','10','˵','Menu','index.php?M=System&A=Menu','0','System','','Menu','','this.g','','','1','1','1','1','7');
INSERT INTO `excms_menu` VALUES ('75','10','Ȩ޹','Permissions','index.php?M=System&A=Permissions','0','System','','Permissions','','this.g','','','1','1','1','1','3');
INSERT INTO `excms_menu` VALUES ('76','2','','batchAdd','index.php?M=Channel&A=BatchAddChannel','0','Channel','','BatchAddChannel','','this.g','','','1','1','1','1','3');
INSERT INTO `excms_menu` VALUES ('77','4','Ƭ','block','index.php?M=block&method=index','0','block','','','','this.g','','','1','1','1','1','1');
INSERT INTO `excms_menu` VALUES ('89','1','-','split','','0','','','','','','','','0','1','1','0','51');
INSERT INTO `excms_menu` VALUES ('90','2','-','split','','0','','','','','','','','0','1','1','0','4');
INSERT INTO `excms_menu` VALUES ('93','1','-','split','','0','','','','','','','','0','1','1','0','53');
INSERT INTO `excms_menu` VALUES ('94','2','-','split','','0','','','','','','','','0','1','1','0','8');
INSERT INTO `excms_menu` VALUES ('95','3','-','split','','0','','','','','','','','0','1','1','0','51');
INSERT INTO `excms_menu` VALUES ('96','3','-','split','','0','','','','','','','','0','1','1','0','53');
INSERT INTO `excms_menu` VALUES ('97','3','-','split','','0','','','','','','','','0','1','1','0','55');
INSERT INTO `excms_menu` VALUES ('98','5','-','split','','0','','','','','','','','0','1','1','0','51');
INSERT INTO `excms_menu` VALUES ('100','9','-','split','','0','','','','','','','','0','1','1','0','51');
INSERT INTO `excms_menu` VALUES ('101','10','-','split','','0','','','','','','','','0','1','1','0','2');
INSERT INTO `excms_menu` VALUES ('102','10','-','split','','0','','','','','','','','0','1','1','0','4');
INSERT INTO `excms_menu` VALUES ('103','10','-','split','','0','','','','','','','','0','1','1','0','6');
INSERT INTO `excms_menu` VALUES ('104','68','-','split','','0','','','','','','','','0','1','1','0','51');
INSERT INTO `excms_menu` VALUES ('105','68','-','split','','0','','','','','','','','0','1','1','0','53');
INSERT INTO `excms_menu` VALUES ('106','4','-','split','','0','','','','','','','','0','1','1','0','51');
INSERT INTO `excms_menu` VALUES ('107','4','-','split','','0','','','','','','','','0','1','1','0','53');
INSERT INTO `excms_menu` VALUES ('150','10','','','index.php?M=System&A=publishingpoint','0','System','','publishingpoint','','this.g','','','1','1','1','1','1');
INSERT INTO `excms_menu` VALUES ('166','4','-','','','0','','','','','','','','0','1','0','0','2');
INSERT INTO `excms_menu` VALUES ('167','2','ģֶ','modelfield','index.php?M=Model&A=ModelField','0','Model','','ModelField','','this.g','','','1','1','0','1','7');

DROP TABLE IF EXISTS `excms_message`;
CREATE TABLE `excms_message` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `fromuid` int(11) unsigned DEFAULT NULL,
  `touid` int(11) unsigned DEFAULT NULL,
  `reid` int(11) unsigned DEFAULT '0',
  `subject` char(80) DEFAULT NULL,
  `content` mediumtext,
  `sendtime` int(11) unsigned DEFAULT NULL,
  `status` tinyint(1) unsigned DEFAULT NULL,
  `reply` tinyint(1) unsigned DEFAULT NULL,
  `type` tinyint(1) DEFAULT NULL,
  `del` int(11) unsigned DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=gbk;


DROP TABLE IF EXISTS `excms_models`;
CREATE TABLE `excms_models` (
  `modelid` smallint(5) NOT NULL AUTO_INCREMENT,
  `name` varchar(20) DEFAULT NULL,
  `ename` varchar(20) NOT NULL,
  `addontable` varchar(20) DEFAULT NULL,
  `templateindex` varchar(100) DEFAULT NULL,
  `templatelist` varchar(100) DEFAULT NULL,
  `templatedetail` varchar(100) DEFAULT NULL,
  `issystem` tinyint(2) unsigned DEFAULT '0',
  `status` tinyint(2) unsigned DEFAULT '0',
  `sort` tinyint(2) DEFAULT NULL,
  PRIMARY KEY (`modelid`)
) ENGINE=MyISAM AUTO_INCREMENT=1001 DEFAULT CHARSET=gbk;

INSERT INTO `excms_models` VALUES ('1','','article','contents_articles','channel.html','list.html','content.html','1','1','1');
INSERT INTO `excms_models` VALUES ('2','ͼƬ','image','contents_images','channel_image.html','list_image.html','content_image.html','1','1','2');
INSERT INTO `excms_models` VALUES ('3','','download','contents_download','channel_download.html','list_download.html','content_download.html','1','1','3');
INSERT INTO `excms_models` VALUES ('4','Ƶ','video','contents_videos','channel.html','list_video.html','content_video.html','1','1','4');

DROP TABLE IF EXISTS `excms_models_fields`;
CREATE TABLE `excms_models_fields` (
  `fieldid` int(11) NOT NULL AUTO_INCREMENT,
  `modelid` int(11) DEFAULT NULL,
  `formname` varchar(50) DEFAULT NULL,
  `fieldname` varchar(50) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `datatype` int(2) DEFAULT NULL,
  `datalength` int(11) DEFAULT NULL,
  `allownull` tinyint(1) DEFAULT NULL,
  `default` text,
  `allowshow` tinyint(1) DEFAULT '1',
  `allowlist` tinyint(1) DEFAULT '0',
  `allowcontribute` tinyint(1) DEFAULT '0',
  `allowsearch` tinyint(1) DEFAULT '0',
  `addonAtributes` text,
  `sort` int(11) DEFAULT '50',
  `issystem` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`fieldid`)
) ENGINE=MyISAM AUTO_INCREMENT=1001 DEFAULT CHARSET=gbk;

INSERT INTO `excms_models_fields` VALUES ('1','0','contentid','contentid','id','3','8','1','','1','1','1','1','','0','1');
INSERT INTO `excms_models_fields` VALUES ('2','0','modelid','modelid','ģID','3','2','1','1','1','1','1','1','','0','1');
INSERT INTO `excms_models_fields` VALUES ('3','0','channelid','channelid','ĿID','3','4','1','0','1','1','1','1','','0','1');
INSERT INTO `excms_models_fields` VALUES ('4','0','crossid','crossid','ĿID','3','5','0','','1','1','1','1','','0','1');
INSERT INTO `excms_models_fields` VALUES ('5','0','title','title','','0','80','1','','1','1','1','1','','0','1');
INSERT INTO `excms_models_fields` VALUES ('6','0','shorttitle','shorttitle','','0','40','0','','1','1','1','1','','0','1');
INSERT INTO `excms_models_fields` VALUES ('7','0','metatitle','metatitle','Meta','0','100','0','','1','1','1','1','','0','1');
INSERT INTO `excms_models_fields` VALUES ('8','0','keywords','keywords','ؼ','0','70','0','','1','1','1','1','','0','1');
INSERT INTO `excms_models_fields` VALUES ('9','0','tags','tags','Tag','0','70','0','','1','1','1','1','','0','1');
INSERT INTO `excms_models_fields` VALUES ('10','0','description','description','ժҪ','0','250','0','','1','1','1','1','','0','1');
INSERT INTO `excms_models_fields` VALUES ('11','0','source','source','Դ','0','60','0','','1','1','1','1','','0','1');
INSERT INTO `excms_models_fields` VALUES ('12','0','author','author','','0','60','0','','1','1','1','1','','0','1');
INSERT INTO `excms_models_fields` VALUES ('13','0','isthumb','isthumb','Ƿͼ','3','1','1','0','1','1','1','1','','0','1');
INSERT INTO `excms_models_fields` VALUES ('14','0','thumb','thumb','ͼ','0','100','0','','1','1','1','1','','0','1');
INSERT INTO `excms_models_fields` VALUES ('15','0','titleatt','titleatt','(б[i]Ӵ[b]»[u]ɫ[c])','0','50','0','','1','1','1','1','','0','1');
INSERT INTO `excms_models_fields` VALUES ('16','0','likekeywords','likekeywords','عؼ','0','40','0','','1','1','1','1','','0','1');
INSERT INTO `excms_models_fields` VALUES ('17','0','likecontentid','likecontentid','ID','0','200','0','','1','1','1','1','','0','1');
INSERT INTO `excms_models_fields` VALUES ('18','0','forward','forward','ת','0','100','0','','1','1','1','1','','0','1');
INSERT INTO `excms_models_fields` VALUES ('19','0','template','template','ģ','0','100','0','','1','1','1','1','','0','1');
INSERT INTO `excms_models_fields` VALUES ('20','0','filename','filename','Զļ','0','50','0','','1','1','1','1','','0','1');
INSERT INTO `excms_models_fields` VALUES ('21','0','ishtml','ishtml','ʽ 0:̬ 1:̬ 2:δɵľ̬','3','1','1','0','1','1','1','1','','0','1');
INSERT INTO `excms_models_fields` VALUES ('22','0','path','path','ݴλ','0','200','0','','1','1','1','1','','0','1');
INSERT INTO `excms_models_fields` VALUES ('23','0','checked','checked','Ƿ-1:ݸ 0:δ 1:ͨ 2:δͨ','3','1','1','0','1','1','1','1','','0','1');
INSERT INTO `excms_models_fields` VALUES ('24','0','publishdate','publishdate','ʱ','3','11','1','0','1','1','1','1','','0','1');
INSERT INTO `excms_models_fields` VALUES ('25','0','modifieddate','modifieddate','޸ʱ','3','11','1','0','1','1','1','1','','0','1');
INSERT INTO `excms_models_fields` VALUES ('26','0','createddate','createddate','ʱ','3','11','1','0','1','1','1','1','','0','1');
INSERT INTO `excms_models_fields` VALUES ('27','0','distillate','distillate','','3','1','0','','1','1','1','1','','0','1');
INSERT INTO `excms_models_fields` VALUES ('28','0','recommend','recommend','Ƽ','0','15','0','','1','1','1','1','','0','1');
INSERT INTO `excms_models_fields` VALUES ('29','0','credits','credits','Ķ','3','11','1','0','1','1','1','1','','0','1');
INSERT INTO `excms_models_fields` VALUES ('30','0','comment','comment','Ƿ','3','1','1','0','1','1','1','1','','0','1');
INSERT INTO `excms_models_fields` VALUES ('31','0','sort','sort','','3','2','1','0','1','1','1','1','','0','1');
INSERT INTO `excms_models_fields` VALUES ('32','0','editor','editor','α༭','0','20','0','','1','1','1','1','','0','1');
INSERT INTO `excms_models_fields` VALUES ('33','0','modifiedby','modifiedby','޸ûID','3','5','1','','1','1','1','1','','0','1');
INSERT INTO `excms_models_fields` VALUES ('34','0','modifiedbyadmin','modifiedbyadmin','޸ûǷǹԱ','3','1','1','0','1','1','1','1','','0','1');
INSERT INTO `excms_models_fields` VALUES ('35','0','createdby','createdby','ûID','3','5','1','','1','1','1','1','','0','1');
INSERT INTO `excms_models_fields` VALUES ('36','0','createdbyadmin','createdbyadmin','ûǷǹԱ','3','1','1','0','1','1','1','1','','0','1');
INSERT INTO `excms_models_fields` VALUES ('50','1','','body','洢','2','0','1','','1','1','1','1','a:7:{s:5:\"width\";s:4:\"100%\";s:8:\"validate\";s:0:\"\";s:9:\"regexText\";s:14:\"ֻ\";s:9:\"maxlength\";i:0;s:6:\"height\";i:437;s:11:\"addonoption\";a:4:{i:0;s:10:\"deletelink\";i:1;s:14:\"remotedownload\";i:2;s:11:\"displaypage\";i:3;s:14:\"contentkeyword\";}s:12:\"displayLabel\";i:0;}','1','1');
INSERT INTO `excms_models_fields` VALUES ('51','2','ͼƬ','images','ͼƬ','13','0','1','','1','1','1','1','a:6:{s:5:\"width\";s:0:\"\";s:8:\"validate\";s:0:\"\";s:9:\"regexText\";s:0:\"\";s:6:\"height\";i:0;s:12:\"displayLabel\";i:0;s:11:\"displaypage\";i:1;}','50','1');
INSERT INTO `excms_models_fields` VALUES ('52','2','ͼƬ˵','body','','2','0','1','','1','1','0','1','a:7:{s:5:\"width\";s:0:\"\";s:8:\"validate\";s:0:\"\";s:9:\"regexText\";s:0:\"\";s:9:\"maxlength\";i:0;s:6:\"height\";i:0;s:11:\"addonoption\";a:2:{i:0;s:10:\"deletelink\";i:1;s:14:\"remotedownload\";}s:12:\"displayLabel\";i:1;}','50','1');
INSERT INTO `excms_models_fields` VALUES ('60','3','ʽ','publishtype','ʽ(1°汾2)','10','0','1','1','1','1','1','1','a:6:{s:5:\"width\";s:0:\"\";s:8:\"validate\";s:0:\"\";s:9:\"regexText\";s:0:\"\";s:9:\"emptytext\";s:0:\"\";s:9:\"blanktext\";s:0:\"\";s:10:\"addonvalue\";s:19:\"1:°汾\n2:\";}','1','1');
INSERT INTO `excms_models_fields` VALUES ('61','3','','downcategory','(1:,2:3:)','12','0','1','','1','1','1','1','a:7:{s:5:\"width\";s:3:\"-15\";s:8:\"validate\";s:0:\"\";s:9:\"regexText\";s:0:\"\";s:9:\"valuefrom\";i:8;s:11:\"multiselect\";i:0;s:9:\"blanktext\";s:0:\"\";s:9:\"emptytext\";s:0:\"\";}','2','1');
INSERT INTO `excms_models_fields` VALUES ('62','3','汾','version','汾','0','250','1','','1','1','1','1','a:7:{s:5:\"width\";s:0:\"\";s:8:\"validate\";s:0:\"\";s:9:\"regexText\";s:0:\"\";s:9:\"emptytext\";s:0:\"\";s:9:\"blanktext\";s:0:\"\";s:9:\"maxlength\";i:0;s:8:\"password\";i:0;}','7','1');
INSERT INTO `excms_models_fields` VALUES ('63','3','ļС','filesize','ļС','0','250','1','','1','1','0','1','a:5:{s:5:\"width\";s:2:\"60\";s:9:\"emptytext\";s:8:\"λΪKB\";s:9:\"blanktext\";s:0:\"\";s:9:\"maxlength\";i:0;s:8:\"password\";i:0;}','14','1');
INSERT INTO `excms_models_fields` VALUES ('64','3','','downtype','(12ĵ3','12','0','1','','1','1','1','1','a:5:{s:5:\"width\";s:3:\"-15\";s:9:\"valuefrom\";i:12;s:11:\"multiselect\";i:0;s:9:\"blanktext\";s:0:\"\";s:9:\"emptytext\";s:0:\"\";}','3','1');
INSERT INTO `excms_models_fields` VALUES ('65','3','ļ','filetype','ļ','12','0','1','','1','1','1','1','a:5:{s:5:\"width\";s:2:\"60\";s:9:\"valuefrom\";i:13;s:11:\"multiselect\";i:0;s:9:\"blanktext\";s:0:\"\";s:9:\"emptytext\";s:0:\"\";}','15','1');
INSERT INTO `excms_models_fields` VALUES ('66','3','','copyright','(1ҵ234)','12','0','1','','1','1','1','1','a:5:{s:5:\"width\";s:1:\"0\";s:9:\"valuefrom\";i:10;s:11:\"multiselect\";i:0;s:9:\"blanktext\";s:0:\"\";s:9:\"emptytext\";s:0:\"\";}','8','1');
INSERT INTO `excms_models_fields` VALUES ('67','3','','publisher','','0','250','1','','1','1','1','1','a:5:{s:5:\"width\";s:3:\"-15\";s:9:\"emptytext\";s:0:\"\";s:9:\"blanktext\";s:0:\"\";s:9:\"maxlength\";i:0;s:8:\"password\";i:0;}','5','1');
INSERT INTO `excms_models_fields` VALUES ('68','3','ٷַ','publisherurl','ٷַ','0','250','1','http://','1','1','1','1','a:7:{s:5:\"width\";s:0:\"\";s:8:\"validate\";s:12:\"/^http:\\/\\//\";s:9:\"regexText\";s:0:\"\";s:9:\"emptytext\";s:0:\"\";s:9:\"blanktext\";s:0:\"\";s:9:\"maxlength\";i:0;s:8:\"password\";i:0;}','6','1');
INSERT INTO `excms_models_fields` VALUES ('69','3','ʾַ','demo','ʾַ','0','250','0','http://','0','0','0','0','a:5:{s:5:\"width\";i:0;s:9:\"emptytext\";s:0:\"\";s:9:\"blanktext\";s:0:\"\";s:9:\"maxlength\";i:0;s:8:\"password\";i:0;}','12','1');
INSERT INTO `excms_models_fields` VALUES ('70','3','','email','','0','250','1','','1','1','0','1','a:7:{s:5:\"width\";s:3:\"400\";s:8:\"validate\";s:31:\"/^[\\w\\-\\.]+@[\\w\\-\\.]+(\\.\\w+)+$/\";s:9:\"regexText\";s:0:\"\";s:9:\"emptytext\";s:0:\"\";s:9:\"blanktext\";s:0:\"\";s:9:\"maxlength\";i:250;s:8:\"password\";i:0;}','11','1');
INSERT INTO `excms_models_fields` VALUES ('71','3','Ӧƽ̨','platform','Ӧƽ̨','12','0','1','','1','1','1','1','a:7:{s:5:\"width\";s:3:\"-15\";s:8:\"validate\";s:0:\"\";s:9:\"regexText\";s:0:\"\";s:9:\"valuefrom\";i:14;s:11:\"multiselect\";i:1;s:9:\"blanktext\";s:0:\"\";s:9:\"emptytext\";s:0:\"\";}','4','1');
INSERT INTO `excms_models_fields` VALUES ('72','3','','language','(1:ģ2ģ3Ӣ,4:','12','0','1','','1','1','1','1','a:5:{s:5:\"width\";s:1:\"0\";s:9:\"valuefrom\";i:9;s:11:\"multiselect\";i:0;s:9:\"blanktext\";s:0:\"\";s:9:\"emptytext\";s:0:\"\";}','9','1');
INSERT INTO `excms_models_fields` VALUES ('73','3','˵','body','˵','2','0','1','','1','1','1','1','a:7:{s:5:\"width\";s:4:\"100%\";s:8:\"validate\";s:0:\"\";s:9:\"regexText\";s:0:\"\";s:9:\"maxlength\";i:0;s:6:\"height\";i:0;s:11:\"addonoption\";a:2:{i:0;s:10:\"deletelink\";i:1;s:14:\"remotedownload\";}s:12:\"displayLabel\";i:1;}','17','1');
INSERT INTO `excms_models_fields` VALUES ('74','3','ȼ','level','ȼ(1,2,3,4,5)ȼ','9','0','1','3','1','1','0','1','a:4:{s:5:\"width\";s:4:\"100%\";s:9:\"emptytext\";s:0:\"\";s:9:\"blanktext\";s:0:\"\";s:10:\"addonvalue\";s:34:\"һ:1\n:2\n:3\n:4\n:5\";}','10','1');
INSERT INTO `excms_models_fields` VALUES ('75','3','صַ','urls','վصַ','14','0','1','','1','1','1','1','a:8:{s:5:\"width\";s:3:\"-24\";s:8:\"validate\";s:0:\"\";s:9:\"regexText\";s:0:\"\";s:9:\"tablename\";s:0:\"\";s:6:\"height\";i:0;s:6:\"column\";s:0:\"\";s:12:\"systemMirror\";i:1;s:12:\"displayLabel\";i:0;}','16','1');
INSERT INTO `excms_models_fields` VALUES ('76','3','ļ','downfilename','ļ','8','0','1','','1','1','1','1','a:5:{s:5:\"width\";N;s:8:\"validate\";s:0:\"\";s:9:\"regexText\";s:0:\"\";s:8:\"filetype\";s:32:\"zip,rar,doc,docs,xls,ppt,pdf,txt\";s:8:\"filesize\";i:0;}','13','1');
INSERT INTO `excms_models_fields` VALUES ('77','3','زͼ','images','ݲͼ','13','0','1','','1','1','1','1','a:6:{s:5:\"width\";s:4:\"100%\";s:8:\"validate\";s:0:\"\";s:9:\"regexText\";s:0:\"\";s:6:\"height\";i:0;s:12:\"displayLabel\";i:0;s:11:\"displaypage\";i:0;}','50','1');
INSERT INTO `excms_models_fields` VALUES ('80','4','Ƶ','videos','','15','0','1','','1','1','1','1','a:6:{s:5:\"width\";s:4:\"100%\";s:8:\"validate\";s:0:\"\";s:9:\"regexText\";s:0:\"\";s:6:\"height\";i:100;s:12:\"displayLabel\";i:1;s:11:\"displaypage\";i:1;}','50','1');
INSERT INTO `excms_models_fields` VALUES ('81','4','Ƶ','body','','2','0','1','','1','1','1','1','a:7:{s:5:\"width\";s:0:\"\";s:8:\"validate\";s:0:\"\";s:9:\"regexText\";s:0:\"\";s:9:\"maxlength\";i:0;s:6:\"height\";i:0;s:11:\"addonoption\";a:2:{i:0;s:10:\"deletelink\";i:1;s:14:\"remotedownload\";}s:12:\"displayLabel\";i:0;}','50','1');

DROP TABLE IF EXISTS `excms_modules`;
CREATE TABLE `excms_modules` (
  `moduleid` varchar(20) NOT NULL DEFAULT '',
  `name` varchar(20) NOT NULL DEFAULT '',
  `path` varchar(50) NOT NULL DEFAULT '',
  `url` varchar(50) NOT NULL DEFAULT '',
  `issystem` tinyint(1) NOT NULL DEFAULT '0',
  `version` varchar(50) DEFAULT '',
  `author` varchar(50) DEFAULT '',
  `site` varchar(100) DEFAULT '',
  `email` varchar(50) DEFAULT '',
  `description` mediumtext,
  `license` mediumtext,
  `help` mediumtext,
  `sort` int(11) DEFAULT '0',
  `disabled` tinyint(1) DEFAULT '0',
  `isdisplaytop` tinyint(1) DEFAULT '0',
  `publishdate` int(11) DEFAULT NULL,
  `installdate` int(11) DEFAULT NULL,
  `updatedate` int(11) DEFAULT NULL,
  PRIMARY KEY (`moduleid`)
) ENGINE=MyISAM AUTO_INCREMENT=1001 DEFAULT CHARSET=gbk;

INSERT INTO `excms_modules` VALUES ('search','','','','1','1.0','EXCMS Team','www.excms.cn','service@excms.cn','ģ','','','0','1','1','1248160817','1248160817','1248160817');
INSERT INTO `excms_modules` VALUES ('comment','','','','1','1.0','EXCMS Team','www.excms.cn','service@excms.cn','ģ','','','0','1','1','1248160780','1248160780','1248160780');
INSERT INTO `excms_modules` VALUES ('digg','Digg','','','1','1.0','EXCMS Team','www.excms.cn','service@excms.cn','Diggģ','','','0','1','1','1248160827','1248160827','1248160827');
INSERT INTO `excms_modules` VALUES ('click','','','','1','1.0','EXCMS Team','www.excms.cn','service@excms.cn','ģ','','','0','1','1','1248160859','1248160859','1248160859');
INSERT INTO `excms_modules` VALUES ('download','','','','1','1.0','EXCMS Team','www.excms.cn','service@excms.cn','ͳģ','','','0','1','1','1248160859','1248160859','1248160859');
INSERT INTO `excms_modules` VALUES ('link','','','','1','1.0','EXCMS Team','www.excms.cn','service@excms.cn','ģ','','','0','1','1','1248160859','1248160859','1248160859');
INSERT INTO `excms_modules` VALUES ('mood','','','','1','1.0','EXCMS Team','www.excms.cn','service@excms.cn','ģ','','','0','1','1','1248160859','1248160859','1248160859');
INSERT INTO `excms_modules` VALUES ('account','û','','','1','1.0','EXCMS Team','www.excms.cn','service@excms.cn','ûģ','','','0','1','1','1248160859','1248160859','1248160859');

DROP TABLE IF EXISTS `excms_modules_action`;
CREATE TABLE `excms_modules_action` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `actionname` varchar(50) DEFAULT NULL,
  `module` varchar(20) DEFAULT NULL,
  `class` varchar(20) DEFAULT NULL,
  `action` varchar(20) DEFAULT NULL,
  `params` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=1001 DEFAULT CHARSET=gbk;

DROP TABLE IF EXISTS `excms_mood`;
CREATE TABLE `excms_mood` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `gid` int(11) NOT NULL,
  `name` char(50) DEFAULT NULL,
  `image` char(100) DEFAULT NULL,
  `color` char(100) DEFAULT NULL,
  `status` tinyint(1) DEFAULT NULL,
  `createddate` int(11) DEFAULT NULL,
  `sort` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=1001 DEFAULT CHARSET=gbk;

INSERT INTO `excms_mood` VALUES ('1','1','','resource:1001','','1','1269498203','1');
INSERT INTO `excms_mood` VALUES ('2','1','֧','resource:1002','','1','1269499242','2');
INSERT INTO `excms_mood` VALUES ('3','1','Ƿ','resource:1003','','1','1269574339','3');
INSERT INTO `excms_mood` VALUES ('4','1','Ц','resource:1004','','1','1269574349','4');
INSERT INTO `excms_mood` VALUES ('5','1','','resource:1005','','1','1269574366','5');
INSERT INTO `excms_mood` VALUES ('6','1','','resource:1006','','1','1269574382','6');
INSERT INTO `excms_mood` VALUES ('7','1','ͷ','resource:1007','','1','1269574382','7');
INSERT INTO `excms_mood` VALUES ('8','1','','resource:1008','','1','1269574382','8');
INSERT INTO `excms_mood` VALUES ('9','1','','resource:1009','','1','1269574382','9');
INSERT INTO `excms_mood` VALUES ('10','1','','resource:1010','','1','1271063326','10');
INSERT INTO `excms_mood` VALUES ('11','2','','resource:901','','1','1292410758','100');
INSERT INTO `excms_mood` VALUES ('12','2','ѹ','resource:902','','1','1292410770','100');
INSERT INTO `excms_mood` VALUES ('13','2','ж','resource:903','','1','1292410776','100');
INSERT INTO `excms_mood` VALUES ('14','2','ŭ','resource:904','','1','1292410784','100');
INSERT INTO `excms_mood` VALUES ('15','2','Ц','resource:905','','1','1292410794','100');
INSERT INTO `excms_mood` VALUES ('16','2','','resource:906','','1','1292410802','100');

DROP TABLE IF EXISTS `excms_mood_click`;
CREATE TABLE `excms_mood_click` (
  `itemid` int(11) NOT NULL,
  `typeid` tinyint(2) NOT NULL,
  `moodid` int(11) NOT NULL,
  `total` int(11) DEFAULT NULL,
  `day` int(11) DEFAULT NULL,
  `week` int(11) DEFAULT NULL,
  `month` int(11) DEFAULT NULL,
  `year` int(11) DEFAULT NULL,
  `updatetime` int(11) DEFAULT NULL,
  PRIMARY KEY (`itemid`,`typeid`,`moodid`)
) ENGINE=MyISAM DEFAULT CHARSET=gbk;


DROP TABLE IF EXISTS `excms_mood_group`;
CREATE TABLE `excms_mood_group` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` char(50) NOT NULL,
  `description` text,
  `enable` tinyint(1) DEFAULT '1',
  `sort` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=1001 DEFAULT CHARSET=gbk;

INSERT INTO `excms_mood_group` VALUES ('1','Ĭ','Ĭϵ飬ʹPOPOͼ','1','1');
INSERT INTO `excms_mood_group` VALUES ('2','','','1','2');

DROP TABLE IF EXISTS `excms_mood_log`;
CREATE TABLE `excms_mood_log` (
  `itemid` int(11) unsigned DEFAULT NULL,
  `typeid` int(11) unsigned DEFAULT NULL,
  `moodid` int(11) unsigned DEFAULT NULL,
  `uid` int(11) unsigned DEFAULT NULL,
  `username` char(20) DEFAULT NULL,
  `ip` char(15) DEFAULT NULL,
  `date` int(11) unsigned DEFAULT NULL,
  KEY `type_item` (`typeid`,`itemid`,`moodid`,`date`),
  KEY `uid` (`uid`,`typeid`,`itemid`),
  KEY `ip` (`ip`,`typeid`,`itemid`)
) ENGINE=MyISAM DEFAULT CHARSET=gbk;


DROP TABLE IF EXISTS `excms_plugins`;
CREATE TABLE `excms_plugins` (
  `pluginid` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) DEFAULT NULL,
  `cnname` varchar(50) DEFAULT NULL,
  `path` varchar(50) DEFAULT NULL,
  `isdisplaytop` tinyint(1) DEFAULT NULL,
  `status` tinyint(1) DEFAULT '0',
  `author` varchar(50) DEFAULT NULL,
  `link` varchar(100) DEFAULT NULL,
  `version` varchar(50) DEFAULT NULL,
  `license` text,
  `help` text,
  `sort` int(5) DEFAULT '100',
  PRIMARY KEY (`pluginid`)
) ENGINE=MyISAM AUTO_INCREMENT=1001 DEFAULT CHARSET=gbk;

INSERT INTO `excms_plugins` VALUES ('1','IPquery','IPַѯ','/Ipquery','1','1','EXCMS Team','www.excms.cn','1.0','','','100');

DROP TABLE IF EXISTS `excms_publishing_point`;
CREATE TABLE `excms_publishing_point` (
  `id` smallint(5) NOT NULL AUTO_INCREMENT,
  `name` char(20) NOT NULL,
  `url` varchar(100) DEFAULT NULL,
  `type` tinyint(1) unsigned DEFAULT '0',
  `path` varchar(100) DEFAULT NULL,
  `sync` tinyint(4) unsigned DEFAULT '1',
  `server` varchar(50) DEFAULT NULL,
  `port` smallint(5) unsigned DEFAULT '21',
  `username` varchar(50) DEFAULT NULL,
  `password` varchar(50) DEFAULT NULL,
  `remotepath` varchar(100) DEFAULT NULL,
  `pasv` tinyint(1) unsigned DEFAULT '0',
  `ssl` tinyint(1) unsigned DEFAULT '0',
  `comment` varchar(40) DEFAULT NULL,
  `issystem` tinyint(1) DEFAULT '0',
  `sort` tinyint(1) unsigned DEFAULT '100',
  PRIMARY KEY (`id`),
  KEY `name` (`name`)
) ENGINE=MyISAM AUTO_INCREMENT=1001 DEFAULT CHARSET=gbk;

INSERT INTO `excms_publishing_point` VALUES ('1','Ŀ¼','http://excms','0','','0','','21','','','','0','0','վĿ¼','1','100');
INSERT INTO `excms_publishing_point` VALUES ('2','HTML','http://excms/html','0','./html','0','','21','','','/','0','0','HTMLλ','1','100');

DROP TABLE IF EXISTS `excms_resource`;
CREATE TABLE `excms_resource` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `tid` smallint(2) NOT NULL,
  `nid` smallint(2) NOT NULL,
  `fid` int(11) DEFAULT NULL,
  `filename` char(40) DEFAULT NULL,
  `filetype` char(10) DEFAULT NULL,
  `path` varchar(100) DEFAULT NULL,
  `description` varchar(200) DEFAULT NULL,
  `attributes` varchar(250) DEFAULT NULL,
  `filesize` int(11) DEFAULT '0',
  `createddate` int(11) DEFAULT NULL,
  `thumb` varchar(200) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2001 DEFAULT CHARSET=gbk;

INSERT INTO `excms_resource` VALUES ('901','1','4','2','i01.gif','GIF','face','','','806','1292410383','t');
INSERT INTO `excms_resource` VALUES ('902','1','4','2','i02.gif','GIF','face','ѹ','','806','1292410441','t');
INSERT INTO `excms_resource` VALUES ('903','1','4','2','i03.gif','GIF','face','ж','','863','1292410515','t');
INSERT INTO `excms_resource` VALUES ('904','1','4','2','i04.gif','GIF','face','ŭ','','829','1292410515','t');
INSERT INTO `excms_resource` VALUES ('905','1','4','2','i05.gif','GIF','face','Ц','','893','1292410515','t');
INSERT INTO `excms_resource` VALUES ('906','1','4','2','i06.gif','GIF','face','','','801','1292410516','t');
INSERT INTO `excms_resource` VALUES ('1001','1','4','1','gaoxing.gif','GIF','default','','','1922','1275268823','t');
INSERT INTO `excms_resource` VALUES ('1002','1','4','1','zhichi.gif','GIF','default','֧','','2108','1275268824','t');
INSERT INTO `excms_resource` VALUES ('1003','1','4','1','qiebian.gif','GIF','default','Ƿ','','1942','1275268824','t');
INSERT INTO `excms_resource` VALUES ('1004','1','4','1','gaoxiao.gif','GIF','default','Ц','','1965','1275268825','t');
INSERT INTO `excms_resource` VALUES ('1005','1','4','1','chedan.gif','GIF','default','','','1928','1275268826','t');
INSERT INTO `excms_resource` VALUES ('1006','1','4','1','bujie.gif','GIF','default','','','2015','1275268827','t');
INSERT INTO `excms_resource` VALUES ('1007','1','4','1','touyun.gif','GIF','default','ͷ','','2006','1275268827','t');
INSERT INTO `excms_resource` VALUES ('1008','1','4','1','wuliao.gif','GIF','default','','','1898','1275268828','t');
INSERT INTO `excms_resource` VALUES ('1009','1','4','1','zhenjing.gif','GIF','default','','','1940','1275268829','t');
INSERT INTO `excms_resource` VALUES ('1010','1','4','1','huangyan.gif','GIF','default','','','1899','1275268830','t');

DROP TABLE IF EXISTS `excms_resource_bound`;
CREATE TABLE `excms_resource_bound` (
  `itemid` int(11) NOT NULL,
  `type` tinyint(1) NOT NULL,
  `rnid` int(11) NOT NULL,
  `tid` int(11) DEFAULT NULL,
  `topchannel` int(11) DEFAULT '0',
  `binding` tinyint(1) DEFAULT NULL,
  `default` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`itemid`,`type`,`rnid`)
) ENGINE=MyISAM DEFAULT CHARSET=gbk;


DROP TABLE IF EXISTS `excms_resource_default`;
CREATE TABLE `excms_resource_default` (
  `id` int(5) unsigned NOT NULL AUTO_INCREMENT,
  `pid` int(5) unsigned DEFAULT '0',
  `filed` varchar(20) DEFAULT NULL,
  `fieldname` varchar(20) DEFAULT NULL,
  `editor` int(5) unsigned DEFAULT NULL,
  `type` tinyint(1) unsigned DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  `hiddenvalue` varchar(50) DEFAULT NULL,
  `height` int(11) unsigned DEFAULT NULL,
  `width` int(11) unsigned DEFAULT NULL,
  `isdefault` tinyint(1) unsigned DEFAULT NULL,
  `sort` int(5) unsigned DEFAULT NULL,
  `tips` text,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=1001 DEFAULT CHARSET=gbk;

INSERT INTO `excms_resource_default` VALUES ('1','0','path','Դ·','1','1','./resource','./resource','','','1','0','EXCMSװĿ¼·ʹþ·ĬΪ resource Ŀ¼');
INSERT INTO `excms_resource_default` VALUES ('2','0','pathrule','ļ','1','4','{Y}/{M}','','','','0','0','ֱ֧<span style=\"color:#15428B;font-weight:bold\">{Y}</span>4λݡ<span style=\"color:#15428B;font-weight:bold\">{y}</span>2λݡ<span style=\"color:#15428B;font-weight:bold\">{M}</span>ǰ0·ݡ<span style=\"color:#15428B;font-weight:bold\">{m}</span>ǰ0·ݡ<span style=\"color:#15428B;font-weight:bold\">{D}</span>ǰ0졢<span style=\"color:#15428B;font-weight:bold\">{d}</span>ǰ0졢<span style=\"color:#15428B;font-weight:bold\">{H}</span>24СʱСʱ<span style=\"color:#15428B;font-weight:bold\">{i}</span><span style=\"color:#15428B;font-weight:bold\">{s}</span><span style=\"color:#15428B;font-weight:bold\">{UT}</span>UNINXʱ<span style=\"color:#15428B;font-weight:bold\">{R}</span>[0-9a-z]2-16λַ');
INSERT INTO `excms_resource_default` VALUES ('3','0','filerule','ļ','1','4','{Y}{M}{D}{R4}','','','','1','0','ֱ֧<span style=\"color:#15428B;font-weight:bold\">{topchannelaliase}</span>Ŀ<span style=\"color:#15428B;font-weight:bold\">{channelaliase}</span>ǰĿ<span style=\"color:#15428B;font-weight:bold\">{filetype}</span>ļ͡<span style=\"color:#15428B;font-weight:bold\">{Y}</span>4λݡ<span style=\"color:#15428B;font-weight:bold\">{y}</span>2λݡ<span style=\"color:#15428B;font-weight:bold\">{M}</span>ǰ0·ݡ<span style=\"color:#15428B;font-weight:bold\">{m}</span>ǰ0·ݡ<span style=\"color:#15428B;font-weight:bold\">{D}</span>ǰ0졢<span style=\"color:#15428B;font-weight:bold\">{d}</span>ǰ0');
INSERT INTO `excms_resource_default` VALUES ('4','0','status','ԴѡԴ','1','6','1','','','','1','0','');
INSERT INTO `excms_resource_default` VALUES ('5','0','sort','','1','3','50','','','','1','0','');
INSERT INTO `excms_resource_default` VALUES ('6','0','filetype','ϴļ','4','1','jpg,png,gif,bmp','','','','1','0','ϴļͣʹöŸ,磺jpg,png,gif,bmpΪʱϴļ');
INSERT INTO `excms_resource_default` VALUES ('7','0','size','ϴļС','4','3','1024','','','','1','0','ϴļСֵʱջΪ0λΪKB');
INSERT INTO `excms_resource_default` VALUES ('8','0','code','ô','4','2','<img src=\'{filename}\' />','','','','1','0','ñǩ{filename}ļ{description}');
INSERT INTO `excms_resource_default` VALUES ('9','0','image','ͼƬ','4','2','','','','','1','0','');
INSERT INTO `excms_resource_default` VALUES ('10','0','filetype','ϴļ','5','1','zip,rar,doc,docs,xls,ppt,pdf,txt','','','','1','0','ϴļͣʹöŸ,磺jpg,png,gif,bmpΪʱϴļ');
INSERT INTO `excms_resource_default` VALUES ('11','0','code','ϴļС','5','3','1024','','','','1','0','ϴļСֵʱջΪ0λΪKB');
INSERT INTO `excms_resource_default` VALUES ('12','0','image','ô','5','2','<a href=\"{filename}\" target=\"_blank\">{description}</a>','','','','1','0','ñǩ{filename}ļ{description}');
INSERT INTO `excms_resource_default` VALUES ('13','0','name','','3','8','thumb(ͼ)','','','','1','0','ͼƬ');
INSERT INTO `excms_resource_default` VALUES ('14','0','zoom','','3','5','ӦڿȺ͸߶','','','','1','0','');
INSERT INTO `excms_resource_default` VALUES ('15','0','width','߶','3','3','560','','','','1','0','ͼƬȣλpx');
INSERT INTO `excms_resource_default` VALUES ('16','0','height','','3','3','480','','','','1','0','ͼƬ߶ȣλpx');
INSERT INTO `excms_resource_default` VALUES ('17','0','wmtype','ˮӡ','3','5','','','','','1','0','ͼƬˮӡͣͼƬˮӡˮӡˮӡ');
INSERT INTO `excms_resource_default` VALUES ('18','0','pos','ˮӡλ','3','7','[5,8,9]','','','','1','0','');
INSERT INTO `excms_resource_default` VALUES ('19','0','text','','3','1','www.excms.cn','','','','1','0','ˮӡ');
INSERT INTO `excms_resource_default` VALUES ('20','0','font','','3','5','verdana.ttf','','','','1','0','ˮӡ');
INSERT INTO `excms_resource_default` VALUES ('21','0','size','ֺ','3','4','10','','','','1','0','ˮӡС');
INSERT INTO `excms_resource_default` VALUES ('22','0','color','ɫ','3','1','#FFFFFF','','','','1','0','ˮӡɫֵ(: #FFFFFF)');
INSERT INTO `excms_resource_default` VALUES ('23','0','pic','ˮӡͼƬ','3','1','','','','','1','0','ˮӡͼƬ·EXCMSװĿ¼·ʹþ·');
INSERT INTO `excms_resource_default` VALUES ('24','0','rotate','ת','3','3','0','','','','1','0','ˮӡת');
INSERT INTO `excms_resource_default` VALUES ('25','0','opacity','͸','3','3','50','','','','1','0','ˮӡ͸(%)ȡֵ1~100');
INSERT INTO `excms_resource_default` VALUES ('26','2','','','1','','{Y}/{M}','','','','1','5','');
INSERT INTO `excms_resource_default` VALUES ('28','2','','','1','','{topchannelaliase}/{Y}/{M}','','','','0','50','');
INSERT INTO `excms_resource_default` VALUES ('29','2','','','1','','{channelaliase}/{Y}/{M}','','','','0','50','');
INSERT INTO `excms_resource_default` VALUES ('30','2','','','1','','{filetype}/{Y}/{M}','','','','0','50','');
INSERT INTO `excms_resource_default` VALUES ('31','3','','','1','','{Y}{M}{D}{R4}','','','','1','50','');
INSERT INTO `excms_resource_default` VALUES ('32','3','','','1','','{y}{m}{d}{R4}','','','','0','50','');
INSERT INTO `excms_resource_default` VALUES ('33','3','','','1','','{Y}{M}{D}{H}{i}{s}{R4}','','','','0','50','');
INSERT INTO `excms_resource_default` VALUES ('34','3','','','1','','{y}{m}{d}{h}{i}{s}{R4}','','','','0','50','');
INSERT INTO `excms_resource_default` VALUES ('35','3','','','1','','{UT}{R4}','','','','0','50','');
INSERT INTO `excms_resource_default` VALUES ('36','3','','','1','','{RN10}','','','','0','50','');
INSERT INTO `excms_resource_default` VALUES ('37','13','','','3','','thumb(ͼ)','','90','120','1','50','');
INSERT INTO `excms_resource_default` VALUES ('38','13','','','3','','smallslide(Сõͼ)','','200','274','0','50','');
INSERT INTO `excms_resource_default` VALUES ('39','13','','','3','','largeslide(õͼ)','','240','376','0','50','');
INSERT INTO `excms_resource_default` VALUES ('40','13','','','3','','medium(еͼ)','','480','560','0','50','');
INSERT INTO `excms_resource_default` VALUES ('41','13','','','3','','large(ͼ)','','','','0','50','');
INSERT INTO `excms_resource_default` VALUES ('42','13','','','3','','original(ԭͼ)','','','','0','50','');
INSERT INTO `excms_resource_default` VALUES ('43','14','','','3','','ӦڿȺ͸߶','','','','1','50','');
INSERT INTO `excms_resource_default` VALUES ('44','14','','','3','','Ӧ','','','','0','50','');
INSERT INTO `excms_resource_default` VALUES ('45','14','','','3','','Ӧ߶','','','','0','50','');
INSERT INTO `excms_resource_default` VALUES ('46','14','','','3','','̶Ⱥ͸߶','','','','0','50','');
INSERT INTO `excms_resource_default` VALUES ('47','14','','','3','','','','','','0','50','');
INSERT INTO `excms_resource_default` VALUES ('48','17','','','3','','','','','','1','50','');
INSERT INTO `excms_resource_default` VALUES ('49','17','','','3','','ͼƬ','','','','0','50','');
INSERT INTO `excms_resource_default` VALUES ('50','17','','','3','','','','','','0','50','');
INSERT INTO `excms_resource_default` VALUES ('51','21','','','3','','10','','','','1','50','');
INSERT INTO `excms_resource_default` VALUES ('52','21','','','3','','11','','','','0','50','');
INSERT INTO `excms_resource_default` VALUES ('53','21','','','3','','12','','','','0','50','');
INSERT INTO `excms_resource_default` VALUES ('54','21','','','3','','13','','','','0','50','');
INSERT INTO `excms_resource_default` VALUES ('55','21','','','3','','14','','','','0','50','');
INSERT INTO `excms_resource_default` VALUES ('56','21','','','3','','15','','','','0','50','');
INSERT INTO `excms_resource_default` VALUES ('57','21','','','3','','16','','','','0','50','');
INSERT INTO `excms_resource_default` VALUES ('58','21','','','3','','17','','','','0','50','');
INSERT INTO `excms_resource_default` VALUES ('59','21','','','3','','18','','','','0','50','');
INSERT INTO `excms_resource_default` VALUES ('60','21','','','3','','19','','','','0','50','');
INSERT INTO `excms_resource_default` VALUES ('61','21','','','3','','20','','','','0','50','');
INSERT INTO `excms_resource_default` VALUES ('62','21','','','3','','21','','','','0','50','');
INSERT INTO `excms_resource_default` VALUES ('63','21','','','3','','22','','','','0','50','');
INSERT INTO `excms_resource_default` VALUES ('64','21','','','3','','23','','','','0','50','');
INSERT INTO `excms_resource_default` VALUES ('65','21','','','3','','24','','','','0','50','');
INSERT INTO `excms_resource_default` VALUES ('66','21','','','3','','25','','','','0','50','');
INSERT INTO `excms_resource_default` VALUES ('67','21','','','3','','26','','','','0','50','');
INSERT INTO `excms_resource_default` VALUES ('68','21','','','3','','27','','','','0','50','');
INSERT INTO `excms_resource_default` VALUES ('69','21','','','3','','28','','','','0','50','');
INSERT INTO `excms_resource_default` VALUES ('70','21','','','3','','29','','','','0','50','');
INSERT INTO `excms_resource_default` VALUES ('71','21','','','3','','30','','','','0','50','');
INSERT INTO `excms_resource_default` VALUES ('72','21','','','3','','31','','','','0','50','');
INSERT INTO `excms_resource_default` VALUES ('73','21','','','3','','32','','','','0','50','');
INSERT INTO `excms_resource_default` VALUES ('76','20','','','3','','verdana.ttf','','','','1','50','');

DROP TABLE IF EXISTS `excms_resource_folder`;
CREATE TABLE `excms_resource_folder` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `pid` int(11) DEFAULT NULL,
  `tid` smallint(2) DEFAULT NULL,
  `nid` smallint(2) DEFAULT NULL,
  `name` varchar(40) DEFAULT NULL,
  `path` varchar(100) DEFAULT NULL,
  `files` int(11) DEFAULT '0',
  `folders` int(11) DEFAULT '0',
  `createddate` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=1001 DEFAULT CHARSET=gbk;

INSERT INTO `excms_resource_folder` VALUES('1','0','1','4','default','/','10','0','1294658676');
INSERT INTO `excms_resource_folder` VALUES('2','0','1','4','face','/','6','0','1294658676');

DROP TABLE IF EXISTS `excms_resource_node`;
CREATE TABLE `excms_resource_node` (
  `nid` smallint(2) NOT NULL AUTO_INCREMENT,
  `tid` smallint(2) NOT NULL,
  `alias` char(20) NOT NULL,
  `name` char(20) DEFAULT NULL,
  `description` varchar(200) DEFAULT NULL,
  `path` varchar(100) DEFAULT NULL,
  `url` varchar(100) DEFAULT NULL,
  `pathrule` varchar(100) DEFAULT NULL,
  `filerule` varchar(100) DEFAULT NULL,
  `isremote` tinyint(1) DEFAULT '0',
  `interface` text,
  `default` tinyint(1) DEFAULT '1',
  `status` tinyint(1) DEFAULT '1',
  `files` mediumint(6) DEFAULT '0',
  `folders` mediumint(6) DEFAULT '0',
  `size` int(11) DEFAULT '0',
  `sort` smallint(2) DEFAULT NULL,
  `config` text,
  `issystem` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`nid`,`alias`)
) ENGINE=MyISAM AUTO_INCREMENT=1001 DEFAULT CHARSET=gbk;

INSERT INTO `excms_resource_node` VALUES ('1','1','image','ͼƬԴ','','./sitedata/resource/images','','{Y}{M}','{Y}{M}{D}{H}{i}{s}','0','','1','1','372','16','0','50','{\"type\":\"image\",\"filetype\":\"jpg,jpeg,png,gif,bmp\",\"size\":\"\",\"code\":\"\",\"image\":{\"t\":{\"zoom\":\"0\",\"width\":\"120\",\"height\":\"90\",\"wmtype\":\"0\"},\"o\":{\"zoom\":\"4\",\"wmtype\":\"0\"},\"m\":{\"zoom\":\"0\",\"width\":\"600\",\"height\":\"210\",\"wmtype\":\"0\"}}}','1');
INSERT INTO `excms_resource_node` VALUES ('2','2','file','Դ','','./sitedata/resource/files','','{Y}{M}','{Y}{M}{D}{H}{i}{s}{R4}','0','','1','1','10','6','0','50','{\"type\":\"file\",\"filetype\":\"zip,rar,doc,docs,xls,ppt,pdf,txt\",\"size\":\"10240\",\"code\":\"<a href=\'{filename}\' target=\'_blank\'>{description}</a>\"}','1');
INSERT INTO `excms_resource_node` VALUES ('3','1','linklogo','LOGO','','./sitedata/resource/linklogos','','','','0','','0','1','3','0','0','50','{\"type\":\"image\",\"filetype\":\"jpg,jpeg,png,gif,bmp\",\"size\":\"\",\"code\":\"\",\"image\":{\"t\":{\"zoom\":\"3\",\"width\":\"88\",\"height\":\"31\",\"wmtype\":\"0\"}}}','1');
INSERT INTO `excms_resource_node` VALUES ('4','1','mood','ͼ','','./mood/emoticons','','','','0','','0','1','16','0','0','50','{\"type\":\"image\",\"filetype\":\"jpg,jpeg,png,gif,bmp\",\"size\":\"\",\"code\":\"\",\"image\":{\"t\":{\"zoom\":\"4\",\"wmtype\":\"0\"}}}','1');
INSERT INTO `excms_resource_node` VALUES ('5','1','uimage','ûͼƬԴ','ڱûͶеͼƬԴ','./sitedata/resource/u','','{unumber}/{Y}{M}','{Y}{M}{D}{H}{i}{s}{R4}','0','','0','1','38','26','0','50','{\"type\":\"image\",\"filetype\":\"jpg,jpeg,png,gif,bmp\",\"size\":\"\",\"code\":\"\",\"image\":{\"t\":{\"zoom\":\"0\",\"width\":\"120\",\"height\":\"90\",\"wmtype\":\"0\"}}}','1');
INSERT INTO `excms_resource_node` VALUES ('6','3','video','ƵԴ','','./sitedata/resource/video','','{Y}/{M}','{Y}{M}{D}{R4}','0','','1','1','1','3','0','50','{\"type\":\"video\",\"filetype\":\"mov,flv,3gp,avi,mp4\",\"size\":\"102400\",\"code\":\"\"}','1');

DROP TABLE IF EXISTS `excms_resource_type`;
CREATE TABLE `excms_resource_type` (
  `tid` smallint(2) NOT NULL AUTO_INCREMENT,
  `name` char(20) NOT NULL,
  `cname` char(20) DEFAULT NULL,
  `description` varchar(200) DEFAULT NULL,
  `config` text,
  `sort` smallint(6) DEFAULT '50',
  PRIMARY KEY (`tid`,`name`),
  UNIQUE KEY `tid` (`tid`)
) ENGINE=MyISAM AUTO_INCREMENT=1001 DEFAULT CHARSET=gbk;

INSERT INTO `excms_resource_type` VALUES ('1','image','ͼƬ','ͼƬԴ','','50');
INSERT INTO `excms_resource_type` VALUES ('2','file','ļ','ͨļԴ','','50');
INSERT INTO `excms_resource_type` VALUES ('3','video','Ƶ','Ƶ','','50');

DROP TABLE IF EXISTS `excms_resoure_user_node`;
CREATE TABLE `excms_resoure_user_node` (
  `nodeid` int(11) NOT NULL,
  `adminid` int(11) NOT NULL,
  `updatetime` int(11) DEFAULT NULL,
  PRIMARY KEY (`nodeid`,`adminid`)
) ENGINE=MyISAM DEFAULT CHARSET=gbk;


DROP TABLE IF EXISTS `excms_search_category`;
CREATE TABLE `excms_search_category` (
  `id` smallint(4) unsigned NOT NULL AUTO_INCREMENT,
  `name` char(20) DEFAULT NULL,
  `modelid` smallint(2) unsigned DEFAULT NULL,
  `channelids` text,
  `description` varchar(250) DEFAULT NULL,
  `pagemaxnumber` tinyint(2) unsigned DEFAULT '10',
  `maxrecord` smallint(4) unsigned DEFAULT '1000',
  `default` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `status` tinyint(1) unsigned DEFAULT '1',
  `template` varchar(100) DEFAULT NULL,
  `sort` tinyint(2) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=1001 DEFAULT CHARSET=gbk;

INSERT INTO `excms_search_category` VALUES ('1','Ѷ','1','','','10','1000','0','1','search.html','1');
INSERT INTO `excms_search_category` VALUES ('2','ͼƬ','2','','','10','1800','0','1','search_image.html','2');
INSERT INTO `excms_search_category` VALUES ('3','','3','','','10','1000','0','1','search_download.html','3');
INSERT INTO `excms_search_category` VALUES ('4','Ƶ','4','','','10','1000','0','1','search.html','4');
INSERT INTO `excms_search_category` VALUES ('5','ȫվ','','','','10','1000','1','1','search.html','0');

DROP TABLE IF EXISTS `excms_search_field`;
CREATE TABLE `excms_search_field` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `name` char(50) DEFAULT NULL,
  `search_table` char(50) DEFAULT NULL,
  `search_field` char(50) DEFAULT NULL,
  `search_key` char(50) DEFAULT NULL,
  `join_table` char(50) DEFAULT NULL,
  `join_key` char(50) DEFAULT NULL,
  `enable` tinyint(1) DEFAULT '1',
  `cid` int(11) DEFAULT NULL,
  `type` tinyint(1) DEFAULT NULL,
  `value` int(11) DEFAULT NULL,
  `sort` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=gbk;


DROP TABLE IF EXISTS `excms_search_keywords`;
CREATE TABLE `excms_search_keywords` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `keywords` varchar(128) NOT NULL DEFAULT '',
  `asciisplitwords` varchar(500) DEFAULT NULL,
  `splitwords` varchar(256) NOT NULL,
  `type` int(5) unsigned DEFAULT '0',
  `frequency` int(11) unsigned DEFAULT NULL,
  `count` int(11) unsigned NOT NULL DEFAULT '0',
  `hot` tinyint(1) unsigned DEFAULT '0',
  `createddate` int(11) unsigned DEFAULT NULL,
  `modifieddate` int(11) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  FULLTEXT KEY `asciisplitwords` (`asciisplitwords`)
) ENGINE=MyISAM DEFAULT CHARSET=gbk;


DROP TABLE IF EXISTS `excms_search_splitword`;
CREATE TABLE `excms_search_splitword` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `type` tinyint(2) unsigned NOT NULL DEFAULT '0',
  `modelid` smallint(2) unsigned DEFAULT NULL,
  `contentid` int(8) unsigned DEFAULT NULL,
  `channelid` mediumint(5) unsigned DEFAULT NULL,
  `data` text,
  `checked` tinyint(1) unsigned DEFAULT '1',
  `modifieddate` int(11) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `contentid_type` (`contentid`,`type`),
  FULLTEXT KEY `data` (`data`)
) ENGINE=MyISAM DEFAULT CHARSET=gbk;


DROP TABLE IF EXISTS `excms_system_config`;
CREATE TABLE `excms_system_config` (
  `id` int(5) unsigned NOT NULL AUTO_INCREMENT,
  `moduleid` varchar(20) DEFAULT NULL,
  `name` varchar(30) DEFAULT NULL,
  `value` varchar(200) DEFAULT NULL,
  `description` varchar(200) DEFAULT NULL,
  `group` varchar(20) DEFAULT NULL,
  `type` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `issystem` tinyint(1) unsigned DEFAULT '0',
  `sort` smallint(2) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `module` (`moduleid`,`sort`),
  KEY `group` (`group`,`sort`)
) ENGINE=MyISAM AUTO_INCREMENT=1001 DEFAULT CHARSET=gbk;

INSERT INTO `excms_system_config` VALUES ('1','config','sitename','EXCMS ׿Խݹϵͳ','վ','վ','3','1','100');
INSERT INTO `excms_system_config` VALUES ('2','config','domain','http://excms','վ','վ','3','1','100');
INSERT INTO `excms_system_config` VALUES ('3','config','isclose','0','رվ','վ','1','1','100');
INSERT INTO `excms_system_config` VALUES ('4','config','title','EXCMS ׿Խݹϵͳ','վҳ','վ','3','1','100');
INSERT INTO `excms_system_config` VALUES ('5','config','keywords','EXCMS,׿Խݹϵͳ,ǧݹ,ݹ','վؼ','վ','3','1','100');
INSERT INTO `excms_system_config` VALUES ('6','config','description','EXCMS׿ԽݹϵͳһԻ,ǧ,ٵݹϵͳ','վ','վ','4','1','100');
INSERT INTO `excms_system_config` VALUES ('7','config','multisite','0','/ֶ֧վ㣬󸽼Ŀݵþַ','վ','1','1','100');
INSERT INTO `excms_system_config` VALUES ('8','config','copyright','Ȩ &copy; ()޹˾ All Rrights Reserved.','վȨϢ','վ','3','1','100');
INSERT INTO `excms_system_config` VALUES ('9','config','email','admin@excms.cn','վEMAIL','վ','3','1','100');
INSERT INTO `excms_system_config` VALUES ('10','config','beian','','','վ','3','1','100');
INSERT INTO `excms_system_config` VALUES ('11','config','statcode','','ͳƴ','վ','3','1','100');
INSERT INTO `excms_system_config` VALUES ('12','config','cli_time','+8','ʱ(Ĭ+8)','','3','1','100');
INSERT INTO `excms_system_config` VALUES ('13','config','home_link_txt','ҳ','ҳ','','3','1','100');
INSERT INTO `excms_system_config` VALUES ('14','config','list_symbol','&gt;','Ŀλõļ','','3','1','100');
INSERT INTO `excms_system_config` VALUES ('15','config','list_son','0','ϼбǷ','','1','1','100');
INSERT INTO `excms_system_config` VALUES ('16','config','update_maxpages','100','ĿбʱÿĿ󴴽ҳ','','3','1','100');
INSERT INTO `excms_system_config` VALUES ('17','config','auto_description','140','ԶժҪȣ0-2500ʾã','','3','1','100');
INSERT INTO `excms_system_config` VALUES ('18','config','auto_page','1','ǷԶҳ','','1','1','100');
INSERT INTO `excms_system_config` VALUES ('19','config','dynamic','3','Ƿȫվ̬(1:̬2̬3)','','2','1','100');
INSERT INTO `excms_system_config` VALUES ('20','config','sitelink_protocol','http','վЭ(ɾվʱʹ)Э\',\'ָ','','3','1','100');
INSERT INTO `excms_system_config` VALUES ('21','config','sitelink_domain','*.excms','õΪվ(ɾվʱʹ)\',\'ָ*κ(磺*.excms.cn)','','3','1','100');
INSERT INTO `excms_system_config` VALUES ('22','config','sitepath','./','վĿ¼λ(ΪʱʾEXCMSװĿ¼)ȡֵ·(\"../\"\"./\"ͷֵEXCMSconfiguration·)·','ļĿ¼','3','1','100');
INSERT INTO `excms_system_config` VALUES ('23','config','htmlpath','./html','̬HTMLĬϱ·,վĿ¼(sitepath)','ļĿ¼','3','1','100');
INSERT INTO `excms_system_config` VALUES ('24','config','rootpath','','վĿ¼λ(ΪʱʾEXCMSװĿ¼)\nȡֵ·(\"../\"\"./\"ͷֵEXCMSconfiguration·)·','ļĿ¼','3','1','100');
INSERT INTO `excms_system_config` VALUES ('26','config','rsspath','./rss','rssļ·վĿ¼(sitepath)','ļĿ¼','3','1','100');
INSERT INTO `excms_system_config` VALUES ('27','config','sitemappath','./sitemap','վͼļ·վĿ¼(sitepath)','ļĿ¼','3','1','100');
INSERT INTO `excms_system_config` VALUES ('28','config','login_verifycode','0','Ƿ̨¼֤','ȫ','1','1','100');
INSERT INTO `excms_system_config` VALUES ('29','config','id_code_key','excms','IDĿIDҳʹõĻַؼסַ','ȫ','3','1','100');
INSERT INTO `excms_system_config` VALUES ('30','config','code_channelid','0','ǷĿID̬Ŀʹã','ȫ','1','1','100');
INSERT INTO `excms_system_config` VALUES ('31','config','code_contentid','0','ǷID','ȫ','1','1','100');
INSERT INTO `excms_system_config` VALUES ('32','config','code_page','0','Ƿҳ','ȫ','1','1','100');
INSERT INTO `excms_system_config` VALUES ('33','config','template_dir','themes','ģλãվĿ¼(sitepath)','ģ','3','1','100');
INSERT INTO `excms_system_config` VALUES ('34','config','template_name','excellence','ǰʹģ','ģ','3','1','100');
INSERT INTO `excms_system_config` VALUES ('35','config','style_url','./themes/excellence','CSSʽļĿ¼·','ģ','3','1','100');
INSERT INTO `excms_system_config` VALUES ('36','config','js_url','./themes','JSűĿ¼·','ģ','3','1','100');
INSERT INTO `excms_system_config` VALUES ('37','config','index_template','index.html','ҳģ(ҳ̬ʱʹ)','ģ','3','1','100');
INSERT INTO `excms_system_config` VALUES ('38','config','safety_code','','վȫ','ȫ','3','1','100');
INSERT INTO `excms_system_config` VALUES ('58','config','log_filesize','2097152','־ļС','־','3','1','100');
INSERT INTO `excms_system_config` VALUES ('59','config','log_level','EMERG,ALERT,CRIT,ERR,WARN,NOTIC,INFO,SQL','¼־','־','3','1','100');
INSERT INTO `excms_system_config` VALUES ('60','config','log_sqldebug','0','¼SQL䵽־ļ','־','1','1','100');
INSERT INTO `excms_system_config` VALUES ('61','config','log_enable','0','Ƿ־¼','־','1','1','100');
INSERT INTO `excms_system_config` VALUES ('62','config','show_error_msg','1','ǷʾϢ','־','1','1','100');
INSERT INTO `excms_system_config` VALUES ('63','config','error_page','','ҳ','־','3','1','100');
INSERT INTO `excms_system_config` VALUES ('64','config','error_message','ҳʱ˴','ʾϢ ǵģʽЧ','־','3','1','100');
INSERT INTO `excms_system_config` VALUES ('65','config','debug_mode','0','Ƿõģʽ(0:ĬϹر,1:)','־','1','1','100');
INSERT INTO `excms_system_config` VALUES ('66','search','q_date','dt','޶Ҫҳʱ','ģ','3','1','100');
INSERT INTO `excms_system_config` VALUES ('67','search','q_orderby','sort','','ģ','3','1','100');
INSERT INTO `excms_system_config` VALUES ('68','search','q_keywordslocation','kl','ѯؼλ','ģ','3','1','100');
INSERT INTO `excms_system_config` VALUES ('69','search','fulltext','0','ǷȫļúҪ ִʴС','ģ','1','1','100');
INSERT INTO `excms_system_config` VALUES ('70','search','name','','ģ:ǰ̨ʾԶƣ硰ѡѡ','ģ','3','1','100');
INSERT INTO `excms_system_config` VALUES ('71','search','splitsize','0','ִʴС(KB):ĬΪ0Ϊ0ʱݽзִ(ֻеȫʱò)','ģ','2','1','100');
INSERT INTO `excms_system_config` VALUES ('72','search','option','2','Ĭʽ:1=;\n2=;\n3=;\n4=ȫļ.\n(Ĭʹñ)','ģ','2','1','100');
INSERT INTO `excms_system_config` VALUES ('73','search','q_notin','ni','¹ؼ','ģ','3','1','100');
INSERT INTO `excms_system_config` VALUES ('74','search','q_anykeywords','ak','һؼ','ģ','3','1','100');
INSERT INTO `excms_system_config` VALUES ('75','search','q_completekeywords','ck','µؼ','ģ','3','1','100');
INSERT INTO `excms_system_config` VALUES ('76','search','q_allkeywords','all','ȫĹؼ','ģ','3','1','100');
INSERT INTO `excms_system_config` VALUES ('77','search','q_category','c','ǩ','ģ','3','1','100');
INSERT INTO `excms_system_config` VALUES ('78','search','q_pageon','p','ǰҳǩ','ģ','3','1','100');
INSERT INTO `excms_system_config` VALUES ('79','search','q_pagesize','pg','ҳСǩ','ģ','3','1','100');
INSERT INTO `excms_system_config` VALUES ('80','search','q_keywords','q','ؼֱǩ','ģ','3','1','100');
INSERT INTO `excms_system_config` VALUES ('81','search','filterkeywords','','ؼ','ģ','4','1','100');
INSERT INTO `excms_system_config` VALUES ('82','comment','allow_hide_ip','0','ǷIP','ģ','1','1','100');
INSERT INTO `excms_system_config` VALUES ('83','comment','anonymous','1','Ƿ','ģ','1','1','100');
INSERT INTO `excms_system_config` VALUES ('84','comment','verifycode','0','Ƿ֤','ģ','1','1','100');
INSERT INTO `excms_system_config` VALUES ('85','comment','hotlimit','2','ϵͳȵ','ģ','2','1','100');
INSERT INTO `excms_system_config` VALUES ('86','comment','background_img','','ۿ򱳾ͼƬ','ģ','3','1','100');
INSERT INTO `excms_system_config` VALUES ('87','comment','default_words','Ҳۣ','ۿĬ','ģ','3','1','100');
INSERT INTO `excms_system_config` VALUES ('88','comment','allow_guest','1','Ƿοͷ','ģ','1','1','100');
INSERT INTO `excms_system_config` VALUES ('89','comment','check','0','ǷҪ','ģ','1','1','100');
INSERT INTO `excms_system_config` VALUES ('90','comment','allow_hide_position','0','Ƿλ','ģ','1','1','100');
INSERT INTO `excms_system_config` VALUES ('91','comment','show_ip','1','бǷʾIP','ģ','1','1','100');
INSERT INTO `excms_system_config` VALUES ('92','comment','hidefloor','1','бǷͬ¥','ģ','1','1','100');
INSERT INTO `excms_system_config` VALUES ('93','comment','floor_show_num','10','бʾ','ģ','2','1','100');
INSERT INTO `excms_system_config` VALUES ('94','comment','show_position','1','бǷʾλ','ģ','1','1','100');
INSERT INTO `excms_system_config` VALUES ('95','comment','name','','ģ','ģ','3','1','100');
INSERT INTO `excms_system_config` VALUES ('96','download','upload_filetype','rar|zip|exe|doc','ģļϴ','ģ','3','1','100');
INSERT INTO `excms_system_config` VALUES ('97','download','enable_url','0','Ƿֻñصַ','ģ','1','1','100');
INSERT INTO `excms_system_config` VALUES ('98','download','download_way','jump','jumpתsofturlʵʵַ','ģ','3','1','100');
INSERT INTO `excms_system_config` VALUES ('99','download','downloadinfo','Ƽʹʿ쳵رվʹ WinRAR v3.10 ϰ汾ѹվ<br>\nǲص,лл!!<br>\nرվԴݲһʱԣ<br>\nʲô⣬뵽վ̳ȥѰǽṩ õԴ<br>\nվṩһЩҵǹѧϰо֮ãҵ;빺档','˵','ģ','4','1','100');
INSERT INTO `excms_system_config` VALUES ('112','config','code_contentid_method','0','0: ෽ʽU1327198EX.html \n1: 0ȫʽ0000001234.html','ȫ','2','1','100');
INSERT INTO `excms_system_config` VALUES ('113','config','code_contentid_len','10','ID볤ȣ8-16λƼ10λ','ȫ','2','1','100');
INSERT INTO `excms_system_config` VALUES ('116','account','enabled','1','Ƿû','ģ','1','1','100');
INSERT INTO `excms_system_config` VALUES ('117','account','register','1','ûע','ģ','1','1','100');
INSERT INTO `excms_system_config` VALUES ('119','account','register_type','1','ע͡1ûע᣻2ʼַע','ģ','2','1','100');
INSERT INTO `excms_system_config` VALUES ('120','account','email_unique','0','ǷÿEmailֻעһʺ(ʹʼַʽעʱԶЧ)','ģ','1','1','100');
INSERT INTO `excms_system_config` VALUES ('121','account','user_checked','3','ûעῪͨ״̬趨(1:Աֹˣ2:ʼ֤3:ע󼴿ͨ)','ģ','2','1','100');
INSERT INTO `excms_system_config` VALUES ('122','account','register_verifycode','1','ûע֤빦','ģ','1','1','100');
INSERT INTO `excms_system_config` VALUES ('123','account','register_askverify','1','ûעʱʴ֤','ģ','1','1','100');
INSERT INTO `excms_system_config` VALUES ('124','account','default_group','1','ûעĬϻԱ(Աid)','ģ','2','1','100');
INSERT INTO `excms_system_config` VALUES ('125','account','default_experience','0','ûעĬ;','ģ','2','1','100');
INSERT INTO `excms_system_config` VALUES ('126','account','default_credit','0','עûĬϻ','ģ','2','1','100');
INSERT INTO `excms_system_config` VALUES ('127','account','register_license','ûϸĶȫݡûͬⱾݣ벻Ҫעʹñվûͨע򲢹ѡѾĶ ûЭ顱ʾû뱾վѴЭ飬Ըܱݡ˺ûδĶκʽĿ硣','ûעЭ(Эõַ)','ģ','4','1','100');
INSERT INTO `excms_system_config` VALUES ('128','account','preserve_username','','ϵͳû(õûûעᣬ\",\"ָ)','ģ','4','1','100');
INSERT INTO `excms_system_config` VALUES ('130','account','nickname_same','1','Ƿûǳظ','ģ','1','1','100');
INSERT INTO `excms_system_config` VALUES ('131','account','contribute_verifycode','0','ǷûͶ֤','ģ','1','1','100');
INSERT INTO `excms_system_config` VALUES ('132','account','recover_passwd','2','ûʱʹúַʽһ(0:ʹðȫһ;1:ʹһ;2:ʹðȫһ)','ģ','2','1','100');
INSERT INTO `excms_system_config` VALUES ('134','comment','contentpage','1','ϸҳǷʾб','ģ','1','1','100');
INSERT INTO `excms_system_config` VALUES ('135','config','assocwchannel','0','ǷԴĿ','','1','1','100');
INSERT INTO `excms_system_config` VALUES ('136','config','assocwmodel','0','ǷԴģ͹','','1','1','100');
INSERT INTO `excms_system_config` VALUES ('137','digg','enable_log','1','digg־¼¼ûȼ¼','ģ','1','1','100');
INSERT INTO `excms_system_config` VALUES ('138','mood','enable_log','1','־¼¼û¼','ģ','1','1','100');
INSERT INTO `excms_system_config` VALUES ('139','config','contentpath_zeropad_type','2','0 : ID(contentid)ȫʽ;\n1 : ȫվÿcontentpath_zeropad_typeȫ;\n2 : Ŀÿcontentpath_zeropad_typeȫ;','ȫ','2','1','100');
INSERT INTO `excms_system_config` VALUES ('140','config','contentpath_zeropad_start','1','·ȫʼֵ','ȫ','2','1','100');
INSERT INTO `excms_system_config` VALUES ('539','config','mail_protocol','1','ʼͷʽ:\n0: ͨ PHP  sendmail \n1:ͨ SOCKET  SMTP (֧ ESMTP ֤)\n2: ͨ PHP  SMTP  Email( Windows Ч, ֧ ESMTP ֤)','ʼ','2','1','100');
INSERT INTO `excms_system_config` VALUES ('540','config','smtp_host','smtp.163.com',' SMTP ĵַ(mail_protocolΪ12ʱЧ)','ʼ','3','1','100');
INSERT INTO `excms_system_config` VALUES ('541','config','smtp_port','25',' SMTP Ķ˿ڣĬΪ 25(mail_protocolΪ12ʱЧ)','ʼ','3','1','100');
INSERT INTO `excms_system_config` VALUES ('542','config','smtp_user','','SMTP ֤û(mail_protocolΪ1ʱЧ)','ʼ','3','1','100');
INSERT INTO `excms_system_config` VALUES ('543','config','smtp_pass','','SMTP ֤롣(mail_protocolΪ1ʱЧ)','ʼ','3','1','100');
INSERT INTO `excms_system_config` VALUES ('544','config','mail_delimiter','0','ʼͷķָ:\n0:ʹ CRLF Ϊָ(ͨΪ Windows )\n1:ʹ LF Ϊָ(ͨΪ Unix/Linux )\n2:ʹ CR Ϊָ(ͨΪ Mac )\nʼõ˲','ʼ','2','1','100');
INSERT INTO `excms_system_config` VALUES ('545','config','mail_username','1','ռ˵ַа˻:\nѡǡռ˵ʼַаվ˻','ʼ','1','1','100');
INSERT INTO `excms_system_config` VALUES ('546','config','mail_sign','','ʼǩ','ʼ','4','1','100');
INSERT INTO `excms_system_config` VALUES ('547','config','sendmail_silent','1','ʼеȫʾ','ʼ','1','1','100');
INSERT INTO `excms_system_config` VALUES ('548','config','mail_from','username <user@domain.com>','ʼַҪ֤, ΪʼַʼַҪûʽΪusername <user@domain.com>','ʼ','3','1','100');
INSERT INTO `excms_system_config` VALUES ('549','config','mail_auth_from','0','SMTP Ҫ󷢼ʼ֤','ʼ','1','1','100');
INSERT INTO `excms_system_config` VALUES ('555','config','include_method','INCLUDE','SSH|JS|IFRAME|INCLUDE|SSH_FORCE|JS_FORCE|IFRAME_FORCE|INCLUDE_FORCE','','3','1','100');
INSERT INTO `excms_system_config` VALUES ('556','config','htmleditor','kindeditor','HTML༭ѡ༭kindeditor(Ĭֵ), sinaeditor, fckeditor','','3','1','100');
INSERT INTO `excms_system_config` VALUES ('557','click','clickinit','10000,20000','ʼݵ,10000-20000֮','ģ','3','1','100');

DROP TABLE IF EXISTS `excms_table_fields`;
CREATE TABLE `excms_table_fields` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `pid` int(11) DEFAULT NULL,
  `table` varchar(50) DEFAULT NULL,
  `field` varchar(50) DEFAULT NULL,
  `description` varchar(50) DEFAULT NULL,
  `from_table` varchar(50) DEFAULT NULL,
  `from_field` varchar(50) DEFAULT NULL,
  `from_value` varchar(50) DEFAULT NULL,
  `is_table` tinyint(1) DEFAULT NULL,
  `sort` tinyint(5) DEFAULT NULL,
  `is_inuse` tinyint(1) DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=gbk;


DROP TABLE IF EXISTS `excms_tag_index`;
CREATE TABLE `excms_tag_index` (
  `tagid` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `name` char(80) NOT NULL,
  `initial` char(1) DEFAULT NULL,
  `createddate` int(11) unsigned NOT NULL,
  `click` int(11) unsigned NOT NULL DEFAULT '0',
  `contentscount` int(11) unsigned NOT NULL DEFAULT '0',
  `weekcc` int(11) unsigned NOT NULL DEFAULT '0',
  `monthcc` int(11) unsigned NOT NULL DEFAULT '0',
  `weekup` int(11) unsigned NOT NULL DEFAULT '0',
  `monthup` int(11) unsigned NOT NULL DEFAULT '0',
  `color` char(7) NOT NULL DEFAULT '0',
  `size` tinyint(1) unsigned NOT NULL DEFAULT '12',
  `weight` tinyint(10) unsigned NOT NULL DEFAULT '50',
  `category` char(80) NOT NULL DEFAULT '0',
  `recommend` tinyint(10) unsigned NOT NULL DEFAULT '50',
  `italics` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `underline` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `bold` tinyint(1) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`tagid`)
) ENGINE=MyISAM DEFAULT CHARSET=gbk;


DROP TABLE IF EXISTS `excms_tag_list`;
CREATE TABLE `excms_tag_list` (
  `tagid` int(8) NOT NULL,
  `contentid` int(8) NOT NULL,
  `channelid` mediumint(5) DEFAULT NULL,
  `sort` int(6) DEFAULT '100',
  PRIMARY KEY (`tagid`,`contentid`),
  KEY `aid` (`contentid`),
  KEY `cid_aid_tid` (`channelid`,`contentid`,`tagid`)
) ENGINE=MyISAM DEFAULT CHARSET=gbk;


DROP TABLE IF EXISTS `excms_url`;
CREATE TABLE `excms_url` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `moduleid` varchar(20) NOT NULL DEFAULT '',
  `name` varchar(50) NOT NULL DEFAULT '',
  `url` varchar(200) NOT NULL DEFAULT '',
  `enablerewrite` tinyint(1) unsigned DEFAULT '0',
  `rewrite` varchar(200) DEFAULT NULL,
  `description` varchar(200) DEFAULT NULL,
  `issystem` tinyint(1) DEFAULT '0',
  `sort` tinyint(2) DEFAULT '50',
  PRIMARY KEY (`moduleid`,`name`),
  UNIQUE KEY `id` (`id`),
  KEY `sort` (`moduleid`,`sort`)
) ENGINE=MyISAM AUTO_INCREMENT=1001 DEFAULT CHARSET=gbk;

INSERT INTO `excms_url` VALUES ('1','system','index','index.php','1','','ҳ','1','50');
INSERT INTO `excms_url` VALUES ('2','system','channel','channel.php?channelid={channelid}&crossid={crossid}&page={page}','0','channel/{channelid}/{page}.html','Ŀ','1','50');
INSERT INTO `excms_url` VALUES ('3','system','list','list.php?model={model}&type={type}&channelid={channelid}&crossid={crossid}&page={page}','0','list-{channelid}-{model}-{type}-{page}.html','[Ŀ]бmodel: article(£Ĭ)image(ͼƬ)download()type: newest(£Ĭ)head(ͷ)recommend(Ƽ)focus()scroll()txpic(ͼ)','1','50');
INSERT INTO `excms_url` VALUES ('4','system','content','content.php?contentid={contentid}&page={page}','0','content-{contentid}-{page}.html','','1','50');
INSERT INTO `excms_url` VALUES ('5','system','content_action','apps/content.php','0','apps/content','ݶ','1','50');
INSERT INTO `excms_url` VALUES ('6','system','pic','pic.php','0','pic.html','ͼƬ','1','50');
INSERT INTO `excms_url` VALUES ('7','system','video','video.php','0','video.html','Ƶ','1','50');
INSERT INTO `excms_url` VALUES ('8','system','videosrc','apps/video.php?contentid={contentid}|{field}|{page}.xml','0','apps/video-{contentid}|{field}|{page}.xml','Ƶַ','1','50');
INSERT INTO `excms_url` VALUES ('9','system','top','top.php?model={model}&order={order}&channelid={channelid}&crossid={crossid}','0','top-{channelid}-{model}-{order}.html','[Ŀ]аmodel(article:Ĭ,imageͼƬ,download)order(day,week,month,year,all)','1','50');
INSERT INTO `excms_url` VALUES ('10','system','digg','digg.php?channelid={channelid}&model={model}&type={type}&page={page}','0','digg-{channelid}-{model}-{type}-{page}.html','[Ŀ]Digg(ע)аmodel(article:Ĭ,imageͼƬ,download)type(day,week,month,year,all)','1','50');
INSERT INTO `excms_url` VALUES ('11','system','tag','tag.php?cid={cid}&initial={initial}&page={page}','0','tag-{cid}-{initial}-{page}.html','Tagǩ','1','50');
INSERT INTO `excms_url` VALUES ('12','system','tag_channel','tag.php?channelid={channelid}&crossid={crossid}&cid={cid}&page={page}','0','tag-{channelid}-{page}.html','ĿTagǩ','1','50');
INSERT INTO `excms_url` VALUES ('13','system','tag_name','tag.php?name={tagname}&page={page}','0','tag-{tagname}-{page}.html','ĿTagǩ','1','50');
INSERT INTO `excms_url` VALUES ('14','system','rss','apps/rss.php','0','rss.html','Rss','1','50');
INSERT INTO `excms_url` VALUES ('15','system','rss_channel','apps/rss.php?channelid={channelid}&crossid={crossid}&html={html}','0','rss-{channelid}-{html}.xml','ĿRSSԴ','1','50');
INSERT INTO `excms_url` VALUES ('16','system','sitemap','sitemap.html','0','sitemap.html','վͼ','1','50');
INSERT INTO `excms_url` VALUES ('17','system','components','widgets','0','widgets','ǰ̨Ŀ¼URL','1','50');
INSERT INTO `excms_url` VALUES ('18','system','page404','404.php','0','404.html','404ҳ','1','50');
INSERT INTO `excms_url` VALUES ('19','system','verifycode','apps/verifycode.php','0','apps/verifycode','֤','1','50');
INSERT INTO `excms_url` VALUES ('20','search','index','search.php','0','search','','1','50');
INSERT INTO `excms_url` VALUES ('21','search','query','search.php','0','search','ѯ','1','50');
INSERT INTO `excms_url` VALUES ('22','search','advanced','search.php?adv=1','0','adv_search','߼','1','50');
INSERT INTO `excms_url` VALUES ('23','search','so','apps/search.php','0','apps/search.html','Զֶ','1','50');
INSERT INTO `excms_url` VALUES ('24','comment','index','comment.php','0','http://comment.excms/comment.php','۳','1','50');
INSERT INTO `excms_url` VALUES ('25','comment','rank','comment.php?type=rank&rank={rank}','0','comment-rank-{rank}.html',',rank: day()week(ܣĬ)month()year()all()','1','50');
INSERT INTO `excms_url` VALUES ('26','comment','wonderful','comment.php?type=wonderful&page={page}','0','comment-wonderful-{page}.html','','1','50');
INSERT INTO `excms_url` VALUES ('27','comment','recommend','comment.php?type=recommend&page={page}','0','comment-recommend-{page}.html','Ƽ','1','50');
INSERT INTO `excms_url` VALUES ('28','comment','content','comment.php?contentid={contentid}&page={page}','0','http://comment.excms/comment.php?contentid={contentid}&page={page}','','1','50');
INSERT INTO `excms_url` VALUES ('29','comment','content_hot','comment.php?type=hot&contentid={contentid}&page={page}','0','comment-hot-{contentid}-{page}.html','ȵ','1','50');
INSERT INTO `excms_url` VALUES ('30','comment','content_support','comment.php?type=support&contentid={contentid}&page={page}','0','comment-support-{contentid}-{page}.html','֧','1','50');
INSERT INTO `excms_url` VALUES ('31','comment','content_against','comment.php?type=against&contentid={contentid}&page={page}','0','comment-against-{contentid}-{page}.html','෴','1','50');
INSERT INTO `excms_url` VALUES ('32','comment','single','comment.php?commentid={commentid}','0','comment-single-{commentid}.html','ȫ','1','50');
INSERT INTO `excms_url` VALUES ('33','click','action','apps/click.php?act={act}&contentid={contentid}&js={js}','0','apps/click-{act}-{contentid}-{js}','','1','50');
INSERT INTO `excms_url` VALUES ('34','download','action','apps/download.php?link={link}','0','apps/download?{link}','ض','1','50');
INSERT INTO `excms_url` VALUES ('35','download','type','channel.php?type={type}&channelid={channelid}&crossid={crossid}&page={page}','0','channel-{type}-{channelid}-{crossid}-{page}.html','ͣfree()share()','1','50');
INSERT INTO `excms_url` VALUES ('36','download','orderby','channel.php?orderby={orderby}&channelid={channelid}&crossid={crossid}&page={page}','0','channel-{orderby}-{channelid}-{crossid}-{page}.html','time(ʱ䣬Ĭ)hot()digg()','1','50');
INSERT INTO `excms_url` VALUES ('37','download','download','apps/download.php?link={link}&contentid={contentid}','0','apps/download?link={link}&contentid={contentid}','صַ','1','50');
INSERT INTO `excms_url` VALUES ('38','link','index','link.html','0','link.html','ҳ','1','50');
INSERT INTO `excms_url` VALUES ('39','link','action','apps/link.php','0','apps/link.php','Ӷ','1','50');
INSERT INTO `excms_url` VALUES ('40','account','home','account/index.php','0','account','ûҳ','1','50');
INSERT INTO `excms_url` VALUES ('41','account','login','account/login.php?forward={forward}','0','account/login.html?forward={forward}','û¼','1','50');
INSERT INTO `excms_url` VALUES ('42','account','register','account/register.php','0','account/register.html','ûע','1','50');
INSERT INTO `excms_url` VALUES ('43','account','profile','account/profile.php?type={type}','0','account/profile-{type}.html','ҵʻ','1','50');
INSERT INTO `excms_url` VALUES ('44','account','content','account/content.php?model={model}&channelid={channelid}&crossid={crossid}&check={check}&k={k}&page={page}','0','account/content.html?model={model}&channelid={channelid}&crossid={crossid}&check={check}&k={k}&page={page}','ҵͶ','1','50');
INSERT INTO `excms_url` VALUES ('45','account','favorite','account/favorite.php?categoryid={categoryid}','0','account/favorite.html?categoryid={categoryid}','ҵղ','1','50');
INSERT INTO `excms_url` VALUES ('46','account','rank','account/rank.php?type={type}','0','account/rank.html?type={type}','а','1','50');
INSERT INTO `excms_url` VALUES ('47','account','help','account/help.php','0','account/help.html','','1','50');
INSERT INTO `excms_url` VALUES ('48','account','logout','account/login.php?action=logout','0','account/logout.html','ע','1','50');
INSERT INTO `excms_url` VALUES ('49','account','verifycode','account/verifycode.php?size={width}x{height}x{length}&type={type}','0','account/verifycode.jpg?size={width}x{height}x{length}&type={type}','ûģ֤','1','50');
INSERT INTO `excms_url` VALUES ('50','account','contribute','account/content.php?action=edit&model={model}&contentid={contentid}','0','account/content.html?action=edit&model={model}&contentid={contentid}','ûͶurl','1','50');
INSERT INTO `excms_url` VALUES ('51','account','recover','account/recover.php?id={id}&code={code}','0','account/recove.html?id={id}&code={code}','һ','1','50');
INSERT INTO `excms_url` VALUES ('52','account','islogin','account/login.php?action=islogin','0','account/islogin.html','жûǷ¼JSONֵ','1','50');
INSERT INTO `excms_url` VALUES ('53','account','favorite_new','account/favorite.php?action=new','0','account/favorite.html?action=new','½ղ','1','50');
INSERT INTO `excms_url` VALUES ('54','account','path','account/','0','account/','ʻĸĿ¼','1','50');
INSERT INTO `excms_url` VALUES ('55','account','preview','account/content.php?action=preview&contentid={contentid}','0','account/content.html?action=preview&contentid={contentid}','ûԤͶ','1','50');
INSERT INTO `excms_url` VALUES ('56','account','avatar_path','account/avatars/','0','account/avatars/','ûͷ·','1','50');
INSERT INTO `excms_url` VALUES ('57','account','friend','account/friend.php?groupid={groupid}&action={action}','0','account/friend.html?groupid={groupid}&action={action}','ҵĺ','1','50');
INSERT INTO `excms_url` VALUES ('58','account','message','account/message.php?action={action}&read={read}&page={page}&friend={friend}','0','account/message.html?action={action}&read={read}&page={page}&friend={friend}','Ϣ','1','50');
INSERT INTO `excms_url` VALUES ('59','account','guestbook','account/guestbook.php?page={page}','0','account/guestbook.html?page={page}','ҵ','1','50');
INSERT INTO `excms_url` VALUES ('60','account','view_message','account/message.php?action={action}&messageid={messageid}','0','account/message.html?action={action}&messageid={messageid}','鿴Ϣ','1','50');
INSERT INTO `excms_url` VALUES ('61','account','view_info','account/message.php?action={action}&uid={uid}','0','account/message.html?action={action}&uid={uid}','鿴ûĸϢ','1','50');
INSERT INTO `excms_url` VALUES ('62','account','mail','account/mail.php','0','account/mail.html','ûʼ','1','50');
INSERT INTO `excms_url` VALUES ('63','mood','action','mood/action.php?method={method}','0','','','1','50');
INSERT INTO `excms_url` VALUES ('64','mood','index','mood/index.php?channelid={channelid}','0','mood/{channelalias}.html','ҳ','1','50');
INSERT INTO `excms_url` VALUES ('65','mood','path','mood','0','mood','ģ·','1','50');




