<?php
/*
	[SueamCMS] (C)2009-2010 ZMRNet Studio
	sueam_vdb.php by 2009-12-25 zmrnet
*/
class sueam_vdb{
	var $ext = '.vdb';
	var $dir = 'data/';
	var $fdb = 'sueam';
	var $dat = array();
	var $txt = '';
	
	function connect($fdb = 'sueam'){
		$this->fdb = $fdb;
		$fn = $this->dir . $fdb . $this->ext;
		if(!is_file($fn)){
			$fn = dirname(__FILE__).'/../'.$fn;
		}
		$fs = new sueam_vfs();
		$fd = $fs->fread($fn);
		unset($fs);
		
		preg_match('/<sueam:text>(.*?)<\/sueam:text>/is', $fd, $matchs);
		$this->txt = $matchs[1];
		
		preg_match('/<sueam:data><!--(.*?)--><\/sueam:data>/is', $fd, $matchs);
		$dat = unserialize(base64_decode($matchs[1]));
		if(is_array($dat)){
			$this->dat = $dat;
		}
		return $this->dat;
	}
	function update($dat, $txt = false){
		$this->dat = $dat;
		if(false!==$txt){
			$this->txt = $txt;
		}
	}
	function save($dat = null){
		if(empty($dat)){
			$dat = $this->dat;
		}
		if($this->ext=='.vdb'){
			$fn = $this->dir . $this->fdb . $this->ext;
			$fd = base64_encode(serialize($dat));
			$fd = '<sueam:data><!--'.$fd.'--></sueam:data>';
			$fs = new sueam_vfs();
			$fw = $fs->fwrite($fn, $fd);
			unset($fs);
			return $fw;
		}
		return false;
	}
	function close(){
		$this->ext = '.vdb';
		$this->dir = 'data/';
		$this->fdb = 'sueam';
		$this->dat = array();
		$this->txt = '';
	}
	function clear(){
		$this->dat = array();
		$this->txt = '';
	}
	
	function open($fdb = 'index'){
		$this->ext = '.html';
		$this->dir = '../';
		$this->clear();
		$dat = $this->connect($fdb);
		if(is_array($dat)){
			$this->dat = $dat;
		}
		return $this->dat;
	}
	function write($dat = null){
		if(empty($dat)){
			$dat = $this->dat;
		}
		if($this->ext=='.html'){
			$fn = $this->dir . $this->fdb . $this->ext;
			$ta = explode('/', substr($fn, 0, -5));
			if(count($ta)>3){
				$tn = $ta[1].'_'.$ta[2];
			}else{
				$tn = $ta[1];
			}
			$tpl = new sueam_tpl();
			$tpl->load($tn);
			$tpl->dat = array_merge($tpl->dat,$this->dat);
			$tpl->dat['site_skin'] = '{$site_dir}skin/{$site_tpl}/';
			$tpl->dat['this_info'] = '<sueam:text>'.stripslashes($this->txt).'</sueam:text>';
			$tpl->dat['sueam_data'] = base64_encode(serialize($dat));
			$tpl->save($fn);
			unset($tpl);
			return $this->fdb;
		}
		return false;
	}
	
	function opendir($dir = ''){
		$this->ext = '.html';
		$this->dir = '../';
		$this->dat = array();
		$vdb = new sueam_vdb();
		$tdir = $this->dir . $dir . '/';
		$dh = @opendir($tdir);
		while($file=@readdir($dh)){
			if(is_file($tdir.$file)){
				if(substr($file,-5)=='.html'){
					$file = substr($file, 0 , -5);
					$vdb->open($dir.'/'.$file);
					$lst = $vdb->dat['this_list'];
					if(is_array($lst)){
						$this->dat = array_merge($this->dat, $lst);
					}
				}
			}
		}
		@closedir($dh);
		unset($vdb);
		return $this->dat;
	}
	function writedir($dir = '', $lst = null){
		$res = array();
		$this->ext = '.html';
		$this->dir = '../';
		$this->dat = array();
		
		$vdb = new sueam_vdb();
		$_VDB = $vdb->connect();
		$adir = explode('/', $dir);
		$this_dir = $adir[0];
		$this_type = $_VDB['art'][$this_dir];
		$page_size = page_size;
		if(!isset($this_type)){
			$this_type = $_VDB['bbs'][$this_dir];
			$page_size = post_size;
		}
		
		if(substr($dir,-5)=='/list'){
			if(!is_array($lst)){
				$lst = $vdb->opendir($dir);
			}
			$plst = array_chunk($lst, $page_size);
			$pcnt = count($plst);
			for($i=0;$i<$pcnt;$i++){
				$page = $i + 1;
				$this_list = $plst[$i];
				array_push($res, $dir.'/'.$page);
				$vdb->open($dir.'/'.$page);
				$vdb->dat['this_type']	= $this_type;
				$vdb->dat['this_dir']	= $this_dir;
				$vdb->dat['this_page']	= $page;
				$vdb->dat['show_page']	= showpage($page, $pcnt);
				$vdb->dat['this_list']	= $this_list;
				$vdb->write();
			}
			$fs = new sueam_vfs();
			$fs->delfile($this->dir.$dir);
			unset($fs);
			unset($plst);
			return $res;
		}else{
			$adir = explode('/', $dir);
			$this_dir = $adir[0];
			$tdir = $this->dir . $dir . '/';
			$dh = @opendir($tdir);
			while($file=@readdir($dh)){
				if(is_file($tdir.$file)){
					if(substr($file,-5)=='.html'){
						$file = substr($file, 0 , -5);
						array_push($res, $dir.'/'.$file);
						$this->open($dir.'/'.$file);
						if($this_type){
							$this->dat['this_type'] = $this_type;
							$this->dat['this_dir'] = $this_dir;
							$vdb->dat['this_page']	= 1;
						}
						$this->write();
					}
				}
			}
			@closedir($dh);
			return $res;
		}
		
		unset($_VDB);
		unset($vdb);
		
		return false;
	}
	
	function encrypt($data, $key){
		$cipher = '';
		$dlen = strlen($data);
		$klen = strlen($key);
		if(!$dlen||!$klen)return $cipher;
		for($i=0,$j=0;$i<$dlen;$i++,$j++){
			if($j>=$klen)$j -= $klen;
			$d = ord($data[$i])-32;
			$k = ord($key[$j])-32;
			$c = $d + $k;
			if($c>=95)$c-=95;
			$cipher .= chr($c+32);
		}
		return $cipher;
	}
	function decrypt($cipher, $key){
		$data = '';
		$clen = strlen($cipher);
		$klen = strlen($key);
		if(!$clen||!$klen)return $data;
		for($i=0,$j=0;$i<$clen;$i++,$j++){
			if($j>=$klen)$j -= $klen;
			$c = ord($cipher[$i])-32;
			$k = ord($key[$j])-32;
			$d = $c - $k;
			if($d<0)$d+=95;
			$data .= chr($d+32);
		}
		return $data;
	}
}
?>