<?php
/**
 * The template for displaying Comments.
 *
 * The area of the page that contains both current comments
 * and the comment form. The actual display of comments is
 * handled by a callback to twentyeleven_comment() which is
 * located in the functions.php file.
 *
 * @package WordPress
 * @subpackage Twenty_Eleven
 * @since Twenty Eleven 1.0
 */
?>
	<div id="comments">
	<?php if ( post_password_required() ) : ?>
		<p class="nopassword"><?php _e( 'This post is password protected. Enter the password to view any comments.', 'zipe' ); ?></p>
	</div><!-- #comments -->
	<?php
			/* Stop the rest of comments.php from being processed,
			 * but don't kill the script entirely -- we still have
			 * to fully load the template.
			 */
			return;
		endif;
	?>

	<?php // You can start editing here -- including this comment! ?>

<?php if ( comments_open() ) : ?>
		<div id="respond">
			<h3><?php comment_form_title(); ?></h3>
			<?php cancel_comment_reply_link() ?>
	<?php if ( get_option('comment_registration') && !is_user_logged_in() ) : ?>
			<p class="must-log-in"><?php printf( __( 'You must be <a href="%s">logged in</a> to post a comment.', 'zipe' ), wp_login_url(get_permalink() ) ); ?></p>
	<?php else : ?>
			<form action="<?php echo get_option('siteurl'); ?>/wp-comments-post.php" method="post" id="commentform">
				<?php comment_id_fields(); ?>
		<?php if ( is_user_logged_in() ) : ?>
				<p class="logged-in-as"><?php printf( str_replace('<br />', ' ', __( '<a href="%1$s">%2$s</a><br />(<a href="%3$s" title="Log out of this account">Logout</a>)', 'zipe' )), admin_url( 'profile.php' ), $user_identity, wp_logout_url( get_permalink() ) ); ?></p>
		<?php else : ?>
				<p class="comment-form-author">
					<input id="author" name="author" type="text" value="<?php echo $comment_author; ?>" size="30" placeholder="<?php _e('Name', 'zipe'); ?>(*)" required>
				</p>
				<p class="comment-form-email">
					<input id="email" name="email" type="email" value="<?php echo $comment_author_email; ?>" size="30" placeholder="<?php _e('Email', 'zipe'); ?>(*)" required>
				</p>
				<p class="comment-form-url">
					<input id="url" name="url" type="text" value="<?php echo $comment_author_url; ?>" size="30" placeholder="<?php _e('Website', 'zipe'); ?>" >
				</p>
		<?php endif; ?>
				<p class="comment-form-comment"><textarea id="comment" name="comment" cols="45" rows="5" placeholder="<?php _e('Type your comment here.', 'zipe'); ?>" required></textarea></p>
				<input name="submit" type="submit" id="submit" value="<?php _e( 'Post Comment', 'zipe' ); ?>">
				<?php do_action('comment_form', $post->ID); ?>
			</form>
	<?php endif; ?>
		</div>
		<h3 id="comments-title">
			<?php comments_number('0条评论', '1条评论', '% 条评论'); ?>
		</h3>
<?php elseif ( ! comments_open() && ! is_page() && post_type_supports( get_post_type(), 'comments' ) && ! have_comments() ) : ?>
		<p class="nocomments"><?php _e( 'Comments are closed.', 'zipe' ); ?></p>
<?php endif; ?>

<?php if ( have_comments() ) : ?>
	<ol id="commentlist" class="commentlist">
		<?php wp_list_comments( array( 'callback' => 'zipe_comment' ) ); ?>
	</ol>

	<?php if ( get_comment_pages_count() > 1 && get_option( 'page_comments' ) ) : // are there comments to navigate through ?>
		<nav id="nav-below">
			<div class="nav-previous"><?php previous_comments_link(); ?></div>
			<div class="nav-next"><?php next_comments_link(); ?></div>
		</nav>
	<?php endif; // check for comment navigation ?>
<?php endif; ?>

</div><!-- #comments -->