<?php
load_theme_textdomain('zipe', get_template_directory() . '/languages');
register_nav_menu( 'primary', __('Navigation Menu', 'zipe') );


function get_first_image() {
      global $post;
      $first_img = '';
      ob_start();
      ob_end_clean();
      $output = preg_match_all('/<img.+src=[\'"]([^\'"]+)[\'"].*>/i', $post->post_content, $matches);
      $first_img = $matches [1] [0];
      if(empty($first_img)){ //Defines a default image
        $first_img = bloginfo('template_url') . "/images/default.jpg";
      };
      return $first_img;
}

if ( ! function_exists( 'zipe_comment' ) ) :
function zipe_comment( $comment, $args, $depth ) {
	$GLOBALS['comment'] = $comment;
	switch ( $comment->comment_type ) :
		case 'pingback' :
		case 'trackback' :
	?>
	<li class="post pingback">
		<p><?php _e( 'Pingback: ', 'zipe' ); ?><?php comment_author_link(); ?></p>
	<?php
			break;
		default :
	?>
	<li <?php comment_class(); ?> id="li-comment-<?php comment_ID(); ?>">
		<div id="comment-<?php comment_ID(); ?>" class="comment-wrapper">
			<div class="comment-meta">
				<div class="comment-author vcard">
					<?php echo get_avatar( $comment, 36 ); ?>
					<?php comment_author_link(); ?>
					<?php if ( $comment->comment_approved == '0' ) : ?>
						<em class="comment-awaiting-moderation" title="<?php comment_time('Y-n-j H:i') ?>"><?php _e( 'Your comment is awaiting moderation.', 'zipe' ); ?></em>
					<?php else : ?>
						<time pubdate datetime="<?php comment_date() ?>">
						<?php
						if ( current_time('timestamp') - get_comment_time('U') < 2592000 ) {
							echo human_time_diff( get_comment_time('U'), current_time('timestamp') ) . __( ' ago', 'zipe' );
						} else {
							echo comment_time('Y-n-j H:i');
						}
						?>
						</time>
					<?php endif; ?>
				</div><!-- .comment-author .vcard -->
			</div>

			<div class="comment-content"><?php comment_text(); ?></div>

			<?php if ( $comment->comment_approved != '0' && $args != null&&$depth != null) : ?>
			<div class="reply">
				<?php comment_reply_link( array_merge( $args, array( 'depth' => $depth, 'max_depth' => $args['max_depth'] ) ) ); ?>
				<?php if(function_exists('mailtocommenter_button')) mailtocommenter_button();?>
			</div><!-- .reply -->
			<?php endif; ?>
		</div><!-- #comment-## -->

	<?php
			break;
	endswitch;
}
endif;

add_filter('the_content','web589_the_content_nofollow',999);
function web589_the_content_nofollow($content){
	preg_match_all('/href="(.*?)"/',$content,$matches);
	if($matches){
		foreach($matches[1] as $val){
			if( strpos($val,home_url())===false ) $content=str_replace("href=\"$val\"", "href=\"$val\" rel=\"external nofollow\" ",$content);
		}
	}
	return $content;
}
